/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.designer;

import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.extreport.manage.model.ExtReportGroupVO;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.framework.ksql.model.KsqlParamValue;
import com.kingdee.bos.framework.ksql.model.KsqlRowset;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.systemvar.SystemVarType;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.dbmanage.exception.DBManageException;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.report.ds.dto.DesignerVOTransferModel;
import com.kingdee.bos.report.ds.dto.DesignerVOTransferSegment;
import com.kingdee.bos.report.ds.vo.DesignerVO;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.mservice.extreport.dataset.exception.DataSetException;
import kd.bos.mservice.extreport.dataset.model.entity.EntityHelper;
import kd.bos.mservice.extreport.designer.SysVarService;
import kd.bos.mservice.extreport.designer.domain.DataSetDesignerDomain;
import kd.bos.mservice.extreport.designer.exception.AssembleResultSetException;
import kd.bos.mservice.extreport.designer.var.SystemVar;
import kd.bos.mservice.extreport.designer.var.VarAdapter;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportGroupDaoImpl;
import kd.bos.mservice.extreport.manage.domain.DataSetManageDomain;
import kd.bos.mservice.extreport.manage.exception.ExtReportManagementException;
import kd.bos.mservice.extreport.manage.model.DataSetVO;
import kd.bos.mservice.extreport.runtime.domain.PageManager;
import kd.bos.mservice.extreport.util.DataSetExecuteChecker;
import kd.bos.mservice.qing.util.AppUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DataSetDesignerService
implements IQingContextable,
IDBAccessable {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private DataSetManageDomain dataSetManageDomain;
    private DataSetDesignerDomain dataSetDesignerDomain;
    private ExtReportGroupDaoImpl extReportGroupDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public DataSetManageDomain getDataSetManageDomain() {
        if (this.dataSetManageDomain == null) {
            this.dataSetManageDomain = new DataSetManageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dataSetManageDomain;
    }

    public DataSetDesignerDomain getDataSetDesignerDomain() {
        if (this.dataSetDesignerDomain == null) {
            this.dataSetDesignerDomain = new DataSetDesignerDomain();
            this.dataSetDesignerDomain.setDbExcuter(this.dbExcuter);
            this.dataSetDesignerDomain.setTx(this.tx);
            this.dataSetDesignerDomain.setQingContext(this.qingContext);
        }
        return this.dataSetDesignerDomain;
    }

    public ExtReportGroupDaoImpl getExtReportGroupDaoImpl() {
        if (this.extReportGroupDao == null) {
            this.extReportGroupDao = new ExtReportGroupDaoImpl(this.dbExcuter);
        }
        return this.extReportGroupDao;
    }

    public Date getServerDate(String dateValue) {
        return new Date();
    }

    public String saveOrUpdate(DesignerVO designerVo) throws ExtReportManagementException, AbstractQingIntegratedException {
        String id = (String)designerVo.getFieldContent("fid");
        String name = (String)designerVo.getFieldContent("fname");
        String groupId = (String)designerVo.getFieldContent("ffoldermetaid");
        String type = (String)designerVo.getFieldContent("ftype");
        byte[] content = (byte[])designerVo.getFieldContent("fdatasourcecontent");
        ExtReportVO extReportVO = new ExtReportVO();
        extReportVO.setExtReportID(id);
        extReportVO.setExtReportName(name);
        extReportVO.setExtReportGroupID(groupId);
        extReportVO.setDataSetType(type);
        try {
            DataSetVO oldDataSetVO = this.getDataSetManageDomain().loadDataSet(id);
            if (oldDataSetVO != null) {
                extReportVO.setDescription(oldDataSetVO.getDescription());
            }
        }
        catch (SQLException e) {
            throw new ExtReportManagementException((Throwable)e);
        }
        this.getDataSetManageDomain().saveOrUpdateOld(extReportVO, content, this.qingContext.getUserId());
        return extReportVO.getExtReportID();
    }

    public DesignerVO findDataSource(String dataSetID) throws AbstractQingIntegratedException, SQLException, IOException {
        DesignerVO designerVO = null;
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetID);
        if (dataSetVO != null) {
            designerVO = this.loadDataSet(dataSetVO);
        }
        return designerVO;
    }

    public DesignerVO findDataSource(String groupID, String groupName, String dataSourceID, String dbsourcename, String userID) throws Exception, SQLException {
        DesignerVO designerVO = null;
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(groupID, groupName, dataSourceID, dbsourcename, userID);
        if (dataSetVO != null) {
            designerVO = this.loadDataSet(dataSetVO);
        }
        return designerVO;
    }

    private DesignerVO loadDataSet(DataSetVO dataSetVO) throws AbstractQingIntegratedException, SQLException, IOException {
        DesignerVO designerVO = new DesignerVO(1);
        designerVO.addColumn("fid", (Object)dataSetVO.getDataSetID());
        designerVO.addColumn("fname", (Object)dataSetVO.getDataSetName());
        designerVO.addColumn("ftype", (Object)dataSetVO.getType());
        byte[] content = this.loadDataSetContent(dataSetVO.getDataSetID());
        if (content == null) {
            content = new byte[]{};
        }
        designerVO.addColumn("fdatasourcecontent", (Object)content, -2);
        String groupName = this.getExtReportGroupDaoImpl().loadExtReportGroupFullPathById(dataSetVO.getDataSetGroupID());
        if (StringUtils.isNotEmpty((CharSequence)groupName)) {
            designerVO.addColumn("groupName", (Object)groupName);
        }
        designerVO.addColumn("systemID", (Object)dataSetVO.getDataSetGroupID());
        return designerVO;
    }

    private byte[] loadDataSetContent(String dataSetID) throws AbstractQingIntegratedException, SQLException, IOException {
        if (PageManager.refreshDataSet.get() == null) {
            return this.getDataSetDesignerDomain().loadDataSetContent(dataSetID);
        }
        if (Boolean.TRUE.equals(PageManager.refreshDataSet.get())) {
            byte[] content = this.getDataSetDesignerDomain().loadDataSetContent(dataSetID);
            PageManager.cacheDataSetContent((String)dataSetID, (byte[])content);
            return content;
        }
        byte[] dataSetContent = PageManager.getDataSetContent((String)dataSetID);
        if (dataSetContent == null) {
            return this.getDataSetDesignerDomain().loadDataSetContent(dataSetID);
        }
        return dataSetContent;
    }

    public List<DesignerVO> getOutDBList() throws AbstractQingIntegratedException, SQLException {
        return this.getDataSetDesignerDomain().getOutDBList();
    }

    public List<String> getSuperQuerySchemas() throws AbstractQingIntegratedException, AbstractSourceException {
        return this.getDataSetDesignerDomain().getSuperQuerySchemas();
    }

    public DesignerVO getOutDBByDBName(String dbname) throws AbstractQingIntegratedException, IOException, ModelParseException, XmlParsingException {
        return this.getDataSetDesignerDomain().getOutDBInfoByName(dbname);
    }

    public int checkDataSourceTouchable(String userId, String dbName) throws AbstractQingIntegratedException, SQLException {
        return this.getDataSetDesignerDomain().checkDataSourceTouchable(userId, dbName);
    }

    public String loadExtReportGroupFullPathById(String groupId) throws AbstractQingIntegratedException, SQLException {
        return this.getExtReportGroupDaoImpl().loadExtReportGroupFullPathById(groupId);
    }

    public String loadDataSetCreatorIdById(String dataSetID) throws AbstractQingIntegratedException, SQLException {
        if ("0".equals(dataSetID)) {
            return this.qingContext.getUserId();
        }
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetID);
        if (dataSetVO != null) {
            return dataSetVO.getCreatorId();
        }
        return null;
    }

    public String loadCreatorNameById(String creatorId) throws AbstractQingIntegratedException {
        return IntegratedHelper.getUserName((String)creatorId);
    }

    public DesignerVOTransferModel executeQuery(DesignerVO designerVO) throws Exception {
        return this.getDataSetDesignerDomain().executeQuery(designerVO);
    }

    public DesignerVOTransferModel executeOQLQuery(DesignerVO designerVO) throws AbstractQingIntegratedException, SQLException, AssembleResultSetException {
        return this.getDataSetDesignerDomain().executeOQLQuery(designerVO);
    }

    public DesignerVOTransferSegment fetchTransferSegment(DesignerVO designerVO) {
        return this.getDataSetDesignerDomain().fetchTransferSegment(designerVO);
    }

    public KsqlRowset callProcedure(DesignerVO designerVO, int max, List<KsqlParamValue> paramValues) throws UnSupportDataSourceException, AbstractQingIntegratedException, DBManageException, SQLException {
        return this.getDataSetDesignerDomain().callProcedure(designerVO, max, paramValues);
    }

    public List<DesignerVO> getSubSystemTree() throws AbstractQingIntegratedException, SQLException {
        ArrayList<DesignerVO> result = new ArrayList<DesignerVO>(10);
        String userID = this.qingContext.getUserId();
        DesignerVO designerVO = new DesignerVO(3);
        designerVO.addColumn("uuid", (Object)"root");
        designerVO.addColumn("name", (Object)"QingRpt");
        designerVO.addColumn("isLeaf", (Object)"false");
        List groupVOs = this.getExtReportGroupDaoImpl().listExtReportGroup(userID);
        this.convertList2Tree(groupVOs, designerVO);
        result.add(designerVO);
        return result;
    }

    public void convertList2Tree(List<ExtReportGroupVO> groupVOs, DesignerVO designerVO) {
        ArrayList<DesignerVO> children = new ArrayList<DesignerVO>(10);
        ArrayList<ExtReportGroupVO> parentReportGroupVOs = new ArrayList<ExtReportGroupVO>();
        HashMap<String, ExtReportGroupVO> categoryMap = new HashMap<String, ExtReportGroupVO>(32);
        for (ExtReportGroupVO extReportGroupVO : groupVOs) {
            categoryMap.put(extReportGroupVO.getExtReportGroupID(), extReportGroupVO);
        }
        for (ExtReportGroupVO extReportGroupVO : groupVOs) {
            String parentID = extReportGroupVO.getParentID();
            if (StringUtils.isNotEmpty((CharSequence)parentID)) {
                ExtReportGroupVO parent = (ExtReportGroupVO)categoryMap.get(parentID);
                if (null == parent) continue;
                parent.addChild(extReportGroupVO);
                continue;
            }
            parentReportGroupVOs.add(extReportGroupVO);
        }
        this.handleTreeNode(parentReportGroupVOs, children, designerVO);
    }

    public void handleTreeNode(List<ExtReportGroupVO> parentReportGroupVOs, List<DesignerVO> children, DesignerVO designerVO) {
        for (ExtReportGroupVO groupVO : parentReportGroupVOs) {
            DesignerVO child = new DesignerVO(3);
            child.addColumn("uuid", (Object)groupVO.getExtReportGroupID());
            child.addColumn("name", (Object)groupVO.getExtReportGroupName());
            child.addColumn("isLeaf", (Object)"true");
            children.add(child);
            if (groupVO.getChildren() == null || groupVO.getChildren().size() <= 0) continue;
            ArrayList<DesignerVO> oChildren = new ArrayList<DesignerVO>(10);
            this.handleTreeNode(groupVO.getChildren(), oChildren, child);
        }
        designerVO.addColumn("children", children);
    }

    public List<DesignerVO> getSubSystemPresetTree() throws AbstractQingIntegratedException, SQLException {
        ArrayList<DesignerVO> result = new ArrayList<DesignerVO>(10);
        DesignerVO designerVO = new DesignerVO(3);
        designerVO.addColumn("uuid", (Object)"root");
        designerVO.addColumn("name", (Object)"QingRpt");
        designerVO.addColumn("isLeaf", (Object)"false");
        List groupVOs = this.getExtReportGroupDaoImpl().listPresetExtReportGroup();
        this.convertList2Tree(groupVOs, designerVO);
        result.add(designerVO);
        return result;
    }

    public List<DesignerVO> findSystemParameters() {
        ArrayList<DesignerVO> result = new ArrayList<DesignerVO>(VarAdapter.getSystemVars().length);
        for (SystemVar systemVar : VarAdapter.getSystemVars()) {
            SystemVarType systemVarType = systemVar.getSystemVarType();
            DesignerVO designerVO = new DesignerVO(-1);
            designerVO.addColumn("key", (Object)systemVar.getName());
            designerVO.addColumn("name", (Object)systemVar.getName());
            designerVO.addColumn("alias", (Object)systemVar.getAlias());
            String value = null;
            if (systemVarType.isCollectionType()) {
                Collection values = (Collection)this.qingContext.getSystemVar(systemVarType);
                value = SysVarService.parseCollectionToString((Collection)values);
            } else {
                value = this.qingContext.getSystemVarStringValue(systemVarType);
            }
            designerVO.addColumn("value", (Object)value);
            result.add(designerVO);
        }
        return result;
    }

    public List<DesignerVO> findUserOrgScopeInfo() {
        Collection values = (Collection)this.qingContext.getSystemVar(SystemVarType.BIZ_UNIT_ORGRANG_ID);
        QFilter filter = new QFilter("id", "in", (Object)values);
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number,name,parent.id", (QFilter[])new QFilter[]{filter});
        ArrayList<DesignerVO> queryList = new ArrayList<DesignerVO>(result.size());
        DesignerVO designerVO = new DesignerVO(-1);
        designerVO.addColumn("id", (Object)"id");
        designerVO.addColumn("number", (Object)"number");
        designerVO.addColumn("name", (Object)"name");
        designerVO.addColumn("parentid", (Object)"parentid");
        queryList.add(designerVO);
        for (Map.Entry entry : result.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            designerVO = new DesignerVO(4);
            designerVO.addColumn("id", (Object)value.getString("id"));
            designerVO.addColumn("number", (Object)value.getString("number"));
            designerVO.addColumn("name", (Object)value.getString("name"));
            designerVO.addColumn("parentid", (Object)value.getString("parent.id"));
            queryList.add(designerVO);
        }
        return queryList;
    }

    public boolean checkDBCenterPermission() {
        return this.getDataSetDesignerDomain().checkDBCenterPermission();
    }

    public boolean checkDBCenterPermissionByUserId(String userId) {
        return this.getDataSetDesignerDomain().checkDBCenterPermissionByUserId(userId);
    }

    public boolean checkDataSetIsPreset(String dataSetId) {
        return this.getDataSetDesignerDomain().checkDataSetIsPreset(dataSetId);
    }

    public boolean checkPresetManagePermission() {
        return this.getDataSetDesignerDomain().checkPresetManagePermission();
    }

    public int checkEntityPermissionByUserId(String creatorId, String entityName) {
        boolean isSupportQing;
        boolean hasPermission;
        try {
            hasPermission = EntityHelper.hasPermission((long)Long.parseLong(creatorId), (String)entityName);
            isSupportQing = EntityHelper.isSupportQingAnalysis((String)entityName);
        }
        catch (DataSetException e) {
            return 2;
        }
        if (!hasPermission) {
            return 1;
        }
        if (!isSupportQing) {
            return 3;
        }
        return 0;
    }

    public String checkDBCenterAppPerm(String appNumber) {
        try {
            AppUtil.checkAppPerm((String)appNumber);
        }
        catch (AbstractQingException e) {
            return e.getMessage();
        }
        return null;
    }

    public DesignerVO getBizMetaDBInfo(String appNumber) throws DataCenterNoPermissionException {
        return this.getDataSetDesignerDomain().getBizMetaDBInfo(appNumber);
    }

    public boolean checkDataSetExecutableById(String dataSetId) {
        return DataSetExecuteChecker.checkDataSetExecutableById(dataSetId);
    }
}

