/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.manage.dao.impl;

import com.kingdee.bos.extreport.manage.model.ExtReportGroupVO;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.imexport.model.ImExportExtReportVO;
import kd.bos.mservice.extreport.manage.dao.IExtReportDao;
import kd.bos.mservice.extreport.manage.dao.IExtReportGroupDao;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportGroupDaoImpl;
import kd.bos.mservice.extreport.manage.exception.ExtReportNameDuplicateException;
import kd.bos.mservice.extreport.manage.model.ExtReportPO;
import kd.bos.mservice.extreport.manage.model.ExtRptTypeEnum;
import kd.bos.mservice.extreport.manage.util.SqlUtils;

public class ExtReportDaoImpl
implements IExtReportDao {
    private IDBExcuter dbExcuter;
    private IExtReportGroupDao extReportGroupDao;

    public ExtReportDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public IExtReportGroupDao getExtReportGroupDao() {
        if (this.extReportGroupDao == null) {
            this.extReportGroupDao = new ExtReportGroupDaoImpl(this.dbExcuter);
        }
        return this.extReportGroupDao;
    }

    public List<ExtReportVO> listExtReports(List<String> groupIDList, String userID) throws AbstractQingIntegratedException, SQLException {
        String sqlInGroupID = this.getListParamStrInSQL(groupIDList);
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.addAll(groupIDList);
        queryValue.add(userID);
        queryValue.addAll(groupIDList);
        queryValue.add(userID);
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, FEXTRPTTYPE, FDATASETTYPE FROM (  SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, '0' AS FEXTRPTTYPE, '' AS FDATASETTYPE  FROM T_QING_EXTRPT_INFO  WHERE FGROUPID IN (" + sqlInGroupID + ") AND FCREATORID = ?  UNION SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, '' AS FTEMPLATETYPE, FGROUPID, '1' AS FEXTRPTTYPE , FTYPE AS FDATASETTYPE  FROM T_QING_DATASET_INFO  WHERE FGROUPID IN (" + sqlInGroupID + ") AND FCREATORID = ? ) T ORDER BY T.FCREATEDATE DESC ";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private List<ExtReportVO> extReportResultHandle(ResultSet rs) throws SQLException {
        ArrayList<ExtReportVO> voList = new ArrayList<ExtReportVO>(10);
        while (rs.next()) {
            ExtReportVO vo = new ExtReportVO();
            vo.setExtReportID(rs.getString("FID"));
            vo.setExtReportName(rs.getString("FNAME"));
            vo.setDescription(rs.getString("FDESCRIPTION"));
            vo.setExtReportGroupID(rs.getString("FGROUPID"));
            vo.setTemplateType(rs.getString("FTEMPLATETYPE"));
            vo.setCreateTime(Long.valueOf(rs.getTimestamp("FCREATEDATE").getTime()));
            vo.setModifyTime(Long.valueOf(rs.getTimestamp("FMODIFYDATE").getTime()));
            vo.setExtRptType(rs.getString("FEXTRPTTYPE"));
            vo.setDataSetType(rs.getString("FDATASETTYPE"));
            vo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
            voList.add(vo);
        }
        return voList;
    }

    public Map<String, List<ExtReportVO>> loadGroupExtReports(String userID, boolean hasDataSet) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuilder querySql = new StringBuilder();
        querySql.append(" SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, FEXTRPTTYPE, FDATASETTYPE ");
        querySql.append(" FROM (");
        querySql.append(" SELECT G1.FID AS FGROUPID , I1.FID, I1.FNAME, I1.FDESCRIPTION, I1.FCREATORID, I1.FCREATEDATE, I1.FMODIFYDATE, ");
        querySql.append(" I1.FTEMPLATETYPE, '0' AS FEXTRPTTYPE, '' AS FDATASETTYPE ");
        querySql.append(" FROM T_QING_EXTRPT_INFO I1 LEFT JOIN T_QING_EXTRPT_GROUP G1 ON I1.FGROUPID = G1.FID ");
        querySql.append(" WHERE I1.FCREATORID = ? OR I1.FCREATORID = ? ");
        queryValue.add(userID);
        queryValue.add(IntegratedHelper.getPresetUserId());
        if (hasDataSet) {
            querySql.append(" UNION ALL ");
            querySql.append(" SELECT G2.FID AS FGROUPID, I2.FID, I2.FNAME, I2.FDESCRIPTION, I2.FCREATORID, I2.FCREATEDATE, I2.FMODIFYDATE, ");
            querySql.append(" '' AS FTEMPLATETYPE, '1' AS FEXTRPTTYPE, FTYPE AS FDATASETTYPE ");
            querySql.append(" FROM T_QING_DATASET_INFO I2 LEFT JOIN T_QING_EXTRPT_GROUP G2 ON I2.FGROUPID = G2.FID ");
            querySql.append(" WHERE I2.FCREATORID = ? OR I2.FCREATORID = ? ");
            queryValue.add(userID);
            queryValue.add(IntegratedHelper.getPresetUserId());
        }
        querySql.append(" ) T ORDER BY T.FCREATEDATE DESC ");
        return (Map)this.dbExcuter.query(querySql.toString(), queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String saveOrUpdate(ExtReportPO extreportPO, String userID) throws ExtReportNameDuplicateException, AbstractQingIntegratedException, SQLException {
        String extreportID = extreportPO.getExtReportID();
        String groupID = extreportPO.getExtReportGroupID();
        String extreportName = extreportPO.getExtReportName();
        Date updateTime = extreportPO.getUpdateTime();
        String description = extreportPO.getDescription();
        if (this.checkNameExist(extreportID, extreportName, groupID, userID)) {
            String messageContent = MserviceRptMessages.getMLS((String)"duplicateNameExtReportInCategory", (String)"\u5b58\u5728\u540c\u540d\u62a5\u8868\u3002");
            throw new ExtReportNameDuplicateException(messageContent);
        }
        String sql = null;
        ArrayList<Object> params = new ArrayList<Object>();
        if (extreportID == null || extreportID.trim().isEmpty()) {
            sql = "INSERT INTO T_QING_EXTRPT_INFO (FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FGROUPID, FTEMPLATETYPE) VALUES(?,?,?,?,?,?,?,?)";
            extreportID = this.dbExcuter.genStringId("T_QING_EXTRPT_INFO");
            params.add(extreportID);
            params.add(extreportName);
            params.add(description);
            params.add(userID);
            params.add(updateTime);
            params.add(updateTime);
            params.add(groupID);
            params.add(extreportPO.getTemplateType());
        } else {
            sql = "UPDATE T_QING_EXTRPT_INFO SET FNAME = ?, FDESCRIPTION = ? WHERE FID=? AND FGROUPID = ? AND FCREATORID = ?";
            params.add(extreportName);
            params.add(description);
            params.add(extreportID);
            params.add(groupID);
            params.add(userID);
        }
        this.dbExcuter.execute(sql, params.toArray());
        return extreportID;
    }

    public boolean checkNameExist(String extreportID, String extreportName, String groupID, String userID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID FROM T_QING_EXTRPT_INFO WHERE FGROUPID = ? AND FNAME = ? AND FCREATORID = ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{groupID, extreportName, userID}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ExtReportVO loadExtReportByID(String extreportId, String userID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE,  FMODIFYDATE, FGROUPID, FTEMPLATETYPE FROM T_QING_EXTRPT_INFO WHERE FID = ? AND FCREATORID = ? ORDER BY FCREATEDATE DESC";
        return (ExtReportVO)this.dbExcuter.query(sql, new Object[]{extreportId, userID}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ExtReportVO loadExtReportByID(String extreportId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE,  FMODIFYDATE, FGROUPID, FTEMPLATETYPE FROM T_QING_EXTRPT_INFO WHERE FID = ?";
        return (ExtReportVO)this.dbExcuter.query(sql, new Object[]{extreportId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<ExtReportVO> loadExtReportByIDS(Set<String> extreportIds) throws AbstractQingIntegratedException, SQLException {
        if (extreportIds == null || extreportIds.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] ids = extreportIds.toArray();
        String idParams = this.getListParamStrInSQL(extreportIds);
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE,  FMODIFYDATE, FGROUPID, FTEMPLATETYPE FROM T_QING_EXTRPT_INFO WHERE FID IN (" + idParams + ")";
        return (List)this.dbExcuter.query(sql, ids, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteExtReport(String extreportID, String userID) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isNotBlank((CharSequence)extreportID)) {
            String sql = "DELETE FROM T_QING_EXTRPT_INFO WHERE FID = ? AND FCREATORID = ?";
            this.dbExcuter.execute(sql, new Object[]{extreportID, userID});
        }
    }

    public void moveExtReport(ExtReportGroupVO extReportGroupVO, ExtReportPO extreportPO, String userID) throws AbstractQingIntegratedException, SQLException, ExtReportNameDuplicateException {
        String groupID;
        String extreportName;
        String extreportID = extreportPO.getExtReportID();
        if (this.checkNameExist(extreportID, extreportName = extreportPO.getExtReportName(), groupID = extReportGroupVO.getExtReportGroupID(), userID)) {
            String messageContent = MserviceRptMessages.getMLS((String)"duplicateNameExtReportInCategory", (String)"\u5b58\u5728\u540c\u540d\u62a5\u8868\u3002");
            throw new ExtReportNameDuplicateException(messageContent);
        }
        String sql = "UPDATE T_QING_EXTRPT_INFO SET FGROUPID = ? WHERE FID = ? AND FCREATORID = ?";
        this.dbExcuter.execute(sql, new Object[]{groupID, extreportID, userID});
    }

    public ImExportExtReportVO loadExportExtReport(String extReportID, String userID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT T.FID FEXTREPORTID, T.FNAME FEXTREPORTNAME, T.FTEMPLATETYPE, T.FDESCRIPTION,  G.FID FGROUPID, G.FNAME FEXTREPORTGROUPNAME  FROM T_QING_EXTRPT_INFO T  LEFT JOIN T_QING_EXTRPT_GROUP G ON G.FID = T.FGROUPID WHERE T.FID = ? AND T.FCREATORID = ?";
        return (ImExportExtReportVO)this.dbExcuter.query(sql, new Object[]{extReportID, userID}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ExtReportVO loadInfoByNameAndGroupID(String extreportName, String extreportGroupID, String userID) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE,  FMODIFYDATE, FGROUPID FROM T_QING_EXTRPT_INFO WHERE FNAME = ? AND FGROUPID = ? AND FCREATORID = ?";
        return (ExtReportVO)this.dbExcuter.query(sql, new Object[]{extreportName, extreportGroupID, userID}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getListParamStrInSQL(Collection<String> paramList) {
        String sqlInParam = "null";
        if (paramList == null) {
            return sqlInParam;
        }
        StringBuilder sqlInParamBuilder = new StringBuilder();
        sqlInParamBuilder.append("?");
        for (int i = 1; i < paramList.size(); ++i) {
            sqlInParamBuilder.append(",?");
        }
        sqlInParam = sqlInParamBuilder.toString();
        return sqlInParam;
    }

    public String getReportIdByCreatorAndPath(String pathAlias, String creatorId) throws AbstractQingIntegratedException, SQLException {
        String sGroupId = "";
        ExtReportVO extReportVO = null;
        String[] pathAndReportName = StringUtils.split((String)pathAlias, (char)'/');
        StringBuilder fullPath = new StringBuilder();
        String reportName = pathAndReportName[pathAndReportName.length - 1];
        if (pathAndReportName.length >= 3) {
            for (int i = 1; i < pathAndReportName.length - 1; ++i) {
                fullPath.append(pathAndReportName[i]);
                if (i == pathAndReportName.length - 2) continue;
                fullPath.append("/");
            }
        } else {
            fullPath.append(pathAndReportName[0]);
        }
        if ("\u9884\u7f6e\u76ee\u5f55".equals(pathAndReportName[0])) {
            sGroupId = this.getExtReportGroupDao().loadExtReportGroupIdByFullPath(fullPath.toString(), IntegratedHelper.getPresetUserId());
            extReportVO = this.loadInfoByNameAndGroupID(reportName, sGroupId, IntegratedHelper.getPresetUserId());
        } else {
            sGroupId = this.getExtReportGroupDao().loadExtReportGroupIdByFullPath(fullPath.toString(), creatorId);
            extReportVO = this.loadInfoByNameAndGroupID(reportName, sGroupId, creatorId);
        }
        if (null != extReportVO) {
            return extReportVO.getExtReportID();
        }
        return null;
    }

    public ExtReportVO loadExtReportInfoByNameAndGroupName(String extreportName, String extreportGroupName, String userID) throws AbstractQingIntegratedException, SQLException {
        String sGroupId = this.getExtReportGroupDao().loadExtReportGroupIdByFullPath(extreportGroupName, userID);
        return this.loadInfoByNameAndGroupID(extreportName, sGroupId, userID);
    }

    public ExtReportVO findExtReport(String sourceExtReportID, String userID, ReportProperties reportProperties) throws AbstractQingIntegratedException, SQLException {
        String groupID;
        ExtReportVO extReportVO;
        String reportID = reportProperties.getId();
        String isolateTag = reportProperties.getDomain();
        if (StringUtils.isNotEmpty((CharSequence)isolateTag) && reportProperties.getPathAlias().contains("\u9884\u7f6e\u76ee\u5f55") && IntegratedHelper.getPresetUserId().equals(isolateTag)) {
            userID = isolateTag;
        }
        if ((extReportVO = this.loadExtReportByID(reportID, userID)) != null) {
            return extReportVO;
        }
        String extreportName = reportProperties.getAlias();
        extReportVO = this.loadInfoByNameAndGroupID(extreportName, groupID = reportProperties.getPath(), userID);
        if (extReportVO != null) {
            return extReportVO;
        }
        String pathAlias = reportProperties.getPathAlias();
        String[] pathAndReportName = StringUtils.split((String)pathAlias, (char)'/');
        StringBuilder sb = new StringBuilder();
        for (int n = 1; n < pathAndReportName.length - 1; ++n) {
            sb.append(pathAndReportName[n]);
            if (n == pathAndReportName.length - 2) continue;
            sb.append("/");
        }
        String extreportGroupName = pathAndReportName.length >= 3 ? sb.toString() : pathAndReportName[0];
        extReportVO = this.loadExtReportInfoByNameAndGroupName(extreportName, extreportGroupName, userID);
        if (extReportVO != null) {
            return extReportVO;
        }
        return null;
    }

    public List<ExtReportVO> listExtReportsUnionPreset(List<String> groupIDList, String userID) throws AbstractQingIntegratedException, SQLException {
        String sqlInGroupID = this.getListParamStrInSQL(groupIDList);
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.addAll(groupIDList);
        queryValue.add(userID);
        queryValue.add(IntegratedHelper.getPresetUserId());
        queryValue.addAll(groupIDList);
        queryValue.add(userID);
        queryValue.add(IntegratedHelper.getPresetUserId());
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, FEXTRPTTYPE, FDATASETTYPE FROM (  SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, '0' AS FEXTRPTTYPE, '' AS FDATASETTYPE  FROM T_QING_EXTRPT_INFO  WHERE FGROUPID IN (" + sqlInGroupID + ") AND (FCREATORID=? or FCREATORID=?)  UNION SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, '' AS FTEMPLATETYPE, FGROUPID, '1' AS FEXTRPTTYPE , FTYPE AS FDATASETTYPE  FROM T_QING_DATASET_INFO  WHERE FGROUPID IN (" + sqlInGroupID + ") AND (FCREATORID=? or FCREATORID=?) ) T ORDER BY T.FCREATEDATE DESC ";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<ExtReportVO> loadSortedExtReport(String extreportGroupID, String sSortField, String sSortOrder, String userID) throws AbstractQingIntegratedException, SQLException {
        String sFiled = "FNAME";
        if ("createTime".equals(sSortField)) {
            sFiled = "FCREATEDATE";
        }
        String sOrder = "DESC";
        if ("ASC".equalsIgnoreCase(sSortOrder)) {
            sOrder = "ASC";
        }
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(extreportGroupID);
        queryValue.add(userID);
        queryValue.add(extreportGroupID);
        queryValue.add(userID);
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, FEXTRPTTYPE, FDATASETTYPE ");
        buffer.append("FROM ( ");
        buffer.append(" SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, '0' AS FEXTRPTTYPE, '' AS FDATASETTYPE ");
        buffer.append(" FROM T_QING_EXTRPT_INFO ");
        buffer.append(" WHERE FGROUPID = ? AND FCREATORID = ? ");
        buffer.append(" UNION ALL ");
        buffer.append(" SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, '' AS FTEMPLATETYPE, FGROUPID, '1' AS FEXTRPTTYPE , FTYPE AS FDATASETTYPE ");
        buffer.append(" FROM T_QING_DATASET_INFO ");
        buffer.append(" WHERE FGROUPID = ? AND FCREATORID = ? ");
        buffer.append(" ) T ");
        buffer.append(" ORDER BY T.").append(sFiled).append(" ").append(sOrder);
        return (List)this.dbExcuter.query(buffer.toString(), queryValue.toArray(), (ResultHandler)new ResultHandler<List<ExtReportVO>>(){

            public List<ExtReportVO> handle(ResultSet rs) throws SQLException {
                return ExtReportDaoImpl.this.extReportResultHandle(rs);
            }
        });
    }

    public List<ExtReportVO> loadSortedExtReportUnionPreset(String extreportGroupID, String sSortField, String sSortOrder, String userID) throws AbstractQingIntegratedException, SQLException {
        String sFiled = "FCREATEDATE";
        sFiled = "createTime".equals(sSortField) ? "FCREATEDATE" : "FNAME";
        String sOrder = "DESC";
        if ("ASC".equalsIgnoreCase(sSortOrder)) {
            sOrder = "ASC";
        }
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(extreportGroupID);
        queryValue.add(userID);
        queryValue.add(IntegratedHelper.getPresetUserId());
        queryValue.add(extreportGroupID);
        queryValue.add(userID);
        queryValue.add(IntegratedHelper.getPresetUserId());
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, FEXTRPTTYPE, FDATASETTYPE ");
        buffer.append("FROM ( ");
        buffer.append(" SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, FTEMPLATETYPE, FGROUPID, '0' AS FEXTRPTTYPE, '' AS FDATASETTYPE ");
        buffer.append(" FROM T_QING_EXTRPT_INFO ");
        buffer.append(" WHERE FGROUPID = ? AND (FCREATORID= ? or FCREATORID= ? ) ");
        buffer.append(" UNION ALL ");
        buffer.append(" SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE, FMODIFYDATE, '' AS FTEMPLATETYPE, FGROUPID, '1' AS FEXTRPTTYPE , FTYPE AS FDATASETTYPE ");
        buffer.append(" FROM T_QING_DATASET_INFO ");
        buffer.append(" WHERE FGROUPID = ? AND (FCREATORID = ? or FCREATORID= ? ) ");
        buffer.append(" ) T ");
        buffer.append(" ORDER BY T.").append(sFiled).append(" ").append(sOrder);
        return (List)this.dbExcuter.query(buffer.toString(), queryValue.toArray(), (ResultHandler)new ResultHandler<List<ExtReportVO>>(){

            public List<ExtReportVO> handle(ResultSet rs) throws SQLException {
                return ExtReportDaoImpl.this.extReportResultHandle(rs);
            }
        });
    }

    public HashMap<String, String> getBillModelTypeMap(final List<String> fidList) {
        String sql = "SELECT FID, FMODELTYPE FROM T_META_ENTITYDESIGN WHERE FID";
        StringBuilder sqlInQuestionBuilder = new StringBuilder();
        sqlInQuestionBuilder.append('?');
        for (int i = 1; i < fidList.size(); ++i) {
            sqlInQuestionBuilder.append(",?");
        }
        String sqlInQuestion = sqlInQuestionBuilder.toString();
        sql = sql + " IN (" + sqlInQuestion + ") ";
        ArrayList<String> queryValue = new ArrayList<String>(fidList);
        return (HashMap)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])queryValue.toArray(), (ResultSetHandler)new ResultSetHandler<HashMap<String, String>>(){

            public HashMap<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>(fidList.size());
                while (rs.next()) {
                    String fid = rs.getString("FID");
                    String type = rs.getString("FMODELTYPE");
                    map.put(fid, type);
                }
                return map;
            }
        });
    }

    public List<ExtReportVO> loadExtReportByIDs(Set<String> extReportIds, String userId) throws AbstractQingIntegratedException, SQLException {
        String sqlInStr = SqlUtils.getListParamStrInSQL(extReportIds);
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.addAll(extReportIds);
        queryValue.add(userId);
        String sql = "SELECT FID, FNAME, FDESCRIPTION, FCREATORID, FCREATEDATE,  FMODIFYDATE, FGROUPID, FTEMPLATETYPE FROM T_QING_EXTRPT_INFO WHERE FID IN(#1) AND FCREATORID = ? ORDER BY FCREATEDATE DESC";
        sql = sql.replace("#1", sqlInStr);
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<List<ExtReportVO>>(){

            public List<ExtReportVO> handle(ResultSet rs) throws SQLException {
                ArrayList<ExtReportVO> voList = new ArrayList<ExtReportVO>(10);
                while (rs.next()) {
                    ExtReportVO extreportVO = new ExtReportVO();
                    extreportVO.setExtReportID(rs.getString("FID"));
                    extreportVO.setExtReportName(rs.getString("FNAME"));
                    extreportVO.setDescription(rs.getString("FDESCRIPTION"));
                    extreportVO.setExtReportGroupID(rs.getString("FGROUPID"));
                    extreportVO.setTemplateType(rs.getString("FTEMPLATETYPE"));
                    extreportVO.setCreatorId(rs.getString("FCREATORID"));
                    extreportVO.setExtRptType(ExtRptTypeEnum.EXT_REPORT.getType());
                    voList.add(extreportVO);
                }
                return voList;
            }
        });
    }
}

