/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.old.rpts.web.util;

import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.web.filter.DataType;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.immit.bill.BillHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Border;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.awt.Color;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.bill.OperationStatus;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportContentDaoImpl;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportDaoImpl;
import kd.bos.mservice.extreport.old.rpts.tobi.man.ReportImpl;
import kd.bos.mservice.extreport.old.rpts.tobi.man.SheetImpl;
import kd.bos.mservice.extreport.old.rpts.web.model.BorderStyle;
import kd.bos.mservice.extreport.old.rpts.web.model.CellModel;
import kd.bos.mservice.extreport.old.rpts.web.model.CellTree;
import kd.bos.mservice.extreport.old.rpts.web.model.Diagonal;
import kd.bos.mservice.extreport.old.rpts.web.model.HyperLink;
import kd.bos.mservice.extreport.old.rpts.web.model.ParamValue;
import kd.bos.mservice.extreport.old.rpts.web.util.CustomParamTranslator;
import kd.bos.mservice.extreport.old.rpts.web.util.ReportBookHelper;
import kd.bos.mservice.extreport.old.rpts.web.util.StyleToCss;
import kd.bos.mservice.extreport.old.rpts.web.vo.TableInfo;
import kd.bos.mservice.extreport.runtime.domain.WebParamAdapter;
import kd.bos.mservice.extreport.runtime.exception.ExtReportException;
import org.apache.log4j.Logger;

public class ReportBookHelper {
    private static final Logger log = com.kingdee.cosmic.ctrl.common.util.LogUtil.getLogger(ReportBookHelper.class);
    private static final ThreadLocal<Map<String, String>> creatorIdAndPathToReportIdMapCache = new ThreadLocal();
    private static final ThreadLocal<Map<String, Book>> targetRptDataCache = new ThreadLocal();

    private ReportBookHelper() {
    }

    public static void clearCreatorIdAndPathToReportIdMapCache() {
        creatorIdAndPathToReportIdMapCache.remove();
    }

    public static void clearTargetRptDataCache() {
        targetRptDataCache.remove();
    }

    public static List<String> collectSheetsInfo(Book book) {
        Sheet sheet = null;
        int count = book.getSheetCount();
        ArrayList<String> sheetList = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            sheet = book.getSheet(index);
            if (null == sheet || sheet.isHide()) continue;
            sheetList.add(sheet.getSheetName());
        }
        return sheetList;
    }

    public static List<String> collectSheetsColor(Book book) {
        Sheet sheet = null;
        int count = book.getSheetCount();
        ArrayList<String> colorList = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            sheet = book.getSheet(index);
            if (null == sheet || sheet.isHide()) continue;
            Color color = sheet.getTabColor();
            if (color != null) {
                colorList.add(StyleParser.colorToHex((Color)color));
                continue;
            }
            colorList.add("");
        }
        return colorList;
    }

    public static HyperlinkCalculableProps getHyperLink(Cell cell) {
        ExtProps ep = cell.getExtProps(false);
        if (ep == null) {
            return null;
        }
        SortedExtPropFormulasArray formulas = ep.getFormulas(false);
        if (formulas == null) {
            return null;
        }
        ICalculableProps prop = formulas.get(ExtConst.FORMULA_HYPERLINK);
        if (prop == null) {
            return null;
        }
        return (HyperlinkCalculableProps)prop;
    }

    public static List<CellModel> buildCell(Row row, int colCount, SheetImpl sheetModel, TableInfo tableModel, QingContext ctx, ReportImpl reportImpl, Sheet sheet) {
        int rowIndex = row.getRow();
        ViewSplitInfo splitInfo = sheet.getSheetOption().getViewSplitInfo();
        int rowSplit = splitInfo.getRowSplit();
        int colSplit = splitInfo.getColSplit();
        ArrayList<CellModel> cellList = new ArrayList<CellModel>();
        for (int i = 0; i < colCount; ++i) {
            DiagonalHeader dh;
            CellModel cell;
            boolean isOpaque = (rowIndex < rowSplit || i < colSplit) && splitInfo.isFreezed();
            Cell bookCell = row.getCell(i, false);
            if (bookCell == null) {
                cell = new CellModel();
                Style style = row.getSheet().getCellDisplayStyle(row.getRow(), i);
                if (style == null || style.isEmpty()) continue;
                cell.setStyle(StyleToCss.getCssStyle((Style)style, (boolean)isOpaque));
                cell.setBorder(StyleToCss.getCssBorder((Style)style, (boolean)isOpaque));
                cell.setCol(i);
                cellList.add(cell);
                cell.setValue("");
                continue;
            }
            cell = new CellModel();
            HyperlinkCalculableProps hyperLinkCalProps = ReportBookHelper.getHyperLink(bookCell);
            if (hyperLinkCalProps != null && bookCell.getStyle().isUnderline()) {
                InnerLinkTargets innerTars;
                ETTargets condition;
                Map tars = hyperLinkCalProps.getTargets();
                ETTargets repTars = (ETTargets)tars.get("EXTRPT");
                ExternalTargets externalTargets = (ExternalTargets)tars.get("EXTERNAL");
                boolean leaveOutLink = true;
                Object object = condition = repTars != null ? repTars : externalTargets;
                if (condition != null) {
                    Expr expr = condition.getBehaviorAction();
                    Variant v = ReportBookHelper.executeBehavior(sheet.getDeps().getExprContext(), expr, bookCell);
                    if (v != null) {
                        try {
                            leaveOutLink = v.booleanValue();
                        }
                        catch (SyntaxErrorException e) {
                            leaveOutLink = true;
                        }
                    }
                }
                if (leaveOutLink) {
                    if (repTars != null) {
                        ReportBookHelper.buildRptHyperlink(reportImpl, ctx, repTars, bookCell, cell);
                    }
                    if (externalTargets != null) {
                        ReportBookHelper.buildExternalLink(bookCell, cell, externalTargets);
                    }
                }
                if (bookCell.getHyperLink() != null) {
                    String rangeSiteInSheet;
                    String linkTo = bookCell.getHyperLink().getLinkTo();
                    int start = linkTo.indexOf(35);
                    String name = linkTo.substring(start + 1);
                    if (start >= 0 && StringUtils.isNotEmpty((CharSequence)(rangeSiteInSheet = ReportBookHelper.findRangeSiteInSheet(sheet, name, true)))) {
                        cell.addStringLink(rangeSiteInSheet, name);
                    }
                }
                if ((innerTars = (InnerLinkTargets)tars.get("EXT_INNER")) != null) {
                    ReportBookHelper.buildInnerLink(innerTars, bookCell, cell);
                }
            } else if (bookCell.getHyperLink() != null) {
                String rangeSiteInSheet;
                String linkTo = bookCell.getHyperLink().getLinkTo();
                int start = linkTo.indexOf(35);
                String name = linkTo.substring(start + 1);
                if (start >= 0 && (rangeSiteInSheet = ReportBookHelper.findRangeSiteInSheet(sheet, name, true)) != null && !rangeSiteInSheet.isEmpty()) {
                    cell.setLinkTo(rangeSiteInSheet);
                }
                if (linkTo.startsWith("callTo:")) {
                    cell.setLinkTo(linkTo);
                }
            }
            if (sheetModel.isTree()) {
                CellTree cellTree = ReportBookHelper.buildCellTree(bookCell, sheetModel);
                cell.setCellTree(cellTree);
            }
            if ((dh = bookCell.getDiagonalHeader()) != null) {
                Diagonal dg = new Diagonal();
                dg.setCrossColSum(dh.getCol2() - dh.getCol());
                dg.setCrossRowSum(dh.getRow2() - dh.getRow());
                dg.setLinkToCols(dh.getColOffs());
                dg.setLinkToRows(dh.getRowOffs());
                for (int j = 0; j < dh.size(); ++j) {
                    TriangleInfo tInfo = dh.getTriangleInfo(j);
                    Diagonal.Triangle ta = new Diagonal.Triangle();
                    ta.setText(tInfo.getText());
                    ta.setLean(tInfo.isLean());
                    Style style = tInfo.getStyle();
                    if (style != null) {
                        ta.setStyle(StyleToCss.getCssStyle((Style)style, (boolean)false));
                        BorderStyle bStyle = StyleToCss.getCssBorder((Style)style, (boolean)false);
                        ta.setSlashStyle(bStyle.getLeft());
                    }
                    dg.addTriangle(ta);
                }
                cell.setDiagonal(dg);
            } else {
                cell.setValue(bookCell.getText());
            }
            cell.setStyle(StyleToCss.getCssStyle((Style)bookCell.getDisplayStyle(), (boolean)isOpaque));
            CellBlock mergeBlock = bookCell.getMerge(true);
            if (mergeBlock != null && !bookCell.isExtendMerge()) {
                cell.setBorder(StyleToCss.getCssBorder((Style)ReportBookHelper.getMergeBlockBorderStyle(bookCell, mergeBlock), (boolean)isOpaque));
            } else {
                cell.setBorder(StyleToCss.getCssBorder((Style)bookCell.getStyle(), (boolean)isOpaque));
            }
            cell.setCol(i);
            cellList.add(cell);
        }
        return cellList;
    }

    static Variant executeBehavior(ExprContext ctx, Expr expr, Cell cll) {
        Variant v = null;
        if (expr == null) {
            return v;
        }
        boolean traceMode = ctx.isTraceMode();
        ctx.setTraceMode(false);
        if (ctx.isCalcLastMode()) {
            ctx.setCalcLastMode(false);
            v = expr.execute(ctx, (ICalculable)null).getVariant();
            ctx.setCalcLastMode(true);
        } else {
            v = expr.execute(ctx, (ICalculable)cll).getVariant();
        }
        ctx.setTraceMode(traceMode);
        return v;
    }

    private static void buildExternalLink(Cell bookCell, CellModel cell, ExternalTargets externalTargets) {
        List targets = externalTargets.getAllAssembledTargets();
        ArrayList<HyperLink> links = new ArrayList<HyperLink>(4);
        for (Map target : targets) {
            HyperLink link = new HyperLink();
            HyperLink.TargetType type = HyperLink.TargetType.getType((String)((String)target.get("HYPERLINK_PREFIX")));
            switch (1.$SwitchMap$kd$bos$mservice$extreport$old$rpts$web$model$HyperLink$TargetType[type.ordinal()]) {
                case 1: {
                    link.setSystemId((String)target.get("UI_APPID"));
                    link.setReportId((String)target.get("UI_ID"));
                    link.setReportName((String)target.get("DISPLAY_NAME"));
                    Object isDetail = target.get("UI_DETAIL");
                    if (isDetail != null && Boolean.parseBoolean((String)isDetail)) {
                        link.setUiType(HyperLink.UIType.UI_DETAIL.toString());
                    } else {
                        link.setUiType(HyperLink.UIType.UI_LIST.toString());
                    }
                    if (Boolean.TRUE.toString().equals(target.get("UI_READ_ONLY"))) {
                        link.setOperateState(OperationStatus.VIEW.name());
                    } else {
                        link.setOperateState(OperationStatus.EDIT.name());
                    }
                    ICalculableProps[] calculableProps = (ICalculableProps[])target.get("ID_LIST");
                    List paramList = BillHyperLinkExec.doExecuteProps((ICalculableProps[])calculableProps, (ExtProps)bookCell.getExtProps(false));
                    link.setParams(paramList.toString());
                    break;
                }
                case 2: {
                    link.setUrl((String)target.get("JAVA_CLASS_NAME"));
                    Map params = (Map)target.get("JAVA_PARAMS");
                    if (params == null) break;
                    ExtProps ep = bookCell.getExtProps(false);
                    ep.executeParams(params);
                    link.setParams(JsonUtil.encodeToString((Object)CustomParamTranslator.toCustomHyperParams(ReportBookHelper.transToJsonMap(params))));
                    break;
                }
            }
            link.setType(type);
            link.setReportAlias((String)target.get("DISPLAY_NAME"));
            links.add(link);
        }
        cell.addExtHyperLink(links);
    }

    private static Map<String, Map<String, Object>> transToJsonMap(Map<String, IParameter> params) {
        TreeMap<String, Map<String, Object>> ret = new TreeMap<String, Map<String, Object>>();
        if (params == null || params.isEmpty()) {
            return ret;
        }
        for (Map.Entry<String, IParameter> entry : params.entrySet()) {
            IParameter parameter = params.get(entry.getKey());
            ret.put(entry.getKey(), parameter.toJsonFormMap());
        }
        return ret;
    }

    private static String findRangeSiteInSheet(Sheet sheet, String name, boolean withDefined) {
        StringBuilder rangeSite = new StringBuilder();
        if (withDefined) {
            Cell firstCell;
            SortedNamedObjectNodeArray sona = sheet.getNames();
            NamedObjectNode node = sona.searchByName(name);
            Range refersToRange = null;
            if (node != null) {
                refersToRange = node.getRefersToRange();
            } else {
                SortedNamedObjectNodeArray sn = sheet.getBook().getNames();
                node = sn.searchByName(name);
                if (node != null) {
                    refersToRange = node.getRefersToRange();
                }
            }
            if (refersToRange != null && (firstCell = refersToRange.getFirstCell()) != null) {
                rangeSite.append(firstCell.getSheet().getSheetName()).append('!');
                Cell actualCell = sheet.getActualCell(firstCell.getRow(), firstCell.getCol());
                if (actualCell != null) {
                    rangeSite.append(actualCell.getCol()).append('_').append(actualCell.getRow());
                } else {
                    rangeSite.append(firstCell.getCol()).append('_').append(firstCell.getRow());
                }
                return rangeSite.toString();
            }
        }
        SortedCellBlockArray blocks = null;
        Expr expr = sheet.getExpr(null, name);
        if (!expr.isSyntaxError() && expr.hasCellBlock()) {
            blocks = new SortedCellBlockArray();
            IExprNode[] nodes = expr.getExprParams().getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (!(node instanceof CellBlock)) {
                    blocks = null;
                    break;
                }
                blocks.insert((Object)node);
            }
        }
        if (blocks != null && !blocks.isEmpty()) {
            CellBlock bounds = blocks.getBounds();
            int end = name.indexOf(33);
            rangeSite.append(name.substring(1, end - 1)).append('!');
            if (bounds == null) {
                return null;
            }
            Cell actualCell = sheet.getActualCell(bounds.getRow(), bounds.getCol());
            if (actualCell != null) {
                rangeSite.append(actualCell.getCol()).append('_').append(actualCell.getRow());
            } else {
                rangeSite.append(bounds.getCol()).append('_').append(bounds.getRow());
            }
            return rangeSite.toString();
        }
        return null;
    }

    private static void buildRptHyperlink(ReportImpl report, QingContext ctx, ETTargets repTars, Cell bookCell, CellModel cell) {
        ChartDataItemInfo dataItemInfo = null;
        List<HyperLink> links = ReportBookHelper.buildRptHyperlink(report, ctx, repTars, bookCell, dataItemInfo);
        cell.addHyperLink(links);
    }

    public static List<HyperLink> buildRptHyperlink(ReportImpl report, QingContext ctx, ETTargets repTars, Cell bookCell, ChartDataItemInfo dataItemInfo) {
        ArrayList<HyperLink> links = new ArrayList<HyperLink>(10);
        List targets = repTars.getTargets();
        ExtProps ep = bookCell.getExtProps(false);
        for (ExtTransitionTarget target : targets) {
            String pathAlias;
            String[] pathAndReportName;
            Object obj = ep.executeCalculableProps(target.getReportProps().getCalculableProps());
            if (obj != null) {
                target.getReportProps().setAlias(obj.toString());
            }
            String reportId = target.getReportProps().getId();
            boolean findByIdFlag = false;
            if (reportId != null) {
                ExtReportVO reportVOById = null;
                String pathAlias2 = target.getReportProps().getPathAlias();
                String creatorId = report.getExtReportVO() == null ? "" : report.getExtReportVO().getCreatorId();
                String key = StringUtils.join((Object[])new Object[]{creatorId, pathAlias2}, (char)'_');
                Map<String, String> map = creatorIdAndPathToReportIdMapCache.get();
                if (map != null && map.containsKey(key)) {
                    reportId = map.get(key);
                    findByIdFlag = true;
                } else {
                    IDBExcuter idbExcuter = report.getDbExcuter();
                    try {
                        if (idbExcuter == null) {
                            throw new ExtReportException("IDBExcuter is null");
                        }
                        reportVOById = new ExtReportDaoImpl(idbExcuter).loadExtReportByID(reportId, creatorId);
                        if (map == null) {
                            map = new HashMap<String, String>();
                        }
                        if (reportVOById != null) {
                            map.put(key, reportId);
                            creatorIdAndPathToReportIdMapCache.set(map);
                            findByIdFlag = true;
                        }
                    }
                    catch (Exception e) {
                        reportId = null;
                        LogUtil.warn((String)(MserviceRptMessages.getMLS((String)"queryLinkedReportExceptionBasedOnID", (String)"\u6839\u636eID\u67e5\u8be2\u8054\u67e5\u62a5\u8868\u5f02\u5e38") + e.getMessage()));
                    }
                }
            }
            if (!findByIdFlag && (pathAndReportName = StringUtils.split((String)(pathAlias = target.getReportProps().getPathAlias()), (char)'/')) != null) {
                try {
                    IDBExcuter idbExcuter = report.getDbExcuter();
                    if (idbExcuter == null) {
                        throw new ExtReportException("IDBExcuter is null");
                    }
                    String creatorId = report.getExtReportVO() == null ? "" : report.getExtReportVO().getCreatorId();
                    String key = StringUtils.join((Object[])new Object[]{creatorId, pathAlias}, (char)'_');
                    Map<String, String> map = creatorIdAndPathToReportIdMapCache.get();
                    if (map != null && map.containsKey(key)) {
                        reportId = map.get(key);
                    } else {
                        reportId = new ExtReportDaoImpl(idbExcuter).getReportIdByCreatorAndPath(pathAlias, creatorId);
                        if (map == null) {
                            map = new HashMap<String, String>();
                        }
                        map.put(key, reportId);
                        creatorIdAndPathToReportIdMapCache.set(map);
                    }
                }
                catch (Exception e) {
                    reportId = null;
                    LogUtil.warn((String)("\u67e5\u8be2\u4e3b\u62a5\u8868ID+\u8def\u5f84+\u540d\u79f0\u8054\u67e5\u62a5\u8868\u5f02\u5e38" + e.getMessage()));
                }
            }
            String reportName = target.getReportProps().getName();
            String systemId = target.getReportProps().getPath();
            String alias = target.getReportProps().getAlias();
            String domain = target.getReportProps().getDomain();
            boolean isDefault = repTars.getDefaultTarget() == target;
            ArrayList<ParamValue> paramValues = new ArrayList<ParamValue>(10);
            Map params = target.getParameters();
            ep.executeParams(params);
            Book book = ReportBookHelper.prepareReportBookData(reportId, target.getReportProps().getPathAlias(), report.getDbExcuter());
            ReportBookHelper.executeParamsDefaultValue(ctx, params, null, target.getReportProps(), report.getDbExcuter(), book);
            ChartInnerLinkExec.executeChartParams((Map)params, (ChartDataItemInfo)dataItemInfo);
            Iterator paramIter = params.keySet().iterator();
            while (paramIter.hasNext()) {
                ParamValue paramValue = new ParamValue();
                String key = paramIter.next().toString();
                ParameterImpl param = (ParameterImpl)params.get(key);
                DataType dataTypeEnum = DataType.get((int)param.getDataType());
                String dataType = dataTypeEnum.name().toLowerCase();
                paramValue.setDataType(dataType);
                paramValue.setName(param.getName());
                paramValue.setAlias(param.getAlias());
                Variant vt = param.getValue();
                Date date = null;
                if (vt != null && vt.getVt() == 13) {
                    date = Variant.calendarToGMTDate((Calendar)((GregorianCalendar)vt.getValue()));
                } else if (vt != null && vt.getVt() == 12) {
                    date = (Date)vt.getValue();
                }
                if (date != null) {
                    switch (1.$SwitchMap$com$kingdee$bos$datawizard$edd$web$filter$DataType[dataTypeEnum.ordinal()]) {
                        case 1: {
                            paramValue.setValues(((DateFormat)CtrlReportUtil.sdfDateTime.get()).format(date));
                            break;
                        }
                        case 2: {
                            paramValue.setValues(((DateFormat)CtrlReportUtil.sdf_yyyy_MM_dd.get()).format(date));
                            break;
                        }
                        case 3: {
                            paramValue.setValues(((DateFormat)CtrlReportUtil.sdfTime.get()).format(date));
                        }
                    }
                } else {
                    paramValue.setValues(Variant2String.toString((Variant)vt));
                }
                paramValues.add(paramValue);
            }
            HyperLink hyperLink = new HyperLink();
            hyperLink.setReportId(reportId);
            hyperLink.setReportName(reportName);
            hyperLink.setReportAlias(alias);
            hyperLink.setSystemId(systemId);
            hyperLink.setDomain(domain);
            hyperLink.setDefaultLink(isDefault);
            hyperLink.setParamValues(paramValues);
            links.add(hyperLink);
        }
        return links;
    }

    private static Book prepareReportBookData(String reportId, String pathAlias, IDBExcuter dbExcuter) {
        Book book = null;
        String cacheKey = StringUtils.join((Object[])new Object[]{reportId, pathAlias}, (String)"_");
        Map<String, Book> cacheMap = targetRptDataCache.get();
        if (null != cacheMap && cacheMap.containsKey(cacheKey)) {
            book = cacheMap.get(cacheKey);
        } else {
            if (cacheMap == null) {
                cacheMap = new HashMap<String, Book>();
            }
            if ((book = ReportBookHelper.getReportBook(reportId, dbExcuter)) != null) {
                cacheMap.put(cacheKey, book);
                targetRptDataCache.set(cacheMap);
            }
        }
        return book;
    }

    public static Book getReportBook(String reportId, IDBExcuter dbExcuter) {
        if (null != reportId) {
            Book book;
            try {
                byte[] bookData = new ExtReportContentDaoImpl(dbExcuter).loadExtReportContent(reportId);
                book = BookIOUtil.unpack((byte[])bookData);
            }
            catch (Exception e) {
                book = null;
                LogUtil.warn((String)(MserviceRptMessages.getMLS((String)"queryLinkedReportExceptionBasedOnID", (String)"\u6839\u636eID\u67e5\u8be2\u8054\u67e5\u62a5\u8868\u5f02\u5e38") + e.getMessage()));
            }
            return book;
        }
        return null;
    }

    private static List getAllUnionParam(QingContext ctx, ReportProperties rptpros, IDBExcuter dbExcuter, Book book) {
        if (rptpros == null) {
            return null;
        }
        String reportId = rptpros.getId();
        WebParamAdapter adapter = new WebParamAdapter(ctx, dbExcuter, reportId, book);
        try {
            adapter.cacheDbSourceModel();
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return adapter.getAllUnionParam();
    }

    public static void executeParamsDefaultValue(QingContext ctx, Map params, List allUnionParam, ReportProperties rptpros, IDBExcuter dbExcuter, Book book) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Object errorData;
            IParameter param = (IParameter)i.next().getValue();
            Variant var = param.getValue();
            if (var == null || var == Variant.nullVariant) continue;
            Object value = var.getValue();
            try {
                if (!var.isError() && value instanceof String && ((String)value).toUpperCase().contains("@OriginalDefaultValue".toUpperCase())) {
                    SyntaxErrorException e = new SyntaxErrorException(131072L, (Object)"@OriginalDefaultValue");
                    var.setObject((Object)e, 16);
                    value = var.getValue();
                }
            }
            catch (Exception e) {
                log.error((Object)"err:", (Throwable)e);
            }
            if (!var.isError() || !((errorData = ((SyntaxErrorException)((Object)value)).getExtData()) instanceof String) || !"@OriginalDefaultValue".equalsIgnoreCase((String)errorData)) continue;
            if (allUnionParam == null && rptpros != null && ((allUnionParam = ReportBookHelper.getAllUnionParam(ctx, rptpros, dbExcuter, book)) == null || allUnionParam.isEmpty())) {
                return;
            }
            DesignParameter dp2 = null;
            if (null == allUnionParam) continue;
            for (DesignParameter dp2 : allUnionParam) {
                if (dp2.getName().equals(param.getName())) {
                    var = RunReportParam.getVariant((String)dp2.getDefaultValue(), (int)dp2.getDesignDataType().intValue());
                    param.setValue(var);
                    continue;
                }
                if (!(dp2.getName() + "_text").equals(param.getName())) continue;
                var = RunReportParam.getVariant((String)dp2.getDefaultAlias(), (int)dp2.getDesignDataType().intValue());
                param.setValue(var);
            }
        }
    }

    private static void buildInnerLink(InnerLinkTargets innerTars, Cell bookCell, CellModel cell) {
        List targets = innerTars.getTargets();
        if (targets != null && !targets.isEmpty()) {
            cell.addInnerLink(bookCell.getName(false, true));
        }
    }

    private static CellTree buildCellTree(Cell cell, SheetImpl sheet) {
        int[] type;
        CellTree cellTree = new CellTree();
        cellTree.setHorizontal(sheet.isHorizonTree());
        if (sheet.isHorizonTree() && cell.getRow() == sheet.getTreePos()) {
            type = sheet.displayType(cell.getCol());
        } else if (cell.getCol() == sheet.getTreePos() && TreeCellUtil.queryCellType((Cell)cell) != null) {
            if (cell.isFirstMergedCell()) {
                CellBlock merge = cell.getMerge(true);
                type = sheet.displayType(merge.getRow2());
            } else {
                type = sheet.displayType(cell.getRow());
            }
        } else {
            return null;
        }
        cellTree.setLevel(type[1]);
        if (type[0] == 0) {
            cellTree.setExpanded(true);
        } else {
            cellTree.setExpanded(false);
        }
        if (type[2] == 1) {
            cellTree.setHaveHandler(true);
        } else {
            cellTree.setHaveHandler(false);
        }
        return cellTree;
    }

    private static Style getMergeBlockBorderStyle(Cell cell, CellBlock mergeBlock) {
        StyleAttributes sa = Styles.getEmptySA();
        Sheet sheet = cell.getSheet();
        Borders borders = sheet.getBorders();
        Border leftBorder = borders.getCellBorder(mergeBlock.getRow(), mergeBlock.getCol() - 1, true);
        boolean leftSame = true;
        for (int j = mergeBlock.getRow() + 1; j <= mergeBlock.getRow2(); ++j) {
            if (leftBorder == borders.getCellBorder(j, mergeBlock.getCol() - 1, true)) continue;
            leftSame = false;
            break;
        }
        if (leftSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.LEFT, leftBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.LEFT, sheet.getDefaultBorder(true));
        }
        boolean topSame = true;
        Border topBorder = borders.getCellBorder(mergeBlock.getRow() - 1, mergeBlock.getCol(), false);
        for (int i = mergeBlock.getCol() + 1; i <= mergeBlock.getCol2(); ++i) {
            if (topBorder == borders.getCellBorder(mergeBlock.getRow() - 1, i, false)) continue;
            topSame = false;
            break;
        }
        if (topSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.TOP, topBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.TOP, sheet.getDefaultBorder(false));
        }
        Border rightBorder = borders.getCellBorder(mergeBlock.getRow(), mergeBlock.getCol2(), true);
        boolean rightSame = true;
        for (int i = mergeBlock.getRow() + 1; i <= mergeBlock.getRow2(); ++i) {
            if (rightBorder == borders.getCellBorder(i, mergeBlock.getCol2(), true)) continue;
            rightSame = false;
            break;
        }
        if (rightSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.RIGHT, rightBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.RIGHT, sheet.getDefaultBorder(true));
        }
        Border bottomBorder = borders.getCellBorder(mergeBlock.getRow2(), mergeBlock.getCol(), false);
        boolean bottomSame = true;
        for (int i = mergeBlock.getCol() + 1; i <= mergeBlock.getCol2(); ++i) {
            if (bottomBorder == borders.getCellBorder(mergeBlock.getRow2(), i, false)) continue;
            bottomSame = false;
            break;
        }
        if (bottomSame) {
            ReportBookHelper.fillSA(sa, Styles.Position.BOTTOM, bottomBorder);
        } else {
            ReportBookHelper.fillSA(sa, Styles.Position.BOTTOM, sheet.getDefaultBorder(false));
        }
        int bitCount = ShareStyleAttributes.ATTRS_COUNT;
        if (!sa.isFull()) {
            sa.append(sheet.getRowSSA(cell.getRow()), false, bitCount);
        }
        if (!sa.isFull()) {
            sa.append(sheet.getColSSA(cell.getCol()), false, bitCount);
        }
        if (!sa.isFull()) {
            sa.append(sheet.getSSA(), false, bitCount);
        }
        return new Style((ShareStyleAttributes)sa);
    }

    private static void fillSA(StyleAttributes sa, Styles.Position pos, Border bdr) {
        sa.setBorderColor(pos, bdr.getColor());
        sa.setBorderPenStyle(pos, bdr.getPenStyle());
        sa.setBorderLineStyle(pos, bdr.getLineStyle());
    }
}

