/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.runtime.domain;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.bo.KSQLReportBO;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoExisitException;
import com.kingdee.bos.datawizard.edd.ctrlreport.dataset.exception.ExtDataSetNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlreport.macro.exception.ExtMacroException;
import com.kingdee.bos.datawizard.edd.ctrlreport.model.CtrlReportUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignDataType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.DesignParameter;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputState;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.InputType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.data.TreeStructType;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.CycleException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataCenterNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetContentNotExistsException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.DataSetNotPresetPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.InvalidParamInputException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.exception.SuperQueryNoPermissionException;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.DataSetDefineModel;
import com.kingdee.bos.datawizard.edd.ctrlsqldesign.model.RunReportParam;
import com.kingdee.bos.datawizard.edd.tobi.model.F7SuppliedValue;
import com.kingdee.bos.datawizard.edd.tobi.util.ExtFilterParamUtil;
import com.kingdee.bos.datawizard.edd.web.filter.CtrlType;
import com.kingdee.bos.datawizard.edd.web.filter.DataType;
import com.kingdee.bos.datawizard.edd.web.filter.DateParamDescription;
import com.kingdee.bos.datawizard.edd.web.filter.F7ParamDescription;
import com.kingdee.bos.datawizard.edd.web.filter.ReportParamDescription;
import com.kingdee.bos.datawizard.edd.web.vo.Entry;
import com.kingdee.bos.datawizard.edd.web.vo.TableRowSet;
import com.kingdee.bos.datawizard.edd.web.vo.TreeNodeEntry;
import com.kingdee.bos.extreport.manage.model.ExtReportVO;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapFolderVO;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapGroupType;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapPeriodType;
import com.kingdee.bos.extreport.snap.model.ExtReportSnapSaveInfo;
import com.kingdee.bos.extreport.utils.StringUtils;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.PublishNoPermissionException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.model.PublishOperTypeEnum;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StackTraceUtil;
import com.kingdee.bos.report.ext.web.scheme.po.ExtFilterScheme;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.ThreadLocalUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.chart.AbstractType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferMapper;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.util.QingTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.print.util.KDPrinterUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.xml.bind.JAXBException;
import kd.bos.mservice.extreport.common.MserviceRptMessages;
import kd.bos.mservice.extreport.dataset.datasource.param.ParamAnalysisHelper;
import kd.bos.mservice.extreport.designer.domain.ExtFilterSchemeDomain;
import kd.bos.mservice.extreport.manage.dao.IExtReportContentDao;
import kd.bos.mservice.extreport.manage.dao.IExtReportDao;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportContentDaoImpl;
import kd.bos.mservice.extreport.manage.dao.impl.ExtReportDaoImpl;
import kd.bos.mservice.extreport.manage.domain.DataSetManageDomain;
import kd.bos.mservice.extreport.manage.model.DataSetVO;
import kd.bos.mservice.extreport.old.analysis.web.export.ExportType;
import kd.bos.mservice.extreport.old.analysis.web.pagesetup.PageSetup;
import kd.bos.mservice.extreport.old.analysis.web.pagesetup.PageSetupFactory;
import kd.bos.mservice.extreport.old.analysis.web.solution.filter.FilterScheme;
import kd.bos.mservice.extreport.old.analysis.web.solution.filter.ShareStrategy;
import kd.bos.mservice.extreport.old.rpts.tobi.ExtReportImpl;
import kd.bos.mservice.extreport.old.rpts.tobi.man.ReportImpl;
import kd.bos.mservice.extreport.old.rpts.tobi.man.SheetImpl;
import kd.bos.mservice.extreport.old.rpts.web.exception.InnerLinkException;
import kd.bos.mservice.extreport.old.rpts.web.filter.FilterSchemeInfo;
import kd.bos.mservice.extreport.old.rpts.web.innerlink.CellInnerLinkWebExec;
import kd.bos.mservice.extreport.old.rpts.web.innerlink.ChartInnerLinkWebExec;
import kd.bos.mservice.extreport.old.rpts.web.model.EmbedLinkParamVO;
import kd.bos.mservice.extreport.old.rpts.web.model.LinkModel;
import kd.bos.mservice.extreport.old.rpts.web.model.LinkParamVo;
import kd.bos.mservice.extreport.old.rpts.web.model.ParamValue;
import kd.bos.mservice.extreport.old.rpts.web.util.BeanFactory;
import kd.bos.mservice.extreport.old.rpts.web.util.ReportBookHelper;
import kd.bos.mservice.extreport.old.rpts.web.vo.FilterInfo;
import kd.bos.mservice.extreport.old.rpts.web.vo.ReportInfo;
import kd.bos.mservice.extreport.old.rpts.web.vo.SheetInfo;
import kd.bos.mservice.extreport.old.rpts.web.vo.TableInfo;
import kd.bos.mservice.extreport.runtime.constant.ExtReportOperCodeEnum;
import kd.bos.mservice.extreport.runtime.domain.ExportDomain;
import kd.bos.mservice.extreport.runtime.domain.PageManager;
import kd.bos.mservice.extreport.runtime.domain.WebParamAdapter;
import kd.bos.mservice.extreport.runtime.exception.DataSetExecuteException;
import kd.bos.mservice.extreport.runtime.exception.DataSetInvalidParamException;
import kd.bos.mservice.extreport.runtime.exception.DataSetNoPermissionException;
import kd.bos.mservice.extreport.runtime.exception.DataSetNotExistsException;
import kd.bos.mservice.extreport.runtime.exception.ExtMacroNotExistsException;
import kd.bos.mservice.extreport.runtime.exception.ExtReportException;
import kd.bos.mservice.extreport.runtime.exception.ExtReportNoPermissionException;
import kd.bos.mservice.extreport.runtime.exception.ExtReportNotExistsException;
import kd.bos.mservice.extreport.runtime.exception.SnapErrorCodeEnum;
import kd.bos.mservice.extreport.runtime.exception.SnapInvalidParamException;
import kd.bos.mservice.extreport.runtime.model.bo.ExtReportCache;
import kd.bos.mservice.extreport.runtime.model.vo.DataSetRuntimeInfo;
import kd.bos.mservice.extreport.runtime.model.vo.ExtReportRuntimeInfo;
import kd.bos.mservice.extreport.runtime.model.vo.ExtReportSnapRuntimeInfo;
import kd.bos.mservice.extreport.runtime.model.vo.ExtReportSnapSavingModel;
import kd.bos.mservice.extreport.runtime.model.vo.SetupModel;
import kd.bos.mservice.extreport.runtime.model.vo.ZoomScaleModel;
import kd.bos.mservice.extreport.snapcenter.dao.IExtReportSnapContentDao;
import kd.bos.mservice.extreport.snapcenter.dao.IExtReportSnapInfoDao;
import kd.bos.mservice.extreport.snapcenter.dao.impl.ExtReportSnapContentImpl;
import kd.bos.mservice.extreport.snapcenter.dao.impl.ExtReportSnapInfoDaoImpl;
import kd.bos.mservice.extreport.snapcenter.domain.ExtReportSnapGroupDomain;
import kd.bos.mservice.extreport.snapcenter.domain.ExtReportSnapInfoDomain;
import kd.bos.mservice.extreport.snapcenter.model.ExtReportSnapGroupVO;
import kd.bos.mservice.extreport.snapcenter.model.ExtReportSnapInfoPO;
import kd.bos.mservice.extreport.snapschedule.model.vo.FilterInfoVO;
import kd.bos.mservice.extreport.util.DataSetExecuteChecker;

public class RuntimeDomain {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private IExtReportContentDao extReportContentDao;
    private IExtReportDao extReportDao;
    private ExportDomain exportDomain;
    private ExtFilterSchemeDomain filterSchemeDomain;
    private DataSetManageDomain dataSetManageDomain;
    private CommonPublishDomain commonPublishDomain;
    private ExtReportSnapInfoDomain extReportSnapInfoDomain;
    private ExtReportSnapGroupDomain extReportSnapGroupDomain;
    private IExtReportSnapContentDao snapContentDao;
    private IExtReportSnapInfoDao snapInfoDao;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private IExtReportContentDao getExtReportContentDao() {
        if (this.extReportContentDao == null) {
            this.extReportContentDao = new ExtReportContentDaoImpl(this.dbExcuter);
        }
        return this.extReportContentDao;
    }

    private IExtReportDao getExtReportDao() {
        if (this.extReportDao == null) {
            this.extReportDao = new ExtReportDaoImpl(this.dbExcuter);
        }
        return this.extReportDao;
    }

    private ExportDomain getExportDomain() {
        if (this.exportDomain == null) {
            this.exportDomain = new ExportDomain();
        }
        return this.exportDomain;
    }

    private DataSetManageDomain getDataSetManageDomain() {
        if (this.dataSetManageDomain == null) {
            this.dataSetManageDomain = new DataSetManageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.dataSetManageDomain;
    }

    private ExtFilterSchemeDomain getFilterSchemeDomain() {
        if (this.filterSchemeDomain == null) {
            this.filterSchemeDomain = new ExtFilterSchemeDomain();
            this.filterSchemeDomain.setQingContext(this.qingContext);
            this.filterSchemeDomain.setTx(this.tx);
            this.filterSchemeDomain.setDbExcuter(this.dbExcuter);
        }
        return this.filterSchemeDomain;
    }

    private ExtReportSnapInfoDomain getSnapInfoDomain() {
        if (this.extReportSnapInfoDomain == null) {
            this.extReportSnapInfoDomain = new ExtReportSnapInfoDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.extReportSnapInfoDomain;
    }

    private ExtReportSnapGroupDomain getExtReportSnapGroupDomain() {
        if (this.extReportSnapGroupDomain == null) {
            this.extReportSnapGroupDomain = new ExtReportSnapGroupDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.extReportSnapGroupDomain;
    }

    private IExtReportSnapContentDao getSnapContentDao() {
        if (this.snapContentDao == null) {
            this.snapContentDao = new ExtReportSnapContentImpl(this.dbExcuter);
        }
        return this.snapContentDao;
    }

    private IExtReportSnapInfoDao getSnapInfoDao() {
        if (this.snapInfoDao == null) {
            this.snapInfoDao = new ExtReportSnapInfoDaoImpl(this.dbExcuter);
        }
        return this.snapInfoDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    public void initExtReport(String extReportID, boolean checkPermission, boolean isHyperlink, String paramCacheId) throws ExtReportNotExistsException, AbstractQingIntegratedException, SQLException, ExtReportNoPermissionException {
        ExtReportVO extReportVO = this.getExtReportDao().loadExtReportByID(extReportID);
        if (extReportVO == null) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theLightReportDoesNotExist", (String)"\u8be5\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
            throw new ExtReportNotExistsException(msg);
        }
        Boolean bPresetManagePerm = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)this.qingContext);
        if (checkPermission && !this.qingContext.getUserId().equals(extReportVO.getCreatorId()) && !bPresetManagePerm.booleanValue()) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"reportNotAuthorizedToView", (String)"\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u62a5\u8868");
            throw new ExtReportNoPermissionException(msg);
        }
    }

    public ExtReportRuntimeInfo loadExtReportInfo(String extReportID, String publishId, String cacheDataName, Boolean isGuiPreview) throws Exception {
        return this.loadExtReportInfo(extReportID, publishId, true, cacheDataName, isGuiPreview);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtReportRuntimeInfo loadExtReportInfo(String extReportID, String publishId, boolean cacheClientId, String cacheDataName, Boolean isGuiPreview) throws Exception {
        try {
            boolean authRight;
            PageManager.refreshDataSet.set(true);
            ExtReportVO extReportVO = this.getExtReportDao().loadExtReportByID(extReportID);
            String userId = this.qingContext.getUserId();
            String systemId = IntegratedHelper.getPresetUserId();
            if (StringUtils.isNotEmpty((CharSequence)publishId)) {
                if (extReportVO != null && systemId.equals(extReportVO.getCreatorId())) {
                    PublishPO publishPO = this.getCommonPublishDomain().checkPublishExist(publishId);
                    authRight = this.getCommonPublishDomain().checkPublishAuthRight(publishPO);
                    if (authRight) {
                        ThreadLocalUtil.set((String)"isPresetPublish", (Object)true);
                    }
                }
            } else if (systemId.equals(extReportVO.getCreatorId())) {
                Boolean isPreview = (Boolean)ThreadLocalUtil.get((String)"isPreview");
                if (isPreview != null && isPreview.booleanValue()) {
                    if (!IntegratedHelper.checkExtReportPresetManagePermission((QingContext)this.qingContext)) {
                        String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"reportNotPresetAuthorizedToView", (String)"\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u62a5\u8868\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002");
                        throw new ExtReportNoPermissionException(msg);
                    }
                } else {
                    authRight = this.getCommonPublishDomain().checkExtReportPublishAuthRight(extReportID);
                    if (authRight) {
                        ThreadLocalUtil.set((String)"isPresetPublish", (Object)true);
                    }
                }
            }
            byte[] data = isGuiPreview != false ? PageManager.getCachedExtData((String)cacheDataName) : this.getExtReportContentDao().loadExtReportContent(extReportID);
            String dataName = PageManager.cacheExtData((byte[])data);
            String pageId = UUID.randomUUID().toString();
            ExtReportCache cacheMeta = new ExtReportCache(pageId, extReportID);
            cacheMeta.setTempletaBookFile(dataName);
            cacheMeta.setRuntimeBookFile(dataName);
            cacheMeta.setExtReportVO(extReportVO);
            PageManager.cachePage((ExtReportCache)cacheMeta);
            if (cacheClientId) {
                PageManager.cacheClientId((String)pageId);
            }
            ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
            ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
            extReportImpl.setQingContext(this.qingContext);
            extReportImpl.setDbExcuter(this.dbExcuter);
            ExtReportRuntimeInfo runtimeInfo = cachePage.getReportInfo();
            if (extReportVO != null) {
                runtimeInfo.setCreatorName(IntegratedHelper.getUserName((String)extReportVO.getCreatorId()));
                runtimeInfo.setCreateTime(DateUtils.timeStampToString((long)(extReportVO.getCreateTime() / 1000L), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)publishId)) {
                runtimeInfo.setCurrentUserId(userId);
                this.setPublishOperValue(runtimeInfo, publishId);
            } else {
                Boolean isPreview = (Boolean)ThreadLocalUtil.get((String)"isPreview");
                if (isPreview != null && isPreview.booleanValue()) {
                    ExtReportVO reportVO = this.getExtReportDao().loadExtReportByID(extReportID, this.qingContext.getUserId());
                    if (reportVO != null || extReportVO != null && systemId.equals(extReportVO.getCreatorId())) {
                        runtimeInfo.setHasPrintPermission(true);
                        runtimeInfo.setHasExportPermission(true);
                    }
                } else {
                    this.setPublishOperValue(runtimeInfo);
                }
            }
            HashMap<String, String> invalidDataMap = new HashMap<String, String>(8);
            ReportDataSetChecker checker = extDataSet -> {
                String define = extDataSet.getDefine();
                DataSetDefineModel dataSetDefineModel = DataSetDefineModel.parseDefine((String)define);
                if (dataSetDefineModel == null) {
                    return true;
                }
                DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetDefineModel.getId());
                if (dataSetVO == null) {
                    return true;
                }
                String dataSetID = dataSetVO.getDataSetID();
                if (!DataSetExecuteChecker.checkDataSetExecutableById(dataSetID)) {
                    invalidDataMap.put(extDataSet.getAlias(), dataSetDefineModel.getPath());
                    return false;
                }
                return true;
            };
            ReportImpl report = extReportImpl.getReport();
            if (report != null) {
                Book book = report.getBook();
                runtimeInfo.setSetupModel(this.initSetupModel(book));
                runtimeInfo.setAvailable(this.checkReportAvailable(book, checker));
            }
            if (!invalidDataMap.isEmpty()) {
                runtimeInfo.setInvalidData(this.buildErrorMessage(invalidDataMap));
            }
            ExtReportRuntimeInfo extReportRuntimeInfo = runtimeInfo;
            return extReportRuntimeInfo;
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    private SetupModel initSetupModel(Book book) {
        if (book == null || book.getSheetCount() == 0) {
            return null;
        }
        SetupModel setupModel = new SetupModel();
        PrintSetup printSetup = book.getSheet(0).getSheetOption().getPrintSetup(true);
        this.sycPaperSize(setupModel, printSetup);
        setupModel.setLandscape(printSetup.isLandScape());
        setupModel.setMarginLeft((float)Math.round(printSetup.getLeftMargin() * 25430.0f / 1000.0f));
        setupModel.setMarginTop((float)Math.round(printSetup.getTopMargin() * 25430.0f / 1000.0f));
        setupModel.setMarginRight((float)Math.round(printSetup.getRightMargin() * 25430.0f / 1000.0f));
        setupModel.setMarginBottom((float)Math.round(printSetup.getBottomMargin() * 25430.0f / 1000.0f));
        this.sycHeaderAndFooter(setupModel, printSetup);
        ZoomScaleModel scaleModel = new ZoomScaleModel();
        scaleModel.setScale((float)printSetup.getScale());
        scaleModel.setAutoFit(printSetup.isAutoFit());
        scaleModel.setAutoFitWidth(printSetup.getAutoFitWidth());
        scaleModel.setAutoFitHeight(printSetup.getAutoFitHeight());
        setupModel.setScaleModel(scaleModel);
        setupModel.setRowFirst(printSetup.isRowFirst());
        return setupModel;
    }

    private boolean checkReportAvailable(Book book, ReportDataSetChecker checker) throws AbstractQingIntegratedException, SQLException {
        if (null == book) {
            return true;
        }
        ExtDataSetManager extDataSetManager = book.getDataSetManager();
        if (extDataSetManager == null) {
            return true;
        }
        boolean isAvailable = true;
        int dsCount = extDataSetManager.size();
        for (int indexDataSet = 0; indexDataSet < dsCount; ++indexDataSet) {
            ExtDataSet extDataSet = extDataSetManager.getAt(indexDataSet);
            isAvailable = isAvailable && checker.check(extDataSet);
        }
        return isAvailable;
    }

    private void sycPaperSize(SetupModel setupModel, PrintSetup printSetup) {
        float paperHeight;
        float paperWidth;
        int pagesizeIndex = printSetup.getPagesizeIndex();
        MediaSizeName mediasize = KDPrinterUtils.getMediaSizeNameByValue((int)pagesizeIndex, (float)(paperWidth = printSetup.getPagesizeX()), (float)(paperHeight = printSetup.getPagesizeY()));
        MediaSize msz = MediaSize.getMediaSizeForName(mediasize);
        if (msz == null) {
            msz = MediaSize.ISO.A4;
        }
        setupModel.setPaperWidth((float)Math.round(msz.getX(1) / 1000.0f));
        setupModel.setPaperHeight((float)Math.round(msz.getY(1) / 1000.0f));
    }

    private void sycHeaderAndFooter(SetupModel setupModel, PrintSetup printSetup) {
        ArrayList<String[]> headData = new ArrayList<String[]>(3);
        ArrayList<String[]> footData = new ArrayList<String[]>(3);
        List oldHeadData = printSetup.getHeadData();
        List oldFootData = printSetup.getFootData();
        int headSize = oldHeadData == null ? 0 : oldHeadData.size();
        String[] leftStrs = new String[headSize];
        String[] centerStrs = new String[headSize];
        String[] rightStrs = new String[headSize];
        for (int i = 0; i < headSize; ++i) {
            String value = ((HeadFootRow)oldHeadData.get(i)).getText();
            String[] split = value.split("&\\|");
            if (split.length == 1) {
                leftStrs[i] = "";
                centerStrs[i] = split[0];
                rightStrs[i] = "";
                continue;
            }
            if (split.length == 2) {
                leftStrs[i] = split[0];
                centerStrs[i] = split[1];
                rightStrs[i] = "";
                continue;
            }
            if (split.length <= 2) continue;
            leftStrs[i] = split[0];
            centerStrs[i] = split[1];
            rightStrs[i] = split[2];
        }
        headData.add(leftStrs);
        headData.add(centerStrs);
        headData.add(rightStrs);
        int footSize = oldFootData == null ? 0 : oldFootData.size();
        leftStrs = new String[footSize];
        centerStrs = new String[footSize];
        rightStrs = new String[footSize];
        for (int i = 0; i < footSize; ++i) {
            String value = ((HeadFootRow)oldFootData.get(i)).getText();
            String[] split = value.split("&\\|");
            if (split.length == 1) {
                leftStrs[i] = "";
                centerStrs[i] = split[0];
                rightStrs[i] = "";
                continue;
            }
            if (split.length == 2) {
                leftStrs[i] = split[0];
                centerStrs[i] = split[1];
                rightStrs[i] = "";
                continue;
            }
            if (split.length <= 2) continue;
            leftStrs[i] = split[0];
            centerStrs[i] = split[1];
            rightStrs[i] = split[2];
        }
        footData.add(leftStrs);
        footData.add(centerStrs);
        footData.add(rightStrs);
        setupModel.setListHeaderRow(headData);
        setupModel.setListFooterRow(footData);
    }

    private CtrlDesignQueryModel initDataSetModel(String dataSetId) throws CtrlReportException, CycleException, DataSetNotExistsException {
        CtrlDesignQueryModel model;
        try {
            model = KSQLReportBO.initModel((Object)this.qingContext, (String)dataSetId, null);
        }
        catch (CtrlReportException e) {
            if (e instanceof DataSetContentNotExistsException) {
                String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theDatasetDoesNotExist", (String)"\u8be5\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
                throw new DataSetNotExistsException(msg, (Throwable)e);
            }
            throw e;
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSetRuntimeInfo loadDataSetInfo(String dataSetId) throws Exception {
        try {
            PageManager.refreshDataSet.set(true);
            PageManager.cacheClientId((String)dataSetId);
            DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetId);
            if (dataSetVO == null) {
                String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theDatasetDoesNotExist", (String)"\u8be5\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
                throw new DataSetNotExistsException(msg);
            }
            Boolean bPresetManagePerm = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)this.qingContext);
            if (!this.qingContext.getUserId().equals(dataSetVO.getCreatorId()) && !bPresetManagePerm.booleanValue()) {
                String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"dataSetNotAuthorizedToView", (String)"\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u6570\u636e\u96c6");
                throw new DataSetNoPermissionException(msg);
            }
            DataSetRuntimeInfo dataSetRuntimeInfo = new DataSetRuntimeInfo();
            dataSetRuntimeInfo.setDataSetId(dataSetId);
            dataSetRuntimeInfo.setDataSetName(dataSetVO.getDataSetName());
            dataSetRuntimeInfo.setDataSetGroupId(dataSetVO.getDataSetGroupID());
            dataSetRuntimeInfo.setDescription(dataSetVO.getDescription());
            CtrlDesignQueryModel model = this.initDataSetModel(dataSetId);
            CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
            dataSetRuntimeInfo.setHasModel(!commonQuery.isNullModel());
            List parameters = model.getCommonQuery().getParameters();
            boolean hasFilter = parameters != null && parameters.size() > 0;
            dataSetRuntimeInfo.setHasFilter(hasFilter);
            DataSetRuntimeInfo dataSetRuntimeInfo2 = dataSetRuntimeInfo;
            return dataSetRuntimeInfo2;
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    public FilterInfo getDataSetFilterAndSchemaList(String dataSetId) throws ExtMacroNotExistsException, Exception {
        try {
            PageManager.refreshDataSet.set(false);
            FilterInfo filterInfo = new FilterInfo();
            CtrlDesignQueryModel model = this.initDataSetModel(dataSetId);
            CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
            List parameters = commonQuery.getParameters();
            this.processDefaultValue(parameters);
            List<ReportParamDescription> paramDescriptions = RuntimeDomain.translateParams(this.qingContext, parameters, null, dataSetId);
            filterInfo.setParamList(paramDescriptions);
            Map<String, List<String>> paramRef = this.buildParamRef(paramDescriptions);
            ArrayList<FilterSchemeInfo> schemeList = new ArrayList<FilterSchemeInfo>(10);
            FilterSchemeInfo filterSchemeInfo = new FilterSchemeInfo();
            FilterScheme defaultFilterScheme = RuntimeDomain.getDefaultFilterScheme(parameters);
            filterSchemeInfo.setCaption(defaultFilterScheme.getCaption());
            filterSchemeInfo.setValue(defaultFilterScheme.toString());
            schemeList.add(filterSchemeInfo);
            this.getFilterSchemesNotDefault(dataSetId, ShareStrategy.USER_ONLY, schemeList, paramDescriptions);
            filterInfo.setSchemeList(schemeList);
            filterInfo.setShareStrategy(ShareStrategy.USER_ONLY.ordinal());
            ExtFilterScheme lastUseScheme = this.getFilterSchemeDomain().findLastUseFilterScheme(dataSetId);
            if (lastUseScheme != null) {
                filterInfo.setHasDefaultEnter(true);
                filterInfo.setDefaultEnter(lastUseScheme.getName());
            }
            filterInfo.setAssociate(paramRef);
            FilterInfo filterInfo2 = filterInfo;
            return filterInfo2;
        }
        catch (DataCenterNoPermissionException e) {
            throw new kd.bos.mservice.extreport.runtime.exception.DataCenterNoPermissionException((Throwable)e);
        }
        catch (ExtMacroException e) {
            throw new ExtMacroNotExistsException(e.getErrorCode(), (Throwable)e, e.getErrorMessage());
        }
        catch (DataSetNotPresetPermissionException e) {
            throw new DataSetNotPresetPermissionException((Throwable)e, e.getErrorMessage());
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> applyDataSetFilter(String dataSetId, int limit, String paramValues) throws Exception {
        try {
            Map mapResult;
            PageManager.refreshDataSet.set(false);
            CtrlDesignQueryModel model = this.initDataSetModel(dataSetId);
            CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
            List parameters = commonQuery.getParameters();
            this.processDefaultValue(parameters);
            Map<String, String> paramMap = RuntimeDomain.getParamMap(parameters, paramValues, "value", false);
            Map<String, DesignParameter> executeParams = this.getExecuteParams(parameters, paramMap);
            RunReportParam.putDefalutListParamsMap((Object)this.qingContext, executeParams);
            try {
                ExtReportOutDBBO.checkDataSetByDataSetIdAndModel((Object)this.qingContext, (CtrlDesignQueryModel)model, (String)dataSetId);
                mapResult = CtrlDesignDataExecutor.execute((Object)this.qingContext, (CtrlDesignQueryModel)model, executeParams, null, (int)0, (int)limit, (boolean)false, null);
            }
            catch (ExtDataSetNoExisitException e) {
                throw new DataSetNotExistsException(e.getErrorMessage(), (Throwable)e);
            }
            catch (ExtDataSetNoPermissionException e) {
                throw new DataSetNoPermissionException(e.getErrorMessage(), (Throwable)e);
            }
            catch (ExtMacroException e) {
                throw new ExtMacroNotExistsException(e.getErrorCode(), (Throwable)e, e.getErrorMessage());
            }
            catch (DataCenterNoPermissionException e) {
                throw new kd.bos.mservice.extreport.runtime.exception.DataCenterNoPermissionException((Throwable)e);
            }
            catch (SuperQueryNoPermissionException e) {
                throw e;
            }
            catch (Exception e) {
                String sql = model.getSql();
                String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"checkExecutionStatement", (String)"\u6570\u636e\u96c6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u8bed\u53e5");
                throw new DataSetExecuteException(msg + "|||\nSqlContent\uff1a \n" + sql + "\n\n" + StackTraceUtil.getStackTrace((Throwable)e));
            }
            ResultSet resultSet = (ResultSet)mapResult.get("6xx8xxRowset");
            int len = resultSet.getMetaData().getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>(4);
            ArrayList<String> columnAlias = new ArrayList<String>(4);
            Map<String, Column> nameAlisaMap = this.getNameAlisaMapFromModel(model);
            for (int i = 0; i < len; ++i) {
                String columnName = resultSet.getMetaData().getColumnName(i + 1).toUpperCase(Locale.ENGLISH);
                Column column = nameAlisaMap.get(columnName);
                if (column == null) {
                    columnNames.add(columnName);
                    columnAlias.add(columnName);
                    continue;
                }
                columnNames.add(column.getName());
                columnAlias.add(column.getAliasName());
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("columnNames", columnNames);
            resultMap.put("resultList", this.setDataToList(resultSet));
            resultMap.put("columnAlias", columnAlias);
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    private void processDefaultValue(List<DesignParameter> parameters) throws CtrlReportException {
        LinkedHashMap mapDesignParameter = new LinkedHashMap();
        RunReportParam.getExecuteParam(parameters, mapDesignParameter);
        RunReportParam.putDefalutListParamsMap((Object)this.qingContext, mapDesignParameter);
        for (DesignParameter parameter : parameters) {
            RunReportParam.processDefaultValue((Object)this.qingContext, (DesignParameter)parameter, parameters, mapDesignParameter);
        }
    }

    private Map<String, Column> getNameAlisaMapFromModel(CtrlDesignQueryModel model) {
        HashMap<String, Column> map = new HashMap<String, Column>();
        if (model != null) {
            Outputs outputs = model.getCommonQuery().getOutputs();
            OutputColumns ocs = null;
            if (outputs != null && !outputs.isEmpty()) {
                ocs = (OutputColumns)outputs.get(0);
                for (int i = 0; i < ocs.size(); ++i) {
                    Column oc = (Column)ocs.get(i);
                    map.put(oc.getName().toUpperCase(), oc);
                }
            }
        }
        return map;
    }

    private List<Map<String, Object>> setDataToList(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>(10);
        ResultSetMetaData rsmd = rs.getMetaData();
        int len = rsmd.getColumnCount();
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>(len);
            for (int i = 1; i <= len; ++i) {
                Object obj = rs.getObject(i);
                int type = rsmd.getColumnType(i);
                obj = obj == null ? "" : (type == 12 || type == 16 || type == 4 || type == 8 || type == 6 || type == 2 || type == -6 || type == 3 || type == 5 || type == 1 || type == -1 || type == -5 || type == -16 || type == -9 || type == -15 ? String.valueOf(obj) : (type == 91 ? dateFormat.format(obj) : (type == 92 ? timeFormat.format(obj) : (type == 93 ? timestampFormat.format(obj) : obj.toString()))));
                map.put(rsmd.getColumnName(i).toLowerCase(), obj);
            }
            lst.add(map);
        }
        return lst;
    }

    private Map<String, DesignParameter> getExecuteParams(List<DesignParameter> currentList, Map<String, String> paramMap) throws DataSetInvalidParamException {
        HashMap<String, DesignParameter> mapDesignParameter = new HashMap<String, DesignParameter>(currentList.size());
        for (DesignParameter parameter : currentList) {
            String name = parameter.getName();
            String valueAlias = parameter.getCurentValueAlias();
            DesignDataType designDataType = parameter.getDesignDataType();
            String value = paramMap.get(name);
            if (parameter.getInputState() == InputState.HIDDEN && (value = parameter.getDefaultValue()) != null) {
                value = ParamAnalysisHelper.replaceMultiValues((String)value);
            }
            try {
                RunReportParam.isValidInput((DesignParameter)parameter, (String)value);
            }
            catch (InvalidParamInputException e) {
                throw new DataSetInvalidParamException(e.getMessage(), e.getCause());
            }
            if (value != null) {
                parameter.setCurentValue(value);
            }
            DesignParameter dp = new DesignParameter();
            dp.setName(name);
            dp.setCurentValue(value);
            dp.setCurentValueAlias(valueAlias);
            dp.setDesignDataType(designDataType);
            mapDesignParameter.put(name, dp);
        }
        RunReportParam.getExecuteParam(currentList, mapDesignParameter);
        return mapDesignParameter;
    }

    public FilterInfo getFilter(String pageId, String paramCacheId, String schemaBiztagId) throws Exception {
        return this.getFilter(pageId, paramCacheId, schemaBiztagId, false);
    }

    public FilterInfo getFilter(String pageId, String paramCacheId, String schemaBiztagId, Boolean withF7SuppliedValue) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        List allUnionParam = reportImpl.getAllUnionParam();
        boolean isHyperLink = RuntimeDomain.handleHyperLinkParams(paramCacheId, allUnionParam);
        String presetUserId = IntegratedHelper.getPresetUserId();
        String createtorId = reportImpl.getExtReportVO().getCreatorId();
        if (StringUtils.isNotEmpty((CharSequence)schemaBiztagId) && createtorId != null && presetUserId.equals(createtorId)) {
            if (schemaBiztagId.contains("QingAnalysis")) {
                PublishPO publishPO = this.getCommonPublishDomain().checkPublishExist(schemaBiztagId);
                boolean authRight = this.getCommonPublishDomain().checkPublishAuthRight(publishPO);
                if (authRight) {
                    ThreadLocalUtil.set((String)"isPresetPublish", (Object)true);
                }
            } else {
                boolean authRight = this.getCommonPublishDomain().checkExtReportPublishAuthRight(schemaBiztagId);
                if (authRight) {
                    ThreadLocalUtil.set((String)"isPresetPublish", (Object)true);
                }
            }
        }
        WebParamAdapter paramAdapter = extReportImpl.getAdapter(cachePage);
        List<ReportParamDescription> paramList = RuntimeDomain.translateParams(this.qingContext, allUnionParam, paramAdapter.getSqlDbMap(), reportImpl.getReportId(), withF7SuppliedValue);
        cachePage.setAllUnionParam(allUnionParam);
        PageManager.cachePage((ExtReportCache)cachePage);
        reportImpl.setParamList(paramList);
        if (schemaBiztagId == null) {
            schemaBiztagId = cachePage.getExtReportID();
        }
        ExtFilterScheme lastUseFilterScheme = this.getFilterSchemeDomain().findLastUseFilterScheme(schemaBiztagId);
        ShareStrategy shareStrategy = null;
        shareStrategy = lastUseFilterScheme == null ? ShareStrategy.USER_ONLY : ShareStrategy.toShareStrategy((int)lastUseFilterScheme.getShareStrategy());
        List<FilterSchemeInfo> schemeList = this.getFilterSchemes(pageId, shareStrategy, schemaBiztagId);
        Map<String, List<String>> paramRef = this.buildParamRef(paramList);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.setParamList(paramList);
        filterInfo.setAssociate(paramRef);
        filterInfo.setHyperLink(isHyperLink);
        filterInfo.setSchemeList(schemeList);
        filterInfo.setShareStrategy(shareStrategy.ordinal());
        if (lastUseFilterScheme != null) {
            filterInfo.setHasDefaultEnter(true);
            filterInfo.setDefaultEnter(lastUseFilterScheme.getName());
        }
        return filterInfo;
    }

    private Map<String, List<String>> buildParamRef(List<ReportParamDescription> paramList) {
        HashMap<String, List<String>> paramRef = new HashMap<String, List<String>>();
        for (ReportParamDescription define : paramList) {
            String name = define.getName();
            List relations = define.getRelations();
            if (relations == null || relations.isEmpty()) continue;
            Iterator iter = relations.iterator();
            while (iter.hasNext()) {
                if (!name.equals(iter.next())) continue;
                iter.remove();
            }
            if (relations.isEmpty()) continue;
            paramRef.put(name, relations);
        }
        return paramRef;
    }

    public List<FilterSchemeInfo> getFilterSchemes(String pageId, ShareStrategy shareStrategy, String schemaBiztagId) throws Exception {
        List<ReportParamDescription> paramDescList;
        ArrayList<FilterSchemeInfo> schemeList = new ArrayList<FilterSchemeInfo>(10);
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        List allUnionParam = reportImpl.getAllUnionParam();
        extReportImpl.getFilter();
        FilterScheme defaultScheme = RuntimeDomain.getDefaultFilterScheme(allUnionParam);
        defaultScheme.setShareStrategy(shareStrategy);
        FilterSchemeInfo defaultSchemeInfo = new FilterSchemeInfo();
        defaultSchemeInfo.setCaption(defaultScheme.getCaption());
        defaultSchemeInfo.setValue(defaultScheme.toString());
        schemeList.add(defaultSchemeInfo);
        if (schemaBiztagId == null) {
            schemaBiztagId = cachePage.getExtReportID();
        }
        if (CollectionUtils.isEmpty((Collection)(paramDescList = reportImpl.getParamList()))) {
            WebParamAdapter paramAdapter = extReportImpl.getAdapter(cachePage);
            paramDescList = RuntimeDomain.translateParams(this.qingContext, allUnionParam, paramAdapter.getSqlDbMap(), reportImpl.getReportId(), true);
        }
        this.getFilterSchemesNotDefault(schemaBiztagId, shareStrategy, schemeList, paramDescList);
        return schemeList;
    }

    private void getFilterSchemesNotDefault(String schemaBiztagId, ShareStrategy shareStrategy, List<FilterSchemeInfo> schemeList, List<ReportParamDescription> paramDescList) throws Exception {
        int shareStrategyFlag = shareStrategy.ordinal();
        List schemes = this.getFilterSchemeDomain().findFilterSchemes(schemaBiztagId, shareStrategyFlag);
        if (schemes != null && !schemes.isEmpty()) {
            HashMap<String, ReportParamDescription> paramDescMap = new HashMap<String, ReportParamDescription>(paramDescList.size());
            for (ReportParamDescription paramDesc : paramDescList) {
                paramDescMap.put(paramDesc.getName(), paramDesc);
            }
            for (ExtFilterScheme scheme : schemes) {
                String name = scheme.getName();
                String whereValue = scheme.getContent();
                Map dpMap = RunReportParam.changWhereValueToMapParams((String)whereValue);
                Object[] defaultValueParams = new Object[paramDescMap.size()];
                Object[] defaultCaptionParams = new Object[paramDescMap.size()];
                Object[] nameParams = new Object[paramDescMap.size()];
                int index = 0;
                Iterator iterator = paramDescMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    String value = "";
                    String text = "";
                    Map.Entry entry = iterator.next();
                    ReportParamDescription paramDescription = (ReportParamDescription)entry.getValue();
                    DesignParameter designParameter = (DesignParameter)dpMap.get(paramDescription.getName());
                    if (designParameter != null) {
                        designParameter.setDefaultValue(designParameter.getCurentValue());
                        designParameter.setDefaultAlias(designParameter.getCurentValueAlias());
                        String ctrlType = paramDescription.getCtrlType();
                        Object oldParamDescDefaultValue = paramDescription.getDefaultValue();
                        if (CtrlType.F7.name().equals(ctrlType)) {
                            ExtFilterParamUtil.setF7DefaultValue((DesignParameter)designParameter, (ReportParamDescription)paramDescription);
                            ExtFilterParamUtil.checkF7DefaultValue((Object)this.qingContext, null, (DesignParameter)designParameter, (ReportParamDescription)paramDescription, (boolean)false);
                        } else if (CtrlType.CheckBoxGroup.name().equals(ctrlType)) {
                            ExtFilterParamUtil.setCheckBoxGroupDefaultValue((DesignParameter)designParameter, (ReportParamDescription)paramDescription);
                            ExtFilterParamUtil.checkCheckBoxDefaultValue((DesignParameter)designParameter, (ReportParamDescription)paramDescription);
                        } else if (CtrlType.ComboBox.name().equals(ctrlType)) {
                            ExtFilterParamUtil.setParamDefaultValue((DesignParameter)designParameter, (ReportParamDescription)paramDescription);
                            ExtFilterParamUtil.checkListDefaultValue((DesignParameter)designParameter, (ReportParamDescription)paramDescription);
                        }
                        paramDescription.setDefaultValue(oldParamDescDefaultValue);
                        value = designParameter.getDefaultValue();
                        text = designParameter.getDefaultAlias();
                        nameParams[index] = designParameter.getName();
                    } else {
                        nameParams[index] = paramDescription.getName();
                    }
                    defaultValueParams[index] = Collections.singletonList(value);
                    defaultCaptionParams[index] = Collections.singletonList(text);
                    ++index;
                }
                FilterScheme filterScheme = FilterScheme.createFilterScheme((String)name, (Object[])defaultValueParams, (Object[])defaultCaptionParams, (ShareStrategy)ShareStrategy.toShareStrategy((int)scheme.getShareStrategy()), (String)schemaBiztagId, (Object[])nameParams);
                FilterSchemeInfo schemeInfo = new FilterSchemeInfo();
                schemeInfo.setCaption(filterScheme.getCaption());
                schemeInfo.setValue(filterScheme + "");
                schemeInfo.setShareStrategy(filterScheme.getShareStrategy().ordinal());
                schemeList.add(schemeInfo);
            }
        }
        for (ReportParamDescription paramDesc : paramDescList) {
            if (!CtrlType.F7.name().equals(paramDesc.getCtrlType())) continue;
            paramDesc.setSuppliedValue(null);
        }
    }

    private String getOwnerId(int shareStrategy) {
        String ownerId = null;
        if (ShareStrategy.ALL.ordinal() != shareStrategy && ShareStrategy.USER_ONLY.ordinal() == shareStrategy) {
            ownerId = this.qingContext.getUserId();
        }
        return ownerId;
    }

    public FilterSchemeInfo saveFilterScheme(String reportId, List<DesignParameter> allUnionParam, String schemeName, ShareStrategy shareStrategy, boolean isDefaultChange, Object[] valueParams, Object[] captionParams, Object[] nameParams) throws AbstractQingIntegratedException, JAXBException, SQLException {
        FilterSchemeInfo info = new FilterSchemeInfo();
        if (schemeName.contains("script") || schemeName.contains("iframe") || schemeName.contains("<") || schemeName.contains(">")) {
            info.setInvalid(true);
            return info;
        }
        FilterScheme scheme = FilterScheme.createFilterScheme((String)schemeName, (Object[])valueParams, (Object[])captionParams, (ShareStrategy)shareStrategy, (String)reportId, (Object[])nameParams);
        ExtFilterScheme extFilterScheme = new ExtFilterScheme();
        extFilterScheme.setName(schemeName);
        extFilterScheme.setOwnerId(this.getOwnerId(shareStrategy.ordinal()));
        extFilterScheme.setReportId(reportId);
        extFilterScheme.setShareStrategy(shareStrategy.ordinal());
        extFilterScheme.setNextDirectlyInto(isDefaultChange);
        LinkedHashMap<String, DesignParameter> allUnionParamMap = new LinkedHashMap<String, DesignParameter>(allUnionParam.size());
        for (DesignParameter dp : allUnionParam) {
            allUnionParamMap.put(dp.getName(), dp);
        }
        int count = nameParams.length;
        LinkedHashMap<String, DesignParameter> paramValues = new LinkedHashMap<String, DesignParameter>(count);
        for (int index = 0; index < count; ++index) {
            String paramName = (String)nameParams[index];
            DesignParameter designParameter = new DesignParameter();
            designParameter.setName(paramName);
            designParameter.setDesignDataType(((DesignParameter)allUnionParamMap.get(paramName)).getDesignDataType());
            List valueParam = (List)valueParams[index];
            StringBuilder sCurentValue = new StringBuilder();
            for (String value : valueParam) {
                if (sCurentValue.length() > 0) {
                    sCurentValue.append("0xx1xx");
                }
                sCurentValue.append(value);
            }
            designParameter.setCurentValue(sCurentValue.toString());
            List captionParam = (List)captionParams[index];
            StringBuilder sCurentAlias = new StringBuilder();
            for (String caption : captionParam) {
                if (sCurentAlias.length() > 0) {
                    sCurentAlias.append("0xx1xx");
                }
                sCurentAlias.append(caption);
            }
            designParameter.setCurentValueAlias(sCurentAlias.toString());
            paramValues.put(paramName, designParameter);
        }
        String content = CtrlDesignUtil.toFilterSolutionXml(paramValues);
        extFilterScheme.setContent(content);
        this.getFilterSchemeDomain().saveOrUpdateFilterScheme(extFilterScheme);
        info.setCaption(schemeName);
        info.setValue(scheme.toString());
        info.setShareStrategy(extFilterScheme.getShareStrategy());
        return info;
    }

    public boolean delFilterScheme(String reportId, String filterName, ShareStrategy shareStrategy) throws AbstractQingIntegratedException, SQLException {
        return this.getFilterSchemeDomain().deleteFilterSchemeByFilterName(reportId, filterName, shareStrategy);
    }

    private static FilterScheme getDefaultFilterScheme(List<DesignParameter> allUnionParam) {
        int paramSize = allUnionParam != null ? allUnionParam.size() : 0;
        Object[] defaultValueParams = new Object[paramSize];
        Object[] defaultCaptionParams = new Object[paramSize];
        Object[] nameParams = new Object[paramSize];
        int size = -1;
        int j = 0;
        if (allUnionParam != null && (size = allUnionParam.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                DesignParameter dp = allUnionParam.get(i);
                if (InputType.EMPTY.equals((Object)dp.getInputType()) || InputType.Separator.equals((Object)dp.getInputType())) continue;
                nameParams[j] = dp.getName();
                String value = dp.getDefaultValue();
                String alias = dp.getDefaultAlias() != null ? dp.getDefaultAlias() : value;
                defaultValueParams[j] = Collections.singletonList(value);
                defaultCaptionParams[j] = Collections.singletonList(alias);
                ++j;
            }
        }
        return FilterScheme.createFilterScheme((String)MserviceRptMessages.getMLS((String)"defaultScheme", (String)"\u9ed8\u8ba4\u65b9\u6848"), (Object[])defaultValueParams, (Object[])defaultCaptionParams, null, null, (Object[])nameParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportInfo applyFilter(String pageId, int shareStrategy, String schemeName, String paramValues, Boolean isDefaultChange) throws Exception {
        try {
            PageManager.refreshDataSet.set(false);
            ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
            this.checkReportExist(cachePage.getExtReportID());
            String extReportID = cachePage.getExtReportID();
            ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
            extReportImpl.setQingContext(this.qingContext);
            extReportImpl.setDbExcuter(this.dbExcuter);
            if (isDefaultChange.booleanValue()) {
                String schemeId = null;
                if (schemeName.equals(MserviceRptMessages.getMLS((String)"defaultScheme", (String)"\u9ed8\u8ba4\u65b9\u6848"))) {
                    schemeId = "0";
                } else {
                    List extFilterSchemes = this.getFilterSchemeDomain().findFilterSchemes(extReportID, shareStrategy, schemeName);
                    if (extFilterSchemes != null && !extFilterSchemes.isEmpty()) {
                        schemeId = ((ExtFilterScheme)extFilterSchemes.get(0)).getUuid();
                    }
                }
                this.getFilterSchemeDomain().addOrUpdateExtFilterSchemeRelation(extReportID, schemeId, true);
            }
            ReportImpl reportImpl = extReportImpl.getReport();
            WebParamAdapter webParamAdapter = extReportImpl.getAdapter(cachePage);
            List allUnionParam = reportImpl.getAllUnionParam();
            webParamAdapter.setAllUnionParam(allUnionParam);
            String presetUserId = IntegratedHelper.getPresetUserId();
            String createtorId = reportImpl.getExtReportVO().getCreatorId();
            String publishId = (String)ThreadLocalUtil.get((String)"publishId");
            if (StringUtils.isNotEmpty((CharSequence)publishId) && createtorId != null && presetUserId.equals(createtorId)) {
                PublishPO publishPO = this.getCommonPublishDomain().checkPublishExist(publishId);
                boolean authRight = this.getCommonPublishDomain().checkPublishAuthRight(publishPO);
                if (authRight) {
                    ThreadLocalUtil.set((String)"isPresetPublish", (Object)true);
                }
            }
            Map<String, String> paramMap = RuntimeDomain.getParamMap(allUnionParam, paramValues, "value", false);
            Map<String, String> aliasMap = RuntimeDomain.getParamMap(allUnionParam, paramValues, "text", false);
            try {
                webParamAdapter.execute(paramMap, aliasMap, null);
            }
            catch (InvalidParamInputException e) {
                throw new DataSetInvalidParamException(e.getMessage(), e.getCause());
            }
            ServerRequestInvokeContext.staticCheckInterrupt((ServerRequestInvokeContext)ServerRequestInvokeContext.get());
            Book book = webParamAdapter.getBook();
            String oldBookFile = cachePage.getRuntimeBookFile();
            SnapReportControlModel snapReportControlModel = new SnapReportControlModel();
            snapReportControlModel.setSaveHyplink(true);
            Book snapShotBook = ExecutorUtil.generateSnapShotBook((Book)book, (SnapReportControlModel)snapReportControlModel);
            String newBookFile = PageManager.cacheExtData((byte[])BookIOUtil.pack((Book)snapShotBook));
            if (!oldBookFile.equals(cachePage.getTempletaBookFile()) && !oldBookFile.equals(newBookFile)) {
                PageManager.removeBookFile((QingContext)this.qingContext, (String)oldBookFile);
            }
            cachePage.setRuntimeBookFile(newBookFile);
            book = snapShotBook;
            reportImpl.setBook(book);
            reportImpl.setDbExcuter(this.dbExcuter);
            String curSheetName = book.getActiveSheet().getSheetName();
            reportImpl.setCurrentSheetName(curSheetName);
            BeanFactory.makeupReportModelBhv().behaviour(reportImpl);
            reportImpl.setPageId(pageId);
            ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(this.qingContext, reportImpl);
            cachePage.setSheetMap(reportImpl.getSheetMap());
            PageManager.cachePage((ExtReportCache)cachePage);
            ReportInfo reportInfo2 = reportInfo;
            return reportInfo2;
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    public TableRowSet getDelaySuppliedValue(String paramName, String textName, String valueName, int dataSourceType, String dataSetId, String xmlContent, String paramValues) throws Exception {
        PageManager.refreshDataSet.set(false);
        CtrlDesignQueryModel model = KSQLReportBO.initModel((Object)this.qingContext, (String)dataSetId, null);
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        List parameters = commonQuery.getParameters();
        return this.getDelaySuppliedValue(parameters, paramName, textName, valueName, dataSourceType, dataSetId, xmlContent, paramValues);
    }

    public TableRowSet getDelaySuppliedValue(List<DesignParameter> allUnionParam, String paramName, String textName, String valueName, int dataSourceType, String reportId, String xmlContent, String paramValues) throws Exception {
        String[] hiddenFieldsArr;
        TableRowSet rowSet;
        ArrayList<Entry> entryList;
        F7SuppliedValue f7SuppliedValue;
        List lst;
        Map<String, String> params = RuntimeDomain.parseParamValues(paramValues);
        TreeStructType treeStructType = null;
        String hiddenFields = null;
        String dataSetId = null;
        for (DesignParameter dp : allUnionParam) {
            IInputCtrl inputCtrl;
            if (!dp.getName().equals(paramName)) continue;
            DesignParameter[][] suppliers = null;
            try {
                suppliers = dp.getSupplierParams((Object)this.qingContext, null);
            }
            catch (CycleException e) {
                continue;
            }
            for (DesignParameter[] supplier : suppliers) {
                if (supplier[0] == null || supplier[1] == null) continue;
                String disKey = supplier[0].getName();
                String sourceKey = supplier[1].getName();
                if (!params.containsKey(sourceKey)) continue;
                String value = params.get(sourceKey);
                params.put(disKey, value);
            }
            if (!InputType.F7LIST.equals((Object)dp.getInputType()) || (inputCtrl = dp.getInputCtrl()) == null) break;
            if ("2".equals(inputCtrl.getDataSetType())) {
                try {
                    DefObj defDbsource = inputCtrl.getDefDbsource();
                    dataSetId = defDbsource == null ? null : defDbsource.getName();
                    CtrlDesignQueryModel model = KSQLReportBO.initModelFromXml((Object)this.qingContext, (String)xmlContent, null);
                    ExtReportOutDBBO.checkDataSetByDataSetIdAndModel((Object)this.qingContext, (CtrlDesignQueryModel)model, (String)dataSetId);
                }
                catch (CycleException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            treeStructType = inputCtrl.getTreeType();
            hiddenFields = inputCtrl.getHiddenFields();
            break;
        }
        if ((lst = (f7SuppliedValue = ExtFilterParamUtil.getF7SuppliedValueWithColumnMap((Object)this.qingContext, (String)reportId, (String)xmlContent, (String)textName, (String)valueName, (int)dataSourceType, params, dataSetId)).getColumnData()) == null || lst.isEmpty()) {
            entryList = new ArrayList<Entry>(10);
            rowSet = new TableRowSet();
            rowSet.setEntryList(entryList);
            rowSet.setNoPermFieldIndexs(f7SuppliedValue.getNoPermissionIndex());
            return rowSet;
        }
        if (treeStructType == null) {
            entryList = new ArrayList(lst.size());
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                Entry entry = new Entry();
                HashMap mapitem = (HashMap)it.next();
                entry.setText(CtrlReportUtil.getObjectString(mapitem.get(textName.toLowerCase())));
                entry.setValue(CtrlReportUtil.getObjectString(mapitem.get(valueName.toLowerCase())));
                entryList.add(entry);
            }
            rowSet = new TableRowSet();
            rowSet.setEntryList(entryList);
            rowSet.setNoPermFieldIndexs(f7SuppliedValue.getNoPermissionIndex());
            return rowSet;
        }
        Map columnAliasMap = f7SuppliedValue.getColumnMap();
        boolean columnAliasMapSetted = false;
        List<Object> hiddenFieldsList = new ArrayList(0);
        if (StringUtils.isNotBlank(hiddenFields) && (hiddenFieldsArr = StringUtils.split(hiddenFields, (char)';')) != null) {
            hiddenFieldsList = Arrays.asList(hiddenFieldsArr);
        }
        HashSet noPermField = new HashSet(8);
        ArrayList allFieldName = new ArrayList(columnAliasMap.keySet());
        if (CollectionUtils.isNotEmpty((Collection)f7SuppliedValue.getNoPermissionIndex())) {
            for (Integer index : f7SuppliedValue.getNoPermissionIndex()) {
                noPermField.add(allFieldName.get(index));
            }
        }
        ArrayList<TreeNodeEntry> entryList2 = new ArrayList<TreeNodeEntry>(lst.size());
        for (int i = 0; i < lst.size(); ++i) {
            TreeNodeEntry entry = new TreeNodeEntry();
            HashMap mapitem = (HashMap)lst.get(i);
            entry.setText(CtrlReportUtil.getObjectString(mapitem.get(textName.toLowerCase())));
            entry.setValue(CtrlReportUtil.getObjectString(mapitem.get(valueName.toLowerCase())));
            for (String string : hiddenFieldsList) {
                mapitem.remove(string.toLowerCase());
                if (columnAliasMapSetted) continue;
                columnAliasMap.remove(string.toLowerCase());
                noPermField.remove(string.toLowerCase());
            }
            columnAliasMapSetted = true;
            entry.setRows((Map)mapitem);
            entryList2.add(entry);
        }
        ArrayList<Integer> noPermIndex = new ArrayList<Integer>(noPermField.size());
        allFieldName = new ArrayList(columnAliasMap.keySet());
        for (int i = 0; i < allFieldName.size(); ++i) {
            if (!noPermField.contains(allFieldName.get(i))) continue;
            noPermIndex.add(i);
        }
        String currentNodeIdName = valueName.toLowerCase();
        String parentNodeIdName = "parentnodeid";
        int treeType = treeStructType.getTreeType();
        switch (treeType) {
            case -1: {
                break;
            }
            case 0: {
                if (dataSourceType == 6) {
                    currentNodeIdName = "id";
                    parentNodeIdName = "parentId";
                    break;
                }
                currentNodeIdName = treeStructType.getNodeCurrent().getName().toLowerCase();
                parentNodeIdName = treeStructType.getNodeParent().getName().toLowerCase();
                break;
            }
            case 1: {
                String string = treeStructType.getNodeLongNum().getName();
                String nodeSeparator = treeStructType.getNodeSeparator();
                lst = (ArrayList)ExtFilterParamUtil.translateLongNumberTreeType((List)lst, (String)string, (String)nodeSeparator, (String)currentNodeIdName, (String)parentNodeIdName);
                break;
            }
        }
        String textNameLowCase = textName.toLowerCase();
        String valueNameLowCase = valueName.toLowerCase();
        for (int i = 0; i < entryList2.size(); ++i) {
            TreeNodeEntry entry = (TreeNodeEntry)entryList2.get(i);
            HashMap hashMap = (HashMap)lst.get(i);
            entry.setId(CtrlReportUtil.getObjectString(hashMap.get(currentNodeIdName)));
            entry.setParentId(CtrlReportUtil.getObjectString(hashMap.get(parentNodeIdName)));
        }
        this.setParentIdNull(entryList2);
        TableRowSet rowSet2 = new TableRowSet();
        rowSet2.setEntryList(entryList2);
        rowSet2.setHead(columnAliasMap);
        rowSet2.setNoPermFieldIndexs(noPermIndex);
        return rowSet2;
    }

    private void setParentIdNull(List<TreeNodeEntry> entryList) {
        for (TreeNodeEntry entry : entryList) {
            if (!entry.getId().equals(entry.getParentId())) continue;
            entry.setParentId(null);
        }
    }

    public TableRowSet getDelaySuppliedValue(String pageId, String paramName, String textName, String valueName, int dataSourceType, String reportId, String xmlContent, String paramValues) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        WebParamAdapter webParamAdapter = extReportImpl.getAdapter(cachePage);
        List allUnionParam = reportImpl.getAllUnionParam();
        webParamAdapter.setAllUnionParam(allUnionParam);
        return this.getDelaySuppliedValue(allUnionParam, paramName, textName, valueName, dataSourceType, reportId, xmlContent, paramValues);
    }

    private static Map<String, String> parseParamValues(String paramValues) {
        HashMap<String, String> params = new HashMap<String, String>();
        JsonElement paramValuesJsonElement = JsonParser.parseString((String)paramValues);
        if (paramValuesJsonElement.isJsonArray()) {
            JsonArray jsonArray = paramValuesJsonElement.getAsJsonArray();
            int length = jsonArray.size();
            for (int index = 0; index < length; ++index) {
                String paramValue;
                JsonObject jsonObject;
                JsonElement vs;
                JsonElement o = jsonArray.get(index);
                if (!o.isJsonObject() || !(vs = (jsonObject = o.getAsJsonObject()).get("paramValues")).isJsonArray()) continue;
                JsonArray vsArray = vs.getAsJsonArray();
                String paramName = jsonObject.get("paramName").getAsString();
                if (vsArray.size() == 1) {
                    paramValue = "";
                    if (!vsArray.get(0).isJsonNull()) {
                        paramValue = vsArray.get(0).getAsString();
                    }
                    params.put(paramName, paramValue);
                    continue;
                }
                if (vsArray.size() <= 1) continue;
                paramValue = vsArray.get(0).getAsString();
                StringBuilder sb = new StringBuilder();
                sb.append(paramValue);
                int length2 = vsArray.size();
                for (int index2 = 1; index2 < length2; ++index2) {
                    sb.append("0xx1xx");
                    sb.append(vsArray.get(index2).getAsString());
                }
                params.put(paramName, sb.toString());
            }
        }
        return params;
    }

    public static Map<String, String> getParamMap(List<DesignParameter> paramlist, String strParams, String type, boolean isApplyFilter) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)strParams)) {
            return paramMap;
        }
        JsonElement jsonElement = JsonParser.parseString((String)strParams);
        if (!jsonElement.isJsonArray()) {
            return paramMap;
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        int size = -1;
        if (paramlist != null && (size = paramlist.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                JsonElement paramVarsElement;
                DesignParameter dp = paramlist.get(i);
                String paramName = dp.getName();
                if (dp.getInputState() == InputState.HIDDEN && isApplyFilter) {
                    if ("value".equals(type)) {
                        paramMap.put(paramName, dp.getDefaultValue());
                        continue;
                    }
                    paramMap.put(paramName, dp.getDefaultAlias());
                    continue;
                }
                JsonObject oParam = null;
                JsonElement tempParam = null;
                for (int j = 0; j < jsonArray.size(); ++j) {
                    String jsonParamName;
                    JsonObject jsonObject;
                    JsonElement paramNameElement;
                    tempParam = jsonArray.get(j);
                    if (!tempParam.isJsonObject() || !(paramNameElement = (jsonObject = tempParam.getAsJsonObject()).get("paramName")).isJsonPrimitive() || !paramName.equalsIgnoreCase(jsonParamName = paramNameElement.getAsString())) continue;
                    oParam = jsonObject;
                    break;
                }
                JsonArray arrVar = null;
                if (oParam != null && (paramVarsElement = oParam.get("paramVars")).isJsonArray()) {
                    arrVar = paramVarsElement.getAsJsonArray();
                }
                StringBuilder sbValue = new StringBuilder();
                if (arrVar == null) continue;
                for (int j = 0; j < arrVar.size(); ++j) {
                    JsonObject paramVarObject;
                    JsonElement typeJsonElement;
                    JsonElement paramVarElement = arrVar.get(j);
                    if (!paramVarElement.isJsonObject() || !(typeJsonElement = (paramVarObject = paramVarElement.getAsJsonObject()).get(type)).isJsonPrimitive()) continue;
                    String value = typeJsonElement.getAsString();
                    InputType inputType = dp.getInputType();
                    if (inputType != null && inputType.equals((Object)InputType.INPUT)) {
                        if (value != null) {
                            value = ParamAnalysisHelper.replaceMultiValues((String)value);
                        }
                        sbValue.append(value);
                        if (j + 1 >= arrVar.size()) continue;
                        sbValue.append("0xx1xx");
                        continue;
                    }
                    sbValue.append(value);
                    if (j + 1 >= arrVar.size()) continue;
                    sbValue.append("0xx1xx");
                }
                paramMap.put(paramName, sbValue.toString());
            }
        }
        return paramMap;
    }

    private static boolean handleHyperLinkParams(String paramCacheId, List<DesignParameter> paramlist) {
        String strParams = PageManager.getCacheParam((String)paramCacheId);
        if (StringUtils.isEmpty((CharSequence)strParams)) {
            return false;
        }
        JsonArray attParam = JsonParser.parseString((String)strParams).getAsJsonArray();
        if (attParam.size() > 0) {
            int size = -1;
            if (paramlist != null && (size = paramlist.size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    DesignParameter dp = paramlist.get(i);
                    String paramName = dp.getName();
                    JsonObject oParam = null;
                    for (int j = 0; j < attParam.size() && !paramName.equalsIgnoreCase((oParam = attParam.get(j).getAsJsonObject()).get("paramName").getAsString()); ++j) {
                    }
                    if (oParam == null) break;
                    JsonArray arrVar = oParam.get("paramVars").getAsJsonArray();
                    String dataType = oParam.get("dataType").getAsString();
                    StringBuilder sbValue = new StringBuilder();
                    StringBuilder sbText = new StringBuilder();
                    for (int j = 0; j < arrVar.size(); ++j) {
                        Date date;
                        JsonObject var = arrVar.get(j).getAsJsonObject();
                        String value = var.get("value").getAsString();
                        String text = var.get("text").getAsString();
                        if (DataType.Date.name().equalsIgnoreCase(dataType) && StringUtil.isNumber((String)value)) {
                            date = Variant.decimalToCalender((BigDecimal)new BigDecimal(value)).getTime();
                            value = ((DateFormat)CtrlReportUtil.sdf_yyyy_MM_dd.get()).format(date);
                        }
                        if (DataType.DateTime.name().equalsIgnoreCase(dataType) && StringUtil.isNumber((String)value)) {
                            date = Variant.decimalToCalender((BigDecimal)new BigDecimal(value)).getTime();
                            value = ((DateFormat)CtrlReportUtil.sdfDateTime.get()).format(date);
                        }
                        if (DataType.Time.name().equalsIgnoreCase(dataType) && StringUtil.isNumber((String)value)) {
                            date = Variant.decimalToCalender((BigDecimal)new BigDecimal(value)).getTime();
                            value = ((DateFormat)CtrlReportUtil.sdfTime.get()).format(date);
                        }
                        if (sbValue.length() > 0) {
                            sbValue.append("0xx1xx");
                            sbText.append("0xx1xx");
                        }
                        sbValue.append(value);
                        sbText.append(text);
                    }
                    dp.setDefaultValue(sbValue.toString());
                    dp.setDefaultAlias(sbText.toString());
                    dp.setCurentValue(sbValue.toString());
                    dp.setCurentValueAlias(sbText.toString());
                }
            }
        }
        return true;
    }

    public static List<ReportParamDescription> translateParams(QingContext qingContext, List<DesignParameter> allUnionParam, Map sqlDbMap, String reportId) throws Exception {
        return RuntimeDomain.translateParams(qingContext, allUnionParam, sqlDbMap, reportId, true);
    }

    public static List<ReportParamDescription> translateParams(QingContext qingContext, List<DesignParameter> allUnionParam, Map sqlDbMap, String reportId, Boolean withF7SuppliedValue) throws Exception {
        Locale easLocale = null;
        if (qingContext != null) {
            easLocale = qingContext.getIi18nContext().getLanManager().getLocale();
        }
        ArrayList<ReportParamDescription> paramList = new ArrayList<ReportParamDescription>(10);
        int size = -1;
        if (allUnionParam != null && (size = allUnionParam.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                F7ParamDescription param;
                DesignParameter dp = allUnionParam.get(i);
                InputType inputType = dp.getInputType();
                if (InputType.EMPTY.equals((Object)inputType) || InputType.Separator.equals((Object)inputType)) continue;
                IInputCtrl unit = dp.getInputCtrl();
                if (InputType.F7LIST.equals((Object)inputType)) {
                    F7ParamDescription f7ParamDescription;
                    param = f7ParamDescription = new F7ParamDescription();
                    if (unit != null) {
                        TreeStructType treeStructType;
                        DefObj def = unit.getDefDbsource();
                        if (def != null) {
                            f7ParamDescription.setBindSourceName(def.getAlias());
                            String maxRestrictNumber = unit.getRowLimit();
                            if (unit.isAllowMultipleSelected() && maxRestrictNumber != null) {
                                f7ParamDescription.setMaxRestrictNumber(Integer.parseInt(maxRestrictNumber));
                            } else {
                                f7ParamDescription.setMaxRestrictNumber(1);
                            }
                        }
                        if ((treeStructType = unit.getTreeType()) != null) {
                            boolean isTree = false;
                            switch (treeStructType.getTreeType()) {
                                case 0: 
                                case 1: {
                                    isTree = true;
                                    break;
                                }
                                case -1: {
                                    isTree = false;
                                    break;
                                }
                                default: {
                                    isTree = false;
                                }
                            }
                            f7ParamDescription.setIsTree(Boolean.valueOf(isTree));
                            f7ParamDescription.setTreeExpandLevel(treeStructType.getTreeExpandLevel());
                        }
                        f7ParamDescription.setEditable(Boolean.valueOf(unit.isAllowEdit()));
                    }
                } else if (InputType.DATE.equals((Object)inputType)) {
                    param = new DateParamDescription();
                } else {
                    param = new ReportParamDescription();
                    if (InputType.LIST.equals((Object)inputType) && unit != null) {
                        param.setEditable(Boolean.valueOf(unit.isAllowEdit()));
                    }
                }
                DesignParameter[] rela = dp.getRelatedParams();
                if (rela != null && rela.length != 0) {
                    ArrayList<String> relation = new ArrayList<String>(rela.length);
                    for (int k = 0; k < rela.length; ++k) {
                        relation.add(rela[k].getName());
                    }
                    param.setRelations(relation);
                }
                param.setDataType((Enum)ExtFilterParamUtil.translateDataType((DesignDataType)dp.getDesignDataType()));
                param.setRequired(Boolean.valueOf(!dp.isAllowNull()));
                param.setName(dp.getName());
                param.setState((Enum)ExtFilterParamUtil.translateState((InputState)dp.getInputState()));
                param.setText(easLocale == null ? dp.getAliasName() : dp.getAliasName(easLocale));
                param.setDescription(dp.getDescription());
                try {
                    ExtFilterParamUtil.translateCtrlType((Object)qingContext, (DesignParameter)dp, (ReportParamDescription)param, (String)reportId, (boolean)withF7SuppliedValue, (Map)sqlDbMap, allUnionParam);
                }
                catch (ExtMacroException e) {
                    throw new ExtMacroNotExistsException(e.getErrorCode(), (Throwable)e, e.getErrorMessage());
                }
                catch (ExtDataSetNoExisitException e) {
                    throw new DataSetNotExistsException(e.getErrorMessage(), (Throwable)e);
                }
                catch (ExtDataSetNoPermissionException e) {
                    throw new DataSetNoPermissionException(e.getErrorMessage(), (Throwable)e);
                }
                catch (DataCenterNoPermissionException e) {
                    throw new kd.bos.mservice.extreport.runtime.exception.DataCenterNoPermissionException((Throwable)e);
                }
                catch (Exception e) {
                    throw e;
                }
                paramList.add((ReportParamDescription)param);
            }
        }
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportInfo excuteExtReport(String pageId, String paramCacheId) throws Exception {
        try {
            PageManager.refreshDataSet.set(false);
            ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
            this.checkReportExist(cachePage.getExtReportID());
            ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
            Boolean isPreview = (Boolean)ThreadLocalUtil.get((String)"isPreview");
            String creatorId = extReportImpl.getExtReportVO().getCreatorId();
            String systemUserId = IntegratedHelper.getPresetUserId();
            if (!Boolean.TRUE.equals(isPreview) && systemUserId.equals(creatorId)) {
                ThreadLocalUtil.set((String)"isPresetPublish", (Object)true);
            }
            extReportImpl.setQingContext(this.qingContext);
            extReportImpl.setDbExcuter(this.dbExcuter);
            Map<Object, Object> paramMap = new HashMap();
            Map<Object, Object> aliasMap = new HashMap();
            WebParamAdapter webParamAdapter = extReportImpl.getAdapter(cachePage);
            ReportImpl reportImpl = extReportImpl.getReport();
            List allUnionParam = reportImpl.getAllUnionParam();
            webParamAdapter.setAllUnionParam(allUnionParam);
            List paramList = reportImpl.getParamList();
            if (paramCacheId != null && !"".equals(paramCacheId)) {
                String paramJson = PageManager.getCacheParam((String)paramCacheId);
                paramMap = RuntimeDomain.getParamMap(allUnionParam, paramJson, "value", false);
                aliasMap = RuntimeDomain.getParamMap(allUnionParam, paramJson, "text", false);
            } else if (allUnionParam != null && !allUnionParam.isEmpty()) {
                int size = allUnionParam.size();
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    DesignParameter dp = (DesignParameter)allUnionParam.get(i);
                    String paramName = dp.getName();
                    String value = dp.getDefaultValue();
                    String alias = dp.getDefaultAlias();
                    InputType inputType = dp.getInputType();
                    if (InputType.INPUT.equals((Object)inputType)) {
                        if (value != null) {
                            value = ParamAnalysisHelper.replaceMultiValues((String)value);
                        }
                        if (alias != null) {
                            alias = ParamAnalysisHelper.replaceMultiValues((String)alias);
                        }
                    }
                    if (!StringUtil.isEmptyString((String)value)) {
                        paramMap.put(paramName, value);
                        aliasMap.put(paramName, alias);
                    }
                    if (InputType.EMPTY.equals((Object)inputType) || InputType.Separator.equals((Object)inputType)) {
                        paramMap.put(paramName, value);
                        aliasMap.put(paramName, alias);
                        continue;
                    }
                    if (InputType.ALONE_CHECKBOX.equals((Object)inputType)) {
                        paramMap.put(paramName, value);
                        aliasMap.put(paramName, alias);
                    }
                    ++j;
                }
            }
            try {
                webParamAdapter.execute(paramMap, aliasMap, paramCacheId);
            }
            catch (InvalidParamInputException e) {
                throw new DataSetInvalidParamException(e.getMessage(), e.getCause());
            }
            ServerRequestInvokeContext.staticCheckInterrupt((ServerRequestInvokeContext)ServerRequestInvokeContext.get());
            Book book = webParamAdapter.getBook();
            String oldBookFile = cachePage.getRuntimeBookFile();
            SnapReportControlModel snapReportControlModel = new SnapReportControlModel();
            snapReportControlModel.setSaveHyplink(true);
            Book snapShotBook = ExecutorUtil.generateSnapShotBook((Book)book, (SnapReportControlModel)snapReportControlModel);
            String newBookFile = PageManager.cacheExtData((byte[])BookIOUtil.pack((Book)snapShotBook));
            if (!oldBookFile.equals(cachePage.getTempletaBookFile()) && !oldBookFile.equals(newBookFile)) {
                PageManager.removeBookFile((QingContext)this.qingContext, (String)oldBookFile);
            }
            cachePage.setRuntimeBookFile(newBookFile);
            String curSheetName = book.getActiveSheet().getSheetName();
            book = snapShotBook;
            reportImpl.setCurrentSheetName(curSheetName);
            cachePage.setCurrentSheetName(curSheetName);
            reportImpl.setPageId(pageId);
            reportImpl.setBook(book);
            reportImpl.setDbExcuter(this.dbExcuter);
            BeanFactory.makeupReportModelBhv().behaviour(reportImpl);
            ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(this.qingContext, reportImpl);
            cachePage.setSheetMap(reportImpl.getSheetMap());
            PageManager.cachePage((ExtReportCache)cachePage);
            ReportInfo reportInfo2 = reportInfo;
            return reportInfo2;
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    private void setPublishOperValue(ExtReportRuntimeInfo extReportRuntimeInfo, String publishId) throws AbstractQingIntegratedException, SQLException, PublishNotFoundException, PublishNoPermissionException {
        extReportRuntimeInfo.setHasPrintPermission(true);
        extReportRuntimeInfo.setHasExportPermission(true);
        extReportRuntimeInfo.setHasSaveSnapshotPermission(true);
        PublishPO publishPO = this.getCommonPublishDomain().checkPublishExist(publishId);
        this.getCommonPublishDomain().checkRightAndReturnIsAnonymous(publishPO);
        Map noOperValueMap = this.getCommonPublishDomain().loadPublishOperList(publishId, null, true, false);
        Integer noOperAuthValue = (Integer)noOperValueMap.get(PublishOperTypeEnum.QING_RPT.getType());
        if (noOperAuthValue != null && noOperAuthValue != 0) {
            extReportRuntimeInfo.setHasExportPermission(!ExtReportOperCodeEnum.hasExportPermission((int)noOperAuthValue));
            extReportRuntimeInfo.setHasPrintPermission(!ExtReportOperCodeEnum.hasPrintPermission((int)noOperAuthValue));
            extReportRuntimeInfo.setHasSaveSnapshotPermission(!ExtReportOperCodeEnum.hasSaveSnapshotPermission((int)noOperAuthValue));
        }
    }

    public void checkSaveSnapPermission(String reportId, String publishId) throws SnapInvalidParamException {
        boolean hasSaveSnapPermission = false;
        try {
            ExtReportRuntimeInfo runtimeInfo = new ExtReportRuntimeInfo();
            runtimeInfo.setReportId(reportId);
            if (StringUtils.isNotBlank((CharSequence)publishId)) {
                this.setPublishOperValue(runtimeInfo, publishId);
            } else {
                this.setPublishOperValue(runtimeInfo);
            }
            hasSaveSnapPermission = runtimeInfo.isHasSaveSnapshotPermission();
        }
        catch (PublishNotFoundException runtimeInfo) {
        }
        catch (PublishNoPermissionException runtimeInfo) {
        }
        catch (Exception e) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.CHECK_USER_RPT_PERM_EXCEPTION);
        }
        if (!hasSaveSnapPermission) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.NO_RPT_PERM_EXCEPTION);
        }
    }

    private void setPublishOperValue(ExtReportRuntimeInfo runtimeInfo) throws AbstractQingIntegratedException, SQLException {
        runtimeInfo.setHasPrintPermission(false);
        runtimeInfo.setHasExportPermission(false);
        runtimeInfo.setHasSaveSnapshotPermission(false);
        List publishPOList = this.getCommonPublishDomain().loadPublishInfos(runtimeInfo.getReportId(), null);
        for (PublishPO publishPO : publishPOList) {
            boolean hasRight = this.getCommonPublishDomain().checkPublishAuthRight(publishPO);
            if (hasRight) {
                Map noOperValueMap = this.getCommonPublishDomain().loadPublishOperList(publishPO.getId(), null, true, false);
                Integer noOperAuthValue = (Integer)noOperValueMap.get(PublishOperTypeEnum.QING_RPT.getType());
                if (noOperAuthValue == null) {
                    runtimeInfo.setHasExportPermission(true);
                    runtimeInfo.setHasPrintPermission(true);
                    runtimeInfo.setHasSaveSnapshotPermission(true);
                    break;
                }
                if (!ExtReportOperCodeEnum.hasExportPermission((int)noOperAuthValue)) {
                    runtimeInfo.setHasExportPermission(true);
                }
                if (!ExtReportOperCodeEnum.hasPrintPermission((int)noOperAuthValue)) {
                    runtimeInfo.setHasPrintPermission(true);
                }
                if (!ExtReportOperCodeEnum.hasSaveSnapshotPermission((int)noOperAuthValue)) {
                    runtimeInfo.setHasSaveSnapshotPermission(true);
                }
            }
            if (!runtimeInfo.isHasExportPermission() || !runtimeInfo.isHasPrintPermission() || !runtimeInfo.isHasSaveSnapshotPermission()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInfo loadFragment(String pageId, Integer pageIndex) throws Exception {
        try {
            PageManager.refreshDataSet.set(false);
            ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
            ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
            extReportImpl.setQingContext(this.qingContext);
            extReportImpl.setDbExcuter(this.dbExcuter);
            ReportImpl reportImpl = extReportImpl.getReport();
            if (pageIndex != null) {
                SheetImpl sheetModel = reportImpl.getCurrentSheet();
                int startRow = sheetModel.getPerNum() * pageIndex;
                sheetModel.setEndRow(startRow - 1);
                sheetModel.setStartRow(startRow);
            }
            reportImpl.setDbExcuter(this.dbExcuter);
            reportImpl.setBook(extReportImpl.getAdapter(cachePage).getBook());
            ExecutionContext executionContext = reportImpl.getBook().getDataSetManager().getExecutionContext();
            if (executionContext != null) {
                executionContext.registerDataSetFactories(WebParamAdapter.getDataSetFactories());
            }
            TableInfo tableInfo = BeanFactory.outputTableBhv().behaviour(reportImpl, this.qingContext);
            cachePage.setSheetMap(reportImpl.getSheetMap());
            PageManager.cachePage((ExtReportCache)cachePage);
            TableInfo tableInfo2 = tableInfo;
            return tableInfo2;
        }
        finally {
            PageManager.refreshDataSet.remove();
        }
    }

    public SheetInfo switchSheet(String pageId, String sheetName, boolean switchOnly) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        SheetInfo sheetInfo = null;
        cachePage.setCurrentSheetName(sheetName);
        reportImpl.setDbExcuter(this.dbExcuter);
        if (switchOnly) {
            reportImpl.setCurrentSheetName(sheetName);
        } else {
            Book book = extReportImpl.getAdapter(cachePage).getBook();
            Sheet sheet = book.getSheet(sheetName);
            SheetImpl sheetImpl = reportImpl.getSheet(sheetName);
            this.assembleUncachedContent(sheetImpl, sheet);
            ExecutionContext executionContext = book.getDataSetManager().getExecutionContext();
            if (executionContext != null) {
                executionContext.registerDataSetFactories(WebParamAdapter.getDataSetFactories());
            }
            reportImpl.setBook(book);
            sheetInfo = BeanFactory.outputSheetBhv().behaviour(this.qingContext, reportImpl, sheetName);
            cachePage.setSheetMap(reportImpl.getSheetMap());
        }
        PageManager.cachePage((ExtReportCache)cachePage);
        return sheetInfo;
    }

    public String exportToFile(String pageId, Map<String, String> params) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        reportImpl.setBook(extReportImpl.getAdapter(cachePage).getBook());
        String exportType = params.get("exportType");
        File exportFile = null;
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            String jsonExportSetting = params.get("exportSetting");
            SetupModel setupModel = (SetupModel)JsonUtil.decodeFromString((String)jsonExportSetting, SetupModel.class);
            PageSetup pageSetup = PageSetupFactory.buildPageSetup((SetupModel)setupModel);
            exportFile = this.getExportDomain().exportToPdf(reportImpl, pageSetup);
        } else {
            String jsonExportConfig = params.get("isMegerExport");
            boolean isMegerExport = true;
            if (!StringUtil.isEmptyString((String)jsonExportConfig)) {
                isMegerExport = Boolean.parseBoolean(jsonExportConfig);
            }
            if (ExportType.TYPE_EXCEL.equalsIgnoreCase(exportType)) {
                exportFile = this.getExportDomain().exportToXsl(reportImpl, isMegerExport);
            } else if (ExportType.TYPE_EXCEL2007.equalsIgnoreCase(exportType)) {
                exportFile = this.getExportDomain().exportToXlsx(reportImpl, isMegerExport);
            } else {
                String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"unsupportedReportExportFormat", (String)"\u4e0d\u652f\u6301\u7684\u62a5\u8868\u5bfc\u51fa\u683c\u5f0f\uff1a");
                throw new ExtReportException(msg + exportType);
            }
        }
        IQingFile qingFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        try {
            qingFile.write((IWriteCall)new CopyWriteCall((InputStream)new FileInputStream(exportFile), false), true);
        }
        catch (FileNotFoundException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ExtReportException((Throwable)e);
        }
        return qingFile.getName();
    }

    public String cacheParamValues(String paramValues) {
        return PageManager.addCacheParam((String)paramValues);
    }

    private void assembleUncachedContent(SheetImpl sheetImpl, Sheet sheet) {
        boolean hor = sheetImpl.isHor();
        if (hor) {
            sheetImpl.setItems(sheet.getColSpans());
        } else {
            sheetImpl.setItems(sheet.getRowSpans());
        }
    }

    public TableInfo lazyLoadTree(String pageId, Integer rowIdx, Integer treeLevel) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        Book book = extReportImpl.getAdapter(cachePage).getBook();
        reportImpl.setDbExcuter(this.dbExcuter);
        reportImpl.setBook(book);
        String currentSheetName = reportImpl.getCurrentSheetName();
        Sheet sheet = book.getSheet(currentSheetName);
        this.assembleUncachedContent(reportImpl.getCurrentSheet(), sheet);
        TableInfo tableInfo = BeanFactory.outputTableTreeBhv().behaviour(reportImpl, rowIdx.intValue(), treeLevel.intValue(), this.qingContext);
        cachePage.setSheetMap(reportImpl.getSheetMap());
        PageManager.cachePage((ExtReportCache)cachePage);
        return tableInfo;
    }

    public LinkModel cellInnerLink(String pageId, String currentSheetName, String linkSrc) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        Book book = extReportImpl.getAdapter(cachePage).getBook();
        LinkParamVo linkParam = new LinkParamVo();
        linkParam.setLinkSrc(linkSrc);
        return RuntimeDomain.cellInnerLink(linkParam, currentSheetName, book, pageId, extReportImpl.getReport(), this.qingContext, this.dbExcuter);
    }

    public List<LinkModel> lookForLinkageTargets(String pageId, String currentSheetName, String linkSrc) throws Exception {
        LinkModel outerModel;
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        Book book = extReportImpl.getAdapter(cachePage).getBook();
        EmbedLinkParamVO embedLinkParamVO = (EmbedLinkParamVO)JsonUtil.decodeFromString((String)linkSrc, EmbedLinkParamVO.class);
        Sheet sheet = book.getSheet(currentSheetName);
        EmbedhLayer layer = sheet.getEmbedments(false);
        ChartRectEmbedment chart = null;
        for (int i = 0; i < layer.size(); ++i) {
            EmbedObject embed = layer.getEmbed(i);
            if (!(embed instanceof ChartRectEmbedment)) continue;
            FlashChartModel model = ((ChartRectEmbedment)embed).getModel();
            if (embedLinkParamVO == null || !embedLinkParamVO.getChartId().equals(model.getChartID())) continue;
            chart = (ChartRectEmbedment)embed;
            break;
        }
        ArrayList<LinkModel> models = new ArrayList<LinkModel>(2);
        LinkModel innerModel = this.collectInnerLinkageTargets(chart);
        if (innerModel != null) {
            models.add(innerModel);
        }
        if ((outerModel = this.collectOuterLinkageTargets(chart, reportImpl, embedLinkParamVO)) != null) {
            models.add(outerModel);
        }
        return models;
    }

    public String executeChangedChart(String pageId, String currentSheetName, String chartID, String type) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        Book book = extReportImpl.getAdapter(cachePage).getBook();
        Sheet sheet = book.getSheet(currentSheetName);
        EmbedhLayer layer = sheet.getEmbedments(false);
        for (int i = 0; i < layer.size(); ++i) {
            EmbedObject embed = layer.getEmbed(i);
            if (embed instanceof EChart && chartID.equals(((EChart)embed).getModel().getChartID())) {
                EChart eChart = (EChart)embed;
                FlashChartModel srcModel = eChart.getModel();
                FlashChartType chartType = FlashChartType.getChartType((String)type);
                srcModel.setChartType(chartType);
                srcModel.getDataNode().setChartType((AbstractType)chartType);
                AbstractFusionBean bean = AbstractFusionBean.createBean((FlashChartType)chartType);
                bean.setChartType(chartType);
                bean.setTransformable_chart(srcModel.getBean().getTransformable_chart());
                bean.setContainerWidth(eChart.getBounds().width, null);
                bean.setContainerHeight(eChart.getBounds().height, null);
                srcModel.setBean(bean);
                srcModel.getDataNode().setDirty(false);
                DataLabelUtil.changeFlashChartType2DataSortLabel(null, (FlashChartType)chartType, (ChartFrameWorkType)srcModel.getFrameWorkType()).prepareProperties(bean, srcModel.getDataNode());
                List script = TransferMapper.transfer2ExecuteScript((FlashChartModel)srcModel, (boolean)false);
                String str = this.getStr(script);
                str = "\n myChart.off('legendselectchanged'); \n" + str;
                return str;
            }
            if (!(embed instanceof QingChart) || !chartID.equals(((QingChart)embed).getModel().getChartID())) continue;
            QingChart qingChart = (QingChart)embed;
            FlashChartModel srcModel = qingChart.getModel();
            QingChartType chartType = QingChartType.getType((String)type);
            srcModel.setChartType((FlashChartType)chartType);
            srcModel.getDataNode().setChartType((AbstractType)chartType);
            AbstractFusionBean bean = AbstractFusionBean.createBean((FlashChartType)chartType);
            bean.setChartType((FlashChartType)chartType);
            bean.setTransformable_chart(srcModel.getBean().getTransformable_chart());
            bean.setContainerWidth(qingChart.getBounds().width, null);
            bean.setContainerHeight(qingChart.getBounds().height, null);
            srcModel.setBean(bean);
            srcModel.getDataNode().setDirty(false);
            DataLabelUtil.changeFlashChartType2DataSortLabel(null, (FlashChartType)chartType, (ChartFrameWorkType)srcModel.getFrameWorkType()).prepareProperties(bean, srcModel.getDataNode());
            return QingTransferUtil.buildScript((FlashChartModel)srcModel, (boolean)false);
        }
        return null;
    }

    private String getStr(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append("//--\n");
        }
        return sb.toString();
    }

    private LinkModel collectOuterLinkageTargets(ChartRectEmbedment embedment, ReportImpl report, EmbedLinkParamVO embedLinkParamVO) {
        if (embedment == null) {
            return null;
        }
        ETTargets extTargets = embedment.getModel().getExtTargets();
        if (extTargets == null) {
            return null;
        }
        List targets = extTargets.getTargets();
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        LinkModel linkModel = new LinkModel();
        linkModel.setLinkType("outterLink");
        Cell activeCell = embedment.getSheet().getActiveCell();
        if (activeCell == null) {
            activeCell = embedment.getSheet().getCell(1048574, 65534, true);
        }
        ExtProps ep = activeCell.getExtProps(true);
        HashMap<String, String> reportIdCache = new HashMap<String, String>(8);
        HashMap<String, Book> targetBookDataCache = new HashMap<String, Book>(8);
        for (ExtTransitionTarget target : targets) {
            String pathAlias;
            ReportProperties reportProps = target.getReportProps();
            Object obj = ep.executeCalculableProps(reportProps.getCalculableProps());
            if (obj != null) {
                reportProps.setAlias(obj.toString());
            }
            String reportId = reportProps.getId();
            boolean findByIdFlag = false;
            if (reportId != null) {
                try {
                    ExtReportVO reportVOById = null;
                    pathAlias = reportProps.getPathAlias();
                    String creatorId = report.getExtReportVO() == null ? "" : report.getExtReportVO().getCreatorId();
                    String key = StringUtils.join((Object[])new Object[]{creatorId, pathAlias}, (char)'_');
                    if (reportIdCache.containsKey(key)) {
                        reportId = (String)reportIdCache.get(key);
                        findByIdFlag = true;
                    } else {
                        reportVOById = this.getExtReportDao().loadExtReportByID(reportId, creatorId);
                        if (reportVOById != null) {
                            reportIdCache.put(key, reportId);
                            findByIdFlag = true;
                        }
                    }
                }
                catch (Exception e) {
                    reportId = null;
                    LogUtil.warn((String)(MserviceRptMessages.getMLS((String)"queryLinkedReportExceptionBasedOnID", (String)"\u6839\u636eID\u67e5\u8be2\u8054\u67e5\u62a5\u8868\u5f02\u5e38") + e.getMessage()));
                }
            }
            if (!findByIdFlag) {
                try {
                    String creatorId = report.getExtReportVO() == null ? "" : report.getExtReportVO().getCreatorId();
                    pathAlias = reportProps.getPathAlias();
                    String key = StringUtils.join((Object[])new Object[]{creatorId, pathAlias}, (char)'_');
                    if (reportIdCache.containsKey(key)) {
                        reportId = (String)reportIdCache.get(key);
                    } else {
                        reportId = this.getExtReportDao().getReportIdByCreatorAndPath(pathAlias, creatorId);
                        reportIdCache.put(key, reportId);
                    }
                }
                catch (Exception e) {
                    reportId = null;
                    LogUtil.warn((String)(MserviceRptMessages.getMLS((String)"queryLinkedReportException", (String)"\u67e5\u8be2\u8054\u67e5\u62a5\u8868\u5f02\u5e38") + e.getMessage()));
                }
            }
            String reportName = reportProps.getName();
            String systemId = reportProps.getPath();
            String alias = reportProps.getAlias();
            String domain = reportProps.getDomain();
            boolean isDefault = extTargets.getDefaultTarget() == target;
            ArrayList<ParamValue> paramValues = new ArrayList<ParamValue>(10);
            Map params = target.getParameters();
            ep.executeParams(params);
            Book book = this.prepareReportBook(reportId, reportProps.getPathAlias(), targetBookDataCache);
            ReportBookHelper.executeParamsDefaultValue(this.qingContext, params, null, reportProps, this.dbExcuter, book);
            ChartInnerLinkExec.executeChartParams((Map)params, (ChartDataItemInfo)embedLinkParamVO);
            for (Object p : params.keySet()) {
                ParamValue paramValue = new ParamValue();
                String key = p.toString();
                ParameterImpl param = (ParameterImpl)params.get(key);
                DataType dataTypeEnum = DataType.get((int)param.getDataType());
                String dataType = dataTypeEnum.name().toLowerCase();
                paramValue.setDataType(dataType);
                paramValue.setName(param.getName());
                paramValue.setAlias(param.getAlias());
                Variant vt = param.getValue();
                Date date = null;
                if (vt != null && vt.getVt() == 13) {
                    date = Variant.calendarToGMTDate((Calendar)((GregorianCalendar)vt.getValue()));
                } else if (vt != null && vt.getVt() == 12) {
                    date = (Date)vt.getValue();
                }
                if (date != null) {
                    switch (dataTypeEnum) {
                        case DateTime: {
                            paramValue.setValues(((DateFormat)CtrlReportUtil.sdfDateTime.get()).format(date));
                            break;
                        }
                        case Date: {
                            paramValue.setValues(((DateFormat)CtrlReportUtil.sdf_yyyy_MM_dd.get()).format(date));
                            break;
                        }
                        case Time: {
                            paramValue.setValues(((DateFormat)CtrlReportUtil.sdfTime.get()).format(date));
                        }
                    }
                } else {
                    paramValue.setValues(Variant2String.toString((Variant)vt));
                }
                paramValues.add(paramValue);
            }
            linkModel.addHyperLink(reportId, reportName, alias, systemId, domain, isDefault, paramValues);
        }
        return linkModel;
    }

    private Book prepareReportBook(String reportId, String pathAlias, Map<String, Book> targetBookDataCache) {
        Book book;
        String cacheKey = StringUtils.join((Object[])new Object[]{reportId, pathAlias}, (char)'_');
        if (targetBookDataCache.containsKey(cacheKey)) {
            book = targetBookDataCache.get(cacheKey);
        } else {
            book = ReportBookHelper.getReportBook(reportId, this.dbExcuter);
            if (null != book) {
                targetBookDataCache.put(cacheKey, book);
            }
        }
        return book;
    }

    private LinkModel collectInnerLinkageTargets(ChartRectEmbedment embedment) {
        if (embedment == null) {
            return null;
        }
        InnerLinkTargets innerTargets = embedment.getModel().getInnerTargets();
        if (innerTargets == null) {
            return null;
        }
        List targets = innerTargets.getTargets();
        if (targets == null || targets.isEmpty()) {
            return null;
        }
        LinkModel linkModel = new LinkModel();
        linkModel.setLinkType("innerLink");
        return linkModel;
    }

    private void filterInnerTarget(List<InnerLinkTransitionTarget> targets, ChartRectEmbedment embedment) {
        if (targets == null) {
            return;
        }
        List subReportCells = embedment.getSheet().getSubReportCells();
        EmbedhLayer embedments = embedment.getSheet().getEmbedments(false);
        if (!(subReportCells != null && !subReportCells.isEmpty() || embedments != null && embedments.size() > 1)) {
            targets.clear();
            return;
        }
        Iterator<InnerLinkTransitionTarget> iterator = targets.iterator();
        while (iterator.hasNext()) {
            InnerLinkTransitionTarget target = iterator.next();
            String linkName = target.getTargetProps().getId((ICalculable)embedment.getModel().getDataNode());
            boolean exist = false;
            if (subReportCells != null) {
                for (Cell cell : subReportCells) {
                    if (!cell.getName(false, true).equals(linkName)) continue;
                    exist = true;
                    break;
                }
            }
            if (!exist && embedments != null) {
                int embedSize = embedments.size();
                if (linkName.indexOf("!") > 0) {
                    linkName = linkName.split("!")[1];
                }
                for (int i = 0; i < embedSize; ++i) {
                    EmbedObject embed = embedments.getEmbed(i);
                    if (!(embed instanceof ChartRectEmbedment) || !linkName.equals(embed.getName())) continue;
                    exist = true;
                    break;
                }
            }
            if (exist) continue;
            iterator.remove();
        }
    }

    public LinkModel chartInnerLink(String pageId, String currentSheetName, String linkSrc) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl report = extReportImpl.getReport();
        Book book = extReportImpl.getAdapter(cachePage).getBook();
        Sheet sheet = book.getSheet(currentSheetName);
        EmbedhLayer layer = sheet.getEmbedments(false);
        ChartRectEmbedment chart = null;
        EmbedLinkParamVO paramVO = (EmbedLinkParamVO)JsonUtil.decodeFromString((String)linkSrc, EmbedLinkParamVO.class);
        for (int i = 0; i < layer.size(); ++i) {
            EmbedObject embed = layer.getEmbed(i);
            if (!(embed instanceof ChartRectEmbedment)) continue;
            FlashChartModel model = ((ChartRectEmbedment)embed).getModel();
            if (paramVO == null || paramVO.getChartId() == null || !paramVO.getChartId().equals(model.getChartID())) continue;
            chart = (ChartRectEmbedment)embed;
            break;
        }
        if (chart == null || chart.getModel().getInnerTargets() == null) {
            return null;
        }
        InnerLinkTargets innerTargets = chart.getModel().getInnerTargets();
        List targets = innerTargets.getTargets();
        ChartInnerLinkWebExec webExec = new ChartInnerLinkWebExec(book, pageId, report, this.qingContext, this.dbExcuter);
        webExec.setEmbedment(chart);
        webExec.setParamVO((ChartDataItemInfo)paramVO);
        webExec.setTargets(targets);
        return webExec.execute();
    }

    public static LinkModel cellInnerLink(LinkParamVo linkParam, String currentSheetName, Book book, String pageId, ReportImpl report, QingContext qingContext, IDBExcuter dbExcuter) throws InnerLinkException {
        String linkSrc = linkParam.getLinkSrc();
        String[] arrName = linkSrc.split("!");
        if (arrName == null || arrName.length != 2) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)qingContext.getIi18nContext(), (String)"failedToParseTheCurrentCellCorrectly", (String)"\u672a\u80fd\u6b63\u786e\u89e3\u6790\u5f53\u524d\u5355\u5143\u683c");
            throw new InnerLinkException(msg + "[" + linkSrc + "]!");
        }
        String cellName = arrName[1];
        Sheet sheet = book.getSheet(currentSheetName);
        Cell cell = ((CellBlockNode)sheet.getRange(cellName).getBlock(0)).getFirstCell(false);
        if (cell == null) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)qingContext.getIi18nContext(), (String)"failedToParseTheCurrentCellCorrectly", (String)"\u672a\u80fd\u6b63\u786e\u89e3\u6790\u5f53\u524d\u5355\u5143\u683c");
            throw new InnerLinkException(msg + "[" + cellName + "]!");
        }
        HyperlinkCalculableProps hyperLinkCalProps = ReportBookHelper.getHyperLink(cell);
        if (hyperLinkCalProps != null) {
            Map tars = hyperLinkCalProps.getTargets();
            InnerLinkTargets innerTars = (InnerLinkTargets)tars.get("EXT_INNER");
            CellInnerLinkWebExec executor = new CellInnerLinkWebExec(book, pageId, report, qingContext, dbExcuter);
            executor.setCell(cell);
            executor.setInnerLinkTargets(innerTars);
            return executor.execute();
        }
        String msg = MserviceRptMessages.getLangMessage((II18nContext)qingContext.getIi18nContext(), (String)"noLinkedTargetFound", (String)"\u672a\u627e\u5230\u5f53\u524d\u5355\u5143\u683c\u9700\u8981\u8054\u52a8\u7684\u76ee\u6807\uff01");
        throw new InnerLinkException(msg);
    }

    public Map<String, List<String>> getSnapNameByInputText(String userId, String inputText) throws AbstractQingIntegratedException, SQLException {
        List snapNameList = this.getSnapInfoDomain().getSnapNameByInputText(userId, inputText);
        HashMap<String, List<String>> snapNameMap = new HashMap<String, List<String>>(1);
        snapNameMap.put(inputText, snapNameList);
        return snapNameMap;
    }

    public List<ExtReportSnapFolderVO> loadExtReportSnapGroupTypes(String snapId) throws AbstractQingIntegratedException, SQLException, SnapInvalidParamException {
        return this.getExtReportSnapGroupDomain().loadExtReportSnapGroupTypes(snapId);
    }

    public List<ExtReportSnapFolderVO> loadExtReportSnapGroupTreeInfo(String snapId) throws AbstractQingIntegratedException, SQLException, SnapInvalidParamException {
        return this.getExtReportSnapGroupDomain().loadExtReportSnapGroupTreeInfo(this.qingContext.getUserId(), snapId);
    }

    public String saveSnapInfo(String pageId, Map<String, String> params, boolean withTx) throws Exception {
        boolean onlyUpdateSnapInfo;
        this.getSnapInfoDomain().checkSnapCenterModule();
        this.getSnapInfoDomain().checkSnapCenterQueryPermission();
        ExtReportSnapSaveInfo extReportSnapSaveInfo = new ExtReportSnapSaveInfo();
        extReportSnapSaveInfo.setSnapName(params.get("snapName"));
        if (StringUtils.isEmpty((CharSequence)extReportSnapSaveInfo.getSnapName())) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_NAME_NULL_EXCEPTION);
        }
        if (extReportSnapSaveInfo.getSnapName().length() > 50) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_NAME_LENGTH_EXCEPTION);
        }
        if (!Pattern.matches("^([\u4e00-\u9fa5a-zA-Z_])[\u4e00-\u9fa5a-zA-Z0-9_]*$", extReportSnapSaveInfo.getSnapName())) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_NAME_INVALID_EXCEPTION);
        }
        if (Pattern.compile("\\b(null|true|false)\\b", 2).matcher(extReportSnapSaveInfo.getSnapName()).find()) {
            String message = SnapErrorCodeEnum.SNAP_NAME_INVALID_EXCEPTION_2.getMessage().replace("#1", extReportSnapSaveInfo.getSnapName());
            throw new SnapInvalidParamException(message, SnapErrorCodeEnum.SNAP_NAME_INVALID_EXCEPTION_2.getCode());
        }
        extReportSnapSaveInfo.setSnapGroupId(params.get("saveSnapGroupId"));
        if (StringUtils.isEmpty((CharSequence)extReportSnapSaveInfo.getSnapGroupId())) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GROUP_NULL_EXCEPTION);
        }
        extReportSnapSaveInfo.setSnapId(params.get("snapId"));
        ExtReportCache cachePage = null;
        Date now = new Date();
        String snapId = extReportSnapSaveInfo.getSnapId();
        boolean overwriteFlag = Boolean.parseBoolean(params.get("overwrite"));
        boolean forceOverwrite = Boolean.parseBoolean(params.get("forceOverwrite"));
        overwriteFlag = forceOverwrite ? forceOverwrite : overwriteFlag;
        extReportSnapSaveInfo.setOverwrite(overwriteFlag);
        boolean bl = onlyUpdateSnapInfo = StringUtils.isNotBlank((CharSequence)snapId) && !extReportSnapSaveInfo.isOverwrite();
        if (onlyUpdateSnapInfo) {
            extReportSnapSaveInfo.setReportId(params.get("reportId"));
        } else {
            String oldSnapId = params.get("oldSnapId");
            if (StringUtils.isNotBlank((CharSequence)oldSnapId)) {
                this.getSnapInfoDomain().checkSnapExist(oldSnapId);
            } else {
                ExtReportVO reportVO = this.getExtReportDao().loadExtReportByID(params.get("reportId"));
                if (reportVO == null) {
                    throw new SnapInvalidParamException(SnapErrorCodeEnum.REPORT_NOT_FOUND_EXCEPTION);
                }
            }
            cachePage = PageManager.getCachePage((String)pageId);
            extReportSnapSaveInfo.setSaveHyperlink(Boolean.parseBoolean(params.get("isHyperLink")));
            extReportSnapSaveInfo.setReportId(cachePage.getExtReportID());
            extReportSnapSaveInfo.setReportPeriod(ExtReportSnapPeriodType.EMPTY);
            extReportSnapSaveInfo.setCreatorId(this.qingContext.getUserId());
            extReportSnapSaveInfo.setCreateDate(now);
        }
        if (StringUtils.isEmpty((CharSequence)extReportSnapSaveInfo.getReportId())) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.REPORT_NOT_FOUND_EXCEPTION);
        }
        extReportSnapSaveInfo.setModifierId(this.qingContext.getUserId());
        extReportSnapSaveInfo.setModifyDate(now);
        if (!onlyUpdateSnapInfo) {
            String publishId = params.get("publishId");
            if (StringUtils.isNotBlank((CharSequence)publishId)) {
                this.checkSaveSnapPermission(extReportSnapSaveInfo.getReportId(), publishId);
            } else {
                this.checkSaveSnapPermission(extReportSnapSaveInfo.getReportId(), null);
            }
        }
        snapId = withTx ? this.saveSnapInfoInnerWithTx(extReportSnapSaveInfo, cachePage, onlyUpdateSnapInfo) : this.saveSnapInfoInnerWithoutTx(extReportSnapSaveInfo, cachePage, onlyUpdateSnapInfo);
        return snapId;
    }

    private String saveSnapInfoInnerWithoutTx(ExtReportSnapSaveInfo extReportSnapSaveInfo, ExtReportCache cachePage, boolean onlyUpdateSnapInfo) throws Exception {
        boolean existSnapGroup = this.getExtReportSnapGroupDomain().existSnapGroup(extReportSnapSaveInfo.getSnapGroupId());
        if (!existSnapGroup) {
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GROUP_NOT_FOUND_EXCEPTION);
        }
        String snapId = this.getSnapInfoDao().saveOrUpdateSnapInfo(extReportSnapSaveInfo);
        if (!onlyUpdateSnapInfo) {
            byte[] runtimeSnapData = PageManager.getCachedExtData((String)cachePage.getRuntimeBookFile());
            Book runtimeSnapBook = BookIOUtil.unpack((byte[])runtimeSnapData);
            SnapReportControlModel controlModel = new SnapReportControlModel();
            controlModel.setSaveHyplink(extReportSnapSaveInfo.isSaveHyperlink());
            byte[] snapData = ExecutorUtil.generateSnapShot((Book)runtimeSnapBook, (SnapReportControlModel)controlModel);
            this.getSnapContentDao().saveSnapContent(snapId, snapData);
        }
        return snapId;
    }

    private String saveSnapInfoInnerWithTx(ExtReportSnapSaveInfo extReportSnapSaveInfo, ExtReportCache cachePage, boolean onlyUpdateSnapInfo) throws Exception {
        ILock transactionLock = LockFactory.createLock((String)("QingTransactionLockSaveSnapshot" + this.qingContext.getAccountId()));
        try {
            transactionLock.lock();
            this.tx.beginRequired();
            String string = this.saveSnapInfoInnerWithoutTx(extReportSnapSaveInfo, cachePage, onlyUpdateSnapInfo);
            return string;
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
            transactionLock.unlock();
        }
    }

    public ExtReportSnapRuntimeInfo loadExtReportSnapInfo(String snapId) throws Exception {
        ExtReportCache cachePage;
        ExtReportImpl extReportImpl;
        ReportImpl report;
        ExtReportSnapInfoPO snapInfoPO = this.getSnapInfoDomain().getSnapInfoPOById(snapId);
        byte[] data = this.getSnapContentDao().loadSnapContent(snapId);
        String dataName = PageManager.cacheExtData((byte[])data);
        String pageId = UUID.randomUUID().toString();
        ExtReportCache cacheMeta = new ExtReportCache(pageId, snapInfoPO.getReportId());
        cacheMeta.setTempletaBookFile(dataName);
        cacheMeta.setRuntimeBookFile(dataName);
        ExtReportVO extReportVO = this.getExtReportDao().loadExtReportByID(snapInfoPO.getReportId());
        cacheMeta.setExtReportVO(extReportVO);
        PageManager.cachePage((ExtReportCache)cacheMeta);
        PageManager.cacheClientId((String)pageId);
        ExtReportSnapRuntimeInfo runtimeInfo = new ExtReportSnapRuntimeInfo();
        runtimeInfo.setPageId(pageId);
        runtimeInfo.setReportId(snapInfoPO.getReportId());
        runtimeInfo.setSnapId(snapId);
        runtimeInfo.setExtReportName(extReportVO == null ? null : extReportVO.getExtReportName());
        runtimeInfo.setHasModel(true);
        this.setPublishOperValue((ExtReportRuntimeInfo)runtimeInfo);
        if (extReportVO != null) {
            runtimeInfo.setCreatorName(IntegratedHelper.getUserName((String)extReportVO.getCreatorId()));
            runtimeInfo.setCreateTime(DateUtils.timeStampToString((long)(extReportVO.getCreateTime() / 1000L), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ((report = (extReportImpl = (cachePage = PageManager.getCachePage((String)pageId)).getExtReportImpl()).getReport()) != null) {
            Book book = report.getBook();
            runtimeInfo.setSetupModel(this.initSetupModel(book));
        }
        return runtimeInfo;
    }

    public ReportInfo executeExtReportFromSnapContent(String pageId) throws Exception {
        ExtReportCache cachePage = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cachePage.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        Book book = reportImpl.getBook();
        String curSheetName = book.getActiveSheet().getSheetName();
        reportImpl.setCurrentSheetName(curSheetName);
        cachePage.setCurrentSheetName(curSheetName);
        reportImpl.setPageId(pageId);
        reportImpl.setBook(book);
        reportImpl.setDbExcuter(this.dbExcuter);
        Map dataSetFactories = WebParamAdapter.getDataSetFactories();
        ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
        if (ctx != null) {
            ctx.registerDataSetFactories(dataSetFactories);
        }
        BeanFactory.makeupReportModelBhv().behaviour(reportImpl);
        ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(this.qingContext, reportImpl);
        cachePage.setSheetMap(reportImpl.getSheetMap());
        PageManager.cachePage((ExtReportCache)cachePage);
        return reportInfo;
    }

    public void checkSnapOperPermission(Map<String, String> params) throws SnapInvalidParamException, AbstractQingIntegratedException, SQLException {
        boolean snapCenterQueryPerm = Boolean.parseBoolean(params.get("snapCenterQueryPerm"));
        boolean snapExist = Boolean.parseBoolean(params.get("snapExist"));
        String snapId = params.get("snapId");
        if (snapCenterQueryPerm) {
            this.getSnapInfoDomain().checkSnapCenterQueryPermission();
        }
        if (snapExist && StringUtils.isNotBlank((CharSequence)snapId)) {
            this.getSnapInfoDomain().checkSnapExist(snapId);
        }
    }

    public void checkPresetManagePermission(Map<String, String> params) throws AbstractQingIntegratedException, SQLException, SnapInvalidParamException, ExtReportNoPermissionException {
        String snapId = params.get("snapId");
        ExtReportSnapInfoPO snapInfo = null;
        if (snapId != null) {
            snapInfo = this.getSnapInfoDomain().getSnapInfoPOById(snapId);
        }
        if (snapInfo != null) {
            ExtReportVO extReportVO = this.getSnapInfoDomain().getExtReportDao().loadExtReportByID(snapInfo.getReportId());
            String presetUserId = IntegratedHelper.getPresetUserId();
            if (extReportVO != null && presetUserId.equals(extReportVO.getCreatorId()) && !IntegratedHelper.checkExtReportPresetManagePermission((QingContext)this.qingContext)) {
                throw new ExtReportNoPermissionException(MserviceRptMessages.getMLS((String)"noPermissionForPresetReportPleaseContactAdminForAuthorization", (String)"\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u62a5\u8868\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002"));
            }
        }
    }

    public void checkReportExist(String reportId) throws AbstractQingIntegratedException, SQLException, ExtReportNotExistsException {
        ExtReportVO reportVO = this.getExtReportDao().loadExtReportByID(reportId);
        if (reportVO == null) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theLightReportDoesNotExist", (String)"\u8be5\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
            throw new ExtReportNotExistsException(msg);
        }
    }

    public void checkDataSetExist(String dataSetId) throws DataSetNotExistsException, AbstractQingIntegratedException, SQLException {
        DataSetVO dataSetVO = this.getDataSetManageDomain().loadDataSet(dataSetId);
        if (dataSetVO == null) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theDatasetDoesNotExist", (String)"\u8be5\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
            throw new DataSetNotExistsException(msg);
        }
    }

    public String[] analysisParamJson(JsonElement oJson, String type, int index) {
        JsonObject jsonObject = oJson.getAsJsonObject();
        JsonElement jsonElement = jsonObject.get(type);
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        jsonElement = jsonArray.get(index);
        jsonArray = jsonElement.getAsJsonArray();
        int count = jsonArray.size();
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            String str;
            ret[i] = str = jsonArray.get(i).getAsString();
        }
        return ret;
    }

    public void closeClient(String clientId) {
        String pageId = PageManager.getCachedPageId((String)clientId);
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return;
        }
        this.cleanRuntimePageCache(pageId);
    }

    public void cleanRuntimePageCache(String pageId) {
        try {
            if (pageId != null) {
                ExtReportCache cache = (ExtReportCache)QingSessionUtil.getCache((String)ExtReportCache.getCacheKey((String)pageId), ExtReportCache.class);
                if (cache != null) {
                    PageManager.removeBookFile((QingContext)this.qingContext, (String)cache.getRuntimeBookFile());
                    PageManager.removeBookFile((QingContext)this.qingContext, (String)cache.getTempletaBookFile());
                    QingSessionUtil.remove((String)ExtReportCache.getCacheKey((String)pageId));
                }
                PageManager.removeDataSetContent((QingContext)this.qingContext, (String)pageId);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)MserviceRptMessages.getMLS((String)"cacheClearException", (String)"\u6e05\u7406\u7f13\u5b58\u5f02\u5e38"), (Throwable)e);
        }
    }

    public FilterInfoVO getReportFilter(String reportId, String publishId) throws Exception {
        return this.getReportFilter(reportId, publishId, false);
    }

    public FilterInfoVO getReportFilter(String reportId, String publishId, Boolean withF7SuppliedValue) throws Exception {
        FilterInfoVO filterInfoVO = null;
        FilterInfo filterInfo = null;
        ExtReportRuntimeInfo runtimeInfo = this.loadExtReportInfo(reportId, null, false, null, false);
        if (runtimeInfo.isHasFilter()) {
            filterInfo = this.getFilter(runtimeInfo.getPageId(), null, publishId, withF7SuppliedValue);
            filterInfoVO = FilterInfoVO.fromFilterInfo((FilterInfo)filterInfo);
            filterInfoVO.setHasFilter(runtimeInfo.isHasFilter());
            filterInfoVO.setPageId(runtimeInfo.getPageId());
            return filterInfoVO;
        }
        filterInfoVO = new FilterInfoVO();
        filterInfoVO.setHasFilter(runtimeInfo.isHasFilter());
        filterInfoVO.setPageId(runtimeInfo.getPageId());
        return filterInfoVO;
    }

    public Map<String, ReportParamDescription> getReportParamDesc(String pageId) throws Exception {
        ExtReportCache cache = PageManager.getCachePage((String)pageId);
        ExtReportImpl extReportImpl = cache.getExtReportImpl();
        extReportImpl.setQingContext(this.qingContext);
        extReportImpl.setDbExcuter(this.dbExcuter);
        ReportImpl reportImpl = extReportImpl.getReport();
        List allUnionParam = reportImpl.getAllUnionParam();
        if (allUnionParam == null) {
            return Collections.emptyMap();
        }
        WebParamAdapter paramAdapter = extReportImpl.getAdapter(cache);
        List<ReportParamDescription> paramList = RuntimeDomain.translateParams(this.qingContext, allUnionParam, paramAdapter.getSqlDbMap(), reportImpl.getReportId(), true);
        HashMap<String, ReportParamDescription> mapReportParamDesc = new HashMap<String, ReportParamDescription>(paramList.size());
        for (ReportParamDescription param : paramList) {
            mapReportParamDesc.put(param.getName(), param);
        }
        return mapReportParamDesc;
    }

    public String generateSnapshot(String param) throws Exception {
        ExtReportSnapSavingModel snapSavingModel = (ExtReportSnapSavingModel)JsonUtil.decodeFromString((String)param, ExtReportSnapSavingModel.class);
        if (StringUtils.isBlank((CharSequence)snapSavingModel.getReportName()) || StringUtils.isBlank((CharSequence)snapSavingModel.getReportGroupName()) || StringUtils.isBlank((CharSequence)snapSavingModel.getSnapName()) || StringUtils.isBlank((CharSequence)snapSavingModel.getSnapGroupType()) || StringUtils.isBlank((CharSequence)snapSavingModel.getSnapGroupName()) || null == snapSavingModel.getSaveHyperLink() || null == snapSavingModel.getOverwriteSnap()) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"parameterError", (String)"\u53c2\u6570\u9519\u8bef");
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GENERATE_EXCEPTION, msg);
        }
        return this.generateSnapshot(snapSavingModel);
    }

    public String generateSnapshot(ExtReportSnapSavingModel snapSavingModel) throws Exception {
        ExtReportVO reportVO = snapSavingModel.getReportId() == null ? this.getExtReportDao().loadExtReportInfoByNameAndGroupName(snapSavingModel.getReportName(), snapSavingModel.getReportGroupName(), this.qingContext.getUserId()) : this.getExtReportDao().loadExtReportByID(snapSavingModel.getReportId());
        if (reportVO == null) {
            String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theLightReportDoesNotExist", (String)"\u8be5\u62a5\u8868\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002");
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GENERATE_EXCEPTION, msg);
        }
        ExtReportRuntimeInfo runtimeInfo = null;
        try {
            runtimeInfo = this.loadExtReportInfo(reportVO.getExtReportID(), null, false, null, false);
        }
        catch (Exception e) {
            LogUtil.error((String)MserviceRptMessages.getMLS((String)"getReportInfoException", (String)"\u83b7\u53d6\u62a5\u8868\u4fe1\u606f\u5f02\u5e38"), (Throwable)e);
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GENERATE_EXCEPTION, (Throwable)e);
        }
        String invalidData = runtimeInfo.getInvalidData();
        if (invalidData != null) {
            throw new SnapInvalidParamException(invalidData, SnapErrorCodeEnum.EXTREPORT_DATASET_REJECT_EXEC_EXCEPTION.getCode());
        }
        String paramValues = null;
        if (snapSavingModel.getFilterParam() != null) {
            paramValues = JsonUtil.encodeToString((Object)snapSavingModel.getFilterParam());
        }
        try {
            if (paramValues == null) {
                this.excuteExtReport(runtimeInfo.getPageId(), null);
            } else {
                this.applyFilter(runtimeInfo.getPageId(), 1, "", paramValues, false);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)MserviceRptMessages.getMLS((String)"executeReportException", (String)"\u6267\u884c\u62a5\u8868\u5f02\u5e38"), (Throwable)e);
            throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GENERATE_EXCEPTION, (Throwable)e);
        }
        ILock generateLock = LockFactory.createLock((String)("QingRptLockGenerateSnapshot" + this.qingContext.getUserId()));
        try {
            generateLock.lock();
            this.tx.beginRequired();
            String snapGroupId = snapSavingModel.getSnapGroupId();
            if (snapGroupId == null && (snapGroupId = this.getExtReportSnapGroupDomain().findSnapGroupByTypeAndName(snapSavingModel.getSnapGroupType(), snapSavingModel.getSnapGroupName())) == null) {
                ExtReportSnapGroupVO snapGroupVO = new ExtReportSnapGroupVO();
                snapGroupVO.setExtReportSnapGroupName(snapSavingModel.getSnapGroupName());
                snapGroupVO.setExtReportSnapGroupType(ExtReportSnapGroupType.getValueByDesc((String)snapSavingModel.getSnapGroupType()));
                snapGroupId = this.getExtReportSnapGroupDomain().saveOrUpdateExtReportSnapGroupWithoutTx(snapGroupVO, this.qingContext.getUserId());
            }
            String snapId = this.getSnapInfoDao().existSnapName(snapGroupId, reportVO.getExtReportID(), snapSavingModel.getSnapName());
            boolean overwriteSnapFlag = snapSavingModel.getOverwriteSnap();
            if (!overwriteSnapFlag && snapId != null) {
                String msg = MserviceRptMessages.getLangMessage((II18nContext)this.qingContext.getIi18nContext(), (String)"theSameSnapshotAlreadyExists", (String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5feb\u7167");
                throw new SnapInvalidParamException(SnapErrorCodeEnum.SNAP_GENERATE_EXCEPTION, msg);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("snapName", snapSavingModel.getSnapName());
            params.put("saveSnapGroupId", snapGroupId);
            params.put("isHyperLink", snapSavingModel.getSaveHyperLink().toString());
            params.put("overwrite", snapSavingModel.getOverwriteSnap().toString());
            params.put("reportId", reportVO.getExtReportID());
            params.put("publishId", snapSavingModel.getPublishId());
            String string = this.saveSnapInfo(runtimeInfo.getPageId(), params, false);
            return string;
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            if (runtimeInfo != null) {
                this.cleanRuntimePageCache(runtimeInfo.getPageId());
            }
            this.tx.end();
            generateLock.unlock();
        }
    }

    private String buildErrorMessage(Map<String, String> invalidDataMap) {
        StringBuilder errorMessage = new StringBuilder();
        int index = 1;
        for (Map.Entry<String, String> entry : invalidDataMap.entrySet()) {
            errorMessage.append(this.buildMessageItem(index, entry.getKey(), entry.getValue()));
            ++index;
        }
        return errorMessage.toString().replaceAll("\\\\", "/");
    }

    private String buildMessageItem(int index, String key, String value) {
        String msg = MserviceRptMessages.getMLS((String)"dataSetInfo", (String)"%1$s\u3001\u540d\u79f0:%2$s; \u8def\u5f84:%3$s");
        return String.format(msg, index, key, value);
    }

    public static interface ReportDataSetChecker {
        public boolean check(ExtDataSet var1) throws AbstractQingIntegratedException, SQLException;
    }
}

