/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.extreport.util;

import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;

public class DataSetExecuteChecker {
    private static final String QING_RPT_DATASET_REJECTIDS = "qing.rpt.dataset.rejectids";
    private static final String QING_RPT_DATASET_PREFIX = "qing_rpt";
    private static final char SPLIT_CHAR = '-';

    private DataSetExecuteChecker() {
    }

    public static boolean checkDataSetExecutableById(String dataSetId) {
        if (StringUtils.isEmpty((CharSequence)dataSetId)) {
            return true;
        }
        String rejectIdsJson = SystemPropertyUtil.getString((String)QING_RPT_DATASET_REJECTIDS);
        if (StringUtils.isEmpty((CharSequence)rejectIdsJson)) {
            return true;
        }
        String accountID = DataSetExecuteChecker.getAccountID();
        try {
            Map idsMap = (Map)JsonUtil.decodeFromString((String)rejectIdsJson, Map.class);
            if (idsMap == null || !idsMap.containsKey(accountID)) {
                return true;
            }
            List nodes = (List)idsMap.get(accountID);
            for (String node : nodes) {
                if (!"all".equalsIgnoreCase(node) && !node.equals(dataSetId)) continue;
                return false;
            }
        }
        catch (Exception e) {
            LogUtil.error((String)("check dataSet executable error. dataSetId:" + dataSetId), (Throwable)e);
            return true;
        }
        return true;
    }

    public static String formatSql(String sql, String dataSetId) {
        if (StringUtils.isEmpty((CharSequence)sql) || StringUtils.isEmpty((CharSequence)dataSetId)) {
            return sql;
        }
        String accountID = DataSetExecuteChecker.getAccountID();
        return String.format("/*%s%s%s%s%s*/%s", QING_RPT_DATASET_PREFIX, Character.valueOf('-'), accountID, Character.valueOf('-'), dataSetId, sql);
    }

    public static String getAccountID() {
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            return null;
        }
        return requestContext.getAccountId();
    }
}

