/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.network.blacklist.IpBlackList;
import com.kingdee.bos.qing.common.spi.IQProfilerSupporter;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.data.domain.macro.IMacroExecutor;
import com.kingdee.bos.qing.data.domain.macro.RuntimeMacroRegister;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBTableCreator;
import com.kingdee.bos.qing.data.domain.source.db.IBizSourceConversionStrategy;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionProvider;
import com.kingdee.bos.qing.data.domain.source.db.IDBConnectionCheckerStrategy;
import com.kingdee.bos.qing.data.domain.source.db.IStoredProcedure;
import com.kingdee.bos.qing.data.domain.source.db.JDBCConnectionPool;
import com.kingdee.bos.qing.data.domain.source.db.JDBCModel;
import com.kingdee.bos.qing.data.domain.source.db.JDBCPooledConnection;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.impl.DefaultResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.handler.ColumnListHandler;
import com.kingdee.bos.qing.data.domain.source.db.handler.LeafNodeHandler;
import com.kingdee.bos.qing.data.domain.source.db.handler.StoredProcedureParamsHandler;
import com.kingdee.bos.qing.data.domain.source.db.handler.VersionResultSetHandler;
import com.kingdee.bos.qing.data.domain.source.db.impl.AccessSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.AliyunOdpsSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.ApacheDrillSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.DB2SourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.DMSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.FlyDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.GBaseSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.GaussDB100SourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.GaussDB200300SourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.GaussDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.GaussDBVersionEnum;
import com.kingdee.bos.qing.data.domain.source.db.impl.HANASourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.HiveSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.ImpalaSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.KingBaseSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.KylinSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.MySQLSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.OceanBaseForOracleSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.OpenLookengSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.OracleSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.PostgreSQLSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.RedShiftSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.SQLServerSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.SparkSQLSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.SqliteSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.SysbaseIQSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.SysbaseSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.TDSQLSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.VastbaseSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.impl.YashanDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.query.DBQueryRunner;
import com.kingdee.bos.qing.data.domain.source.db.query.ResultSetHandler;
import com.kingdee.bos.qing.data.domain.source.db.resultset.ResultSetStub;
import com.kingdee.bos.qing.data.domain.source.db.util.SQLHelper;
import com.kingdee.bos.qing.data.domain.source.db.validate.SqlValidatorUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.db.DBConnectionOpenException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBForbiddenException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSPExecuteException;
import com.kingdee.bos.qing.data.exception.db.DBSPNameRepeatException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotFoundResultSetException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSQLExcuseException;
import com.kingdee.bos.qing.data.exception.db.SuperQueryMissTableException;
import com.kingdee.bos.qing.data.exception.db.SuperQueryNoSchemaPermException;
import com.kingdee.bos.qing.data.exception.db.SuperQueryUnDeployException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedure;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.QProfilerSupporter;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractDBSourceJDBCAdapter
implements IStoredProcedure {
    protected static final int LOGIN_TIMEOUT = 10;
    public static final String KSQL_DIALECT = "/*dialect*/";
    public static final String KSQL_QING = "/*qing*/";
    private IConnectionFactory connectionFactory;
    private Set<AbstractQingFileType> QING_FILE_TYPE_FOLDER = new LinkedHashSet<AbstractQingFileType>(16);

    public void setCustomQingFileFolder(LinkedHashSet<AbstractQingFileType> customFolder) {
        this.QING_FILE_TYPE_FOLDER.addAll(customFolder);
    }

    protected IQingFileVisitor getQingFileVistor(DBSource dataBase) {
        if (this.QING_FILE_TYPE_FOLDER.isEmpty()) {
            this.QING_FILE_TYPE_FOLDER.add((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS);
            this.QING_FILE_TYPE_FOLDER.add((AbstractQingFileType)QingTempFileType.UPLOAD);
        }
        for (AbstractQingFileType qingFileType : this.QING_FILE_TYPE_FOLDER) {
            IQingFileVisitor qingFile = FileFactory.newFileVisitor((AbstractQingFileType)qingFileType, (String)dataBase.getDbAddress());
            if (!qingFile.exists()) continue;
            return qingFile;
        }
        return null;
    }

    public static AbstractDBSourceJDBCAdapter newInstance(AbstractSource source) throws UnSupportDataSourceException {
        DBSource dataBase = (DBSource)source;
        DBSource.DBType dbType = dataBase.getDbType();
        AbstractDBSourceJDBCAdapter dbSourceJDBCAdapter = null;
        switch (dbType) {
            case MYSQL: 
            case TIDB: 
            case DORIS: {
                dbSourceJDBCAdapter = MySQLSourceJDBCAdapter.newInstance();
                break;
            }
            case SQLSERVER: {
                dbSourceJDBCAdapter = SQLServerSourceJDBCAdapter.newInstance();
                break;
            }
            case ORACLE: {
                dbSourceJDBCAdapter = OracleSourceJDBCAdapter.newInstance();
                break;
            }
            case DB2: {
                dbSourceJDBCAdapter = DB2SourceJDBCAdapter.newInstance();
                break;
            }
            case GREENPLUM: 
            case POSTGRESQL: {
                dbSourceJDBCAdapter = PostgreSQLSourceJDBCAdapter.newInstance();
                break;
            }
            case SQLITE: {
                dbSourceJDBCAdapter = SqliteSourceJDBCAdapter.newInstance();
                break;
            }
            case ACCESS: {
                dbSourceJDBCAdapter = AccessSourceJDBCAdapter.newInstance();
                break;
            }
            case HIVE: {
                dbSourceJDBCAdapter = HiveSourceJDBCAdapter.newInstance();
                break;
            }
            case HANA: {
                dbSourceJDBCAdapter = HANASourceJDBCAdapter.newInstance();
                break;
            }
            case ODPS: {
                dbSourceJDBCAdapter = AliyunOdpsSourceJDBCAdapter.newInstance();
                break;
            }
            case REDSHIFT: {
                dbSourceJDBCAdapter = RedShiftSourceJDBCAdapter.newInstance();
                break;
            }
            case SYBASE: {
                dbSourceJDBCAdapter = SysbaseSourceJDBCAdapter.newInstance();
                break;
            }
            case DM: {
                dbSourceJDBCAdapter = DMSourceJDBCAdapter.newInstance();
                break;
            }
            case GAUSSDB: {
                if (StringUtils.isNotBlank((CharSequence)dataBase.getDbVersion())) {
                    GaussDBVersionEnum dbVersionEnum = GaussDBVersionEnum.fromPersistance((String)dataBase.getDbVersion());
                    if (dbVersionEnum == GaussDBVersionEnum.GaussDB100) {
                        dbSourceJDBCAdapter = GaussDB100SourceJDBCAdapter.newInstance();
                        break;
                    }
                    dbSourceJDBCAdapter = GaussDB200300SourceJDBCAdapter.newInstance();
                    break;
                }
                dbSourceJDBCAdapter = GaussDBSourceJDBCAdapter.newInstance();
                break;
            }
            case APACHEDRILL: {
                dbSourceJDBCAdapter = ApacheDrillSourceJDBCAdapter.newInstance();
                break;
            }
            case SPARKSQL: {
                dbSourceJDBCAdapter = SparkSQLSourceJDBCAdapter.newInstance();
                break;
            }
            case SYBASEIQ: {
                dbSourceJDBCAdapter = SysbaseIQSourceJDBCAdapter.newInstance();
                break;
            }
            case IMPALA: {
                dbSourceJDBCAdapter = ImpalaSourceJDBCAdapter.newInstance();
                break;
            }
            case KYLIN: {
                dbSourceJDBCAdapter = KylinSourceJDBCAdapter.newInstance();
                break;
            }
            case OPENLOOKENG: {
                dbSourceJDBCAdapter = OpenLookengSourceJDBCAdapter.newInstance((AbstractSource)source);
                break;
            }
            case KINGBASE: {
                dbSourceJDBCAdapter = KingBaseSourceJDBCAdapter.newInstance();
                break;
            }
            case TDSQL: {
                dbSourceJDBCAdapter = TDSQLSourceJDBCAdapter.newInstance();
                break;
            }
            case VASTBASE: {
                dbSourceJDBCAdapter = VastbaseSourceJDBCAdapter.newInstance();
                break;
            }
            case GBASE: {
                dbSourceJDBCAdapter = GBaseSourceJDBCAdapter.newInstance();
                break;
            }
            case YASHANDB: {
                dbSourceJDBCAdapter = YashanDBSourceJDBCAdapter.newInstance();
                break;
            }
            case FLYDB: {
                dbSourceJDBCAdapter = FlyDBSourceJDBCAdapter.newInstance();
                break;
            }
            case OCEANBASE_ORACLE: {
                dbSourceJDBCAdapter = OceanBaseForOracleSourceJDBCAdapter.newInstance();
                break;
            }
        }
        if (null == dbSourceJDBCAdapter) {
            throw new UnSupportDataSourceException("unsupport DBType:" + dbType);
        }
        return dbSourceJDBCAdapter;
    }

    public static DBSource createDBSourceBySource(AbstractSource source) {
        if (source instanceof DBSource) {
            return (DBSource)source;
        }
        IBizSourceConversionStrategy sourceConversionStrategy = (IBizSourceConversionStrategy)CustomStrategyRegistrar.getStrategy(IBizSourceConversionStrategy.class);
        if (sourceConversionStrategy != null) {
            return sourceConversionStrategy.createDBSourceByBizSource(source);
        }
        return null;
    }

    public static IConnectionFactory createConnFactoryBySource(AbstractSource source) {
        IBizSourceConversionStrategy sourceConversionStrategy = (IBizSourceConversionStrategy)CustomStrategyRegistrar.getStrategy(IBizSourceConversionStrategy.class);
        if (sourceConversionStrategy != null) {
            return sourceConversionStrategy.createConnFactoryByBizSource(source);
        }
        return null;
    }

    protected final void queryTableLeafNodes(FolderNode root, DBSource dataBase, String tableQuerySql, Object[] params) throws AbstractDBSourceException {
        this.queryLeafNodes(root, dataBase, tableQuerySql, params, "table");
    }

    public final void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public final IConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected void queryLeafNodes(FolderNode root, DBSource dataBase, String tableQuerySql, Object[] params, String leafNodeType) throws AbstractDBSourceException {
        try {
            tableQuerySql = this.checkAndAddKSqlQing(tableQuerySql);
            tableQuerySql = this.checkAndAddKSqlDialect(tableQuerySql);
            DBQueryRunner queryRunner = new DBQueryRunner(this.getConnectionProvider(dataBase));
            List nodeList = (List)queryRunner.query(tableQuerySql, (ResultSetHandler)new LeafNodeHandler(leafNodeType), params);
            for (LeafNode leafNode : nodeList) {
                root.addChild((AbstractNode)leafNode);
            }
        }
        catch (SQLException e) {
            throw AbstractDBSourceException.parseSQLException((SQLException)e);
        }
    }

    protected abstract String getJDBCUrl(DBSource var1) throws AbstractDBConnectException;

    protected abstract String getDriverClassName();

    protected JDBCModel checkerDataBaseParams(DBSource dataBase) throws AbstractDBConnectException {
        if (IpBlackList.getInstance().isInDbBlackList(dataBase.getDbAddress())) {
            throw new DBForbiddenException("db connection is forbidden");
        }
        String connectUrl = this.getJDBCUrl(dataBase);
        if (this.isMaliciousJdbcUrl(connectUrl)) {
            throw new RuntimeException("jdbc url contains malicious argument");
        }
        String driverClassName = this.getDriverClassName();
        String enCodePsw = dataBase.getPassword();
        String password = new String(Base64.decodeBase64((String)enCodePsw));
        return new JDBCModel(driverClassName, connectUrl, dataBase.getUserName(), password);
    }

    private boolean isMaliciousJdbcUrl(String url) {
        String lowerUrl = url.toLowerCase();
        return lowerUrl.contains("socketfactory=") || lowerUrl.contains("socketfactoryarg=");
    }

    public Connection getConnectionImpl(DBSource dataBase) throws AbstractDBConnectException {
        JDBCPooledConnection connection;
        JDBCModel jdbcModel = this.checkerDataBaseParams(dataBase);
        JDBCConnectionPool.checkDriver((JDBCModel)jdbcModel);
        try {
            connection = JDBCConnectionPool.getConnectionFromPool((JDBCModel)jdbcModel);
        }
        catch (Exception e) {
            throw new DBConnectionOpenException((Throwable)e);
        }
        try {
            this.setConnectionAttribute(dataBase, (Connection)connection);
            return connection;
        }
        catch (SQLException e) {
            CloseUtil.close((Connection)connection);
            throw new DBConnectionOpenException((Throwable)e);
        }
    }

    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(true);
        connection.setAutoCommit(false);
    }

    protected final String checkAndAddKSqlDialect(String sql) {
        if (this.isConnSupportKsql()) {
            return KSQL_DIALECT + sql;
        }
        return sql;
    }

    protected final String checkAndAddKSqlQing(String sql) {
        if (this.isConnSupportKsql()) {
            return KSQL_QING + sql;
        }
        return sql;
    }

    protected final List<StoredProcedureParameter> queryStoredProcedureParams(String sql, DBSource dbSource, Object[] params) throws AbstractDBSourceException {
        sql = this.checkAndAddKSqlDialect(sql);
        DBQueryRunner queryRunner = new DBQueryRunner(this.getConnectionProvider(dbSource));
        try {
            return (List)queryRunner.query(sql, (ResultSetHandler)new StoredProcedureParamsHandler(dbSource), params);
        }
        catch (SQLException e) {
            throw AbstractDBSourceException.parseSQLException((SQLException)e);
        }
    }

    protected final IConnectionProvider getConnectionProvider(final DBSource dbSource) {
        return new IConnectionProvider(){

            public Connection prepareConn() throws AbstractDBConnectException {
                return AbstractDBSourceJDBCAdapter.this.getConnection(dbSource);
            }
        };
    }

    protected final List<String> queryDBNames(DBSource dataBase, String sql, Object[] params, Set<String> ignoreDbs) throws AbstractDBSourceException {
        try {
            DBQueryRunner queryRunner = new DBQueryRunner(this.getConnectionProvider(dataBase));
            List queryResultList = (List)queryRunner.query(sql, (ResultSetHandler)new ColumnListHandler(1), params);
            if (null != ignoreDbs) {
                queryResultList.removeAll(ignoreDbs);
            }
            return queryResultList;
        }
        catch (SQLException e) {
            throw AbstractDBSourceException.parseSQLException((SQLException)e);
        }
    }

    public final Connection getConnection(DBSource dataBase) throws AbstractDBConnectException {
        IDBConnectionCheckerStrategy connectionCheckerStrategy = (IDBConnectionCheckerStrategy)CustomStrategyRegistrar.getStrategy(IDBConnectionCheckerStrategy.class);
        if (connectionCheckerStrategy != null) {
            connectionCheckerStrategy.check();
        }
        if (null != this.connectionFactory) {
            return this.connectionFactory.createConnect();
        }
        return this.getConnectionImpl(dataBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection(QingContext qingContext, AbstractSource source) throws AbstractDBConnectException {
        DBSource dataBase = (DBSource)source;
        Connection conn = null;
        try {
            conn = this.getConnection(dataBase);
        }
        finally {
            CloseUtil.close((Connection)conn);
        }
        return true;
    }

    public void checkEntityMacroValPermission(QingContext qingContext, List<String> macroIds) throws SQLException, ModelParseException, IOException, XmlParsingException, AbstractMacroException, AbstractQingIntegratedException, QingMacroException {
        IMacroExecutor macroExecutor = RuntimeMacroRegister.getMacroExecutor();
        macroExecutor.checkMacroValsPermission(qingContext, macroIds);
    }

    public Map<String, String> getUsableSchemas(QingContext qingContext, DBSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        return null;
    }

    public abstract AbstractNode getUsableEntities(QingContext var1, AbstractSource var2) throws AbstractSourceException, AbstractQingIntegratedException;

    public void setQueryTimeout(QingContext qingContext, PreparedStatement ps) throws SQLException {
        String tenentIdStr = SystemPropertyUtil.getString((String)"qing.db.query.timeout.exclution");
        if (null == tenentIdStr || tenentIdStr.isEmpty()) {
            ps.setQueryTimeout(SystemPropertyUtil.getInt((String)"qing.db.query.timeout", (int)300));
        } else {
            String[] tenentIds;
            boolean exist = false;
            for (String tenentId : tenentIds = tenentIdStr.split(",")) {
                if (!tenentId.equals(qingContext.getTenantId())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                ps.setQueryTimeout(SystemPropertyUtil.getInt((String)"qing.db.query.timeout", (int)300));
            }
        }
    }

    protected IResultSetDataConvertor getDataConvertor() {
        return new DefaultResultSetDataConvertor();
    }

    public String getSchemaPattern(DBSource dataBase) {
        return "%";
    }

    public String wrapTableAssociateName(DBSource dbSource, String tableAssociateName) {
        return tableAssociateName;
    }

    public String getLeftDelimiter() {
        return "";
    }

    public String getRightDelimiter() {
        return "";
    }

    public String appendWhereClause(String sql) {
        return sql;
    }

    protected boolean supportHint() {
        return false;
    }

    public PreparedStatement wrapPrepareStatement(String sql, PreparedStatement preparedStatement) {
        IQProfilerSupporter supporter = QProfilerSupporter.getProfilerSupporter();
        if (null != supporter) {
            return supporter.makeProxy(sql, preparedStatement);
        }
        return preparedStatement;
    }

    protected String getSelectVersionSql() {
        return null;
    }

    public String getDbVersion(DBSource dbSource) {
        String sql = this.getSelectVersionSql();
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            try {
                DBQueryRunner queryRunner = new DBQueryRunner(this.getConnectionProvider(dbSource));
                return (String)queryRunner.query(sql, (ResultSetHandler)new VersionResultSetHandler());
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                return errorMessage != null ? errorMessage : "";
            }
        }
        return "";
    }

    public String getSPCmdFormate(DBSource dbSource) {
        return "{call " + this.getLeftDelimiter() + "%s" + this.getRightDelimiter() + "( %s )}";
    }

    public final String getStoredProcedureExecSql(DBSource dbSource, StoredProcedure storedProce) throws DBSPNotSupportException {
        if (!DBSource.supportStoredProcedure((DBSource.DBType)dbSource.getDbType())) {
            throw new DBSPNotSupportException();
        }
        List parameters = storedProce.getParameters();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            if (i == parameters.size() - 1) {
                sb.append('?');
                continue;
            }
            sb.append('?').append(',');
        }
        String cmdFormate = this.getSPCmdFormate(dbSource);
        return String.format(cmdFormate, storedProce.getAssociateName(), sb.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkSQLExecutable(QingContext qingContext, DBSource dataBase, DBSource.UserSQL.SQLType sqlType, String sqlContent) throws AbstractDBSourceException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "";
        try {
            conn = this.getConnection(dataBase);
            sql = SQLHelper.systemVarUserSqlTransformToSql((QingContext)qingContext, (String)sqlContent);
            sql = SQLHelper.ksqlToDialect((DBSource.DBType)dataBase.getDbType(), (DBSource.UserSQL.SQLType)sqlType, (String)sql);
            String exeSql = String.format("select * from ( %s ) t where 1=0", sql);
            exeSql = this.checkAndAddKSqlDialect(exeSql);
            SqlValidatorUtil.doValidate(exeSql, dataBase.getDbType());
            ps = conn.prepareStatement(exeSql);
            this.setQueryTimeout(qingContext, ps);
            PreparedStatement wrapped = this.wrapPrepareStatement(sql, ps);
            rs = wrapped.executeQuery();
        }
        catch (SQLException e) {
            try {
                throw new DBExcuseException(e, sql);
                catch (Exception e2) {
                    throw new DBExcuseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Connection)conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
    }

    protected static void checkStoredProcedureNameNotRepeat(FolderNode root) throws DBSPNameRepeatException {
        if (root != null && root.getChildCount() > 1) {
            List nodeList = root.getChildren();
            HashSet<String> set = new HashSet<String>(nodeList.size());
            for (AbstractNode abstractNode : nodeList) {
                if (set.contains(abstractNode.getName())) {
                    throw new DBSPNameRepeatException();
                }
                set.add(abstractNode.getName());
            }
        }
    }

    public abstract List<String> getDatabaseNameList(AbstractSource var1) throws AbstractDBSourceException;

    public AbstractDBTableCreator createDBTableCreator(DBSource dbSource, String associateName) {
        if (dbSource.isUserSql(associateName)) {
            return new UserSqlDBTableCreator(dbSource, associateName);
        }
        if (dbSource.isStoredProcedure(associateName)) {
            return new StoredProcedureDBTableCreator(dbSource, associateName);
        }
        return new GeneralDBTableCreator(dbSource, associateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table getTable(Connection conn, DBSource dbSource, String tableAssociateName) throws SQLException {
        Table table;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            String sql = String.format("select * from %s where 1=0", this.getLeftDelimiter() + this.wrapTableAssociateName(dbSource, tableAssociateName) + this.getRightDelimiter());
            sql = this.checkAndAddKSqlQing(sql);
            sql = this.checkAndAddKSqlDialect(sql);
            SqlValidatorUtil.doValidate(sql, dbSource.getDbType());
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            Table table2 = new Table();
            table2.setName(tableAssociateName);
            table2.setSource(dbSource.getName());
            AbstractDBTableCreator.addTablePeerFields((Table)table2, (ResultSetMetaData)resultSetMetaData);
            table = table2;
        }
        catch (Throwable throwable) {
            CloseUtil.close(ps, rs);
            throw throwable;
        }
        CloseUtil.close((Statement)ps, (ResultSet)rs);
        return table;
    }

    protected boolean needCalculateTotalCount() {
        return true;
    }

    public boolean isConnSupportKsql() {
        return null != this.connectionFactory && this.connectionFactory.supportKSql();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T query(QingContext qingContext, DBSource dataBase, String sql, DBSource.UserSQL.SQLType sqlType, QueryResultHandler<T> resultHanlder) throws SQLException, AbstractDBSourceException {
        Object object;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sql = SQLHelper.systemVarUserSqlTransformToSql((QingContext)qingContext, (String)sql);
            sql = SQLHelper.ksqlToDialect((DBSource.DBType)dataBase.getDbType(), (DBSource.UserSQL.SQLType)sqlType, (String)sql);
            sql = this.checkAndAddKSqlDialect(sql);
            SqlValidatorUtil.doValidate(sql, dataBase.getDbType());
            conn = this.getConnection(dataBase);
            ps = conn.prepareStatement(sql);
            this.setQueryTimeout(qingContext, ps);
            ps.setFetchSize(100);
            PreparedStatement wrapped = this.wrapPrepareStatement(sql, ps);
            rs = wrapped.executeQuery();
            object = resultHanlder.handle(rs);
        }
        catch (SQLException e) {
            try {
                throw e;
                catch (AbstractDBSourceException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        return (T)object;
    }

    public ResultSet executeQuery(QingContext qingContext, DBSource dataBase, String sql, List<Object> params) throws SQLException, AbstractDBSourceException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(dataBase);
            sql = this.checkAndAddKSqlDialect(sql);
            SqlValidatorUtil.doValidate(sql, dataBase.getDbType());
            ps = conn.prepareStatement(sql);
            this.setQueryTimeout(qingContext, ps);
            ps.setFetchSize(100);
            if (params != null && !params.isEmpty()) {
                int size = params.size();
                for (int idx = 0; idx < size; ++idx) {
                    Object param = params.get(idx);
                    SQLHelper.setParams((PreparedStatement)ps, (int)(idx + 1), (Object)param);
                }
            }
            PreparedStatement wrapped = this.wrapPrepareStatement(sql, ps);
            rs = wrapped.executeQuery();
            return ResultSetStub.createStub((Connection)conn, (Statement)ps, (ResultSet)rs);
        }
        catch (RuntimeException e) {
            CloseUtil.close((Connection)conn, ps, rs);
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
        catch (SQLException e) {
            CloseUtil.close((Connection)conn, ps, rs);
            throw e;
        }
        catch (AbstractDBSourceException e) {
            CloseUtil.close((Connection)conn, ps, rs);
            throw e;
        }
        catch (Exception e) {
            CloseUtil.close((Connection)conn, ps, rs);
            throw new SQLException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(QingContext qingContext, DBSource dataBase, String sql, List<Object> params) throws SQLException, AbstractDBSourceException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int result = -1;
        try {
            conn = this.getConnection(dataBase);
            sql = this.checkAndAddKSqlDialect(sql);
            ps = conn.prepareStatement(sql);
            this.setQueryTimeout(qingContext, ps);
            if (params != null && !params.isEmpty()) {
                int size = params.size();
                for (int idx = 0; idx < size; ++idx) {
                    Object param = params.get(idx);
                    SQLHelper.setParams((PreparedStatement)ps, (int)(idx + 1), (Object)param);
                }
            }
            PreparedStatement wrapped = this.wrapPrepareStatement(sql, ps);
            result = wrapped.executeUpdate();
            conn.commit();
        }
        catch (SQLException e) {
            try {
                if (conn == null) throw e;
                conn.rollback();
                throw e;
                catch (AbstractDBSourceException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    if (conn == null) throw new SQLException(e3.getMessage(), e3);
                    conn.rollback();
                    throw new SQLException(e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Connection)conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, rs);
        return result;
    }

    public String getPageSql(String sql, long startRow, int offset, Integer ksqlDbType) {
        if (null == ksqlDbType) {
            return null;
        }
        try {
            return TransUtil.translate((String)(" select top " + offset + ", " + startRow + " T.* from (" + sql + ") T"), (int)ksqlDbType);
        }
        catch (SqlTranslateException e) {
            LogUtil.error((String)("transUtil ksql error :" + sql), (Throwable)e);
            return null;
        }
    }

    static {
        DriverManager.setLoginTimeout(10);
    }

    private class GeneralDBTableCreator
    extends AbstractDBTableCreator {
        public GeneralDBTableCreator(DBSource dbSource, String associateName) {
            this.dbSource = dbSource;
            this.associateName = associateName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Table getTablePeer(QingContext qingContext) throws AbstractDBSourceException {
            Table table;
            Connection conn = null;
            try {
                Table table2;
                conn = AbstractDBSourceJDBCAdapter.this.getConnection(this.dbSource);
                table = table2 = AbstractDBSourceJDBCAdapter.this.getTable(conn, this.dbSource, this.associateName);
            }
            catch (RuntimeException e) {
                try {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof SQLException) {
                        int errorCode = ((SQLException)throwable).getErrorCode();
                        if (errorCode == 1089 || errorCode == 1067) {
                            throw new SuperQueryNoSchemaPermException(e.getMessage());
                        }
                        if (errorCode == 20002) {
                            throw new SuperQueryUnDeployException(e.getMessage());
                        }
                    }
                    throw new DBExcuseException((Exception)e);
                    catch (SQLException e2) {
                        if (e2.getErrorCode() != 1071 && e2.getErrorCode() != 1068) {
                            throw new DBExcuseException(e2);
                        }
                        throw new SuperQueryMissTableException(e2.getMessage());
                    }
                    catch (Exception e3) {
                        throw new DBExcuseException(e3);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close(conn);
                    throw throwable;
                }
            }
            CloseUtil.close((Connection)conn);
            return table;
        }
    }

    private class UserSqlDBTableCreator
    extends AbstractDBTableCreator {
        public UserSqlDBTableCreator(DBSource dbSource, String associateName) {
            this.dbSource = dbSource;
            this.associateName = associateName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Table getTablePeer(QingContext qingContext) throws AbstractDBSourceException, AbstractMacroException {
            Table table;
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String sql = "";
            boolean isKSQL = false;
            try {
                conn = AbstractDBSourceJDBCAdapter.this.getConnection(this.dbSource);
                DBSource.UserSQL userSQL = this.dbSource.getUserSql(this.associateName);
                isKSQL = DBSource.UserSQL.SQLType.KSQL == DBSource.UserSQL.SQLType.valueOf((String)userSQL.getSqlType());
                SQLHelper.RuntimeUserSQL runtimeUserSQL = SQLHelper.processUserSQL((DBSource.UserSQL)userSQL, (DBSource.DBType)this.dbSource.getDbType(), (QingContext)qingContext);
                sql = runtimeUserSQL.getSQL();
                List userSQLParams = runtimeUserSQL.getParam();
                String exeSql = String.format("select * from ( %s ) t where 1=0", sql);
                exeSql = AbstractDBSourceJDBCAdapter.this.checkAndAddKSqlQing(exeSql);
                exeSql = AbstractDBSourceJDBCAdapter.this.checkAndAddKSqlDialect(exeSql);
                SqlValidatorUtil.doValidate(exeSql, this.dbSource.getDbType());
                ps = conn.prepareStatement(exeSql);
                int size = userSQLParams.size();
                for (int idx = 0; idx < size; ++idx) {
                    Object param = userSQLParams.get(idx);
                    SQLHelper.setParams((PreparedStatement)ps, (int)(idx + 1), param);
                }
                AbstractDBSourceJDBCAdapter.this.setQueryTimeout(qingContext, ps);
                PreparedStatement wrapped = AbstractDBSourceJDBCAdapter.this.wrapPrepareStatement(sql, ps);
                rs = wrapped.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                Table table2 = new Table();
                table2.setName(userSQL.getName());
                table2.setSource(this.dbSource.getName());
                AbstractDBTableCreator.addTablePeerFields((Table)table2, (ResultSetMetaData)metaData, (DBSource.DBType)this.dbSource.getDbType());
                table = table2;
            }
            catch (RuntimeException e) {
                try {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof SQLException) {
                        int errorCode = ((SQLException)throwable).getErrorCode();
                        if (errorCode == 1089 || errorCode == 1067) {
                            throw new SuperQueryNoSchemaPermException(e.getMessage());
                        }
                        if (errorCode == 20002) {
                            throw new SuperQueryUnDeployException(e.getMessage());
                        }
                    }
                    throw new DBExcuseException((Exception)e);
                    catch (SQLException e2) {
                        if (isKSQL) {
                            throw new DBKSQLExcuseException(e2, sql);
                        }
                        if (e2.getErrorCode() != 1071 && e2.getErrorCode() != 1068) {
                            throw new DBSQLExcuseException(e2, sql);
                        }
                        throw new SuperQueryMissTableException(e2.getMessage());
                    }
                    catch (AbstractMacroException e3) {
                        throw e3;
                    }
                    catch (DBKSQLNotSupportException e4) {
                        throw e4;
                    }
                    catch (Exception e5) {
                        throw new DBExcuseException(e5);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Connection)conn, ps, rs);
                    throw throwable;
                }
            }
            CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
            return table;
        }
    }

    private class StoredProcedureDBTableCreator
    extends AbstractDBTableCreator {
        public StoredProcedureDBTableCreator(DBSource dbSource, String associateName) {
            this.dbSource = dbSource;
            this.associateName = associateName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Table getTablePeer(QingContext qingContext) throws AbstractDBSourceException {
            Table table;
            StoredProcedure storedProcedure = this.dbSource.getStoredProcedure(this.associateName);
            Connection conn = null;
            CallableStatement ps = null;
            ResultSet rs = null;
            try {
                conn = AbstractDBSourceJDBCAdapter.this.getConnection(this.dbSource);
                String sql = AbstractDBSourceJDBCAdapter.this.getStoredProcedureExecSql(this.dbSource, storedProcedure);
                ps = SQLHelper.prepareCall((Connection)conn, (String)sql);
                rs = SQLHelper.getExecResultSet((QingContext)qingContext, (Connection)conn, (DBSource)this.dbSource, (CallableStatement)ps, (StoredProcedure)storedProcedure);
                ResultSetMetaData metaData = rs.getMetaData();
                Table table2 = new Table();
                table2.setName(storedProcedure.getName());
                table2.setSource(this.dbSource.getName());
                AbstractDBTableCreator.addTablePeerFields((Table)table2, (ResultSetMetaData)metaData, (DBSource.DBType)this.dbSource.getDbType());
                table = table2;
            }
            catch (DBSPNotFoundResultSetException e) {
                try {
                    throw e;
                    catch (SQLException e2) {
                        throw new DBSPExecuteException(e2);
                    }
                    catch (DBSPNotSupportException e3) {
                        throw e3;
                    }
                    catch (Exception e4) {
                        throw new DBExcuseException(e4);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Connection)conn, ps, rs);
                    throw throwable;
                }
            }
            CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
            return table;
        }
    }
}

