/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.validate;

import com.kingdee.bos.qing.data.domain.source.db.validate.ISqlValidator;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import java.util.regex.Pattern;

public class SqlKeywordValidator
implements ISqlValidator {
    private static final Pattern pattern;

    @Override
    public void validate(String sql, DBSource.DBType dbType) throws IllegalArgumentException {
        if (pattern.matcher(sql).find()) {
            throw new IllegalArgumentException("SQL statement contains forbidden keywords.");
        }
    }

    static {
        StringBuilder regexBuilder = new StringBuilder();
        regexBuilder.append("\\b(");
        regexBuilder.append("INSERT|");
        regexBuilder.append("UPDATE|");
        regexBuilder.append("DELETE|");
        regexBuilder.append("CREATE|");
        regexBuilder.append("ALTER|");
        regexBuilder.append("DROP|");
        regexBuilder.append("TRUNCATE|");
        regexBuilder.append("RENAME|");
        regexBuilder.append("GRANT|");
        regexBuilder.append("REVOKE");
        regexBuilder.append(")\\b");
        pattern = Pattern.compile(regexBuilder.toString(), 2);
    }
}

