/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.validate;

import com.kingdee.bos.qing.data.domain.source.db.validate.ISqlValidator;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;

public class SqlSymbolValidator
implements ISqlValidator {
    @Override
    public void validate(String sql, DBSource.DBType dbType) throws IllegalArgumentException {
        this.checkContainsSemicolons(sql);
    }

    private void checkContainsSemicolons(String sql) throws IllegalArgumentException {
        if (sql.trim().contains(";")) {
            throw new IllegalArgumentException("SQL statement contains multiple executable SQL.");
        }
    }

    private void checkInvalidSymbols(String sql, DBSource.DBType dbType) throws IllegalArgumentException {
        String[] lines;
        String lastLine;
        if (dbType == DBSource.DBType.MYSQL && (lastLine = (lines = sql.split("\n"))[lines.length - 1]).contains("#") && !lastLine.endsWith("\n")) {
            throw new IllegalArgumentException("SQL statement contains abnormal single-line comments");
        }
    }
}

