/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db.validate;

import com.kingdee.bos.qing.data.domain.source.db.validate.ISqlValidator;
import com.kingdee.bos.qing.data.domain.source.db.validate.SqlKeywordValidator;
import com.kingdee.bos.qing.data.domain.source.db.validate.SqlSymbolValidator;
import com.kingdee.bos.qing.data.domain.source.db.validate.SqlTableNameValidator;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;

public class SqlValidatorUtil {
    private static final String PROPERTY_NEED_VALIDATE_KEY = "qing.sql.validate.enable";
    private static final List<ISqlValidator> SQL_VALIDATORS = new ArrayList<ISqlValidator>(3);

    public static void doValidate(String sql, DBSource.DBType dbType) throws IllegalArgumentException {
        if (!SqlValidatorUtil.checkValidateEnable()) {
            return;
        }
        String cleanSql = SqlValidatorUtil.removeCommentsAndString(sql);
        if (StringUtils.isEmpty((CharSequence)cleanSql)) {
            return;
        }
        for (ISqlValidator validator : SQL_VALIDATORS) {
            validator.validate(cleanSql, dbType);
        }
    }

    public static String removeCommentsAndString(String input) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder();
        int length = input.length();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        for (int i = 0; i < length; ++i) {
            char nextChar;
            char currentChar = input.charAt(i);
            char c = nextChar = i < length - 1 ? input.charAt(i + 1) : (char)'\u0000';
            if (!(currentChar != '\'' || inSingleLineComment || inMultiLineComment || inDoubleQuotes)) {
                inSingleQuotes = !inSingleQuotes;
                continue;
            }
            if (!(currentChar != '\"' || inSingleLineComment || inMultiLineComment || inSingleQuotes)) {
                inDoubleQuotes = !inDoubleQuotes;
                continue;
            }
            if (inSingleQuotes || inDoubleQuotes) continue;
            if (!inMultiLineComment && currentChar == '-' && nextChar == '-') {
                inSingleLineComment = true;
                ++i;
                continue;
            }
            if (!inSingleLineComment && currentChar == '/' && nextChar == '*') {
                inMultiLineComment = true;
                ++i;
                continue;
            }
            if (inSingleLineComment && currentChar == '\n') {
                inSingleLineComment = false;
                continue;
            }
            if (inMultiLineComment && currentChar == '*' && nextChar == '/') {
                inMultiLineComment = false;
                ++i;
                continue;
            }
            if (inSingleLineComment || inMultiLineComment) continue;
            result.append(currentChar);
        }
        if (inSingleLineComment || inMultiLineComment) {
            throw new IllegalArgumentException("SQL statement contains abnormal comment symbols.");
        }
        return result.toString();
    }

    private static boolean checkValidateEnable() {
        return SystemPropertyUtil.getTenantBoolean((String)PROPERTY_NEED_VALIDATE_KEY, (boolean)true);
    }

    static {
        SQL_VALIDATORS.add(new SqlSymbolValidator());
        SQL_VALIDATORS.add(new SqlKeywordValidator());
        SQL_VALIDATORS.add(new SqlTableNameValidator());
    }
}

