/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.mult;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceJoinException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.exception.UnAnalysableException;
import com.kingdee.bos.qing.datasource.join.JoinOption;
import com.kingdee.bos.qing.datasource.join.cache.BoxTableFieldAnalysisHistory;
import com.kingdee.bos.qing.datasource.join.util.MainJoinDataSetModelInitializer;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.model.AbstractDataSetModel;
import com.kingdee.bos.qing.datasource.model.JoinDataSetModel;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IPreAggDataIterator;
import com.kingdee.bos.qing.datasource.spec.mult.IDataJoinExecutor;
import com.kingdee.bos.qing.datasource.spec.mult.JoinExecutorSelector;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataThreadLocalUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiDataIterator
implements IPreAggDataIterator {
    private MultiDataSourceWrap multiDataSourceWrap;
    private List<DSMetaEntity> entities;
    private List<DSMetaRelation> relations;
    private IDataIterator joinResultDataIterator;
    private boolean isAllFieldsNeeded = false;
    private JoinOption joinOption;
    private Set<IPreAggDataIterator.Dimension> dimensions;

    public MultiDataIterator(MultiDataSourceWrap multiDataSourceWrap, List<DSMetaEntity> entities, List<DSMetaRelation> relations) {
        this.entities = entities;
        this.relations = relations;
        this.multiDataSourceWrap = multiDataSourceWrap;
    }

    private boolean needJoin(AbstractDataSourceVisitor visitor, AbstractDataSetModel mainDdataSetModel) {
        if (!(mainDdataSetModel instanceof JoinDataSetModel)) {
            return false;
        }
        if (MultiDataThreadLocalUtil.isJoinFinish()) {
            return false;
        }
        JoinDataSetModel joinModel = (JoinDataSetModel)mainDdataSetModel;
        return null == visitor || !visitor.isFieldsExisted((Collection)joinModel.getMetaInfo().getFieldNames());
    }

    private void removeNotExistedEntityField(Set<DSFieldKey> fields) {
        HashSet<String> existedEntityNames = new HashSet<String>(16);
        for (DSMetaEntity entity : this.entities) {
            existedEntityNames.add(entity.getName());
        }
        Iterator<DSFieldKey> iterator = fields.iterator();
        while (iterator.hasNext()) {
            DSFieldKey fieldKey = iterator.next();
            if (existedEntityNames.contains(fieldKey.getEntityName())) continue;
            iterator.remove();
        }
    }

    private Map<String, MetaInfo> getSingleEntityMetaInfo() {
        HashMap<String, MetaInfo> entityMetas = new HashMap<String, MetaInfo>();
        for (DSMetaEntity entity : this.entities) {
            String entityName = entity.getName();
            HashSet<String> entityNameSet = new HashSet<String>();
            entityNameSet.add(entityName);
            try {
                AbstractSingleDataSourceVisitor sourceVisitor = this.multiDataSourceWrap.get(entityNameSet);
                entityMetas.put(entityName, sourceVisitor.getMetaInfo());
            }
            catch (AbstractDataSourceException e) {
                LogUtil.error((String)"", (Throwable)e);
            }
        }
        return entityMetas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<DSFieldKey> syncAndUpdateAnalysisField(Set<DSFieldKey> fields) {
        ILock lock = null;
        try {
            String boxId = this.multiDataSourceWrap.getBoxId();
            String ownerId = this.multiDataSourceWrap.getOwnerId();
            String themeAnalysisFieldCacheKey = boxId + "_" + ownerId + "_AnalysisFields";
            lock = LockFactory.createLock((String)themeAnalysisFieldCacheKey);
            if (lock.tryLock(5000L)) {
                BoxTableFieldAnalysisHistory history = (BoxTableFieldAnalysisHistory)QingSessionUtil.getGlobalQingSessionImpl().getCache(themeAnalysisFieldCacheKey, BoxTableFieldAnalysisHistory.class);
                if (null == history) {
                    history = new BoxTableFieldAnalysisHistory();
                    history.setBoxId(boxId);
                    history.setUserId(ownerId);
                }
                Set updatedFields = history.refreshAnalysisFields(fields, this.getSingleEntityMetaInfo());
                QingSessionUtil.getGlobalQingSessionImpl().setCache((ISessionCacheable)history);
                Set set = updatedFields;
                return set;
            }
        }
        catch (UnsupportedOperationException e) {
            LogUtil.warn((String)"mutilsource map not supported get theme or ownerId");
        }
        catch (InterruptedException e) {
            LogUtil.warn((String)"lock failed for query analysis fields");
        }
        catch (QingLockRequireException e) {
            LogUtil.warn((String)"lock failed for query analysis fields");
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
        return fields;
    }

    public void init(Set<DSFieldKey> fields, Set<IPushdownFilter> filters, String cacheKey) throws AbstractDataSourceException, InterruptedException {
        Set<DSFieldKey> interestFields;
        AbstractDataSetModel mainDataSetModel;
        if (this.existInvalidRelation(fields)) {
            throw new UnAnalysableException("relation referene a not existed property");
        }
        this.removeNotExistedEntityField(fields);
        if (fields.isEmpty()) {
            return;
        }
        if ("true".equals(SystemPropertyUtil.getTenantProperty((String)"qing.only.join.part.fields"))) {
            Set<DSFieldKey> fieldKeysUseByModelInitialize = this.syncAndUpdateAnalysisField(fields);
            MainJoinDataSetModelInitializer dataSetModelInitializer = new MainJoinDataSetModelInitializer(this.entities, this.relations, this.multiDataSourceWrap);
            dataSetModelInitializer.setNeedJoinAllFields(this.isAllFieldsNeeded);
            mainDataSetModel = dataSetModelInitializer.initialize(fieldKeysUseByModelInitialize, filters);
            interestFields = this.getInterestInitializedFields(fieldKeysUseByModelInitialize, fields);
        } else {
            MainJoinDataSetModelInitializer dataSetModelInitializer = new MainJoinDataSetModelInitializer(this.entities, this.relations, this.multiDataSourceWrap);
            dataSetModelInitializer.setNeedJoinAllFields(true);
            mainDataSetModel = dataSetModelInitializer.initialize(fields, filters);
            interestFields = fields;
        }
        if (mainDataSetModel != null) {
            AbstractSingleDataSourceVisitor visitor = this.multiDataSourceWrap.get(mainDataSetModel.getEntityNames());
            if (this.needJoin((AbstractDataSourceVisitor)visitor, mainDataSetModel)) {
                visitor = this.submitJoinTask(mainDataSetModel);
            }
            if (visitor != null) {
                if (!visitor.hasData()) {
                    throw new DataSourceNoDataException("no data after join");
                }
                this.joinResultDataIterator = visitor.iterator();
                if (this.joinResultDataIterator instanceof IPreAggDataIterator) {
                    ((IPreAggDataIterator)this.joinResultDataIterator).appointDimensions(this.dimensions);
                }
                this.joinResultDataIterator.init(interestFields, filters, cacheKey);
            } else {
                throw new DataSourceJoinException("join result file not found");
            }
        }
    }

    protected AbstractDataSourceVisitor submitJoinTask(AbstractDataSetModel mainDataSetModel) {
        IDataJoinExecutor joinExecutor = JoinExecutorSelector.select((JoinOption)this.joinOption, (MultiDataSourceWrap)this.multiDataSourceWrap);
        return joinExecutor.execute(mainDataSetModel);
    }

    private Set<DSFieldKey> getInterestInitializedFields(Set<DSFieldKey> initializedFields, Set<DSFieldKey> fieldsBeforeInitialize) {
        HashSet<DSFieldKey> interestFields = new HashSet<DSFieldKey>(fieldsBeforeInitialize.size());
        HashSet<String> interestFieldNames = new HashSet<String>(fieldsBeforeInitialize.size());
        for (DSFieldKey dsFieldKey : fieldsBeforeInitialize) {
            interestFieldNames.add(dsFieldKey.toFullName());
        }
        for (DSFieldKey fieldKey : initializedFields) {
            String fullFieldName = fieldKey.toFullName();
            if (!interestFieldNames.contains(fullFieldName)) continue;
            interestFields.add(fieldKey);
        }
        return interestFields;
    }

    public void setJoinOption(JoinOption option) {
        this.joinOption = option;
    }

    private boolean existInvalidRelation(Set<DSFieldKey> fields) {
        for (DSFieldKey dsFieldKey : fields) {
            for (DSMetaRelation relation : this.relations) {
                if (!dsFieldKey.getEntityName().equals(relation.getFromEntity().getName()) && !dsFieldKey.getEntityName().equals(relation.getToEntity().getName()) || !relation.isInvalid()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNextRow() throws AbstractDataSourceException, InterruptedException {
        if (this.joinResultDataIterator != null) {
            return this.joinResultDataIterator.hasNextRow();
        }
        return false;
    }

    public Map<String, Object> nextRow() throws AbstractDataSourceException, InterruptedException {
        if (this.joinResultDataIterator != null) {
            return this.joinResultDataIterator.nextRow();
        }
        return null;
    }

    public void setAllFieldsNeeded(boolean isAllFieldsNeeded) {
        this.isAllFieldsNeeded = isAllFieldsNeeded;
    }

    public void close() {
        CloseUtil.close((Closeable[])new Closeable[]{this.joinResultDataIterator});
        this.joinResultDataIterator = null;
    }

    public void appointDimensions(Set<IPreAggDataIterator.Dimension> dimensions) {
        this.dimensions = dimensions;
    }
}

