/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.fontlibrary.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.DynamicFileTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.fontlibrary.dao.FontLibDao;
import com.kingdee.bos.qing.fontlibrary.domain.FontLibDomain;
import com.kingdee.bos.qing.fontlibrary.exception.CreateZipInputStreamException;
import com.kingdee.bos.qing.fontlibrary.exception.FontCodeDuplicatedException;
import com.kingdee.bos.qing.fontlibrary.exception.FontDisplayNameDuplicatedException;
import com.kingdee.bos.qing.fontlibrary.exception.FontDuplicatedException;
import com.kingdee.bos.qing.fontlibrary.exception.FontFilePersistentException;
import com.kingdee.bos.qing.fontlibrary.exception.FontLibException;
import com.kingdee.bos.qing.fontlibrary.exception.FontNoExistException;
import com.kingdee.bos.qing.fontlibrary.exception.NoExportPermissionForPresetFont;
import com.kingdee.bos.qing.fontlibrary.exception.NoFoundImportFileException;
import com.kingdee.bos.qing.fontlibrary.exception.NoRemovePermissionForPresetFont;
import com.kingdee.bos.qing.fontlibrary.exception.ParsePackageMetaException;
import com.kingdee.bos.qing.fontlibrary.exception.ReadDynamicFileException;
import com.kingdee.bos.qing.fontlibrary.exception.UpdateDynamicFileException;
import com.kingdee.bos.qing.fontlibrary.exception.UploadFileNoExistException;
import com.kingdee.bos.qing.fontlibrary.imexport.FontExporter;
import com.kingdee.bos.qing.fontlibrary.imexport.FontImporter;
import com.kingdee.bos.qing.fontlibrary.lplog.FontOpLog;
import com.kingdee.bos.qing.fontlibrary.lplog.FontOpLogParamDesc;
import com.kingdee.bos.qing.fontlibrary.model.FontEntity;
import com.kingdee.bos.qing.fontlibrary.model.FontPathTypeEnum;
import com.kingdee.bos.qing.fontlibrary.model.FontPo;
import com.kingdee.bos.qing.fontlibrary.model.FontResourcePo;
import com.kingdee.bos.qing.fontlibrary.model.FontVo;
import com.kingdee.bos.qing.fontlibrary.model.HandleConflictFontStrategy;
import com.kingdee.bos.qing.fontlibrary.model.ImExportFontEntity;
import com.kingdee.bos.qing.fontlibrary.model.ImportFontVo;
import com.kingdee.bos.qing.fontlibrary.model.UploadFileInfo;
import com.kingdee.bos.qing.fontlibrary.util.FontLibUtils;
import com.kingdee.bos.qing.imagelibrary.util.ImExportUtil;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.pagination.PaginationRequestData;
import com.kingdee.bos.qing.util.pagination.PaginationUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/*
 * Exception performing whole class analysis ignored.
 */
public class FontLibDomain {
    private final QingContext qingContext;
    private final IDBExcuter dbExecutor;
    private final ITransactionManagement tx;
    private FontLibDao _fontLibDao;
    private static final int BLOCK_SIZE = 65536;
    private String cssFileTemplate;
    private String jsFileTemplate;
    private final String prefixPath;

    public FontLibDomain(QingContext qingContext, IDBExcuter dbExecutor, ITransactionManagement tx, String prefixPath) {
        this.qingContext = qingContext;
        this.dbExecutor = dbExecutor;
        this.tx = tx;
        this.prefixPath = prefixPath + "/qing/loadFontFile.do";
    }

    protected FontLibDao getFontDao() {
        if (this._fontLibDao == null) {
            this._fontLibDao = new FontLibDao(this.dbExecutor, this.qingContext);
        }
        return this._fontLibDao;
    }

    protected String getFontLibOperationLockKey() {
        return "Qing.FontLib.operate.Lock." + this.qingContext.getAccountId();
    }

    protected String getFontLibReLoadFileContentLockKey() {
        return "Qing.FontLib.reload.lock." + this.qingContext.getAccountId();
    }

    public byte[] readDynamicFile(DynamicFileTypeEnum filetype, int offset) throws QingLockRequireException, InterruptedException, AbstractQingIntegratedException, SQLException {
        byte[] contentByte;
        int length;
        int endIndex;
        String fileContent = QingSessionUtil.getGlobalQingSessionImpl().get(filetype.getKey(this.qingContext.getAccountId()));
        if (StringUtils.isEmpty((CharSequence)fileContent)) {
            fileContent = this.reloadFromDbAndGetFileContent(filetype);
        }
        if ((endIndex = offset + 65536) < (length = (contentByte = StringUtils.getBytes((String)fileContent)).length)) {
            return Arrays.copyOfRange(contentByte, offset, endIndex);
        }
        return Arrays.copyOfRange(contentByte, offset, length);
    }

    public byte[] readFontFile(String fileName, int offset) throws ReadDynamicFileException {
        byte[] byArray;
        int len;
        byte[] result;
        QingInputStream inputStream;
        block5: {
            IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.FONT_LIB, (String)fileName);
            inputStream = null;
            inputStream = qingFileVisitor.getInputStream();
            inputStream.seek((long)offset);
            result = new byte[65536];
            len = inputStream.read(result);
            if (len > 0) break block5;
            byte[] byArray2 = null;
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            return byArray2;
        }
        try {
            byArray = Arrays.copyOf(result, len);
        }
        catch (IOException e) {
            try {
                throw new ReadDynamicFileException((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String reloadFromDbAndGetFileContent(DynamicFileTypeEnum fileType) throws QingLockRequireException, InterruptedException, AbstractQingIntegratedException, SQLException {
        ILock lock = LockFactory.createLock((String)this.getFontLibReLoadFileContentLockKey());
        try {
            boolean success = lock.tryLock(10000L);
            if (!success) {
                throw new QingLockRequireException("Failed to reload dynamically generated file from db to cache.");
            }
            String accountId = this.qingContext.getAccountId();
            String fileContent = QingSessionUtil.getGlobalQingSessionImpl().get(fileType.getKey(accountId));
            if (StringUtils.isEmpty((CharSequence)fileContent)) {
                Map fileContentMap = this.getFontDao().getDynamicFileContent();
                for (Map.Entry entry : fileContentMap.entrySet()) {
                    String value = StringUtils.decode((byte[])((byte[])entry.getValue()));
                    QingSessionUtil.getGlobalQingSessionImpl().set((String)entry.getKey(), value, 7, TimeUnit.DAYS);
                    if (!fileType.getKey(accountId).equals(entry.getKey())) continue;
                    fileContent = value;
                }
            }
            String string = fileContent;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public FontVo updateFont(FontVo newFontVo) throws Exception {
        FontLibDao fontLibDao = this.getFontDao();
        String fontId = newFontVo.getId();
        String code = newFontVo.getCode();
        String displayName = newFontVo.getDisplayName();
        if (!this.isFontExist(fontId)) {
            throw new FontNoExistException();
        }
        this.checkDuplicatedName(fontId, code, displayName);
        List newResourcePoList = newFontVo.getFontResourcePos();
        List oldResourcePoList = fontLibDao.loadFontResources(fontId);
        LinkedList<String> successPersistentFileNames = new LinkedList<String>();
        ILock updateLock = LockFactory.createLock((String)this.getFontLibOperationLockKey());
        try {
            boolean isChange;
            int listSize = newResourcePoList.size();
            boolean bl = isChange = listSize != oldResourcePoList.size();
            if (!isChange) {
                Collections.sort(newResourcePoList, FontResourceComparator.getInstance());
                Collections.sort(oldResourcePoList, FontResourceComparator.getInstance());
                for (int i = 0; i < listSize; ++i) {
                    FontResourcePo oldPo;
                    FontResourcePo newPo = (FontResourcePo)newResourcePoList.get(i);
                    boolean bl2 = isChange = !newPo.compare(oldPo = (FontResourcePo)oldResourcePoList.get(i));
                    if (isChange) break;
                }
            }
            this.tx.beginRequired();
            fontLibDao.updateFontInfo(fontId, code, displayName, this.qingContext.getUserId());
            LinkedList fileNeedDelete = new LinkedList();
            if (isChange) {
                LinkedList<String> newQingTypePaths = new LinkedList<String>();
                LinkedList<String> oldQingTypePaths = new LinkedList<String>();
                for (FontResourcePo newPo : newResourcePoList) {
                    if (newPo.getPathTypeEnum() != FontPathTypeEnum.QING) continue;
                    newQingTypePaths.add(newPo.getPath());
                }
                for (FontResourcePo oldPo : oldResourcePoList) {
                    if (oldPo.getPathTypeEnum() != FontPathTypeEnum.QING) continue;
                    oldQingTypePaths.add(oldPo.getPath());
                }
                LinkedList fileNeedAdd = new LinkedList(newQingTypePaths);
                fileNeedAdd.removeAll(oldQingTypePaths);
                fileNeedDelete.addAll(oldQingTypePaths);
                fileNeedDelete.removeAll(newQingTypePaths);
                fontLibDao.deleteFontResourcesByFontId(fontId);
                for (FontResourcePo newResourcePo : newResourcePoList) {
                    String resourceId = newResourcePo.getId();
                    if (StringUtils.isEmpty((CharSequence)resourceId)) {
                        newResourcePo.setId(UUID.randomUUID().toString());
                    }
                    newResourcePo.setFontId(fontId);
                    String path = newResourcePo.getPath();
                    if (newResourcePo.getPathType() != FontPathTypeEnum.QING.getIndex() || !fileNeedAdd.contains(path)) continue;
                    String fileName = this.transferTempToPersistent(newResourcePo);
                    successPersistentFileNames.add(fileName);
                    newResourcePo.setPath(fileName);
                }
                fontLibDao.batchAddFontResource(newResourcePoList);
            }
            updateLock.lock();
            this.updateDynamicGenerateFileWithNoTx();
            FontLibUtils.deleteFontFiles((QingContext)this.qingContext, fileNeedDelete);
            FontVo fontVo = newFontVo;
            return fontVo;
        }
        catch (Exception e) {
            this.tx.markRollback();
            FontLibUtils.deleteFontFiles((QingContext)this.qingContext, successPersistentFileNames);
            throw e;
        }
        finally {
            this.tx.end();
            updateLock.unlock();
        }
    }

    private void checkDuplicatedName(String fontId, String code, String displayName) throws AbstractQingIntegratedException, SQLException, FontDuplicatedException {
        boolean isDisplayNameDuplicated;
        boolean isCodeDuplicated;
        FontLibDao fontLibDao = this.getFontDao();
        if (StringUtils.isEmpty((CharSequence)fontId)) {
            isCodeDuplicated = !fontLibDao.checkNameAvailable(code, true, null);
            isDisplayNameDuplicated = !fontLibDao.checkNameAvailable(displayName, false, null);
        } else {
            isCodeDuplicated = !fontLibDao.checkNameAvailable(code, true, fontId);
            boolean bl = isDisplayNameDuplicated = !fontLibDao.checkNameAvailable(displayName, false, fontId);
        }
        if (isCodeDuplicated && isDisplayNameDuplicated) {
            throw new FontDuplicatedException();
        }
        if (isCodeDuplicated) {
            throw new FontCodeDuplicatedException();
        }
        if (isDisplayNameDuplicated) {
            throw new FontDisplayNameDuplicatedException();
        }
    }

    private void batchRemove(List<String> fontIds) throws AbstractQingIntegratedException, SQLException, UpdateDynamicFileException, NoRemovePermissionForPresetFont {
        FontLibDao fontLibDao = this.getFontDao();
        boolean isHavePresetFontId = false;
        if (!this.qingContext.getUserId().equals(IntegratedHelper.getPresetUserId())) {
            List presetIds = fontLibDao.loadAllPresetFontId();
            isHavePresetFontId = fontIds.removeAll(presetIds);
        }
        List fontFileNames = fontLibDao.loadUploadFileNameByFontIds(fontIds);
        fontLibDao.batchRemoveFonts(fontIds);
        this.updateDynamicGenerateFileWithNoTx();
        FontLibUtils.deleteFontFiles((QingContext)this.qingContext, (List)fontFileNames);
        if (isHavePresetFontId) {
            throw new NoRemovePermissionForPresetFont();
        }
    }

    public void batchRemoveFonts(List<String> fontIds) throws Exception {
        if (fontIds.size() > 0) {
            ILock removeLock = LockFactory.createLock((String)this.getFontLibOperationLockKey());
            try {
                removeLock.lock();
                this.batchRemoveWithTX(fontIds);
            }
            finally {
                removeLock.unlock();
            }
            try {
                FontOpLog fontOpLog = FontOpLog.EMPTY_DIR;
                fontOpLog.setParamsDesc(FontOpLogParamDesc.createMultiFontCodes((int)fontIds.size()));
                OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)fontOpLog, fontIds));
            }
            catch (Exception e) {
                LogUtil.warn((String)("\u5220\u9664\u5b57\u4f53\u540e\u6dfb\u52a0\u4e0a\u673a\u65e5\u5fd7\u5931\u8d25\u3002\n" + e.getMessage()));
            }
        }
    }

    private void batchRemoveWithTX(List<String> fontIds) throws Exception {
        try {
            this.tx.beginRequired();
            this.batchRemove(fontIds);
        }
        catch (NoRemovePermissionForPresetFont e) {
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new FontLibException((Throwable)e);
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void batchRemovePresetFonts(List<String> fontCodes) throws Exception {
        if (CollectionUtils.isNotEmpty(fontCodes)) {
            List fontIds = this.getFontDao().batchLoadPresetFontIds(fontCodes);
            this.batchRemoveFonts(fontIds);
        }
    }

    public UploadFileInfo getFileInfo(String fileName) throws AbstractQingIntegratedException, SQLException {
        return StringUtils.isNotEmpty((CharSequence)fileName) ? this.getFontDao().getFileInfo(fileName) : null;
    }

    public List<String> loadFontLibIds(String searchContent) throws AbstractQingIntegratedException, SQLException {
        return this.getFontDao().loadFontLibIds(searchContent);
    }

    public FontVo loadFontInfo(String fontId) throws AbstractQingIntegratedException, SQLException {
        return this.getFontDao().loadFont(fontId);
    }

    public Map<String, Object> loadFontLibInfos(int targetPage, int pageSize, String searchContent) throws AbstractQingIntegratedException, SQLException {
        FontLibDao fontLibDao = this.getFontDao();
        int totalRow = fontLibDao.getFontTotalRows(searchContent);
        PaginationRequestData paginationRequestData = PaginationUtil.getCorrectRequestData((Integer)totalRow, (Integer)targetPage, (Integer)pageSize);
        List<FontPo> fontPos = new LinkedList();
        if (totalRow > 0) {
            int offset;
            int paginationPageSize = paginationRequestData.getPageSize();
            int presetCount = this.getFontDao().getPresetFontTotalRows(searchContent);
            if (presetCount > (offset = paginationRequestData.getOffSet().intValue())) {
                fontPos = this.getFontDao().loadAllPresetFonts(offset, paginationPageSize, searchContent);
            } else {
                offset -= presetCount;
            }
            int presetFontCountCurrentPage = fontPos.size();
            if (paginationPageSize > presetFontCountCurrentPage) {
                paginationRequestData.setPageSize(Integer.valueOf(paginationPageSize - presetFontCountCurrentPage));
                paginationRequestData.setOffSet(Integer.valueOf(offset));
                fontPos.addAll(this.loadFontLibNoPresetInfos(paginationRequestData, searchContent));
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("totalRow", totalRow);
        result.put("fonts", fontPos);
        return result;
    }

    private List<FontPo> loadFontLibNoPresetInfos(PaginationRequestData paginationRequestData, String searchContent) throws AbstractQingIntegratedException, SQLException {
        List fontPos = this.getFontDao().loadAllNoPresetFonts(paginationRequestData.getOffSet().intValue(), paginationRequestData.getPageSize().intValue(), searchContent);
        for (FontPo fontPo : fontPos) {
            fontPo.setCreatorName(IntegratedHelper.getUserName((String)fontPo.getCreatorId()));
            fontPo.setModifierName(IntegratedHelper.getUserName((String)fontPo.getModifierId()));
        }
        return fontPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontVo addFont(FontVo fontVo) throws Exception {
        FontVo newFontVo;
        ILock addLock = null;
        try {
            addLock = LockFactory.createLock((String)this.getFontLibOperationLockKey());
            addLock.lock();
            newFontVo = this.addFontWithTx(fontVo);
        }
        finally {
            if (addLock != null) {
                addLock.unlock();
            }
        }
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            FontOpLog fontOpLog = FontOpLog.EMPTY_DIR;
            fontOpLog.setParamsDesc(FontOpLogParamDesc.SINGLE_NAME.getValue());
            params.add(fontVo.getCode());
            params.add(fontVo.getDisplayName());
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)fontOpLog, params));
        }
        catch (Exception e) {
            LogUtil.warn((String)("\u65b0\u589e\u5b57\u4f53\u540e\u6dfb\u52a0\u4e0a\u673a\u65e5\u5fd7\u5931\u8d25\u3002\n" + e.getMessage()));
        }
        return newFontVo;
    }

    private FontVo addFontWithTx(FontVo fontVo) throws Exception {
        LinkedList<String> successPersistentFileNames = new LinkedList<String>();
        try {
            this.tx.beginRequired();
            this.checkDuplicatedName(null, fontVo.getCode(), fontVo.getDisplayName());
            this.fixReferences(fontVo);
            this.saveFontEntity((FontEntity)fontVo, successPersistentFileNames);
            this.updateDynamicGenerateFileWithNoTx();
            FontVo fontVo2 = fontVo;
            return fontVo2;
        }
        catch (FontDuplicatedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (Exception e) {
            FontLibUtils.deleteFontFiles((QingContext)this.qingContext, successPersistentFileNames);
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void fixReferences(FontVo fontVo) {
        String fontId = UUID.randomUUID().toString();
        fontVo.setId(fontId);
        for (FontResourcePo resourcePo : fontVo.getFontResourcePos()) {
            resourcePo.setId(UUID.randomUUID().toString());
            resourcePo.setFontId(fontId);
        }
    }

    private void saveFontEntity(FontEntity fontEntity, List<String> successPersistentFileNames) throws FontFilePersistentException, UploadFileNoExistException, SQLException, AbstractQingIntegratedException {
        FontPo fontPo = this.buildFontBasicInfo(fontEntity);
        List<FontResourcePo> resourcePoList = this.buildFontResourceInfo(fontEntity.getFontResourcePos(), successPersistentFileNames);
        FontLibDao fontLibDao = this.getFontDao();
        fontLibDao.saveFontBasicInfo(fontPo);
        fontLibDao.batchAddFontResource(resourcePoList);
    }

    private FontPo buildFontBasicInfo(FontEntity fontEntity) {
        String userId = this.qingContext.getUserId();
        Date date = new Date();
        FontPo fontPo = new FontPo();
        fontPo.setId(fontEntity.getId());
        fontPo.setCode(fontEntity.getCode());
        fontPo.setDisplayName(fontEntity.getDisplayName());
        fontPo.setCreatorId(userId);
        fontPo.setModifierId(userId);
        fontPo.setCreateTime(date);
        fontPo.setModifyTime(date);
        return fontPo;
    }

    private List<FontResourcePo> buildFontResourceInfo(List<FontResourcePo> resourcePoList, List<String> successPersistentFileNames) throws FontFilePersistentException, UploadFileNoExistException {
        for (FontResourcePo fontResource : resourcePoList) {
            FontPathTypeEnum pathType = fontResource.getPathTypeEnum();
            if (pathType != FontPathTypeEnum.QING && pathType != FontPathTypeEnum.PRESET) continue;
            String fileName = this.transferTempToPersistent(fontResource);
            successPersistentFileNames.add(fileName);
            fontResource.setPath(fileName);
        }
        return resourcePoList;
    }

    private String transferTempToPersistent(FontResourcePo fontResource) throws FontFilePersistentException, UploadFileNoExistException {
        QingInputStream inputStream;
        block5: {
            inputStream = null;
            QingFileResourceInfo fileResourceInfo = new QingFileResourceInfo();
            fileResourceInfo.setFromId(fontResource.getId());
            fileResourceInfo.setFromType(ResourceFromType.FONTLIBRARY);
            fileResourceInfo.setDisplayName(fontResource.getFileDisplayName());
            String tempFileName = fontResource.getPath();
            IQingFileVisitor tempFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.UPLOAD, (String)tempFileName);
            IQingFile newPersistentFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)fileResourceInfo, (QingPersistentFileType)QingPersistentFileType.FONT_LIB);
            if (!tempFileVisitor.exists()) break block5;
            inputStream = tempFileVisitor.getInputStream();
            newPersistentFile.write((IWriteCall)new FontFileWriteCall((InputStream)inputStream), true);
            String string = newPersistentFile.getName();
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            return string;
        }
        try {
            try {
                throw new UploadFileNoExistException();
            }
            catch (IOException e) {
                throw new FontFilePersistentException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
    }

    private void updateDynamicGenerateFileWithNoTx() throws AbstractQingIntegratedException, SQLException, UpdateDynamicFileException {
        this.updateDynamicGenerateFileWithNoDeleteCache();
        String accountId = this.qingContext.getAccountId();
        QingSessionUtil.getGlobalQingSessionImpl().remove(DynamicFileTypeEnum.CSS.getKey(accountId));
        QingSessionUtil.getGlobalQingSessionImpl().remove(DynamicFileTypeEnum.JS.getKey(accountId));
    }

    private void updateDynamicGenerateFileWithNoDeleteCache() throws UpdateDynamicFileException, AbstractQingIntegratedException, SQLException {
        List cssAndJsVoList = this.getFontDao().loadFontLib();
        HashMap<String, List<FontResourcePo>> mapForCss = new HashMap<String, List<FontResourcePo>>(cssAndJsVoList.size());
        HashMap<String, String> mapForJs = new HashMap<String, String>(cssAndJsVoList.size());
        for (FontVo vo : cssAndJsVoList) {
            String code = vo.getCode();
            mapForCss.put(code, vo.getFontResourcePos());
            mapForJs.put(code, vo.getDisplayName());
        }
        try {
            this.doUpdateCss(mapForCss);
            this.doUpdateJs(mapForJs);
        }
        catch (IOException e) {
            throw new UpdateDynamicFileException((Throwable)e);
        }
    }

    private void doUpdateCss(Map<String, List<FontResourcePo>> mapForCss) throws AbstractQingIntegratedException, SQLException, IOException {
        StringBuilder allFontFaces = new StringBuilder();
        for (Map.Entry<String, List<FontResourcePo>> entry : mapForCss.entrySet()) {
            String oneFontFace = this.generateOneFontFace(entry.getKey(), entry.getValue());
            allFontFaces.append(oneFontFace).append("\n");
        }
        this.getFontDao().updateDynamicGenerateContent(DynamicFileTypeEnum.CSS, StringUtils.getBytes((String)allFontFaces.toString()));
    }

    private String generateOneFontFace(String familyName, List<FontResourcePo> fontResourcePos) {
        Collections.sort(fontResourcePos, FontResourceComparator.getInstance());
        StringBuilder src = new StringBuilder("\n");
        for (FontResourcePo fontResourcePo : fontResourcePos) {
            String url;
            FontPathTypeEnum type = fontResourcePo.getPathTypeEnum();
            if (type == FontPathTypeEnum.QING || type == FontPathTypeEnum.PRESET) {
                url = this.convertIntoQing(fontResourcePo.getPath());
            } else if (type == FontPathTypeEnum.LOCAL) {
                url = this.convertIntoLocal(fontResourcePo.getPath());
            } else if (type == FontPathTypeEnum.OTHER) {
                url = this.convertIntoOther(fontResourcePo.getPath());
            } else {
                throw new RuntimeException();
            }
            src.append("\t").append(url).append(",").append("\n");
        }
        int len = src.length();
        src.delete(len - 2, len - 1);
        return String.format(this.getCssFileTemplate(), familyName, src);
    }

    private String convertIntoLocal(String localName) {
        return "local(\"" + localName + "\")";
    }

    private String convertIntoQing(String fileName) {
        return "url(\"" + this.prefixPath + "?fileName=" + fileName + "\")";
    }

    private String convertIntoOther(String url) {
        return "url(\"" + url + "\")";
    }

    private void doUpdateJs(Map<String, String> mapForJs) throws IOException, AbstractQingIntegratedException, SQLException {
        String jsContent = this.getJsFileTemplate().replace("#1", this.convertIntoArrays(mapForJs));
        this.getFontDao().updateDynamicGenerateContent(DynamicFileTypeEnum.JS, StringUtils.getBytes((String)jsContent));
    }

    private String convertIntoArrays(Map<String, String> names) {
        StringBuilder template = new StringBuilder();
        template.append("[");
        if (names.size() > 0) {
            ArrayList<Map.Entry<String, String>> entities = new ArrayList<Map.Entry<String, String>>(names.entrySet());
            Collections.sort(entities, FontDisplayNameComparator.getInstance((Locale)Locale.CHINA));
            for (Map.Entry entry : entities) {
                template.append("[\"").append((String)entry.getKey()).append("\", \"").append((String)entry.getValue()).append("\"]");
                template.append(", ");
            }
            template.delete(template.length() - 2, template.length());
        }
        template.append("]");
        return template.toString();
    }

    private String getCssFileTemplate() {
        if (this.cssFileTemplate == null) {
            this.cssFileTemplate = "@font-face\n{\n\tfont-family: \"%s\";\n\tsrc: %s;\n}";
        }
        return this.cssFileTemplate;
    }

    private String getJsFileTemplate() {
        if (this.jsFileTemplate == null) {
            this.jsFileTemplate = "(function()\n{\n\tvar arrAll = #1;\n\tcom.kingdee.bos.qing.framework.common.FontProvider.register(arrAll);\n})()";
        }
        return this.jsFileTemplate;
    }

    public boolean isFontExist(String fontId) throws AbstractQingIntegratedException, SQLException {
        return this.getFontDao().isFontExist(fontId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void presetFonts(IQingFile presetFontFile) throws Exception {
        FontImporter fontImporter = new FontImporter();
        QingInputStream presetFileInputStream = null;
        try {
            presetFileInputStream = presetFontFile.getInputStream();
            List fontEntities = fontImporter.loadFontEntities((InputStream)presetFileInputStream);
            this.bindHandleStrategy(fontEntities);
            fontImporter.unzipFontFiles(presetFontFile.getName(), fontEntities);
            this.importFontsWithLock(fontEntities);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{presetFileInputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{presetFileInputStream});
    }

    private void bindHandleStrategy(List<ImExportFontEntity> fontEntities) throws AbstractQingIntegratedException, SQLException {
        List<String> codeContainer = this.fetchFontCodes(fontEntities);
        List duplicatedCodes = this.getFontDao().filterOutDuplicatedCode(codeContainer);
        for (ImExportFontEntity font : fontEntities) {
            if (!duplicatedCodes.contains(font.getCode())) continue;
            font.setHandleStrategyEnum(HandleConflictFontStrategy.OVERWRITE);
        }
    }

    private List<String> fetchFontCodes(List<ImExportFontEntity> fontEntities) {
        ArrayList<String> codeContainer = new ArrayList<String>(16);
        for (ImExportFontEntity font : fontEntities) {
            codeContainer.add(font.getCode());
        }
        return codeContainer;
    }

    public String exportFonts(List<String> selectedFontIds) throws Exception {
        if (CollectionUtils.isEmpty(selectedFontIds)) {
            return null;
        }
        List<ImExportFontEntity> exportFonts = this.collectExportFonts(selectedFontIds);
        FontExporter fontExporter = new FontExporter();
        return fontExporter.doExport(exportFonts);
    }

    private List<ImExportFontEntity> collectExportFonts(List<String> selectedFontIds) throws AbstractQingIntegratedException, SQLException, NoExportPermissionForPresetFont {
        FontLibDao fontLibDao = this.getFontDao();
        List presetIds = fontLibDao.loadAllPresetFontId();
        if (selectedFontIds.removeAll(presetIds)) {
            throw new NoExportPermissionForPresetFont();
        }
        return fontLibDao.loadFontVoByIds(selectedFontIds);
    }

    public List<ImportFontVo> parseImportFile(String fileName) throws FontLibException {
        List<ImExportFontEntity> fontEntities = this.loadFontEntitiesFromFile(fileName);
        return this.convertVo(fontEntities);
    }

    private List<ImportFontVo> convertVo(List<ImExportFontEntity> fontEntities) {
        if (CollectionUtils.isEmpty(fontEntities)) {
            return Collections.emptyList();
        }
        ArrayList<ImportFontVo> fontEntitiesForImport = new ArrayList<ImportFontVo>(fontEntities.size());
        for (ImExportFontEntity font : fontEntities) {
            ImportFontVo importFontVo = new ImportFontVo(font.getCode(), font.getDisplayName());
            fontEntitiesForImport.add(importFontVo);
        }
        return fontEntitiesForImport;
    }

    public List<ImExportFontEntity> loadFontEntitiesFromFile(String fileName) throws ParsePackageMetaException, NoFoundImportFileException, CreateZipInputStreamException {
        FontImporter fontImporter = new FontImporter();
        return fontImporter.loadFontEntities(fileName);
    }

    private void unzipFontFiles(String fileName, List<ImExportFontEntity> fontEntities) throws NoFoundImportFileException, IOException {
        FontImporter fontImporter = new FontImporter();
        fontImporter.unzipFontFiles(fileName, fontEntities);
    }

    public List<String> importFonts(String fileName, List<String> importFontCodes) throws Exception {
        if (CollectionUtils.isEmpty(importFontCodes)) {
            return Collections.emptyList();
        }
        List<ImExportFontEntity> fontEntities = this.collectFontByCodes(fileName, importFontCodes);
        ArrayList<String> conflictFontCodes = new ArrayList<String>(16);
        this.filterCodeDuplicatedFonts(fontEntities, conflictFontCodes);
        this.unzipFontFiles(fileName, fontEntities);
        this.importFontsWithLock(fontEntities);
        return conflictFontCodes;
    }

    public boolean importConflictFonts(String importFileName, List<ImportFontVo> conflictFonts) throws Exception {
        if (CollectionUtils.isEmpty(conflictFonts)) {
            return false;
        }
        List<ImExportFontEntity> fontEntities = this.collectConflictFonts(importFileName, conflictFonts);
        this.unzipFontFiles(importFileName, fontEntities);
        this.importFontsWithLock(fontEntities);
        return this.isOverwritePresetFont(conflictFonts, fontEntities);
    }

    private boolean isOverwritePresetFont(List<ImportFontVo> importFontVos, List<ImExportFontEntity> imExportFontEntities) {
        ArrayList<String> oldCodes = new ArrayList<String>(16);
        for (ImportFontVo importFontVo : importFontVos) {
            if (importFontVo.getHandleStrategy() != HandleConflictFontStrategy.OVERWRITE.getIndex()) continue;
            oldCodes.add(importFontVo.getCode());
        }
        for (ImExportFontEntity imExportFontEntity : imExportFontEntities) {
            String newCode = imExportFontEntity.getCode();
            if (imExportFontEntity.getHandleStrategyEnum() != HandleConflictFontStrategy.OVERWRITE || oldCodes.contains(newCode)) continue;
            return true;
        }
        return false;
    }

    private List<ImExportFontEntity> collectConflictFonts(String fileName, List<ImportFontVo> conflictFonts) throws ParsePackageMetaException, NoFoundImportFileException, CreateZipInputStreamException {
        ArrayList<String> codeContainer = new ArrayList<String>(16);
        HashMap<String, Integer> handleStrategyMapping = new HashMap<String, Integer>(16);
        for (ImportFontVo fontVo : conflictFonts) {
            String code = fontVo.getCode();
            codeContainer.add(code);
            handleStrategyMapping.put(code, fontVo.getHandleStrategy());
        }
        List<ImExportFontEntity> fontEntities = this.collectFontByCodes(fileName, codeContainer);
        this.fillHandleStrategy(fontEntities, handleStrategyMapping);
        return fontEntities;
    }

    private void fillHandleStrategy(List<ImExportFontEntity> fontEntities, Map<String, Integer> handleStrategyMapping) {
        for (ImExportFontEntity fontEntity : fontEntities) {
            String code = fontEntity.getCode();
            fontEntity.setHandleStrategy(handleStrategyMapping.get(code).intValue());
        }
    }

    private void importFontsWithLock(List<ImExportFontEntity> importFontEntities) throws Exception {
        if (CollectionUtils.isEmpty(importFontEntities)) {
            return;
        }
        ILock lock = null;
        try {
            lock = LockFactory.createLock((String)this.getFontLibOperationLockKey());
            lock.lock();
            this.importFontsWithTX(importFontEntities);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private void importFontsWithTX(List<ImExportFontEntity> importFontEntities) throws Exception {
        try {
            this.tx.beginRequired();
            this.doImport(importFontEntities);
            this.updateDynamicGenerateFileWithNoTx();
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private void doImport(List<ImExportFontEntity> importFonts) throws Exception {
        ArrayList<String> successPersistentFileNames = new ArrayList<String>(16);
        ArrayList<String> fileNamesToDelete = new ArrayList<String>(16);
        try {
            for (ImExportFontEntity fontEntity : importFonts) {
                switch (1.$SwitchMap$com$kingdee$bos$qing$fontlibrary$model$HandleConflictFontStrategy[fontEntity.getHandleStrategyEnum().ordinal()]) {
                    case 1: {
                        this.importFontDirect(fontEntity, successPersistentFileNames);
                        break;
                    }
                    case 2: {
                        this.overwriteFont(fontEntity, successPersistentFileNames, fileNamesToDelete);
                        break;
                    }
                    case 3: {
                        this.renameFont(fontEntity, successPersistentFileNames);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(fileNamesToDelete)) {
                FontLibUtils.deleteFontFiles((QingContext)this.qingContext, fileNamesToDelete);
            }
        }
        catch (Exception e) {
            FontLibUtils.deleteFontFiles((QingContext)this.qingContext, successPersistentFileNames);
            throw e;
        }
    }

    private void importFontDirect(ImExportFontEntity fontEntity, List<String> successPersistentFileNames) throws SQLException, AbstractQingIntegratedException, FontFilePersistentException, UploadFileNoExistException {
        String newDisplayName = this.getAvailableName(fontEntity.getDisplayName(), false);
        fontEntity.setDisplayName(newDisplayName);
        this.saveFontEntity((FontEntity)fontEntity, successPersistentFileNames);
    }

    private void overwriteFont(ImExportFontEntity fontEntity, List<String> successPersistentFileNames, List<String> fileNamesToDelete) throws AbstractQingIntegratedException, SQLException, FontFilePersistentException, UploadFileNoExistException {
        FontPo oldFont = this.getFontDao().loadFontInfoByCode(fontEntity.getCode());
        this.fixName((FontEntity)fontEntity, oldFont);
        String presetUserId = IntegratedHelper.getPresetUserId();
        boolean isPresetFont = presetUserId.equals(oldFont.getCreatorId());
        boolean isPresetRole = presetUserId.equals(this.qingContext.getUserId());
        if (!isPresetFont || isPresetRole) {
            this.reservedFontIdReference(oldFont.getId(), fontEntity);
            this.removeOldFont(oldFont.getId(), fileNamesToDelete);
        }
        this.saveFontEntity((FontEntity)fontEntity, successPersistentFileNames);
    }

    private void renameFont(ImExportFontEntity fontEntity, List<String> successPersistentFileNames) throws AbstractQingIntegratedException, SQLException, FontFilePersistentException, UploadFileNoExistException {
        String newCode = this.getAvailableName(fontEntity.getCode(), true);
        String newDisplayName = this.getAvailableName(fontEntity.getDisplayName(), false);
        fontEntity.setCode(newCode);
        fontEntity.setDisplayName(newDisplayName);
        this.saveFontEntity((FontEntity)fontEntity, successPersistentFileNames);
    }

    private void fixName(FontEntity newFont, FontPo oldFont) throws AbstractQingIntegratedException, SQLException {
        this.fixCode(newFont, oldFont);
        this.fixDisplayName(newFont, oldFont);
    }

    private void fixCode(FontEntity newFont, FontPo oldFont) throws AbstractQingIntegratedException, SQLException {
        String presetUserId = IntegratedHelper.getPresetUserId();
        String currentUserId = this.qingContext.getUserId();
        if (presetUserId.equals(oldFont.getCreatorId()) && !presetUserId.equals(currentUserId)) {
            String newCode = this.getAvailableName(newFont.getCode(), true);
            newFont.setCode(newCode);
        }
    }

    private void fixDisplayName(FontEntity newFont, FontPo oldFont) throws AbstractQingIntegratedException, SQLException {
        String presetUserId = IntegratedHelper.getPresetUserId();
        String newDisplayName = newFont.getDisplayName();
        String oldDisplayName = oldFont.getDisplayName();
        if (presetUserId.equals(this.qingContext.getUserId())) {
            if (presetUserId.equals(oldFont.getCreatorId()) && !newDisplayName.equals(oldDisplayName)) {
                newDisplayName = this.getAvailableName(newFont.getDisplayName(), false);
            }
        } else if (newDisplayName.equals(oldDisplayName)) {
            if (presetUserId.equals(oldFont.getCreatorId())) {
                newDisplayName = this.getAvailableName(newFont.getDisplayName(), false);
            }
        } else {
            newDisplayName = this.getAvailableName(newFont.getDisplayName(), false);
        }
        newFont.setDisplayName(newDisplayName);
    }

    private String getAvailableName(String oldName, boolean isCode) throws AbstractQingIntegratedException, SQLException {
        FontLibDao fontLibDao = this.getFontDao();
        String newName = oldName;
        boolean isAvailable = fontLibDao.checkNameAvailable(newName, isCode, null);
        while (!isAvailable) {
            newName = ImExportUtil.rename((String)newName);
            isAvailable = fontLibDao.checkNameAvailable(newName, isCode, null);
        }
        return newName;
    }

    private void removeOldFont(String fontId, List<String> fileNameToDelete) throws AbstractQingIntegratedException, SQLException {
        FontLibDao fontLibDao = this.getFontDao();
        fileNameToDelete.addAll(fontLibDao.loadUploadFileNameByFontId(fontId));
        fontLibDao.removeFont(fontId);
    }

    private void reservedFontIdReference(String oldFontId, ImExportFontEntity fontEntity) {
        fontEntity.setId(oldFontId);
        for (FontResourcePo resourcePo : fontEntity.getFontResourcePos()) {
            resourcePo.setFontId(oldFontId);
        }
    }

    private void filterCodeDuplicatedFonts(List<ImExportFontEntity> fontEntities, List<String> conflictFontCodes) throws AbstractQingIntegratedException, SQLException {
        List<String> codeContainer = this.fetchFontCodes(fontEntities);
        List duplicatedCodes = this.getFontDao().filterOutDuplicatedCode(codeContainer);
        ArrayList<ImExportFontEntity> duplicatedFontVos = new ArrayList<ImExportFontEntity>(16);
        for (ImExportFontEntity font : fontEntities) {
            String code = font.getCode();
            if (!duplicatedCodes.contains(code)) continue;
            conflictFontCodes.add(code);
            duplicatedFontVos.add(font);
        }
        fontEntities.removeAll(duplicatedFontVos);
    }

    private List<ImExportFontEntity> collectFontByCodes(String fileName, List<String> fontCodes) throws ParsePackageMetaException, NoFoundImportFileException, CreateZipInputStreamException {
        List<ImExportFontEntity> allFontEntities = this.loadFontEntitiesFromFile(fileName);
        ArrayList<ImExportFontEntity> importFontEntities = new ArrayList<ImExportFontEntity>(16);
        for (ImExportFontEntity font : allFontEntities) {
            String fontCode = font.getCode();
            if (!fontCodes.contains(fontCode)) continue;
            importFontEntities.add(font);
        }
        return importFontEntities;
    }
}

