/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imagelibrary.dao;

import com.kingdee.bos.qing.common.Messages;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.PathModel;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.imagelibrary.exception.CategoryDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageDuplicateNameException;
import com.kingdee.bos.qing.imagelibrary.exception.ImageNotFoundException;
import com.kingdee.bos.qing.imagelibrary.imexport.model.NameSpace;
import com.kingdee.bos.qing.imagelibrary.imexport.model.Picture;
import com.kingdee.bos.qing.imagelibrary.model.CategoryTypeEnum;
import com.kingdee.bos.qing.imagelibrary.model.ImageCategory;
import com.kingdee.bos.qing.imagelibrary.model.ImageModel;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.sqlcondition.InSqlConditionBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImageLibraryDao {
    private static final String FID = "FID";
    private static final String FCATEGORYNAME = "FNAME";
    private static final String FISPUBLIC = "FISPUBLIC";
    private static final String FUSERID = "FUSERID";
    private static final String FORDERID = "FORDERID";
    private static final String FCATEGORYID = "FCATEGORYID";
    private static final String FIMAGEFILENAME = "FIMAGEFILENAME";
    private static final String FIMAGENAME = "FIMAGENAME";
    private static final String FTHUMBNAILFILENAME = "FTHUMBNAILFILENAME";
    private static final String FIMAGEWIDTH = "FIMAGEWIDTH";
    private static final String FIMAGEHEIGHT = "FIMAGEHEIGHT";
    private static final String FPARENTID = "FPARENTID";
    private IDBExcuter dbExcuter;

    public ImageLibraryDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private boolean isPublicByTag(String tag) {
        return tag.equals(CategoryTypeEnum.PUBLIC.getType()) || tag.equals(CategoryTypeEnum.PUBLICGALLERY.getType());
    }

    private boolean isGalleryByTag(String tag) {
        return tag.equals(CategoryTypeEnum.PRIVATEGALLERY.getType()) || tag.equals(CategoryTypeEnum.PUBLICGALLERY.getType());
    }

    public void deleteCategory(String categoryId) throws SQLException, AbstractQingIntegratedException {
        this.dbExcuter.execute("DELETE FROM T_QING_IMGLIB_CATEGORY WHERE FID=?", new Object[]{categoryId});
    }

    public List<ImageCategory> getAllCategory(String userId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FNAME, FUSERID, FORDERID, FISPUBLIC, FPARENTID FROM T_QING_IMGLIB_CATEGORY WHERE ((FISPUBLIC = '0' OR FISPUBLIC = '2') AND FUSERID=?) OR FISPUBLIC='1' OR FISPUBLIC='3' ORDER BY FORDERID DESC, FCREATEDATE ASC", new Object[]{userId}, (ResultHandler)new ResultHandler<List<ImageCategory>>(){

            public List<ImageCategory> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageCategory> categories = new ArrayList<ImageCategory>(10);
                while (rs.next()) {
                    ImageCategory category = new ImageCategory();
                    category.setId(rs.getString(ImageLibraryDao.FID));
                    category.setName(rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    category.setPublic(ImageLibraryDao.this.isPublicByTag(rs.getString(ImageLibraryDao.FISPUBLIC)));
                    category.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    category.setOrder(rs.getInt(ImageLibraryDao.FORDERID));
                    category.setParentId(rs.getString(ImageLibraryDao.FPARENTID));
                    category.setGallery(ImageLibraryDao.this.isGalleryByTag(rs.getString(ImageLibraryDao.FISPUBLIC)));
                    categories.add(category);
                }
                return categories;
            }
        });
    }

    public int getCategoryCountByParentId(String categoryId) throws SQLException, AbstractQingIntegratedException {
        return (Integer)this.dbExcuter.query("SELECT COUNT(1) CATEGORY_COUNT FROM T_QING_IMGLIB_CATEGORY WHERE FPARENTID = ?", new Object[]{categoryId}, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("CATEGORY_COUNT");
                }
                return 0;
            }
        });
    }

    public String saveOrUpdateCategory(String userId, ImageCategory category) throws SQLException, CategoryDuplicateNameException, AbstractQingIntegratedException {
        String categoryId = category.getId();
        int categoryOrder = category.getOrder();
        String categoryName = category.getName();
        String parentId = category.getParentId() == null ? " " : category.getParentId();
        CategoryTypeEnum categoryType = category.getCategoryTypeEnum();
        ImageCategory imageCategory = this.getCategoryByNameAndParentId(categoryType, categoryName, userId, parentId);
        if (imageCategory != null) {
            if (imageCategory.isGallery() && imageCategory.getOrder() != categoryOrder) {
                this.updateGalleryCategoryOrder(categoryOrder, imageCategory.getId());
            }
            throw new CategoryDuplicateNameException("Category Name Exist");
        }
        String fId = categoryId;
        if (fId == null || "".equals(fId)) {
            Object[] params = new Object[8];
            fId = this.dbExcuter.genStringId("T_QING_IMGLIB_CATEGORY");
            category.setId(fId);
            params[0] = fId;
            params[1] = userId;
            params[2] = categoryName;
            params[3] = new Date();
            params[4] = new Date();
            params[5] = categoryOrder;
            params[6] = categoryType.getType();
            params[7] = parentId;
            this.dbExcuter.execute("INSERT INTO T_QING_IMGLIB_CATEGORY (FID,FUSERID,FNAME,FCREATEDATE,FUPDATEDATE,FORDERID,FISPUBLIC,FPARENTID) VALUES(?,?,?,?,?,?,?,?)", params);
        } else {
            this.updateCategory(categoryName, categoryId);
        }
        return fId;
    }

    public String saveCategory(String userId, ImageCategory category) throws SQLException, AbstractQingIntegratedException {
        String categoryName = category.getName();
        int categoryOrder = category.getOrder();
        String parentId = category.getParentId() == null ? " " : category.getParentId();
        Object[] params = new Object[8];
        String fId = this.dbExcuter.genStringId("T_QING_IMGLIB_CATEGORY");
        category.setId(fId);
        params[0] = fId;
        params[1] = userId;
        params[2] = categoryName;
        params[3] = new Date();
        params[4] = new Date();
        params[5] = categoryOrder;
        params[6] = category.getCategoryTypeEnum().getType();
        params[7] = parentId;
        this.dbExcuter.execute("INSERT INTO T_QING_IMGLIB_CATEGORY (FID,FUSERID,FNAME,FCREATEDATE,FUPDATEDATE,FORDERID,FISPUBLIC,FPARENTID) VALUES(?,?,?,?,?,?,?,?)", params);
        return fId;
    }

    public String getCategoryIdByName(String categoryName, boolean isPublic, String userId) throws AbstractQingIntegratedException, SQLException {
        ImageCategory imageCategory = this.getCategoryByFullName(isPublic, categoryName, userId);
        return imageCategory == null ? null : imageCategory.getId();
    }

    public void updateCategory(String newCategoryName, String categoryId) throws SQLException, AbstractQingIntegratedException {
        Object[] params = new Object[]{newCategoryName, new Date(), categoryId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_CATEGORY SET FNAME = ?, FUPDATEDATE = ? WHERE FID = ?", params);
    }

    public void updateGalleryCategoryOrder(int categoryOrder, String categoryId) throws SQLException, AbstractQingIntegratedException {
        Object[] params = new Object[]{categoryOrder, new Date(), categoryId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_CATEGORY SET FORDERID = ?, FUPDATEDATE = ? WHERE FID=?", params);
    }

    public ImageCategory getCategoryByFid(final String fid) throws AbstractQingIntegratedException, SQLException {
        return (ImageCategory)this.dbExcuter.query("SELECT FID, FNAME, FISPUBLIC, FUSERID, FORDERID, FPARENTID FROM T_QING_IMGLIB_CATEGORY WHERE FID = ?", new Object[]{fid}, (ResultHandler)new ResultHandler<ImageCategory>(){

            public ImageCategory handle(ResultSet rs) throws SQLException {
                ImageCategory imageCategory = null;
                while (rs.next()) {
                    String userId = rs.getString(ImageLibraryDao.FUSERID);
                    imageCategory = new ImageCategory();
                    imageCategory.setPublic(ImageLibraryDao.this.isPublicByTag(rs.getString(ImageLibraryDao.FISPUBLIC)));
                    imageCategory.setId(fid);
                    imageCategory.setName(rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    imageCategory.setUserId(userId);
                    imageCategory.setParentId(rs.getString(ImageLibraryDao.FPARENTID));
                    imageCategory.setGallery(ImageLibraryDao.this.isGalleryByTag(rs.getString(ImageLibraryDao.FISPUBLIC)));
                    imageCategory.setOrder(rs.getInt(ImageLibraryDao.FORDERID));
                    imageCategory.setPreset(userId.equals(IntegratedHelper.getPresetUserId()));
                }
                return imageCategory;
            }
        });
    }

    public void saveImageInfo(ImageModel imageModel) throws SQLException, AbstractQingIntegratedException {
        Object[] params = new Object[]{imageModel.getId(), imageModel.getThumbnailFileName(), imageModel.getCategoryId(), imageModel.getImageFileName(), imageModel.getImageName(), imageModel.getUserId(), new Date(), imageModel.getImageWidth(), imageModel.getImageHeight()};
        this.dbExcuter.execute("INSERT INTO T_QING_IMGLIB_IMG_INFO (FID,FTHUMBNAILFILENAME,FCATEGORYID,FIMAGEFILENAME,FIMAGENAME,FUSERID,FUPLOADDATE,FIMAGEWIDTH,FIMAGEHEIGHT) VALUES(?,?,?,?,?,?,?,?,?)", params);
    }

    public String getCategoryNameByFid(String fid) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FNAME FROM T_QING_IMGLIB_CATEGORY WHERE FID = ?", new Object[]{fid}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String categoryName = null;
                while (rs.next()) {
                    categoryName = rs.getString(ImageLibraryDao.FCATEGORYNAME);
                }
                return categoryName;
            }
        });
    }

    public String getCategoryParentIdByFid(String fid) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FPARENTID FROM T_QING_IMGLIB_CATEGORY WHERE FID = ?", new Object[]{fid}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String parentId = null;
                while (rs.next()) {
                    parentId = rs.getString(ImageLibraryDao.FPARENTID);
                }
                return parentId;
            }
        });
    }

    public void updateImageCategoryForOrder(List<Object[]> paramsList) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.executeBatch("UPDATE T_QING_IMGLIB_CATEGORY SET FORDERID = ?, FUPDATEDATE = ? WHERE FID=?", paramsList);
    }

    public List<ImageModel> getAllImage(String userId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT TQII.FID , TQII.FTHUMBNAILFILENAME, TQII.FCATEGORYID, TQII.FIMAGEFILENAME, TQII.FIMAGENAME, TQII.FIMAGEWIDTH, TQII.FIMAGEHEIGHT, TQII.FUSERID FROM T_QING_IMGLIB_IMG_INFO TQII WHERE TQII.FCATEGORYID IN (SELECT FID FROM T_QING_IMGLIB_CATEGORY TQIC WHERE (TQIC.FUSERID = ? AND (FISPUBLIC='0' OR FISPUBLIC='2')) OR (FISPUBLIC='1' OR FISPUBLIC='3')) ORDER BY TQII.FUPLOADDATE DESC", new Object[]{userId}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString(ImageLibraryDao.FID));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    boolean exists = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)imageInfo.getImageFileName()).exists();
                    imageInfo.setHasContent(exists);
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public List<ImageModel> getAllImageByCategoryId(String categoryId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID=? ORDER BY FUPLOADDATE DESC", new Object[]{categoryId}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString(ImageLibraryDao.FID));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    boolean exists = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)imageInfo.getImageFileName()).exists();
                    imageInfo.setHasContent(exists);
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public int getImageCountByCategoryId(String categoryId) throws SQLException, AbstractQingIntegratedException {
        return (Integer)this.dbExcuter.query("SELECT COUNT(1) IMG_COUNT FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID=?", new Object[]{categoryId}, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("IMG_COUNT");
                }
                return 0;
            }
        });
    }

    public List<ImageModel> getAllPresetImageOfCategory(String categoryId) throws SQLException, AbstractQingIntegratedException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FCATEGORYID=? AND FUSERID=? ORDER BY FIMAGENAME", new Object[]{categoryId, IntegratedHelper.getPresetUserId()}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString(ImageLibraryDao.FID));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    boolean exists = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)imageInfo.getImageFileName()).exists();
                    imageInfo.setHasContent(exists);
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfo.setPreset(true);
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public void checkImageExist(String imageId, boolean isPublic, String userId) throws AbstractQingIntegratedException, SQLException, ImageNotFoundException {
        ImageModel image = this.getImageById(imageId);
        if (image == null) {
            throw new ImageNotFoundException();
        }
        if (!isPublic && !userId.equals(image.getUserId())) {
            throw new ImageNotFoundException();
        }
    }

    public void deleteImage(String imageId) throws SQLException, AbstractQingIntegratedException {
        this.dbExcuter.execute("DELETE FROM T_QING_IMGLIB_IMG_INFO WHERE FID=?", new Object[]{imageId});
    }

    public void deleteImage(String imageId, String userId) throws SQLException, AbstractQingIntegratedException {
        this.dbExcuter.execute("DELETE FROM T_QING_IMGLIB_IMG_INFO WHERE FID=? AND FUSERID=?", new Object[]{imageId, userId});
    }

    public void moveImage(String imageName, String imageId, String groupId) throws SQLException, AbstractQingIntegratedException, ImageDuplicateNameException {
        boolean bDuplicate = this.checkImageNameDuplicate(imageName, groupId);
        if (bDuplicate) {
            throw new ImageDuplicateNameException("Image name exist.");
        }
        Object[] params = new Object[]{groupId, imageId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_IMG_INFO SET FCATEGORYID = ? WHERE FID = ?", params);
    }

    public void renameImage(String imageName, String imageId, String categoryId) throws AbstractQingIntegratedException, SQLException, ImageDuplicateNameException {
        boolean bDuplicate = this.checkImageNameDuplicate(imageName, categoryId);
        if (bDuplicate) {
            throw new ImageDuplicateNameException("Image name exist.");
        }
        Object[] params = new Object[]{imageName, imageId};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_IMG_INFO SET FIMAGENAME = ? WHERE FID = ?", params);
    }

    public void updateImageFileNameAndSizeById(ImageModel image) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{image.getImageFileName(), image.getImageWidth(), image.getImageHeight(), image.getThumbnailFileName(), image.getId()};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_IMG_INFO SET FIMAGEFILENAME = ?, FIMAGEWIDTH = ?, FIMAGEHEIGHT = ?, FTHUMBNAILFILENAME = ? WHERE FID = ?", params);
    }

    public boolean checkImageNameDuplicate(String imageName, String categoryId) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT FID FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGENAME = ? AND FCATEGORYID = ?", new Object[]{imageName, categoryId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public ImageModel getImageById(String id) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FID, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FTHUMBNAILFILENAME, FUSERID FROM T_QING_IMGLIB_IMG_INFO WHERE FID = ?", new Object[]{id}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setId(rs.getString(ImageLibraryDao.FID));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageModel.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageModel.setUserId(rs.getString(ImageLibraryDao.FUSERID));
                }
                return imageModel;
            }
        });
    }

    public ImageModel getImageByCategoryIdAndName(String imageName, String categoryId) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGENAME = ? AND FCATEGORYID = ?", new Object[]{imageName, categoryId}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setId(rs.getString(ImageLibraryDao.FID));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                }
                return imageModel;
            }
        });
    }

    public List<Picture> getImagesAndIsPublicByIds(List<String> sqlSplit) throws AbstractQingIntegratedException, SQLException {
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(sqlSplit.size());
        String inSql = inSqlConditionBuilder.build("TQII.FID");
        String sql = "SELECT TQIC.FISPUBLIC, TQII.FID , TQII.FCATEGORYID, TQII.FIMAGEFILENAME, TQII.FIMAGENAME, TQIC.FNAME, TQII.FUSERID, TQIC.FORDERID FROM T_QING_IMGLIB_IMG_INFO TQII LEFT JOIN T_QING_IMGLIB_CATEGORY TQIC ON TQIC.FID = TQII.FCATEGORYID WHERE " + inSql;
        return this.getImagesAndIsPublicBySql(sql, sqlSplit);
    }

    public List<Picture> getImagesAndIsPublicByFileNames(Set<String> sqlSplit) throws AbstractQingIntegratedException, SQLException {
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(sqlSplit.size());
        String inSql = inSqlConditionBuilder.build("TQII.FIMAGEFILENAME");
        String sql = "SELECT TQIC.FISPUBLIC, TQII.FID , TQII.FCATEGORYID, TQII.FIMAGEFILENAME, TQII.FIMAGENAME, TQIC.FNAME, TQII.FUSERID, TQIC.FORDERID FROM T_QING_IMGLIB_IMG_INFO TQII LEFT JOIN T_QING_IMGLIB_CATEGORY TQIC ON TQIC.FID = TQII.FCATEGORYID WHERE " + inSql;
        return this.getImagesAndIsPublicBySql(sql, sqlSplit);
    }

    private List<Picture> getImagesAndIsPublicBySql(String sql, Collection<String> params) throws AbstractQingIntegratedException, SQLException {
        List pictures = (List)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<List<Picture>>(){

            public List<Picture> handle(ResultSet rs) throws SQLException {
                ArrayList<Picture> pictures = new ArrayList<Picture>(10);
                Picture picture = null;
                while (rs.next()) {
                    picture = new Picture();
                    picture.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    picture.setCategoryName(rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    picture.setId(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    picture.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    String userId = rs.getString(ImageLibraryDao.FUSERID);
                    int strPublic = rs.getInt(ImageLibraryDao.FISPUBLIC);
                    String nameSpace = ImageLibraryDao.this.getNameSpaceByType(strPublic);
                    nameSpace = IntegratedHelper.getPresetUserId().equals(userId) ? NameSpace.system.toPersistance() : nameSpace;
                    picture.setNameSpace(nameSpace);
                    picture.setOrderId(rs.getString(ImageLibraryDao.FORDERID));
                    pictures.add(picture);
                }
                return pictures;
            }
        });
        String categoryId = null;
        for (Picture picture : pictures) {
            categoryId = picture.getCategoryId();
            if (categoryId.isEmpty()) continue;
            Map<String, String> categoryNameAndOrderId = this.getFullCategoryNameAndOrderById(categoryId);
            picture.setOrderId(categoryNameAndOrderId.get(FORDERID));
            picture.setCategoryName(categoryNameAndOrderId.get(FCATEGORYNAME));
        }
        return pictures;
    }

    private String getNameSpaceByType(int strPublic) {
        String nameSpace = null;
        switch (strPublic) {
            case 0: {
                nameSpace = NameSpace.user.toPersistance();
                break;
            }
            case 1: {
                nameSpace = NameSpace.common.toPersistance();
                break;
            }
            case 2: {
                nameSpace = NameSpace.gallery_user.toPersistance();
                break;
            }
            case 3: {
                nameSpace = NameSpace.gallery_common.toPersistance();
                break;
            }
        }
        return nameSpace;
    }

    public String getFullCategoryNameById(String fId) throws AbstractQingIntegratedException, SQLException {
        ImageCategory imageCategory = this.getCategoryByFid(fId);
        String parentId = imageCategory.getParentId();
        StringBuilder fullCategoryName = new StringBuilder(imageCategory.getName());
        while (!parentId.isEmpty()) {
            imageCategory = this.getCategoryByFid(parentId);
            fullCategoryName.insert(0, imageCategory.getName() + "/");
            parentId = imageCategory.getParentId();
        }
        return fullCategoryName.toString();
    }

    public Map<String, String> getFullCategoryNameAndOrderById(String fId) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        ImageCategory imageCategory = this.getCategoryByFid(fId);
        String parentId = imageCategory.getParentId();
        StringBuilder fullOrderId = new StringBuilder(String.valueOf(imageCategory.getOrder()));
        StringBuilder fullCategoryName = new StringBuilder(imageCategory.getName());
        while (!parentId.isEmpty()) {
            imageCategory = this.getCategoryByFid(parentId);
            fullOrderId.insert(0, imageCategory.getOrder() + "/");
            fullCategoryName.insert(0, imageCategory.getName() + "/");
            parentId = imageCategory.getParentId();
        }
        map.put(FCATEGORYNAME, String.valueOf(fullCategoryName));
        map.put(FORDERID, String.valueOf(fullOrderId));
        return map;
    }

    public void deleteNoImageGalleryCategory(String categoryId) throws AbstractQingIntegratedException, SQLException {
        String parentId = categoryId;
        int imageCount = this.getImageCountByCategoryId(categoryId);
        int categoryCount = this.getCategoryCountByParentId(parentId);
        while (imageCount == 0 && categoryCount == 0) {
            categoryId = parentId;
            parentId = this.getCategoryParentIdByFid(categoryId);
            this.deleteCategory(categoryId);
            if (parentId == null || parentId.isEmpty()) break;
            imageCount = this.getImageCountByCategoryId(parentId);
            categoryCount = this.getCategoryCountByParentId(parentId);
        }
    }

    public String getCategoryName(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT TTIC.FNAME FROM T_QING_IMGLIB_CATEGORY TTIC WHERE FID IN (SELECT TTII.FCATEGORYID FROM T_QING_IMGLIB_IMG_INFO TTII WHERE FIMAGEFILENAME = ?)", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String categoryName = null;
                if (rs.next()) {
                    categoryName = rs.getString(ImageLibraryDao.FCATEGORYNAME);
                }
                return categoryName;
            }
        });
    }

    @Deprecated
    public ImageModel loadImageModel(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FIMAGENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                }
                return imageModel;
            }
        });
    }

    public Map<String, Object> getImageSize(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (Map)this.dbExcuter.query("SELECT FIMAGEWIDTH, FIMAGEHEIGHT, FIMAGENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<Map<String, Object>>(){

            public Map<String, Object> handle(ResultSet rs) throws SQLException {
                HashMap<String, Object> imageSize = new HashMap<String, Object>();
                if (rs.next()) {
                    imageSize.put("imageWidth", rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageSize.put("imageHeight", rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageSize.put("imageName", rs.getString(ImageLibraryDao.FIMAGENAME));
                }
                return imageSize;
            }
        });
    }

    public List<ImageModel> getAllPresetImage() throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FTHUMBNAILFILENAME, FCATEGORYID, FIMAGEFILENAME, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT FROM T_QING_IMGLIB_IMG_INFO WHERE FUSERID=?", new Object[]{IntegratedHelper.getPresetUserId()}, (ResultHandler)new ResultHandler<List<ImageModel>>(){

            public List<ImageModel> handle(ResultSet rs) throws SQLException {
                ArrayList<ImageModel> imageInfos = new ArrayList<ImageModel>(10);
                while (rs.next()) {
                    ImageModel imageInfo = new ImageModel();
                    imageInfo.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageInfo.setId(rs.getString(ImageLibraryDao.FID));
                    imageInfo.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageInfo.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageInfo.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageInfo.setImageWidth(rs.getInt(ImageLibraryDao.FIMAGEWIDTH));
                    imageInfo.setImageHeight(rs.getInt(ImageLibraryDao.FIMAGEHEIGHT));
                    imageInfos.add(imageInfo);
                }
                return imageInfos;
            }
        });
    }

    public ImageModel getImageModelByImageFileName(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT FID, FUSERID, FCATEGORYID, FIMAGENAME, FIMAGEWIDTH, FIMAGEHEIGHT, FIMAGEFILENAME, FTHUMBNAILFILENAME FROM T_QING_IMGLIB_IMG_INFO WHERE FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setId(rs.getString(ImageLibraryDao.FID));
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    boolean exists = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.IMAGE_LIBRARY, (String)imageModel.getImageFileName()).exists();
                    imageModel.setHasContent(exists);
                    imageModel.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                    imageModel.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                }
                return imageModel;
            }
        });
    }

    public String getImageFileNameByFullPath(boolean isPublic, String categoryName, String imageName, String userId) throws AbstractQingIntegratedException, SQLException {
        ImageCategory imageCategory = this.getCategoryByFullName(isPublic, categoryName, userId);
        if (imageCategory == null) {
            return null;
        }
        Object[] param = new Object[]{imageName, imageCategory.getId()};
        String sql = "SELECT IMAGE.FID, IMAGE.FCATEGORYID, IMAGE.FIMAGENAME, IMAGE.FIMAGEFILENAME, IMAGE.FTHUMBNAILFILENAME, IMAGE.FIMAGEWIDTH, IMAGE.FIMAGEHEIGHT FROM T_QING_IMGLIB_IMG_INFO IMAGE WHERE IMAGE.FIMAGENAME = ? AND IMAGE.FCATEGORYID = ?";
        return (String)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String imageFileName = null;
                if (rs.next()) {
                    imageFileName = rs.getString(ImageLibraryDao.FIMAGEFILENAME);
                }
                return imageFileName;
            }
        });
    }

    public String getImageFileNameByFullPath(CategoryTypeEnum categoryType, String categoryName, String imageName, String userId) throws AbstractQingIntegratedException, SQLException {
        ImageCategory imageCategory = this.getCategoryByFullName(categoryType, categoryName, userId);
        if (imageCategory == null) {
            return null;
        }
        Object[] param = new Object[]{imageName, imageCategory.getId()};
        String sql = "SELECT IMAGE.FID, IMAGE.FCATEGORYID, IMAGE.FIMAGENAME, IMAGE.FIMAGEFILENAME, IMAGE.FTHUMBNAILFILENAME, IMAGE.FIMAGEWIDTH, IMAGE.FIMAGEHEIGHT FROM T_QING_IMGLIB_IMG_INFO IMAGE WHERE IMAGE.FIMAGENAME = ? AND IMAGE.FCATEGORYID = ?";
        return (String)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String imageFileName = null;
                if (rs.next()) {
                    imageFileName = rs.getString(ImageLibraryDao.FIMAGEFILENAME);
                }
                return imageFileName;
            }
        });
    }

    @Deprecated
    public ImageModel loadModelByImageNameAndCategoryName(String categoryName, String imageName, String userId) throws AbstractQingIntegratedException, SQLException {
        return (ImageModel)this.dbExcuter.query("SELECT IMGINFO.FID, IMGINFO.FCATEGORYID, IMGINFO.FIMAGENAME, IMGINFO.FIMAGEWIDTH, IMGINFO.FIMAGEHEIGHT, IMGINFO.FIMAGEFILENAME, IMGINFO.FTHUMBNAILFILENAME FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE CATEGORY.FNAME = ? AND IMGINFO.FIMAGENAME = ? AND IMGINFO.FUSERID = ?", new Object[]{categoryName, imageName, userId}, (ResultHandler)new ResultHandler<ImageModel>(){

            public ImageModel handle(ResultSet rs) throws SQLException {
                ImageModel imageModel = null;
                if (rs.next()) {
                    imageModel = new ImageModel();
                    imageModel.setId(rs.getString(ImageLibraryDao.FID));
                    imageModel.setCategoryId(rs.getString(ImageLibraryDao.FCATEGORYID));
                    imageModel.setImageName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    imageModel.setImageFileName(rs.getString(ImageLibraryDao.FIMAGEFILENAME));
                    imageModel.setThumbnailFileName(rs.getString(ImageLibraryDao.FTHUMBNAILFILENAME));
                }
                return imageModel;
            }
        });
    }

    public PathModel getPathModel(String imageFileName) throws AbstractQingIntegratedException, SQLException {
        PathModel fullPathModel = (PathModel)this.dbExcuter.query("SELECT IMGINFO.FIMAGENAME, CATEGORY.FID, CATEGORY.FNAME, CATEGORY.FISPUBLIC, CATEGORY.FUSERID FROM T_QING_IMGLIB_IMG_INFO IMGINFO LEFT JOIN T_QING_IMGLIB_CATEGORY CATEGORY ON IMGINFO.FCATEGORYID = CATEGORY.FID WHERE IMGINFO.FIMAGEFILENAME = ?", new Object[]{imageFileName}, (ResultHandler)new ResultHandler<PathModel>(){

            public PathModel handle(ResultSet rs) throws SQLException {
                PathModel pathModel = null;
                if (rs.next()) {
                    String nameSpace = ImageLibraryDao.this.getNameSpaceByType(rs.getInt(ImageLibraryDao.FISPUBLIC));
                    nameSpace = IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)) ? NameSpace.system.toPersistance() : nameSpace;
                    pathModel = new PathModel();
                    pathModel.setNameSpace(nameSpace);
                    pathModel.setName(rs.getString(ImageLibraryDao.FIMAGENAME));
                    pathModel.setGroupName(rs.getString(ImageLibraryDao.FID));
                }
                return pathModel;
            }
        });
        if (fullPathModel != null) {
            fullPathModel.setGroupName(this.getFullCategoryNameById(fullPathModel.getGroupName()));
        }
        return fullPathModel;
    }

    public ImageCategory getCategoryByFullName(boolean isPublic, String categoryFullName, String userId) throws AbstractQingIntegratedException, SQLException {
        ImageCategory imageCategory = null;
        if (StringUtils.isBlank((CharSequence)categoryFullName)) {
            return imageCategory;
        }
        String categoryId = null;
        List<String> categoryNames = Arrays.asList(StringUtils.split((String)categoryFullName, (char)'/'));
        int length = categoryNames.size();
        for (int index = 0; index < length; ++index) {
            imageCategory = this.getCategoryByNameAndParentId(isPublic, categoryNames.get(index), userId, categoryId);
            if (imageCategory == null) {
                return null;
            }
            categoryId = imageCategory.getId();
        }
        return imageCategory;
    }

    public ImageCategory getCategoryByFullName(CategoryTypeEnum categoryType, String categoryFullName, String userId) throws AbstractQingIntegratedException, SQLException {
        ImageCategory imageCategory = null;
        if (StringUtils.isBlank((CharSequence)categoryFullName)) {
            return imageCategory;
        }
        String categoryId = null;
        List<String> categoryNames = Arrays.asList(StringUtils.split((String)categoryFullName, (char)'/'));
        int length = categoryNames.size();
        for (int index = 0; index < length; ++index) {
            imageCategory = this.getCategoryByNameAndParentId(categoryType, categoryNames.get(index), userId, categoryId);
            if (imageCategory == null) {
                return null;
            }
            categoryId = imageCategory.getId();
        }
        return imageCategory;
    }

    public ImageCategory getCategoryByNameAndParentId(CategoryTypeEnum categoryType, String categoryName, String userId, String parentId) throws AbstractQingIntegratedException, SQLException {
        String sql = null;
        boolean isPreset = IntegratedHelper.getPresetUserId().equals(userId);
        Object[] param = new Object[4];
        param[0] = categoryType.getType();
        param[1] = categoryName;
        Object object = param[2] = parentId == null ? " " : parentId;
        if (!isPreset && categoryType.isPublic()) {
            param[3] = IntegratedHelper.getPresetUserId();
            sql = "SELECT FID, FNAME, FUSERID, FORDERID, FISPUBLIC, FPARENTID, FORDERID FROM T_QING_IMGLIB_CATEGORY WHERE FISPUBLIC=? AND FNAME=? AND FPARENTID = ? AND FUSERID<>?";
        } else {
            param[3] = userId;
            sql = "SELECT FID, FNAME, FUSERID, FORDERID, FISPUBLIC, FPARENTID, FORDERID FROM T_QING_IMGLIB_CATEGORY WHERE FISPUBLIC=? AND FNAME=? AND FPARENTID = ? AND FUSERID=?";
        }
        return (ImageCategory)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<ImageCategory>(){

            public ImageCategory handle(ResultSet rs) throws SQLException {
                ImageCategory category = null;
                if (rs.next()) {
                    category = new ImageCategory();
                    category.setId(rs.getString(ImageLibraryDao.FID));
                    category.setName(rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    category.setOrder(rs.getInt(ImageLibraryDao.FORDERID));
                    category.setPublic(CategoryTypeEnum.isPublic((String)rs.getString(ImageLibraryDao.FISPUBLIC)));
                    category.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    category.setGallery(CategoryTypeEnum.isGallery((String)rs.getString(ImageLibraryDao.FISPUBLIC)));
                    category.setParentId(rs.getString(ImageLibraryDao.FPARENTID));
                }
                return category;
            }
        });
    }

    public ImageCategory getCategoryByNameAndParentId(boolean isPublic, String categoryName, String userId, String parentId) throws AbstractQingIntegratedException, SQLException {
        String sql = null;
        boolean isPreset = IntegratedHelper.getPresetUserId().equals(userId);
        Object[] param = new Object[5];
        param[0] = isPublic ? CategoryTypeEnum.PUBLIC.getType() : CategoryTypeEnum.PRIVATE.getType();
        param[1] = isPublic ? CategoryTypeEnum.PUBLICGALLERY.getType() : CategoryTypeEnum.PRIVATEGALLERY.getType();
        param[2] = categoryName;
        Object object = param[3] = parentId == null ? " " : parentId;
        if (!isPreset && isPublic) {
            param[4] = IntegratedHelper.getPresetUserId();
            sql = "SELECT FID, FNAME, FUSERID, FORDERID, FISPUBLIC, FPARENTID, FORDERID FROM T_QING_IMGLIB_CATEGORY WHERE (FISPUBLIC=? OR FISPUBLIC=?) AND FNAME=? AND FPARENTID = ? AND FUSERID<>?";
        } else {
            param[4] = userId;
            sql = "SELECT FID, FNAME, FUSERID, FORDERID, FISPUBLIC, FPARENTID, FORDERID FROM T_QING_IMGLIB_CATEGORY WHERE (FISPUBLIC=? OR FISPUBLIC=?) AND FNAME=? AND FPARENTID = ? AND FUSERID=?";
        }
        return (ImageCategory)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<ImageCategory>(){

            public ImageCategory handle(ResultSet rs) throws SQLException {
                ImageCategory category = null;
                if (rs.next()) {
                    category = new ImageCategory();
                    category.setId(rs.getString(ImageLibraryDao.FID));
                    category.setName(rs.getString(ImageLibraryDao.FCATEGORYNAME));
                    category.setOrder(rs.getInt(ImageLibraryDao.FORDERID));
                    category.setPublic(CategoryTypeEnum.isPublic((String)rs.getString(ImageLibraryDao.FISPUBLIC)));
                    category.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString(ImageLibraryDao.FUSERID)));
                    category.setGallery(CategoryTypeEnum.isGallery((String)rs.getString(ImageLibraryDao.FISPUBLIC)));
                    category.setParentId(rs.getString(ImageLibraryDao.FPARENTID));
                }
                return category;
            }
        });
    }

    public void updateImageUserIdByImageFileName(String imageFileName, String categoryId, String newImageName, String toUserId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{categoryId, newImageName, toUserId, imageFileName};
        this.dbExcuter.execute("UPDATE T_QING_IMGLIB_IMG_INFO SET FCATEGORYID = ?, FIMAGENAME = ?, FUSERID = ? WHERE FIMAGEFILENAME = ?", params);
    }

    public List<FileResourceVO> findResourceFileListByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE, II.FID AS IMGID,  IC.FNAME AS IMGGROUPNAME, IC.FID AS IMGCATEGORYID, IC.FISPUBLIC  FROM      (SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE FROM T_QING_FILE_RESOURCE FR       WHERE FR.FUSERID = ? AND FR.FFROMTYPE='IMAGELIBRARY' ) FR  LEFT JOIN T_QING_IMGLIB_IMG_INFO II ON FR.FFROMID=II.FID  LEFT JOIN T_QING_IMGLIB_CATEGORY IC ON II.FCATEGORYID=IC.FID ";
        return (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<FileResourceVO>>(){

            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setFromId(rs.getString("FFROMID"));
                    resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
                    resourceFile.setFileSizeNoFormat(rs.getString("FFILESIZE"));
                    long fcreatedate = rs.getTimestamp("FCREATEDATE").getTime();
                    resourceFile.setCreateDate(Long.valueOf(fcreatedate));
                    String formatDateTime = IntegratedHelper2.formatDateTime(new Date(fcreatedate));
                    resourceFile.setCreateDateFormat(formatDateTime);
                    String fromType = rs.getString("FFROMTYPE");
                    resourceFile.setFromType(fromType);
                    boolean isPublic = CategoryTypeEnum.isPublic((String)rs.getString(ImageLibraryDao.FISPUBLIC));
                    String imgGroupName = rs.getString("IMGGROUPNAME");
                    String imgCategoryId = rs.getString("IMGCATEGORYID");
                    String fromPathName = (isPublic ? Messages.getMLS((String)"public", (String)"\u516c\u5171") : Messages.getMLS((String)"private", (String)"\u4e2a\u4eba")) + "/" + imgGroupName;
                    resourceFile.setFromPathName(fromPathName);
                    resourceFile.setFromPath(imgCategoryId);
                    resourceFile.setSourceExist(StringUtils.isNotBlank((CharSequence)rs.getString("IMGID")));
                    list.add(resourceFile);
                }
                return list;
            }
        });
    }

    public void deleteCategories(List<String> newCreatedCategories) throws SQLException, AbstractQingIntegratedException {
        if (CollectionUtils.isEmpty(newCreatedCategories)) {
            return;
        }
        StringBuilder sqlInQuestionBuilder = new StringBuilder();
        sqlInQuestionBuilder.append("?");
        for (int i = 1; i < newCreatedCategories.size(); ++i) {
            sqlInQuestionBuilder.append(",?");
        }
        String sql = "DELETE FROM T_QING_IMGLIB_CATEGORY WHERE FID in (#1)";
        sql = sql.replace("#1", sqlInQuestionBuilder);
        this.dbExcuter.execute(sql, newCreatedCategories.toArray());
    }
}

