/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.DBConnectionType;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.SuperQuerySource;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.dbmanage.exception.DBManageException;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.dbmanage.model.RefFromType;
import com.kingdee.bos.qing.imexport.model.resource.ExportDBConnInfo;
import com.kingdee.bos.qing.imexport.model.resource.ExportMacro;
import com.kingdee.bos.qing.imexport.model.resource.ExportSQLMacro;
import com.kingdee.bos.qing.imexport.model.resource.Resources;
import com.kingdee.bos.qing.macro.dao.SQLMacroDao;
import com.kingdee.bos.qing.macro.domain.AbstractMacroDomain;
import com.kingdee.bos.qing.macro.domain.SQLMacroDomain;
import com.kingdee.bos.qing.macro.exception.MacroDBConnectionNoExistException;
import com.kingdee.bos.qing.macro.exception.MacroDbCenterException;
import com.kingdee.bos.qing.macro.exception.MacroExecuteException;
import com.kingdee.bos.qing.macro.exception.MacroNoAuthorityException;
import com.kingdee.bos.qing.macro.exception.MacroNotFoundException;
import com.kingdee.bos.qing.macro.exception.MacroRejectExecuteException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.model.MacroStatus;
import com.kingdee.bos.qing.macro.model.PackageMeta;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.MacroCheckResult;
import com.kingdee.bos.qing.macro.model.vo.MacroValue;
import com.kingdee.bos.qing.macro.model.vo.PreviewData;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.macro.oplog.MacroOpLog;
import com.kingdee.bos.qing.macro.oplog.MacroOpLogScene;
import com.kingdee.bos.qing.macro.strategy.IMacroCheckPermission;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.DateUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.MacroCheckPermissionUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SQLMacroDomain
extends AbstractMacroDomain {
    private static final String KSQL_MACRO = "/*qing_marco-%s-%s*/";
    private static final String QING_MACRO_REJECTIDS = "qing.macro.rejectids";
    private SQLMacroDao sqlMacroDao;

    public SQLMacroDomain(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) {
        super(dbExcuter, tx, qingContext);
    }

    private SQLMacroDao getSQLMacroDao() {
        if (this.sqlMacroDao == null) {
            this.sqlMacroDao = new SQLMacroDao(this.dbExcuter);
        }
        return this.sqlMacroDao;
    }

    private void checkDBPermission(DBConnection dbConnect) throws AbstractQingIntegratedException, SQLException, MacroDBConnectionNoExistException, MacroNoAuthorityException {
        boolean isHasSchema;
        SuperQuerySource superQuerySource;
        boolean isPublicSuperQuerySource = false;
        if (dbConnect.getDbSource().getDBConnectionType() == DBConnectionType.SuperQuery && !(isPublicSuperQuerySource = (superQuerySource = (SuperQuerySource)dbConnect.getDbSource()).isPublic()) && !(isHasSchema = MacroCheckPermissionUtil.checkSuperQuerySchema((QingContext)this.qingContext, (IMacroCheckPermission)this.getMacroCheckPermission(), (SuperQuerySource)superQuerySource, (String)this.qingContext.getUserId()))) {
            throw new MacroNoAuthorityException();
        }
        if (dbConnect.isDBSource() || isPublicSuperQuerySource) {
            List dbConnIds = this.getDBConnectionDomain().loadAllDBConnIdsWithBizMeta();
            if (!dbConnIds.contains(dbConnect.getId())) {
                throw new MacroDBConnectionNoExistException();
            }
            if (!this.getDBConnectionDomain().isDBConnHasPermission(this.qingContext.getUserId(), dbConnect.getId()).booleanValue()) {
                throw new MacroNoAuthorityException();
            }
        } else if (dbConnect.isDBCenterSource() && MacroCheckPermissionUtil.macroCheckDBCenterSourceNoPermission((IMacroCheckPermission)this.getMacroCheckPermission(), (DBConnection)dbConnect, (String)this.qingContext.getUserId())) {
            throw new MacroNoAuthorityException();
        }
    }

    protected Macro saveWithoutTx(Macro macro, boolean checkExecutable) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        SQLMacro sqlMacro = (SQLMacro)macro;
        try {
            DBConnection dbConnect = sqlMacro.getDBInfo();
            if (dbConnect != null) {
                if (checkExecutable) {
                    this.checkDBPermission(dbConnect);
                }
                this.getDBConnectionDomain().getActualPassword(dbConnect.getDbSource(), dbConnect.getId());
            }
            if (checkExecutable) {
                this.checkSQLValid(sqlMacro);
            }
            SQLMacroPO macroPO = sqlMacro.toSQLMacroPO();
            if (dbConnect != null) {
                this.getDBConnectionDomain().saveConnAndUpdateRefWithoutTx(sqlMacro.getDBInfo(), macroPO.getFid(), RefFromType.Macro);
                this.getDBConnectionDomain().replacePasswordWithUUID(dbConnect.getDbSource());
            } else if (sqlMacro.getRefDBHashCode() != null) {
                this.getDBConnectionDomain().saveDBRefByHashCodeWithoutTx(macroPO.getFid(), RefFromType.Macro, sqlMacro.getRefDBHashCode());
            }
            this.getSQLMacroDao().saveSQLMacro(macroPO);
            return sqlMacro;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (MacroDBConnectionNoExistException e) {
            throw e;
        }
        catch (MacroNoAuthorityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
    }

    protected Macro updateWithoutTx(Macro newMacro, Macro oldMacro) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        SQLMacro newSqlMacro = (SQLMacro)newMacro;
        try {
            DBConnection dbConnect = newSqlMacro.getDBInfo();
            if (dbConnect != null) {
                this.checkDBPermission(dbConnect);
                this.getDBConnectionDomain().getActualPassword(dbConnect.getDbSource(), dbConnect.getId());
            }
            this.checkSQLValid(newSqlMacro);
            SQLMacroPO oldSQLMacroPO = this.getSQLMacroDao().loadMacro(oldMacro.getFid());
            if (oldSQLMacroPO != null) {
                DBConnection newDBConnection = newSqlMacro.getDBInfo();
                this.getDBConnectionDomain().saveConnAndUpdateRefWithoutTx(newDBConnection, newSqlMacro.getFid(), RefFromType.Macro);
                SQLMacroPO po = newSqlMacro.toSQLMacroPO();
                this.getSQLMacroDao().updateSQLMacro(po);
            }
            if (dbConnect != null) {
                this.getDBConnectionDomain().replacePasswordWithUUID(dbConnect.getDbSource());
            }
            return newSqlMacro;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (MacroDBConnectionNoExistException e) {
            throw e;
        }
        catch (MacroNoAuthorityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
    }

    protected void deleteWithoutTx(String macroId) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        SQLMacroPO sqlMacroPO = this.getSQLMacroDao().loadMacro(macroId);
        if (sqlMacroPO == null) {
            return;
        }
        try {
            SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
            this.getDBConnectionDomain().deleteDBConnRefWithoutTx(sqlMacro.getFid(), RefFromType.Macro);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
        this.getSQLMacroDao().deleteSQLMacroByMacroId(sqlMacroPO.getFid());
    }

    protected void deleteWithoutTx(List<String> macroIds) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        ArrayList dbConnsToDel = new ArrayList(10);
        ArrayList<String> macroNames = new ArrayList<String>(macroIds.size());
        try {
            for (String macroId : macroIds) {
                SQLMacroPO sqlMacroPO = this.getSQLMacroDao().loadMacro(macroId);
                macroNames.add(sqlMacroPO.getName());
                SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
                this.getDBConnectionDomain().deleteDBConnRefWithoutTx(sqlMacro.getFid(), RefFromType.Macro);
            }
            this.getSQLMacroDao().deleteSQLMacrosByMacroIds(macroIds);
            this.getDBConnectionDomain().deleteDBConnectionsWithoutTx(dbConnsToDel);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
        ArrayList params = new ArrayList(1);
        MacroOpLog emptyDir = MacroOpLog.EMPTY_DIR;
        emptyDir.setLogScene(MacroOpLogScene.MACRO);
        for (int i = 0; i < macroNames.size(); ++i) {
            params.clear();
            params.add(macroNames.get(i));
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)emptyDir, params));
        }
    }

    public Macro loadMacro(String macroId) throws AbstractQingIntegratedException, QingMacroException {
        try {
            SQLMacroPO sqlMacroPO = this.getSQLMacroDao().loadMacro(macroId);
            SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
            HashSet<String> userIds = new HashSet<String>(2);
            userIds.add(sqlMacro.getCreatorId());
            userIds.add(sqlMacro.getModifierId());
            Map userNames = IntegratedHelper.getUserNamesByUserIds(new ArrayList(userIds));
            sqlMacro.setCreatorName((String)userNames.get(sqlMacro.getCreatorId()));
            sqlMacro.setModifierName((String)userNames.get(sqlMacro.getModifierId()));
            MacroCheckResult checkResult = this.checkMacro((Macro)sqlMacro);
            sqlMacro.setMacroStatus(checkResult.getMacroStatus());
            if (sqlMacro.getDBInfo() != null) {
                this.getDBConnectionDomain().replacePasswordWithUUID(sqlMacro.getDBInfo().getDbSource());
            }
            return sqlMacro;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
    }

    public boolean checkMacroPermissionByUid(String macroUid) throws QingMacroException {
        try {
            SQLMacroPO sqlMacroPO = this.getSQLMacroDao().loadSQLMacroByUid(macroUid);
            SQLMacro sqlMacro = sqlMacroPO.toSQLMacro();
            MacroCheckResult checkResult = this.checkMacro((Macro)sqlMacro);
            return checkResult.getMacroStatus() == MacroStatus.AVAILABLE;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
    }

    private void processDbPermission(SQLMacro sqlMacro) throws AbstractQingIntegratedException, SQLException {
        MacroStatus macroStatus = sqlMacro.getMacroStatus();
        if (macroStatus == MacroStatus.AVAILABLE) {
            this.getDBConnectionDomain().replacePasswordWithUUID(sqlMacro.getDBInfo().getDbSource());
        } else if (macroStatus == MacroStatus.WITHOUT_DB_PERMISSION) {
            sqlMacro.setConnAuthorized(false);
        } else if (macroStatus == MacroStatus.WITHOUT_DB_CENTER_PERMISSION) {
            sqlMacro.setDbCenterAuthorized(false);
        } else if (macroStatus == MacroStatus.WITHOUT_SCHEMA_PERMISSION) {
            sqlMacro.setSchemaAuthorized(false);
        }
    }

    private boolean checkMacroDBSourcePermission(String modifierId, SQLMacro sqlMacro) throws AbstractQingIntegratedException, SQLException {
        DBConnection dbInfo = sqlMacro.getDBInfo();
        return this.getDBConnectionDomain().isDBConnHasPermission(modifierId, dbInfo.getId());
    }

    public PreviewData getPreviewData(Macro macro, boolean isEditMacro) throws QingMacroException, DBManageException, SQLException, AbstractQingIntegratedException {
        SQLMacro sqlMacro = (SQLMacro)macro;
        AbstractSource source = sqlMacro.getDBInfo().getDbSource();
        if (isEditMacro) {
            sqlMacro.setModifierId(QingContext.getCurrent().getUserId());
        }
        if (!isEditMacro && source instanceof SuperQuerySource) {
            ((SuperQuerySource)source).setOwnerId(macro.getModifierId());
        }
        return this.executeMacro(sqlMacro, 100, new DBSourceExecutor<PreviewData>(){

            public PreviewData execute(AbstractDBSourceJDBCAdapter jdbcAdapter, DBSource dbSource, String sql, DBSource.UserSQL.SQLType sqlType, final boolean multiValued, final int limitRows) throws AbstractDBSourceException, SQLException {
                return jdbcAdapter.query(SQLMacroDomain.this.qingContext, dbSource, sql, sqlType, new AbstractDBSourceJDBCAdapter.QueryResultHandler<PreviewData>(){

                    public PreviewData handle(ResultSet rs) throws SQLException {
                        PreviewData previewData = new PreviewData();
                        ArrayList allColumnValuesList = new ArrayList(10);
                        ResultSetMetaData meta = rs.getMetaData();
                        int columnCount = meta.getColumnCount();
                        if (columnCount >= 1) {
                            int i;
                            ArrayList<String> allColumnNameList = new ArrayList<String>(columnCount);
                            ArrayList<DataType> columnDataTypes = new ArrayList<DataType>(columnCount);
                            for (i = 1; i <= columnCount; ++i) {
                                String columnName = meta.getColumnLabel(i);
                                previewData.addField(columnName);
                                int type = meta.getColumnType(i);
                                String className = meta.getColumnClassName(i);
                                DataType dataType = null;
                                dataType = DataTypeUtil.checkSqlTypes((int)type) ? DataTypeUtil.parseDataType((int)type) : DataTypeUtil.parseDataType((String)className);
                                if (dataType == null) continue;
                                allColumnNameList.add(columnName);
                                columnDataTypes.add(dataType);
                            }
                            if (rs.next()) {
                                for (i = 0; i < allColumnNameList.size(); ++i) {
                                    ArrayList<String> columnValueList = new ArrayList<String>(10);
                                    columnValueList.add(SQLMacroDomain.this.getPreviewText((DataType)columnDataTypes.get(i), (String)allColumnNameList.get(i), rs));
                                    allColumnValuesList.add(columnValueList);
                                }
                                int totalCount = 1;
                                if (multiValued) {
                                    while (rs.next()) {
                                        if (totalCount < limitRows) {
                                            int cols = allColumnNameList.size();
                                            for (int i2 = 0; i2 < cols; ++i2) {
                                                DataType dataType = (DataType)columnDataTypes.get(i2);
                                                String columnName = (String)allColumnNameList.get(i2);
                                                ((List)allColumnValuesList.get(i2)).add(SQLMacroDomain.this.getPreviewText(dataType, columnName, rs));
                                            }
                                        }
                                        ++totalCount;
                                    }
                                }
                                previewData.setTotalRowCount(totalCount);
                            }
                            if (allColumnValuesList.size() > 0) {
                                List columnValueList = (List)allColumnValuesList.get(0);
                                int size = columnValueList.size();
                                for (int i3 = 0; i3 < size; ++i3) {
                                    PreviewData.Row row = previewData.createRow();
                                    int allColumnSize = allColumnValuesList.size();
                                    for (int j = 0; j < allColumnSize; ++j) {
                                        PreviewData.Column column = row.createColumn();
                                        column.setValue(((List)allColumnValuesList.get(j)).get(i3));
                                    }
                                }
                            }
                        }
                        return previewData;
                    }
                });
            }
        });
    }

    public PreviewData getPreviewDataByID(String macroId) throws QingMacroException, AbstractQingIntegratedException, SQLException, DBManageException {
        Macro macro = this.loadMacro(macroId);
        if (macro == null) {
            return new PreviewData();
        }
        PreviewData previewData = this.getPreviewData(macro, false);
        return previewData;
    }

    public List<Macro> getMacrosFromXML(List<IXmlElement> macroElements, IXmlElement dbInfosElement, String version) {
        if (CollectionUtils.isEmpty(macroElements)) {
            return new ArrayList<Macro>();
        }
        ArrayList<DBConnection> importedDBConn = null;
        if (dbInfosElement != null) {
            List dbInfoElements = dbInfosElement.getChildren();
            importedDBConn = new ArrayList<DBConnection>(dbInfoElements.size());
            for (IXmlElement element : dbInfoElements) {
                ExportDBConnInfo exportModel = new ExportDBConnInfo();
                exportModel.fromXml(element, version);
                DBConnection dbConn = exportModel.toDBConnInfo();
                importedDBConn.add(dbConn);
            }
        }
        ArrayList<Macro> macros = new ArrayList<Macro>(macroElements.size());
        for (IXmlElement element : macroElements) {
            ExportSQLMacro exportMacro = new ExportSQLMacro();
            exportMacro.fromXml(element, version);
            SQLMacro sqlMacro = (SQLMacro)exportMacro.toMacro();
            String refDBHashcode = exportMacro.getRefDBHashcode();
            sqlMacro.setRefDBHashCode(refDBHashcode);
            if (CollectionUtils.isNotEmpty(importedDBConn)) {
                for (DBConnection dbConn : importedDBConn) {
                    if (!dbConn.getDBHashCode().equals(refDBHashcode)) continue;
                    sqlMacro.setDBInfo(dbConn);
                }
            }
            macros.add((Macro)sqlMacro);
        }
        return macros;
    }

    public List<MacroCheckResult> checkMacro(List<Macro> macros) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        if (CollectionUtils.isEmpty(macros)) {
            return new ArrayList<MacroCheckResult>(1);
        }
        ArrayList<MacroCheckResult> macroCheckResultList = new ArrayList<MacroCheckResult>(macros.size());
        HashMap<String, Boolean> dbCenterSourcePermissionCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> dbSourcePermissionCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> superQuerySchemaCache = new HashMap<String, Boolean>();
        IMacroCheckPermission macroCheckPermission = (IMacroCheckPermission)CustomStrategyRegistrar.getStrategy(IMacroCheckPermission.class);
        for (Macro macro : macros) {
            MacroCheckResult macroCheckResult = this.checkMacro((SQLMacro)macro, dbCenterSourcePermissionCache, dbSourcePermissionCache, macroCheckPermission, superQuerySchemaCache);
            macroCheckResultList.add(macroCheckResult);
        }
        return macroCheckResultList;
    }

    public MacroCheckResult checkMacro(Macro macro) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, Boolean> dbCenterSourcePermissionCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> dbSourcePermissionCache = new HashMap<String, Boolean>();
        HashMap<String, Boolean> superQuerySchemaCache = new HashMap<String, Boolean>();
        IMacroCheckPermission macroCheckPermission = (IMacroCheckPermission)CustomStrategyRegistrar.getStrategy(IMacroCheckPermission.class);
        MacroCheckResult macroCheckResult = this.checkMacro((SQLMacro)macro, dbCenterSourcePermissionCache, dbSourcePermissionCache, macroCheckPermission, superQuerySchemaCache);
        return macroCheckResult;
    }

    public MacroCheckResult checkMacro(SQLMacro sqlMacro, Map<String, Boolean> dbCenterSourcePermissionCache, Map<String, Boolean> dbSourcePermissionCache, IMacroCheckPermission macroCheckPermission, Map<String, Boolean> superQuerySchemaCache) throws AbstractQingIntegratedException, SQLException {
        SuperQuerySource superQuerySource;
        MacroCheckResult macroCheckResult = new MacroCheckResult();
        macroCheckResult.setMacroStatus(MacroStatus.AVAILABLE);
        if (sqlMacro == null) {
            macroCheckResult.setMacroStatus(MacroStatus.NOT_EXIST);
            return macroCheckResult;
        }
        macroCheckResult.setMacroId(sqlMacro.getFid());
        if (this.checkMacroReject(sqlMacro.getFid())) {
            macroCheckResult.setMacroStatus(MacroStatus.MACRO_REJECT);
            return macroCheckResult;
        }
        DBConnection dbInfo = sqlMacro.getDBInfo();
        if (dbInfo == null) {
            macroCheckResult.setMacroStatus(MacroStatus.DB_NOT_EXIST);
            return macroCheckResult;
        }
        boolean isPublicSuperQuerySource = false;
        if (dbInfo.getDbSource().getDBConnectionType() == DBConnectionType.SuperQuery && !(isPublicSuperQuerySource = (superQuerySource = (SuperQuerySource)dbInfo.getDbSource()).isPublic())) {
            String cacheKey = sqlMacro.getModifierId() + dbInfo.getId();
            Boolean isHasSchema = superQuerySchemaCache.get(cacheKey);
            if (isHasSchema == null) {
                isHasSchema = MacroCheckPermissionUtil.checkSuperQuerySchema((QingContext)this.qingContext, (IMacroCheckPermission)macroCheckPermission, (SuperQuerySource)superQuerySource, (String)sqlMacro.getModifierId());
                superQuerySchemaCache.put(cacheKey, isHasSchema);
            }
            if (!isHasSchema.booleanValue()) {
                macroCheckResult.setMacroStatus(MacroStatus.WITHOUT_SCHEMA_PERMISSION);
                sqlMacro.setSchemaAuthorized(false);
            }
        }
        if (dbInfo.isDBSource() || isPublicSuperQuerySource) {
            String cacheKey = sqlMacro.getModifierId() + dbInfo.getId();
            Boolean isDBConnHasPermission = dbSourcePermissionCache.get(cacheKey);
            if (isDBConnHasPermission == null) {
                isDBConnHasPermission = this.getDBConnectionDomain().isDBConnHasPermission(sqlMacro.getModifierId(), dbInfo.getId());
                dbSourcePermissionCache.put(cacheKey, isDBConnHasPermission);
            }
            if (!isDBConnHasPermission.booleanValue()) {
                macroCheckResult.setMacroStatus(MacroStatus.WITHOUT_DB_PERMISSION);
                sqlMacro.setConnAuthorized(false);
            }
        } else if (dbInfo.isDBCenterSource()) {
            Boolean isPermission = dbCenterSourcePermissionCache.get(sqlMacro.getModifierId());
            if (isPermission == null) {
                isPermission = MacroCheckPermissionUtil.checkDBCenterSourcePermission((IMacroCheckPermission)macroCheckPermission, (String)sqlMacro.getModifierId());
                dbCenterSourcePermissionCache.put(sqlMacro.getModifierId(), isPermission);
            }
            if (isPermission.booleanValue()) {
                try {
                    macroCheckPermission.checkAppUsable(dbInfo);
                }
                catch (AbstractQingException e) {
                    macroCheckResult.setAppNumber(macroCheckPermission.getAppNumber(dbInfo));
                    int errorCode = e.getErrorCode();
                    switch (errorCode) {
                        case 3009001: {
                            macroCheckResult.setMacroStatus(MacroStatus.DB_CENTER_NO_APP_METADATA);
                            break;
                        }
                        case 3009002: {
                            macroCheckResult.setMacroStatus(MacroStatus.DB_CENTER_APP_CLOUD_DISABLED);
                            break;
                        }
                        case 3009003: {
                            macroCheckResult.setMacroStatus(MacroStatus.DB_CENTER_APP_DISABLED);
                            break;
                        }
                        case 3009004: {
                            macroCheckResult.setMacroStatus(MacroStatus.DB_CENTER_NO_APP);
                            break;
                        }
                        default: {
                            macroCheckResult.setMacroStatus(MacroStatus.DB_CENTER_APP_DISABLED);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    macroCheckResult.setMacroStatus(MacroStatus.DB_CENTER_APP_DISABLED);
                }
            } else {
                macroCheckResult.setMacroStatus(MacroStatus.WITHOUT_DB_CENTER_PERMISSION);
                sqlMacro.setDbCenterAuthorized(false);
            }
        }
        return macroCheckResult;
    }

    private void checkSQLValid(SQLMacro sqlMacro) throws MacroExecuteException {
        DBConnection dbConnection = sqlMacro.getDBInfo();
        AbstractSource source = dbConnection.getDbSource();
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source);
        IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source);
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        try {
            jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)dbSource);
            jdbcAdapter.setConnectionFactory(connFactory);
            jdbcAdapter.checkSQLExecutable(this.qingContext, dbSource, sqlMacro.getSQLType(), sqlMacro.getContent());
        }
        catch (AbstractSourceException e) {
            throw new MacroExecuteException((Throwable)e);
        }
    }

    public MacroValue getMacroExecuteResult(String macroId, List<String> fieldNames, int limitRows) throws QingMacroException {
        try {
            MacroValue macroValue = this.executeMacro(macroId, limitRows);
            if (CollectionUtils.isEmpty(fieldNames)) {
                return macroValue;
            }
            int fieldCount = fieldNames.size();
            ArrayList<String> columnNames = new ArrayList<String>(fieldCount);
            ArrayList columnValues = new ArrayList(fieldCount);
            if (macroValue != null && CollectionUtils.isNotEmpty((Collection)macroValue.getColumnNames())) {
                List macroColumnNames = macroValue.getColumnNames();
                List macroColumnValues = macroValue.getColumnValues();
                for (int i = 0; i < fieldCount; ++i) {
                    String fieldName = fieldNames.get(i);
                    int index = macroColumnNames.indexOf(fieldName);
                    if (index < 0) continue;
                    columnNames.add(fieldName);
                    columnValues.add(macroColumnValues.get(index));
                }
            }
            MacroValue result = new MacroValue();
            result.setColumnNames(columnNames);
            result.setColumnValues(columnValues);
            return result;
        }
        catch (MacroExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacroExecuteException((Throwable)e);
        }
    }

    public MacroValue getMacroFirstFieldValue(String macroId, int limitRows) throws QingMacroException {
        try {
            MacroValue macroValue = this.executeMacro(macroId, limitRows);
            ArrayList columnNames = new ArrayList(1);
            ArrayList columnValues = new ArrayList(1);
            if (macroValue != null && CollectionUtils.isNotEmpty((Collection)macroValue.getColumnNames())) {
                columnNames.add(macroValue.getColumnNames().get(0));
                columnValues.add(macroValue.getColumnValues().get(0));
            }
            MacroValue result = new MacroValue();
            result.setColumnNames(columnNames);
            result.setColumnValues(columnValues);
            return result;
        }
        catch (MacroExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacroExecuteException((Throwable)e);
        }
    }

    private MacroValue executeMacro(String macroId, int limitRows) throws QingMacroException {
        SQLMacro sqlMacro;
        try {
            SQLMacroPO macroPO = this.getSQLMacroDao().loadMacro(macroId);
            if (macroPO == null) {
                throw new MacroNotFoundException();
            }
            sqlMacro = macroPO.toSQLMacro();
        }
        catch (MacroNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
        if (this.checkMacroReject(sqlMacro.getFid())) {
            throw new MacroRejectExecuteException(sqlMacro.getName(), 1200019);
        }
        return this.executeMacro(sqlMacro, limitRows, new DBSourceExecutor<MacroValue>(){

            public MacroValue execute(AbstractDBSourceJDBCAdapter jdbcAdapter, DBSource dbSource, String sql, DBSource.UserSQL.SQLType sqlType, final boolean multiValued, final int limitRows) throws SQLException, AbstractDBSourceException {
                return jdbcAdapter.query(SQLMacroDomain.this.qingContext, dbSource, sql, sqlType, new AbstractDBSourceJDBCAdapter.QueryResultHandler<MacroValue>(){

                    public MacroValue handle(ResultSet rs) throws SQLException {
                        MacroValue rsMacroValue = new MacroValue();
                        ArrayList<String> allColumnNames = new ArrayList<String>(10);
                        ArrayList allColumnValues = new ArrayList(10);
                        ArrayList<DataType> columnDataTypes = new ArrayList<DataType>(10);
                        ResultSetMetaData meta = rs.getMetaData();
                        int columnCount = meta.getColumnCount();
                        if (columnCount >= 1) {
                            for (int i = 1; i <= columnCount; ++i) {
                                int type = meta.getColumnType(i);
                                String className = meta.getColumnClassName(i);
                                DataType dataType = DataTypeUtil.checkSqlTypes((int)type) ? DataTypeUtil.parseDataType((int)type) : DataTypeUtil.parseDataType((String)className);
                                if (dataType == null) continue;
                                allColumnNames.add(meta.getColumnLabel(i));
                                allColumnValues.add(new ArrayList(10));
                                columnDataTypes.add(dataType);
                            }
                            int rowCounts = 0;
                            if (rs.next() && CollectionUtils.isNotEmpty(allColumnNames)) {
                                int i;
                                for (i = 0; i < allColumnNames.size(); ++i) {
                                    List oneColumnValues = (List)allColumnValues.get(i);
                                    oneColumnValues.add(SQLMacroDomain.this.getExecuteValue((DataType)columnDataTypes.get(i), (String)allColumnNames.get(i), rs));
                                }
                                ++rowCounts;
                                if (multiValued) {
                                    while (rs.next() && (limitRows <= 0 || rowCounts++ < limitRows)) {
                                        int cols = allColumnNames.size();
                                        for (i = 0; i < cols; ++i) {
                                            List oneColumnValues = (List)allColumnValues.get(i);
                                            oneColumnValues.add(SQLMacroDomain.this.getExecuteValue((DataType)columnDataTypes.get(i), (String)allColumnNames.get(i), rs));
                                        }
                                    }
                                }
                            }
                        }
                        rsMacroValue.setColumnNames(allColumnNames);
                        rsMacroValue.setColumnValues(allColumnValues);
                        return rsMacroValue;
                    }
                });
            }
        });
    }

    private Object getExecuteValue(DataType dataType, String columnName, ResultSet rs) throws SQLException {
        switch (dataType) {
            case DATE: {
                Date date = rs.getDate(columnName);
                return date == null ? "" : DateUtils.DateToString((java.util.Date)date);
            }
            case DATETIME: {
                Timestamp ts = rs.getTimestamp(columnName);
                return ts == null ? "" : DateUtils.DateTimeToString((java.util.Date)ts);
            }
        }
        return rs.getObject(columnName);
    }

    public <T> T executeMacro(SQLMacro sqlMacro, int limitRows, DBSourceExecutor<T> dbSourceExecutor) throws QingMacroException {
        IConnectionFactory connFactory;
        MacroStatus macroStatus;
        if (sqlMacro == null) {
            throw new MacroNotFoundException();
        }
        DBConnection dbConnection = sqlMacro.getDBInfo();
        String modifierId = sqlMacro.getModifierId();
        boolean isUsable = false;
        try {
            macroStatus = this.checkMacro((Macro)sqlMacro).getMacroStatus();
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
        switch (macroStatus) {
            case DB_NOT_EXIST: {
                throw new MacroDBConnectionNoExistException();
            }
            case WITHOUT_DB_PERMISSION: 
            case WITHOUT_DB_CENTER_PERMISSION: 
            case WITHOUT_SCHEMA_PERMISSION: {
                throw new MacroNoAuthorityException();
            }
            case DB_CENTER_NO_APP_METADATA: {
                throw new MacroDbCenterException(1200015);
            }
            case DB_CENTER_APP_CLOUD_DISABLED: {
                throw new MacroDbCenterException(1200016);
            }
            case DB_CENTER_APP_DISABLED: {
                throw new MacroDbCenterException(1200017);
            }
            case DB_CENTER_NO_APP: {
                throw new MacroDbCenterException(1200018);
            }
        }
        AbstractSource source = dbConnection.getDbSource();
        String sql = sqlMacro.getContent();
        sql = String.format(KSQL_MACRO, this.qingContext.getAccountId(), sqlMacro.getFid()) + sql;
        DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source);
        try {
            this.getDBConnectionDomain().getActualPassword(source, sqlMacro.getDBInfo().getId());
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)modifierId) && dbSource.getDbType() == DBSource.DBType.FLYDB && StringUtils.isEmpty((CharSequence)dbSource.getDbAddress())) {
            dbSource.setOwnerId(modifierId);
            connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource((AbstractSource)dbSource);
        } else {
            connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source);
        }
        AbstractDBSourceJDBCAdapter jdbcAdapter = null;
        try {
            jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)dbSource);
            jdbcAdapter.setConnectionFactory(connFactory);
        }
        catch (UnSupportDataSourceException e) {
            throw new QingMacroException((Throwable)e);
        }
        try {
            boolean multiValued = sqlMacro.isMultiValued();
            return (T)dbSourceExecutor.execute(jdbcAdapter, dbSource, sql, sqlMacro.getSQLType(), multiValued, limitRows);
        }
        catch (AbstractDBConnectException e) {
            throw new QingMacroException((Throwable)e);
        }
        catch (SQLException e) {
            throw new QingMacroException((Throwable)e);
        }
        catch (AbstractSourceException e) {
            throw new MacroExecuteException((Throwable)e);
        }
    }

    private boolean checkMacroReject(String fid) {
        Map map;
        List rejectIds;
        String rejectIdsMap = SystemPropertyUtil.getString((String)QING_MACRO_REJECTIDS);
        return StringUtils.isNotBlank((CharSequence)rejectIdsMap) && (rejectIds = (List)(map = (Map)JsonUtil.decodeFromString((String)rejectIdsMap, Map.class)).get(this.qingContext.getAccountId())) != null && rejectIds.contains(fid);
    }

    private String getPreviewText(DataType dataType, String columnName, ResultSet rs) throws SQLException {
        switch (dataType) {
            case DATE: {
                Date date = rs.getDate(columnName);
                return date == null ? "" : DateUtils.DateToString((java.util.Date)date);
            }
            case DATETIME: {
                Timestamp ts = rs.getTimestamp(columnName);
                return ts == null ? "" : DateUtils.DateTimeToString((java.util.Date)ts);
            }
        }
        Object obj = rs.getObject(columnName);
        return obj == null ? "" : obj.toString();
    }

    public List<Macro> buildMacroInfo(List<Macro> macros) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        try {
            if (CollectionUtils.isEmpty(macros)) {
                return null;
            }
            HashMap<String, SQLMacroPO> sqlMacroPOMap = new HashMap<String, SQLMacroPO>(macros.size());
            ArrayList<Macro> sqlMacros = new ArrayList<Macro>(macros.size());
            ArrayList<String> macroIds = new ArrayList<String>(macros.size());
            for (Macro macro : macros) {
                macroIds.add(macro.getFid());
            }
            List sqlMacroPOS = this.getSQLMacroDao().loadSQLMacros(macroIds);
            for (SQLMacroPO sqlMacroPOItem : sqlMacroPOS) {
                sqlMacroPOMap.put(sqlMacroPOItem.getFid(), sqlMacroPOItem);
            }
            IMacroCheckPermission iMacroCheckPermission = this.getMacroCheckPermission();
            HashMap<String, Boolean> dbCenterSourcePermissionCache = new HashMap<String, Boolean>(16);
            HashMap<String, Boolean> dbConnectionsCache = new HashMap<String, Boolean>(16);
            HashMap<String, Boolean> superQuerySchemaCache = new HashMap<String, Boolean>(16);
            for (Macro macroItem : macros) {
                SQLMacro sqlMacro = (SQLMacro)macroItem;
                SQLMacroPO sqlMacroPO = (SQLMacroPO)sqlMacroPOMap.get(macroItem.getFid());
                if (sqlMacroPO != null) {
                    SQLMacro sqlMacroInfo = sqlMacroPO.toSQLMacro();
                    sqlMacro.setSQLType(sqlMacroInfo.getSQLType());
                    sqlMacro.setDBInfo(sqlMacroInfo.getDBInfo());
                    sqlMacro.setContent(sqlMacroInfo.getContent());
                }
                MacroCheckResult checkResult = this.checkMacro(sqlMacro, dbCenterSourcePermissionCache, dbConnectionsCache, iMacroCheckPermission, superQuerySchemaCache);
                sqlMacro.setMacroStatus(checkResult.getMacroStatus());
                if (sqlMacro.getDBInfo() != null) {
                    this.getDBConnectionDomain().replacePasswordWithUUID(sqlMacro.getDBInfo().getDbSource());
                }
                sqlMacros.add((Macro)sqlMacro);
            }
            return sqlMacros;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
    }

    public void packageMacro(Macro macro, PackageMeta packageMeta) {
        ExportSQLMacro exportSQLMacro = this.convertExportSQLMacro((SQLMacro)macro);
        ExportDBConnInfo exportDBConn = exportSQLMacro.getDbConnInfo();
        if (null != exportDBConn) {
            DBConnection connInfo = ((SQLMacro)macro).getDBInfo();
            if (connInfo.getDbSource().getDBConnectionType() == DBConnectionType.SuperQuery) {
                SuperQuerySource superQuerySource = (SuperQuerySource)connInfo.getDbSource();
                if (!superQuerySource.isPublic()) {
                    packageMeta.addDBConn(exportDBConn);
                }
            } else if (connInfo.isDBCenterSource()) {
                packageMeta.addDBConn(exportDBConn);
            }
        }
        packageMeta.addMacro((ExportMacro)exportSQLMacro);
    }

    public void attachResources(Macro macro, Resources resources) {
        ExportSQLMacro exportSQLMacro = this.convertExportSQLMacro((SQLMacro)macro);
        ExportDBConnInfo exportDBConn = exportSQLMacro.getDbConnInfo();
        ArrayList<ExportSQLMacro> exportMacros = resources.getMacros();
        if (exportMacros == null) {
            exportMacros = new ArrayList<ExportSQLMacro>();
        }
        exportMacros.add(exportSQLMacro);
        ArrayList<ExportDBConnInfo> exportDBConns = resources.getDBConnInfos();
        if (exportDBConns == null) {
            exportDBConns = new ArrayList<ExportDBConnInfo>();
        }
        if (null != exportDBConn) {
            DBConnection connInfo = ((SQLMacro)macro).getDBInfo();
            if (connInfo.getDbSource().getDBConnectionType() == DBConnectionType.SuperQuery) {
                SuperQuerySource superQuerySource = (SuperQuerySource)connInfo.getDbSource();
                if (!superQuerySource.isPublic()) {
                    exportDBConns.add(exportDBConn);
                }
            } else if (connInfo.isDBCenterSource()) {
                exportDBConns.add(exportDBConn);
            }
        }
        resources.setMacros(exportMacros);
        resources.setDBConnInfos(exportDBConns);
    }

    private ExportDBConnInfo convertExportModel(DBConnection dbConn) {
        ExportDBConnInfo exportModel = new ExportDBConnInfo();
        exportModel.setId(dbConn.getId());
        exportModel.setName(dbConn.getName());
        exportModel.setDbSource(dbConn.getDbSource());
        exportModel.setDbSourceType(dbConn.getDbSourceType());
        return exportModel;
    }

    private ExportSQLMacro convertExportSQLMacro(SQLMacro sqlMacro) {
        ExportSQLMacro exportMacro = new ExportSQLMacro();
        exportMacro.setId(sqlMacro.getFid());
        exportMacro.setDesc(sqlMacro.getDesc());
        exportMacro.setName(sqlMacro.getName());
        exportMacro.setMultiValued(sqlMacro.isMultiValued());
        exportMacro.setType(sqlMacro.getType());
        exportMacro.setUid(sqlMacro.getUid());
        exportMacro.setContent(sqlMacro.getContent());
        exportMacro.setSQLType(sqlMacro.getSQLType());
        DBConnection dbConn = sqlMacro.getDBInfo();
        if (dbConn != null) {
            ExportDBConnInfo exportDBConn = this.convertExportModel(dbConn);
            exportMacro.setRefDBHashcode(dbConn.getDBHashCode());
            exportMacro.setDbConnInfo(exportDBConn);
        }
        return exportMacro;
    }

    public List<String> getMacroFieldsByUid(Macro macro) throws QingMacroException {
        if (this.checkMacroReject(macro.getFid())) {
            throw new MacroRejectExecuteException(macro.getName(), 1200019);
        }
        return this.executeMacro((SQLMacro)macro, 1, new DBSourceExecutor<List<String>>(){

            public List<String> execute(AbstractDBSourceJDBCAdapter jdbcAdapter, DBSource dbSource, String sql, DBSource.UserSQL.SQLType sqlType, boolean multiValued, int limitRows) throws SQLException, AbstractDBSourceException {
                return jdbcAdapter.query(SQLMacroDomain.this.qingContext, dbSource, sql, sqlType, new AbstractDBSourceJDBCAdapter.QueryResultHandler<List<String>>(){

                    public List<String> handle(ResultSet rs) throws SQLException {
                        ArrayList<String> allColumnNames = new ArrayList<String>(10);
                        ResultSetMetaData meta = rs.getMetaData();
                        int columnCount = meta.getColumnCount();
                        if (columnCount >= 1) {
                            int i = 1;
                            while (i <= columnCount) {
                                int columnIdx = i++;
                                String columnName = meta.getColumnLabel(columnIdx);
                                allColumnNames.add(columnName);
                            }
                        }
                        return allColumnNames;
                    }
                });
            }
        });
    }

    public SQLMacro checkPermissionBeforeEdit(Macro macro) throws QingMacroException, AbstractQingIntegratedException {
        try {
            MacroCheckResult checkResult = this.checkMacro(macro);
            SQLMacro sqlMacro = (SQLMacro)macro;
            sqlMacro.setMacroStatus(checkResult.getMacroStatus());
            if (sqlMacro.getDBInfo() != null) {
                this.getDBConnectionDomain().replacePasswordWithUUID(sqlMacro.getDBInfo().getDbSource());
            }
            return sqlMacro;
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QingMacroException((Throwable)e);
        }
    }
}

