/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.Messages;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.integrated.IIntegratedHelperStrategy;
import com.kingdee.bos.qing.common.strategy.publishmenu.IPublishMenuStrategy;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PublishInfoDao {
    private IDBExcuter dbExcuter;

    public PublishInfoDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void deletePublishInfo(String infoId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{infoId};
        String sqlDelPublish = "DELETE FROM T_QING_PUBLISH WHERE FID in (?)";
        this.dbExcuter.execute(sqlDelPublish, params);
    }

    public PublishPO getPublishInfoByInfoId(String infoId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH,FLASTBIZTAG FROM T_QING_PUBLISH WHERE FID = ?";
        return (PublishPO)this.dbExcuter.query(sql, new Object[]{infoId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PublishPO> getBatchPublishInfoByInfoId(List<String> infoIdList, String userId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH FROM T_QING_PUBLISH WHERE FID in (");
        Object[] params = new Object[infoIdList.size()];
        for (int i = 0; i < infoIdList.size(); ++i) {
            params[i] = infoIdList.get(i);
            sql.append(i != infoIdList.size() - 1 ? "?," : "?");
        }
        sql.append(" )");
        return (List)this.dbExcuter.query(sql.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PublishPO> getPublishInfoByInfoIds(List<String> infoIds, String userId) throws AbstractQingIntegratedException, SQLException {
        if (infoIds == null || infoIds.size() == 0) {
            return new ArrayList<PublishPO>();
        }
        String sqlInId = this.getListParamStrInSQL(infoIds);
        String sql = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH FROM T_QING_PUBLISH WHERE FID IN (" + sqlInId + ")";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.addAll(infoIds);
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            sql = sql + "AND FCREATORID = ? ";
            queryValue.add(userId);
        }
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<String> loadAllPublishPath(String userId, int type) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT DISTINCT FPATH FROM T_QING_PUBLISH WHERE FCREATORID=? and FTYPE=?";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, String.valueOf(type)}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updatePublishInfo(int updateType, PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sqlUpdate = new StringBuilder("UPDATE T_QING_PUBLISH SET FANALYSIS=? ");
        paramList.add(publishInfo.isCanAnalysis());
        switch (updateType) {
            case 6: {
                sqlUpdate.append(", FSCHEMAID = ? ");
                paramList.add(publishInfo.getSchemaId());
            }
            case 7: {
                sqlUpdate.append(",FNAME=? ");
                paramList.add(publishInfo.getName());
                sqlUpdate.append(",FPATH=? ");
                paramList.add(publishInfo.getPath());
                break;
            }
            case 0: {
                sqlUpdate.append(", FSCHEMAID = ? ");
                paramList.add(publishInfo.getSchemaId());
                sqlUpdate.append(",FNAME=? ");
                paramList.add(publishInfo.getName());
                break;
            }
            case 1: {
                sqlUpdate.append(", FSCHEMAID = ? ");
                paramList.add(publishInfo.getSchemaId());
                sqlUpdate.append(",FPATH=? ");
                paramList.add(publishInfo.getPath());
                break;
            }
            case 10: {
                sqlUpdate.append(",FCREATETIME=? ");
                paramList.add(publishInfo.getCreateTime());
                break;
            }
            case 8: {
                sqlUpdate.append(", FSCHEMAID = ? ");
                paramList.add(publishInfo.getSchemaId());
                sqlUpdate.append(",FNAME=? ");
                paramList.add(publishInfo.getName());
                sqlUpdate.append(",FPATH=? ");
                paramList.add(publishInfo.getPath());
                sqlUpdate.append(",FCARRYDATA=? ");
                paramList.add(publishInfo.isCarryData());
                if (StringUtils.isNotEmpty((CharSequence)publishInfo.getParentPublishIdFullPath())) {
                    sqlUpdate.append(",FPARENTPUBIDFULLPATH=? ");
                    paramList.add(publishInfo.getParentPublishIdFullPath());
                }
                sqlUpdate.append(", FLASTBIZTAG = ? ");
                paramList.add(publishInfo.getLastBiztag());
                break;
            }
        }
        sqlUpdate.append(" WHERE FID=?");
        paramList.add(publishInfo.getId());
        this.dbExcuter.execute(sqlUpdate.toString(), paramList.toArray());
    }

    public void savePublishInfo(PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException {
        String sqlPublish = "INSERT INTO T_QING_PUBLISH (FID,FTYPE,FSOURCE,FNAME,FPATH,FANALYSIS,FTAGID,FCREATORID,FCREATETIME,FUPDATETIME,FSCHEMAID,FCARRYDATA,FPARENTPUBIDFULLPATH,FLASTBIZTAG) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Object[] params = new Object[14];
        int i = 0;
        params[i++] = publishInfo.getId();
        params[i++] = publishInfo.getPublishTargetType();
        params[i++] = publishInfo.getPublishSourceType() != null ? publishInfo.getPublishSourceType().name() : "";
        params[i++] = publishInfo.getName();
        params[i++] = publishInfo.getPath();
        params[i++] = publishInfo.isCanAnalysis();
        params[i++] = publishInfo.getTagId();
        params[i++] = publishInfo.getCreatorId();
        params[i++] = publishInfo.getCreateTime() == null ? new Date() : publishInfo.getCreateTime();
        params[i++] = publishInfo.getUpdateTime() == null ? new Date() : publishInfo.getUpdateTime();
        params[i++] = StringUtils.isEmpty((CharSequence)publishInfo.getSchemaId()) ? " " : publishInfo.getSchemaId();
        params[i++] = publishInfo.isCarryData();
        params[i++] = publishInfo.getParentPublishIdFullPath();
        params[i++] = publishInfo.getLastBiztag();
        this.dbExcuter.execute(sqlPublish, params);
    }

    public void movePublishInfo(String userId, String oldPath, String newPath) throws AbstractQingIntegratedException, SQLException {
        String sql = "update T_QING_PUBLISH set FPATH=? where Fpath=? and FCREATORID=?";
        this.dbExcuter.execute(sql, new Object[]{newPath, oldPath, userId});
    }

    public boolean checkSameSourceNameExist(PublishPO publishInfo, String bizTag, boolean isSave) throws AbstractQingIntegratedException, SQLException {
        String newSql;
        IPublishMenuStrategy strategy;
        int type = publishInfo.getPublishTargetType();
        String name = publishInfo.getName();
        String path = publishInfo.getPath();
        String userId = publishInfo.getCreatorId();
        String id = publishInfo.getId();
        String sqlCheck = "SELECT 1 FROM T_QING_PUBLISH WHERE FTYPE=? AND FNAME=? AND FCREATORID=? AND FTAGID=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(type));
        params.add(name);
        params.add(userId);
        params.add(bizTag);
        boolean isCosmicAppMenu = false;
        if (0 == type && (strategy = (IPublishMenuStrategy)CustomStrategyRegistrar.getStrategy(IPublishMenuStrategy.class)) != null && StringUtils.isNotEmpty((CharSequence)(newSql = strategy.appendMenuPath(sqlCheck, path, params)))) {
            sqlCheck = newSql;
            isCosmicAppMenu = true;
        }
        if (!isCosmicAppMenu) {
            sqlCheck = sqlCheck + " AND FPATH=?";
            params.add(path);
        }
        if (!isSave) {
            sqlCheck = sqlCheck + " AND FID<>?";
            params.add(id);
        }
        return (Boolean)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public List<String> getPublishIdBythemeId(String themeId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select FID from T_QING_PUBLISH where FTAGID=? and FTYPE='2'";
        Object[] param = new Object[]{themeId};
        List publishIds = (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                return list;
            }
        });
        return publishIds;
    }

    public boolean hasPublishInfo(String userId, int type, List<String> pathList) throws AbstractQingIntegratedException, SQLException {
        String sqlInPath = this.getListParamStrInSQL(pathList);
        String sql = "SELECT FID FROM T_QING_PUBLISH WHERE FTYPE=? AND FCREATORID=? AND FPATH IN (" + sqlInPath + ")";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(String.valueOf(type));
        queryValue.add(userId);
        queryValue.addAll(pathList);
        return (Boolean)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public List<PublishPO> loadPublishInfos(String tagId, int type, String userId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH FROM T_QING_PUBLISH WHERE FTAGID = ? AND FTYPE = ? AND FCREATORID = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{tagId, String.valueOf(type), userId}, (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishInfos = new ArrayList<PublishPO>(10);
                while (rs.next()) {
                    PublishPO publishInfo = null;
                    publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    String source = rs.getString("FSOURCE");
                    if (source != null && !"".equals(source.trim())) {
                        publishInfo.setPublishSourceType(PublishSourceEnum.valueOf((String)source));
                    }
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    publishInfo.setParentPublishIdFullPath(rs.getString("FPARENTPUBIDFULLPATH"));
                    publishInfos.add(publishInfo);
                }
                return publishInfos;
            }
        });
    }

    public List<PublishPO> loadPublishInfos(String tagId, String userId) throws SQLException, AbstractQingIntegratedException {
        String sqlSelect = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH FROM T_QING_PUBLISH ";
        String sqlWhere = "";
        Object[] param = null;
        if (tagId != null && userId != null) {
            sqlWhere = " WHERE FTAGID = ? AND FCREATORID = ? ";
            param = new Object[]{tagId, userId};
        } else if (tagId != null) {
            sqlWhere = " WHERE FTAGID = ? ";
            param = new Object[]{tagId};
        } else if (userId != null) {
            sqlWhere = " WHERE FCREATORID = ? ";
            param = new Object[]{userId};
        }
        String sql = sqlSelect + sqlWhere;
        return (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishInfos = new ArrayList<PublishPO>(10);
                while (rs.next()) {
                    PublishPO publishInfo = null;
                    publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    String source = rs.getString("FSOURCE");
                    if (source != null && !"".equals(source.trim())) {
                        publishInfo.setPublishSourceType(PublishSourceEnum.valueOf((String)source));
                    }
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    publishInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                    publishInfo.setParentPublishIdFullPath(rs.getString("FPARENTPUBIDFULLPATH"));
                    publishInfos.add(publishInfo);
                }
                return publishInfos;
            }
        });
    }

    public PublishPO loadPublishInfo(int type, String name, String path, String userId, String tagId) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH FROM T_QING_PUBLISH WHERE FTYPE=? AND FNAME=? AND FPATH=? AND FCREATORID=? AND FTAGID=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(type));
        params.add(name);
        params.add(path);
        params.add(userId);
        params.add(tagId);
        return (PublishPO)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<PublishPO>(){

            public PublishPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    PublishPO publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    String source = rs.getString("FSOURCE");
                    if (source != null && !"".equals(source.trim())) {
                        publishInfo.setPublishSourceType(PublishSourceEnum.valueOf((String)source));
                    }
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    publishInfo.setParentPublishIdFullPath(rs.getString("FPARENTPUBIDFULLPATH"));
                    return publishInfo;
                }
                return null;
            }
        });
    }

    public String loadPublishId(int type, String name, String path) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID FROM T_QING_PUBLISH WHERE FTYPE=? AND FNAME=? AND FPATH=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(type));
        params.add(name);
        params.add(path);
        return (String)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public String loadPublishId(int type, String name, String path, String userId) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID FROM T_QING_PUBLISH WHERE FTYPE=? AND FNAME=? AND FPATH=? AND FCREATORID=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(type));
        params.add(name);
        params.add(path);
        params.add(userId);
        return (String)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public String loadPublishId(int type, String name, String path, String publishSource, String userId) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID FROM T_QING_PUBLISH WHERE FTYPE=? AND FNAME=? AND FPATH=? AND FSOURCE != ? AND FCREATORID=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(type));
        params.add(name);
        params.add(path);
        params.add(publishSource);
        params.add(userId);
        return (String)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
    }

    public List<PublishPO> loadTagIdPublishIdMapsBySourceTypeAndAuth(PublishSourceEnum source, String userId, Set<String> userRoles, Set<String> creatorIds, Boolean isPreset) throws SQLException, AbstractQingIntegratedException {
        Object[] params;
        String sql;
        Object[] queryByUserRoleParams;
        if (source == null || userId == null || creatorIds.isEmpty()) {
            throw new SQLException(Messages.getMLS((String)"paramError", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String union = " union ";
        StringBuilder queryByCreatorPlaceHolderSb = new StringBuilder();
        for (String creatorId : creatorIds) {
            queryByCreatorPlaceHolderSb.append("?,");
        }
        String queryByCreatorPlaceHolder = queryByCreatorPlaceHolderSb.toString();
        String queryByCreatorsSql = "SELECT TQP.FID, TQP.FTAGID, TQP.FNAME, TQP.FTYPE, TQP.FPATH, TQP.FCREATORID, TQP.FCREATETIME FROM T_QING_PUBLISH TQP WHERE TQP.FSOURCE = ? AND TQP.FCREATORID IN ( " + queryByCreatorPlaceHolder.substring(0, queryByCreatorPlaceHolder.length() - 1) + " )";
        Object[] sourceParam = new Object[]{source.name()};
        String[] creatorParams = creatorIds.toArray(new String[0]);
        Object[] queryByCreatorParams = new Object[sourceParam.length + creatorParams.length];
        System.arraycopy(sourceParam, 0, queryByCreatorParams, 0, sourceParam.length);
        System.arraycopy(creatorParams, 0, queryByCreatorParams, sourceParam.length, creatorParams.length);
        String andSql = "";
        Object[] andParam1 = new Object[]{source.name(), userId};
        if (!userRoles.isEmpty()) {
            StringBuilder queryByUserRolePlaceHolderSb = new StringBuilder();
            for (String userRole : userRoles) {
                queryByUserRolePlaceHolderSb.append("?,");
            }
            String queryByUserRolePlaceHolder = queryByUserRolePlaceHolderSb.toString();
            andSql = "OR (TQP2.FTYPE='1' AND TQP2.FVIEWERID IN ( " + queryByUserRolePlaceHolder.substring(0, queryByUserRolePlaceHolder.length() - 1) + " ))";
            String[] andParam2 = userRoles.toArray(new String[0]);
            queryByUserRoleParams = new Object[andParam1.length + andParam2.length];
            System.arraycopy(andParam1, 0, queryByUserRoleParams, 0, andParam1.length);
            System.arraycopy(andParam2, 0, queryByUserRoleParams, andParam1.length, andParam2.length);
        } else {
            queryByUserRoleParams = andParam1;
        }
        String queryByUserRoleSql = "SELECT TQP.FID, TQP.FTAGID, TQP.FNAME, TQP.FTYPE, TQP.FPATH, TQP.FCREATORID, TQP.FCREATETIME FROM T_QING_PUBLISH TQP WHERE TQP.FSOURCE = ? AND EXISTS ( SELECT 1 FROM T_QING_PERMPUBLISH TQP2 WHERE TQP.FID = TQP2.FPUBLISHID AND ( (TQP2.FTYPE='0' AND TQP2.FVIEWERID = ?) OR TQP2.FTYPE IN ('2', '3') " + andSql + ") )";
        if (isPreset.booleanValue()) {
            sql = queryByCreatorsSql;
            params = new Object[queryByCreatorParams.length];
            System.arraycopy(queryByCreatorParams, 0, params, 0, queryByCreatorParams.length);
        } else {
            sql = queryByCreatorsSql + union + queryByUserRoleSql;
            params = new Object[queryByCreatorParams.length + queryByUserRoleParams.length];
            System.arraycopy(queryByCreatorParams, 0, params, 0, queryByCreatorParams.length);
            System.arraycopy(queryByUserRoleParams, 0, params, queryByCreatorParams.length, queryByUserRoleParams.length);
        }
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishPOList = new ArrayList<PublishPO>(10);
                while (rs.next()) {
                    PublishPO publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                    publishPOList.add(publishInfo);
                }
                return publishPOList;
            }
        });
    }

    public boolean isNameExist(int type, String name, String path, String userId) throws AbstractQingIntegratedException, SQLException {
        String publishId = this.loadPublishId(type, name, path, userId);
        return publishId != null;
    }

    public List<PublishPO> loadPublishInfo(int type, String path, String userId, String sourceType) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA FROM T_QING_PUBLISH WHERE FTYPE=? AND FPATH=? AND FCREATORID=? AND FSOURCE=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(String.valueOf(type));
        params.add(path);
        params.add(userId);
        params.add(sourceType);
        return (List)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishPOs = new ArrayList<PublishPO>(10);
                while (rs.next()) {
                    PublishPO publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    String source = rs.getString("FSOURCE");
                    if (source != null && !"".equals(source.trim())) {
                        publishInfo.setPublishSourceType(PublishSourceEnum.valueOf((String)source));
                    }
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    publishPOs.add(publishInfo);
                }
                return publishPOs;
            }
        });
    }

    public List<PublishPO> loadPublishInfoByTagId(String tagId, String userId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA FROM T_QING_PUBLISH WHERE FTAGID = ? AND (FTYPE = '0' or FTYPE = '1') AND FCREATORID = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{tagId, userId}, (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishInfos = new ArrayList<PublishPO>(10);
                while (rs.next()) {
                    PublishPO publishInfo = null;
                    publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    String source = rs.getString("FSOURCE");
                    if (source != null && !"".equals(source.trim())) {
                        publishInfo.setPublishSourceType(PublishSourceEnum.valueOf((String)source));
                    }
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    publishInfos.add(publishInfo);
                }
                return publishInfos;
            }
        });
    }

    public List<PublishPO> loadAllPublishInfosWithoutPushAndLightApp(String tagId, String userId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH,FLASTBIZTAG FROM T_QING_PUBLISH WHERE FTAGID = ? AND FCREATORID = ? AND FTYPE NOT IN(?,?)";
        return (List)this.dbExcuter.query(sql, new Object[]{tagId, userId, String.valueOf(2), String.valueOf(6)}, (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishInfos = new ArrayList<PublishPO>(10);
                while (rs.next()) {
                    PublishPO publishInfo = null;
                    publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    String source = rs.getString("FSOURCE");
                    if (source != null && !"".equals(source.trim())) {
                        publishInfo.setPublishSourceType(PublishSourceEnum.valueOf((String)source));
                    }
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                    publishInfo.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                    publishInfo.setCarryData(rs.getBoolean("FCARRYDATA"));
                    publishInfo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                    publishInfo.setParentPublishIdFullPath(rs.getString("FPARENTPUBIDFULLPATH"));
                    publishInfo.setLastBiztag(rs.getString("FLASTBIZTAG"));
                    publishInfos.add(publishInfo);
                }
                return publishInfos;
            }
        });
    }

    public List<String> loadLappPushPublishInfos(String tagId, int type, String userId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT P.FID,P.FNAME,P.FTYPE,P.FSOURCE,P.FTAGID,P.FANALYSIS,P.FPATH,P.FSCHEMAID,P.FCREATORID,P.FUPDATETIME,P.FCREATETIME,P.FCARRYDATA FROM T_QING_PUSH_RECORD PUSH LEFT JOIN T_QING_PUBLISH P ON PUSH.FPUBLISHID = P.FID WHERE P.FTAGID = ? AND P.FTYPE = ? AND P.FCREATORID = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{tagId, String.valueOf(type), userId}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishIds = new ArrayList<String>(10);
                while (rs.next()) {
                    publishIds.add(rs.getString("FID"));
                }
                return publishIds;
            }
        });
    }

    public List<FileResourceVO> findResourceFilePublishedAndCardThumbnail(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE, P.FID AS PUBLISHID,  P.FNAME AS PUBLISHNAME, P.FPATH AS PUBLISHPATH, P.FTYPE AS PUBLISHTYPE, PG.FNAME AS PUBLISHGROUPNAME,  C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1 , C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3 , C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4  FROM      (SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE FROM T_QING_FILE_RESOURCE FR       WHERE FR.FUSERID = ? AND (FR.FFROMTYPE='PUBLISHED' OR FR.FFROMTYPE='CARDTHUMBNAIL')) FR  LEFT JOIN T_QING_PUBLISH P ON FR.FFROMID=P.FID  LEFT JOIN T_QING_PUBLISH_GROUP PG ON P.FPATH=PG.FID  LEFT JOIN T_QING_CENTER_RELATION CR ON CR.FID=P.FPATH  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID ";
        return (List)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new ResultHandler<List<FileResourceVO>>(){

            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    PublishInfoDao.this.createResourceFile(rs, resourceFile, IntegratedHelper2);
                    list.add(resourceFile);
                }
                return list;
            }
        });
    }

    public List<FileResourceVO> findResourceFileTimingPush(String userId) throws AbstractQingIntegratedException, SQLException {
        String fromType = ResourceFromType.TIMINGPUSH.name();
        String PUSH_TARGET_TYPE_EMAIL = "-1";
        String sql = "SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE, P.FID AS PUBLISHID,  P.FNAME AS PUBLISHNAME, P.FPATH AS PUBLISHPATH, P.FTYPE AS PUBLISHTYPE, PCI.FID AS CONFIGID, PCI.FPUSHTARGET AS PUSHTARGET,  PEC.FID AS EMAILFID  FROM      (SELECT FR.FFROMID, FR.FUSERID, FR.FDISPLAYNAME, FR.FFROMTYPE, FR.FCREATEDATE, FR.FFILESIZE FROM T_QING_FILE_RESOURCE FR       WHERE FR.FUSERID = ? AND FR.FFROMTYPE = ? ) FR  LEFT JOIN T_QING_PUBLISH P ON FR.FFROMID=P.FID  LEFT JOIN T_QING_PUSH_CONFIG_INFO PCI ON P.FPATH=PCI.FID  LEFT JOIN T_QING_PUB_EMAIL_CONF PEC ON P.FPATH=PEC.FID ";
        return (List)this.dbExcuter.query(sql, new Object[]{userId, fromType}, (ResultHandler)new ResultHandler<List<FileResourceVO>>(){

            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
                    resourceFile.setFileSizeNoFormat(rs.getString("FFILESIZE"));
                    long fcreatedate = rs.getTimestamp("FCREATEDATE").getTime();
                    resourceFile.setCreateDate(Long.valueOf(fcreatedate));
                    String formatDateTime = IntegratedHelper2.formatDateTime(new Date(fcreatedate));
                    resourceFile.setCreateDateFormat(formatDateTime);
                    String fromType = rs.getString("FFROMTYPE");
                    resourceFile.setFromType(fromType);
                    resourceFile.setUserId(rs.getString("FUSERID"));
                    String publishName = rs.getString("PUBLISHNAME");
                    String publishPath = rs.getString("PUBLISHPATH");
                    String publishType = rs.getString("PUBLISHTYPE");
                    resourceFile.setFromPath(publishPath);
                    resourceFile.setFromName(publishName);
                    resourceFile.setFromTargetType(publishType);
                    if ("2".equals(resourceFile.getFromTargetType())) {
                        String pushType = rs.getString("PUSHTARGET");
                        resourceFile.setFromTargetType(pushType);
                        boolean sourceExist = StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")) && StringUtils.isNotBlank((CharSequence)rs.getString("CONFIGID"));
                        resourceFile.setSourceExist(sourceExist);
                    } else {
                        resourceFile.setFromTargetType("-1");
                        boolean sourceExist = StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")) && StringUtils.isNotBlank((CharSequence)rs.getString("EMAILFID"));
                        resourceFile.setSourceExist(sourceExist);
                    }
                    list.add(resourceFile);
                }
                return list;
            }
        });
    }

    public List<FileResourceVO> findResourceFileByIds(List<String> fids) throws AbstractQingIntegratedException, SQLException {
        StringBuffer whereInSql = new StringBuffer("?");
        for (int i = 1; i < fids.size(); ++i) {
            whereInSql.append(",?");
        }
        String sql = "SELECT P.FID AS FFROMID, P.FCREATORID AS FUSERID, P.FSOURCE AS FPUBLISHSOURCE,  P.FNAME AS PUBLISHNAME, P.FPATH AS PUBLISHPATH, P.FTYPE AS PUBLISHTYPE, PG.FNAME AS PUBLISHGROUPNAME,  C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1 , C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3 , C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4  FROM      (SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA FROM T_QING_PUBLISH        WHERE FID in (" + whereInSql + ")) P  LEFT JOIN T_QING_PUBLISH_GROUP PG ON P.FPATH=PG.FID  LEFT JOIN T_QING_CENTER_RELATION CR ON CR.FID=P.FPATH  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID ";
        return (List)this.dbExcuter.query(sql, fids.toArray(), (ResultHandler)new ResultHandler<List<FileResourceVO>>(){

            public List<FileResourceVO> handle(ResultSet rs) throws SQLException {
                ArrayList<FileResourceVO> resourceFileList = new ArrayList<FileResourceVO>(10);
                while (rs.next()) {
                    FileResourceVO resourceFile = new FileResourceVO();
                    resourceFile.setFromId(rs.getString("FFROMID"));
                    resourceFile.setUserId(rs.getString("FUSERID"));
                    String publishName = rs.getString("PUBLISHNAME");
                    String publishPath = rs.getString("PUBLISHPATH");
                    String publishType = rs.getString("PUBLISHTYPE");
                    String publishSource = rs.getString("FPUBLISHSOURCE");
                    String centerName1 = rs.getString("FCENTERNAME1");
                    String centerName2 = rs.getString("FCENTERNAME2");
                    String centerName3 = rs.getString("FCENTERNAME3");
                    String centerName4 = rs.getString("FCENTERNAME4");
                    String cardGroupName = rs.getString("PUBLISHGROUPNAME");
                    resourceFile.setFromPath(publishPath);
                    resourceFile.setFromName(publishName);
                    resourceFile.setFromTargetType(publishType);
                    resourceFile.setFromSourceType(publishSource);
                    if ("1".equals(publishType)) {
                        String pathFullName = "";
                        if (StringUtils.isNotBlank((CharSequence)publishPath)) {
                            if (StringUtils.isNotBlank((CharSequence)centerName4)) {
                                pathFullName = centerName1 + "/" + centerName2 + "/" + centerName3 + "/" + centerName4;
                            } else if (StringUtils.isNotBlank((CharSequence)centerName3)) {
                                pathFullName = centerName1 + "/" + centerName2 + "/" + centerName3;
                            } else if (StringUtils.isNotBlank((CharSequence)centerName2)) {
                                pathFullName = centerName1 + "/" + centerName2;
                            } else if (StringUtils.isNotBlank((CharSequence)centerName1)) {
                                pathFullName = centerName1;
                            }
                        }
                        resourceFile.setFromPathName(pathFullName);
                    } else if ("5".equals(publishType)) {
                        resourceFile.setFromPathName(cardGroupName);
                    }
                    resourceFileList.add(resourceFile);
                }
                return resourceFileList;
            }
        });
    }

    private void createResourceFile(ResultSet rs, FileResourceVO resourceFile, IIntegratedHelperStrategy IntegratedHelper2) throws SQLException {
        resourceFile.setFromId(rs.getString("FFROMID"));
        resourceFile.setDisplayName(rs.getString("FDISPLAYNAME"));
        resourceFile.setFileSizeNoFormat(rs.getString("FFILESIZE"));
        long fcreatedate = rs.getTimestamp("FCREATEDATE").getTime();
        resourceFile.setCreateDate(Long.valueOf(fcreatedate));
        String formatDateTime = IntegratedHelper2.formatDateTime(new Date(fcreatedate));
        resourceFile.setCreateDateFormat(formatDateTime);
        String fromType = rs.getString("FFROMTYPE");
        resourceFile.setFromType(fromType);
        resourceFile.setUserId(rs.getString("FUSERID"));
        String publishName = rs.getString("PUBLISHNAME");
        String publishPath = rs.getString("PUBLISHPATH");
        String publishType = rs.getString("PUBLISHTYPE");
        String centerName1 = rs.getString("FCENTERNAME1");
        String centerName2 = rs.getString("FCENTERNAME2");
        String centerName3 = rs.getString("FCENTERNAME3");
        String centerName4 = rs.getString("FCENTERNAME4");
        String cardGroupName = rs.getString("PUBLISHGROUPNAME");
        resourceFile.setFromPath(publishPath);
        resourceFile.setFromName(publishName);
        resourceFile.setFromTargetType(publishType);
        resourceFile.setSourceExist(StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")));
        if ("1".equals(publishType)) {
            String pathFullName = "";
            if (StringUtils.isNotBlank((CharSequence)publishPath)) {
                if (StringUtils.isNotBlank((CharSequence)centerName4)) {
                    pathFullName = centerName1 + "/" + centerName2 + "/" + centerName3 + "/" + centerName4;
                } else if (StringUtils.isNotBlank((CharSequence)centerName3)) {
                    pathFullName = centerName1 + "/" + centerName2 + "/" + centerName3;
                } else if (StringUtils.isNotBlank((CharSequence)centerName2)) {
                    pathFullName = centerName1 + "/" + centerName2;
                } else if (StringUtils.isNotBlank((CharSequence)centerName1)) {
                    pathFullName = centerName1;
                }
            }
            resourceFile.setFromPathName(pathFullName);
        } else if ("5".equals(publishType)) {
            resourceFile.setFromPathName(cardGroupName);
        }
    }

    public List<ScheduleExecuteVO> findScheduleExecuteListByUserId(String userId, Date dateMin, Date dateMax) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME, P.FID AS PUBLISHID,  P.FNAME AS PUBLISHNAME,P.FPATH AS PUBLISHPATH,P.FTYPE AS PUBLISHTYPE, PG.FNAME AS PUBLISHGROUPNAME  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FUSERID=? AND SE.FMETHODNAME='updateLappThumbnail' AND SE.FEXECUTETIME>=? AND SE.FEXECUTETIME<=?) SE  LEFT JOIN T_QING_PUBLISH P ON SE.FSOURCEID=P.FID  LEFT JOIN T_QING_PUBLISH_GROUP PG ON P.FPATH=PG.FID ";
        Object[] params = new Object[]{userId, dateMin, dateMax};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<ScheduleExecuteVO>>(){

            public List<ScheduleExecuteVO> handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ArrayList<ScheduleExecuteVO> voList = new ArrayList<ScheduleExecuteVO>(10);
                while (rs.next()) {
                    ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    scheduleExecute.setSourceName(rs.getString("FSOURCENAME"));
                    String publishName = rs.getString("PUBLISHNAME");
                    String publishPath = rs.getString("PUBLISHPATH");
                    String publishType = rs.getString("PUBLISHTYPE");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceName(publishName);
                    scheduleExecute.setSourcePath(publishPath);
                    scheduleExecute.setSourceTargetType(publishType);
                    scheduleExecute.setUserId(rs.getString("FUSERID"));
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    long fexecutetime = rs.getTimestamp("FEXECUTETIME").getTime();
                    scheduleExecute.setExecuteTime(Long.valueOf(fexecutetime));
                    String executeTimeFormat = IntegratedHelper2.formatDateTime(new Date(fexecutetime));
                    scheduleExecute.setExecuteTimeFormat(executeTimeFormat);
                    if (rs.getTimestamp("FENDTIME") != null) {
                        long fendtime = rs.getTimestamp("FENDTIME").getTime();
                        scheduleExecute.setEndTime(Long.valueOf(fendtime));
                        String endTimeFormat = IntegratedHelper2.formatDateTime(new Date(fendtime));
                        scheduleExecute.setEndTimeFormat(endTimeFormat);
                    }
                    scheduleExecute.setSourceExist(StringUtils.isNotBlank((CharSequence)rs.getString("PUBLISHID")));
                    voList.add(scheduleExecute);
                }
                return voList;
            }
        });
    }

    public ScheduleExecuteVO findById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME,  P.FNAME AS PUBLISHNAME,P.FPATH AS PUBLISHPATH,P.FTYPE AS PUBLISHTYPE, PG.FNAME AS PUBLISHGROUPNAME  FROM      (SELECT SE.FID, SE.FUSERID, SE.FSCHEDULENAME, SE.FSOURCEID, SE.FSOURCENAME, SE.FEXECUTESTATE, SE.FEXECUTETIME, SE.FENDTIME, SE.FMETHODNAME FROM T_QING_SCHEDULE_EXECUTE SE      WHERE SE.FID=? AND SE.FMETHODNAME='updateLappThumbnail' ) SE  LEFT JOIN T_QING_PUBLISH P ON SE.FSOURCEID=P.FID  LEFT JOIN T_QING_PUBLISH_GROUP PG ON P.FPATH=PG.FID ";
        Object[] params = new Object[]{id};
        return (ScheduleExecuteVO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ScheduleExecuteVO>(){

            public ScheduleExecuteVO handle(ResultSet rs) throws SQLException {
                IIntegratedHelperStrategy IntegratedHelper2 = (IIntegratedHelperStrategy)CustomStrategyRegistrar.getStrategy(IIntegratedHelperStrategy.class);
                ScheduleExecuteVO scheduleExecute = new ScheduleExecuteVO();
                if (rs.next()) {
                    scheduleExecute.setId(rs.getString("FID"));
                    scheduleExecute.setScheduleName(rs.getString("FSCHEDULENAME"));
                    scheduleExecute.setSourceId(rs.getString("FSOURCEID"));
                    String publishName = rs.getString("PUBLISHNAME");
                    String publishPath = rs.getString("PUBLISHPATH");
                    String publishType = rs.getString("PUBLISHTYPE");
                    String methodName = rs.getString("FMETHODNAME");
                    scheduleExecute.setSourceName(publishName);
                    scheduleExecute.setSourcePath(publishPath);
                    scheduleExecute.setSourceTargetType(publishType);
                    scheduleExecute.setUserId(rs.getString("FUSERID"));
                    scheduleExecute.setMethodName(methodName);
                    scheduleExecute.setExecuteState(rs.getInt("FEXECUTESTATE"));
                    long fexecutetime = rs.getTimestamp("FEXECUTETIME").getTime();
                    scheduleExecute.setExecuteTime(Long.valueOf(fexecutetime));
                    String executeTimeFormat = IntegratedHelper2.formatDateTime(new Date(fexecutetime));
                    scheduleExecute.setExecuteTimeFormat(executeTimeFormat);
                    if (rs.getTimestamp("FENDTIME") != null) {
                        long fendtime = rs.getTimestamp("FENDTIME").getTime();
                        scheduleExecute.setEndTime(Long.valueOf(fendtime));
                        String endTimeFormat = IntegratedHelper2.formatDateTime(new Date(fendtime));
                        scheduleExecute.setEndTimeFormat(endTimeFormat);
                    }
                }
                return scheduleExecute;
            }
        });
    }

    public void updateModifyDate(String publishId, String userID) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("UPDATE T_QING_PUBLISH SET FUpdateTime=? WHERE FID=? AND FCreatorID=?", new Object[]{new Date(), publishId, userID});
    }

    private String getListParamStrInSQL(List<String> paramList) {
        String sqlInParam = "null";
        if (paramList == null) {
            return sqlInParam;
        }
        StringBuilder sqlInParamBuilder = new StringBuilder();
        sqlInParamBuilder.append("?");
        for (int i = 1; i < paramList.size(); ++i) {
            sqlInParamBuilder.append(",?");
        }
        sqlInParam = sqlInParamBuilder.toString();
        return sqlInParam;
    }

    public boolean isSchedule(String themeId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FID,FSOURCEID FROM T_QING_SCHEDULE WHERE FSOURCEID = ?");
        return (Boolean)this.dbExcuter.query(sql.toString(), new Object[]{themeId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public List<PublishPO> queryParentFullPathByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FID,FNAME,FTYPE,FSOURCE,FTAGID,FANALYSIS,FPATH,FSCHEMAID,FCREATORID,FUPDATETIME,FCREATETIME,FCARRYDATA,FPARENTPUBIDFULLPATH  FROM T_QING_PUBLISH WHERE FPARENTPUBIDFULLPATH LIKE  ?");
        return (List)this.dbExcuter.query(sql.toString(), new Object[]{"%" + publishId + "%"}, (ResultHandler)new ResultHandler<List<PublishPO>>(){

            public List<PublishPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishPO> publishInfos = new ArrayList<PublishPO>(16);
                while (rs.next()) {
                    PublishPO publishInfo = new PublishPO();
                    publishInfo.setId(rs.getString("FID"));
                    publishInfo.setName(rs.getString("FNAME"));
                    publishInfo.setPublishTargetType(rs.getInt("FTYPE"));
                    publishInfo.setTagId(rs.getString("FTAGID"));
                    publishInfo.setCanAnalysis(rs.getBoolean("FANALYSIS"));
                    publishInfo.setPath(rs.getString("FPATH"));
                    publishInfo.setSchemaId(rs.getString("FSCHEMAID"));
                    publishInfo.setCreatorId(rs.getString("FCREATORID"));
                    publishInfo.setParentPublishIdFullPath(rs.getString("FPARENTPUBIDFULLPATH"));
                    publishInfos.add(publishInfo);
                }
                return publishInfos;
            }
        });
    }

    public void updateParentFullPath(List<PublishPO> childrenPublishPoList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(childrenPublishPoList.size());
        for (PublishPO publishPO : childrenPublishPoList) {
            Object[] param = new Object[]{publishPO.getParentPublishIdFullPath(), publishPO.getId()};
            paramsList.add(param);
        }
        this.dbExcuter.executeBatch("UPDATE T_QING_PUBLISH SET FPARENTPUBIDFULLPATH=? WHERE FID=?", paramsList);
    }

    public boolean checkEditPublishInfoSource(PublishPO publishInfoNew) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("select fsource from t_qing_saschema left join t_qing_sarelation on t_qing_saschema.fid = t_qing_sarelation.fschemaid and fuserid = ? where fbiztag = ?");
        Object[] params = new Object[]{publishInfoNew.getCreatorId(), publishInfoNew.getId()};
        return (Boolean)this.dbExcuter.query(sql.toString(), params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("fsource") == 0;
                }
                return false;
            }
        });
    }

    public Map<String, Integer> loadUserCancelPermission(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select ftype, fnooperauthvalue from T_QING_PUB_OPER_PERMISSIONS where fpublishid = ?";
        Object[] param = new Object[]{publishId};
        return (Map)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<Map<String, Integer>>(){

            public Map<String, Integer> handle(ResultSet rs) throws SQLException {
                HashMap<String, Integer> cancelPermission = new HashMap<String, Integer>(1);
                if (rs.next()) {
                    String fType = rs.getString("ftype");
                    int fNoOperauthValue = rs.getInt("fnooperauthvalue");
                    cancelPermission.put(fType, fNoOperauthValue);
                }
                return cancelPermission.size() > 0 ? cancelPermission : null;
            }
        });
    }

    public boolean existPublishInfo(String userId, PublishSourceEnum source, String tagId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT 1 FROM T_QING_PUBLISH WHERE FCREATORID = ? AND FSOURCE = ? AND FTAGID = ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{userId, source.name(), tagId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public boolean checkPublishPerm(PublishSourceEnum source, String tagId, List<String> permTypes, List<String> viewerIds) throws SQLException, AbstractQingIntegratedException {
        Object[] params;
        String sqlWhere;
        if (source == null || tagId == null || permTypes == null || permTypes.isEmpty()) {
            throw new SQLException(Messages.getMLS((String)"paramError", (String)"\u53c2\u6570\u9519\u8bef"));
        }
        String sqlSelect = "SELECT 1 FROM T_QING_PUBLISH T1 LEFT JOIN T_QING_PERMPUBLISH T2 ON T1.FID = T2.FPUBLISHID ";
        Object[] param1 = new Object[]{source.name(), tagId};
        Object[] param2 = permTypes.toArray();
        Object[] paramsIfBranch = new Object[param1.length + param2.length];
        System.arraycopy(param1, 0, paramsIfBranch, 0, param1.length);
        System.arraycopy(param2, 0, paramsIfBranch, param1.length, param2.length);
        String sqlPermTypesIn = this.getListParamStrInSQL(permTypes);
        if (viewerIds == null || viewerIds.isEmpty()) {
            sqlWhere = " WHERE T1.FSOURCE = ? AND T1.FTAGID = ? AND T2.FTYPE IN (" + sqlPermTypesIn + ")";
            params = paramsIfBranch;
        } else {
            String sqlViewerIdsIn = this.getListParamStrInSQL(viewerIds);
            sqlWhere = " WHERE T1.FSOURCE = ? AND T1.FTAGID = ? AND T2.FTYPE IN (" + sqlPermTypesIn + ") AND T2.FVIEWERID in (" + sqlViewerIdsIn + ")";
            Object[] param3 = viewerIds.toArray();
            Object[] paramsElseBranch = new Object[paramsIfBranch.length + param3.length];
            System.arraycopy(paramsIfBranch, 0, paramsElseBranch, 0, paramsIfBranch.length);
            System.arraycopy(param3, 0, paramsElseBranch, paramsIfBranch.length, param3.length);
            params = paramsElseBranch;
        }
        String sql = sqlSelect + sqlWhere;
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public boolean isNameExist(int type, String name, String path) throws AbstractQingIntegratedException, SQLException {
        return this.loadPublishId(type, name, path) != null;
    }

    public boolean existLappPushInfo(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT 1 FROM T_QING_PUSH_RECORD WHERE FPUBLISHID = ?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }
}

