/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.dao;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.ACFolderNameDuplicateException;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.AbstractQingCenterVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterMenuVO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.sqlcondition.InSqlConditionBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisCenterDAO {
    public static final String MY_QING_ANALYSIS_ID = "c81a0135-1157-41a4-8e08-de55179916c1";
    public static final String ADD_SUB = "ADD_SUB";
    private IDBExcuter dbExcuter;
    private QingContext context;
    private static final String EXTREPORT = "extreport";
    private static final String SQUARE = "square";
    private static final String ALL = "all";

    public AnalysisCenterDAO(QingContext context, IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
        this.context = context;
    }

    private boolean checkAddCenterGroupNameExist(QingCenterGroupVO centerVO, String newCenterGoupId, String addType, String userId) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT CR.FID FROM T_QING_CENTER_RELATION CR";
        ArrayList<String> params = new ArrayList<String>(10);
        params.add(userId);
        String centerId1 = centerVO.getLevelId1();
        String centerId2 = centerVO.getLevelId2();
        String centerId3 = centerVO.getLevelId3();
        String centerId4 = centerVO.getLevelId4();
        if (StringUtils.isNotBlank((CharSequence)addType) && ADD_SUB.equals(addType)) {
            if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=?";
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                params.add(newCenterGoupId);
            } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=?";
                params.add(centerId1);
                params.add(centerId2);
                params.add(newCenterGoupId);
            } else {
                sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=?";
                params.add(centerId1);
                params.add(newCenterGoupId);
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerId4)) {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=? ";
            params.add(centerId1);
            params.add(centerId2);
            params.add(centerId3);
            params.add(newCenterGoupId);
        } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? ";
            params.add(centerId1);
            params.add(centerId2);
            params.add(newCenterGoupId);
        } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=? AND CR.FCENTERID1=?";
            params.add(centerId1);
            params.add(newCenterGoupId);
        } else {
            sqlCheck = sqlCheck + " WHERE CR.FCREATORID=? AND CR.FCENTERID=?";
            params.add(newCenterGoupId);
        }
        return (Boolean)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void initDefaultGroup(String userId) throws AbstractQingIntegratedException, SQLException {
        boolean existsCenter = (Boolean)this.dbExcuter.query("SELECT 1 FROM T_QING_CENTER WHERE FID=?", new Object[]{MY_QING_ANALYSIS_ID}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (!existsCenter) {
            Object[] params = new Object[]{MY_QING_ANALYSIS_ID, Messages.getMLS((QingContext)this.context, (String)"myAnalysis", (String)"\u6211\u7684\u8f7b\u5206\u6790", (Messages.ProjectName)Messages.ProjectName.QING_THEME)};
            this.dbExcuter.execute("INSERT INTO T_QING_CENTER(FID, FNAME) VALUES(?,?)", params);
        }
        String sql = "SELECT 1 FROM T_QING_CENTER_RELATION WHERE FCREATORID=? AND FCENTERID1=' '";
        boolean exists = (Boolean)this.dbExcuter.query(sql, new Object[]{userId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (!exists) {
            Date now = new Date(631123200000L);
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?)";
            this.dbExcuter.execute(sql, new Object[]{this.dbExcuter.genStringId("T_QING_CENTER_RELATION"), userId, MY_QING_ANALYSIS_ID, now, now});
        }
    }

    public List<QingCenterGroupVO> loadCenterGroups(String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT CR.FID AS FRELATIONID, C1.FID as FCENTERID1, C1.FNAME as FCENTERNAME1, C2.FID as FCENTERID2, C2.FNAME as FCENTERNAME2, C3.FID as FCENTERID3, C3.FNAME as FCENTERNAME3, C4.FID as FCENTERID4, C4.FNAME as FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE #1 CR.FCREATORID != '" + IntegratedHelper.getPresetUserId() + "' ORDER BY CR.FCREATETIME ASC ";
        Object[] params = null;
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            params = new Object[]{userId};
            sql = sql.replace("#1", "CR.FCREATORID = ? AND");
        } else {
            sql = sql.replace("#1", "");
        }
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getUniqueQingCenterFID(String groupName) throws AbstractQingIntegratedException, SQLException {
        String sql = "select FID FROM T_QING_CENTER where FNAME=?";
        String sFID = (String)this.dbExcuter.query(sql, new Object[]{groupName}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (sFID == null) {
            sFID = this.dbExcuter.genStringId("T_QING_CENTER");
            sql = "INSERT INTO T_QING_CENTER(FID, FNAME) VALUES(?,?)";
            Object[] params = new Object[]{sFID, groupName};
            this.dbExcuter.execute(sql, params);
        }
        return sFID;
    }

    public QingCenterGroupVO saveCenterGroup(QingCenterGroupVO centerVO, String addType, String userId) throws AbstractQingIntegratedException, ACFolderNameDuplicateException, SQLException {
        String newCenterGoupId = this.getUniqueQingCenterFID(centerVO.getName());
        if (this.checkAddCenterGroupNameExist(centerVO, newCenterGoupId, addType, userId)) {
            throw new ACFolderNameDuplicateException();
        }
        String sRelationId = this.dbExcuter.genStringId("T_QING_CENTER_RELATION");
        Date now = new Date();
        String sql = "";
        ArrayList<Object> params = new ArrayList<Object>(10);
        params.add(sRelationId);
        params.add(userId);
        String centerId1 = centerVO.getLevelId1();
        String centerId2 = centerVO.getLevelId2();
        String centerId3 = centerVO.getLevelId3();
        String centerId4 = centerVO.getLevelId4();
        if (StringUtils.isNotBlank((CharSequence)addType) && ADD_SUB.equals(addType)) {
            if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                params.add(newCenterGoupId);
                centerVO.setParentId(centerId3);
                centerVO.setLevelId4(newCenterGoupId);
                centerVO.setLevelName4(centerVO.getName());
                sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCENTERID3,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?,?)";
            } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                params.add(centerId1);
                params.add(centerId2);
                params.add(newCenterGoupId);
                centerVO.setParentId(centerId2);
                centerVO.setLevelId3(newCenterGoupId);
                centerVO.setLevelName3(centerVO.getName());
                sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?)";
            } else {
                params.add(centerId1);
                params.add(newCenterGoupId);
                centerVO.setParentId(centerId1);
                centerVO.setLevelId2(newCenterGoupId);
                centerVO.setLevelName2(centerVO.getName());
                sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?)";
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerId4)) {
            params.add(centerId1);
            params.add(centerId2);
            params.add(centerId3);
            params.add(newCenterGoupId);
            centerVO.setParentId(centerId3);
            centerVO.setLevelId4(newCenterGoupId);
            centerVO.setLevelName4(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCENTERID3,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?,?)";
        } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
            params.add(centerId1);
            params.add(centerId2);
            params.add(newCenterGoupId);
            centerVO.setParentId(centerId2);
            centerVO.setLevelId3(newCenterGoupId);
            centerVO.setLevelName3(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCENTERID2,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?,?)";
        } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
            params.add(centerId1);
            params.add(newCenterGoupId);
            centerVO.setParentId(centerId1);
            centerVO.setLevelId2(newCenterGoupId);
            centerVO.setLevelName2(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCENTERID1,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?,?)";
        } else {
            params.add(newCenterGoupId);
            centerVO.setLevelId1(newCenterGoupId);
            centerVO.setLevelName1(centerVO.getName());
            sql = "INSERT INTO T_QING_CENTER_RELATION(FID, FCREATORID,FCENTERID,FCREATETIME,FUPDATETIME) VALUES(?,?,?,?,?)";
        }
        params.add(now);
        params.add(now);
        this.dbExcuter.execute(sql, params.toArray());
        centerVO.setRelationId(sRelationId);
        centerVO.setId(newCenterGoupId);
        return centerVO;
    }

    public void deleteCenterGroup(List<String> fidList) throws AbstractQingIntegratedException, SQLException {
        String sqlInFid = "null";
        if (fidList != null && fidList.size() > 0) {
            StringBuilder sqlInFidBuilder = new StringBuilder();
            sqlInFidBuilder.append("?");
            for (int i = 1; i < fidList.size(); ++i) {
                sqlInFidBuilder.append(",?");
            }
            sqlInFid = sqlInFidBuilder.toString();
        }
        ArrayList<String> queryValue = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(fidList)) {
            queryValue.addAll(fidList);
        }
        queryValue.add(this.context.getUserId());
        String sql = "DELETE T_QING_CENTER_RELATION WHERE FID IN (" + sqlInFid + ") and FCREATORID=?";
        this.dbExcuter.execute(sql, queryValue.toArray());
    }

    public Map<String, Object> updateCenterGroup(QingCenterGroupVO centerVO, Integer iLevel) throws ACFolderNameDuplicateException, AbstractQingIntegratedException, SQLException {
        String sFID = this.getUniqueQingCenterFID(centerVO.getName());
        if (this.checkUpdateCenterGroupNameExist(centerVO, sFID, iLevel).booleanValue()) {
            throw new ACFolderNameDuplicateException();
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Object> updateParams = new ArrayList<Object>();
        updateParams.add(sFID);
        updateParams.add(new Date());
        updateParams.add(centerVO.getLevelId1());
        String updateSql = "";
        String querySql = "SELECT CR.FID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2, C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON  C1.FID=CR.FCENTERID LEFT JOIN T_QING_CENTER C2 ON  C2.FID=CR.FCENTERID1 LEFT JOIN T_QING_CENTER C3 ON  C3.FID=CR.FCENTERID2 LEFT JOIN T_QING_CENTER C4 ON  C4.FID=CR.FCENTERID3 WHERE CR.FCREATORID = ?";
        ArrayList<String> queryParams = new ArrayList<String>();
        queryParams.add(this.context.getUserId());
        queryParams.add(centerVO.getLevelId1());
        if (iLevel == 4) {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID3=?, FUPDATETIME=? WHERE FCENTERID=? AND FCENTERID1=? AND FCENTERID2=? AND FCENTERID3=? AND FCREATORID=? ";
            updateParams.add(centerVO.getLevelId2());
            updateParams.add(centerVO.getLevelId3());
            updateParams.add(centerVO.getLevelId4());
            querySql = querySql + " AND  CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=?";
            queryParams.add(centerVO.getLevelId2());
            queryParams.add(centerVO.getLevelId3());
            queryParams.add(centerVO.getLevelId4());
        } else if (iLevel == 3) {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID2=?, FUPDATETIME=? WHERE  FCENTERID=? AND FCENTERID1=? AND FCENTERID2=? AND FCREATORID=?";
            updateParams.add(centerVO.getLevelId2());
            updateParams.add(centerVO.getLevelId3());
            querySql = querySql + " AND  CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=?";
            queryParams.add(centerVO.getLevelId2());
            queryParams.add(centerVO.getLevelId3());
        } else if (iLevel == 2) {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID1=?, FUPDATETIME=? WHERE FCENTERID=? AND FCENTERID1=? AND FCREATORID=?";
            updateParams.add(centerVO.getLevelId2());
            querySql = querySql + " AND CR.FCENTERID=? AND CR.FCENTERID1=?";
            queryParams.add(centerVO.getLevelId2());
        } else {
            updateSql = "UPDATE T_QING_CENTER_RELATION SET FCENTERID=?, FUPDATETIME=? WHERE FCENTERID=? AND FCREATORID=?";
            querySql = querySql + " AND CR.FCENTERID=?";
        }
        List updateGroups = (List)this.dbExcuter.query(querySql, queryParams.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        resultMap.put("updateGroups", updateGroups);
        updateParams.add(this.context.getUserId());
        this.dbExcuter.execute(updateSql, updateParams.toArray());
        resultMap.put("newCenterID", sFID);
        return resultMap;
    }

    private Boolean checkUpdateCenterGroupNameExist(QingCenterGroupVO centerVO, String newCenterGroupId, Integer iLevel) throws AbstractQingIntegratedException, SQLException {
        String sqlCheck = "SELECT FID FROM T_QING_CENTER_RELATION WHERE FCREATORID=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.context.getUserId());
        String centerId1 = centerVO.getLevelId1();
        String centerId2 = centerVO.getLevelId2();
        String centerId3 = centerVO.getLevelId3();
        if (iLevel == 4) {
            sqlCheck = sqlCheck + "AND  FCENTERID=? AND FCENTERID1=? AND FCENTERID2=? AND FCENTERID3=? ";
            params.add(centerId1);
            params.add(centerId2);
            params.add(centerId3);
            params.add(newCenterGroupId);
        } else if (iLevel == 3) {
            sqlCheck = sqlCheck + "AND  FCENTERID=? AND FCENTERID1=? AND FCENTERID2=?";
            params.add(centerId1);
            params.add(centerId2);
            params.add(newCenterGroupId);
        } else if (iLevel == 2) {
            sqlCheck = sqlCheck + "AND  FCENTERID=? AND FCENTERID1=?";
            params.add(centerId1);
            params.add(newCenterGroupId);
        } else {
            sqlCheck = sqlCheck + "AND FCENTERID=?";
            params.add(newCenterGroupId);
        }
        return (Boolean)this.dbExcuter.query(sqlCheck, params.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<QingCenterGroupVO> loadPublishedInfos(Set<String> roleIds) throws SQLException, AbstractQingIntegratedException {
        String userId = this.context.getUserId();
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String sql = "SELECT DISTINCT FID, FNAME, FTAGID, FSOURCE, FCREATETIME, DIRCREATETIME, PARENTID, FCREATORID, FCENTERID1, FCENTERNAME1, FCENTERID2, FCENTERNAME2, FCENTERID3, FCENTERNAME3, FCENTERID4, FCENTERNAME4  FROM ( SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, CR.FCREATETIME AS DIRCREATETIME, P.FPATH AS PARENTID, P.FCREATORID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PERMPUBLISH PERM  INNER JOIN T_QING_PUBLISH P ON PERM.FPUBLISHID=P.FID  INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3  WHERE P.FTYPE='1' AND ((PERM.FVIEWERID =? AND PERM.FTYPE='0') OR (PERM.FVIEWERID IN (" + sqlInQuestion + ") AND PERM.FTYPE='1'))  UNION  SELECT P.FID, P.FNAME, P.FTAGID, P.FSOURCE, P.FCREATETIME AS FCREATETIME, CR.FCREATETIME AS DIRCREATETIME, P.FPATH AS PARENTID, P.FCREATORID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P  INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3 \tWHERE  P.FTYPE='1' AND P.FCREATORID=? ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(userId);
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        boolean isPresetManagePermission = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)this.context);
        if (isCurrentUserInQingAdminRole || isPresetManagePermission) {
            sql = sql + " UNION  SELECT P.FID, P.FNAME, P.FTAGID, P.FSOURCE, P.FCREATETIME, CR.FCREATETIME AS DIRCREATETIME, P.FPATH AS PARENTID, P.FCREATORID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P  INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE P.FCREATORID = ?";
            queryValue.add(IntegratedHelper.getPresetUserId());
            if (isCurrentUserInQingAdminRole && !isPresetManagePermission) {
                sql = sql + " AND P.FSOURCE != ?";
                queryValue.add(PublishSourceEnum.extreport.name());
            } else if (isPresetManagePermission && !isCurrentUserInQingAdminRole) {
                sql = sql + " AND FSOURCE = ?";
                queryValue.add(PublishSourceEnum.extreport.name());
            }
        }
        sql = sql + " ) T WHERE T.FID IS NOT NULL ORDER BY T.DIRCREATETIME ASC, T.FCREATETIME ASC";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<AbstractQingCenterVO> loadPublishedInfosForDsb(Set<String> roleIds, String sType) throws SQLException, AbstractQingIntegratedException {
        return this.loadPublishedInfosFor(roleIds, sType, false, false);
    }

    public List<AbstractQingCenterVO> loadPublishedInfosForExtReport(Set<String> roleIds, boolean isPresetSnap) throws SQLException, AbstractQingIntegratedException {
        return this.loadPublishedInfosFor(roleIds, EXTREPORT, true, isPresetSnap);
    }

    private List<AbstractQingCenterVO> loadPublishedInfosFor(Set<String> roleIds, String sType, boolean extReportJoin, boolean isPresetSnap) throws SQLException, AbstractQingIntegratedException {
        String userId = this.context.getUserId();
        String sqlInQuestion = "null";
        if (roleIds != null && roleIds.size() > 0) {
            StringBuilder sqlInQuestionBuilder = new StringBuilder();
            sqlInQuestionBuilder.append("?");
            for (int i = 1; i < roleIds.size(); ++i) {
                sqlInQuestionBuilder.append(",?");
            }
            sqlInQuestion = sqlInQuestionBuilder.toString();
        }
        String extReportJoinSql = " INNER JOIN T_QING_EXTRPT_INFO E ON P.FTAGID=E.FID";
        String sql = "SELECT DISTINCT FID, FNAME, FTAGID, FSOURCE, FCREATETIME, FCREATORID, FSCHEMAID, FPATH, FCENTERID1, FCENTERNAME1, FCENTERID2, FCENTERNAME2, FCENTERID3, FCENTERNAME3, FCENTERID4, FCENTERNAME4  FROM ( SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PERMPUBLISH PERM  INNER JOIN T_QING_PUBLISH P ON PERM.FPUBLISHID=P.FID " + (extReportJoin ? extReportJoinSql : "") + " INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3  WHERE P.FTYPE='1' AND ((PERM.FVIEWERID =? AND PERM.FTYPE='0') OR (PERM.FVIEWERID IN (" + sqlInQuestion + ") AND PERM.FTYPE='1'))  AND (P.FSOURCE IN( '" + this.getSourceCondition(sType) + "')) UNION  SELECT P.FID, P.FNAME, P.FTAGID, P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P " + (extReportJoin ? extReportJoinSql : "") + " INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON C1.FID=CR.FCENTERID  LEFT JOIN T_QING_CENTER C2 ON C2.FID=CR.FCENTERID1  LEFT JOIN T_QING_CENTER C3 ON C3.FID=CR.FCENTERID2  LEFT JOIN T_QING_CENTER C4 ON C4.FID=CR.FCENTERID3 \tWHERE P.FTYPE='1' AND P.FCREATORID=?  AND (P.FSOURCE IN( '" + this.getSourceCondition(sType) + "'))";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        if (CollectionUtils.isNotEmpty(roleIds)) {
            queryValue.addAll(roleIds);
        }
        queryValue.add(userId);
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        boolean isPresetManagePermission = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)this.context);
        if (!extReportJoin) {
            if (PublishSourceEnum.extreport.name().equals(sType) || PublishSourceEnum.all.name().equals(sType)) {
                if (isPresetManagePermission) {
                    sql = sql + " UNION  SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER c2 ON cr.FCENTERID1 = c2.FID  LEFT JOIN T_QING_CENTER c3 ON cr.FCENTERID2 = c3.FID  LEFT JOIN T_QING_CENTER c4 ON cr.FCENTERID3 = c4.FID  WHERE CR.FCREATORID = ? AND (P.FSOURCE = '" + PublishSourceEnum.extreport.name() + "')";
                    queryValue.add(IntegratedHelper.getPresetUserId());
                }
            } else if (isCurrentUserInQingAdminRole) {
                sql = sql + " UNION  SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER c2 ON cr.FCENTERID1 = c2.FID  LEFT JOIN T_QING_CENTER c3 ON cr.FCENTERID2 = c3.FID  LEFT JOIN T_QING_CENTER c4 ON cr.FCENTERID3 = c4.FID  WHERE CR.FCREATORID = ? AND (P.FSOURCE != '" + PublishSourceEnum.extreport.name() + "') AND (P.FSOURCE != '" + PublishSourceEnum.dashboard.name() + "')";
                queryValue.add(IntegratedHelper.getPresetUserId());
            }
        }
        if (PublishSourceEnum.extreport.name().equals(sType) && isPresetManagePermission && isPresetSnap) {
            sql = sql + " UNION  SELECT P.FID, P.FNAME ,P.FTAGID,P.FSOURCE, P.FCREATETIME, P.FCREATORID, P.FSCHEMAID, P.FPATH , C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1, C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,  C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3, C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_PUBLISH P INNER JOIN T_QING_CENTER_RELATION CR ON P.FPATH=CR.FID  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER c2 ON cr.FCENTERID1 = c2.FID  LEFT JOIN T_QING_CENTER c3 ON cr.FCENTERID2 = c3.FID  LEFT JOIN T_QING_CENTER c4 ON cr.FCENTERID3 = c4.FID  WHERE CR.FCREATORID = ? AND (P.FSOURCE = '" + PublishSourceEnum.extreport.name() + "')";
            queryValue.add(IntegratedHelper.getPresetUserId());
        }
        sql = sql + " ) T WHERE T.FID IS NOT NULL ORDER BY T.FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getSourceCondition(String sType) {
        String sourceCondition = PublishSourceEnum.subject.name() + "','" + PublishSourceEnum.bill.name() + "','" + PublishSourceEnum.control.name() + "','" + PublishSourceEnum.report.name();
        if (EXTREPORT.equals(sType)) {
            sourceCondition = PublishSourceEnum.extreport.name();
        } else if (ALL.equals(sType)) {
            sourceCondition = sourceCondition + "','" + PublishSourceEnum.extreport.name();
        }
        return sourceCondition;
    }

    private List<AbstractQingCenterVO> handleResult(ResultSet rs) throws SQLException {
        QingCenterMenuVO centerMenuvo = null;
        QingCenterGroupVO centerGroupvo = null;
        ArrayList<AbstractQingCenterVO> arrCenterGroup = new ArrayList<AbstractQingCenterVO>(10);
        while (rs.next()) {
            QingCenterGroupVO groupParent2;
            QingCenterGroupVO groupParent1;
            centerMenuvo = new QingCenterMenuVO();
            centerMenuvo.setId(rs.getString("FID"));
            centerMenuvo.setName(rs.getString("FNAME"));
            centerMenuvo.setTagId(rs.getString("FTAGID"));
            centerMenuvo.setSource(rs.getString("FSOURCE"));
            centerMenuvo.setSchemaId(rs.getString("FSCHEMAID"));
            centerMenuvo.setUserId(rs.getString("FCREATORID"));
            centerMenuvo.setParentId(rs.getString("FPATH"));
            centerMenuvo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
            centerMenuvo.setPublishTime(Long.valueOf(rs.getTimestamp("FCREATETIME").getTime()));
            String publishId = rs.getString("FID");
            String centerId1 = rs.getString("FCENTERID1");
            String centerId2 = rs.getString("FCENTERID2");
            String centerId3 = rs.getString("FCENTERID3");
            String centerId4 = rs.getString("FCENTERID4");
            String centerName1 = rs.getString("FCENTERNAME1");
            String centerName2 = rs.getString("FCENTERNAME2");
            String centerName3 = rs.getString("FCENTERNAME3");
            String centerName4 = rs.getString("FCENTERNAME4");
            centerMenuvo.setOrderPath(publishId);
            ArrayList<QingCenterMenuVO> childrens = new ArrayList<QingCenterMenuVO>();
            childrens.add(centerMenuvo);
            centerGroupvo = new QingCenterGroupVO();
            centerGroupvo.setLevelId1(centerId1);
            centerGroupvo.setLevelName1(centerName1);
            centerGroupvo.setLevelId2(centerId2);
            centerGroupvo.setLevelName2(centerName2);
            centerGroupvo.setLevelId3(centerId3);
            centerGroupvo.setLevelName3(centerName3);
            centerGroupvo.setLevelId4(centerId4);
            centerGroupvo.setLevelName4(centerName4);
            centerGroupvo.setRelationId(rs.getString("FPATH"));
            centerGroupvo.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
            if (StringUtils.isNotBlank((CharSequence)centerId4)) {
                centerGroupvo.setId(centerId4);
                centerGroupvo.setName(centerName4);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setParentId(centerId3);
                centerGroupvo.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3 + "/" + centerId4);
                groupParent1 = new QingCenterGroupVO();
                groupParent1.setLevelId1(centerId1);
                groupParent1.setLevelName1(centerName1);
                groupParent1.setId(centerId1);
                groupParent1.setName(centerName1);
                groupParent1.setOrderPath(centerId1);
                groupParent1.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                arrCenterGroup.add((AbstractQingCenterVO)groupParent1);
                groupParent2 = new QingCenterGroupVO();
                groupParent2.setLevelId1(centerId1);
                groupParent2.setLevelName1(centerName1);
                groupParent2.setLevelId2(centerId2);
                groupParent2.setLevelName2(centerName2);
                groupParent2.setId(centerId2);
                groupParent2.setName(centerName2);
                groupParent2.setParentId(centerId1);
                groupParent2.setOrderPath(centerId1 + "/" + centerId2);
                groupParent2.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                arrCenterGroup.add((AbstractQingCenterVO)groupParent2);
                QingCenterGroupVO groupParent3 = new QingCenterGroupVO();
                groupParent3.setLevelId1(centerId1);
                groupParent3.setLevelName1(centerName1);
                groupParent3.setLevelId2(centerId2);
                groupParent3.setLevelName2(centerName2);
                groupParent3.setLevelId3(centerId3);
                groupParent3.setLevelName3(centerName3);
                groupParent3.setId(centerId3);
                groupParent3.setName(centerName3);
                groupParent3.setParentId(centerId2);
                groupParent3.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                groupParent3.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3);
                arrCenterGroup.add((AbstractQingCenterVO)groupParent3);
            } else if (StringUtils.isNotBlank((CharSequence)centerId3)) {
                centerGroupvo.setId(centerId3);
                centerGroupvo.setName(centerName3);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setParentId(centerId2);
                centerGroupvo.setOrderPath(centerId1 + "/" + centerId2 + "/" + centerId3);
                groupParent1 = new QingCenterGroupVO();
                groupParent1.setLevelId1(centerId1);
                groupParent1.setLevelName1(centerName1);
                groupParent1.setId(centerId1);
                groupParent1.setName(centerName1);
                groupParent1.setOrderPath(centerId1);
                groupParent1.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                arrCenterGroup.add((AbstractQingCenterVO)groupParent1);
                groupParent2 = new QingCenterGroupVO();
                groupParent2.setLevelId1(centerId1);
                groupParent2.setLevelName1(centerName1);
                groupParent2.setLevelId2(centerId2);
                groupParent2.setLevelName2(centerName2);
                groupParent2.setId(centerId2);
                groupParent2.setName(centerName2);
                groupParent2.setParentId(centerId1);
                groupParent2.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                groupParent2.setOrderPath(centerId1 + "/" + centerId2);
                arrCenterGroup.add((AbstractQingCenterVO)groupParent2);
            } else if (StringUtils.isNotBlank((CharSequence)centerId2)) {
                centerGroupvo.setId(centerId2);
                centerGroupvo.setName(centerName2);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setParentId(centerId1);
                centerGroupvo.setOrderPath(centerId1 + "/" + centerId2);
                QingCenterGroupVO groupParent = new QingCenterGroupVO();
                groupParent.setLevelId1(centerId1);
                groupParent.setLevelName1(centerName1);
                groupParent.setId(centerId1);
                groupParent.setName(centerName1);
                groupParent.setPreset(IntegratedHelper.getPresetUserId().equals(rs.getString("FCREATORID")));
                groupParent.setOrderPath(centerId1);
                arrCenterGroup.add((AbstractQingCenterVO)groupParent);
            } else {
                centerGroupvo.setId(centerId1);
                centerGroupvo.setName(centerName1);
                centerGroupvo.setChildren(childrens);
                centerGroupvo.setOrderPath(centerId1);
            }
            arrCenterGroup.add((AbstractQingCenterVO)centerGroupvo);
        }
        return arrCenterGroup;
    }

    public List<PublishVO> loadPublishInfos(String pathId) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append(" SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH,").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, EXTRPT.FNAME AS EXTRPTNAME").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH=?").append(" ORDER BY P.FCREATETIME");
        Object[] params = new Object[]{"1", this.context.getUserId(), pathId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listVO;
    }

    public String getCatalogId(String userId, String catalogName) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT C.FID FROM T_QING_CENTER C, T_QING_CENTER_RELATION R  WHERE ((C.FID = R.FCENTERID) OR (C.FID = R.FCENTERID1) OR (C.FID = R.FCENTERID2) OR (C.FID = R.FCENTERID3) )  AND R.FCREATORID = ? AND C.FNAME = ?";
        return (String)this.dbExcuter.query(sql, new Object[]{userId, catalogName}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<String> getGroupNameByCenterGroupFid(String fid) throws AbstractQingIntegratedException, SQLException {
        String userId = this.context.getUserId();
        String selectCenterIdSQL = "SELECT FCENTERID, FCENTERID1, FCENTERID2, FCENTERID3 FROM T_QING_CENTER_RELATION WHERE FID = ? AND FCREATORID = ?";
        List centerIds = (List)this.dbExcuter.query(selectCenterIdSQL, new Object[]{fid, userId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        String selectNameSQL = "SELECT FNAME FROM T_QING_CENTER WHERE FID in (?)";
        String joinCenterIds = StringUtils.join((Collection)centerIds, (char)',');
        return (List)this.dbExcuter.query(selectNameSQL, new Object[]{joinCenterIds}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public QingCenterGroupVO getQingCerterCatalog(String fId) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FNAME FROM T_QING_CENTER WHERE FID = ?";
        return (QingCenterGroupVO)this.dbExcuter.query(sql, new Object[]{fId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String loadPublishId(String centerName1, String centerName2, String centerName3, String centerName4, String publishName, String userId, int type, String publishSource) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isBlank((CharSequence)centerName1)) {
            return null;
        }
        String sql = "SELECT PUB.FID FROM T_QING_PUBLISH PUB WHERE PUB.FNAME = ? AND PUB.FCREATORID=? AND PUB.FTYPE=? AND PUB.FPATH= ? AND PUB.FSOURCE != ?";
        String fpath = this.findPublishPathByNames(centerName1, centerName2, centerName3, centerName4, userId);
        ArrayList<String> params = new ArrayList<String>();
        params.add(publishName);
        params.add(userId);
        params.add(String.valueOf(type));
        params.add(fpath);
        params.add(publishSource);
        return (String)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String findPublishPathByNames(String centerName1, String centerName2, String centerName3, String centerName4, String userId) throws AbstractQingIntegratedException, SQLException {
        if (StringUtils.isBlank((CharSequence)centerName1)) {
            return null;
        }
        String sql = "SELECT FID FROM  T_QING_CENTER_RELATION CR WHERE FCREATORID=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(userId);
        ArrayList<String> groupNames = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)centerName4)) {
            groupNames.add(centerName1);
            groupNames.add(centerName2);
            groupNames.add(centerName3);
            groupNames.add(centerName4);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                String centerId2 = groupMap.get(centerName2);
                String centerId3 = groupMap.get(centerName3);
                String centerId4 = groupMap.get(centerName4);
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                params.add(centerId4);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=?";
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerName3)) {
            groupNames.add(centerName1);
            groupNames.add(centerName2);
            groupNames.add(centerName3);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                String centerId2 = groupMap.get(centerName2);
                String centerId3 = groupMap.get(centerName3);
                params.add(centerId1);
                params.add(centerId2);
                params.add(centerId3);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=? AND CR.FCENTERID3=' '";
            }
        } else if (StringUtils.isNotBlank((CharSequence)centerName2)) {
            groupNames.add(centerName1);
            groupNames.add(centerName2);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                String centerId2 = groupMap.get(centerName2);
                params.add(centerId1);
                params.add(centerId2);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=? AND CR.FCENTERID2=' '";
            }
        } else {
            groupNames.add(centerName1);
            Map<String, String> groupMap = this.findGroupIdByName(groupNames);
            if (groupMap != null) {
                String centerId1 = groupMap.get(centerName1);
                params.add(centerId1);
                sql = sql + " AND CR.FCENTERID=? AND CR.FCENTERID1=' '";
            }
        }
        return (String)this.dbExcuter.query(sql, params.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Map<String, String> findGroupIdByName(List<String> groupNames) throws AbstractQingIntegratedException, SQLException {
        if (groupNames == null || groupNames.size() == 0) {
            return null;
        }
        String sqlInName = "null";
        if (groupNames != null && groupNames.size() > 0) {
            StringBuilder sqlInNameBuilder = new StringBuilder();
            sqlInNameBuilder.append("?");
            for (int i = 1; i < groupNames.size(); ++i) {
                sqlInNameBuilder.append(",?");
            }
            sqlInName = sqlInNameBuilder.toString();
        }
        String sql = "SELECT FID, FNAME FROM T_QING_CENTER WHERE FNAME IN (" + sqlInName + ")";
        return (Map)this.dbExcuter.query(sql, groupNames.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<QingCenterGroupVO> loadCenterPresetGroups() throws AbstractQingIntegratedException, SQLException {
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        boolean isPresetManagePermission = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)QingContext.getCurrent());
        String dataTypeStr = "";
        String type = "";
        if (isPresetManagePermission && !isCurrentUserInQingAdminRole) {
            dataTypeStr = " AND (P.FSOURCE = ? or P.FSOURCE is NULL)";
            type = PublishSourceEnum.extreport.name();
        } else if (isCurrentUserInQingAdminRole && !isPresetManagePermission) {
            dataTypeStr = " AND P.FSOURCE != ? ";
            type = PublishSourceEnum.extreport.name();
        }
        String sql = " SELECT DISTINCT CR.FID AS FRELATIONID, C1.FID as FCENTERID1, C1.FNAME as FCENTERNAME1, C2.FID as FCENTERID2, C2.FNAME as FCENTERNAME2, C3.FID as FCENTERID3, C3.FNAME as FCENTERNAME3, C4.FID as FCENTERID4, C4.FNAME as FCENTERNAME4, CR.FCREATETIME FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  LEFT JOIN T_QING_PUBLISH P ON CR.FID = P.FPATH WHERE CR.FCREATORID = ?" + dataTypeStr + " ORDER BY CR.FCREATETIME ASC ";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(IntegratedHelper.getPresetUserId());
        if (!StringUtils.isEmpty((CharSequence)type)) {
            queryValue.add(type);
        }
        return (List)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PublishVO> loadPresetPublishInfos(String pathId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, QC.FNAME AS PATHTEXT, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, EXTRPT.FNAME AS EXTRPTNAME").append(" FROM T_QING_PUBLISH P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" LEFT JOIN T_QING_CENTER QC ON QC.FID = P.FPATH").append(" WHERE P.FTYPE=? AND P.FCREATORID=? AND P.FPATH=?").append(" ORDER BY P.FCREATETIME");
        Object[] params = new Object[]{"1", IntegratedHelper.getPresetUserId(), pathId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listVO;
    }

    public String findPublishNameByPath(String publishPath) throws AbstractQingIntegratedException, SQLException {
        String pathFullName = "";
        if (StringUtils.isNotBlank((CharSequence)publishPath)) {
            QingCenterGroupVO centerGroup = this.loadCenterGroupByPublishPath(publishPath);
            if (null == centerGroup) {
                return pathFullName;
            }
            if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName4())) {
                pathFullName = centerGroup.getLevelName1() + "/" + centerGroup.getLevelName2() + "/" + centerGroup.getLevelName3() + "/" + centerGroup.getLevelName4();
            } else if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName3())) {
                pathFullName = centerGroup.getLevelName1() + "/" + centerGroup.getLevelName2() + "/" + centerGroup.getLevelName3();
            } else if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName2())) {
                pathFullName = centerGroup.getLevelName1() + "/" + centerGroup.getLevelName2();
            } else if (StringUtils.isNotBlank((CharSequence)centerGroup.getLevelName1())) {
                pathFullName = centerGroup.getLevelName1();
            }
        }
        return pathFullName;
    }

    public QingCenterGroupVO loadCenterGroupByPublishPath(String path) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT CR.FID AS FRELATIONID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1 , C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3 , C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID WHERE CR.FID = ? ";
        return (QingCenterGroupVO)this.dbExcuter.query(sql, new Object[]{path}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, String> loadCenterGroupByPathBatch(Set<String> pathSet) throws AbstractQingIntegratedException, SQLException {
        StringBuilder paramBuilder = new StringBuilder();
        String sql = "SELECT CR.FID AS FRELATIONID, C1.FID AS FCENTERID1, C1.FNAME AS FCENTERNAME1 , C2.FID AS FCENTERID2, C2.FNAME AS FCENTERNAME2,C3.FID AS FCENTERID3, C3.FNAME AS FCENTERNAME3 , C4.FID AS FCENTERID4, C4.FNAME AS FCENTERNAME4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID WHERE CR.FID IN (";
        paramBuilder.append(sql);
        for (int i = 0; i < pathSet.size(); ++i) {
            paramBuilder.append("?,");
        }
        paramBuilder.deleteCharAt(paramBuilder.length() - 1);
        paramBuilder.append(")");
        return (Map)this.dbExcuter.query(paramBuilder.toString(), pathSet.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public PublishVO loadPublishInfo(String userId, String fid) throws AbstractQingIntegratedException, SQLException {
        String sql = " SELECT FNAME, FID, FTAGID, FTYPE, FPATH, FSOURCE, FCARRYDATA, FCREATETIME, FUPDATETIME, FTIME FROM T_QING_PUBLISH  WHERE FCREATORID=? AND FID=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(fid);
        PublishVO vo = (PublishVO)this.dbExcuter.query(sql, queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (vo == null) {
            return null;
        }
        QingCenterGroupVO qingCenterGroupVO = this.loadCenterGroupByPublishPath(vo.getPath());
        if (qingCenterGroupVO == null) {
            return vo;
        }
        String pathText = null;
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName1())) {
            pathText = qingCenterGroupVO.getLevelName1();
        }
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName2())) {
            pathText = pathText + "/" + qingCenterGroupVO.getLevelName2();
        }
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName3())) {
            pathText = pathText + "/" + qingCenterGroupVO.getLevelName3();
        }
        if (StringUtils.isNotBlank((CharSequence)qingCenterGroupVO.getLevelName4())) {
            pathText = pathText + "/" + qingCenterGroupVO.getLevelName4();
        }
        vo.setPathText(pathText);
        return vo;
    }

    public void deleteCenterGroupPublishOrder() throws AbstractQingIntegratedException, SQLException {
        String userid = this.context.getUserId();
        String sql = "DELETE T_QING_CENTER_PUBLISH_ORDER WHERE FCREATORID=?";
        this.dbExcuter.execute(sql, new Object[]{userid});
    }

    public void saveCenterGroupPublishOrder(List<String> arrCenterGroupId) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_CENTER_PUBLISH_ORDER(FID,FCREATORID,FPATH,FPATHINDEX) VALUES(?,?,?,?)";
        String userid = this.context.getUserId();
        int index = arrCenterGroupId.size();
        for (String centerGroup : arrCenterGroupId) {
            String sFID = this.dbExcuter.genStringId("T_QING_CENTER_PUBLISH_ORDER");
            Object[] params = new Object[]{sFID, userid, centerGroup, index};
            --index;
            this.dbExcuter.execute(sql, params);
        }
    }

    public Map<String, Integer> loadCenterGroupPublishOrder() throws AbstractQingIntegratedException, SQLException {
        String userid = this.context.getUserId();
        String sql = "SELECT CO.FPATH, CO.FPATHINDEX FROM T_QING_CENTER_PUBLISH_ORDER CO WHERE CO.FCREATORID = ? ";
        return (Map)this.dbExcuter.query(sql, new Object[]{userid}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteEmptyCenterGroupByUserId(String userId) throws AbstractQingIntegratedException, SQLException {
        String queryPublishCenterGroupsql = "SELECT DISTINCT CR.FID AS FRELATIONID, CR.FCENTERID AS FCENTERID1, CR.FCENTERID1 AS FCENTERID2, CR.FCENTERID2 AS FCENTERID3, CR.FCENTERID3 AS FCENTERID4 FROM T_QING_PUBLISH T JOIN  T_QING_CENTER_RELATION CR ON T.FPATH = CR.FID AND CR.FCREATORID = T.FCREATORID WHERE T.FCREATORID = ?";
        List publishedCenterGroups = (List)this.dbExcuter.query(queryPublishCenterGroupsql, new Object[]{userId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        String queryAllCenterGroupsql = "SELECT CR.FID AS FRELATIONID, CR.FCENTERID AS FCENTERID1, CR.FCENTERID1 AS FCENTERID2, CR.FCENTERID2 AS FCENTERID3, CR.FCENTERID3 AS FCENTERID4 FROM T_QING_CENTER_RELATION CR WHERE CR.FCREATORID = ?";
        List allCenterGroups = (List)this.dbExcuter.query(queryAllCenterGroupsql, new Object[]{userId}, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        HashSet<String> needKeepRelationIdSet = new HashSet<String>();
        for (QingCenterGroupVO sourceGroup : publishedCenterGroups) {
            for (QingCenterGroupVO targetGroup : allCenterGroups) {
                boolean bGroupNeedKeep = this.checkGroupNeedKeep(sourceGroup, targetGroup);
                if (!bGroupNeedKeep) continue;
                needKeepRelationIdSet.add(targetGroup.getRelationId());
            }
        }
        String sqlInFid = "null";
        if (needKeepRelationIdSet.size() > 0) {
            StringBuilder sqlInFidBuilder = new StringBuilder();
            sqlInFidBuilder.append("?");
            for (int i = 1; i < needKeepRelationIdSet.size(); ++i) {
                sqlInFidBuilder.append(",?");
            }
            sqlInFid = sqlInFidBuilder.toString();
        }
        String deleteEmptySql = "DELETE FROM T_QING_CENTER_RELATION WHERE FID NOT IN(" + sqlInFid + ") AND FCREATORID=? ";
        ArrayList<String> needKeppFidList = new ArrayList<String>(needKeepRelationIdSet);
        needKeppFidList.add(userId);
        this.dbExcuter.execute(deleteEmptySql, needKeppFidList.toArray());
    }

    private boolean checkGroupNeedKeep(QingCenterGroupVO sourceGroup, QingCenterGroupVO targetGroup) {
        return StringUtils.isNotBlank((CharSequence)targetGroup.getLevelId4()) ? targetGroup.getLevelId4().equals(sourceGroup.getLevelId4()) && targetGroup.getLevelId3().equals(sourceGroup.getLevelId3()) && targetGroup.getLevelId2().equals(sourceGroup.getLevelId2()) && targetGroup.getLevelId1().equals(sourceGroup.getLevelId1()) : (StringUtils.isNotBlank((CharSequence)targetGroup.getLevelId3()) ? targetGroup.getLevelId3().equals(sourceGroup.getLevelId3()) && targetGroup.getLevelId2().equals(sourceGroup.getLevelId2()) && targetGroup.getLevelId1().equals(sourceGroup.getLevelId1()) : (StringUtils.isNotBlank((CharSequence)targetGroup.getLevelId2()) ? targetGroup.getLevelId2().equals(sourceGroup.getLevelId2()) && targetGroup.getLevelId1().equals(sourceGroup.getLevelId1()) : targetGroup.getLevelId1().equals(sourceGroup.getLevelId1())));
    }

    public String saveCenterName1(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, null, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId1();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public String saveCenterName2(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, ADD_SUB, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId2();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public String saveCenterName3(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, ADD_SUB, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId3();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public String saveCenterName4(QingCenterGroupVO centerInfo, String userId) throws AbstractQingIntegratedException, SQLException {
        String categoryId = null;
        try {
            QingCenterGroupVO analysisCenterVO = this.saveCenterGroup(centerInfo, ADD_SUB, userId);
            centerInfo.setRelationId(analysisCenterVO.getRelationId());
            categoryId = analysisCenterVO.getLevelId4();
        }
        catch (ACFolderNameDuplicateException e) {
            categoryId = this.getCatalogId(userId, centerInfo.getName());
        }
        return categoryId;
    }

    public List<PublishVO> loadAllPresetPublishInfos(String presetUserId) throws AbstractQingIntegratedException, SQLException {
        Map<String, String> extRptGroupIdMapFullPath = this.getExtRptGroupIdMapFullPath(presetUserId);
        StringBuilder sqlSelect = new StringBuilder();
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        boolean isExtReportPresetManagePermission = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)QingContext.getCurrent());
        String dataFieldStr = "";
        String dataSourceStr = "";
        String dataTypeStr = "";
        if (isExtReportPresetManagePermission && !isCurrentUserInQingAdminRole) {
            dataFieldStr = " EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME, TQEG.FID AS EXTRPTGROUPID ";
            dataSourceStr = " LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID";
            dataTypeStr = " AND P1.FSOURCE = '" + PublishSourceEnum.extreport.name() + "'";
        } else if (isCurrentUserInQingAdminRole && !isExtReportPresetManagePermission) {
            dataFieldStr = " THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME";
            dataSourceStr = " LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID";
            dataTypeStr = " AND P1.FSOURCE != '" + PublishSourceEnum.extreport.name() + "'";
        } else {
            dataFieldStr = " THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME, TQEG.FID AS EXTRPTGROUPID ";
            dataSourceStr = " LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID";
        }
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, QC.FNAME AS PATHTEXT, P.FCREATETIME, P.FUPDATETIME,  ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA,").append(dataFieldStr).append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME, P1.FUPDATETIME,").append(" P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA ").append(" FROM T_QING_PUBLISH P1").append(" WHERE P1.FTYPE=? AND P1.FCREATORID=?").append(dataTypeStr).append(") P").append(dataSourceStr).append(" LEFT JOIN T_QING_CENTER QC ON QC.FID = P.FPATH").append(" ORDER BY P.FCREATETIME DESC");
        Object[] params = new Object[]{"1", presetUserId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listVO;
    }

    public List<PublishVO> loadAllPublishInfos(String userId) throws SQLException, AbstractQingIntegratedException {
        Map<String, String> extRptGroupIdMapFullPath = this.getExtRptGroupIdMapFullPath(userId);
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, P.FCREATETIME, P.FUPDATETIME, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME, TQEG.FID AS EXTRPTGROUPID ").append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME, P1.FUPDATETIME, ").append(" P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA FROM T_QING_PUBLISH P1").append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? ) P").append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID").append(" ORDER BY P.FCREATETIME DESC");
        Object[] params = new Object[]{"1", userId};
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listVO;
    }

    public String generateWhereClause(boolean isCurrentUserInQingAdminRole, boolean isExtReportPresetManagePermission, String currentType) {
        String whereClause = "";
        if (currentType == null) {
            whereClause = isCurrentUserInQingAdminRole && isExtReportPresetManagePermission ? "" : (isCurrentUserInQingAdminRole && !isExtReportPresetManagePermission ? "AND P.FSOURCE != 'extreport'" : "AND P.FSOURCE = 'extreport'");
        } else if ("dashboard".equals(currentType)) {
            whereClause = isCurrentUserInQingAdminRole ? "AND P.FSOURCE = 'dashboard'" : "AND 1=0";
        } else if (EXTREPORT.equals(currentType)) {
            whereClause = isExtReportPresetManagePermission ? "AND P.FSOURCE = 'extreport'" : "AND 1=0";
        } else if ("moduleLonger".equals(currentType)) {
            whereClause = isCurrentUserInQingAdminRole ? "AND (P.FSOURCE = 'bill' OR P.FSOURCE = 'subject')" : "AND 1=0";
        }
        return whereClause;
    }

    public Integer loadAllPresetPublishInfosByPaginationCount(String presetUserId, String pathId, String searchText, String currentType) throws AbstractQingIntegratedException, SQLException {
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        boolean isExtReportPresetManagePermission = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)QingContext.getCurrent());
        StringBuilder sqlStringBuilder = new StringBuilder();
        String selectClause = "SELECT COUNT(1) AS RPESETPUBLISHINFOCOUNT FROM T_QING_PUBLISH P WHERE P.FTYPE = ? AND P.FCREATORID = ? AND P.FPATH = ?";
        String whereClause = this.generateWhereClause(isCurrentUserInQingAdminRole, isExtReportPresetManagePermission, currentType);
        sqlStringBuilder.append(selectClause).append(whereClause);
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add("1");
        queryValue.add(presetUserId);
        queryValue.add(pathId);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sqlStringBuilder.append(" AND (UPPER(P.FNAME) LIKE ?)");
            queryValue.add("%" + searchText.toUpperCase() + "%");
        }
        return (Integer)this.dbExcuter.query(sqlStringBuilder.toString(), queryValue.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PublishVO> loadAllPresetPublishInfosByPagination(String presetUserId, String pathId, Integer pageSize, Integer offSet, String searchText, String currentType, String sortField, String sortOrder) throws SQLException, AbstractQingIntegratedException {
        Map<String, String> extRptGroupIdMapFullPath = this.getExtRptGroupIdMapFullPath(presetUserId);
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole();
        boolean isExtReportPresetManagePermission = IntegratedHelper.checkExtReportPresetManagePermission((QingContext)QingContext.getCurrent());
        String dataFieldStr = "";
        String dataSourceStr = "";
        if (isExtReportPresetManagePermission && !isCurrentUserInQingAdminRole) {
            dataFieldStr = " EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME, TQEG.FID AS EXTRPTGROUPID ";
            dataSourceStr = " LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID";
        } else if (isCurrentUserInQingAdminRole && !isExtReportPresetManagePermission) {
            dataFieldStr = " THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME";
            dataSourceStr = " LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID";
        } else {
            dataFieldStr = " THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME, TQEG.FID AS EXTRPTGROUPID ";
            dataSourceStr = " LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID";
        }
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT TOP %s,%s P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, P.FCREATETIME, P.FUPDATETIME, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, ").append(dataFieldStr).append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME, P1.FUPDATETIME, ").append(" P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA FROM T_QING_PUBLISH P1");
        String sql = sqlSelect.toString();
        String result = offSet == null || pageSize == null ? sql.replace("TOP %s,%s", "") : String.format(sql, pageSize, offSet);
        sqlSelect = new StringBuilder(result);
        if (currentType == null) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND (UPPER(P1.FNAME) LIKE ?)) P");
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=?) P");
            }
        } else if (currentType.equals("dashboard")) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'dashboard' AND (UPPER(P1.FNAME) LIKE ?)) P");
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'dashboard') P");
            }
        } else if (currentType.equals(EXTREPORT)) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'extreport' AND (UPPER(P1.FNAME) LIKE ?)) P");
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'extreport') P");
            }
        } else if (currentType.equals("moduleLonger")) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND (P1.FSOURCE = 'bill' OR P1.FSOURCE = 'subject') AND (UPPER(P1.FNAME) LIKE ?)) P");
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND (P1.FSOURCE = 'bill' OR P1.FSOURCE = 'subject')) P");
            }
        }
        if (sortField == null || sortOrder == null) {
            sortField = "createTime";
            sortOrder = "DESC";
        }
        String sqlSortFieldAndOrder = " ORDER BY " + (sortField.equals("createTime") ? "P.FCREATETIME " : "P.FNAME ") + (sortOrder.equalsIgnoreCase("DESC") ? "DESC" : "ASC");
        StringBuilder sqlSelectOfEnd = new StringBuilder(dataSourceStr).append(sqlSortFieldAndOrder);
        sqlSelect = sqlSelect.append((CharSequence)sqlSelectOfEnd);
        Integer n = searchText != null && searchText.length() > 0 ? 4 : 3;
        Object[] params = new Object[n.intValue()];
        params[0] = "1";
        params[1] = presetUserId;
        params[2] = pathId;
        if (searchText != null && searchText.length() > 0) {
            params[3] = "%" + searchText.toUpperCase() + "%";
        }
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listVO;
    }

    public Integer loadAllPublishInfosByPaginationCount(String userId, String pathId, String searchText, String currentType) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlStringBuilder = new StringBuilder();
        String selectClause = "SELECT COUNT(1) AS PUBLISHINFOCOUNT FROM T_QING_PUBLISH P WHERE P.FTYPE = ? AND P.FCREATORID = ? AND P.FPATH = ?";
        String whereClause = "";
        if (currentType == null) {
            whereClause = "";
        } else if (currentType.equals("dashboard")) {
            whereClause = "AND P.FSOURCE = 'dashboard'";
        } else if (currentType.equals(EXTREPORT)) {
            whereClause = "AND P.FSOURCE = 'extreport'";
        } else if (currentType.equals("moduleLonger")) {
            whereClause = "AND (P.FSOURCE = 'bill' OR P.FSOURCE = 'subject')";
        }
        sqlStringBuilder.append(selectClause).append(whereClause);
        Integer n = searchText != null && searchText.length() > 0 ? 4 : 3;
        Object[] params = new Object[n.intValue()];
        params[0] = "1";
        params[1] = userId;
        params[2] = pathId;
        if (searchText != null && searchText.length() > 0) {
            sqlStringBuilder.append(" AND (UPPER(P.FNAME) LIKE ?)");
            params[3] = "%" + searchText.toUpperCase() + "%";
        }
        return (Integer)this.dbExcuter.query(sqlStringBuilder.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PublishVO> loadAllPublishInfosByPagination(String userId, String pathId, Integer pageSize, Integer offSet, String searchText, String currentType, String sortField, String sortOrder) throws SQLException, AbstractQingIntegratedException {
        Map<String, String> extRptGroupIdMapFullPath = this.getExtRptGroupIdMapFullPath(userId);
        if (sortField == null || sortOrder == null) {
            sortField = "createTime";
            sortOrder = "DESC";
        }
        String sqlSortFieldAndOrder = " ORDER BY " + (sortField.equals("createTime") ? "P.FCREATETIME " : "P.FNAME ") + (sortOrder.equalsIgnoreCase("DESC") ? "DESC" : "ASC");
        StringBuilder sqlSelect = new StringBuilder();
        sqlSelect.append("SELECT TOP %s,%s P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, P.FCREATETIME, P.FUPDATETIME, ").append(" P.FSCHEMAID, P.FANALYSIS, P.FTAGID, P.FCARRYDATA, THEME.FNAME AS THEMENAME, TQTG.FNAME AS THEMEGROUPNAME, EXTRPT.FNAME AS EXTRPTNAME, TQEG.FNAME AS EXTRPTGROUPNAME, TQEG.FID AS EXTRPTGROUPID ").append(" FROM (SELECT P1.FID, P1.FTYPE, P1.FSOURCE, P1.FNAME, P1.FPATH, P1.FCREATETIME, P1.FUPDATETIME, ").append(" P1.FSCHEMAID, P1.FANALYSIS, P1.FTAGID, P1.FCARRYDATA FROM T_QING_PUBLISH P1");
        String sql = sqlSelect.toString();
        String result = offSet == null || pageSize == null || offSet <= 0 || pageSize <= 0 ? sql.replace("TOP %s,%s", "") : String.format(sql, pageSize, offSet);
        sqlSelect = new StringBuilder(result);
        StringBuilder sqlSelectOfEnd = new StringBuilder();
        sqlSelectOfEnd.append(" LEFT JOIN T_QING_THEME THEME ON THEME.FID = P.FTAGID").append(" LEFT JOIN T_QING_THEME_GROUP TQTG ON TQTG.FID = THEME.FTHEMEGROUPID").append(" LEFT JOIN T_QING_EXTRPT_INFO EXTRPT ON EXTRPT.FID = P.FTAGID").append(" LEFT JOIN T_QING_EXTRPT_GROUP TQEG ON TQEG.FID = EXTRPT.FGROUPID").append(sqlSortFieldAndOrder);
        if (currentType == null) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND (UPPER(P1.FNAME) LIKE ?)) P").append((CharSequence)sqlSelectOfEnd);
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=?) P").append((CharSequence)sqlSelectOfEnd);
            }
        } else if (currentType.equals("dashboard")) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'dashboard' AND (UPPER(P1.FNAME) LIKE ?)) P").append((CharSequence)sqlSelectOfEnd);
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'dashboard') P").append((CharSequence)sqlSelectOfEnd);
            }
        } else if (currentType.equals(EXTREPORT)) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'extreport' AND (UPPER(P1.FNAME) LIKE ?)) P").append((CharSequence)sqlSelectOfEnd);
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND P1.FSOURCE = 'extreport') P").append((CharSequence)sqlSelectOfEnd);
            }
        } else if (currentType.equals("moduleLonger")) {
            if (searchText != null && searchText.length() > 0) {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND (P1.FSOURCE = 'bill' OR P1.FSOURCE = 'subject') AND (UPPER(P1.FNAME) LIKE ?)) P").append((CharSequence)sqlSelectOfEnd);
            } else {
                sqlSelect.append(" WHERE P1.FTYPE=? AND P1.FCREATORID=? AND P1.FPATH=? AND (P1.FSOURCE = 'bill' OR P1.FSOURCE = 'subject')) P").append((CharSequence)sqlSelectOfEnd);
            }
        }
        Integer n = searchText != null && searchText.length() > 0 ? 4 : 3;
        Object[] params = new Object[n.intValue()];
        params[0] = "1";
        params[1] = userId;
        params[2] = pathId;
        if (searchText != null && searchText.length() > 0) {
            params[3] = "%" + searchText.toUpperCase() + "%";
        }
        List listVO = (List)this.dbExcuter.query(sqlSelect.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        return listVO;
    }

    private Map<String, String> getExtRptGroupIdMapFullPath(String userId) throws AbstractQingIntegratedException, SQLException {
        String SUB_QUERY = "SELECT FID FROM T_QING_EXTRPT_GROUP WHERE FCREATORID = ?";
        Object[] subParms = new Object[]{userId};
        List idS = (List)this.dbExcuter.query(SUB_QUERY, subParms, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty((Collection)idS)) {
            return new HashMap<String, String>(1);
        }
        String listParamStrInSQL = this.getListParamStrInSQL(idS);
        String QUERY_TABLE = " T_QING_EXTRPT_GROUP ";
        String pathDelimiter = "/";
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT G1.FID AS FID, G1.FNAME AS PARENT1, G2.FNAME AS PARENT2, G3.FNAME AS PARENT3, G4.FNAME AS PARENT4 ");
        buffer.append(" FROM ");
        buffer.append(QUERY_TABLE).append(" AS G1");
        buffer.append(" LEFT JOIN ");
        buffer.append(QUERY_TABLE).append(" AS G2").append(" ON G1.FPARENTID = G2.FID ");
        buffer.append(" LEFT JOIN ");
        buffer.append(QUERY_TABLE).append(" AS G3").append(" ON G2.FPARENTID = G3.FID ");
        buffer.append(" LEFT JOIN ");
        buffer.append(QUERY_TABLE).append(" AS G4").append(" ON G3.FPARENTID = G4.FID ");
        buffer.append(" WHERE G1.FID IN( ").append(listParamStrInSQL).append(" )");
        return (Map)this.dbExcuter.query(buffer.toString(), idS.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getListParamStrInSQL(List<String> paramList) {
        String sqlInParam = "null";
        if (paramList == null) {
            return sqlInParam;
        }
        StringBuilder sqlInParamBuilder = new StringBuilder();
        sqlInParamBuilder.append("?");
        for (int i = 1; i < paramList.size(); ++i) {
            sqlInParamBuilder.append(",?");
        }
        sqlInParam = sqlInParamBuilder.toString();
        return sqlInParam;
    }

    public Map<String, Integer> getHitNumberOfAllPath(String userId, String searchText, String currentType) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sqlStringBuilder = new StringBuilder();
        String selectClause = "SELECT P.FPATH, COUNT(1) AS COUNT FROM T_QING_PUBLISH P WHERE P.FTYPE = ? AND P.FCREATORID = ? AND UPPER(P.FNAME) LIKE ?";
        String whereClause = "";
        if (currentType == null) {
            whereClause = "GROUP BY P.FPATH";
        } else if (currentType.equals("dashboard")) {
            whereClause = "AND P.FSOURCE = 'dashboard' GROUP BY P.FPATH";
        } else if (currentType.equals(EXTREPORT)) {
            whereClause = "AND P.FSOURCE = 'extreport' GROUP BY P.FPATH";
        } else if (currentType.equals("moduleLonger")) {
            whereClause = "AND (P.FSOURCE = 'bill' OR P.FSOURCE = 'subject') GROUP BY P.FPATH";
        }
        sqlStringBuilder.append(selectClause).append(whereClause);
        Object[] params = new Object[]{"1", userId, "%" + searchText.toUpperCase() + "%"};
        return (Map)this.dbExcuter.query(sqlStringBuilder.toString(), params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, String> loadCenterGroupsByIds(Set<String> ids) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<String, String>(0);
        }
        StringBuilder sqlInIdsBuilder = new StringBuilder();
        sqlInIdsBuilder.append("?");
        for (int i = 1; i < ids.size(); ++i) {
            sqlInIdsBuilder.append(",?");
        }
        String sqlInParam = sqlInIdsBuilder.toString();
        String pathDelimiter = "/";
        String sql = " SELECT CR.FID AS FRELATIONID, C1.FID as FCENTERID1, C2.FID as FCENTERID2, C3.FID as FCENTERID3, C4.FID as FCENTERID4 FROM T_QING_CENTER_RELATION CR  LEFT JOIN T_QING_CENTER C1 ON CR.FCENTERID = C1.FID  LEFT JOIN T_QING_CENTER C2 ON CR.FCENTERID1 = C2.FID  LEFT JOIN T_QING_CENTER C3 ON CR.FCENTERID2 = C3.FID  LEFT JOIN T_QING_CENTER C4 ON CR.FCENTERID3 = C4.FID  WHERE CR.FID in (" + sqlInParam + ")";
        return (Map)this.dbExcuter.query(sql, ids.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Integer getPublishInfosCountByPath(List<String> pathIds, String searchText, String filterType) throws AbstractQingIntegratedException, SQLException {
        if (pathIds == null || pathIds.size() <= 0 || "SQUARE".equals(filterType)) {
            return 0;
        }
        String sql = "SELECT COUNT(1) AS PUBLISHCARD_COUNT FROM T_QING_PUBLISH P WHERE #1 #2 P.FTYPE = '1' ";
        sql = this.fixFilterType(sql, "#1", filterType);
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(pathIds.size());
        sql = sql.replace("#2", inSqlConditionBuilder.build("P.FPATH") + "AND");
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            pathIds.add("%" + searchText + "%");
            sql = sql + "AND P.FNAME LIKE ?";
        }
        return (Integer)this.dbExcuter.query(sql, pathIds.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<PublishVO> loadPublishInfosByPath(List<String> pathIds, String searchText, String filterType, Integer offset, Integer pageSize) throws SQLException, AbstractQingIntegratedException {
        if (pathIds == null || pathIds.size() <= 0 || "SQUARE".equals(filterType)) {
            return null;
        }
        String sql = "SELECT TOP %s,%s P.FID, P.FTYPE, P.FSOURCE, P.FNAME, P.FPATH, P.FTAGID, P.FCREATORID, P.FCREATETIME FROM T_QING_PUBLISH P WHERE #1 #2 P.FTYPE = '1' ";
        sql = offset == null || pageSize == null ? sql.replace("TOP %s,%s", "") : String.format(sql, pageSize, offset);
        sql = this.fixFilterType(sql, "#1", filterType);
        InSqlConditionBuilder inSqlConditionBuilder = new InSqlConditionBuilder(pathIds.size());
        sql = sql.replace("#2", inSqlConditionBuilder.build("P.FPATH") + "AND");
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            pathIds.add("%" + searchText + "%");
            sql = sql + "AND P.FNAME LIKE ? ";
        }
        sql = sql + "ORDER BY P.FCREATETIME DESC";
        return (List)this.dbExcuter.query(sql, pathIds.toArray(), (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Map<String, Integer> getPublishCountAggPath(String searchText, String filterType) throws AbstractQingIntegratedException, SQLException {
        if ("SQUARE".equals(filterType)) {
            return null;
        }
        Object[] params = null;
        String sql = "SELECT P.FPATH, COUNT(1) AS PUBLISH_COUNT FROM T_QING_PUBLISH P WHERE #1 #2 P.FTYPE = '1' GROUP BY P.FPATH";
        sql = this.fixFilterType(sql, "#1", filterType);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            sql = sql.replace("#2", " P.FNAME LIKE ? AND ");
            params = new Object[]{"%" + searchText + "%"};
        } else {
            sql = sql.replace("#2", "");
        }
        return (Map)this.dbExcuter.query(sql, params, (ResultHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fixUserNames(List<Long> userIds, List<PublishVO> publishVOs) throws SQLException {
        try {
            Map userAndNameMap = IntegratedHelper.getUserAndName(userIds);
            String presetUserId = IntegratedHelper.getPresetUserId();
            for (PublishVO publishVO : publishVOs) {
                Map UserNameMap = (Map)userAndNameMap.get(publishVO.getCreatorId());
                if (presetUserId.equals(publishVO.getCreatorId())) {
                    publishVO.setPreset(true);
                    publishVO.setCreatorName((String)UserNameMap.get("name"));
                    continue;
                }
                publishVO.setCreatorName(UserNameMap.get("name") + "(" + UserNameMap.get("username") + ")");
            }
        }
        catch (IntegratedRuntimeException e) {
            throw new SQLException(e);
        }
    }

    private String fixFilterType(String sql, String replaceChar, String filterType) {
        if ("ALL".equals(filterType)) {
            sql = sql.replace(replaceChar, "( P.FSOURCE = 'subject' OR P.FSOURCE = 'bill' OR P.FSOURCE = 'dashboard' ) AND ");
        } else if ("ANALYSIS".equals(filterType)) {
            sql = sql.replace(replaceChar, " ( P.FSOURCE = 'subject' OR P.FSOURCE = 'bill' ) AND ");
        } else if ("DASHBOARD".equals(filterType)) {
            sql = sql.replace(replaceChar, " P.FSOURCE = 'dashboard' AND ");
        }
        return sql;
    }

    static /* synthetic */ List access$000(AnalysisCenterDAO x0, ResultSet x1) throws SQLException {
        return x0.handleResult(x1);
    }

    static /* synthetic */ QingContext access$100(AnalysisCenterDAO x0) {
        return x0.context;
    }

    static /* synthetic */ void access$200(AnalysisCenterDAO x0, List x1, List x2) throws SQLException {
        x0.fixUserNames(x1, x2);
    }
}

