/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelExportUtil {
    public static final int NUM_PER_SHEET = 300000;
    public static final int NUM_BY_PAGES = 50000;
    private int writeDisk = 50000;
    private int MaxExcelColWidth = 65280;
    private List<String> tableHeads;
    private Map<String, String> headAndFieldMapping;
    private IQingFile exportFile;
    private OutputStream fos;
    private IQingFileWriter fileWriter;
    private SXSSFWorkbook wb;
    private CellStyle headCellStyle;
    private CellStyle contentCellStyle;
    private int sheetName;
    private int tableRowNum;
    private Long rowNum = 1L;
    private Map<Integer, Integer> maxWidth;
    private Pattern numPattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
    private static final Set<Character> FILTER_CHARS = new HashSet<Character>(8);

    public ExcelExportUtil(List<String> tableHeads, Map<String, String> headAndFieldMapping) {
        this.tableHeads = tableHeads;
        this.headAndFieldMapping = headAndFieldMapping;
    }

    public void buildExcelFile() throws IOException {
        this.exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        this.fileWriter = this.exportFile.createWriter();
        this.fos = this.fileWriter.getOutputStream();
        this.wb = new SXSSFWorkbook(this.writeDisk);
    }

    public Sheet buildExcelSheet() {
        SXSSFSheet sheet = this.wb.createSheet("Sheet" + ++this.sheetName);
        this.maxWidth = new HashMap<Integer, Integer>(this.tableHeads.size());
        this.insertHead((Sheet)sheet);
        return sheet;
    }

    private void insertHead(Sheet sheet) {
        if (this.headCellStyle == null) {
            this.headCellStyle = this.wb.createCellStyle();
            this.headCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            this.headCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
            this.headCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        this.tableRowNum = 0;
        Row row = sheet.createRow(this.tableRowNum++);
        for (int i = 0; i < this.tableHeads.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.headCellStyle);
            String cellValue = this.tableHeads.get(i);
            cell.setCellValue(cellValue);
            this.maxWidth.put(i, cellValue.getBytes().length * 256 + 200);
        }
    }

    public void insertExportData(List<Map<String, String>> objectMaps, Sheet sheet) {
        int i;
        if (this.contentCellStyle == null) {
            this.contentCellStyle = this.wb.createCellStyle();
            this.contentCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.contentCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        for (i = 0; i < objectMaps.size(); ++i) {
            Map<String, String> objectMap = objectMaps.get(i);
            Row row = sheet.createRow(this.tableRowNum++);
            row.setHeightInPoints(20.0f);
            for (int j = 0; j < this.tableHeads.size(); ++j) {
                String key = this.headAndFieldMapping.get(this.tableHeads.get(j));
                String value = null;
                if (this.tableHeads.get(j).equals("#") && objectMap.get(key) == null) {
                    Long l = this.rowNum;
                    Long l2 = this.rowNum = Long.valueOf(this.rowNum + 1L);
                    value = String.valueOf(l);
                } else {
                    value = objectMap.get(key) == null ? "" : objectMap.get(key);
                }
                Cell cell = row.createCell(j);
                cell.setCellStyle(this.contentCellStyle);
                boolean isNum = this.numPattern.matcher(value).matches();
                if (isNum) {
                    cell.setCellValue(Double.parseDouble(value));
                } else {
                    cell.setCellValue(value);
                }
                int maxColWidth = Math.max(value.getBytes().length * 256 + 200, this.maxWidth.get(j));
                this.maxWidth.put(j, Math.min(maxColWidth, this.MaxExcelColWidth));
            }
        }
        for (i = 0; i < this.tableHeads.size(); ++i) {
            sheet.setColumnWidth(i, this.maxWidth.get(i).intValue());
        }
    }

    public String finish() throws IOException {
        this.wb.write(this.fos);
        return this.exportFile.getName();
    }

    public void close(Exception e) {
        this.wb.dispose();
        CloseUtil.close((Closeable[])new Closeable[]{this.wb, this.fos});
        if (this.fileWriter != null) {
            this.fileWriter.close(e);
        }
    }

    public static String filterExcelInjection(String value) {
        int startIndex;
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        String strValue = value.trim();
        int length = strValue.length();
        for (startIndex = 0; startIndex < length && FILTER_CHARS.contains(Character.valueOf(strValue.charAt(startIndex))); ++startIndex) {
        }
        return startIndex == 0 ? strValue : strValue.substring(startIndex);
    }

    static {
        FILTER_CHARS.add(Character.valueOf('='));
        FILTER_CHARS.add(Character.valueOf('+'));
        FILTER_CHARS.add(Character.valueOf('-'));
        FILTER_CHARS.add(Character.valueOf('@'));
    }
}

