/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.qing.customservice;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.strategy.publishmenu.IPublishMenuStrategy;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.mservice.qing.publish.appmenu.domain.AppMenuManageDomain;
import kd.bos.mservice.qing.publish.appmenu.model.AbstractPublishAppMenuNode;
import kd.bos.mservice.qing.publish.appmenu.model.PublishAppMenuFolderNode;

public class PublishAppMenuStrategyImpl
implements IPublishMenuStrategy {
    public String getId() {
        return IPublishMenuStrategy.class.getName();
    }

    public void buildMenuPath(List<FileResourceVO> list, String userId, QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) throws Exception {
        PublishAppMenuFolderNode rootNode = this.getPublishManageDomain(qingContext, tx, dbExcuter).getAppMenuTree(userId, false);
        for (FileResourceVO fileResourceVO : list) {
            if (!"0".equals(fileResourceVO.getFromTargetType())) continue;
            Map map = (Map)JsonUtil.decodeFromString((String)fileResourceVO.getFromPath(), Map.class);
            String appMenuPathName = this.getAppMenuPathName(rootNode, map);
            fileResourceVO.setFromPathName(appMenuPathName);
        }
    }

    private String getAppMenuPathName(PublishAppMenuFolderNode rootNode, Map<String, String> pathMap) {
        HashMap<String, String> resultPathMap = new HashMap<String, String>();
        this.recursion(rootNode.getChildren(), resultPathMap, pathMap);
        String sFullPathName = "";
        if (!resultPathMap.isEmpty()) {
            String sAppMenuName2 = resultPathMap.get("appMenuName2");
            String sAppMenuName = resultPathMap.get("appMenuName");
            String sAppName = resultPathMap.get("appName");
            String sCloudName = resultPathMap.get("cloudName");
            if (StringUtils.isNotBlank((CharSequence)sAppMenuName2)) {
                sFullPathName = sCloudName + "/" + sAppName + "/" + sAppMenuName + "/" + sAppMenuName2;
            } else if (StringUtils.isNotBlank((CharSequence)sAppMenuName)) {
                sFullPathName = sCloudName + "/" + sAppName + "/" + sAppMenuName;
            } else if (StringUtils.isNotBlank((CharSequence)sAppName)) {
                sFullPathName = sCloudName + "/" + sAppName;
            } else if (StringUtils.isNotBlank((CharSequence)sCloudName)) {
                sFullPathName = sCloudName;
            }
        }
        return sFullPathName;
    }

    private void recursion(List<AbstractPublishAppMenuNode> children, Map<String, String> resultPathMap, Map<String, String> pathMap) {
        if (children == null || children.size() == 0) {
            return;
        }
        for (AbstractPublishAppMenuNode node : children) {
            if (StringUtils.isNotBlank((CharSequence)node.getAppMenuId2())) {
                if (!node.getAppMenuId2().equals(pathMap.get("appMenuId2"))) continue;
                resultPathMap.put("appMenuName2", node.getDisplayName());
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)node.getAppMenuId())) {
                if (!node.getAppMenuId().equals(pathMap.get("appMenuId"))) continue;
                resultPathMap.put("appMenuName", node.getDisplayName());
            } else if (StringUtils.isNotBlank((CharSequence)node.getAppId())) {
                if (!node.getAppId().equals(pathMap.get("appId"))) continue;
                resultPathMap.put("appName", node.getDisplayName());
            } else {
                if (!StringUtils.isNotBlank((CharSequence)node.getCloudId()) || !node.getCloudId().equals(pathMap.get("cloudId"))) continue;
                resultPathMap.put("cloudName", node.getDisplayName());
            }
            if (!(node instanceof PublishAppMenuFolderNode)) continue;
            this.recursion(((PublishAppMenuFolderNode)node).getChildren(), resultPathMap, pathMap);
        }
    }

    private AppMenuManageDomain getPublishManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        return new AppMenuManageDomain(qingContext, tx, dbExcuter, null);
    }

    public String appendMenuPath(String originSql, String path, List<Object> appendParams) {
        StringBuilder sqlBuilder = new StringBuilder(originSql);
        Map map = (Map)JsonUtil.decodeFromString((String)path, Map.class);
        Object appMenuId = map.get("appMenuId");
        if (appMenuId != null) {
            sqlBuilder.append(" AND FPATH like ? ");
            appendParams.add("%%\"appMenuId\":\"" + appMenuId + "\"%%");
        } else {
            sqlBuilder.append(" AND FPATH=?");
            appendParams.add(path);
        }
        return sqlBuilder.toString();
    }
}

