/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.db;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.handler.impl.ColumnToRowDataHandler;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.IDataSourceIterator;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBTableCreator;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.domain.source.db.IDBConnectionSupporter;
import com.kingdee.bos.qing.data.domain.source.db.IStoredProcedure;
import com.kingdee.bos.qing.data.domain.source.db.JDBCDataSourceIterator;
import com.kingdee.bos.qing.data.domain.source.db.dataconvert.IResultSetDataConvertor;
import com.kingdee.bos.qing.data.domain.source.db.impl.CommonDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.impl.FlyDBSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.impl.KylinSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.impl.MySQLSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.impl.OpenLookengSourceDomain;
import com.kingdee.bos.qing.data.domain.source.db.util.SQLHelper;
import com.kingdee.bos.qing.data.exception.AbstractDBSourceException;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.AbstractDBConnectException;
import com.kingdee.bos.qing.data.exception.db.DBExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLTranslateException;
import com.kingdee.bos.qing.data.exception.db.DBSQLMacroConnNoExistException;
import com.kingdee.bos.qing.data.exception.db.DBSQLMacroExecuteException;
import com.kingdee.bos.qing.data.exception.db.SuperQueryMissPhysicalTableException;
import com.kingdee.bos.qing.data.exception.db.SuperQueryMissTableException;
import com.kingdee.bos.qing.data.exception.db.SuperQueryNoSchemaPermException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.exception.macro.DBCenterMacroUnAvailableException;
import com.kingdee.bos.qing.data.exception.macro.MacroNoFoundEntityException;
import com.kingdee.bos.qing.data.exception.macro.MacroNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedure;
import com.kingdee.bos.qing.data.model.designtime.StoredProcedureParameter;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.runtime.db.DBCompareFilter;
import com.kingdee.bos.qing.data.model.runtime.db.DBLogicalFilter;
import com.kingdee.bos.qing.data.model.runtime.db.IDBRuntimeFilter;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class AbstractDBSourceDomain
extends AbstractDataSourceDomain
implements IDBConnectionSupporter,
IStoredProcedure {
    private static String COUNTSQLTEMPLATE = "select count(1) from ( %s ) T";
    protected AbstractDBSourceJDBCAdapter jdbcAdapter;
    protected static final String KSQL_QING_THEME = "/*qing-%s-%s*/";
    private static final String CHECK_DATA_FIELD_UNIQUE_SQL = "select t1.a from ( select count(1) as a from %s ) t1 INNER JOIN (select count(0) as a from ( select DISTINCT %s from %s) t) t2 on t1.a =t2.a";

    public static AbstractDBSourceDomain newInstance(AbstractSource source) throws UnSupportDataSourceException {
        AbstractDBSourceJDBCAdapter jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance((AbstractSource)source);
        DBSource dataBase = (DBSource)source;
        DBSource.DBType dbType = dataBase.getDbType();
        if (DBSource.DBType.MYSQL == dbType) {
            return new MySQLSourceDomain(jdbcAdapter);
        }
        if (DBSource.DBType.KYLIN == dbType) {
            return new KylinSourceDomain(jdbcAdapter);
        }
        if (DBSource.DBType.OPENLOOKENG == dbType) {
            return new OpenLookengSourceDomain(jdbcAdapter);
        }
        if (DBSource.DBType.FLYDB == dbType) {
            return new FlyDBSourceDomain(jdbcAdapter);
        }
        return new CommonDBSourceDomain(jdbcAdapter);
    }

    public void setDBSource(AbstractSource source) {
    }

    @Override
    public void initEntityTitle(QingContext qingContext, Entity entity, AbstractSource source) {
        DBSource dbSource;
        if (source instanceof DBSource && (dbSource = (DBSource)source).getUserSqls() != null && dbSource.getUserSqls().isEmpty() && dbSource.getStoredProcedures() != null && dbSource.getStoredProcedures().isEmpty()) {
            String title = Messages.getMLS((II18nContext)qingContext.getIi18nContext(), (String)"initialName", (String)"\u521d\u59cb\u540d\u79f0", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
            entity.setTitle(title + ":" + entity.getAssociateName());
        }
    }

    @Override
    public void checkSourceLegality(QingContext qingContext, AbstractSource source, List<Entity> entityArrayList, AbstractDataSourceDomain domain) {
        block8: {
            try {
                if (source instanceof DBSource) {
                    this.jdbcAdapter.checkConnection(qingContext, source);
                } else if (source instanceof IFileSavable) {
                    String tempFilePathName = ((IFileSavable)source).getFileUrl();
                    IQingFileVisitor file = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_DS, (String)tempFilePathName);
                    if (file.exists()) {
                        this.jdbcAdapter.checkConnection(qingContext, source);
                    } else if (entityArrayList != null && !entityArrayList.isEmpty()) {
                        this.setEntityErrorState(qingContext, entityArrayList, EntityErrorState.FILENOTEXIST);
                    }
                }
            }
            catch (AbstractDBConnectException e) {
                if (entityArrayList.isEmpty()) break block8;
                this.setEntityErrorState(qingContext, entityArrayList, EntityErrorState.DB_CONNECT_FAILED);
            }
        }
    }

    @Override
    public void checkEntityPermission(QingContext qingContext, Entity entity, AbstractSource source) throws NoEntityPermissionException {
        ArrayList<Entity> errorEntityList = new ArrayList<Entity>(1);
        Throwable exception = null;
        EntityErrorState entityErrorState = null;
        try {
            this.checkDBSourceMacroValPermission(qingContext, source, entity);
        }
        catch (MacroNoFoundEntityException e) {
            entityErrorState = EntityErrorState.MACRO_NO_FOUND_ENTITY;
            exception = e;
            errorEntityList.add(entity);
        }
        catch (DBSQLMacroConnNoExistException e) {
            entityErrorState = EntityErrorState.MACRO_VAL_CONN_NO_EXIST;
            exception = e;
            errorEntityList.add(entity);
        }
        catch (DBSQLMacroExecuteException e) {
            entityErrorState = EntityErrorState.MACRO_VAL_NO_PERMISSION;
            exception = e;
            errorEntityList.add(entity);
        }
        catch (DBCenterMacroUnAvailableException e) {
            entityErrorState = EntityErrorState.DB_CENTER_MACRO_UNAVAILABLE;
            exception = e;
            errorEntityList.add(entity);
        }
        catch (AbstractMacroException e) {
            LogUtil.error((Throwable)e);
        }
        if (errorEntityList.size() > 0) {
            this.setEntityErrorState(qingContext, errorEntityList, entityErrorState, (AbstractMacroException)exception);
        }
    }

    public void checkDBSourceMacroValPermission(QingContext qingContext, AbstractSource source, Entity entity) throws AbstractMacroException {
        List<String> macroIds = this.parseSqlOutMacroVals(source, entity.getName());
        if (macroIds.size() > 0) {
            try {
                this.jdbcAdapter.checkEntityMacroValPermission(qingContext, macroIds);
            }
            catch (MacroNoFoundEntityException e) {
                e.putExceptionMassageMap("sqlType", this.parseOutSqlType(source, entity));
                throw e;
            }
            catch (DBSQLMacroConnNoExistException e) {
                e.putExceptionMassageMap("sqlType", this.parseOutSqlType(source, entity));
                throw e;
            }
            catch (DBSQLMacroExecuteException e) {
                e.putExceptionMassageMap("sqlType", this.parseOutSqlType(source, entity));
                throw e;
            }
            catch (DBCenterMacroUnAvailableException e) {
                throw e;
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String parseOutSqlType(AbstractSource source, Entity entity) {
        String associateName = entity.getAssociateName();
        DBSource dbSource = (DBSource)source;
        DBSource.UserSQL userSQL = dbSource.getUserSql(associateName);
        return userSQL.getSqlType();
    }

    public AbstractDBSourceDomain(AbstractDBSourceJDBCAdapter jdbcAdapter) {
        this.jdbcAdapter = jdbcAdapter;
    }

    public AbstractDBSourceJDBCAdapter getJdbcAdapter() {
        return this.jdbcAdapter;
    }

    @Override
    public Map<String, String> getUsableSchemas(QingContext qingContext, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        DBSource dbSource = (DBSource)source;
        return this.jdbcAdapter.getUsableSchemas(qingContext, dbSource);
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        return this.jdbcAdapter.getUsableEntities(qingContext, source);
    }

    public boolean checkConnection(QingContext context, AbstractSource source) throws AbstractDBConnectException {
        return this.jdbcAdapter.checkConnection(context, source);
    }

    public AbstractNode getStoredProcedures(QingContext qingContext, AbstractSource source) throws AbstractSourceException {
        return this.jdbcAdapter.getStoredProcedures(qingContext, source);
    }

    public List<StoredProcedureParameter> getStoredProcedureParameters(QingContext qingContext, AbstractSource source, String storedProcedureName) throws AbstractSourceException {
        return this.jdbcAdapter.getStoredProcedureParameters(qingContext, source, storedProcedureName);
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String associateName) throws AbstractDBSourceException, AbstractMacroException {
        Table table;
        DBSource dataBase = (DBSource)source;
        AbstractDBTableCreator dbTable = this.jdbcAdapter.createDBTableCreator(dataBase, associateName);
        try {
            table = dbTable.getTablePeer(qingContext);
        }
        catch (AbstractMacroException e) {
            if (e instanceof MacroNotFoundException) {
                e.putExceptionMassageMap("sqlType", dataBase.getUserSql(associateName).getSqlType());
            }
            throw e;
        }
        return DesigntimeDataObject.createSingleDataObject((Entity)Entity.fromTable((Table)table));
    }

    public final void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.jdbcAdapter.setConnectionFactory(connectionFactory);
    }

    public final IConnectionFactory getConnectionFactory() {
        return this.jdbcAdapter.getConnectionFactory();
    }

    @Override
    public RuntimeFilterUtil.Prediction initRuntimeFilter(RuntimeEntity runtimeEntity) {
        RuntimeFilterUtil.Prediction prediction = new RuntimeFilterUtil.Prediction();
        runtimeEntity.initFilter(DBCompareFilter.class, DBLogicalFilter.class, prediction);
        return prediction;
    }

    public DBRuntimeInfo initDBRuntimeParams(QingContext qingContext, RuntimeEntity runtimeEntity, boolean isGetDataCount) throws AbstractDBSourceException, AbstractMacroException {
        String sql;
        DBRuntimeInfo dbRuntimeInfo = new DBRuntimeInfo();
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (dbRuntimeInfo.isAlwaysFalse) {
            return dbRuntimeInfo;
        }
        IDBRuntimeFilter runtimeFilter = (IDBRuntimeFilter)runtimeEntity.getPushdownableFilter();
        dbRuntimeInfo.isAlwaysFalse = prediction.isAlwaysFalse();
        dbRuntimeInfo.runtimeFilter = runtimeFilter;
        if (runtimeFilter != null) {
            ArrayList params = new ArrayList();
            runtimeFilter.collectParamValue(params);
            dbRuntimeInfo.params = params.toArray();
            dbRuntimeInfo.isParamSizeTooLong = AbstractDBSourceDomain.isParamSizeTooLong(dbRuntimeInfo);
        }
        dbRuntimeInfo.sql = sql = this.makeSqlAndCollectParam(qingContext, runtimeEntity, dbRuntimeInfo, isGetDataCount);
        return dbRuntimeInfo;
    }

    public String makeSqlAndCollectParam(QingContext qingContext, RuntimeEntity runtimeEntity, DBRuntimeInfo runtimeParams, boolean isGetDataCount) throws DBKSQLTranslateException, AbstractMacroException, DBKSQLNotSupportException {
        StringBuilder sql = new StringBuilder();
        String tableAssociateName = runtimeEntity.getAssociateName();
        DBSource dbSource = (DBSource)runtimeEntity.getSource();
        DBSource.UserSQL userSQL = dbSource.getUserSql(tableAssociateName);
        if (userSQL != null) {
            tableAssociateName = "T";
        }
        boolean isExistsUnionColToRow = false;
        if (runtimeEntity.getEntityExtractContext() != null) {
            isExistsUnionColToRow = CollectionUtils.isNotEmpty((Collection)runtimeEntity.getEntityExtractContext().getColumnToRowProperties());
        }
        if (!isGetDataCount || isGetDataCount && runtimeEntity.getUnPushdownableFilter() != null || isExistsUnionColToRow || CollectionUtils.isNotEmpty((Collection)runtimeEntity.getOrinalEntity().getColumnToRowProperties())) {
            ArrayList<String> columnToRowPropertyNameList = new ArrayList<String>(6);
            List columnToRowProperties = runtimeEntity.getOrinalEntity().getColumnToRowProperties();
            if (CollectionUtils.isNotEmpty((Collection)columnToRowProperties)) {
                for (Object columnToRowProperty : columnToRowProperties) {
                    columnToRowPropertyNameList.add(columnToRowProperty.getFieldNameProperty().getName());
                    columnToRowPropertyNameList.addAll(columnToRowProperty.getFieldValueNames());
                }
            }
            ArrayList<String> tableColumnAssociateNames = new ArrayList<String>(runtimeEntity.getSelectedPriProperties().size());
            for (RuntimeProperty property : runtimeEntity.getSelectedPriProperties()) {
                if (columnToRowPropertyNameList.contains(property.getProperty().getRelatedBaseProperty()) || property.getProperty().isNotExisted()) continue;
                String tableColumnAssociateName = property.getAssociateName();
                tableColumnAssociateNames.add(tableColumnAssociateName);
            }
            if (tableColumnAssociateNames.size() > 0) {
                for (String columnAssociateName : tableColumnAssociateNames) {
                    if (sql.length() > 0) {
                        sql.append(", ");
                    }
                    sql.append(this.jdbcAdapter.getLeftDelimiter());
                    sql.append(tableAssociateName);
                    sql.append(this.jdbcAdapter.getRightDelimiter());
                    sql.append(".");
                    sql.append(this.jdbcAdapter.getLeftDelimiter());
                    sql.append(columnAssociateName);
                    sql.append(this.jdbcAdapter.getRightDelimiter());
                }
            } else {
                sql.append(this.jdbcAdapter.getLeftDelimiter());
                sql.append(tableAssociateName);
                sql.append(this.jdbcAdapter.getRightDelimiter());
                sql.append(".* ");
            }
            if (this.jdbcAdapter.supportHint()) {
                String hintSelectPrefix = "SELECT /*+USER_CUSTOM*/ ";
                sql.insert(0, hintSelectPrefix);
            } else {
                sql.insert(0, "select ");
            }
            sql.append(" from ");
        } else {
            boolean runForGetDataCount;
            boolean bl = runForGetDataCount = (runtimeParams.runtimeFilter == null || AbstractDBSourceDomain.isCanFilterInDB(runtimeParams)) && runtimeEntity.getUnPushdownableFilter() == null;
            if (runForGetDataCount) {
                sql.append("select count(1) from ");
            } else {
                List items = runtimeEntity.getOrinalEntity().getFilters();
                for (int i = 0; i < items.size(); ++i) {
                    if (sql.length() > 0) {
                        sql.append(", ");
                    }
                    FilterItem item = (FilterItem)items.get(i);
                    sql.append(this.jdbcAdapter.getLeftDelimiter());
                    sql.append(tableAssociateName);
                    sql.append(this.jdbcAdapter.getRightDelimiter());
                    sql.append(".");
                    sql.append(this.jdbcAdapter.getLeftDelimiter());
                    sql.append(item.getProprety());
                    sql.append(this.jdbcAdapter.getRightDelimiter());
                }
                sql.insert(0, "select ");
                sql.append(" from ");
            }
        }
        boolean isConnSupportKsql = this.jdbcAdapter.isConnSupportKsql();
        if (userSQL != null) {
            sql.append('(');
            SQLHelper.RuntimeUserSQL runtimeUserSQL = SQLHelper.processUserSQL((DBSource.UserSQL)userSQL, (DBSource.DBType)dbSource.getDbType(), (QingContext)qingContext);
            String dbSQL = runtimeUserSQL.getSQL();
            runtimeParams.setUserSQLParams(runtimeUserSQL.getParam());
            sql.append(dbSQL);
            sql.append(") ");
            sql.append(this.jdbcAdapter.getLeftDelimiter());
            sql.append(tableAssociateName);
            sql.append(this.jdbcAdapter.getRightDelimiter());
        } else {
            sql.append(this.jdbcAdapter.getLeftDelimiter());
            sql.append(this.jdbcAdapter.wrapTableAssociateName(dbSource, tableAssociateName));
            sql.append(this.jdbcAdapter.getRightDelimiter());
        }
        if (AbstractDBSourceDomain.isCanFilterInDB(runtimeParams)) {
            sql.append(" where ");
            sql.append(runtimeParams.runtimeFilter.toSqlWhere(this.jdbcAdapter.getLeftDelimiter(), this.jdbcAdapter.getRightDelimiter()));
        }
        if (isConnSupportKsql) {
            if (runtimeEntity.getEntityExtractContext() != null && runtimeEntity.getEntityExtractContext().getThemeId() != null) {
                sql.insert(0, String.format(KSQL_QING_THEME, qingContext.getAccountId(), runtimeEntity.getEntityExtractContext().getThemeId()));
            } else {
                sql.insert(0, "/*qing*/");
            }
            sql.insert(0, "/*dialect*/");
        }
        return sql.toString();
    }

    public static boolean isParamSizeTooLong(DBRuntimeInfo runtimeParams) {
        return runtimeParams.params != null && runtimeParams.params.length > SQLHelper.getMaxParamSize();
    }

    static boolean isRuntimeFilterValid(IDBRuntimeFilter runtimeFilter) {
        return runtimeFilter != null && !runtimeFilter.isInvalid();
    }

    static Map<String, Object> filterRow(Map<String, Object> primaryRowData, RuntimeEntity runtimeEntity) {
        IDBRuntimeFilter runtimeFilter = (IDBRuntimeFilter)runtimeEntity.getPushdownableFilter();
        if (runtimeFilter != null && runtimeFilter.innerExcuteFilterWtihRawValue(primaryRowData) || runtimeFilter == null) {
            return AbstractDataSourceDomain.getRowDataAfterCalculateAndFilter(primaryRowData, runtimeEntity);
        }
        return null;
    }

    @Override
    public PreviewDataModel getPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractDBSourceException, AbstractMacroException {
        DBSource dbSource = (DBSource)runtimeEntity.getSource();
        StoredProcedure storedProce = dbSource.getStoredProcedure(runtimeEntity.getAssociateName());
        if (storedProce != null) {
            return this.previewDataStoredProcedure(runtimeEntity, dbSource, storedProce, rows);
        }
        return this.previewDataGeneral(qingContext, runtimeEntity, rows);
    }

    private PreviewDataModel previewDataStoredProcedure(RuntimeEntity runtimeEntity, DBSource dbSource, StoredProcedure storedProce, int rows) throws AbstractDBSourceException {
        StoredProcedureExec storedProcedureExec = new StoredProcedureExec(runtimeEntity, dbSource, storedProce);
        List<Object[]> result = storedProcedureExec.getPreviewData(rows);
        return new PreviewDataModel(result);
    }

    protected String preHandlePreviewSql(DBRuntimeInfo dbRuntimeInfo, RuntimeEntity runtimeEntity, int rows) {
        return dbRuntimeInfo.sql;
    }

    protected void setRuntimeParams(PreparedStatement ps, int parameterIndex, Object param) throws SQLException {
        SQLHelper.setParams((PreparedStatement)ps, (int)parameterIndex, (Object)param);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PreviewDataModel previewDataGeneral(QingContext qingContext, RuntimeEntity runtimeEntity, int rows) throws AbstractDBSourceException, AbstractMacroException {
        DBSource dataBase = (DBSource)runtimeEntity.getSource();
        DBRuntimeInfo runtimeParams = this.initDBRuntimeParams(qingContext, runtimeEntity, false);
        if (runtimeParams.isAlwaysFalse) {
            return new PreviewDataModel(new ArrayList());
        }
        String sql = this.preHandlePreviewSql(runtimeParams, runtimeEntity, rows);
        sql = this.jdbcAdapter.appendWhereClause(sql);
        Object[] params = runtimeParams.params;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        try {
            int i;
            int size;
            conn = this.jdbcAdapter.getConnection(dataBase);
            ps = conn.prepareStatement(sql);
            this.jdbcAdapter.setQueryTimeout(qingContext, ps);
            ps.setFetchSize(100);
            int parameterIndex = 1;
            List<Object> userSQLParams = runtimeParams.getUserSQLParams();
            if (userSQLParams != null) {
                size = userSQLParams.size();
                for (i = 0; i < size; ++i, ++parameterIndex) {
                    SQLHelper.setParams((PreparedStatement)ps, (int)parameterIndex, (Object)userSQLParams.get(i));
                }
            }
            if (AbstractDBSourceDomain.isParamsValid(runtimeParams)) {
                size = params.length;
                for (i = 0; i < size; ++i, ++parameterIndex) {
                    Object param = params[i];
                    this.setRuntimeParams(ps, parameterIndex, param);
                }
            }
            PreparedStatement wrapped = this.jdbcAdapter.wrapPrepareStatement(sql, ps);
            rs = wrapped.executeQuery();
            HashMap<String, Object> oneRowMap = new HashMap<String, Object>(runtimeEntity.getAllProperties().size(), 1.0f);
            IResultSetDataConvertor dataConvertor = this.jdbcAdapter.getDataConvertor();
            while (rs.next() && result.size() < rows) {
                ColumnToRowDataHandler dataHandler;
                List rowDataList;
                oneRowMap.clear();
                AbstractDBSourceDomain.getPrimaryRowData(oneRowMap, rs, runtimeEntity, dataConvertor);
                Map<String, Object> innerFilterRowMap = AbstractDBSourceDomain.innerFilterIfParamSizeTooLong(runtimeParams, oneRowMap);
                if (innerFilterRowMap == null || !CollectionUtils.isNotEmpty((Collection)(rowDataList = (dataHandler = new ColumnToRowDataHandler()).columnToRow(innerFilterRowMap, runtimeEntity)))) continue;
                for (Map rowMap : rowDataList) {
                    Map<String, Object> calculatedRowData = AbstractDBSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                    if (calculatedRowData == null) continue;
                    result.add(AbstractDBSourceDomain.getOutputData(calculatedRowData, runtimeEntity, true));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DBExcuseException(e);
                catch (Exception e2) {
                    throw new DBExcuseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Connection)conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        String unPushdownableFilterConditions = "";
        IDBRuntimeFilter unPushdownableRuntimeFilter = (IDBRuntimeFilter)runtimeEntity.getUnPushdownableFilter();
        if (unPushdownableRuntimeFilter != null) {
            unPushdownableFilterConditions = unPushdownableRuntimeFilter.getUnpushdownFilterExpress();
        }
        PreviewDataModel previewDataModel = new PreviewDataModel(result);
        previewDataModel.setSqlContent(SQLHelper.sqlReplaceParams((String)sql, (Object[])params));
        previewDataModel.setUnPushdownFilterContent(unPushdownableFilterConditions);
        return previewDataModel;
    }

    static Map<String, Object> innerFilterIfParamSizeTooLong(DBRuntimeInfo runtimeInfo, Map<String, Object> oneRowMap) {
        if (runtimeInfo.isParamSizeTooLong && runtimeInfo.runtimeFilter != null && !runtimeInfo.runtimeFilter.isInvalid()) {
            if (runtimeInfo.runtimeFilter.innerExcuteFilter(oneRowMap, null)) {
                return oneRowMap;
            }
            return null;
        }
        return oneRowMap;
    }

    @Override
    public long getDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractDBSourceException, AbstractMacroException {
        DBSource dbSource = (DBSource)runtimeEntity.getSource();
        StoredProcedure storedProce = dbSource.getStoredProcedure(runtimeEntity.getAssociateName());
        if (storedProce != null) {
            return this.getDataCountStoredProcedure(runtimeEntity, dbSource, storedProce);
        }
        return this.getDataCountGeneral(qingContext, runtimeEntity);
    }

    private long getDataCountStoredProcedure(RuntimeEntity runtimeEntity, DBSource dbSource, StoredProcedure storedProce) throws AbstractDBSourceException {
        StoredProcedureExec storedProcedureExec = new StoredProcedureExec(runtimeEntity, dbSource, storedProce);
        long dataCount = storedProcedureExec.getDataCount();
        return dataCount;
    }

    protected boolean isNeedReCountByResultSet(Object[] params) {
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getDataCountGeneral(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractDBSourceException, AbstractMacroException {
        long l;
        long dataCount;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        DBRuntimeInfo runtimeParams;
        block18: {
            long rowCount;
            long count;
            int i;
            int size;
            DBSource dataBase = (DBSource)runtimeEntity.getSource();
            runtimeParams = this.initDBRuntimeParams(qingContext, runtimeEntity, true);
            boolean needReCount = this.isNeedReCountByResultSet(runtimeParams.params);
            if (needReCount) {
                runtimeParams = this.initDBRuntimeParams(qingContext, runtimeEntity, false);
            }
            if (runtimeParams.isAlwaysFalse) {
                return 0L;
            }
            IRuntimeFilter calculateFilter = runtimeEntity.getUnPushdownableFilter();
            String sql = runtimeParams.sql;
            sql = this.jdbcAdapter.appendWhereClause(sql);
            conn = null;
            ps = null;
            rs = null;
            dataCount = 0L;
            boolean isNoUnionColToRow = true;
            if (runtimeEntity.getEntityExtractContext() != null) {
                isNoUnionColToRow = CollectionUtils.isEmpty((Collection)runtimeEntity.getEntityExtractContext().getColumnToRowProperties());
            }
            conn = this.jdbcAdapter.getConnection(dataBase);
            boolean isNeedFormateSql = (runtimeParams.runtimeFilter == null || AbstractDBSourceDomain.isCanFilterInDB(runtimeParams)) && calculateFilter == null && CollectionUtils.isEmpty((Collection)runtimeEntity.getOrinalEntity().getColumnToRowProperties()) && isNoUnionColToRow;
            ps = conn.prepareStatement(sql);
            this.jdbcAdapter.setQueryTimeout(qingContext, ps);
            int parameterIndex = 1;
            List<Object> userSQLParams = runtimeParams.getUserSQLParams();
            if (userSQLParams != null) {
                size = userSQLParams.size();
                for (i = 0; i < size; ++i, ++parameterIndex) {
                    SQLHelper.setParams((PreparedStatement)ps, (int)parameterIndex, (Object)userSQLParams.get(i));
                }
            }
            if (AbstractDBSourceDomain.isParamsValid(runtimeParams)) {
                size = runtimeParams.params.length;
                for (i = 0; i < size; ++i, ++parameterIndex) {
                    Object param = runtimeParams.params[i];
                    this.setRuntimeParams(ps, parameterIndex, param);
                }
            }
            PreparedStatement wrapped = this.jdbcAdapter.wrapPrepareStatement(sql, ps);
            rs = wrapped.executeQuery();
            if (!isNeedFormateSql) break block18;
            if (!needReCount) {
                rs.next();
                count = rs.getLong(1);
            } else {
                rowCount = 0L;
                while (rs.next()) {
                    ++rowCount;
                }
                count = rowCount;
            }
            rowCount = count;
            CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
            return rowCount;
        }
        try {
            HashMap<String, Object> oneRowMap = new HashMap<String, Object>(runtimeEntity.getAllProperties().size(), 1.0f);
            IResultSetDataConvertor dataConvertor = this.jdbcAdapter.getDataConvertor();
            while (rs.next()) {
                ColumnToRowDataHandler dataHandler;
                List rowDataList;
                oneRowMap.clear();
                AbstractDBSourceDomain.getPrimaryRowData(oneRowMap, rs, runtimeEntity, dataConvertor);
                Map<String, Object> innerFilterRowMap = AbstractDBSourceDomain.innerFilterIfParamSizeTooLong(runtimeParams, oneRowMap);
                if (innerFilterRowMap == null || !CollectionUtils.isNotEmpty((Collection)(rowDataList = (dataHandler = new ColumnToRowDataHandler()).columnToRow(innerFilterRowMap, runtimeEntity)))) continue;
                for (Map rowMap : rowDataList) {
                    Map<String, Object> calculatedRowData = AbstractDBSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                    if (calculatedRowData == null) continue;
                    ++dataCount;
                }
            }
            l = dataCount;
        }
        catch (SQLException e) {
            try {
                throw new DBExcuseException(e);
                catch (Exception e2) {
                    throw new DBExcuseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close(conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        return l;
    }

    public static boolean isCanFilterInDB(DBRuntimeInfo runtimeParams) {
        return AbstractDBSourceDomain.isRuntimeFilterValid(runtimeParams.runtimeFilter) && !runtimeParams.isParamSizeTooLong;
    }

    private static boolean isParamsValid(DBRuntimeInfo runtimeParams) {
        return runtimeParams.params != null && runtimeParams.params.length > 0 && !runtimeParams.isParamSizeTooLong;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isDataFieldUnique(QingContext qingContext, RuntimeEntity runtimeEntity, RuntimeProperty runtimeProperty) throws AbstractSourceException {
        boolean bl;
        DBSource dataBase = (DBSource)runtimeEntity.getSource();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.jdbcAdapter.getConnection(dataBase);
            String sql = null;
            String tableAssociateName = runtimeEntity.getAssociateName();
            DBSource.UserSQL userSQL = dataBase.getUserSql(tableAssociateName);
            tableAssociateName = this.jdbcAdapter.getLeftDelimiter() + this.jdbcAdapter.wrapTableAssociateName(dataBase, tableAssociateName) + this.jdbcAdapter.getRightDelimiter();
            String columnAssociateName = tableAssociateName + "." + this.jdbcAdapter.getLeftDelimiter() + runtimeProperty.getAssociateName() + this.jdbcAdapter.getRightDelimiter();
            if (userSQL != null) {
                String userSqlContent = userSQL.getContent();
                DBSource.UserSQL.SQLType sqlType = DBSource.UserSQL.SQLType.valueOf((String)userSQL.getSqlType());
                userSqlContent = SQLHelper.ksqlToDialect((DBSource.DBType)dataBase.getDbType(), (DBSource.UserSQL.SQLType)sqlType, (String)userSqlContent);
                tableAssociateName = "(" + userSqlContent + ") " + tableAssociateName;
            }
            sql = String.format(CHECK_DATA_FIELD_UNIQUE_SQL, tableAssociateName, columnAssociateName, tableAssociateName);
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new DBExcuseException(e);
                catch (Exception e2) {
                    throw new DBExcuseException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Connection)conn, ps, rs);
                throw throwable;
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String extractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws DataSourcePersistenceException, AbstractSourceException, InterruptedException {
        TraceSpan traceSpan = null;
        String result = null;
        try {
            traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"databaseTable", (String)"\u6570\u636e\u5e93\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + runtimeEntity.getAlias() + Messages.getMLS((String)"getData", (String)"]\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractData");
            traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getName());
            traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getAlias());
            DBSource dbSource = (DBSource)runtimeEntity.getSource();
            StoredProcedure storedProce = dbSource.getStoredProcedure(runtimeEntity.getAssociateName());
            result = storedProce != null ? this.extractDataStoredProcedure(dataSourceWriter, runtimeEntity, progressProcessor, dbSource, storedProce) : this.extractDataGeneral(qingContext, dataSourceWriter, runtimeEntity, progressProcessor);
        }
        catch (Throwable throwable) {
            TracerUtil.close(traceSpan);
            throw throwable;
        }
        TracerUtil.close((TraceSpan)traceSpan);
        return result;
    }

    private final String extractDataStoredProcedure(IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor, DBSource dbSource, StoredProcedure storedProce) throws DataSourcePersistenceException, AbstractDBSourceException, InterruptedException {
        StoredProcedureExec storedProcedureExec = new StoredProcedureExec(runtimeEntity, dbSource, storedProce);
        return storedProcedureExec.extractData(dataSourceWriter, progressProcessor);
    }

    @Override
    public IDataSourceIterator createDataSourceIterator(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        return new JDBCDataSourceIterator(qingContext, this, runtimeEntity, this.jdbcAdapter.getDataConvertor());
    }

    protected int getFetchSize() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String extractDataGeneral(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws DataSourcePersistenceException, InterruptedException, AbstractSourceException {
        block23: {
            dataBase = (DBSource)runtimeEntity.getSource();
            runtimeParams = this.initDBRuntimeParams(qingContext, runtimeEntity, false);
            if (runtimeParams.isAlwaysFalse) {
                return null;
            }
            sql = runtimeParams.sql;
            sql = this.jdbcAdapter.appendWhereClause(sql);
            params = runtimeParams.params;
            conn = null;
            ps = null;
            rs = null;
            try {
                if (!runtimeEntity.isUnionUnitEntity() && progressProcessor != null && this.jdbcAdapter.needCalculateTotalCount() && !AbstractDBSourceDomain.isParamSizeTooLong(runtimeParams)) {
                    countSql = String.format(AbstractDBSourceDomain.COUNTSQLTEMPLATE, new Object[]{sql});
                    countSql = this.jdbcAdapter.appendWhereClause(countSql);
                    if (SystemPropertyUtil.getBoolean((String)"qing.preparedata.count.enable", (boolean)true)) {
                        ThreadPoolManage.excuteThreadWithContext((ThreadPoolManage.QingThreadPoolName)ThreadPoolManage.QingThreadPoolName.QING_RUN_IN_BACKGROUND_HANDLER, (Callable)new CountTask(qingContext, countSql, progressProcessor, dataBase, params), (QingContext)qingContext);
                    }
                }
                conn = this.jdbcAdapter.getConnection(dataBase);
                ps = conn.prepareStatement(sql);
                this.jdbcAdapter.setQueryTimeout(qingContext, ps);
                parameterIndex = 1;
                userSQLParams = runtimeParams.getUserSQLParams();
                if (userSQLParams != null) {
                    size = userSQLParams.size();
                    for (i = 0; i < size; ++i, ++parameterIndex) {
                        SQLHelper.setParams((PreparedStatement)ps, (int)parameterIndex, (Object)userSQLParams.get(i));
                    }
                }
                if (AbstractDBSourceDomain.isParamsValid(runtimeParams)) {
                    size = params.length;
                    for (i = 0; i < size; ++i, ++parameterIndex) {
                        param = params[i];
                        this.setRuntimeParams(ps, parameterIndex, param);
                    }
                }
                ps.setFetchSize(this.getFetchSize());
                wrapped = this.jdbcAdapter.wrapPrepareStatement(sql, ps);
                traceSpan = null;
                try {
                    traceSpan = TracerUtil.create((String)Messages.getMLS((String)"executeSQL", (String)"\u6267\u884cSQL", (Messages.ProjectName)Messages.ProjectName.QING_DATA));
                    traceSpan.addClassMethodAttribute(this.getClass().getName() + ".executeQuery");
                    traceSpan.addAttribute("SQL", SQLHelper.sqlReplaceParams((String)sql, (Object[])params));
                    rs = wrapped.executeQuery();
                }
                catch (Throwable var17_24) {
                    TracerUtil.close(traceSpan);
                    throw var17_24;
                }
                TracerUtil.close((TraceSpan)traceSpan);
                oneRowMap = new HashMap<String, Object>(runtimeEntity.getAllProperties().size(), 1.0f);
                dataConvertor = this.jdbcAdapter.getDataConvertor();
                calculatedRowData = null;
                serverRequestInvokeContext = ServerRequestInvokeContext.get();
lbl51:
                // 5 sources

                while (rs.next()) {
                    ServerRequestInvokeContext.staticCheckInterrupt((ServerRequestInvokeContext)serverRequestInvokeContext);
                    oneRowMap.clear();
                    AbstractDBSourceDomain.getPrimaryRowData(oneRowMap, rs, runtimeEntity, dataConvertor);
                    innerFilterRow = AbstractDBSourceDomain.innerFilterIfParamSizeTooLong(runtimeParams, oneRowMap);
                    if (innerFilterRow == null) ** GOTO lbl98
                    dataHandler = new ColumnToRowDataHandler();
                    rowDataList = dataHandler.columnToRow(innerFilterRow, runtimeEntity);
                    if (!CollectionUtils.isNotEmpty((Collection)rowDataList)) continue;
lbl61:
                    // 3 sources

                    for (Map rowMap : rowDataList) {
                        calculatedRowData = AbstractDBSourceDomain.getRowDataAfterCalculateAndFilter(rowMap, runtimeEntity);
                        if (calculatedRowData == null) ** GOTO lbl-1000
                        data = AbstractDBSourceDomain.getOutputData(calculatedRowData, runtimeEntity, false);
                        dataSourceWriter.writeData(data);
                        if (progressProcessor != null) {
                            progressProcessor.writeOneRow();
                            if (progressProcessor.isDataLimit()) {
                                var26_34 = null;
                                break block23;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                }
                ** GOTO lbl101
            }
            catch (RuntimeException e) {
                try {
                    throwable = e.getCause();
                    if (throwable instanceof SQLException && ((errorCode = ((SQLException)throwable).getErrorCode()) == 1089 || errorCode == 1067)) {
                        throw new SuperQueryNoSchemaPermException(e.getMessage());
                    }
                    throw new DBExcuseException((Exception)e);
                    catch (SQLException e) {
                        if (e.getErrorCode() == 1011) {
                            throw new SuperQueryMissPhysicalTableException(e.getMessage());
                        }
                        if (e.getErrorCode() != 1071 && e.getErrorCode() != 1068) {
                            throw new DBExcuseException(e);
                        }
                        throw new SuperQueryMissTableException(e.getMessage());
                    }
                    catch (Exception e) {
                        throw new DBExcuseException(e);
                    }
                }
                catch (Throwable var27_35) {
                    CloseUtil.close(conn, ps, rs);
                    throw var27_35;
                }
            }
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        return var26_34;
lbl-1000:
        // 2 sources

        {
            if (progressProcessor == null) ** GOTO lbl61
            progressProcessor.dealOneRow();
            ** GOTO lbl61
lbl98:
            // 1 sources

            if (progressProcessor == null) ** GOTO lbl51
            progressProcessor.dealOneRow();
            ** GOTO lbl51
lbl101:
            // 1 sources

            var20_28 = null;
        }
        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
        return var20_28;
    }

    public static Map<String, Object> getPrimaryRowData(Map<String, Object> oneRowData, ResultSet rs, RuntimeEntity runtimeEntity, IResultSetDataConvertor dataConvertor) throws SQLException {
        for (RuntimeProperty property : runtimeEntity.getSelectedPriProperties()) {
            String columnName = property.getName();
            DataType inputdataType = property.getInputDataType();
            String associateName = property.getAssociateName();
            if (property.getProperty().isNotExisted()) {
                oneRowData.put(columnName, null);
            }
            if (!AbstractDBSourceDomain.isColumnExist(rs, associateName)) continue;
            oneRowData.put(columnName, dataConvertor.getData(rs, associateName, inputdataType));
        }
        return oneRowData;
    }

    private static boolean isColumnExist(ResultSet rs, String colName) {
        try {
            return rs.findColumn(colName) > 0;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public List<String> getDatabaseNameList(AbstractSource source) throws AbstractDBSourceException {
        return this.jdbcAdapter.getDatabaseNameList(source);
    }

    public String getDbVersion(DBSource dbSource) {
        return this.jdbcAdapter.getDbVersion(dbSource);
    }

    public void checkSQLExecutable(QingContext qingContext, DBSource source, DBSource.UserSQL.SQLType sqlType, String content) throws AbstractDBSourceException {
        this.jdbcAdapter.checkSQLExecutable(qingContext, source, sqlType, content);
    }

    public <T> T query(QingContext qingContext, DBSource dataBase, String sql, DBSource.UserSQL.SQLType sqlType, AbstractDBSourceJDBCAdapter.QueryResultHandler<T> queryResultHandler) throws AbstractDBSourceException, SQLException {
        return (T)this.jdbcAdapter.query(qingContext, dataBase, sql, sqlType, queryResultHandler);
    }

    private class StoredProcedureExec {
        private StoredProcedure storedProce;
        private DBSource dbSource;
        private RuntimeEntity runtimeEntity;

        public StoredProcedureExec(RuntimeEntity runtimeEntity, DBSource dbSource, StoredProcedure storedProce) {
            this.runtimeEntity = runtimeEntity;
            this.storedProce = storedProce;
            this.dbSource = dbSource;
        }

        public long getDataCount() throws AbstractDBSourceException {
            Connection conn = AbstractDBSourceDomain.this.jdbcAdapter.getConnection(this.dbSource);
            CallableStatement ps = null;
            ResultSet rs = null;
            try {
                RuntimeFilterUtil.Prediction prediction = AbstractDBSourceDomain.this.initRuntimeFilter(this.runtimeEntity);
                if (prediction.isAlwaysFalse()) {
                    long l = 0L;
                    return l;
                }
                String sql = AbstractDBSourceDomain.this.jdbcAdapter.getStoredProcedureExecSql(this.dbSource, this.storedProce);
                ps = SQLHelper.prepareCall((Connection)conn, (String)sql);
                rs = SQLHelper.getExecResultSet((QingContext)this.runtimeEntity.getQingContext(), (Connection)conn, (DBSource)this.dbSource, (CallableStatement)ps, (StoredProcedure)this.storedProce);
                long dataCount = 0L;
                HashMap<String, Object> oneRowMap = new HashMap<String, Object>(this.runtimeEntity.getAllProperties().size(), 1.0f);
                IResultSetDataConvertor dataConvertor = AbstractDBSourceDomain.this.jdbcAdapter.getDataConvertor();
                while (rs.next()) {
                    oneRowMap.clear();
                    AbstractDBSourceDomain.getPrimaryRowData(oneRowMap, rs, this.runtimeEntity, dataConvertor);
                    ColumnToRowDataHandler dataHandler = new ColumnToRowDataHandler();
                    List rowDataList = dataHandler.columnToRow(oneRowMap, this.runtimeEntity);
                    if (!CollectionUtils.isNotEmpty((Collection)rowDataList)) continue;
                    for (Map rowMap : rowDataList) {
                        Map<String, Object> calculatedRowData = AbstractDBSourceDomain.filterRow(rowMap, this.runtimeEntity);
                        if (calculatedRowData == null) continue;
                        ++dataCount;
                    }
                }
                long l = dataCount;
                CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
                return l;
            }
            catch (SQLException e) {
                throw new DBExcuseException(e);
            }
            catch (Exception e) {
                throw new DBExcuseException(e);
            }
            finally {
                CloseUtil.close((Connection)conn, ps, rs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String extractData(IDataSourceWriter dataSourceWriter, ProgressProcessor progressProcessor) throws DataSourcePersistenceException, AbstractDBSourceException, InterruptedException {
            String string;
            Connection conn = null;
            CallableStatement ps = null;
            ResultSet rs = null;
            try {
                RuntimeFilterUtil.Prediction prediction = AbstractDBSourceDomain.this.initRuntimeFilter(this.runtimeEntity);
                if (prediction.isAlwaysFalse()) {
                    String string2 = null;
                    return string2;
                }
                conn = AbstractDBSourceDomain.this.jdbcAdapter.getConnection(this.dbSource);
                String sql = AbstractDBSourceDomain.this.jdbcAdapter.getStoredProcedureExecSql(this.dbSource, this.storedProce);
                TraceSpan traceSpan = null;
                try {
                    traceSpan = TracerUtil.create((String)Messages.getMLS((String)"executeStoreProcedure", (String)"\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b", (Messages.ProjectName)Messages.ProjectName.QING_DATA));
                    traceSpan.addClassMethodAttribute(this.getClass().getName() + ".prepareCall");
                    traceSpan.addAttribute("SQL", sql);
                    ps = SQLHelper.prepareCall((Connection)conn, (String)sql);
                }
                catch (Throwable throwable) {
                    TracerUtil.close(traceSpan);
                    throw throwable;
                }
                TracerUtil.close((TraceSpan)traceSpan);
                rs = SQLHelper.getExecResultSet((QingContext)this.runtimeEntity.getQingContext(), (Connection)conn, (DBSource)this.dbSource, (CallableStatement)ps, (StoredProcedure)this.storedProce);
                HashMap<String, Object> oneRowMap = new HashMap<String, Object>(this.runtimeEntity.getAllProperties().size(), 1.0f);
                IResultSetDataConvertor dataConvertor = AbstractDBSourceDomain.this.jdbcAdapter.getDataConvertor();
                while (rs.next()) {
                    oneRowMap.clear();
                    AbstractDBSourceDomain.getPrimaryRowData(oneRowMap, rs, this.runtimeEntity, dataConvertor);
                    ColumnToRowDataHandler dataHandler = new ColumnToRowDataHandler();
                    List rowDataList = dataHandler.columnToRow(oneRowMap, this.runtimeEntity);
                    if (!CollectionUtils.isNotEmpty((Collection)rowDataList)) continue;
                    for (Map rowMap : rowDataList) {
                        Map<String, Object> rowValue = AbstractDBSourceDomain.filterRow(rowMap, this.runtimeEntity);
                        if (rowValue == null) continue;
                        Object[] data = AbstractDataSourceDomain.getOutputData(rowValue, this.runtimeEntity, false);
                        dataSourceWriter.writeData(data);
                        if (progressProcessor == null) continue;
                        progressProcessor.dealOneRow();
                        progressProcessor.writeOneRow();
                        if (!progressProcessor.isDataLimit()) continue;
                        String string3 = null;
                        CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
                        return string3;
                    }
                }
                string = null;
                CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
            }
            catch (SQLException e) {
                throw new DBExcuseException(e);
            }
            catch (Exception e) {
                throw new DBExcuseException(e);
            }
            finally {
                CloseUtil.close(conn, ps, rs);
            }
            return string;
        }

        public List<Object[]> getPreviewData(int rows) throws AbstractDBSourceException {
            Connection conn = null;
            CallableStatement ps = null;
            ResultSet rs = null;
            try {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                RuntimeFilterUtil.Prediction prediction = AbstractDBSourceDomain.this.initRuntimeFilter(this.runtimeEntity);
                if (prediction.isAlwaysFalse()) {
                    ArrayList<Object[]> arrayList = result;
                    return arrayList;
                }
                conn = AbstractDBSourceDomain.this.jdbcAdapter.getConnection(this.dbSource);
                String sql = AbstractDBSourceDomain.this.jdbcAdapter.getStoredProcedureExecSql(this.dbSource, this.storedProce);
                ps = SQLHelper.prepareCall((Connection)conn, (String)sql);
                rs = SQLHelper.getExecResultSet((QingContext)this.runtimeEntity.getQingContext(), (Connection)conn, (DBSource)this.dbSource, (CallableStatement)ps, (StoredProcedure)this.storedProce);
                HashMap<String, Object> oneRowMap = new HashMap<String, Object>(this.runtimeEntity.getAllProperties().size(), 1.0f);
                IResultSetDataConvertor dataConvertor = AbstractDBSourceDomain.this.jdbcAdapter.getDataConvertor();
                while (rs.next() && result.size() < rows) {
                    oneRowMap.clear();
                    AbstractDBSourceDomain.getPrimaryRowData(oneRowMap, rs, this.runtimeEntity, dataConvertor);
                    ColumnToRowDataHandler dataHandler = new ColumnToRowDataHandler();
                    List rowDataList = dataHandler.columnToRow(oneRowMap, this.runtimeEntity);
                    if (!CollectionUtils.isNotEmpty((Collection)rowDataList)) continue;
                    for (Map rowMap : rowDataList) {
                        Map<String, Object> rowValue = AbstractDBSourceDomain.filterRow(rowMap, this.runtimeEntity);
                        if (rowValue == null) continue;
                        result.add(AbstractDataSourceDomain.getOutputData(rowValue, this.runtimeEntity, true));
                    }
                }
                ArrayList<Object[]> arrayList = result;
                CloseUtil.close((Connection)conn, (Statement)ps, (ResultSet)rs);
                return arrayList;
            }
            catch (SQLException e) {
                throw new DBExcuseException(e);
            }
            catch (Exception e) {
                throw new DBExcuseException(e);
            }
            finally {
                CloseUtil.close(conn, ps, rs);
            }
        }
    }

    private class CountTask
    implements Callable<Long> {
        private ProgressProcessor progressProcessor;
        private DBSource dataSource;
        private Object[] params;
        private String countSql;
        private QingContext qingContext;

        public CountTask(QingContext qingContext, String sql, ProgressProcessor progressProcessor, DBSource dataBase, Object[] params) {
            this.qingContext = qingContext;
            this.progressProcessor = progressProcessor;
            this.dataSource = dataBase;
            this.params = params;
            this.countSql = sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws SQLException, AbstractDBConnectException {
            ResultSet rs = null;
            long countDB = 1L;
            PreparedStatement ps = null;
            Connection connection = null;
            try {
                connection = AbstractDBSourceDomain.this.jdbcAdapter.getConnection(this.dataSource);
                ps = connection.prepareStatement(this.countSql);
                if (this.params != null && this.params.length > 0) {
                    int size = this.params.length;
                    for (int parameterIndex = 0; parameterIndex < size; ++parameterIndex) {
                        Object param = this.params[parameterIndex];
                        SQLHelper.setParams((PreparedStatement)ps, (int)(parameterIndex + 1), (Object)param);
                    }
                }
                AbstractDBSourceDomain.this.jdbcAdapter.setQueryTimeout(this.qingContext, ps);
                ps.setFetchSize(100);
                PreparedStatement wrapPs = AbstractDBSourceDomain.this.jdbcAdapter.wrapPrepareStatement(this.countSql, ps);
                rs = wrapPs.executeQuery();
                countDB = rs.next() ? rs.getLong(1) : 0L;
                this.progressProcessor.setTotalRows(countDB);
            }
            catch (Throwable throwable) {
                CloseUtil.close(connection, ps, rs);
                throw throwable;
            }
            CloseUtil.close((Connection)connection, (Statement)ps, (ResultSet)rs);
            return countDB;
        }
    }

    public static class DBRuntimeInfo {
        public String sql;
        public Object[] params;
        public boolean isAlwaysFalse = false;
        public IDBRuntimeFilter runtimeFilter;
        public boolean isParamSizeTooLong = false;
        private List<Object> userSQLParams;

        public String getSql() {
            return this.sql;
        }

        public IDBRuntimeFilter getRuntimeFilter() {
            return this.runtimeFilter;
        }

        public void setUserSQLParams(List<Object> params) {
            this.userSQLParams = params;
        }

        public List<Object> getUserSQLParams() {
            return this.userSQLParams;
        }
    }
}

