/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.model;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.data.domain.source.file.handler.XmlColIndexNameHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XmlColTypeHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XmlTableNamesHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XmlTopNRowHandler;
import com.kingdee.bos.qing.data.domain.source.file.handler.XmlTotalRowCountHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.AbstractFileModel;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileParseException;
import com.kingdee.bos.qing.data.model.designtime.source.FileSource;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParseDataModel
extends AbstractFileModel {
    private String[] xPath;
    private FileSource fileSource;
    private Map<Integer, String> colIndexNameMap;
    private Map<String, Set<String>> colTypeMap = new HashMap<String, Set<String>>(16);
    private ResultContent resultContent = new ResultContent();

    public XmlParseDataModel(String path) {
        super(path);
    }

    public XmlParseDataModel(String path, String[] xPath, FileSource fileSource) {
        super(path);
        this.xPath = xPath;
        this.fileSource = fileSource;
    }

    public ResultContent getResultContent() {
        return this.resultContent;
    }

    public int getTotalRowCount(RunningTimeParams params) throws AbstractSourceException {
        if (this.colIndexNameMap == null) {
            this.getColIndexNameMap();
        }
        XmlTotalRowCountHandler xmlTotalRowCountHandler = new XmlTotalRowCountHandler(params, this.xPath, this.colIndexNameMap, this);
        this.doParse((DefaultHandler)xmlTotalRowCountHandler);
        return xmlTotalRowCountHandler.getRowCount();
    }

    public List<String> getTableNames() throws AbstractSourceException {
        XmlTableNamesHandler xmlTableNamesHandler = new XmlTableNamesHandler();
        this.doParse((DefaultHandler)xmlTableNamesHandler);
        ArrayList<String> tableNames = new ArrayList<String>(xmlTableNamesHandler.getPathSet());
        return tableNames;
    }

    public Map<Integer, String> getColIndexNameMap() throws AbstractSourceException {
        XmlColIndexNameHandler xmlColIndexNameHandler = new XmlColIndexNameHandler(this.xPath);
        this.doParse((DefaultHandler)xmlColIndexNameHandler);
        this.colIndexNameMap = xmlColIndexNameHandler.getColIndexNameMap();
        return this.colIndexNameMap;
    }

    public Map<String, Set<String>> getColTypeMap() throws AbstractSourceException {
        if (this.colIndexNameMap == null) {
            this.getColIndexNameMap();
        }
        this.doParse((DefaultHandler)new XmlColTypeHandler(this.xPath, this.fileSource.getDefineTypeRowCount(), this.colIndexNameMap, this.colTypeMap));
        return this.colTypeMap;
    }

    public String getColType(int colIndex) throws AbstractSourceException {
        return null;
    }

    public ResultContent topNRow(RunningTimeParams params, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException {
        if (this.colIndexNameMap == null) {
            this.getColIndexNameMap();
        }
        XmlTopNRowHandler xmlTopNRowHandler = new XmlTopNRowHandler(params, progressProcessor, this.xPath, this.colIndexNameMap, this);
        this.doParse((DefaultHandler)xmlTopNRowHandler);
        return xmlTopNRowHandler.getResultContent();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doParse(DefaultHandler handler) throws AbstractSourceException {
        InputStream fileInputStream = null;
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = saxFactory.newSAXParser();
            fileInputStream = this.getFileInputStream(this.getPath());
            parser.parse(fileInputStream, handler);
        }
        catch (ParserConfigurationException e) {
            try {
                throw new FileSourceFileParseException((Throwable)e);
                catch (SAXParseException e2) {
                    String msg = this.getTranslateMessage(e2.getMessage(), e2.getLineNumber(), e2.getColumnNumber());
                    throw new FileSourceFileParseException(msg, (Throwable)e2);
                }
                catch (SAXException e3) {
                    throw new FileSourceFileParseException((Throwable)e3);
                }
                catch (IOException e4) {
                    throw new FileSourceFileParseException((Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
    }

    private String getTranslateMessage(String message, int lineNumber, int columnNumber) {
        String translateMessage = Messages.getMLS((String)"saxParseError", (String)"xml\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff0c\u7b2c#1\u884c\uff0c\u4f4d\u7f6e#2\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        translateMessage = translateMessage.replace("#1", String.valueOf(lineNumber)).replace("#2", String.valueOf(columnNumber));
        if (StringUtils.isNotBlank((CharSequence)message) && message.contains("The markup in the document following the root element must be well-formed")) {
            translateMessage = translateMessage + Messages.getMLS((String)"rootElementError", (String)"\u6709\u591a\u4e2a\u6839\u5143\u7d20\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if (StringUtils.isNotBlank((CharSequence)message) && message.contains("XML document structures must start and end within the same entity")) {
            translateMessage = translateMessage + Messages.getMLS((String)"sameEntityError", (String)"\u5143\u7d20\u672a\u5c01\u95ed\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if (StringUtils.isNotBlank((CharSequence)message) && message.contains("Invalid byte 1 of 1-byte UTF-8 sequence")) {
            translateMessage = translateMessage + Messages.getMLS((String)"encodeError", (String)"\u672a\u6307\u5b9a\u6b63\u786e\u5b57\u7b26\u7f16\u7801\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if (StringUtils.isNotBlank((CharSequence)message) && message.contains("A pseudo attribute name is expected")) {
            translateMessage = translateMessage + Messages.getMLS((String)"attributeError", (String)"\u5c5e\u6027\u540d\u4e0d\u5b8c\u6574\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        if (StringUtils.isNotBlank((CharSequence)message) && message.contains("The processing instruction must begin with the name of the target")) {
            translateMessage = translateMessage + Messages.getMLS((String)"beginNameError", (String)"\u6587\u4ef6\u5f00\u5934\u4e0d\u6b63\u786e\u3002", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        }
        return translateMessage;
    }

    public static Integer getKey(Map<Integer, String> map, String value) {
        Integer key = null;
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            key = entry.getKey();
        }
        return key;
    }

    public static boolean isRecordWrapTag(List<String> levelList, String[] xPath) {
        return levelList.size() == xPath.length && XmlParseDataModel.compareXPath(levelList, xPath);
    }

    public static boolean needReadRecord(List<String> levelList, String[] xPath) {
        return levelList.size() == xPath.length + 1 && XmlParseDataModel.compareXPath(levelList, xPath);
    }

    public static boolean compareXPath(List<String> levelList, String[] xPath) {
        for (int i = 0; i < xPath.length; ++i) {
            if (xPath[i].equals(levelList.get(i))) continue;
            return false;
        }
        return true;
    }
}

