/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.EntityType;
import com.kingdee.bos.qing.data.model.designtime.ExtractConfig;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.FixAbstractEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixBizUnionEntityBatchProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixIllegalSourceProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixListEntityPropertyProcess;
import com.kingdee.bos.qing.data.util.EntityNameKeySelector;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FixProcesser {
    public static void fixBoxForExtract(QingContext qingContext, Box box, String ownerId) {
        List abstractEntities = box.getEntities();
        List sources = box.getSources();
        FixIllegalSourceProcess.process((QingContext)qingContext, (List)sources, (List)abstractEntities);
        FixIllegalSourceProcess.fixUserContext((List)sources, (String)ownerId);
        FixListEntityPropertyProcess listEntityPropertyProcess = new FixListEntityPropertyProcess();
        listEntityPropertyProcess.process(qingContext, box, BoxFixScene.extract);
    }

    public static void fixBoxForAnalysis(QingContext qingContext, Box box) {
        List abstractEntities = box.getEntities();
        List sources = box.getSources();
        FixIllegalSourceProcess.process((QingContext)qingContext, (List)sources, (List)abstractEntities);
        FixListEntityPropertyProcess listEntityPropertyProcess = new FixListEntityPropertyProcess();
        listEntityPropertyProcess.process(qingContext, box, BoxFixScene.analysis);
    }

    public static boolean fixEntityForPreview(QingContext qingContext, AbstractEntity entity, AbstractSource source, List<AbstractEntity> entitys) {
        ArrayList<AbstractSource> sources = new ArrayList<AbstractSource>();
        sources.add(source);
        return FixProcesser.fixEntityForPreview(qingContext, entity, sources, entitys);
    }

    public static boolean fixEntityForPreview(QingContext qingContext, AbstractEntity entity, List<AbstractSource> sources, List<AbstractEntity> entitys) {
        FixProcesser.checkSourcePermission(qingContext, sources);
        FixIllegalSourceProcess.process((QingContext)qingContext, sources, entitys);
        if (!entitys.isEmpty()) {
            Map entitysMap = MapUtils.collectionToMap(entitys, (MapUtils.IMapKeySelector)new EntityNameKeySelector());
            HashMap<String, AbstractSource> sourcesMap = new HashMap<String, AbstractSource>(sources.size());
            for (AbstractSource source : sources) {
                sourcesMap.put(source.getName(), source);
            }
            FixProcesser.setEntityParent(entitys, entitysMap);
            if (entity.getEntityType() == EntityType.BIZ_UNION) {
                ArrayList<AbstractEntity> bizUnionEntities = new ArrayList<AbstractEntity>();
                for (AbstractEntity absEntity : entitys) {
                    if (absEntity.getEntityType() != EntityType.BIZ_UNION) continue;
                    bizUnionEntities.add(absEntity);
                }
                new FixBizUnionEntityBatchProcess(qingContext, BoxFixScene.preview).fixBizUnionEntity(bizUnionEntities, new HashMap(), sourcesMap);
                return false;
            }
            FixAbstractEntityProcess abstractEntityProcess = new FixAbstractEntityProcess(qingContext, null, BoxFixScene.preview);
            return abstractEntityProcess.process(entity, sourcesMap, entitysMap);
        }
        return false;
    }

    private static void checkSourcePermission(QingContext qingContext, List<AbstractSource> sources) {
        if (sources != null) {
            Iterator<AbstractSource> sourcesIterator = sources.iterator();
            while (sourcesIterator.hasNext()) {
                AbstractSource source = sourcesIterator.next();
                try {
                    AbstractDataSourceDomain domain = SourceDomainFactory.getSourceDomain((AbstractSource)source);
                    domain.checkSourcePermission(qingContext, source);
                }
                catch (UnSupportDataSourceException e) {
                    sourcesIterator.remove();
                }
            }
        }
    }

    private static void setEntityParent(List<AbstractEntity> entitys, Map<String, AbstractEntity> entitysMap) {
        for (AbstractEntity entity : entitys) {
            String parentName = entity.getParentName();
            if (!StringUtils.isNotEmpty((CharSequence)parentName)) continue;
            entity.setParentEntity(entitysMap.get(parentName));
        }
    }

    public static void fixBoxForDataModeling(QingContext qingContext, Box box) {
        ExtractConfig extractConfig;
        if (box == null) {
            return;
        }
        List abstractEntities = box.getEntities();
        List sources = box.getSources();
        FixIllegalSourceProcess.process((QingContext)qingContext, (List)sources, (List)abstractEntities);
        if (!abstractEntities.isEmpty()) {
            FixListEntityPropertyProcess listEntityPropertyProcess = new FixListEntityPropertyProcess();
            listEntityPropertyProcess.process(qingContext, box, BoxFixScene.datamodeling);
        }
        if ((extractConfig = box.getExtractConfig()) != null) {
            extractConfig.setExtractUsers(extractConfig.getValidExtractUsers());
        }
    }
}

