/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qinglightapp.repository;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qinglightapp.context.ContextManager;
import com.kingdee.bos.qinglightapp.exception.PersistentModelParseException;
import com.kingdee.bos.qinglightapp.model.analysis.AnalysisBO;
import com.kingdee.bos.qinglightapp.model.analysis.AnalysisDO;
import com.kingdee.bos.qinglightapp.model.analysis.AnalysisVO;
import com.kingdee.bos.qinglightapp.model.analysis.DisplayStyleEnum;
import com.kingdee.bos.qinglightapp.model.analysis.ProductType;
import com.kingdee.bos.qinglightapp.model.analysis.ViewTypeEnum;
import com.kingdee.bos.qinglightapp.repository.AbstractRepository;
import com.kingdee.bos.qinglightapp.repository.helper.IResultGetter;
import com.kingdee.bos.qinglightapp.repository.helper.TableHelper;
import com.kingdee.bos.qinglightapp.repository.sqlbuilder.SqlPageBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisRepository
extends AbstractRepository<AnalysisDO> {
    public List<AnalysisDO> findByDirectoryIdAndIsDeletedEquals(long directoryId, boolean isDeleted) {
        String sql = this.getSelectedSql() + "WHERE FDIRECTORYID = ? AND FISDELETED = ?";
        return this.queryList(sql, new Object[]{directoryId, this.convertBoolToString(isDeleted)});
    }

    public Integer getOwnAnalysisPaginationCount(Long directoryId, String searchText, String currentType) {
        StringBuilder sqlBuilder = new StringBuilder();
        String selectClause = "SELECT COUNT(1) AS COUNT FROM t_qing_app_analysis A ";
        sqlBuilder.append(selectClause).append("WHERE FDIRECTORYID = ? AND FISDELETED = ?");
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(directoryId);
        paramsList.add(this.convertBoolToString(false));
        if (currentType != null) {
            sqlBuilder.append(" AND A.FVIEWTYPE = ?");
            paramsList.add(currentType);
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sqlBuilder.append(" AND UPPER(A.FNAME) LIKE ?");
            paramsList.add("%" + searchText.toUpperCase() + "%");
        }
        Object[] params = paramsList.toArray();
        return (Integer)this.query(sqlBuilder.toString(), params, (IResultGetter)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<AnalysisDO> findByDirectoryIdAndOtherCondition(long directoryId, String searchText, String currentType, Integer pageSize, Integer offSet, String sortField, String sortOrder) {
        StringBuilder sqlBuilder = new StringBuilder();
        String selectClause = "SELECT A.FID, A.FNAME, A.FDIRECTORYID, A.FCREATETIME, A.FCREATORNAME, A.FPUBLISHID, A.FVIEWTYPE, A.FURL FROM t_qing_app_analysis A ";
        sqlBuilder.append(selectClause).append("WHERE FDIRECTORYID = ? AND FISDELETED = ?");
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(directoryId);
        paramsList.add(this.convertBoolToString(false));
        if (currentType != null) {
            sqlBuilder.append(" AND A.FVIEWTYPE = ?");
            paramsList.add(currentType);
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sqlBuilder.append(" AND UPPER(A.FNAME) LIKE ?");
            paramsList.add("%" + searchText.toUpperCase() + "%");
        }
        sortField = "createTime".equals(sortField) ? "A.FCREATETIME " : "A.FNAME ";
        sortOrder = "DESC".equals(sortOrder) ? "DESC" : "ASC";
        String sqlSortFieldAndOrder = " ORDER BY " + sortField + sortOrder;
        sqlBuilder.append(sqlSortFieldAndOrder);
        String sql = SqlPageBuilder.fixPageSql((String)sqlBuilder.toString(), (Integer)offSet, (Integer)pageSize);
        Object[] params = paramsList.toArray();
        return this.queryList(sql, params, (IResultGetter)new IResultGetter<AnalysisDO>(){

            public AnalysisDO getResult(ResultSet rs) throws SQLException {
                AnalysisDO analysisDO = new AnalysisDO();
                analysisDO.setId(rs.getLong("FID"));
                analysisDO.setName(rs.getString("FNAME"));
                analysisDO.setDirectoryId(Long.valueOf(rs.getLong("FDIRECTORYID")));
                analysisDO.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                analysisDO.setCreatorName(rs.getString("FCREATORNAME"));
                analysisDO.setPublishId(rs.getString("FPUBLISHID"));
                analysisDO.setViewType(ViewTypeEnum.fromPersistance((String)rs.getString("FVIEWTYPE")));
                analysisDO.setUrl(rs.getString("FURL"));
                return analysisDO;
            }
        });
    }

    public int countByDirectoryIdAndIsDeletedEquals(long directoryId, boolean isDeleted) {
        String sql = "SELECT COUNT(1) AS FCOUNT FROM " + this.getTable() + " WHERE FDIRECTORYID = ? AND FISDELETED = ?";
        return (Integer)this.query(sql, new Object[]{directoryId, this.convertBoolToString(isDeleted)}, (IResultGetter)new IResultGetter<Integer>(){

            public Integer getResult(ResultSet rs) throws SQLException {
                return rs.getInt("FCOUNT");
            }
        });
    }

    public List<AnalysisDO> getDemoList(String unionId) {
        String sql = this.getSelectedSql() + "WHERE FUNIONID = ? AND FISDEMO = ? AND FISDELETED = ? ORDER BY FUPDATETIME DESC";
        return this.queryList(sql, new Object[]{unionId, this.convertBoolToString(true), this.convertBoolToString(false)});
    }

    public List<AnalysisDO> query(Long directoryId, String name, Date modifiedTime) {
        String sql = this.getSelectedSql() + "A WHERE A.FDIRECTORYID = ? AND A.FNAME LIKE ? AND A.FUPDATETIME <= ? AND FISDELETED = ? ORDER BY A.FUPDATETIME DESC";
        return this.queryList(sql, new Object[]{directoryId, name, modifiedTime, this.convertBoolToString(false)});
    }

    public AnalysisDO findById(long id) {
        String sql = this.getSelectedSql() + "A WHERE A.FID = ? AND A.FISDELETED = ?";
        return (AnalysisDO)this.query(sql, new Object[]{id, this.convertBoolToString(false)});
    }

    public List<AnalysisDO> findByIdIn(List<Long> ids) {
        String questionStr = this.getQuestionStr(ids.size());
        String sql = this.getSelectedSql() + "A WHERE A.FID IN (" + questionStr + ") AND A.FISDELETED = ?";
        ArrayList<Long> params = new ArrayList<Long>(ids);
        params.add((Long)((Object)this.convertBoolToString(false)));
        return this.queryList(sql, params.toArray());
    }

    public AnalysisDO findByIdAndIgnoreIsDeleted(long id) {
        String sql = this.getSelectedSql() + "WHERE FID = ?";
        return (AnalysisDO)this.query(sql, new Object[]{id});
    }

    public List<AnalysisDO> findByDirectoryIdIgnoreIsDeleted(long id) {
        String sql = this.getSelectedSql() + "WHERE FDIRECTORYID = ?";
        return this.queryList(sql, new Object[]{id});
    }

    public List<AnalysisDO> findByPublishIds(List<String> publishIds) {
        String sql = this.getSelectedSql() + "WHERE FPUBLISHID IN (" + this.getQuestionStr(publishIds.size()) + ")";
        return this.queryList(sql, publishIds.toArray());
    }

    public AnalysisDO findByPublishId(String publishId) {
        String sql = this.getSelectedSql() + "WHERE FPUBLISHID = ?";
        return (AnalysisDO)this.query(sql, new Object[]{publishId});
    }

    public AnalysisDO findByPublishIdAndUnionId(String publishId, String unionId) {
        String sql = this.getSelectedSql() + "A WHERE A.FPUBLISHID = ? AND A.FUNIONID = ? AND A.FISDELETED = ?";
        return (AnalysisDO)this.query(sql, new Object[]{publishId, unionId, this.convertBoolToString(false)});
    }

    public void deleteById(long id) {
        String sql = "DELETE FROM " + this.getTable() + " WHERE FID = ?";
        this.execute(sql, new Object[]{id});
    }

    public void logicDeleteById(long id) {
        String sql = "UPDATE " + this.getTable() + " SET FISDELETED = ?, FUPDATETIME = ? WHERE FID = ?";
        Date now = new Date();
        this.execute(sql, new Object[]{this.convertBoolToString(true), now, id});
    }

    public int countByDirectoryIdAndNameAndIsDeleted(Long directoryId, String name, boolean isDeleted) {
        String sql = "SELECT COUNT(1) AS FCOUNT FROM " + this.getTable() + " WHERE FDIRECTORYID = ? AND FNAME = ? AND FISDELETED = ?";
        return (Integer)this.query(sql, new Object[]{directoryId, name, this.convertBoolToString(isDeleted)}, (IResultGetter)new IResultGetter<Integer>(){

            public Integer getResult(ResultSet rs) throws SQLException {
                return rs.getInt("FCOUNT");
            }
        });
    }

    public List<AnalysisDO> findOwnAnalysisByDirName(String unionId, String dirName) {
        String sql = this.getSelectedSql("A") + "LEFT JOIN " + "t_qing_app_directory" + " D ON A.FDIRECTORYID = D.FID WHERE D.FUNIONID = ? AND D.FNAME = ? AND A.FISDELETED = ?";
        return this.queryList(sql, new Object[]{unionId, dirName, this.convertBoolToString(false)});
    }

    public List<AnalysisBO> findPermissionAnalysisByDirName(String unionId, String dirName) {
        String sql = "SELECT A.FID, A.FCREATETIME, A.FUPDATETIME, A.FDIRECTORYID, A.FCREATORNAME, A.FPRODUCTTYPE, A.FNAME, A.FSCHEMAID, A.FQSID, A.FPUBLISHID, A.FLAYOUTTYPE, A.FDESCRIPTION, A.FURL, A.FLARGETHUMB, A.FISDEMO, A.FISDELETED, A.FVIEWTYPE, A.FUNIONID, A.FISLANDSCAPE, A.FBOTTOMANNOTATION, A.FDISPLAYSTYLE, P.FCREATETIME AS FPERMISSIONCREATETIME FROM " + this.getTable() + " A LEFT JOIN " + "t_qing_app_directory" + " D ON A.FDIRECTORYID = D.FID LEFT JOIN " + "t_qing_app_permpublish" + " P ON A.FID = P.FANALYSISID WHERE A.FUNIONID != ? AND P.FUNIONID = ? AND D.FNAME = ? AND A.FISDELETED = ?";
        return this.queryList(sql, new Object[]{unionId, unionId, dirName, this.convertBoolToString(false)}, (IResultGetter)new IResultGetter<AnalysisBO>(){

            public AnalysisBO getResult(ResultSet rs) throws SQLException {
                AnalysisBO analysisBO = new AnalysisBO();
                analysisBO.setId(rs.getLong("FID"));
                analysisBO.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                analysisBO.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
                analysisBO.setDirectoryId(Long.valueOf(rs.getLong("FDIRECTORYID")));
                analysisBO.setCreatorName(rs.getString("FCREATORNAME"));
                try {
                    analysisBO.setProductType(ProductType.fromPersistance((String)rs.getString("FPRODUCTTYPE")));
                }
                catch (PersistentModelParseException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
                analysisBO.setName(rs.getString("FNAME"));
                analysisBO.setSchemaId(rs.getString("FSCHEMAID"));
                analysisBO.setQsId(rs.getString("FQSID"));
                analysisBO.setPublishId(rs.getString("FPUBLISHID"));
                analysisBO.setLayoutType(rs.getString("FLAYOUTTYPE"));
                analysisBO.setDescription(rs.getString("FDESCRIPTION"));
                analysisBO.setUrl(rs.getString("FURL"));
                analysisBO.setLargeThumb(rs.getString("FLARGETHUMB"));
                analysisBO.setDemo(AnalysisRepository.this.convertStringToBool(rs.getString("FISDEMO")));
                analysisBO.setDeleted(AnalysisRepository.this.convertStringToBool(rs.getString("FISDELETED")));
                analysisBO.setViewType(ViewTypeEnum.fromPersistance((String)rs.getString("FVIEWTYPE")));
                analysisBO.setUnionId(rs.getString("FUNIONID"));
                analysisBO.setLandscape(AnalysisRepository.this.convertStringToBool(rs.getString("FISLANDSCAPE")));
                analysisBO.setBottomAnnotation(rs.getString("FBOTTOMANNOTATION"));
                analysisBO.setDisplayStyle(DisplayStyleEnum.fromPersistance((String)rs.getString("FDISPLAYSTYLE")));
                analysisBO.setPermissionCreateTime((Date)rs.getTimestamp("FPERMISSIONCREATETIME"));
                return analysisBO;
            }
        });
    }

    public void updateDirectoryId(long newDirectoryId, long id) {
        String sql = "UPDATE " + this.getTable() + " SET FDIRECTORYID = ?, FUPDATETIME = ? WHERE FID = ?";
        this.execute(sql, new Object[]{newDirectoryId, new Date(), id});
    }

    public void updateDirectoryId(long newDirectoryId, Set<Long> ids) {
        String sql = "UPDATE " + this.getTable() + " SET FDIRECTORYID = ?, FUPDATETIME = ? WHERE FID IN (" + this.getQuestionStr(ids.size()) + ")";
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        params.add(Long.valueOf(newDirectoryId));
        params.add(new Date());
        params.addAll(ids);
        this.execute(sql, params.toArray());
    }

    public List<AnalysisDO> findDemoMapByUnionIds(Set<String> unionIds) {
        String sql = this.getSelectedSql() + "WHERE FUNIONID IN (" + this.getQuestionStr(unionIds.size()) + ") AND FISDEMO = ? AND FISDELETED = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(unionIds);
        params.add(this.convertBoolToString(true));
        params.add(this.convertBoolToString(false));
        return this.queryList(sql, params.toArray());
    }

    public List<AnalysisDO> findDirMapByPublishIds(List<String> publishIds) {
        String sql = "SELECT FID, FDIRECTORYID FROM " + this.getTable() + " WHERE FPUBLISHID IN (" + this.getQuestionStr(publishIds.size()) + ") AND FISDELETED = ?";
        ArrayList<String> params = new ArrayList<String>(publishIds);
        params.add(this.convertBoolToString(false));
        return this.queryList(sql, params.toArray(), (IResultGetter)new IResultGetter<AnalysisDO>(){

            public AnalysisDO getResult(ResultSet rs) throws SQLException {
                AnalysisDO analysisDO = new AnalysisDO();
                analysisDO.setId(rs.getLong("FID"));
                analysisDO.setDirectoryId(Long.valueOf(rs.getLong("FDIRECTORYID")));
                return analysisDO;
            }
        });
    }

    public List<AnalysisDO> findByUnionIdAndIsDeleted(String unionId, boolean isDeleted) {
        String sql = this.getSelectedSql() + "WHERE FUNIONID = ? AND FISDELETED = ?";
        return this.queryList(sql, new Object[]{unionId, this.convertBoolToString(isDeleted)});
    }

    public AnalysisDO findByDirectoryIdAndNameAndIsDeleted(long directoryId, String name, boolean isDeleted) {
        String sql = this.getSelectedSql() + "WHERE FDIRECTORYID = ? AND FNAME = ? AND FISDELETED = ?";
        return (AnalysisDO)this.query(sql, new Object[]{directoryId, name, this.convertBoolToString(isDeleted)});
    }

    public List<AnalysisDO> findByUnionIdAndIsDemo(String unionId, boolean isDemo) {
        String sql = this.getSelectedSql() + "WHERE FUNIONID = ? AND FISDEMO = ?";
        return this.queryList(sql, new Object[]{unionId, this.convertBoolToString(isDemo)});
    }

    public List<AnalysisDO> findByUnionIdAndPublishIds(String unionId, Set<String> publishIds) {
        String sql = "SELECT FID, FPUBLISHID, FDIRECTORYID, FNAME FROM " + this.getTable() + " WHERE FUNIONID = ? AND FPUBLISHID IN (" + this.getQuestionStr(publishIds.size()) + ") AND FISDELETED = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(unionId);
        params.addAll(publishIds);
        params.add(this.convertBoolToString(false));
        return this.queryList(sql, params.toArray(), (IResultGetter)new IResultGetter<AnalysisDO>(){

            public AnalysisDO getResult(ResultSet rs) throws SQLException {
                AnalysisDO analysisDO = new AnalysisDO();
                analysisDO.setId(rs.getLong("FID"));
                analysisDO.setPublishId(rs.getString("FPUBLISHID"));
                analysisDO.setDirectoryId(Long.valueOf(rs.getLong("FDIRECTORYID")));
                analysisDO.setName(rs.getString("FNAME"));
                return analysisDO;
            }
        });
    }

    public List<String> findByUnionIdWithoutPush(String unionId, long pushDirectoryId) {
        String sql = "SELECT FPUBLISHID FROM " + this.getTable() + " WHERE FUNIONID = ? AND FDIRECTORYID != ? AND FISDELETED = ?";
        return this.queryList(sql, new Object[]{unionId, pushDirectoryId, this.convertBoolToString(false)}, (IResultGetter)new IResultGetter<String>(){

            public String getResult(ResultSet rs) throws SQLException {
                return rs.getString("FPUBLISHID");
            }
        });
    }

    public List<Object[]> findDirNameByPublishIds(List<String> publishIds) {
        String sql = "SELECT A.FID, A.FPUBLISHID, A.FDIRECTORYID, A.FNAME, A.FUNIONID, A.FVIEWTYPE, D.FNAME AS FDIRECTORYNAME FROM " + this.getTable() + " A INNER JOIN " + "t_qing_app_directory" + " D ON A.FDIRECTORYID = D.FID WHERE A.FPUBLISHID IN (" + this.getQuestionStr(publishIds.size()) + ") AND A.FISDELETED = ? ORDER BY A.FID";
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(publishIds);
        params.add(this.convertBoolToString(false));
        return this.queryList(sql, params.toArray(), (IResultGetter)new IResultGetter<Object[]>(){

            public Object[] getResult(ResultSet rs) throws SQLException {
                Object[] result = new Object[]{rs.getLong("FID"), rs.getString("FPUBLISHID"), rs.getLong("FDIRECTORYID"), rs.getString("FNAME"), rs.getString("FUNIONID"), rs.getString("FDIRECTORYNAME"), rs.getString("FVIEWTYPE")};
                return result;
            }
        });
    }

    public List<String> findByUnionIdAndDirectoryIdAndLikeName(String unionId, Long directoryId, String name) {
        String sql = "SELECT A.FNAME FROM " + this.getTable() + " A WHERE A.FUNIONID = ? AND A.FDIRECTORYID = ? AND A.FISDELETED = ? AND A.FNAME LIKE ?";
        return this.queryList(sql, new Object[]{unionId, directoryId, this.convertBoolToString(false), name + '%'}, (IResultGetter)new IResultGetter<String>(){

            public String getResult(ResultSet rs) throws SQLException {
                return rs.getString("FNAME");
            }
        });
    }

    public void updateById(long id, long directoryId, String name, String unionId) {
        String sql = "UPDATE " + this.getTable() + " SET FDIRECTORYID = ?, FNAME = ?, FUNIONID = ? WHERE FID = ? AND FISDELETED = ?";
        this.execute(sql, new Object[]{directoryId, name, unionId, id, this.convertBoolToString(false)});
    }

    protected AnalysisDO getDO(ResultSet rs) throws SQLException {
        AnalysisDO analysisDO = new AnalysisDO();
        analysisDO.setId(rs.getLong("FID"));
        analysisDO.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
        analysisDO.setUpdateTime((Date)rs.getTimestamp("FUPDATETIME"));
        analysisDO.setDirectoryId(Long.valueOf(rs.getLong("FDIRECTORYID")));
        analysisDO.setCreatorName(rs.getString("FCREATORNAME"));
        try {
            analysisDO.setProductType(ProductType.fromPersistance((String)rs.getString("FPRODUCTTYPE")));
        }
        catch (PersistentModelParseException persistentModelParseException) {
            // empty catch block
        }
        analysisDO.setName(rs.getString("FNAME"));
        analysisDO.setSchemaId(rs.getString("fschemaid"));
        analysisDO.setQsId(rs.getString("FQSID"));
        analysisDO.setPublishId(rs.getString("FPUBLISHID"));
        analysisDO.setLayoutType(rs.getString("FLAYOUTTYPE"));
        analysisDO.setDescription(rs.getString("FDESCRIPTION"));
        analysisDO.setUrl(rs.getString("FURL"));
        analysisDO.setLargeThumb(rs.getString("FLARGETHUMB"));
        analysisDO.setDemo(this.convertStringToBool(rs.getString("FISDEMO")));
        analysisDO.setDeleted(this.convertStringToBool(rs.getString("FISDELETED")));
        analysisDO.setViewType(ViewTypeEnum.fromPersistance((String)rs.getString("FVIEWTYPE")));
        analysisDO.setUnionId(rs.getString("FUNIONID"));
        analysisDO.setLandscape(this.convertStringToBool(rs.getString("FISLANDSCAPE")));
        analysisDO.setBottomAnnotation(rs.getString("FBOTTOMANNOTATION"));
        analysisDO.setDisplayStyle(DisplayStyleEnum.fromPersistance((String)rs.getString("FDISPLAYSTYLE")));
        return analysisDO;
    }

    protected String[] getFields() {
        return new String[]{"FID", "FCREATETIME", "FUPDATETIME", "FDIRECTORYID", "FCREATORNAME", "FPRODUCTTYPE", "FNAME", "FSCHEMAID", "FQSID", "FPUBLISHID", "FLAYOUTTYPE", "FDESCRIPTION", "FURL", "FLARGETHUMB", "FISDEMO", "FISDELETED", "FVIEWTYPE", "FUNIONID", "FISLANDSCAPE", "FBOTTOMANNOTATION", "FDISPLAYSTYLE"};
    }

    protected Map<String, Object> getFieldValue(AnalysisDO analysisDO) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("FID", analysisDO.getId());
        result.put("FCREATETIME", analysisDO.getCreateTime());
        result.put("FUPDATETIME", analysisDO.getUpdateTime());
        result.put("FDIRECTORYID", analysisDO.getDirectoryId());
        result.put("FCREATORNAME", analysisDO.getCreatorName());
        result.put("FPRODUCTTYPE", analysisDO.getProductType().toPersistance());
        result.put("FNAME", analysisDO.getName());
        result.put("FSCHEMAID", analysisDO.getSchemaId());
        result.put("FQSID", analysisDO.getQsId());
        result.put("FPUBLISHID", analysisDO.getPublishId());
        result.put("FLAYOUTTYPE", analysisDO.getLayoutType());
        result.put("FDESCRIPTION", analysisDO.getDescription());
        result.put("FURL", analysisDO.getUrl());
        result.put("FLARGETHUMB", analysisDO.getLargeThumb());
        result.put("FISDEMO", this.convertBoolToString(analysisDO.isDemo()));
        result.put("FISDELETED", this.convertBoolToString(analysisDO.isDeleted()));
        result.put("FVIEWTYPE", analysisDO.getViewType().toPersistance());
        result.put("FUNIONID", analysisDO.getUnionId());
        result.put("FISLANDSCAPE", this.convertBoolToString(analysisDO.isLandscape()));
        result.put("FBOTTOMANNOTATION", analysisDO.getBottomAnnotation());
        result.put("FDISPLAYSTYLE", analysisDO.getDisplayStyle().toPersistance());
        return result;
    }

    protected String getTable() {
        return TableHelper.getTableName(AnalysisDO.class);
    }

    public Integer getAnalysisInfosCountByDirIds(List<Long> directoryIds, String searchText, String filterType) {
        String sql = "SELECT COUNT(1) AS COUNT FROM t_qing_app_analysis A WHERE A.FDIRECTORYID in (" + this.getQuestionStr(directoryIds.size()) + ") AND #1 A.FISDELETED = '" + this.convertBoolToString(false) + "' ";
        sql = this.fixFilterType(sql, "#1", filterType);
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(directoryIds);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            params.add("%" + searchText + "%");
            sql = sql + " AND A.FNAME LIKE ?";
        }
        return (Integer)this.query(sql, params.toArray(), (IResultGetter)new IResultGetter<Integer>(){

            public Integer getResult(ResultSet rs) throws SQLException {
                return rs.getInt("COUNT");
            }
        });
    }

    public List<AnalysisDO> getAnalysisInfosByDirIds(List<Long> directoryIds, String searchText, String filterType, Integer offset, Integer pageSize) {
        String sql = "SELECT A.FID, A.FNAME, A.FDIRECTORYID, A.FCREATETIME, A.FCREATORNAME, A.FPUBLISHID, A.FVIEWTYPE FROM t_qing_app_analysis A WHERE A.FDIRECTORYID in (" + this.getQuestionStr(directoryIds.size()) + ") AND #1 A.FISDELETED = '" + this.convertBoolToString(false) + "' ";
        sql = this.fixFilterType(sql, "#1", filterType);
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(directoryIds);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            params.add("%" + searchText + "%");
            sql = sql + " AND A.FNAME LIKE ? ";
        }
        sql = sql + " ORDER BY A.FCREATETIME DESC ";
        sql = SqlPageBuilder.fixPageSql((String)sql, (Integer)offset, (Integer)pageSize);
        return this.queryList(sql, params.toArray(), (IResultGetter)new IResultGetter<AnalysisDO>(){

            public AnalysisDO getResult(ResultSet rs) throws SQLException {
                AnalysisDO analysisDO = new AnalysisDO();
                analysisDO.setId(rs.getLong("FID"));
                analysisDO.setName(rs.getString("FNAME"));
                analysisDO.setDirectoryId(Long.valueOf(rs.getLong("FDIRECTORYID")));
                analysisDO.setCreateTime((Date)rs.getTimestamp("FCREATETIME"));
                analysisDO.setCreatorName(rs.getString("FCREATORNAME"));
                analysisDO.setPublishId(rs.getString("FPUBLISHID"));
                analysisDO.setViewType(ViewTypeEnum.fromPersistance((String)rs.getString("FVIEWTYPE")));
                return analysisDO;
            }
        });
    }

    public Map<String, Integer> getPublishCountAggPath(String dataCenterUUID, String searchText, String filterType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT A.FDIRECTORYID, COUNT(1) AS COUNT FROM   (SELECT D.FID      FROM t_qing_app_datacenter DC INNER JOIN t_qing_app_dir_dc_r DR ON DC.FID = DR.FDATACENTERID              INNER JOIN t_qing_app_directory D ON DR.FDIRECTORYID = D.FID      WHERE DC.FDATACENTERUUID = ? AND D.FISDELETED = '" + this.convertBoolToString(false) + "'   ) D INNER JOIN " + "t_qing_app_analysis" + " A ON D.FID = A.FDIRECTORYID    WHERE #1 #2 A.FISDELETED = '" + this.convertBoolToString(false) + "' GROUP BY A.FDIRECTORYID";
        sql = this.fixFilterType(sql, "#1", filterType);
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(dataCenterUUID);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            sql = sql.replace("#2", " A.FNAME LIKE ? AND ");
            params.add("%" + searchText + "%");
        } else {
            sql = sql.replace("#2", "");
        }
        IDBExcuter dbExcuter = ContextManager.getCurrentDBExcuter();
        return (Map)dbExcuter.query(sql, params.toArray(), (ResultHandler)new ResultHandler<Map<String, Integer>>(){

            public Map<String, Integer> handle(ResultSet rs) throws SQLException {
                HashMap<String, Integer> lappCount = new HashMap<String, Integer>(10);
                while (rs.next()) {
                    lappCount.put(rs.getString("FDIRECTORYID"), rs.getInt("COUNT"));
                }
                return lappCount;
            }
        });
    }

    public List<AnalysisVO> getAnalysisInfosByPublishIds(List<String> publishIds) {
        String sql = "SELECT A.FID, A.FDIRECTORYID, A.FNAME AS PUBNAME, A.FPUBLISHID, D.FNAME AS DIRNAME FROM t_qing_app_analysis A LEFT JOIN t_qing_app_directory D ON A.FDIRECTORYID = D.FID WHERE A.FPUBLISHID in (" + this.getQuestionStr(publishIds.size()) + ") AND A.FISDELETED = '" + this.convertBoolToString(false) + "' ";
        return this.queryList(sql, publishIds.toArray(), (IResultGetter)new IResultGetter<AnalysisVO>(){

            public AnalysisVO getResult(ResultSet rs) throws SQLException {
                AnalysisVO analysisVO = new AnalysisVO();
                analysisVO.setName(rs.getString("PUBNAME"));
                analysisVO.setDirectoryId(rs.getLong("FDIRECTORYID"));
                analysisVO.setDirectoryName(rs.getString("DIRNAME"));
                analysisVO.setPublishId(rs.getString("FPUBLISHID"));
                return analysisVO;
            }
        });
    }

    private String fixFilterType(String sql, String replaceChar, String filterType) {
        sql = "ANALYSIS".equals(filterType) ? sql.replace(replaceChar, "A.FVIEWTYPE = '1' AND") : ("SQUARE".equals(filterType) ? sql.replace(replaceChar, "A.FVIEWTYPE = '2' AND") : ("DASHBOARD".equals(filterType) ? sql.replace(replaceChar, "A.FVIEWTYPE = '3' AND") : sql.replace(replaceChar, "")));
        return sql;
    }
}

