/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.AbstractCalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.ISerialObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.HotSpot;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public abstract class EmbedObject
extends AbstractCalculable
implements ISerialObject,
Comparable {
    private static final Logger logger = LogUtil.getPackageLogger(EmbedObject.class);
    public static final String EMBEDED_OBJ_VERSION_1_0 = "1.0";
    public static final String EMBEDED_OBJ_VERSION_1_1 = "1.1";
    public static final String EMBEDED_OBJ_VERSION_1_2 = "1.2";
    public static final int ANCHOR_TWO_CELL = 0;
    public static final int ANCHOR_ONE_CELL = 1;
    public static final int ANCHOR_ABSOLUTE = 2;
    private boolean _selected;
    protected Sheet _sheet;
    protected int _x;
    protected int _y;
    protected int _width;
    protected int _height;
    protected String _name;
    protected CellBlockNode anchorBlock;
    protected CellBlockNode _anchorCellLT;
    protected CellBlockNode _anchorCellRB;
    protected CellBlockNode _positionCellLT;
    protected CellBlockNode _positionCellRB;
    protected Point fromOffset = new Point();
    protected Point toOffset = new Point();
    protected int anchorMode = 0;
    private float lastScale;
    private boolean isCalcLast;
    private boolean isQueued2 = false;
    private boolean[] isSrcEmpty = new boolean[]{false, false, false, false};
    private Cell[] srcClls = new Cell[4];
    protected Object[] splitArray;

    public EmbedObject(Sheet sheet) {
        this._sheet = sheet;
        this.anchorBlock = CellBlockNode.getCellBlockNode((Sheet)sheet, (int)0, (int)0, (int)0, (int)0, (int)0);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public int getAnchorMode() {
        return this.anchorMode;
    }

    public void setAnchorMode(int anchorMode) {
        this.setBounds(this._x, this._y, this._width, this._height);
        this.anchorMode = anchorMode;
    }

    public String getAnchorCellLT() {
        if (this._anchorCellLT == null) {
            return null;
        }
        return SheetBaseMath.getBlockName((int)this._anchorCellLT.getRow(), (int)this._anchorCellLT.getCol(), (boolean)true, (boolean)false, (boolean)false);
    }

    public CellBlockNode getAnchorCellLTWithCell() {
        return this._anchorCellLT;
    }

    public CellBlockNode getAnchorCellRBWithCell() {
        return this._anchorCellRB;
    }

    public CellBlockNode getPositionCellLT() {
        return this._positionCellLT;
    }

    public CellBlockNode getPositionCellRB() {
        return this._positionCellRB;
    }

    public void setAnchorCellLT(String anchorCellLT) {
        try {
            this._anchorCellLT = SheetBaseMath.getArrayBlockNodes((Sheet)this._sheet, (String)anchorCellLT, (boolean)true)[0];
        }
        catch (Exception ex) {
            this._anchorCellLT = null;
        }
        this.setBounds(this._x, this._y, this._width, this._height);
    }

    public String getAnchorCellRB() {
        if (this._anchorCellRB == null) {
            return null;
        }
        return SheetBaseMath.getBlockName((int)this._anchorCellRB.getRow(), (int)this._anchorCellRB.getCol(), (boolean)true, (boolean)false, (boolean)false);
    }

    public void setAnchorCellRB(String anchorCellRB) {
        try {
            this._anchorCellRB = SheetBaseMath.getArrayBlockNodes((Sheet)this._sheet, (String)anchorCellRB, (boolean)true)[0];
        }
        catch (Exception ex) {
            this._anchorCellRB = null;
        }
        this.setBounds(this._x, this._y, this._width, this._height);
    }

    private void modulationOffset() {
        if (this._anchorCellLT != null) {
            this.fromOffset.x += SheetBaseMath.getColX((Sheet)this._sheet, (int)this._positionCellLT.getCol()) - SheetBaseMath.getColX((Sheet)this._sheet, (int)this._anchorCellLT.getCol());
            this.fromOffset.y += SheetBaseMath.getRowY((Sheet)this._sheet, (int)this._positionCellLT.getRow()) - SheetBaseMath.getRowY((Sheet)this._sheet, (int)this._anchorCellLT.getRow());
        }
        if (this._anchorCellRB != null) {
            this.toOffset.x += SheetBaseMath.getColX((Sheet)this._sheet, (int)this._positionCellRB.getCol()) - SheetBaseMath.getColX((Sheet)this._sheet, (int)this._anchorCellRB.getCol());
            this.toOffset.y += SheetBaseMath.getRowY((Sheet)this._sheet, (int)this._positionCellRB.getRow()) - SheetBaseMath.getRowY((Sheet)this._sheet, (int)this._anchorCellRB.getRow());
        }
    }

    boolean isSelected() {
        return this._selected;
    }

    void setSelected(boolean selected) {
        this._selected = selected;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setX(int x) {
        this.setBounds(x, this._y, this._width, this._height);
    }

    public void setY(int y) {
        this.setBounds(this._x, y, this._width, this._height);
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this._width, this._height);
    }

    public void setWidth(int w) {
        this.setBounds(this._x, this._y, w, this._height);
    }

    public void setHeight(int h) {
        this.setBounds(this._x, this._y, this._width, h);
    }

    public void setSize(int w, int h) {
        this.setBounds(this._x, this._y, w, h);
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean setBounds(int x, int y, int w, int h) {
        return this.setBounds(x, y, w, h, true);
    }

    public boolean setBounds(int x, int y, int w, int h, boolean updateAnchor) {
        boolean change = false;
        change = x != this._x || y != this._y || w != this._width || h != this._height;
        int oldx = this._x;
        int oldy = this._y;
        int oldw = this._width;
        int oldh = this._height;
        this._x = x;
        this._y = y;
        this._width = w;
        this._height = h;
        this.lastScale = this._sheet.getSheetOption().getScaleNoPercent();
        if (updateAnchor) {
            Point p = new Point(x, y);
            int row = SheetBaseMath.rowAtPoint((Sheet)this._sheet, (Point2D)p);
            int col = SheetBaseMath.colAtPoint((Sheet)this._sheet, (Point2D)p);
            Point p2 = new Point(this._x + this._width, this._y + this._height);
            int row2 = SheetBaseMath.rowAtPoint((Sheet)this._sheet, (Point2D)p2);
            int col2 = SheetBaseMath.colAtPoint((Sheet)this._sheet, (Point2D)p2);
            this.fromOffset.x = (int)((float)(x - SheetBaseMath.getColX((Sheet)this._sheet, (int)col)) / this.lastScale);
            this.fromOffset.y = (int)((float)(y - SheetBaseMath.getRowY((Sheet)this._sheet, (int)row)) / this.lastScale);
            this.toOffset.x = (int)((float)(p2.x - SheetBaseMath.getColX((Sheet)this._sheet, (int)col2)) / this.lastScale);
            this.toOffset.y = (int)((float)(p2.y - SheetBaseMath.getRowY((Sheet)this._sheet, (int)row2)) / this.lastScale);
            this.modulationOffset();
            this._positionCellLT = CellBlockNode.getCellBlockNode((Sheet)this._sheet, (int)row, (int)col, (int)row, (int)col, (int)0);
            this._positionCellRB = CellBlockNode.getCellBlockNode((Sheet)this._sheet, (int)row2, (int)col2, (int)row2, (int)col2, (int)0);
            CellBlockNode cb = CellBlockNode.getCellBlockNode((Sheet)this._sheet, (int)row, (int)col, (int)row2, (int)col2, (int)this.anchorBlock.getFlags());
            this.anchorBlock = this._sheet.setDependent((ICalculable)this, cb);
        }
        if (change) {
            this.boundsUpdated(oldx, oldy, oldw, oldh);
        }
        return change;
    }

    public void relayout() {
        if (this._sheet.isDisposed()) {
            this.setBounds(0, 0, 0, 0, false);
            return;
        }
        switch (this.anchorMode) {
            case 2: {
                float factor = this._sheet.getSheetOption().getScaleNoPercent() / this.lastScale;
                this.setBounds((int)((float)this._x * factor), (int)((float)this._y * factor), (int)((float)this._width * factor), (int)((float)this._height * factor), false);
                break;
            }
            case 1: {
                float scale = this._sheet.getSheetOption().getScaleNoPercent();
                CellBlockNode anchorCellLT = this._anchorCellLT;
                if (anchorCellLT == null) {
                    anchorCellLT = this._positionCellLT;
                }
                int scaledFromOffsetX = (int)((float)this.fromOffset.x * scale);
                int scaledFromOffsetY = (int)((float)this.fromOffset.y * scale);
                int abridgedFromOffsetX = scaledFromOffsetX;
                int abridgedFromOffsetY = scaledFromOffsetY;
                int x = SheetBaseMath.getColX((Sheet)this._sheet, (int)anchorCellLT.getCol()) + abridgedFromOffsetX;
                int y = SheetBaseMath.getRowY((Sheet)this._sheet, (int)anchorCellLT.getRow()) + abridgedFromOffsetY;
                float factor = scale / this.lastScale;
                this.setBounds(x, y, (int)((float)this._width * factor), (int)((float)this._height * factor), false);
                break;
            }
            case 0: {
                CellBlockNode anchorCellRB;
                float scale = this._sheet.getSheetOption().getScaleNoPercent();
                CellBlockNode anchorCellLT = this._anchorCellLT;
                if (anchorCellLT == null) {
                    anchorCellLT = this._positionCellLT;
                }
                if ((anchorCellRB = this._anchorCellRB) == null) {
                    anchorCellRB = this._positionCellRB;
                }
                int scaledFromOffsetX = (int)((float)this.fromOffset.x * scale);
                int scaledFromOffsetY = (int)((float)this.fromOffset.y * scale);
                int abridgedFromOffsetX = scaledFromOffsetX;
                int abridgedFromOffsetY = scaledFromOffsetY;
                int x = SheetBaseMath.getColX((Sheet)this._sheet, (int)anchorCellLT.getCol()) + abridgedFromOffsetX;
                int y = SheetBaseMath.getRowY((Sheet)this._sheet, (int)anchorCellLT.getRow()) + abridgedFromOffsetY;
                int scaledToOffsetX = (int)((float)this.toOffset.x * scale);
                int scaledToOffsetY = (int)((float)this.toOffset.y * scale);
                int abridgedToOffsetX = scaledToOffsetX;
                int abridgedToOffsetY = scaledToOffsetY;
                int w = SheetBaseMath.getColX((Sheet)this._sheet, (int)anchorCellRB.getCol()) + abridgedToOffsetX - x;
                int h = SheetBaseMath.getRowY((Sheet)this._sheet, (int)anchorCellRB.getRow()) + abridgedToOffsetY - y;
                this.setBounds(x, y, w, h, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad Embed Object AnchorMode!");
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public Rectangle getBounds(Rectangle rect) {
        if (rect == null) {
            return new Rectangle(this._x, this._y, this._width, this._height);
        }
        rect.setBounds(this._x, this._y, this._width, this._height);
        return rect;
    }

    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    public byte[] save() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream((OutputStream)bs);
        try {
            out.writeString(EMBEDED_OBJ_VERSION_1_2);
            if (this.anchorMode != 0) {
                this.setBounds(this._x, this._y, this._width, this._height);
            }
            out.writeInt(this._x);
            out.writeInt(this._y);
            out.writeInt(this._width);
            out.writeInt(this._height);
            out.writeInt(this.anchorMode);
            out.writeString(SheetBaseMath.getBlockA1Name((CellBlock)this.anchorBlock, (boolean)false));
            if (this._anchorCellLT != null) {
                out.writeString(SheetBaseMath.getBlockName((int)this._anchorCellLT.getRow(), (int)this._anchorCellLT.getCol(), (boolean)false, (boolean)false, (boolean)false));
            } else {
                out.writeString(null);
            }
            if (this._anchorCellRB != null) {
                out.writeString(SheetBaseMath.getBlockName((int)this._anchorCellRB.getRow(), (int)this._anchorCellRB.getCol(), (boolean)false, (boolean)false, (boolean)false));
            } else {
                out.writeString(null);
            }
            out.writeInt(this.fromOffset.x);
            out.writeInt(this.fromOffset.y);
            out.writeInt(this.toOffset.x);
            out.writeInt(this.toOffset.y);
            out.writeString(this._name);
            byte[] cus = this.saveCustom();
            out.writeInt(cus.length);
            out.write(cus);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    public void load(byte[] str, boolean create) {
        try {
            int y;
            int x;
            KDSDataInputStream is = new KDSDataInputStream((InputStream)new ByteArrayInputStream(str));
            String ver = is.readString();
            if (EMBEDED_OBJ_VERSION_1_0.equals(ver)) {
                x = is.readInt();
                y = is.readInt();
                int w = is.readInt();
                int h = is.readInt();
                this.setBounds(x, y, w, h);
            } else {
                x = is.readInt();
                y = is.readInt();
                int w = is.readInt();
                int h = is.readInt();
                this.anchorMode = is.readInt();
                this.setBounds(x, y, w, h, true);
                is.readString();
                if (EMBEDED_OBJ_VERSION_1_2.equals(ver)) {
                    String cell = is.readString();
                    if (!StringUtil.isEmptyString((String)cell)) {
                        this._anchorCellLT = SheetBaseMath.getArrayBlockNodes((Sheet)this._sheet, (String)cell, (boolean)false)[0];
                    }
                    if (!StringUtil.isEmptyString((String)(cell = is.readString()))) {
                        this._anchorCellRB = SheetBaseMath.getArrayBlockNodes((Sheet)this._sheet, (String)cell, (boolean)false)[0];
                    }
                }
                this.fromOffset.x = is.readInt();
                this.fromOffset.y = is.readInt();
                this.toOffset.x = is.readInt();
                this.toOffset.y = is.readInt();
            }
            this.setName(is.readString());
            int cusLen = is.readInt();
            byte[] cus = new byte[cusLen];
            is.read(cus);
            this.loadCustom(cus, create);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    public abstract HotSpot[] getHotSpots();

    public abstract boolean contains(int var1, int var2);

    public abstract void paintData(Graphics var1);

    public abstract void paintFocus(Graphics var1);

    public abstract Shape getOutLine(HotSpot var1, int var2, int var3);

    protected abstract void boundsUpdated(int var1, int var2, int var3, int var4);

    protected abstract byte[] saveCustom();

    protected abstract void loadCustom(byte[] var1, boolean var2);

    public boolean calc(ExprContext ctx) {
        if (!this.isCalcLast) {
            this.isCalcLast = true;
            return false;
        }
        this.reCycleClls();
        this.relayout();
        return true;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public Variant getValue() {
        return null;
    }

    public void updateExpr(boolean queue) {
    }

    public int getCalculableType() {
        return 5;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (this == obj) {
            return 0;
        }
        int cmp = 1;
        if (obj instanceof ICalculable && (cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType()) != 0) {
            return cmp;
        }
        if (cmp == 0) {
            if (this._anchorCellLT != null) {
                cmp = ((EmbedObject)obj)._anchorCellLT != null ? this._anchorCellLT.compareTo((Object)((EmbedObject)obj)._anchorCellLT) : 1;
            }
            if (cmp == 0 && this._anchorCellRB != null) {
                cmp = ((EmbedObject)obj)._anchorCellRB != null ? this._anchorCellRB.compareTo((Object)((EmbedObject)obj)._anchorCellRB) : 1;
            }
            return cmp;
        }
        return cmp;
    }

    public void setQueued(boolean isQueued) {
        super.setQueued(true);
        if (!this.isQueued2) {
            CellBlockNode[] cbs = new CellBlockNode[]{this._anchorCellLT, this._anchorCellRB, this._positionCellLT, this._positionCellRB};
            for (int i = 0; i < cbs.length; ++i) {
                this.prepare(cbs[i], i);
            }
            this.isQueued2 = true;
        }
    }

    private void prepare(CellBlockNode cb, int index) {
        if (cb == null) {
            return;
        }
        Cell cll = cb.getFirstCell(false);
        this.isSrcEmpty[index] = cll == null;
        if (this.isSrcEmpty[index]) {
            cll = cb.getFirstCell(true);
        } else {
            this.isSrcEmpty[index] = true;
        }
        this.srcClls[index] = cll;
        if (!cll.isQueued()) {
            cll.queue();
        }
    }

    private void reCycleClls() {
        CellBlockNode[] cbs = new CellBlockNode[]{this._anchorCellLT, this._anchorCellRB, this._positionCellLT, this._positionCellRB};
        for (int i = 0; i < cbs.length; ++i) {
            if (!this.isSrcEmpty[i]) continue;
            cbs[i].offset(this.srcClls[i].getRow() - cbs[i].getRow(), this.srcClls[i].getCol() - cbs[i].getCol());
            this.isSrcEmpty[i] = false;
            if (!this.srcClls[i].getRowObject().isEmpty()) continue;
            this.srcClls[i].getRowObject().setDelete(true);
        }
    }

    public void split(SpreadView[] splitViews, SpreadContext.PhysicalEmbedXListener listener) {
    }

    public void merge() {
    }
}

