/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.qing;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.QingGPTLicenseException;
import com.kingdee.bos.qing.common.exception.QingLicenseException;
import com.kingdee.bos.qing.common.exception.QingModelerLicenseException;
import com.kingdee.bos.qing.common.exception.QingReportLicenseException;
import com.kingdee.bos.qing.common.framework.web.AbstractQingAction;
import com.kingdee.bos.qing.common.framework.web.dependency.QingWebRequestDispatcher;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.init.QingInitializeHelper;
import com.kingdee.bos.qing.common.rpc.common.IRpcInvokerProxy;
import com.kingdee.bos.qing.common.rpc.common.QRpcInvocationHandler;
import com.kingdee.bos.qing.common.rpc.common.QRpcSystemApp;
import com.kingdee.bos.qing.common.rpc.common.RemoteInvokerProxy;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.strategy.license.QingLicenseCheckResult;
import com.kingdee.bos.qing.filesystem.manager.api.IQRpcQingFileReadHandler;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.URLUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.lang.Lang;
import kd.bos.mservice.qingshared.common.context.QingIntegratedContext;
import kd.bos.mservice.qingshared.common.session.QingSessionImpl;
import kd.bos.session.SessionKeys;
import kd.bos.tenant.TenantInfo;
import kd.bos.url.UrlService;
import kd.bos.web.qing.exception.FileUploadFailException;
import kd.bos.web.qing.impl.QingMServiceDispatcher;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class QingSharedAction
extends AbstractQingAction {
    protected static final String QING_LIGHTAPP_PUBLISHURL = "qing.lightapp.publishurl";
    protected static Set<String> SHARED_HTML_SET = new HashSet<String>();
    protected static final String QINGLICENSESERVICE = "QingLicenseService";
    protected static final String UTF_8 = "utf-8";
    protected static final String ERROR_CODE = "errorCode";
    protected static final String QING_SERVICE = "QingService";
    protected static final String DATA = "data";
    protected static final String NO_PERMISSION = "noPermission";
    protected static final String QING_MODELER_APPID = "qing_modeler";
    protected static final String CHECK_QING_MODELER_PERMISSION = "checkQingModelerPermission";
    protected static final String CHECK_QING_METRIC_LIBRARY_PERMISSION = "checkQingMetricLibraryPermission";
    protected static final String GET_MODEL_SET_PERMISSION_PRESET = "getModelSetPermissionAndPreset";
    protected static final String QING_MODELER_SERVICE = "QingModelerService";
    private static final Set<Locale> SUPPORTED;

    protected static final void checkLicense() throws AbstractQingException {
        int checkResult = (Integer)QingMServiceDispatcher.dispatch((String)"qing", (String)QINGLICENSESERVICE, (String)"checkLicence", (Object[])new Object[0]);
        switch (checkResult) {
            case 0: {
                return;
            }
            case 0x2DEDD2: {
                throw QingLicenseException.NoLicenseException;
            }
            case 3010003: {
                throw QingLicenseException.NotRegisteredUserException;
            }
        }
        throw new QingLicenseException("check Qing Analaysis License failed");
    }

    protected static final void checkQingReportLicense() throws AbstractQingException {
        int checkResult = (Integer)QingMServiceDispatcher.dispatch((String)"qing_rpt", (String)QINGLICENSESERVICE, (String)"checkQingReportLicence", (Object[])new Object[0]);
        switch (checkResult) {
            case 0: {
                return;
            }
            case 3010005: {
                throw QingReportLicenseException.NoLicenseException;
            }
            case 3010006: {
                throw QingReportLicenseException.NotRegisteredUserException;
            }
        }
        throw new QingReportLicenseException("check Qing Report License failed");
    }

    protected static final void checkQingModelerLicense() throws QingModelerLicenseException {
        int checkResult = (Integer)QingMServiceDispatcher.dispatch((String)QING_MODELER_APPID, (String)QINGLICENSESERVICE, (String)"checkQingModelerLicense", (Object[])new Object[0]);
        switch (checkResult) {
            case 0: {
                return;
            }
            case 3010008: {
                throw QingModelerLicenseException.NoLicenseException;
            }
            case 0x2DEDDD: {
                throw QingModelerLicenseException.NonsupportException;
            }
        }
        throw new QingModelerLicenseException("check Qing Modeler License failed");
    }

    protected static final void checkQingGPTLicense() throws AbstractQingException {
        int checkResult = (Integer)QingMServiceDispatcher.dispatch((String)"qing", (String)QINGLICENSESERVICE, (String)"checkQingGPTLicence", (Object[])new Object[0]);
        switch (checkResult) {
            case 0: {
                return;
            }
            case 3010009: {
                throw QingGPTLicenseException.NoLicenseException;
            }
            case 3010010: {
                throw QingGPTLicenseException.NotRegisteredUserException;
            }
        }
        throw new QingGPTLicenseException("check Qing GPT License failed");
    }

    protected static final void checkLicenseForEmbeded(String billFormId, String pageId, String ctrlKey) throws AbstractQingException {
        int checkResult = (Integer)QingMServiceDispatcher.dispatch((String)"qing", (String)QINGLICENSESERVICE, (String)"checkEmbeddedLicence", (Object[])new Object[]{billFormId, pageId, ctrlKey});
        switch (checkResult) {
            case 0: {
                return;
            }
            case 0x2DEDD2: {
                throw QingLicenseException.NoLicenseException;
            }
            case 3010003: {
                throw QingLicenseException.NotRegisteredUserException;
            }
        }
        throw new QingLicenseException("check License failed");
    }

    protected static final void checkLicenseForPublish(String appId, String publishId) throws AbstractQingException {
        QingLicenseCheckResult qingLicenseCheckResult = (QingLicenseCheckResult)QingMServiceDispatcher.dispatch((String)appId, (String)QINGLICENSESERVICE, (String)"checkLicenseForPublish", (Object[])new Object[]{publishId});
        QingSharedAction.parsePublishLicenseCheckResult(qingLicenseCheckResult);
    }

    protected static final void checkLicenseForPush(String pushTarget, String configId) throws AbstractQingException {
        QingLicenseCheckResult qingLicenseCheckResult = (QingLicenseCheckResult)QingMServiceDispatcher.dispatch((String)"qing", (String)QINGLICENSESERVICE, (String)"checkLicenseForPush", (Object[])new Object[]{pushTarget, configId});
        QingSharedAction.parsePublishLicenseCheckResult(qingLicenseCheckResult);
    }

    protected boolean checkQingModelerPermission(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resultMap = QingSharedAction.handlerQingMServiceDispatcher(QING_MODELER_APPID, QING_MODELER_SERVICE, CHECK_QING_MODELER_PERMISSION, new Object[0]);
        if (resultMap.containsKey(ERROR_CODE)) {
            this.handlerError(request, response, resultMap.get(ERROR_CODE).toString(), "");
            return false;
        }
        boolean haveAuthority = (Boolean)resultMap.get(DATA);
        if (!haveAuthority) {
            this.handlerError(request, response, NO_PERMISSION, "");
            return false;
        }
        return true;
    }

    protected boolean checkQingMetricLibraryPermission(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resultMap = QingSharedAction.handlerQingMServiceDispatcher(QING_MODELER_APPID, QING_MODELER_SERVICE, CHECK_QING_METRIC_LIBRARY_PERMISSION, new Object[0]);
        if (resultMap.containsKey(ERROR_CODE)) {
            this.handlerError(request, response, resultMap.get(ERROR_CODE).toString(), "");
            return false;
        }
        boolean haveAuthority = (Boolean)resultMap.get(DATA);
        if (!haveAuthority) {
            this.handlerError(request, response, NO_PERMISSION, "");
            return false;
        }
        return true;
    }

    private static void parsePublishLicenseCheckResult(QingLicenseCheckResult qingLicenseCheckResult) throws AbstractQingException {
        if (qingLicenseCheckResult.isHasLicense()) {
            return;
        }
        String msg = qingLicenseCheckResult.getMessage();
        if (msg != null) {
            if (msg.equals(String.valueOf(0x2DEDD2))) {
                throw QingLicenseException.NoLicenseException;
            }
            if (msg.equals(String.valueOf(3010003))) {
                throw QingLicenseException.NotRegisteredUserException;
            }
            if (msg.equals(String.valueOf(3010005))) {
                throw QingReportLicenseException.NoLicenseException;
            }
            if (msg.equals(String.valueOf(3010006))) {
                throw QingReportLicenseException.NotRegisteredUserException;
            }
            throw new QingLicenseException(qingLicenseCheckResult.getMessage(), 1030001);
        }
        throw new QingLicenseException("check License failed");
    }

    protected static Map<String, Object> handlerQingMServiceDispatcher(String appID, String serviceName, String methodName, Object ... paras) {
        byte[] result = (byte[])QingMServiceDispatcher.dispatch((String)appID, (String)serviceName, (String)methodName, (Object[])paras);
        String res = new String(result, Charset.forName(UTF_8));
        Map resultMap = (Map)JsonUtil.decodeFromString((String)res, Map.class);
        Object errCodeObj = resultMap.get(ERROR_CODE);
        if (errCodeObj instanceof Double) {
            String errorCode = String.valueOf(((Double)errCodeObj).intValue());
            resultMap.put(ERROR_CODE, errorCode);
        }
        return resultMap;
    }

    public void doPolling(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sessionId = RequestContext.get().getGlobalSessionId();
        QingIntegratedContext qingContext = new QingIntegratedContext();
        AbstractQingAction.protectedDoPolling((HttpServletRequest)request, (IQingSession)new QingSessionImpl(sessionId), (QingContext)qingContext, (HttpServletResponse)response);
    }

    public void doRemoteProxy(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((QingContext)new QingIntegratedContext(), (String)"\u4ee3\u7406\u9875\u9762", (String)"agentPage", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS), "remote-proxy.html");
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterVale = request.getParameter(parameterName);
            if ("path".equals(parameterName)) continue;
            safetyURL.appendParamToUrl(parameterName, parameterVale);
        }
        safetyURL.sendRedirect(response);
    }

    public void doSafetyUrl(HttpServletRequest request, HttpServletResponse response) {
        try {
            QingIntegratedContext qingContext = new QingIntegratedContext();
            super.protectedSafetyUrl(request, response, (QingContext)qingContext);
        }
        catch (IOException e) {
            this.handlerException(request, response, e);
        }
    }

    public void doErrorEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.setCharacterEncoding("UTF-8");
            response.setContentType("text/html;charset=UTF-8");
            String errorCode = request.getParameter(ERROR_CODE);
            String errorMessage = request.getParameter("errorMessage");
            String sPromptMessage = request.getParameter("sPromptMessage");
            String sDetailMessage = request.getParameter("sDetailMessage");
            String sExhibitScene = request.getParameter("sExhibitScene");
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((QingContext)new QingIntegratedContext(), (String)"\u9519\u8bef\u63d0\u793a\u9875\u9762", (String)"errorPage", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS), "error.html");
            if (StringUtils.isNotBlank((CharSequence)errorCode)) {
                safetyURL.appendParamToUrl(ERROR_CODE, errorCode);
            }
            if (errorMessage != null) {
                errorMessage = StringUtils.decodeBase64ToString((String)errorMessage);
                errorMessage = URLDecoder.decode(errorMessage, UTF_8);
                safetyURL.appendParamToUrl("errorMessage", errorMessage);
            }
            if (sPromptMessage != null) {
                safetyURL.appendParamToUrl("sPromptMessage", sPromptMessage);
            }
            if (sDetailMessage != null) {
                safetyURL.appendParamToUrl("sDetailMessage", sDetailMessage);
            }
            if (sExhibitScene != null) {
                safetyURL.appendParamToUrl("sExhibitScene", sExhibitScene);
            }
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerException(request, response, e);
        }
    }

    public void doProfilerEntrance(HttpServletRequest request, HttpServletResponse response) {
        try {
            AbstractQingAction.ISafetyURL safetyURL = this.createSafetyURL(request, Messages.getMLS((QingContext)new QingIntegratedContext(), (String)"\u6027\u80fd\u76d1\u63a7\u5668", (String)"performanceMonitor", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS), "qing-profiler.html");
            safetyURL.sendRedirect(response);
        }
        catch (Throwable e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadHeapDumpFile(HttpServletRequest request, HttpServletResponse response) {
        String fileName = request.getParameter("fileName");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fileName", fileName);
        params.put("qingTempFileType", QingTempFileType.EXPORT.getSubFolder());
        RemoteInvokerProxy invokerProxy = null;
        IQRpcQingFileReadHandler fileReader = null;
        ServletOutputStream outputStream = null;
        try {
            byte[] datas;
            byte[] results = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)new QingIntegratedContext(), (String)this.getAppID(), (String)"/qingshared/profile.do", (String)"prepareFileReadHandler", (Object[])new Object[]{params});
            String url = new String(results, Charset.forName(UTF_8));
            String[] detail = url.split("/");
            if (detail.length != 2) {
                throw new RuntimeException("prepare file read handler failed,illegal url:" + url);
            }
            String ipAndPort = detail[0];
            String invokerId = detail[1];
            String ip = ipAndPort.split(":")[0];
            String port = ipAndPort.split(":")[1];
            invokerProxy = new RemoteInvokerProxy(QRpcSystemApp.Qing, invokerId, ip, Integer.parseInt(port), true);
            fileReader = (IQRpcQingFileReadHandler)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IQRpcQingFileReadHandler.class}, (InvocationHandler)new QRpcInvocationHandler((IRpcInvokerProxy)invokerProxy, 15000L));
            int fetchSize = 0x100000;
            try {
                fileName = URLEncoder.encode(fileName, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
                fileName = System.currentTimeMillis() + "";
            }
            response.setHeader("Content-Type", "application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            outputStream = response.getOutputStream();
            while (null != (datas = fileReader.readNext(fetchSize)) && datas.length > 0) {
                outputStream.write(datas);
                outputStream.flush();
                if (datas.length >= fetchSize) continue;
                break;
            }
        }
        catch (Exception e) {
            try {
                this.handlerException(request, response, e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outputStream});
                if (null != fileReader) {
                    fileReader.close();
                }
                if (null != invokerProxy) {
                    invokerProxy.close();
                }
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{outputStream});
            if (null != fileReader) {
                fileReader.close();
            }
            if (null != invokerProxy) {
                invokerProxy.close();
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{outputStream});
        if (null != fileReader) {
            fileReader.close();
        }
        if (null != invokerProxy) {
            invokerProxy.close();
        }
    }

    public void downloadAsyncProfilerFile(HttpServletRequest request, HttpServletResponse response) {
        try {
            String fileName = request.getParameter("fileName");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fileName", fileName);
            byte[] results = (byte[])QingWebRequestDispatcher.synDispatcher((QingContext)new QingIntegratedContext(), (String)this.getAppID(), (String)"/qingshared/profile.do", (String)"downloadAsyncProfilerFile", (Object[])new Object[]{params});
            try {
                fileName = URLEncoder.encode(fileName, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
                fileName = System.currentTimeMillis() + "";
            }
            response.setHeader("Content-Type", "application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.getOutputStream().write(results);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (Throwable e) {
            this.handlerExceptionForClosable(request, response, e);
        }
    }

    public void checkUploadFile(FileItem fileItem) throws FileUploadException, IOException, FileUploadFailException {
        HashMap<String, String> fileFormat = new HashMap<String, String>(64);
        String baseZipHead = "504B0304";
        fileFormat.put("png", "89504E47");
        fileFormat.put("jpg", "FFD8FF");
        fileFormat.put("jpeg", "FFD8FF");
        fileFormat.put("bmp", "424D");
        fileFormat.put("gif", "47494638");
        fileFormat.put("csv", "");
        fileFormat.put("txt", "");
        fileFormat.put("xls", "D0CF11");
        fileFormat.put("xlsx", "504B0304");
        fileFormat.put("xml", "");
        fileFormat.put("accdb", "");
        fileFormat.put("mdb", "");
        fileFormat.put("db", "");
        fileFormat.put("qing-pkg", "504B0304");
        fileFormat.put("qing-theme-pkg", "504B0304");
        fileFormat.put("qing-macro", "504B0304");
        fileFormat.put("qhf", "504B0304");
        fileFormat.put("qing-map", "504B0304");
        fileFormat.put("qing-pic", "504B0304");
        fileFormat.put("qing-font", "504B0304");
        fileFormat.put("qing-rpt", "504B0304");
        fileFormat.put("kds", "236B6473");
        fileFormat.put("kdsql", "");
        fileFormat.put("qing-md", "504B0304");
        fileFormat.put("qing-mds", "504B0304");
        fileFormat.put("ttf", "00100000");
        fileFormat.put("ttc", "74746366");
        fileFormat.put("otf", "4F54544F");
        fileFormat.put("woff", "774F4646");
        fileFormat.put("woff2", "774F4632");
        HashSet<String> imgSet = new HashSet<String>(Arrays.asList("jpg", "jpeg", "png", "bmp", "gif"));
        HashSet<String> flatFileSet = new HashSet<String>(Arrays.asList("csv", "txt", "xls", "xlsx", "xml"));
        HashSet<String> dbFileSet = new HashSet<String>(Arrays.asList("accdb", "mdb", "db"));
        HashSet<String> importSet = new HashSet<String>(Arrays.asList("qing-pkg", "qing-pic", "qing-theme-pkg", "qing-macro", "qing-map", "qing-rpt", "kds", "kdsql", "qing-md", "qing-mds", "qing-font"));
        HashSet<String> fontSet = new HashSet<String>(Arrays.asList("ttf", "otf", "ttc", "woff", "woff2"));
        HashSet<String> ignoreSizeLimit = new HashSet<String>(Collections.singletonList("qhf"));
        boolean accepted = false;
        String suffix = fileItem.getName().substring(fileItem.getName().lastIndexOf(".") + 1);
        suffix = suffix.toLowerCase();
        if (fileFormat.containsKey(suffix)) {
            InputStream inputStream = fileItem.getInputStream();
            byte[] b = new byte[8];
            inputStream.read(b, 0, b.length);
            String hexString = QingSharedAction.bytesToHexString(b);
            if (hexString != null) {
                String fileStart = hexString.toUpperCase();
                if (imgSet.contains(suffix)) {
                    for (String imgType : imgSet) {
                        if (!fileStart.contains((CharSequence)fileFormat.get(imgType))) continue;
                        accepted = true;
                        break;
                    }
                } else {
                    String fileHeader = (String)fileFormat.get(suffix);
                    if (!fileHeader.isEmpty()) {
                        if (fileStart.contains(fileHeader)) {
                            accepted = true;
                        }
                    } else {
                        accepted = true;
                    }
                }
            }
            if (!accepted) {
                throw new FileUploadFailException(Messages.getMLS((QingContext)new QingIntegratedContext(), (String)"incorrectFile", (String)"\u4e0a\u4f20\u6587\u4ef6\u7684\u683c\u5f0f\u4e0e\u6587\u4ef6\u6269\u5c55\u540d\u6307\u5b9a\u7684\u683c\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u3002", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS));
            }
            if (ignoreSizeLimit.contains(suffix)) {
                return;
            }
            String generalCategory = "";
            if (imgSet.contains(suffix)) {
                generalCategory = "img";
            } else if (flatFileSet.contains(suffix)) {
                generalCategory = "flatfile";
            } else if (dbFileSet.contains(suffix)) {
                generalCategory = "dbfile";
            } else if (importSet.contains(suffix)) {
                generalCategory = "import";
            } else if (fontSet.contains(suffix)) {
                generalCategory = "fontfile";
            }
            accepted = this.checkFileSize(suffix, fileItem.getSize(), generalCategory);
            if (!accepted) {
                throw new FileUploadFailException(Messages.getMLS((QingContext)new QingIntegratedContext(), (String)"exceedMaxFileSize", (String)"\u4e0a\u4f20\u6587\u4ef6\u8d85\u51fa\u5927\u5c0f\u9650\u5236\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5927\u5c0f\u914d\u7f6e\u9879\u3002", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS));
            }
        } else {
            throw new FileUploadFailException(Messages.getMLS((QingContext)new QingIntegratedContext(), (String)"notSupportFileType", (String)"\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u7684\u6587\u4ef6\u3002", (Messages.ProjectName)Messages.ProjectName.QING_SHARED_WEBACTIONS));
        }
    }

    protected final AbstractQingAction.ISafetyURL createSafetyURL(HttpServletRequest request, String title, String targetURL) {
        String path = null;
        String oldPath = request.getParameter("path");
        if (StringUtils.isNotBlank((CharSequence)oldPath) && oldPath.equals(System.getProperty(QING_LIGHTAPP_PUBLISHURL))) {
            path = oldPath;
        }
        return this.createSafetyURL(request, title, targetURL, path);
    }

    protected final AbstractQingAction.ISafetyURL createSafetyURLWithRelativePath(HttpServletRequest request, String title, String targetURL) {
        String path = null;
        String oldPath = request.getParameter("path");
        if (StringUtils.isNotBlank((CharSequence)oldPath) && oldPath.equals(System.getProperty(QING_LIGHTAPP_PUBLISHURL))) {
            path = oldPath;
        }
        return this.createSafetyURL(request, title, targetURL, path);
    }

    protected AbstractQingAction.ISafetyURL createSafetyURL(HttpServletRequest request, String title, String targetURL, String path) {
        String accountId;
        String cdnUrl = System.getProperty("CDNURL");
        String fileSize = System.getProperty("qing.uploadfile.maxsize.flatfile");
        String pageId = request.getParameter("pageId");
        String appID = request.getParameter("appID");
        appID = StringUtils.isEmpty((CharSequence)appID) ? this.getAppID() : appID;
        AbstractQingAction.SafetyURL safetyURL = new AbstractQingAction.SafetyURL((QingContext)new QingIntegratedContext(), appID, title, QingSharedAction.createQingURL(path, pageId, "/qinganalysis/safetyUrl.do"), targetURL);
        safetyURL.appendParamToUrl("language", QingSharedAction.getLocale());
        String skin = request.getParameter("skin");
        if (skin == null) {
            skin = "ierp";
        }
        if ((accountId = request.getParameter("kdcdc")) == null) {
            accountId = request.getParameter("accountId");
        }
        safetyURL.appendParamToUrl("skin", skin);
        safetyURL.appendParamToUrl("appID", appID);
        safetyURL.appendParamToUrl("cdnUrl", cdnUrl);
        safetyURL.appendParamToUrl("flatFileSize", fileSize);
        safetyURL.appendParamToUrl("kdcdc", accountId);
        return safetyURL;
    }

    private static String getLocale() {
        RequestContext context = RequestContext.get();
        Lang lang = context.getLang();
        Locale langLocale = lang.getLocale();
        if (SUPPORTED.contains(langLocale)) {
            return langLocale.toString();
        }
        if (Locale.US.equals(langLocale)) {
            return Locale.ENGLISH.toString();
        }
        return context.getLang().name();
    }

    protected String getAppID() {
        return "qing";
    }

    private static String createQingURL(String path, String pageId, String baseURL) {
        if (StringUtils.isBlank((CharSequence)path) && (path = UrlService.getDomainContextUrl()).endsWith("/")) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        String sURL = path + baseURL;
        sURL = URLUtil.appendParamToUrl((String)sURL, (String)"path", (String)path);
        sURL = URLUtil.appendParamToUrl((String)sURL, (String)"pageId", (String)pageId);
        sURL = URLUtil.appendParamToUrl((String)sURL, (String)"cookieName", (String)QingSharedAction.getCookieName());
        return sURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatcherToUrl(HttpServletRequest request, HttpServletResponse response, String targetUrl) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        String appID = request.getParameter("appID");
        if (SHARED_HTML_SET.contains(targetUrl)) {
            appID = "qing";
        }
        InputStream inputStream = QingSharedAction.class.getResourceAsStream("/web/" + appID + "/" + targetUrl);
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream, outputStream});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream, outputStream});
    }

    protected final String getQingClosableErrorUrl() {
        return "closeable-error.html";
    }

    protected final String getQingErrorUrl() {
        return "error.html";
    }

    protected final IQingSession getQingSession(HttpServletRequest request) {
        return null;
    }

    private static String getCookieName() {
        RequestContext rc = RequestContext.get();
        TenantInfo tenantInfo = AccountUtils.getTenantByid((String)rc.getTenantId());
        try {
            return SessionKeys.getGlobalCookieSessionkey((String)tenantInfo.getId(), (String)rc.getAccountId());
        }
        catch (Throwable r) {
            LogUtil.error((Throwable)r);
            return SessionKeys.getGlobalCookieSessionkey((String)tenantInfo.getId());
        }
    }

    private boolean checkFileSize(String suffix, float sizeByte, String generalCategory) {
        boolean isLegalSize = false;
        String prefix = "qing.uploadfile.maxsize.";
        String prefixByCategory = "qing.uploadfile.defaultmaxsize";
        HashMap<String, String> defaultSizeLimitMap = new HashMap<String, String>();
        defaultSizeLimitMap.put("qing.uploadfile.defaultmaxsizeimg", "20");
        defaultSizeLimitMap.put("qing.uploadfile.defaultmaxsizeflatfile", "100");
        defaultSizeLimitMap.put("qing.uploadfile.defaultmaxsizedbfile", "100");
        defaultSizeLimitMap.put("qing.uploadfile.defaultmaxsizeimport", "100");
        defaultSizeLimitMap.put("qing.uploadfile.defaultmaxsizefontfile", "100");
        String fileSizeLimit = System.getProperty("qing.uploadfile.maxsize." + suffix);
        String fileSizeLimitByCategory = System.getProperty("qing.uploadfile.maxsize." + generalCategory);
        if (fileSizeLimit != null) {
            int sizeLimit = Integer.parseInt(fileSizeLimit);
            if (sizeByte / 1048576.0f <= (float)sizeLimit) {
                isLegalSize = true;
            }
        } else if (fileSizeLimitByCategory != null) {
            int sizeLimit = Integer.parseInt(fileSizeLimitByCategory);
            if (sizeByte / 1048576.0f <= (float)sizeLimit) {
                isLegalSize = true;
            }
        } else {
            String defaultSizeLimit = (String)defaultSizeLimitMap.get("qing.uploadfile.defaultmaxsize" + generalCategory);
            int sizeLimit = Integer.parseInt(defaultSizeLimit);
            if (sizeByte / 1048576.0f <= (float)sizeLimit) {
                isLegalSize = true;
            }
        }
        return isLegalSize;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        QingInitializeHelper.initializeOnStart();
        SHARED_HTML_SET.add("qing-profiler.html");
        SHARED_HTML_SET.add("remote-proxy.html");
        SUPPORTED = new HashSet<Locale>();
        SUPPORTED.add(Locale.SIMPLIFIED_CHINESE);
        SUPPORTED.add(Locale.TRADITIONAL_CHINESE);
        SUPPORTED.add(Locale.ENGLISH);
    }
}

