/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.bos.Context;
import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ExportAction;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.dd.DataPerspective;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.TransitionException;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseType;
import com.kingdee.cosmic.ctrl.ext.immit.bill.BillHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.bill.BillProp;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.DataWalkerHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.DataWalkerHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.immit.filter.IExtDatasetFilter;
import com.kingdee.cosmic.ctrl.ext.pd.ParameterPerspective;
import com.kingdee.cosmic.ctrl.ext.rd.ReportPerspective;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.inner.TextFileDatasetConfiger;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.io.WizardExport;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase.ReportViewConstraintsWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase.ShowcaseChooser;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetTextFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.FieldPermission;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.FieldPermissionException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageResult;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.workbench.persist.IIOProvider;
import com.kingdee.cosmic.ctrl.workbench.ui.Perspective;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class BasicExtCallback
implements IExtCallback {
    private static final Logger logger = LogUtil.getPackageLogger(BasicExtCallback.class);
    private KDExt _ext;
    KDFileChooser fileChooser;
    private FileFilter filter;
    private KDFileChooser transitionLocator;
    private KDFileChooser snapshotSaver;
    private ShowcaseConfigCollection collection = null;
    private String lastFilePath;
    private ShowcaseChooser chooser;
    private ReportViewConstraintsWizard wizardViewConstraints;

    public BasicExtCallback(KDExt ext) {
        this._ext = ext;
    }

    @Override
    public void closeNotify() {
    }

    @Override
    public void newTempletNotify() {
        ((ExportAction)this._ext.getExtActionManager().getAction("SHOW_EXPORT_WIZARD", true)).setPersistedFilePath(null);
        this.setShowcaseConfigCollection(null);
        this.setLastFilePath(null);
    }

    @Override
    public List fetchDataSets(Book nousebook) {
        if (this.fileChooser == null) {
            this.filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".txt");
                }

                @Override
                public String getDescription() {
                    return TextFileDatasetConfiger.getLocalText("txtFile");
                }
            };
            this.fileChooser = new KDFileChooser();
            this.fileChooser.setFileFilter(this.filter);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "txt"));
        }
        ArrayList<ExtDataSet> list = new ArrayList<ExtDataSet>();
        if (0 == this.fileChooser.showOpenDialog((Component)((Object)this._ext))) {
            File[] files = this.fileChooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String fileName = file.getName();
                int end = fileName.indexOf(46);
                if (end > 0) {
                    fileName = fileName.substring(0, end);
                }
                Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
                list.add(book.getDataSetManager().getExtDataSetFactory().getDataSet(book, ExtDataSetType.TXT, fileName, file.getPath()));
            }
        }
        return list;
    }

    @Override
    public byte[] getReportData() {
        return null;
    }

    @Override
    public boolean isEntryFromMenu() {
        return true;
    }

    @Override
    public boolean saveReportData(byte[] templet, boolean alwaysPopDialog) {
        ExportAction export = (ExportAction)this._ext.getExtActionManager().getAction("SHOW_EXPORT_WIZARD", true);
        if (alwaysPopDialog || StringUtil.isEmptyString((String)export.getPersistedFilePath())) {
            export.actionPerformed(new ActionEvent(this, 0, "Save"));
        } else {
            export.actionPerformed(new ActionEvent(this, 0, "DirectSave"));
        }
        if (this.collection != null) {
            String filePath = ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).getPersistedFilePath();
            this.collection.setLastFilePath(filePath);
            this.collection.saveShowcaseSchemes(ShowcaseUtil.toShowcaseConfigs(this.collection.toElement()), filePath);
        }
        return true;
    }

    @Override
    public IIOProvider getPerspectiveIOProvider(String perspectiveID) {
        return null;
    }

    @Override
    public IIOProvider getWorkbenchIOProvider() {
        return null;
    }

    @Override
    public IExtDatasetFilter fetchDataSetFilter(ExtDataSet[] datasets, ExecutionContext ctx) {
        return null;
    }

    @Override
    public Map fetchDataSetFactories(ExtDataSetType[] datatypes, ExecutionContext ctx) {
        HashMap<ExtDataSetType, ExtDataSetTextFactory> map = new HashMap<ExtDataSetType, ExtDataSetTextFactory>();
        map.put(ExtDataSetType.TXT, new ExtDataSetTextFactory());
        return map;
    }

    @Override
    public Map<String, IParameter> fetchDataSetParameters(ExtDataSet[] datasets, ExecutionContext ctx) {
        TreeMap<String, IParameter> map = new TreeMap<String, IParameter>();
        return map;
    }

    @Override
    public Map<String, IParameter> fetchCustomHyperLinkParams(String className, ExecutionContext ctx) {
        return null;
    }

    @Override
    public Map<String, String> checkCustomHyperLinkParams(String className, ExecutionContext ctx) {
        return null;
    }

    @Override
    public void cacheCustomHyperLinkParams(Map<String, Map<String, Object>> params, String targetClass) {
    }

    @Override
    public void cacheBillIds(Map<String, Object> billInfo, List<String> ignore) {
    }

    @Override
    public ReportProperties fetchTransitionTarget() {
        int status;
        if (this.transitionLocator == null) {
            this.transitionLocator = new KDFileChooser();
            this.transitionLocator.setFileSelectionMode(2);
            this.transitionLocator.setCurrentDirectory(new File("c:/kd/kds"));
            this.transitionLocator.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".kds");
                }

                @Override
                public String getDescription() {
                    return CtrlEXTMessages.getMLS("reportFile", "\u62a5\u8868\u6587\u4ef6(*.kds)");
                }
            });
        }
        if ((status = this.transitionLocator.showOpenDialog((Component)((Object)this._ext))) == 0) {
            File file = this.transitionLocator.getSelectedFile();
            return new ReportProperties(file.getAbsolutePath(), file.getName(), file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public BillProp fetchBillTarget() {
        return null;
    }

    @Override
    public void setSelectedBill(BillProp billProp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTransitionTargetData(ReportProperties fullName, ExecutionContext _ctx) {
        File file = new File(FilenameUtils.normalize((String)fullName.getId()));
        if (!file.exists()) {
            return new byte[0];
        }
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fis.read(bytes);
        }
        catch (Exception e) {
            byte[] byArray;
            try {
                byArray = new byte[]{};
            }
            catch (Throwable throwable) {
                CloseUtil.close(fis);
                throw throwable;
            }
            CloseUtil.close(fis);
            return byArray;
        }
        CloseUtil.close(fis);
        return bytes;
    }

    @Override
    public void saveAsExternalDataSets(ExtDataSet[] datasets) {
    }

    @Override
    public Map fetchSystemParameters() {
        return new HashMap();
    }

    @Override
    public boolean isCloudView() {
        return false;
    }

    @Override
    public ExtDataSet editDataSet(ExtDataSet dataset, Window parent) {
        return null;
    }

    @Override
    public ExtDataSet refreshDataSet(ExtDataSet dataset) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSnapshot(Book book) {
        int status;
        if (this.snapshotSaver == null) {
            this.snapshotSaver = new KDFileChooser();
            this.snapshotSaver.setFileSelectionMode(2);
            this.snapshotSaver.setCurrentDirectory(new File("c:/kd/snap"));
            this.snapshotSaver.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".snap");
                }

                @Override
                public String getDescription() {
                    return CtrlEXTMessages.getMLS("reportSnapshotFile", "\u62a5\u8868\u5feb\u7167\u6587\u4ef6(*.snap)");
                }
            });
        }
        if ((status = this.snapshotSaver.showSaveDialog(null)) == 0) {
            FileOutputStream os = null;
            try {
                byte[] data = ExecutorUtil.generateSnapShot(book);
                os = new FileOutputStream(this.snapshotSaver.getSelectedFile());
                os.write(data);
                os.close();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"err", (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close(os);
                    throw throwable;
                }
                CloseUtil.close(os);
            }
            CloseUtil.close(os);
        }
    }

    private ShowcaseConfigCollection fetchShowcaseConfigCollection() {
        String path;
        String filePath;
        if (this._ext != null) {
            this.lastFilePath = filePath = ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).getPersistedFilePath();
        } else {
            filePath = this.lastFilePath;
        }
        if (this.collection == null) {
            path = ShowcaseUtil.parseFilePath(filePath);
            this.lastFilePath = filePath;
            IXmlElement element = ShowcaseUtil.loadFile(path);
            this.collection = ShowcaseUtil.toShowcaseConfigs(ShowcaseUtil.toShowcaseConfigs(element), this.getShowcaseTypes());
        } else if (filePath != null && !filePath.equals(this.lastFilePath)) {
            path = ShowcaseUtil.parseFilePath(filePath);
            this.lastFilePath = filePath;
            IXmlElement element = ShowcaseUtil.loadFile(path);
            this.collection = ShowcaseUtil.toShowcaseConfigs(ShowcaseUtil.toShowcaseConfigs(element), this.getShowcaseTypes());
        }
        if (this.collection.getDefaultConfig() == null) {
            ShowcaseConfig templet = this.getTempletConfig();
            if (templet != null) {
                this.collection.setDefaultConfig(templet);
            } else {
                this.collection.setDefaultConfig(new ShowcaseConfig());
            }
        }
        return this.collection;
    }

    private ShowcaseConfig getTempletConfig() {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
        Book book = context.getBook();
        return ShowcaseUtil.toShowcaseConfig((String)book.getUserObjectValue("ShowcaseConfigTemplet"), new ShowcaseConfig());
    }

    private ShowcaseType[] getShowcaseTypes() {
        return new ShowcaseType[]{new ShowcaseType(CtrlEXTMessages.getMLS("userLevel", "\u7528\u6237\u7ea7"), 1), new ShowcaseType(CtrlEXTMessages.getMLS("systemLevel", "\u7cfb\u7edf\u7ea7"), 2)};
    }

    private String getShowcaseConfig(String defaultXml, boolean isDesign) {
        if (!isDesign) {
            String filePath = ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).getPersistedFilePath();
            if (this.collection == null) {
                this.collection = this.fetchShowcaseConfigCollection();
            } else if (filePath != null && !filePath.equals(this.lastFilePath)) {
                this.collection = this.fetchShowcaseConfigCollection();
            }
            if (this.wizardViewConstraints == null) {
                this.wizardViewConstraints = (ReportViewConstraintsWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportViewConstraints);
            }
            this.collection.setLastFilePath(filePath);
            this.wizardViewConstraints.setCollection(this.collection);
            ShowcaseConfig config = this.collection.getDefaultConfig();
            if (config != null) {
                return ShowcaseUtil.toShowcaseConfig(config.toElement());
            }
            return null;
        }
        if (this.collection == null) {
            this.collection = this.fetchShowcaseConfigCollection();
        }
        this.collection.setLastFilePath(this.lastFilePath);
        ShowcaseConfig config = new ShowcaseConfig();
        ShowcaseUtil.toShowcaseConfig(defaultXml, config);
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (this.chooser == null && w instanceof KDFrame) {
            this.chooser = new ShowcaseChooser((KDFrame)w, this.collection, this.getShowcaseTypes(), config.getRowSpans(), config.getColSpans());
        }
        if (this.chooser == null) {
            this.chooser = new ShowcaseChooser(null, this.collection, this.getShowcaseTypes(), config.getRowSpans(), config.getColSpans());
        }
        this.chooser.showDialog(config.getRowSpans(), config.getColSpans());
        if (this.chooser.fetchReturnValue() == 1) {
            return ShowcaseUtil.toShowcaseConfig(this.chooser.getCurrentShowcaseConfig().toElement());
        }
        return null;
    }

    @Override
    public String fetchShowcaseConfigWithID(String showcaseConfig, boolean isDesign) {
        return this.getShowcaseConfig(showcaseConfig, isDesign);
    }

    @Override
    public ReportProperties fetchCurrentReportProperties() {
        ReportProperties p = new ReportProperties(this.lastFilePath, null, null);
        p.setPublish(false);
        p.setPreview(true);
        p.setPrintPermitted(true);
        p.setExportPermitted(true);
        return p;
    }

    @Override
    public AbstractHyperLinkAssembler[] getContainerDefinedHyperLinkAssemblers() {
        AbstractHyperLinkAssembler[] assemblers = new AbstractHyperLinkAssembler[]{new BillHyperLinkAssembler(this._ext), new DataWalkerHyperLinkAssembler(this._ext)};
        return assemblers;
    }

    @Override
    public Map<String, IHyperLinkExec> getContainerDefinedHyperLinkExecs() {
        HashMap<String, IHyperLinkExec> execMap = new HashMap<String, IHyperLinkExec>(1);
        execMap.put("JAVA_JUMPER:", new DataWalkerHyperLinkExec());
        return execMap;
    }

    private void setShowcaseConfigCollection(ShowcaseConfigCollection collection) {
        this.collection = collection;
    }

    private void setLastFilePath(String path) {
        this.lastFilePath = path;
    }

    @Override
    public Object clone() {
        if (this.lastFilePath == null) {
            this.lastFilePath = ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).getPersistedFilePath();
        }
        BasicExtCallback clone = new BasicExtCallback(this._ext);
        clone.lastFilePath = this.lastFilePath;
        clone.collection = this.collection;
        return clone;
    }

    @Override
    public Object clone(ReportProperties props) {
        return this.clone();
    }

    @Override
    public List<ReferredImageModel> getResource(String[] params) {
        return null;
    }

    @Override
    public ReferredImageResult loadImageByUid(String reportId, String embedUid) {
        return null;
    }

    @Override
    public ReferredImageResult loadImageByFileName(String imageFileName) {
        return null;
    }

    @Override
    public String loadImageFullPathByFileName(String fileName) {
        return null;
    }

    @Override
    public ReferredImageResult loadImageByFullPath(String imageFullPath) {
        return null;
    }

    @Override
    public Object afterTransition(ReportProperties props) throws TransitionException {
        return null;
    }

    @Override
    public Object beforeTransition(ReportProperties props) throws TransitionException {
        return null;
    }

    @Override
    public Perspective getPerspective(String perspectiveName) {
        if ("Report Designer".equals(perspectiveName)) {
            return new ReportPerspective(this._ext, "Report Designer", "1.0.1");
        }
        if ("Parameter Designer".equals(perspectiveName)) {
            return new ParameterPerspective(this._ext, "Parameter Designer", "1.0.1");
        }
        if ("Data Designer".equals(perspectiveName)) {
            return new DataPerspective(this._ext, "Data Designer", "1.0.1");
        }
        return null;
    }

    @Override
    public void layoutFilterUIArgs(Book book) {
    }

    @Override
    public boolean saveScheduleModel(String systemid, String reportid, String fname) {
        return false;
    }

    @Override
    public void loadScheduleModel(String reportid) {
    }

    @Override
    public ISpreadWizzard showPushAndWarningWizard(Component parent) {
        return null;
    }

    @Override
    public boolean isMobileTemplate() {
        return false;
    }

    @Override
    public String getReportId() {
        return null;
    }

    @Override
    public void updateAuditTable(long executeTime) {
    }

    public boolean hasPermission(FieldPermission fieldP, ExecutionContext exeCtx) throws FieldPermissionException {
        return true;
    }

    @Override
    public IRptRuntimeCallback getRptRuntimeCallback(String reportId) {
        return null;
    }

    @Override
    public void refreshFIParams(Book template) {
    }

    @Override
    public List<IParameter>[] fetchSystemMacros() {
        return null;
    }

    public byte[] getReportData(ReportProperties fullName) {
        return this.getTransitionTargetData(fullName, null);
    }

    @Override
    public boolean isAuthorizedReport() {
        return false;
    }

    @Override
    public void saveAsExternalMacros(Book book) {
    }

    @Override
    public void showExtManagerListView() {
    }

    @Override
    public String getCloudRptUuid() {
        return null;
    }

    @Override
    public void showCloudRptCommentBox() {
    }

    @Override
    public boolean hasDemoAuth() {
        return false;
    }

    @Override
    public boolean deleteDemoDataAuth() {
        return false;
    }

    @Override
    public boolean isCloudRptCenterEnable(Context easCtx) {
        return false;
    }

    @Override
    public boolean checkCloudRptEnable() {
        return true;
    }

    @Override
    public void linkParamsDefaultValue(Object obj, ExecutionContext ctx) {
    }

    @Override
    public void cacheBookData(byte[] bytes) throws IOException {
    }

    @Override
    public void layoutCardSettingUI(Book book) {
    }

    @Override
    public void insertAuditExport(long executeTime) {
    }

    @Override
    public String getEntityPath(String formId, String appId) {
        return null;
    }
}

