/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.io.WizardImport;
import com.kingdee.cosmic.ctrl.swing.KDMenu;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

class ImportHistory
extends AbstractAction {
    private KDExt _ext;
    private WizardImport wizardImport;
    private boolean flag = true;

    public ImportHistory(KDExt ext) {
        this._ext = ext;
        this.addLastOpenHistory();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.wizardImport == null) {
            this.wizardImport = (WizardImport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Import, true);
        }
        if (e.getSource() instanceof KDMenu) {
            final String[] history = this.wizardImport.getUserOpenHistory();
            final KDMenu item = (KDMenu)e.getSource();
            item.removeAll();
            if (history != null) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        int length = history.length;
                        for (int i = 0; i < length; ++i) {
                            KDMenuItem child = new KDMenuItem((Action)new ReopenAction(history[i]));
                            item.add((JMenuItem)child);
                        }
                    }
                };
                SwingUtilities.invokeLater(t);
            }
        }
    }

    private void addLastOpenHistory() {
        String configDir = System.getProperty("user.dir");
        try {
            if (this.wizardImport == null) {
                this.wizardImport = (WizardImport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Import, true);
            }
            File f = new File(FilenameUtils.normalize((String)(configDir + File.separator + "OpenHistory.text")));
            try (BufferedReader reader = new BufferedReader(new FileReader(f));){
                String size = reader.readLine();
                if (StringUtil.isEmptyString((String)size)) {
                    return;
                }
                String[] history = new String[Integer.parseInt(size)];
                int l = history.length;
                for (int i = 0; i < l; ++i) {
                    history[i] = reader.readLine();
                }
                this.wizardImport.setUserOpenHistory(history);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flag = false;
    }

    private class ReopenAction
    extends AbstractAction {
        private String filePath;

        ReopenAction(String name) {
            this.filePath = name;
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImportHistory.this.wizardImport == null) {
                ImportHistory.this.wizardImport = (WizardImport)ImportHistory.this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Import, false);
            }
            if (ImportHistory.this.wizardImport == null) {
                return;
            }
            ImportHistory.this.wizardImport.openFile(this.filePath);
        }
    }
}

