/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageModel;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;

class InsertResourceAction
extends AbstractAction {
    private KDExt _ext;

    public InsertResourceAction(KDExt ext) {
        this._ext = ext;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<ReferredImageModel> resource = this._ext.getExtCallback().getResource(null);
        if (resource == null) {
            MessageDialog.show(null, (Object)CtrlEXTMessages.getMLS("imageNotFound", "\u9009\u62e9\u56fe\u7247\u4e0d\u5b58\u5728\uff01"), (String)CtrlEXTMessages.getMLS("msgTitle", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1);
        } else if (!resource.isEmpty()) {
            SpreadContext context = (SpreadContext)((Object)this.getValue("Default"));
            Sheet sheet = context.getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            CellBlock block = range.getBounds();
            int x = SheetBaseMath.getColX(sheet, block.getCol());
            int y = SheetBaseMath.getRowY(sheet, block.getRow());
            EmbedImage embedImage = new EmbedImage(sheet, resource.get(0));
            embedImage.setBounds(x, y, Integer.MAX_VALUE, Integer.MAX_VALUE);
            EmbedhLayer layer = sheet.getEmbedments(true);
            layer.addEmbed(embedImage);
            layer.selectEmbed(embedImage, 2);
        }
    }
}

