/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ExtActionManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.rd.RptPerspective;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.workbench.ui.Perspective;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

class NewAction
extends AbstractAction {
    private static final Logger logger = LogUtil.getPackageLogger(NewAction.class);
    private KDExt _ext;

    NewAction(KDExt ext) {
        this._ext = ext;
        this.putValue("Name", ExtActionManager.getLocalText("new", "\u65b0\u5efa"));
        this.putValue("ShortDescription", ExtActionManager.getLocalText("new", "\u65b0\u5efa"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
        IExtCallback extCallback = this._ext.getExtCallback();
        context.getStateManager().stopEditing();
        Perspective perspective = this._ext.getPerspective("Report Designer", false);
        if (perspective != null) {
            ((RptPerspective)perspective).getBeanBindManager().commitPropertySheetPanels();
        }
        if (context.getBook().isEncrypted()) {
            this.createNewTemplet(extCallback);
            return;
        }
        int mark = MessageUtil.msgboxYesNoCancel((Component)((Object)this._ext), CtrlEXTMessages.getMLS("saveFileConfirm", "\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u6587\u4ef6\uff1f"));
        if (mark == 0) {
            try {
                if (!extCallback.saveReportData(BookIOUtil.pack(context.getBook()), false)) {
                    return;
                }
                this.createNewTemplet(extCallback);
            }
            catch (IOException e1) {
                logger.error((Object)"err", (Throwable)e1);
            }
        } else if (mark == 1) {
            this.createNewTemplet(extCallback);
        }
    }

    private void createNewTemplet(IExtCallback extCallback) {
        extCallback.newTempletNotify();
        try {
            this._ext.refresh();
        }
        catch (Exception e) {
            MiscUtil.handleFileCheckingException(e, (Component)((Object)this._ext));
        }
    }
}

