/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.dd;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.IExtActionManager;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.dd.ui.view.DataTrimView;
import com.kingdee.cosmic.ctrl.ext.rd.ReportPerspective;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.ActionManager;
import com.kingdee.cosmic.ctrl.kds.impl.FacadeManager;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.swing.KDMenu;
import com.kingdee.cosmic.ctrl.swing.KDMenuBar;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.workbench.logic.TrimWidgetManager;
import com.kingdee.cosmic.ctrl.workbench.persist.IIOProvider;
import com.kingdee.cosmic.ctrl.workbench.persist.TrimDatabase;
import com.kingdee.cosmic.ctrl.workbench.ui.ITrimView;
import com.kingdee.cosmic.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.cosmic.ctrl.workbench.ui.Perspective;
import com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class DataPerspective
extends Perspective {
    public static final String Data_Widget_ID = "Data_Widget_ID";
    private SpreadContext _context;
    private KDExt _ext;
    private List _toolbars;
    private KDMenuBar _menu;

    public DataPerspective(KDExt ext, String perspectiveName, String version) {
        super(perspectiveName, version);
        this._ext = ext;
        this.init();
    }

    public DataPerspective(KDExt ext, String perspectiveName, String version, IIOProvider ioProvider) {
        super(perspectiveName, version, ioProvider);
        this._ext = ext;
        this.init();
    }

    private void init() {
        if (!this.isAutoInstantiated()) {
            DataTrimView trim = new DataTrimView();
            TrimWidgetViewport viewport = new TrimWidgetViewport(Data_Widget_ID, (ITrimView)trim);
            viewport.setTitle(CtrlEXTMessages.getMLS("dataDesigner", "\u6570\u636e\u8bbe\u8ba1\u5668"));
            this.registerTrimWidget(Data_Widget_ID, (ITrimWidget)viewport);
            TrimWidgetManager trimManager = this.getTrimWidgetManager();
            trimManager.addTrim((ITrimWidget)viewport);
            TrimDatabase.registerTrimWidget((ITrimWidget)viewport);
            this.persistToCache();
            trim.addBookChangeListener(this._ext);
            this._context = trim.getSpreadContext();
        } else {
            DataTrimView designerTrim = (DataTrimView)((TrimWidgetViewport)this.getTrimWidget(Data_Widget_ID)).getView();
            designerTrim.addBookChangeListener(this._ext);
            this._context = designerTrim.getSpreadContext();
        }
        FacadeManager tempManage = this._context.getFacadeManager();
        tempManage.putWizzard(FacadeManager.WIZZARD_Formula, this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Formula, true));
        tempManage.setErrorMessageBox(this._ext.getExtStatusBarManager());
    }

    public void requestFocus() {
        this._context.requestFocus();
    }

    public List getToolBars() {
        if (this._toolbars == null) {
            this._toolbars = new ArrayList();
            KDToolBar toolbar = this._context.getToolBarManager().getToolBar("style");
            toolbar.setFloatable(true);
            this._toolbars.add(toolbar);
            toolbar = this._context.getToolBarManager().getToolBar("common");
            toolbar.setFloatable(true);
            this._toolbars.add(toolbar);
        }
        return this._toolbars;
    }

    public KDMenuBar getMenuBar() {
        if (this._menu == null) {
            this._menu = new KDMenuBar();
            KDMenu _fileMenu = this.createFileMenu(ReportPerspective.getLocalText("file", "\u6587\u4ef6"));
            this._menu.add((JMenu)_fileMenu);
            KDMenu _toolMenu = this.createToolMenu(ReportPerspective.getLocalText("tool", "\u5de5\u5177"));
            this._menu.add((JMenu)_toolMenu);
            KDMenu _windowMenu = this.createWindowMenu(ReportPerspective.getLocalText("window", "\u7a97\u53e3"));
            this._menu.add((JMenu)_windowMenu);
        }
        return this._menu;
    }

    private KDMenu createFileMenu(String name) {
        KDMenu menu = new KDMenu(name + "(F)");
        menu.setMnemonic('F');
        IExtActionManager actionManager = this._ext.getExtActionManager();
        ActionWrapper action = new ActionWrapper(actionManager.getAction("EXT_NEW"));
        action.putValue("Name", CtrlEXTMessages.getMLS("newFile", "\u65b0\u5efa(N)..."));
        action.putValue("MnemonicKey", 78);
        menu.add((Action)action);
        menu.addSeparator();
        action = new ActionWrapper(actionManager.getAction("SHOW_IMPORT_WIZARD", true));
        action.putValue("Name", ReportPerspective.getLocalText("import", "\u5bfc\u5165\u6587\u4ef6") + "(I)...");
        action.putValue("MnemonicKey", 73);
        menu.add((JMenuItem)new KDMenuItem((Action)action));
        action = new ActionWrapper(actionManager.getAction("SHOW_EXPORT_WIZARD", true));
        action.putValue("Name", ReportPerspective.getLocalText("export", "\u5bfc\u51fa\u6587\u4ef6") + "(E)...");
        action.putValue("MnemonicKey", 69);
        menu.add((JMenuItem)new KDMenuItem((Action)action));
        menu.addSeparator();
        action = new ActionWrapper(actionManager.getAction("EXT_SAVE"));
        action.putValue("Name", CtrlEXTMessages.getMLS("saveFile", "\u4fdd\u5b58(S)..."));
        action.putValue("MnemonicKey", 83);
        menu.add((Action)action);
        action = new ActionWrapper(actionManager.getAction("EXT_SAVE_AS"));
        action.putValue("Name", CtrlEXTMessages.getMLS("saveAs2", "\u53e6\u5b58\u4e3a(A)..."));
        action.putValue("MnemonicKey", 65);
        menu.add((Action)action);
        menu.addSeparator();
        action = new ActionWrapper(actionManager.getAction("EXT_PREVIEW"));
        action.putValue("Name", CtrlEXTMessages.getMLS("reportPreview", "\u62a5\u8868\u9884\u89c8(P)..."));
        action.putValue("MnemonicKey", 80);
        menu.add((Action)action);
        menu.addSeparator();
        action = new ActionWrapper(actionManager.getAction("EXT_QUIT"));
        action.putValue("Name", CtrlEXTMessages.getMLS("exit2", "\u9000\u51fa(Q)"));
        action.putValue("MnemonicKey", 81);
        menu.add((Action)action);
        return menu;
    }

    private KDMenu createToolMenu(String name) {
        KDMenu menu = new KDMenu(name + "(T)");
        menu.setMnemonic('T');
        KDMenu protectMenu = new KDMenu(ReportPerspective.getLocalText("protect", "\u4fdd\u62a4") + "(P)");
        protectMenu.setMnemonic('P');
        ActionManager actionManager = this._context.getActionManager();
        ActionWrapper action = new ActionWrapper(actionManager.getAction("Show_ProtectSheet_Wizzard"));
        action.putValue("Name", ReportPerspective.getLocalText("protectSheet", "\u4fdd\u62a4\u5de5\u4f5c\u8868") + "(P)...");
        action.putValue("MnemonicKey", 80);
        protectMenu.add((JMenuItem)new KDMenuItem((Action)action));
        action = new ActionWrapper(actionManager.getAction("Show_ProtectRange_Wizzard"));
        action.putValue("Name", ReportPerspective.getLocalText("allowUserEdit", "\u5141\u8bb8\u7528\u6237\u7f16\u8f91\u533a\u57df") + "(A)...");
        action.putValue("MnemonicKey", 65);
        protectMenu.add((JMenuItem)new KDMenuItem((Action)action));
        action = new ActionWrapper(actionManager.getAction("Show_ProtectBook_Wizzard"));
        action.putValue("Name", ReportPerspective.getLocalText("protectBook", "\u4fdd\u62a4\u5de5\u4f5c\u7c3f") + "(W)...");
        action.putValue("MnemonicKey", 87);
        protectMenu.add((JMenuItem)new KDMenuItem((Action)action));
        menu.add((JMenuItem)protectMenu);
        return menu;
    }

    private KDMenu createWindowMenu(String name) {
        KDMenu menu = new KDMenu(name + "(W)");
        menu.setMnemonic('W');
        ActionManager tempActionManage = this._context.getActionManager();
        ActionWrapper action = new ActionWrapper(tempActionManage.getAction("Freeze"));
        action.putValue("Name", ReportPerspective.getLocalText("freeze", "\u51bb\u7ed3\u7a97\u683c") + "(F)");
        action.putValue("MnemonicKey", 70);
        menu.add((JMenuItem)new KDMenuItem((Action)action));
        action = new ActionWrapper(tempActionManage.getAction("Unfreeze"));
        action.putValue("Name", ReportPerspective.getLocalText("unfreeze", "\u53d6\u6d88\u51bb\u7ed3\u7a97\u683c") + "(U)");
        action.putValue("MnemonicKey", 85);
        menu.add((JMenuItem)new KDMenuItem((Action)action));
        return menu;
    }

    static class ActionWrapper
    extends AbstractAction {
        Action _innerAction;

        ActionWrapper(Action action) {
            this._innerAction = action;
            this.putValue("SmallIcon", this._innerAction.getValue("SmallIcon"));
        }

        @Override
        public boolean isEnabled() {
            if (this._innerAction == null) {
                return false;
            }
            return this._innerAction.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            if (this._innerAction != null) {
                this._innerAction.setEnabled(b);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._innerAction == null) {
                MessageUtil.msgboxInfo(null, CtrlEXTMessages.getMLS("unImplemented", "\u672a\u5b9e\u73b0"));
            } else {
                this._innerAction.actionPerformed(e);
            }
        }
    }
}

