/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit;

import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractExecutableHyperLinkExec
implements IHyperLinkExec {
    protected ExtGuiExecutor _guiExecutor;

    public void registerExtGuiExecutor(ExtGuiExecutor guiExecutor) {
        this._guiExecutor = guiExecutor;
    }

    protected Map executeFormula(Map target) {
        return null;
    }

    protected List executeCalculableProps(CommonCalculableProps prop) {
        Sheet sheet = this._guiExecutor.getSpreadContext().getBook().getActiveSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        Cell cell = sheet.getActiveCell();
        ArrayList<Variant> list = new ArrayList<Variant>();
        Variant variant = prop.calc(ctx, cell);
        if (variant.isArray()) {
            Variant[] variants = (Variant[])variant.getValue();
            int length = variants.length;
            for (int i = 0; i < length; ++i) {
                Object obj = variants[i].getValue();
                if (obj instanceof CellBlockNode) {
                    list.addAll(this.splitCellBlockToValue(sheet, (CellBlockNode)obj));
                    continue;
                }
                list.add(variants[i]);
            }
        } else if (variant.isObject()) {
            Object obj = variant.getValue();
            if (obj instanceof CellBlockNode) {
                list.addAll(this.splitCellBlockToValue(sheet, (CellBlockNode)obj));
            } else if (obj instanceof ExtGroup) {
                ExtGroup groups = (ExtGroup)obj;
                Variant[] values = groups.getValues();
                if (values != null) {
                    for (int i = values.length - 1; i >= 0; --i) {
                        list.add(values[i]);
                    }
                }
            } else {
                list.add(variant);
            }
        } else {
            list.add(variant);
        }
        return list;
    }

    private List splitCellBlockToValue(Sheet sheet, CellBlock block) {
        if (block == null) {
            return null;
        }
        ArrayList<Variant> list = new ArrayList<Variant>();
        int row = block.getRow();
        int row2 = block.getRow2();
        int col = block.getCol();
        int col2 = block.getCol2();
        for (int r = row; r <= row2; ++r) {
            for (int c = col; c <= col2; ++c) {
                Cell cell = sheet.getCell(r, c, false);
                if (cell == null) continue;
                list.add(cell.getValue());
            }
        }
        return list;
    }
}

