/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.DefObj;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.TransitionLinkTypePanel;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.dlg.FormulaWizardPopupForF7;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartInnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPromptBox;
import com.kingdee.cosmic.ctrl.swing.KDPromptSelector;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import com.kingdee.cosmic.ctrl.swing.event.SelectorEvent;
import com.kingdee.cosmic.ctrl.swing.event.SelectorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public abstract class AbstractExtLinkAssembler
extends KDPanel {
    protected KDWorkButton _delBtn;
    protected KDWorkButton _insertBtn;
    protected KDWorkButton _refreshParamBtn;
    private KDWorkButton _delParamBtn;
    private KDWorkButton _insertParamBtn;
    protected KDLabel _reportLbl;
    private KDLabel _paramLbl;
    protected KDTable _reportTable;
    protected KDTable _paramTable;
    protected KDExt _ext;
    protected KDWorkButton _insertInnerBtn;
    protected KDWorkButton _delInnerBtn;
    private KDLabel _innerLbl;
    protected KDTable _innerTable;
    private Color _locked = new Color(220, 220, 220);
    protected Map<String, IParameter> _lastSynced;
    protected Object[] _targets;
    private IRow _currentRow;
    protected static final int COL_R_DEFAULT = 0;
    protected static final int COL_R_PATH = 1;
    protected static final int COL_R_ALIAS = 2;
    protected static final int COL_I_TYPE = 0;
    protected static final int COL_I_NAME = 1;
    protected static final int COL_P_NAME = 0;
    protected static final int COL_P_VALUE = 1;
    protected static final int COL_P_ALIAS = 2;
    protected static final int COL_P_TYPE = 3;
    protected static final int COL_P_REQUIRD = 4;
    protected static final int COL_P_DEFAULT = 5;
    public static final String SEPARATOR = "!";
    protected KDPromptBox _targetFetcher;
    protected TargetRptSelector _rptSelector;
    private HashMap<String, InnerLinkTransitionTarget> _mapInnerTarget;
    protected KDLabel _labelParam;
    private String _linkType;
    protected FlashChartType _chartType;

    protected static final String getText() {
        return CtrlEXTMessages.getMLS("text", "\u6587\u672c");
    }

    protected static final String getNumber() {
        return CtrlEXTMessages.getMLS("number", "\u6570\u5b57");
    }

    protected static final String getDate() {
        return CtrlEXTMessages.getMLS("date", "\u65e5\u671f");
    }

    protected static final String getDateTime() {
        return CtrlEXTMessages.getMLS("timestamp", "\u65f6\u95f4\u6233");
    }

    protected static final String getTime() {
        return CtrlEXTMessages.getMLS("time", "\u65f6\u95f4");
    }

    protected static final String getBoolean() {
        return CtrlEXTMessages.getMLS("boolean", "\u5e03\u5c14");
    }

    protected static final String getUnkonw() {
        return CtrlEXTMessages.getMLS("unknown", "\u672a\u77e5");
    }

    public AbstractExtLinkAssembler(KDExt ext) {
        this._ext = ext;
        this.initComps();
        this.initListeners();
    }

    public AbstractExtLinkAssembler(KDExt ext, FlashChartType chartType) {
        this._ext = ext;
        this._chartType = chartType;
        this.initComps();
        this.initListeners();
    }

    protected void initComps() {
        ImageIcon iconDel = ResourceManager.getImageIcon("tbtn_Delete.gif");
        ImageIcon iconInsert = ResourceManager.getImageIcon("tbtn_Insert.gif");
        this._refreshParamBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Refresh.gif"));
        this._delBtn = new KDWorkButton((Icon)iconDel);
        this._insertBtn = new KDWorkButton((Icon)iconInsert);
        this._delParamBtn = new KDWorkButton((Icon)iconDel);
        this._insertParamBtn = new KDWorkButton((Icon)iconInsert);
        this._reportLbl = new KDLabel();
        this._paramLbl = new KDLabel();
        this._reportTable = new KDTable();
        this._reportTable.getScriptManager().setScriptDisabled(true);
        this._paramTable = new KDTable();
        this._paramTable.getScriptManager().setScriptDisabled(true);
        this._reportLbl.setText(CtrlEXTMessages.getMLS("linkedSettings", "\u8054\u67e5\u8bbe\u7f6e"));
        this._paramLbl.setText(CtrlEXTMessages.getMLS("parameterSettings", "\u53c2\u6570\u8bbe\u7f6e"));
        this._insertInnerBtn = new KDWorkButton((Icon)iconInsert);
        this._delInnerBtn = new KDWorkButton((Icon)iconDel);
        this._innerLbl = new KDLabel(CtrlEXTMessages.getMLS("linkageSettings", "\u8054\u52a8\u8bbe\u7f6e"));
        this._innerTable = new KDTable();
        this.initTables();
        this.setCustomInsets(new Insets(5, 5, 5, 5));
        TableLayout2 layout = new TableLayout2(6, 5);
        this.setLayout((LayoutManager)layout);
        layout.setFixedWidth(0, 150);
        layout.setRatableWidth(1, 1);
        layout.setFixedWidth(2, 22);
        layout.setFixedWidth(3, 22);
        layout.setFixedWidth(4, 22);
        layout.setFixedHeight(0, 22);
        layout.setRatableHeight(1, 1);
        layout.setFixedHeight(4, 22);
        layout.setRatableHeight(5, 1);
        layout.setRowSpacing(0, 5);
        layout.setRowSpacing(1, 10);
        layout.setRowSpacing(2, 0);
        layout.setRowSpacing(3, 0);
        layout.setRowSpacing(4, 5);
        layout.setColSpacing(3, 4);
        layout.setColSpacing(2, 4);
        layout.setFixedHeight(2, 0);
        layout.setFixedHeight(3, 0);
        this.add((Component)this._reportLbl, TableLayout2.param((int)0, (int)0));
        this.add((Component)this._delBtn, TableLayout2.param((int)0, (int)4));
        this.add((Component)this._insertBtn, TableLayout2.param((int)0, (int)3));
        this.add((Component)this._reportTable, TableLayout2.param((int)1, (int)0, (int)1, (int)4));
        this.add((Component)this._paramLbl, TableLayout2.param((int)4, (int)0));
        this.add((Component)this._delParamBtn, TableLayout2.param((int)4, (int)4));
        this.add((Component)this._insertParamBtn, TableLayout2.param((int)4, (int)3));
        this.add((Component)this._refreshParamBtn, TableLayout2.param((int)4, (int)2));
        this.add((Component)this._paramTable, TableLayout2.param((int)5, (int)0, (int)5, (int)4));
        this.add((Component)this._innerLbl, TableLayout2.param((int)2, (int)0));
        this.add((Component)this._delInnerBtn, TableLayout2.param((int)2, (int)4));
        this.add((Component)this._insertInnerBtn, TableLayout2.param((int)2, (int)3));
        this.add((Component)this._innerTable, TableLayout2.param((int)3, (int)0, (int)3, (int)4));
    }

    protected void initTables() {
        this._reportTable.getSelectManager().setSelectMode(2);
        this._reportTable.addColumns(3);
        IColumn colDefault = this._reportTable.getColumn(0);
        colDefault.setWidth(0);
        this._reportTable.getColumn(1).setWidth(275);
        this._reportTable.getColumn(2).setWidth(180);
        this._reportTable.addHeadRow();
        IRow headRow = this._reportTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("defaultExtend", "\u9ed8\u8ba4"));
        headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("reportPath", "\u62a5\u8868\u8def\u5f84"));
        headRow.getCell(2).setValue((Object)CtrlEXTMessages.getMLS("displayName", "\u663e\u793a\u540d\u79f0"));
        this._reportTable.getIndexColumn().getStyleAttributes().setHided(true);
        KDPromptBox f7FormulaWizard = this.createF7Component();
        this._reportTable.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7FormulaWizard));
        this._innerTable.getSelectManager().setSelectMode(2);
        this._innerTable.addColumns(2);
        this._innerTable.getColumn(1).setWidth(395);
        this._innerTable.addHeadRow();
        headRow = this._innerTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("dsType", "\u7c7b\u578b"));
        headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"));
        this._innerTable.getIndexColumn().getStyleAttributes().setHided(true);
        KDComboBox boxType = this.getBoxTargetType();
        this.noJump(boxType);
        this._innerTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxType));
        KDComboBox boxName = new KDComboBox();
        this.noJump(boxName);
        boxName.addItems((Object[])this.getInnerNameItems("fusionChart"));
        this._innerTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxName));
        boxType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (2 == e.getStateChange()) {
                    return;
                }
                IRow row = KDTableUtil.getSelectedRow((KDTable)AbstractExtLinkAssembler.this._innerTable);
                if (row == null) {
                    return;
                }
                Object ObjType = row.getCell(0).getValue();
                if (ObjType != null && e.getItem() == ObjType) {
                    return;
                }
                AbstractExtLinkAssembler.this.typeChanged(row, (DefObj)e.getItem());
            }
        });
        boxName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (2 == e.getStateChange()) {
                    return;
                }
                IRow row = KDTableUtil.getSelectedRow((KDTable)AbstractExtLinkAssembler.this._innerTable);
                if (row == null) {
                    return;
                }
                DefObj selectedItem = (DefObj)e.getItem();
                if (selectedItem == null) {
                    return;
                }
                String name = selectedItem.getName();
                DefObj objType = (DefObj)row.getCell(0).getValue();
                if (objType == null) {
                    return;
                }
                String typeName = objType.getName();
                InnerLinkTransitionTarget target = null;
                String key = AbstractExtLinkAssembler.this.createMapInnerTargetKey(row.getRowIndex(), typeName, name);
                if (AbstractExtLinkAssembler.this._mapInnerTarget == null) {
                    AbstractExtLinkAssembler.this._mapInnerTarget = new HashMap();
                    target = new InnerLinkTransitionTarget();
                    target.setTargetType(typeName);
                    AbstractExtLinkAssembler.this._mapInnerTarget.put(key, target);
                } else {
                    target = (InnerLinkTransitionTarget)AbstractExtLinkAssembler.this._mapInnerTarget.get(key);
                    if (target == null) {
                        target = new InnerLinkTransitionTarget();
                        target.setTargetType(typeName);
                        AbstractExtLinkAssembler.this._mapInnerTarget.put(key, target);
                    }
                }
                AbstractExtLinkAssembler.this.setParamTable(target, selectedItem);
            }
        });
        this._reportTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        ActionMap am = this._reportTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        this._targetFetcher = new KDPromptBox();
        this._targetFetcher.setHistoryRecordEnabled(false);
        this._rptSelector = new TargetRptSelector();
        this._targetFetcher.setSelector((KDPromptSelector)this._rptSelector);
        this._reportTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this._targetFetcher));
        this.initParamTable();
    }

    private void typeChanged(IRow row, DefObj defType) {
        this._paramTable.removeRows();
        int rowIndex = row.getRowIndex();
        KDComboBox boxName = (KDComboBox)this._innerTable.getCellEditor(rowIndex, 1).getComponent();
        boxName.removeAllItems();
        String targetType = defType.getName();
        boxName.addItems((Object[])this.getInnerNameItems(targetType));
        DefObj defObj = (DefObj)boxName.getItemAt(0);
        row.getCell(1).setValue((Object)defObj);
        this.removeKeyStartWidth(rowIndex);
        if (defObj == null) {
            return;
        }
        if (this._mapInnerTarget == null) {
            this._mapInnerTarget = new HashMap();
        }
        String key = this.createMapInnerTargetKey(rowIndex, targetType, defObj.getName());
        InnerLinkTransitionTarget target = new InnerLinkTransitionTarget();
        target.setTargetType(targetType);
        this._mapInnerTarget.put(key, target);
        this.setParamTable(target, defObj);
    }

    private void setParamTable(InnerLinkTransitionTarget target, DefObj selectedItem) {
        if (target == null || selectedItem == null) {
            return;
        }
        InnerLinkTargetProperties props = target.getTargetProps();
        String typeName = target.getTargetType();
        if (props == null) {
            props = "fusionChart".equals(typeName) ? new ChartInnerLinkTargetProperties() : new InnerLinkTargetProperties();
            target.setTargetProps(props);
        }
        Map params = null;
        Map<String, IParameter> oldParams = target.getParams();
        Map newParams = null;
        String name = selectedItem.getName();
        if ("fusionChart".equals(typeName)) {
            ICalculable owner = (ICalculable)selectedItem.getProperty(name);
            props.setId(owner, name);
            props.setName(name);
            params = this.parseParamsFromChart(name);
            if (oldParams == null) {
                oldParams = new TreeMap<String, IParameter>();
            }
            if (params != null && !params.isEmpty()) {
                newParams = params;
            }
        } else {
            ICalculable owner = (ICalculable)selectedItem.getProperty(name);
            if (!(owner instanceof Cell)) {
                return;
            }
            Cell cell = (Cell)owner;
            SubReportInfo rptInfo = cell.getSubReportInfo();
            props.setId(cell, name);
            props.setName(selectedItem.getAlias());
            params = rptInfo.getParams();
            if (oldParams == null || oldParams.isEmpty()) {
                oldParams = new TreeMap<String, IParameter>();
                newParams = this.copyParamAndClearValue(oldParams, params);
            } else if (params != null && !params.isEmpty()) {
                newParams = params;
            }
        }
        this.refreshParamTable(oldParams, newParams);
        target.setParams(oldParams);
    }

    protected void initParamTable() {
        this._paramTable.getSelectManager().setSelectMode(2);
        this._paramTable.addColumns(6);
        IColumn colName = this._paramTable.getColumn(0);
        IColumn colalias = this._paramTable.getColumn(2);
        IColumn colDataType = this._paramTable.getColumn(3);
        IColumn colRequired = this._paramTable.getColumn(4);
        IColumn colDefaultValue = this._paramTable.getColumn(5);
        this._paramTable.getColumn(1).setWidth(185);
        colName.setWidth(85);
        colalias.setWidth(88);
        colDataType.setWidth(55);
        colRequired.setWidth(30);
        colDefaultValue.setWidth(70);
        colName.getStyleAttributes().setBackground(this._locked);
        colalias.getStyleAttributes().setBackground(this._locked);
        colDataType.getStyleAttributes().setBackground(this._locked);
        colRequired.getStyleAttributes().setBackground(this._locked);
        colName.getStyleAttributes().setLocked(true);
        colalias.getStyleAttributes().setLocked(true);
        colDataType.getStyleAttributes().setLocked(true);
        colRequired.getStyleAttributes().setLocked(true);
        colDataType.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])new String[]{AbstractExtLinkAssembler.getText(), AbstractExtLinkAssembler.getNumber(), AbstractExtLinkAssembler.getDate(), AbstractExtLinkAssembler.getDateTime(), AbstractExtLinkAssembler.getTime(), AbstractExtLinkAssembler.getBoolean()})));
        this._paramTable.addHeadRow();
        IRow headRow = this._paramTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"));
        headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("KEY_VALUE", "\u503c"));
        headRow.getCell(2).setValue((Object)CtrlEXTMessages.getMLS("displayName", "\u663e\u793a\u540d\u79f0"));
        headRow.getCell(3).setValue((Object)CtrlEXTMessages.getMLS("dataType", "\u6570\u636e\u7c7b\u578b"));
        headRow.getCell(4).setValue((Object)CtrlEXTMessages.getMLS("required", "\u5fc5\u586b"));
        headRow.getCell(5).setValue((Object)CtrlEXTMessages.getMLS("useDefaultValue", "\u4f7f\u7528\u9ed8\u8ba4\u503c"));
        this._paramTable.getIndexColumn().getStyleAttributes().setHided(true);
        ActionMap am = this._paramTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        KDPromptBox f7FormulaWizard = this.createF7Component();
        this._paramTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7FormulaWizard));
    }

    private void noJump(KDComboBox box) {
        box.putClientProperty((Object)"jump", (Object)"false");
    }

    private KDComboBox getBoxTargetType() {
        KDComboBox box = new KDComboBox();
        DefObj defObj = new DefObj();
        defObj.setName("fusionChart");
        defObj.setAlias(ExtConst.getFChartText());
        box.addItem((Object)defObj);
        DefObj defObj1 = new DefObj();
        defObj1.setName("subReport");
        defObj1.setAlias(ExtConst.getSubRptText());
        box.addItem((Object)defObj1);
        return box;
    }

    private DefObj[] getInnerNameItems(String targetType) {
        Sheet sheet;
        ArrayList<DefObj> list = new ArrayList<DefObj>();
        Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
        if ("fusionChart".equals(targetType)) {
            sheet = book.getActiveSheet();
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (layer != null) {
                String sheetName = sheet.getSyntaxName();
                EmbedhLayer.EmbedIterator iter = layer.getIterator(true);
                while (iter.hasNext()) {
                    ChartRectEmbedment embedment;
                    String dataFrom;
                    EmbedObject embed = iter.next();
                    if (embed == layer.getActiveSelectedEmbed() || !(embed instanceof ChartRectEmbedment) || !"dataset".equals(dataFrom = (embedment = (ChartRectEmbedment)embed).getModel().getDataFrom())) continue;
                    String chartName = embedment.getName();
                    String name = sheetName + SEPARATOR + chartName;
                    if (this.excludeInnerTarget(name)) continue;
                    DefObj defObj = new DefObj();
                    defObj.setName(name);
                    defObj.setAlias(name);
                    defObj.setProperty(name, (Object)embedment.getModel().getDataNode());
                    list.add(defObj);
                }
            }
        } else {
            sheet = book.getActiveSheet();
            List<Cell> cells = sheet.getSubReportCells();
            if (cells != null && !cells.isEmpty()) {
                for (Cell cell : cells) {
                    String name;
                    String cellName = cell.getName(false, true);
                    SubReportInfo rptInfo = cell.getSubReportInfo();
                    if (rptInfo == null || this.excludeInnerTarget(name = cellName)) continue;
                    cellName = "[" + cellName + "]";
                    String alias = cellName + rptInfo.getReportProps().getAlias();
                    DefObj defObj = new DefObj();
                    defObj.setName(name);
                    defObj.setAlias(alias);
                    defObj.setProperty(name, (Object)cell);
                    list.add(defObj);
                }
            }
        }
        DefObj[] arr = new DefObj[list.size()];
        return list.toArray(arr);
    }

    private boolean excludeInnerTarget(String targetName) {
        if (this._mapInnerTarget == null) {
            return false;
        }
        int rowCount = this._innerTable.getRowCount();
        IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)this._innerTable);
        int activeRowIndex = -1;
        if (selectedRow != null) {
            activeRowIndex = KDTableUtil.getSelectedRow((KDTable)this._innerTable).getRowIndex();
        }
        for (int index = 0; index < rowCount; ++index) {
            ICell cell;
            Object value;
            if (activeRowIndex == index || !((value = (cell = this._innerTable.getRow(index).getCell(1)).getValue()) instanceof DefObj) || !targetName.equals(((DefObj)value).getName())) continue;
            return true;
        }
        return false;
    }

    private String getNextParamName() {
        Map<Object, Object> params = new HashMap();
        int rowIndex = this._reportTable.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0) {
            params = ((ExtTransitionTarget)this._reportTable.getRow(rowIndex).getUserObject()).getParameters();
        } else {
            rowIndex = this._innerTable.getSelectManager().getActiveRowIndex();
            IRow row = this._innerTable.getRow(rowIndex);
            String targetType = ((DefObj)row.getCell(0).getValue()).getName();
            DefObj defObj = (DefObj)row.getCell(1).getValue();
            if (defObj != null) {
                String id = defObj.getName();
                InnerLinkTransitionTarget target = this._mapInnerTarget.get(this.createMapInnerTargetKey(rowIndex, targetType, id));
                params = target.getParams();
            }
        }
        int i = 1;
        String paramName;
        while (params.get(paramName = "param" + i) != null) {
            ++i;
        }
        return paramName;
    }

    private Map copyParamAndClearValue(Map oldParams, Map params) {
        TreeMap newParams = null;
        if (params != null && !params.isEmpty()) {
            newParams = new TreeMap();
            Set entrySet = params.entrySet();
            for (Map.Entry entry : entrySet) {
                ParameterImpl p = (ParameterImpl)entry.getValue();
                p = (ParameterImpl)p.clone();
                p.setExpr(null);
                p.setValue(null);
                newParams.put(entry.getKey(), p);
            }
        }
        return newParams;
    }

    protected void initListeners() {
        this._refreshParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow rowRefreshed;
                IExtCallback callback = AbstractExtLinkAssembler.this._ext.getExtCallback();
                Book book = MiscUtil.getActiveSpreadContext(AbstractExtLinkAssembler.this._ext).getBook();
                ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
                int selectReportIndex = AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex();
                if (selectReportIndex >= 0) {
                    rowRefreshed = AbstractExtLinkAssembler.this._reportTable.getRow(selectReportIndex);
                    ExtTransitionTarget transTar = (ExtTransitionTarget)rowRefreshed.getUserObject();
                    ReportProperties fullname = transTar.getReportProps();
                    Map<String, IParameter> oldParams = transTar.getParameters();
                    IExtRuntimeDataProvider dataProvider = null;
                    if (dataProvider == null) {
                        dataProvider = (IExtRuntimeDataProvider)callback.clone(fullname);
                    }
                    try {
                        book = MiscUtil.unpack(dataProvider.getTransitionTargetData(fullname, ctx));
                    }
                    catch (Exception exception) {
                        MiscUtil.handleFileCheckingException(exception, (Component)AbstractExtLinkAssembler.this._paramTable);
                        return;
                    }
                    AbstractExtLinkAssembler.this.refreshParamTable(oldParams, callback.fetchDataSetParameters(MiscUtil.collectExtDataSets(book), ctx));
                }
                if ((selectReportIndex = AbstractExtLinkAssembler.this._innerTable.getSelectManager().getActiveRowIndex()) >= 0) {
                    rowRefreshed = AbstractExtLinkAssembler.this._innerTable.getRow(selectReportIndex);
                    Object cellName = rowRefreshed.getCell(1).getValue();
                    Object cellType = rowRefreshed.getCell(0).getValue();
                    String type = null;
                    if (cellType instanceof DefObj) {
                        type = ((DefObj)cellType).getName();
                    }
                    Map newParams = null;
                    String name = null;
                    Map params = null;
                    if (cellName instanceof DefObj) {
                        name = ((DefObj)cellName).getName();
                    }
                    Map<String, IParameter> oldParams = null;
                    String key = AbstractExtLinkAssembler.this.createMapInnerTargetKey(selectReportIndex, type, name);
                    InnerLinkTransitionTarget transTar = null;
                    if (AbstractExtLinkAssembler.this._mapInnerTarget != null && (transTar = (InnerLinkTransitionTarget)AbstractExtLinkAssembler.this._mapInnerTarget.get(key)) != null) {
                        oldParams = transTar.getParams();
                    }
                    if ("fusionChart".equals(type)) {
                        params = AbstractExtLinkAssembler.this.parseParamsFromChart(name);
                        if (oldParams == null) {
                            oldParams = new TreeMap<String, IParameter>();
                        }
                        if (params != null && !params.isEmpty()) {
                            newParams = params;
                        }
                    } else {
                        Cell cell = (Cell)((DefObj)cellName).getProperty(name);
                        if (cell != null) {
                            SubReportInfo rptInfo = cell.getSubReportInfo();
                            params = rptInfo.getParams();
                            if (oldParams == null || oldParams.isEmpty()) {
                                oldParams = new TreeMap<String, IParameter>();
                                newParams = AbstractExtLinkAssembler.this.copyParamAndClearValue(oldParams, params);
                            } else if (params != null && !params.isEmpty()) {
                                newParams = params;
                            }
                        }
                    }
                    AbstractExtLinkAssembler.this.refreshParamTable(oldParams, newParams);
                    if (transTar != null) {
                        transTar.setParams(oldParams);
                    }
                }
            }
        });
        this._delParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectIndex = AbstractExtLinkAssembler.this._paramTable.getSelectManager().getActiveRowIndex();
                IRow rowRemoved = AbstractExtLinkAssembler.this._paramTable.getRow(selectIndex);
                if (rowRemoved == null) {
                    return;
                }
                if (rowRemoved.getCell(0).getStyle().isLocked()) {
                    AbstractExtLinkAssembler.this.showMsgBox(CtrlEXTMessages.getMLS("cannotDeleteBuiltInParameter", "\u4e0d\u80fd\u5220\u9664\u6570\u636e\u96c6\u5185\u7f6e\u53c2\u6570\uff01"));
                    return;
                }
                Map<String, IParameter> params = null;
                AbstractExtLinkAssembler.this._paramTable.removeRow(selectIndex);
                int rowIndex = AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    params = ((ExtTransitionTarget)AbstractExtLinkAssembler.this._reportTable.getRow(rowIndex).getUserObject()).getParameters();
                } else {
                    rowIndex = AbstractExtLinkAssembler.this._innerTable.getSelectManager().getActiveRowIndex();
                    IRow row = AbstractExtLinkAssembler.this._innerTable.getRow(rowIndex);
                    HashMap mapTarget = (HashMap)row.getUserObject();
                    String targetType = ((DefObj)row.getCell(0).getValue()).getName();
                    DefObj defObj = (DefObj)row.getCell(1).getValue();
                    if (defObj != null) {
                        String id = defObj.getName();
                        InnerLinkTransitionTarget target = (InnerLinkTransitionTarget)AbstractExtLinkAssembler.this._mapInnerTarget.get(AbstractExtLinkAssembler.this.createMapInnerTargetKey(rowIndex, targetType, id));
                        params = target.getParams();
                    }
                }
                if (params != null) {
                    params.remove(rowRemoved.getCell(0).getValue());
                }
                AbstractExtLinkAssembler.this.setTipLabel();
            }
        });
        this._insertParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int innerRowIndex = AbstractExtLinkAssembler.this._innerTable.getSelectManager().getActiveRowIndex();
                int reportRowIndex = AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex();
                if (reportRowIndex >= 0) {
                    ExtTransitionTarget target = (ExtTransitionTarget)AbstractExtLinkAssembler.this._reportTable.getRow(reportRowIndex).getUserObject();
                    if (target == null) {
                        return;
                    }
                    IParameter param = AbstractExtLinkAssembler.this.addParamRow();
                    target.getParameters().put(param.getName(), param);
                } else if (innerRowIndex >= 0) {
                    InnerLinkTransitionTarget target = null;
                    IRow row = AbstractExtLinkAssembler.this._innerTable.getRow(innerRowIndex);
                    String targetType = ((DefObj)row.getCell(0).getValue()).getName();
                    DefObj defObj = (DefObj)row.getCell(1).getValue();
                    if (defObj != null) {
                        String id = defObj.getName();
                        target = (InnerLinkTransitionTarget)AbstractExtLinkAssembler.this._mapInnerTarget.get(AbstractExtLinkAssembler.this.createMapInnerTargetKey(innerRowIndex, targetType, id));
                    }
                    if (target == null) {
                        return;
                    }
                    IParameter param = AbstractExtLinkAssembler.this.addParamRow();
                    target.getParams().put(param.getName(), param);
                }
                AbstractExtLinkAssembler.this.setTipLabel();
            }
        });
        this._delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow rowRemoved = AbstractExtLinkAssembler.this._reportTable.removeRow(AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex());
                if (rowRemoved != null && Boolean.TRUE.equals(rowRemoved.getCell(0).getValue()) && AbstractExtLinkAssembler.this._reportTable.getRowCount() != 0) {
                    IRow firstRow = AbstractExtLinkAssembler.this._reportTable.getRow(0);
                    firstRow.getCell(0).setValue((Object)Boolean.TRUE);
                }
                if (rowRemoved != null) {
                    AbstractExtLinkAssembler.this.syncParams();
                }
            }
        });
        this._delInnerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex = AbstractExtLinkAssembler.this._innerTable.getSelectManager().getActiveRowIndex();
                IRow rowRemoved = AbstractExtLinkAssembler.this._innerTable.removeRow(rowIndex);
                if (rowRemoved != null) {
                    AbstractExtLinkAssembler.this.updateMapInnerTargetKey(false, rowIndex);
                    AbstractExtLinkAssembler.this.syncParams();
                }
            }
        });
        this._insertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean firstRow = false;
                if (AbstractExtLinkAssembler.this._reportTable.getRowCount() == 0) {
                    firstRow = true;
                }
                Book book = MiscUtil.getActiveSpreadContext(AbstractExtLinkAssembler.this._ext).getBook();
                if (!firstRow && book.is4Mobile()) {
                    MessageUtil.msgboxInfo((Component)((Object)AbstractExtLinkAssembler.this), "\u79fb\u52a8\u62a5\u8868\u4e0d\u652f\u6301\u8054\u67e5\u591a\u5f20\u62a5\u8868");
                    return;
                }
                int index = AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex();
                IRow rowAdded = index < 0 ? AbstractExtLinkAssembler.this._reportTable.addRow() : AbstractExtLinkAssembler.this._reportTable.addRow(index);
                if (firstRow) {
                    rowAdded.getCell(0).setValue((Object)Boolean.TRUE);
                } else {
                    rowAdded.getCell(0).setValue((Object)Boolean.FALSE);
                }
                int rowIndex = rowAdded.getRowIndex();
                KDTableUtil.setSelectedRow((KDTable)AbstractExtLinkAssembler.this._reportTable, (int)rowIndex);
                AbstractExtLinkAssembler.this._reportTable.scrollToVisible(rowIndex, 0);
                AbstractExtLinkAssembler.this._reportTable.getEditManager().editCellAt(rowIndex, 1);
                AbstractExtLinkAssembler.this.syncParams();
            }
        });
        this._insertInnerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow rowAdded = null;
                int index = AbstractExtLinkAssembler.this._innerTable.getSelectManager().getActiveRowIndex();
                rowAdded = index < 0 ? AbstractExtLinkAssembler.this._innerTable.addRow() : AbstractExtLinkAssembler.this._innerTable.addRow(index);
                ICell cell = rowAdded.getCell(0);
                int rowIndex = rowAdded.getRowIndex();
                AbstractExtLinkAssembler.this.updateMapInnerTargetKey(true, rowIndex);
                KDComboBox box = (KDComboBox)AbstractExtLinkAssembler.this._innerTable.getCellEditor(rowIndex, 0).getComponent();
                DefObj defObj = (DefObj)box.getItemAt(0);
                cell.setValue((Object)defObj);
                String targetType = defObj.getName();
                cell = rowAdded.getCell(1);
                KDTableUtil.setSelectedRow((KDTable)AbstractExtLinkAssembler.this._innerTable, (int)-1);
                box = (KDComboBox)AbstractExtLinkAssembler.this._innerTable.getCellEditor(rowIndex, 1).getComponent();
                box.removeAllItems();
                box.addItems((Object[])AbstractExtLinkAssembler.this.getInnerNameItems(targetType));
                KDTableUtil.setSelectedRow((KDTable)AbstractExtLinkAssembler.this._innerTable, (int)rowIndex);
                AbstractExtLinkAssembler.this._innerTable.scrollToVisible(rowIndex, 0);
            }
        });
        this._reportTable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AbstractExtLinkAssembler.this.unSelectRow(AbstractExtLinkAssembler.this._innerTable);
                AbstractExtLinkAssembler.this.syncParams();
                AbstractExtLinkAssembler.this._currentRow = AbstractExtLinkAssembler.this._reportTable.getRow(AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex());
            }
        });
        this._innerTable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AbstractExtLinkAssembler.this.unSelectRow(AbstractExtLinkAssembler.this._reportTable);
                IRow row = AbstractExtLinkAssembler.this._innerTable.getRow(AbstractExtLinkAssembler.this._innerTable.getSelectManager().getActiveRowIndex());
                if (AbstractExtLinkAssembler.this._currentRow == row) {
                    return;
                }
                AbstractExtLinkAssembler.this._currentRow = row;
                AbstractExtLinkAssembler.this._paramTable.removeRows();
                if (AbstractExtLinkAssembler.this._currentRow != null && AbstractExtLinkAssembler.this._currentRow.getCell(0).getValue() != null && AbstractExtLinkAssembler.this._currentRow.getCell(1).getValue() != null) {
                    AbstractExtLinkAssembler.this.syncParams();
                }
                AbstractExtLinkAssembler.this.setTipLabel();
            }
        });
        this._innerTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                if (e.getColIndex() != 1) {
                    return;
                }
                IRow row = KDTableUtil.getSelectedRow((KDTable)AbstractExtLinkAssembler.this._innerTable);
                if (row == null) {
                    return;
                }
                DefObj objType = (DefObj)row.getCell(0).getValue();
                if (objType == null) {
                    return;
                }
                String typeName = objType.getName();
                KDComboBox boxName = (KDComboBox)AbstractExtLinkAssembler.this._innerTable.getCellEditor(row.getRowIndex(), 1).getComponent();
                boxName.removeAllItems();
                boxName.addItems((Object[])AbstractExtLinkAssembler.this.getInnerNameItems(typeName));
                DefObj objName = (DefObj)row.getCell(1).getValue();
                if (objName != null) {
                    AbstractExtLinkAssembler.this.setCellValue(row.getCell(1), objName.getName());
                }
                AbstractExtLinkAssembler.this.syncParams();
            }

            public void editStopped(KDTEditEvent e) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)AbstractExtLinkAssembler.this._innerTable);
                if (row == null) {
                    return;
                }
                if (e.getOldValue() == e.getValue()) {
                    return;
                }
                AbstractExtLinkAssembler.this.setTipLabel();
            }
        });
        this._reportTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                if (Boolean.TRUE.equals(e.getOldValue())) {
                    e.setCancel(true);
                }
                KDTableUtil.setSelectedRow((KDTable)AbstractExtLinkAssembler.this._reportTable, (int)e.getRowIndex());
            }

            public void editStopping(KDTEditEvent e) {
                int col = e.getColIndex();
                if (col == 0) {
                    if (!e.getValue().equals(e.getOldValue())) {
                        int size = AbstractExtLinkAssembler.this._reportTable.getRowCount();
                        for (int i = 0; i < size; ++i) {
                            if (e.getRowIndex() == i) continue;
                            IRow otherRow = AbstractExtLinkAssembler.this._reportTable.getRow(i);
                            otherRow.getCell(0).setValue((Object)Boolean.FALSE);
                        }
                    }
                } else if (col == 1) {
                    if (!(e.getValue() instanceof ReportProperties) && e.getOldValue() == null) {
                        e.setCancel(true);
                        AbstractExtLinkAssembler.this._reportTable.getEditManager().editingCanceled();
                    } else {
                        ReportProperties fullName = (ReportProperties)e.getValue();
                        IRow row = AbstractExtLinkAssembler.this._reportTable.getRow(e.getRowIndex());
                        if (fullName == null) {
                            row.setUserObject(null);
                            AbstractExtLinkAssembler.this.syncParams();
                            return;
                        }
                        Object uo = row.getUserObject();
                        if (uo == null) {
                            ExtTransitionTarget target = new ExtTransitionTarget(fullName, AbstractExtLinkAssembler.this._lastSynced);
                            row.setUserObject((Object)target);
                            AbstractExtLinkAssembler.this.syncParams();
                            String alias = fullName.getAlias();
                            fullName.setAlias(alias);
                        } else {
                            ExtTransitionTarget oldTarget = (ExtTransitionTarget)uo;
                            row.getCell(1).setValue((Object)fullName);
                            oldTarget.setParameters(AbstractExtLinkAssembler.this._lastSynced);
                            oldTarget.setReportProps(fullName);
                            if (!oldTarget.getReportProps().getId().equals(fullName.getId())) {
                                AbstractExtLinkAssembler.this.syncParams();
                            }
                        }
                        row.getCell(2).setValue((Object)fullName.getAlias());
                    }
                } else if (col == 2) {
                    IRow row = AbstractExtLinkAssembler.this._reportTable.getRow(e.getRowIndex());
                    String edited = (String)e.getValue();
                    if (StringUtil.isEmptyString((String)edited)) {
                        return;
                    }
                    if (row.getUserObject() == null) {
                        return;
                    }
                    if (AbstractExtLinkAssembler.this.checkDupliAlias(edited, e.getRowIndex())) {
                        AbstractExtLinkAssembler.this.showMsgBox(CtrlEXTMessages.getMLS("duplicateReportDisplayName", "\u62a5\u8868\u663e\u793a\u540d\u79f0\u91cd\u590d"));
                        return;
                    }
                    ((ExtTransitionTarget)row.getUserObject()).getReportProps().setAlias(edited);
                }
            }
        });
        this._paramTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editCanceled(KDTEditEvent e) {
                if (e.getColIndex() == 1 && e.getOldValue() == null) {
                    IRow rowRemoved = AbstractExtLinkAssembler.this._paramTable.removeRow(e.getRowIndex());
                    if (rowRemoved == null) {
                        return;
                    }
                    ((ExtTransitionTarget)AbstractExtLinkAssembler.this._reportTable.getRow(AbstractExtLinkAssembler.this._reportTable.getSelectManager().getActiveRowIndex()).getUserObject()).getParameters().remove(rowRemoved.getCell(0).getValue());
                }
            }

            public void editStopping(KDTEditEvent e) {
                AbstractExtLinkAssembler.this.paramTableEditStopping(e);
            }
        });
    }

    private boolean checkDupliAlias(String edited, int rowIndex) {
        int count = this._reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            ICell cell;
            if (rowIndex == i || (cell = this._reportTable.getCell(i, 2)).getValue() == null || !cell.getValue().equals(edited)) continue;
            return true;
        }
        return false;
    }

    private void updateMapInnerTargetKey(boolean isInsert, int curRowIndex) {
        if (this._mapInnerTarget == null || this._mapInnerTarget.isEmpty()) {
            return;
        }
        ArrayList<String> removeKeys = new ArrayList<String>();
        HashMap<String, InnerLinkTransitionTarget> mapTemp = new HashMap<String, InnerLinkTransitionTarget>();
        for (Map.Entry<String, InnerLinkTransitionTarget> entry : this._mapInnerTarget.entrySet()) {
            InnerLinkTransitionTarget innerTarget = entry.getValue();
            String key = entry.getKey();
            int keyIndex = Integer.parseInt(key.substring(0, 1));
            if (isInsert) {
                if (keyIndex < curRowIndex) continue;
                removeKeys.add(key);
                key = keyIndex + 1 + key.substring(1);
                mapTemp.put(key, innerTarget);
                continue;
            }
            if (keyIndex < curRowIndex) continue;
            if (keyIndex == curRowIndex) {
                removeKeys.add(key);
                continue;
            }
            removeKeys.add(key);
            key = keyIndex - 1 + key.substring(1);
            mapTemp.put(key, innerTarget);
        }
        for (String key : removeKeys) {
            this._mapInnerTarget.remove(key);
        }
        this._mapInnerTarget.putAll(mapTemp);
    }

    private void removeKeyStartWidth(int curRowIndex) {
        if (this._mapInnerTarget == null || this._mapInnerTarget.isEmpty()) {
            return;
        }
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (String key : this._mapInnerTarget.keySet()) {
            int keyIndex = Integer.parseInt(key.substring(0, 1));
            if (keyIndex != curRowIndex) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            this._mapInnerTarget.remove(key);
        }
    }

    private String createMapInnerTargetKey(int index, String targetType, String id) {
        return index + "_" + targetType + "_" + id;
    }

    protected void paramTableEditStopping(KDTEditEvent e) {
        CommonCalculableProps target;
        if (this._currentRow == null) {
            return;
        }
        Object userObject = this._currentRow.getUserObject();
        Map<String, IParameter> allParams = null;
        if (userObject instanceof ExtTransitionTarget) {
            target = (ExtTransitionTarget)userObject;
            if (target != null) {
                allParams = target.getParameters();
            }
        } else {
            target = null;
            String targetType = ((DefObj)this._currentRow.getCell(0).getValue()).getName();
            DefObj defObj = (DefObj)this._currentRow.getCell(1).getValue();
            if (defObj != null) {
                String id = defObj.getName();
                target = this._mapInnerTarget.get(this.createMapInnerTargetKey(this._currentRow.getRowIndex(), targetType, id));
            }
            if (target != null) {
                allParams = ((InnerLinkTransitionTarget)target).getParams();
            }
        }
        if (allParams == null) {
            return;
        }
        IParameter param = allParams.get(this._paramTable.getCell(e.getRowIndex(), 0).getValue());
        if (param == null) {
            return;
        }
        this.paramTableEditStopping(e, param, allParams);
    }

    protected void paramTableEditStopping(KDTEditEvent e, IParameter param, Map allParams) {
        int col = e.getColIndex();
        if (col == 0) {
            String name = (String)e.getValue();
            if (name.equals(param.getName())) {
                return;
            }
            if (this.isErrorParamName(name)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("parameterNameMustStartWithLetter", "\u53c2\u6570\u540d\u5e94\u4ee5\u82f1\u6587\u5b57\u6bcd\u5f00\u5934\uff0c\u53ef\u8ddf\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002"));
                e.setCancel(true);
                return;
            }
            if (allParams.get(name) != null) {
                this.showMsgBox(CtrlEXTMessages.getMLS("duplicateParameterNameInOneDataSet", "\u53c2\u6570\u540d\u4e0e\u540c\u4e00\u6570\u636e\u96c6\u7684\u53e6\u4e00\u53c2\u6570\u540d\u91cd\u590d!"));
                e.setCancel(true);
                return;
            }
            allParams.remove(param.getName());
            param.setName(name);
            allParams.put(name, param);
        } else if (col == 1) {
            Object value = e.getValue();
            if (!this.setParamValue(param, (String)value)) {
                e.setCancel(true);
            }
        } else if (col == 2) {
            param.setAlias((String)e.getValue());
        } else if (col == 3) {
            String type = (String)e.getValue();
            if (AbstractExtLinkAssembler.getText().equals(type)) {
                param.setDataType(0);
            } else if (AbstractExtLinkAssembler.getNumber().equals(type)) {
                param.setDataType(1);
            } else if (AbstractExtLinkAssembler.getDate().equals(type)) {
                param.setDataType(2);
            } else if (AbstractExtLinkAssembler.getDateTime().equals(type)) {
                param.setDataType(4);
            } else if (AbstractExtLinkAssembler.getTime().equals(type)) {
                param.setDataType(5);
            } else if (AbstractExtLinkAssembler.getBoolean().equals(type)) {
                param.setDataType(3);
            }
        } else if (col == 4) {
            param.setNullable((Boolean)e.getValue() == false);
        } else if (col == 5) {
            boolean isDefault = (Boolean)e.getValue();
            if (isDefault) {
                this.setParamValueByDefault(isDefault, this._locked, param, "@OriginalDefaultValue", e.getRowIndex(), allParams);
            } else {
                this.setParamValueByDefault(isDefault, Color.WHITE, param, null, e.getRowIndex(), allParams);
            }
        }
    }

    private void setParamValueByDefault(boolean isDefault, Color bgColor, IParameter param, String paramValue, int rowIndex, Map allParams) {
        ICell cell = this._paramTable.getCell(rowIndex, 1);
        StyleAttributes sa = cell.getStyleAttributes();
        sa.setLocked(isDefault);
        sa.setBackground(bgColor);
        cell.setValue(null);
        this.setParamValue(param, paramValue);
        for (int r = 0; r < this._paramTable.getRowCount(); ++r) {
            String pName = (String)this._paramTable.getRow(r).getCell(0).getValue();
            if (!(param.getName() + "_text").equals(pName)) continue;
            cell = this._paramTable.getCell(r, 1);
            cell.setValue(null);
            sa = cell.getStyleAttributes();
            sa.setLocked(isDefault);
            sa.setBackground(bgColor);
            cell = this._paramTable.getCell(r, 5);
            cell.setValue((Object)isDefault);
            if (allParams != null) {
                param = (IParameter)allParams.get(this._paramTable.getCell(r, 0).getValue());
            }
            if (param == null) break;
            this.setParamValue(param, paramValue);
            break;
        }
    }

    public void changeLinkSet(ItemEvent e) {
        TableLayout2 layout = (TableLayout2)this.getLayout();
        Component itemComp = (Component)e.getItem();
        this._linkType = itemComp.getName();
        if ("outerLink".equals(this._linkType)) {
            layout.setRowSpacing(3, 0);
            layout.setFixedHeight(3, 0);
            this.remove((Component)this._insertInnerBtn);
            this.remove((Component)this._delInnerBtn);
            layout.setRowSpacing(1, 10);
            layout.setRatableHeight(1, 1);
            this.add((Component)this._insertBtn, TableLayout2.param((int)0, (int)3));
            this.add((Component)this._delBtn, TableLayout2.param((int)0, (int)4));
            this._reportTable.getSelectManager().select(0, 0);
            this._reportLbl.setText(CtrlEXTMessages.getMLS("linkedSettings", "\u8054\u67e5\u8bbe\u7f6e"));
        } else {
            layout.setRowSpacing(1, 0);
            layout.setFixedHeight(1, 0);
            this.remove((Component)this._insertBtn);
            this.remove((Component)this._delBtn);
            layout.setRowSpacing(3, 10);
            layout.setRatableHeight(3, 1);
            this.add((Component)this._insertInnerBtn, TableLayout2.param((int)0, (int)3));
            this.add((Component)this._delInnerBtn, TableLayout2.param((int)0, (int)4));
            this._innerTable.getSelectManager().select(0, 0);
            this._reportLbl.setText(CtrlEXTMessages.getMLS("linkageSettings", "\u8054\u52a8\u8bbe\u7f6e"));
        }
        this.setTipLabel();
        this.validate();
    }

    protected boolean setParamValue(IParameter param, String formula) {
        if (StringUtil.isEmptyString((String)formula)) {
            ((ICalculableProps)((Object)param)).setExpr(null);
        } else {
            Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
            Cell cell = sheet.getActiveCell();
            Expr expr = sheet.getExpr(cell, formula);
            ((ICalculableProps)((Object)param)).setExpr(expr);
        }
        return true;
    }

    private void syncParams() {
        this._paramTable.removeRows();
        int index = this._reportTable.getSelectManager().getActiveRowIndex();
        Map<String, IParameter> params = null;
        if (index >= 0) {
            ExtTransitionTarget tt = (ExtTransitionTarget)this._reportTable.getRow(index).getUserObject();
            if (tt != null) {
                params = tt.getParameters();
            }
        } else {
            index = this._innerTable.getSelectManager().getActiveRowIndex();
            if (index >= 0) {
                IRow row = this._innerTable.getRow(index);
                String targetType = ((DefObj)row.getCell(0).getValue()).getName();
                DefObj defObj = (DefObj)row.getCell(1).getValue();
                if (defObj != null) {
                    InnerLinkTransitionTarget tt;
                    String id = defObj.getName();
                    String key = this.createMapInnerTargetKey(index, targetType, id);
                    if (this._mapInnerTarget != null && (tt = this._mapInnerTarget.get(key)) != null) {
                        params = tt.getParams();
                    }
                }
            }
        }
        this.refreshParamTable(params, null);
        if (this._paramTable.getRowCount() > 0) {
            this._paramTable.getSelectManager().select(0, 0);
        }
    }

    protected void refreshParamTable(Map<String, IParameter> oldParams, Map<String, IParameter> newParams) {
        this._lastSynced = oldParams;
        this._paramTable.removeRows();
        if (oldParams == null) {
            this.setTipLabel();
            return;
        }
        if (newParams != null) {
            Set<Map.Entry<String, IParameter>> entrySet = newParams.entrySet();
            for (Map.Entry<String, IParameter> entry : entrySet) {
                String string = entry.getKey();
                ParameterImpl oldPi = (ParameterImpl)oldParams.get(string);
                ParameterImpl newPi = (ParameterImpl)entry.getValue();
                if (oldParams.containsKey(string)) {
                    oldPi.setName(newPi.getName());
                    oldPi.setAlias(newPi.getAlias());
                    oldPi.setDataType(newPi.getDataType());
                    oldPi.setValue(newPi.getValue());
                    oldPi.setAvailableValues(newPi.getAvailableValues());
                    oldPi.setNullable(newPi.isNullable());
                    oldPi.setEditorClass(newPi.getEditorClass());
                    oldPi.setUserDefine(newPi.isUserDefine());
                    oldPi.setDescription(newPi.getDescription());
                    continue;
                }
                oldParams.put(string, newPi);
            }
            entrySet = oldParams.entrySet();
            ArrayList<String> delList = new ArrayList<String>();
            for (Map.Entry<String, IParameter> entry : entrySet) {
                String key = entry.getKey();
                if (newParams.containsKey(key) || ((ParameterImpl)entry.getValue()).isUserDefine()) continue;
                delList.add(key);
            }
            for (Map.Entry<String, IParameter> entry : delList) {
                oldParams.remove(entry);
            }
        }
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        Cell cll = sheet.getActiveCell();
        if (cll == null) {
            cll = sheet.getCell(0, 0, true);
        }
        Set<String> set = oldParams.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            ParameterImpl pi = (ParameterImpl)oldParams.get(iterator.next());
            IRow prow = this._paramTable.addRow();
            prow.setUserObject(pi.clone());
            prow.getCell(0).setValue((Object)pi.getName());
            ICell vCell = prow.getCell(1);
            String formula = pi.getFormula(ctx, cll);
            if (StringUtil.isEmptyString((String)formula)) {
                formula = pi.getFormula();
            }
            vCell.setValue((Object)formula);
            prow.getCell(2).setValue((Object)pi.getAlias());
            ICell tCell = prow.getCell(3);
            switch (pi.getDataType()) {
                case 0: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getText());
                    break;
                }
                case 1: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getNumber());
                    break;
                }
                case 2: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getDate());
                    break;
                }
                case 4: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getDateTime());
                    break;
                }
                case 5: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getTime());
                    break;
                }
                case 3: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getBoolean());
                    break;
                }
                default: {
                    tCell.setValue((Object)AbstractExtLinkAssembler.getUnkonw());
                }
            }
            prow.getCell(4).setValue((Object)(pi.isNullable() ? Boolean.FALSE : Boolean.TRUE));
            if ("@OriginalDefaultValue".equals(vCell.getValue())) {
                prow.getCell(5).setValue((Object)Boolean.TRUE);
                vCell.getStyleAttributes().setLocked(true);
                vCell.getStyleAttributes().setBackground(this._locked);
                vCell.setValue(null);
            } else {
                prow.getCell(5).setValue((Object)Boolean.FALSE);
                vCell.getStyleAttributes().setLocked(false);
                vCell.getStyleAttributes().setBackground(Color.WHITE);
            }
            if (pi.isUserDefine()) {
                prow.getCell(0).getStyleAttributes().setLocked(false);
                prow.getCell(2).getStyleAttributes().setLocked(false);
                prow.getCell(3).getStyleAttributes().setLocked(false);
                prow.getCell(4).getStyleAttributes().setLocked(false);
                prow.getCell(0).getStyleAttributes().setBackground(Color.white);
                prow.getCell(2).getStyleAttributes().setBackground(Color.white);
                prow.getCell(3).getStyleAttributes().setBackground(Color.white);
                prow.getCell(4).getStyleAttributes().setBackground(Color.white);
            }
            if (!pi.isUserDefine() && !pi.getName().endsWith("_text")) continue;
            prow.getCell(5).getStyleAttributes().setLocked(true);
            prow.getCell(5).getStyleAttributes().setBackground(this._locked);
        }
        this.setTipLabel();
    }

    public void configFromCell(Object[] arrTarget, ICalculable owner) {
        this._reportTable.removeRows();
        this._innerTable.removeRows();
        this._paramTable.removeRows();
        if (arrTarget == null) {
            return;
        }
        this.configInnerTargets(arrTarget, owner);
        this.configETTargets(arrTarget);
        this.syncParams();
    }

    protected void configETTargets(Object[] arrTarget) {
        ETTargets rptShell = (ETTargets)arrTarget[0];
        if (rptShell != null) {
            List targets = rptShell.getTargets();
            ExtTransitionTarget defaultTarget = rptShell.getDefaultTarget();
            int size = targets.size();
            for (int i = 0; i < size; ++i) {
                ExtTransitionTarget cur = (ExtTransitionTarget)targets.get(i);
                ExtTransitionTarget tt = cur.getDeepCopy();
                IRow row = this._reportTable.addRow();
                row.setUserObject((Object)tt);
                if (defaultTarget == cur) {
                    row.getCell(0).setValue((Object)Boolean.TRUE);
                } else {
                    row.getCell(0).setValue((Object)Boolean.FALSE);
                }
                row.getCell(1).setValue((Object)tt.getReportProps());
                row.getCell(2).setValue((Object)tt.getReportProps().getAlias());
            }
            if (this._reportTable.getRowCount() > 0) {
                this._reportTable.getSelectManager().select(0, 0);
            }
        }
    }

    protected void configInnerTargets(Object[] arrTarget, ICalculable owner) {
        InnerLinkTargets innerTarets = (InnerLinkTargets)arrTarget[2];
        if (innerTarets != null) {
            List<InnerLinkTransitionTarget> targets = innerTarets.getTargets();
            int size = targets.size();
            for (int i = 0; i < size; ++i) {
                InnerLinkTransitionTarget cur = targets.get(i);
                InnerLinkTransitionTarget tt = cur.getDeepCopy();
                IRow row = this._innerTable.addRow();
                KDTableUtil.setSelectedRow((KDTable)this._innerTable, (int)row.getRowIndex());
                this._innerTable.scrollToVisible(row.getRowIndex(), 0);
                this.setCellValue(row.getCell(0), tt.getTargetType());
                boolean isSetValue = this.setCellValue(row.getCell(1), tt.getTargetProps().getId(owner));
                if (!isSetValue) {
                    this._innerTable.removeRow(row.getRowIndex());
                }
                String key = this.createMapInnerTargetKey(row.getRowIndex(), tt.getTargetType(), tt.getTargetProps().getId(owner));
                if (this._mapInnerTarget == null) {
                    this._mapInnerTarget = new HashMap();
                }
                this._mapInnerTarget.put(key, tt);
            }
            if (this._innerTable.getRowCount() > 0) {
                this._innerTable.getSelectManager().select(0, 0);
                this.setTipLabel();
            }
        }
    }

    private boolean setCellValue(ICell cell, String value) {
        ICellEditor cellEditor = this._innerTable.getColumn(cell.getColumnIndex()).getEditor();
        if (cellEditor == null) {
            cell.setValue((Object)value);
            return true;
        }
        KDComboBox box = (KDComboBox)cellEditor.getComponent();
        int boxCount = box.getModel().getSize();
        String itemName = "";
        for (int j = 0; j < boxCount; ++j) {
            Object itemObject = box.getItemAt(j);
            if (itemObject instanceof DefObj) {
                itemName = ((DefObj)itemObject).getName();
            }
            if (!itemName.equals(value)) continue;
            box.setSelectedIndex(-1);
            box.setSelectedIndex(j);
            cell.setValue(itemObject);
            return true;
        }
        box.setSelectedIndex(-1);
        DefObj defObj = new DefObj();
        defObj.setName(value + CtrlEXTMessages.getMLS("deletedOrRenamed", "(\u5df2\u88ab\u5220\u9664\u6216\u91cd\u547d\u540d)"));
        cell.setValue((Object)defObj);
        return true;
    }

    public boolean commit(TransitionLinkTypePanel linkTypePanel) {
        boolean outerSuccess;
        InnerLinkTargets innerTargets = this.commitInnerTargets();
        boolean innerSuccess = this.checkNullable(innerTargets);
        if (innerSuccess) {
            if (this._targets == null) {
                this._targets = new Object[3];
            }
            this._targets[2] = innerTargets;
        }
        int count = this._reportTable.getRowCount();
        ETTargets rptShell = null;
        if (count != 0) {
            ExtTransitionTarget defaultTarget = null;
            ArrayList<Object> list = new ArrayList<Object>();
            HashSet<Object> alias = new HashSet<Object>(8);
            for (int i = 0; i < count; ++i) {
                IRow row = this._reportTable.getRow(i);
                Object aliasValue = row.getCell(2).getValue();
                Object object = row.getUserObject();
                if ((aliasValue == null || "".equals(aliasValue)) && object == null) continue;
                if (aliasValue == null || "".equals(aliasValue)) {
                    this.showMsgBox(CtrlEXTMessages.getMLS("emptyReportDisplayName", "\u5b58\u5728\u62a5\u8868\u663e\u793a\u540d\u79f0\u4e3a\u7a7a"));
                    return false;
                }
                if (alias.contains(aliasValue)) {
                    this.showMsgBox(CtrlEXTMessages.getMLS("duplicateReportDisplayName", "\u62a5\u8868\u663e\u793a\u540d\u79f0\u91cd\u590d"));
                    return false;
                }
                if (object == null) {
                    this.showMsgBox(CtrlEXTMessages.getMLS("emptyReportPath", "\u5b58\u5728\u62a5\u8868\u8def\u5f84\u4e3a\u7a7a"));
                    return false;
                }
                list.add(row.getUserObject());
                if (Boolean.TRUE.equals(row.getCell(0).getValue())) {
                    defaultTarget = (ExtTransitionTarget)row.getUserObject();
                }
                alias.add(aliasValue);
            }
            if (list.size() > 0) {
                rptShell = new ETTargets();
                rptShell.setTargets(list);
                rptShell.setDefaultTarget(defaultTarget);
            }
        }
        if (outerSuccess = this.checkNullable(rptShell)) {
            if (this._targets == null) {
                this._targets = new Object[3];
            }
            this._targets[0] = rptShell;
        }
        return innerSuccess || outerSuccess;
    }

    protected InnerLinkTargets commitInnerTargets() {
        InnerLinkTargets innerTargets = null;
        int count = this._innerTable.getRowCount();
        if (count != 0) {
            ArrayList<InnerLinkTransitionTarget> list = new ArrayList<InnerLinkTransitionTarget>();
            HashMap<String, DefObj> mapRow = new HashMap<String, DefObj>();
            for (int i = 0; i < count; ++i) {
                String tarName;
                IRow row = this._innerTable.getRow(i);
                Object type = row.getCell(0).getValue();
                Object name = row.getCell(1).getValue();
                if (type == null || name == null || "".equals(type) || "".equals(name) || mapRow.get(tarName = ((DefObj)name).getName()) == type) continue;
                mapRow.put(tarName, (DefObj)type);
                String key = this.createMapInnerTargetKey(i, ((DefObj)type).getName(), tarName);
                InnerLinkTransitionTarget innerTarget = this._mapInnerTarget.get(key);
                if (innerTarget == null) continue;
                list.add(innerTarget);
            }
            if (list.size() > 0) {
                innerTargets = new InnerLinkTargets();
                innerTargets.setTargets(list);
            }
        }
        return innerTargets;
    }

    private boolean checkNullable(ETTargets targets) {
        boolean valid = true;
        if (targets == null) {
            return valid;
        }
        List list = targets.getTargets();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map<String, IParameter> params = ((ExtTransitionTarget)list.get(i)).getParameters();
            if (params == null || this.checkNullable(params)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    protected boolean checkNullable(InnerLinkTargets targets) {
        boolean valid = true;
        if (targets == null) {
            return valid;
        }
        List<InnerLinkTransitionTarget> list = targets.getTargets();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map<String, IParameter> params = list.get(i).getParams();
            if (params == null || this.checkNullable(params)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    protected boolean checkNullable(Map params) {
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        Cell cll = sheet.getCell(sheet.getActiveRow(), sheet.getActiveCol(), true);
        Set keys = params.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            IParameter param = (IParameter)params.get(it.next());
            if (param.isNullable()) continue;
            String errorInfo = CtrlEXTMessages.getMLS("parameter", "\u53c2\u6570 ") + param.getName() + " ";
            String formula = ((ICalculableProps)((Object)param)).getFormula(ctx, cll);
            if (StringUtil.isEmptyString((String)formula)) {
                this.showMsgBox(errorInfo + CtrlEXTMessages.getMLS("notAllowEmpty", "\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"));
                return false;
            }
            Expr expr = sheet.getExpr(null, formula);
            if (expr != null && !expr.isSyntaxError() && !expr.hasUnknownMethod()) continue;
            this.showMsgBox(errorInfo + CtrlEXTMessages.getMLS("msg", "\u8f93\u5165\u7684\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01"));
            return false;
        }
        return true;
    }

    protected void showMsgBox(String msg) {
        MessageDialog.show((Component)((Object)this), (Object)msg, (String)CtrlEXTMessages.getMLS("msgTitle", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1, (int)0, null);
    }

    private boolean isErrorParamName(String source) {
        if (StringUtil.isEmptyString((String)source)) {
            return true;
        }
        Pattern regxPattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
        Matcher m = regxPattern.matcher(source);
        return !m.matches();
    }

    public Object[] getTargets() {
        return this._targets;
    }

    private void unSelectRow(KDTable table) {
        KDTRange range = table.getSelectManager().toRange();
        if (range != null && !range.isEmpty()) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            table.getSelectManager().unselect(block, false);
            table.getSelectManager().setActiveRowIndex(-1);
        }
    }

    protected void setTipLabel() {
        IRow row = null;
        if (this._innerTable != null) {
            row = KDTableUtil.getSelectedRow((KDTable)this._innerTable);
        }
        if (this._paramTable.getRowCount() > 0 || "outerLink".equals(this._linkType) || this._innerTable != null && this._innerTable.getRowCount() <= 0 || row != null && row.getCell(1).getValue() == null) {
            if (this._labelParam != null) {
                this._paramTable.remove((Component)this._labelParam);
            }
        } else {
            if (this._labelParam == null) {
                int width = this._paramTable.getWidth() == 0 ? 516 : this._paramTable.getWidth();
                int height = this._paramTable.getHeight() == 0 ? 185 : this._paramTable.getHeight();
                this._labelParam = new KDLabel(CtrlEXTMessages.getMLS("parametersNotSet", "\u672a\u8bbe\u7f6e\u53c2\u6570\uff01"));
                this._labelParam.setBounds(width / 2 - 45, height / 2 - 10, 250, 20);
                this._labelParam.setForeground(Color.GRAY);
                this._labelParam.setFont(new Font(CtrlEXTMessages.getMLS("font", "\u5fae\u8f6f\u96c5\u9ed1"), 2, 16));
            }
            if (this._labelParam != null) {
                this._paramTable.add((Component)this._labelParam);
            }
        }
    }

    private IParameter addParamRow() {
        int index = this._paramTable.getSelectManager().getActiveRowIndex();
        IRow rowAdded = index < 0 ? this._paramTable.addRow() : this._paramTable.addRow(index);
        String name = this.getNextParamName();
        ParameterImpl param = new ParameterImpl(name, name, 0, null, false);
        param.setUserDefine(true);
        rowAdded.getCell(0).getStyleAttributes().setLocked(false);
        rowAdded.getCell(2).getStyleAttributes().setLocked(false);
        rowAdded.getCell(3).getStyleAttributes().setLocked(false);
        rowAdded.getCell(4).getStyleAttributes().setLocked(false);
        rowAdded.getCell(5).getStyleAttributes().setLocked(true);
        rowAdded.getCell(0).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(2).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(3).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(4).getStyleAttributes().setBackground(Color.white);
        rowAdded.getCell(5).getStyleAttributes().setBackground(this._locked);
        rowAdded.getCell(0).setValue((Object)param.getName());
        rowAdded.getCell(2).setValue((Object)param.getAlias());
        rowAdded.getCell(3).setValue((Object)AbstractExtLinkAssembler.getText());
        rowAdded.getCell(4).setValue((Object)Boolean.TRUE);
        rowAdded.getCell(5).setValue((Object)Boolean.FALSE);
        return param;
    }

    private Map<String, IParameter> parseParamsFromChart(String chartName) {
        if (StringUtil.isEmptyString((String)chartName)) {
            return null;
        }
        Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
        IExtCallback callback = this._ext.getExtCallback();
        ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
        String datasetName = this.getDatasetName(book, chartName);
        ExtDataSet[] chartDataset = this.getChartDataset(book, datasetName);
        return callback.fetchDataSetParameters(chartDataset, ctx);
    }

    private String getDatasetName(Book book, String chartName) {
        DataFromDataset fromDataset = null;
        ChartRectEmbedment chart = AbstractExtLinkAssembler.getFlashChartByName(book, chartName);
        if (chart != null) {
            fromDataset = chart.getModel().getDataNode().getFromDataset();
        }
        if (fromDataset != null) {
            return fromDataset.getDatasetName();
        }
        return null;
    }

    public static ChartRectEmbedment getFlashChartByName(Book book, String sheetChartName) {
        IExprNode[] nodes;
        if (StringUtil.isEmptyString((String)sheetChartName)) {
            return null;
        }
        String[] arrName = sheetChartName.split(SEPARATOR);
        if (arrName == null || arrName.length != 2) {
            return null;
        }
        String sheetName = arrName[0];
        String chartName = arrName[1];
        Sheet sheet = book.getSheet(sheetName);
        if (sheet == null && (nodes = book.getSheet(0).getExpr(null, sheetChartName).getAllNodes()) != null && nodes.length > 0 && nodes[0] != null && nodes[0] instanceof NamedObjectNode) {
            sheet = ((NamedObjectNode)nodes[0]).getSheet();
            chartName = ((NamedObjectNode)nodes[0]).getName();
        }
        if (sheet == null) {
            return null;
        }
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer == null) {
            return null;
        }
        ChartRectEmbedment embed = (ChartRectEmbedment)layer.findEmbed(chartName);
        if (embed instanceof FlashChart || embed instanceof EChart || embed instanceof QingChart) {
            return embed;
        }
        return null;
    }

    private ExtDataSet[] getChartDataset(Book book, String datasetName) {
        ExtDataSet[] chartDataset = new ExtDataSet[1];
        if (StringUtil.isEmptyString((String)datasetName)) {
            return chartDataset;
        }
        ExtDataSet[] datasets = MiscUtil.collectExtDataSets(book);
        int len = datasets.length;
        for (int i = 0; i < len; ++i) {
            if (StringUtil.isEmptyString((String)datasetName) || !datasetName.equals(datasets[i].getName())) continue;
            chartDataset[0] = datasets[i];
            break;
        }
        return chartDataset;
    }

    private KDPromptBox createF7Component() {
        KDPromptBox f7FormulaWizard = new KDPromptBox();
        f7FormulaWizard.setHistoryRecordEnabled(false);
        f7FormulaWizard.setIcon(ResourceManager.getImageIcon("func_new.png").getImage());
        f7FormulaWizard.setSelector((KDPromptSelector)new FormulaWizardPopupForF7(this._ext, f7FormulaWizard));
        f7FormulaWizard.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7 = (KDPromptBox)e.getSource();
                FormulaWizardPopupForF7 popup = (FormulaWizardPopupForF7)f7.getSelector();
                popup.setEditingData(f7.getText());
                popup.setImpresario((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)AbstractExtLinkAssembler.this)));
            }
        });
        return f7FormulaWizard;
    }

    class DefaultSelectorListener
    implements SelectorListener {
        DefaultSelectorListener() {
        }

        public void willShow(SelectorEvent e) {
            KDPromptBox f7 = (KDPromptBox)e.getSource();
            FormulaWizardPopupForF7 popup = (FormulaWizardPopupForF7)f7.getSelector();
            popup.setEditingData(f7.getText());
            popup.setImpresario((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)AbstractExtLinkAssembler.this)));
        }
    }

    protected class TargetRptSelector
    implements KDPromptSelector {
        protected ReportProperties fullname;
        protected boolean canceled;
        protected IExtRuntimeDataProvider dataProvider;

        protected TargetRptSelector() {
        }

        public Object getData() {
            return this.fullname;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void show() {
            IExtCallback callback = AbstractExtLinkAssembler.this._ext.getExtCallback();
            this.fullname = callback.fetchTransitionTarget();
            if (this.fullname == null) {
                this.canceled = true;
                return;
            }
            ExecutionContext ctx = MiscUtil.getActiveSpreadContext(AbstractExtLinkAssembler.this._ext).getBook().getDataSetManager().getExecutionContext();
            Book target = null;
            try {
                byte[] content = this.getContent(callback, ctx);
                if (content != null) {
                    target = MiscUtil.unpack(content);
                }
            }
            catch (Exception e) {
                MiscUtil.handleFileCheckingException(e, (Component)AbstractExtLinkAssembler.this._paramTable);
                this.canceled = true;
                return;
            }
            if (!this.check(callback, target)) {
                this.canceled = true;
                return;
            }
            this.canceled = false;
            if (target != null) {
                AbstractExtLinkAssembler.this.refreshParamTable(callback.fetchDataSetParameters(MiscUtil.collectExtDataSets(target), ctx), null);
            }
        }

        protected boolean check(IExtCallback callback, Book book) {
            return true;
        }

        protected byte[] getContent(IExtCallback callback, ExecutionContext ctx) {
            if (this.dataProvider == null) {
                this.dataProvider = (IExtRuntimeDataProvider)callback.clone(this.fullname);
            }
            return this.dataProvider.getTransitionTargetData(this.fullname, ctx);
        }
    }
}

