/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.immit.SavedSpan;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseType;

public class ShowcaseConfig {
    private SchedulerConfig scheduler;
    private boolean editable;
    private boolean showFormula = true;
    private boolean rowCountVisible;
    private boolean colCountVisible;
    private boolean hideEditable = true;
    private boolean cellSelect = true;
    private boolean isDefault;
    private boolean exportHideSheets = true;
    private boolean isHideMenubarInPortal = false;
    private SavedSpan[] rowSpans;
    private SavedSpan[] colSpans;
    private ShowcaseConfigCollection parent;
    private String showcaseName;
    private String showcaseID;
    private ShowcaseType level;
    private boolean beenModified;

    public ShowcaseConfig(ShowcaseConfigCollection parent) {
        this.parent = parent;
    }

    public IXmlElement toElement() {
        IXmlElement element = XmlUtil.createNode((String)"case");
        element.setAttribute("name", this.showcaseName == null ? "default" : this.showcaseName);
        element.setAttribute("editable", String.valueOf(this.isEditable()));
        element.setAttribute("showformula", String.valueOf(this.isShowFormula()));
        element.setAttribute("rowCountVisible", String.valueOf(this.isRowCountVisible()));
        element.setAttribute("colCountVisible", String.valueOf(this.isColCountVisible()));
        element.setAttribute("hideEditable", String.valueOf(this.isHideEditable()));
        element.setAttribute("cellSelect", String.valueOf(this.isCellSelect()));
        element.setAttribute("showcaseLevel", String.valueOf(this.level == null ? 1 : this.level.getLevel()));
        element.setAttribute("showcaseID", this.showcaseID == null ? (this.showcaseName == null ? "default" : this.showcaseName) : this.showcaseID);
        element.setAttribute("isDefault", String.valueOf(this.isDefault));
        SavedSpan[] rowArray = this.getRowSpans();
        int size = 0;
        SavedSpan span2 = null;
        IXmlElement rowElm = XmlUtil.createNode((String)"rowSpans");
        if (rowArray != null) {
            IXmlElement temp = null;
            for (SavedSpan span2 : rowArray) {
                temp = XmlUtil.createNode((String)"span");
                if (span2 instanceof SavedSpan) {
                    temp.setAttribute("start", String.valueOf(span2.getStart()));
                    temp.setAttribute("end", String.valueOf(span2.getEnd()));
                    temp.setAttribute("length", String.valueOf(span2.getLength()));
                    temp.setAttribute("visible", String.valueOf(span2.isVisible()));
                } else {
                    temp.setAttribute("start", String.valueOf(span2.getStart()));
                    temp.setAttribute("end", String.valueOf(span2.getEnd()));
                }
                rowElm.addChild(temp);
            }
        }
        element.addChild(rowElm);
        SavedSpan[] colArray = this.getColSpans();
        IXmlElement colElm = XmlUtil.createNode((String)"colSpans");
        if (colArray != null) {
            IXmlElement temp = null;
            for (SavedSpan span2 : colArray) {
                temp = XmlUtil.createNode((String)"span");
                if (span2 instanceof SavedSpan) {
                    temp.setAttribute("start", String.valueOf(span2.getStart()));
                    temp.setAttribute("end", String.valueOf(span2.getEnd()));
                    temp.setAttribute("length", String.valueOf(span2.getLength()));
                    temp.setAttribute("visible", String.valueOf(span2.isVisible()));
                } else {
                    temp.setAttribute("start", String.valueOf(span2.getStart()));
                    temp.setAttribute("end", String.valueOf(span2.getEnd()));
                }
                colElm.addChild(temp);
            }
        }
        element.addChild(colElm);
        return element;
    }

    public String toString() {
        return this.getShowcaseName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShowcaseConfig) {
            String id1 = this.getShowcaseID();
            String id2 = ((ShowcaseConfig)obj).getShowcaseID();
            if (id1 == null) {
                id1 = this.getShowcaseName() + this.getLevel().getLevel();
            }
            if (id2 == null) {
                id2 = ((ShowcaseConfig)obj).getShowcaseName() + ((ShowcaseConfig)obj).getLevel().getLevel();
            }
            return id1.equals(id2);
        }
        return false;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (!this.editable) {
            this.setBeenModified(this.editable != editable);
        }
        this.editable = editable;
    }

    public boolean isShowFormula() {
        return this.showFormula;
    }

    public void setShowFormula(boolean showFormula) {
        if (!this.editable) {
            this.setBeenModified(this.showFormula != showFormula);
        }
        this.showFormula = showFormula;
    }

    public boolean isRowCountVisible() {
        return this.rowCountVisible;
    }

    public void setRowCountVisible(boolean rowCountVisible) {
        if (!this.editable) {
            this.setBeenModified(this.rowCountVisible != rowCountVisible);
        }
        this.rowCountVisible = rowCountVisible;
    }

    public boolean isColCountVisible() {
        return this.colCountVisible;
    }

    public void setColCountVisible(boolean colCountVisible) {
        if (!this.editable) {
            this.setBeenModified(this.colCountVisible != colCountVisible);
        }
        this.colCountVisible = colCountVisible;
    }

    public boolean isHideEditable() {
        return this.hideEditable;
    }

    public void setHideEditable(boolean hideEditable) {
        if (!this.editable) {
            this.setBeenModified(this.hideEditable != hideEditable);
        }
        this.hideEditable = hideEditable;
    }

    public final void setExportHideSheets(boolean exportHideSheets) {
        this.exportHideSheets = exportHideSheets;
    }

    public final boolean isExportHideSheets() {
        return this.exportHideSheets;
    }

    public boolean isCellSelect() {
        return this.cellSelect;
    }

    public void setCellSelect(boolean cellSelect) {
        if (!this.editable) {
            this.setBeenModified(this.cellSelect != cellSelect);
        }
        this.cellSelect = cellSelect;
    }

    public SavedSpan[] getRowSpans() {
        return this.rowSpans;
    }

    public void setRowSpans(Object[] rowSpans) {
        if (!this.editable) {
            this.setBeenModified(true);
        }
        if (rowSpans == null) {
            return;
        }
        this.rowSpans = new SavedSpan[rowSpans.length];
        for (int i = 0; i < rowSpans.length; ++i) {
            this.rowSpans[i] = (SavedSpan)rowSpans[i];
        }
    }

    public SavedSpan[] getColSpans() {
        return this.colSpans;
    }

    public void setColSpans(Object[] colSpans) {
        if (!this.editable) {
            this.setBeenModified(true);
        }
        if (colSpans == null) {
            return;
        }
        this.colSpans = new SavedSpan[colSpans.length];
        for (int i = 0; i < colSpans.length; ++i) {
            this.colSpans[i] = (SavedSpan)colSpans[i];
        }
    }

    public ShowcaseType getLevel() {
        return this.level;
    }

    public void setLevel(ShowcaseType level) {
        this.level = level;
    }

    public String getShowcaseName() {
        return this.showcaseName == null ? "default" : this.showcaseName;
    }

    public void setShowcaseName(String showcaseName) {
        if (!this.editable) {
            this.setBeenModified(!showcaseName.equals(this.showcaseName));
        }
        this.showcaseName = showcaseName;
    }

    public ShowcaseConfigCollection getParent() {
        return this.parent;
    }

    public void setParent(ShowcaseConfigCollection parent) {
        this.parent = parent;
    }

    public ShowcaseConfig() {
        this.level = new ShowcaseType("default", 1);
    }

    public boolean isBeenModified() {
        return this.beenModified;
    }

    public void setBeenModified(boolean beenModified) {
        this.beenModified = beenModified;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getShowcaseID() {
        return this.showcaseID;
    }

    public void setShowcaseID(String showcaseID) {
        this.showcaseID = showcaseID;
    }

    public SchedulerConfig getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(SchedulerConfig scheduler) {
        this.scheduler = scheduler;
    }

    public boolean isHideMenubarInPortal() {
        return this.isHideMenubarInPortal;
    }

    public void setHideMenubarInPortal(boolean isHideMenubarInPortal) {
        this.isHideMenubarInPortal = isHideMenubarInPortal;
    }

    public static class SchedulerConfig {
        private int step = 600;
        private int count = -1;
        private boolean enabled;

        public int getStep() {
            return this.step;
        }

        public void setStep(int step) {
            if (step <= 0) {
                return;
            }
            this.step = step;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            if (this.step < -1 || this.step == 0) {
                return;
            }
            this.count = count;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchedulerConfig)) {
                return false;
            }
            SchedulerConfig config = (SchedulerConfig)obj;
            if (this.enabled != config.enabled) {
                return false;
            }
            if (!this.enabled) {
                return true;
            }
            return this.step == config.step && this.count == config.count;
        }
    }
}

