/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.customlinkage;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractExecutableHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.util.StringUtils;
import java.awt.KeyboardFocusManager;
import java.util.Map;
import java.util.TreeMap;

public class CustomHyperLinkExec
extends AbstractExecutableHyperLinkExec {
    public void execute(String linkTo) {
        if (StringUtils.isEmpty((String)linkTo)) {
            this.malformedHyperLink(linkTo);
            return;
        }
        Sheet sheet = this._guiExecutor.getSpreadContext().getBook().getActiveSheet();
        Cell activeCell = sheet.getActiveCell();
        HyperlinkCalculableProps props = (HyperlinkCalculableProps)activeCell.getExtProps(false).getFormulas(false).get(ExtConst.FORMULA_HYPERLINK);
        ExternalTargets externals = (ExternalTargets)props.getTargets().get("EXTERNAL");
        ExtProps ep = activeCell.getExtProps(true);
        Map<String, Object> targets = externals.getTargetsByName(linkTo);
        Map params = (Map)targets.get("JAVA_PARAMS");
        IExtRuntimeDataProvider dataProvider = this._guiExecutor.getDataProvider();
        ep.executeParams(params);
        Map<String, Map<String, Object>> jsonMap = this.transToJsonMap(params);
        String targetClass = (String)targets.get("JAVA_CLASS_NAME");
        dataProvider.cacheCustomHyperLinkParams(jsonMap, targetClass);
    }

    private Map<String, Map<String, Object>> transToJsonMap(Map<String, IParameter> params) {
        TreeMap<String, Map<String, Object>> ret = new TreeMap<String, Map<String, Object>>();
        if (params == null || params.isEmpty()) {
            return ret;
        }
        for (Map.Entry<String, IParameter> entry : params.entrySet()) {
            String key = entry.getKey();
            IParameter parameter = entry.getValue();
            ret.put(key, parameter.toJsonFormMap());
        }
        return ret;
    }

    private void malformedHyperLink(String linkTo) {
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(4, CtrlEXTMessages.getMLS("invalidCodeCustomization", "\u975e\u6cd5\u7684\u4ee3\u7801\u5b9a\u5236\u8054\u67e5\u94fe\u63a5\uff01\u76ee\u6807\u8054\u67e5\u94fe\u63a5\u4fe1\u606f:") + linkTo);
        }
        MessageUtil.msgboxWarning(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), CtrlEXTMessages.getMLS("invalidCodeCustomization", "\u975e\u6cd5\u7684\u4ee3\u7801\u5b9a\u5236\u8054\u67e5\u94fe\u63a5\uff01\u76ee\u6807\u8054\u67e5\u94fe\u63a5\u4fe1\u606f:"));
    }
}

