/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.datawalker;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.IHyperLinkJumper;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class DataWalkerHyperLinkAssembler
extends AbstractHyperLinkAssembler {
    public static final String PREFIX = "JAVA_JUMPER:";
    public static final String JAVA_CLASS_NAME = "JAVA_CLASS_NAME";
    private KDTable _configTable;
    private KDWorkButton _delBtn;
    private KDWorkButton _insertBtn;
    private List lastAssembled;

    public DataWalkerHyperLinkAssembler(KDExt ext) {
        super(ext);
        this.initComps();
        this.initListeners();
    }

    private void initComps() {
        this._delBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        this._insertBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this._configTable = new KDTable();
        this._configTable.getSelectManager().setSelectMode(2);
        int colCount = 3;
        for (int i = 0; i < colCount; ++i) {
            this._configTable.addColumn(i);
        }
        this._configTable.getColumn(0).setWidth(40);
        this._configTable.getColumn(1).setWidth(130);
        this._configTable.getColumn(2).setWidth(325);
        this._configTable.addHeadRow();
        this._configTable.getHeadRow(0).getCell(0).setValue((Object)CtrlEXTMessages.getMLS("defaultExtend", "\u9ed8\u8ba4"));
        this._configTable.getHeadRow(0).getCell(1).setValue((Object)CtrlEXTMessages.getMLS("referenceName", "\u5f15\u7528\u540d\u79f0"));
        this._configTable.getHeadRow(0).getCell(2).setValue((Object)CtrlEXTMessages.getMLS("javaLinkageClassPath", "Java\u8054\u67e5\u7c7b\u8def\u5f84"));
        this._configTable.getIndexColumn().getStyleAttributes().setHided(true);
        this._configTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.setCustomInsets(new Insets(5, 5, 5, 5));
        TableLayout2 layout = new TableLayout2(2, 3);
        this.setLayout((LayoutManager)layout);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 22);
        layout.setFixedWidth(2, 22);
        layout.setFixedHeight(0, 22);
        layout.setRatableHeight(1, 1);
        layout.setRowSpacing(0, 5);
        layout.setColSpacing(1, 4);
        KDLabel reportLbl = new KDLabel(CtrlEXTMessages.getMLS("basicSettings", "\u57fa\u672c\u8bbe\u7f6e"));
        this.add((Component)reportLbl, TableLayout2.param((int)0, (int)0));
        this.add((Component)this._delBtn, TableLayout2.param((int)0, (int)2));
        this.add((Component)this._insertBtn, TableLayout2.param((int)0, (int)1));
        this.add((Component)this._configTable, TableLayout2.param((int)1, (int)0, (int)1, (int)2));
    }

    private void initListeners() {
        this._delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow rowRemoved = DataWalkerHyperLinkAssembler.this._configTable.removeRow(DataWalkerHyperLinkAssembler.this._configTable.getSelectManager().getActiveRowIndex());
                if (rowRemoved != null && Boolean.TRUE.equals(rowRemoved.getCell(0).getValue()) && DataWalkerHyperLinkAssembler.this._configTable.getRowCount() != 0) {
                    IRow firstRow = DataWalkerHyperLinkAssembler.this._configTable.getRow(0);
                    firstRow.getCell(0).setValue((Object)Boolean.TRUE);
                }
            }
        });
        this._insertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                boolean firstRow = false;
                if (DataWalkerHyperLinkAssembler.this._configTable.getRowCount() == 0) {
                    firstRow = true;
                }
                IRow rowAdded = (index = DataWalkerHyperLinkAssembler.this._configTable.getSelectManager().getActiveRowIndex()) < 0 ? DataWalkerHyperLinkAssembler.this._configTable.addRow() : DataWalkerHyperLinkAssembler.this._configTable.addRow(index);
                if (firstRow) {
                    rowAdded.getCell(0).setValue((Object)Boolean.TRUE);
                } else {
                    rowAdded.getCell(0).setValue((Object)Boolean.FALSE);
                }
                DataWalkerHyperLinkAssembler.this._configTable.getEditManager().editCellAt(rowAdded.getRowIndex(), 1);
            }
        });
        this._configTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                if (e.getColIndex() == 0 && Boolean.TRUE == e.getOldValue()) {
                    e.setCancel(true);
                }
            }

            public void editCanceled(KDTEditEvent e) {
                if (e.getColIndex() == 1 && e.getOldValue() == null) {
                    DataWalkerHyperLinkAssembler.this._configTable.removeRow(e.getRowIndex());
                }
            }

            public void editStopping(KDTEditEvent e) {
                int col = e.getColIndex();
                if (col == 0 && !e.getValue().equals(e.getOldValue())) {
                    int size = DataWalkerHyperLinkAssembler.this._configTable.getRowCount();
                    for (int i = 0; i < size; ++i) {
                        if (e.getRowIndex() == i) continue;
                        IRow otherRow = DataWalkerHyperLinkAssembler.this._configTable.getRow(i);
                        otherRow.getCell(0).setValue((Object)Boolean.FALSE);
                    }
                }
            }
        });
    }

    private void showMsgBox(String msg) {
        MessageUtil.msgboxInfo((Component)((Object)this), msg);
    }

    @Override
    public boolean checkValid() {
        HashSet<Object> allAlias = new HashSet<Object>();
        ArrayList<Integer> removeItem = new ArrayList<Integer>();
        int count = this._configTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this._configTable.getRow(i);
            Object value1 = curRow.getCell(1).getValue();
            Object value2 = curRow.getCell(2).getValue();
            if (value1 == null && value2 == null) {
                removeItem.add(0, i);
                continue;
            }
            if (value1 == null) {
                this.showMsgBox(CtrlEXTMessages.getMLS("referenceNameNotEmpty", "\u7b2c#1\u884c\u7684\u5f15\u7528\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01").replace("#1", String.valueOf(i + 1)));
                return false;
            }
            if (!allAlias.add(value1)) {
                this.showMsgBox(CtrlEXTMessages.getMLS("referenceNameConflict", "\u7b2c#1\u884c\u7684\u5f15\u7528\u540d\u79f0 [#2] \u4e0e\u5176\u4ed6\u884c\u91cd\u590d\uff01").replace("#1", String.valueOf(i + 1)).replace("#2", String.valueOf(value1)));
                return false;
            }
            if (value2 == null) {
                this.showMsgBox(CtrlEXTMessages.getMLS("PageView_CN_DI", "\u7b2c") + (i + 1) + "\u884c\u7684Java\u8054\u67e5\u7c7b\u8def\u5f84\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return false;
            }
            String clsName = (String)value2;
            try {
                if (IHyperLinkJumper.class.isAssignableFrom(Class.forName(clsName))) continue;
                this.showMsgBox(CtrlEXTMessages.getMLS("jointTargetClassNotImplement", "\u8054\u67e5\u76ee\u6807\u7c7b [#1] \u6ca1\u6709\u5b9e\u73b0IHyperLinkJumper\u63a5\u53e3").replace("#1", clsName));
                return false;
            }
            catch (ClassNotFoundException e) {
                this.showMsgBox(CtrlEXTMessages.getMLS("jointTargetClassNotFound", "\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u8054\u67e5\u76ee\u6807\u7c7b: ") + clsName);
                return false;
            }
        }
        for (Integer index : removeItem) {
            this._configTable.removeRow(index.intValue());
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return CtrlEXTMessages.getMLS("javaJointCheck", "Java\u8054\u67e5");
    }

    @Override
    public String getHyperLinkPrefix() {
        return PREFIX;
    }

    @Override
    public Map getSuggestedDefaultTarget() {
        Map map = null;
        int size = this.lastAssembled.size();
        for (int i = 0; i < size; ++i) {
            Map curMap = (Map)this.lastAssembled.get(i);
            if (curMap.get("DEFAULT_SUGGESTION") == null) continue;
            map = curMap;
            break;
        }
        return map;
    }

    public void setAssembledTargets(List maps) {
        this.lastAssembled = null;
        this._configTable.removeRows();
        if (maps == null) {
            return;
        }
        int size = maps.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)maps.get(i);
            IRow rowAdded = this._configTable.addRow();
            rowAdded.getCell(0).setValue((Object)Boolean.valueOf((String)map.get("DEFAULT_SUGGESTION")));
            rowAdded.getCell(1).setValue((Object)((String)map.get("DISPLAY_NAME")));
            rowAdded.getCell(2).setValue((Object)((String)map.get(JAVA_CLASS_NAME)));
        }
        this._configTable.getSelectManager().select(0, 0);
    }

    public List getAssembledTargets() {
        this.lastAssembled = null;
        int count = this._configTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (this.lastAssembled == null) {
                this.lastAssembled = new ArrayList();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            IRow curRow = this._configTable.getRow(i);
            map.put("ASSEMBLER_NAME", DataWalkerHyperLinkAssembler.class.getName());
            map.put("HYPERLINK_PREFIX", PREFIX);
            Object o = curRow.getCell(0).getValue();
            if (Boolean.TRUE.equals(o)) {
                map.put("DEFAULT_SUGGESTION", o.toString());
            } else {
                map.remove("DEFAULT_SUGGESTION");
            }
            map.put("DISPLAY_NAME", (String)curRow.getCell(1).getValue());
            map.put(JAVA_CLASS_NAME, (String)curRow.getCell(2).getValue());
            this.lastAssembled.add(map);
        }
        return this.lastAssembled;
    }
}

