/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit.datawalker;

import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetActiveIndexCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetMaxColCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetMaxRowCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetParameterValueCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetValueAtCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetValuesAtColumnCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.GetValuesAtRowCommand;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.IDataWalker;
import com.kingdee.cosmic.ctrl.ext.immit.datawalker.IDataWalkerCommand;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.HashMap;

public class SheetDataWalker
implements IDataWalker {
    private static HashMap _commands;
    public static final String GET_VALUE_AT = "GET_VALUE_AT";
    public static final String GET_MAX_ROW_INDEX = "GET_MAX_ROW_INDEX";
    public static final String GET_MAX_COL_INDEX = "GET_MAX_COL_INDEX";
    public static final String GET_PARAMETER_VALUE = "GET_PARAMETER_VALUE";
    public static final String GET_VALUES_AT_ROW = "GET_VALUES_AT_ROW";
    public static final String GET_VALUES_AT_COLUMN = "GET_VALUES_AT_COLUMN";
    public static final String GET_ACTIVE_INDEX = "GET_ACTIVE_INDEX";
    private Sheet _sheet;

    public SheetDataWalker(Sheet sheet) {
        this._sheet = sheet;
    }

    @Override
    public boolean fetchData(String command, Object[] params) {
        IDataWalkerCommand commandRef = SheetDataWalker.getCommand(command);
        if (commandRef == null) {
            return false;
        }
        return commandRef.execute(this._sheet, params);
    }

    private static IDataWalkerCommand getCommand(String command) {
        IDataWalkerCommand commandRef;
        if (_commands == null) {
            _commands = new HashMap();
        } else {
            commandRef = (IDataWalkerCommand)_commands.get(command);
            if (commandRef != null) {
                return commandRef;
            }
        }
        if (GET_VALUE_AT.equals(command)) {
            commandRef = new GetValueAtCommand();
            _commands.put(GET_VALUE_AT, commandRef);
            return commandRef;
        }
        if (GET_MAX_ROW_INDEX.equals(command)) {
            commandRef = new GetMaxRowCommand();
            _commands.put(GET_MAX_ROW_INDEX, commandRef);
            return commandRef;
        }
        if (GET_MAX_COL_INDEX.equals(command)) {
            commandRef = new GetMaxColCommand();
            _commands.put(GET_MAX_COL_INDEX, commandRef);
            return commandRef;
        }
        if (GET_PARAMETER_VALUE.equals(command)) {
            commandRef = new GetParameterValueCommand();
            _commands.put(GET_PARAMETER_VALUE, commandRef);
            return commandRef;
        }
        if (GET_VALUES_AT_ROW.equals(command)) {
            commandRef = new GetValuesAtRowCommand();
            _commands.put(GET_VALUES_AT_ROW, commandRef);
            return commandRef;
        }
        if (GET_VALUES_AT_COLUMN.equals(command)) {
            commandRef = new GetValuesAtColumnCommand();
            _commands.put(GET_VALUES_AT_COLUMN, commandRef);
            return commandRef;
        }
        if (GET_ACTIVE_INDEX.equals(command)) {
            commandRef = new GetActiveIndexCommand();
            _commands.put(GET_ACTIVE_INDEX, commandRef);
            return commandRef;
        }
        return null;
    }

    public static boolean checkParamsValid(Object[] params, int pCount, Class[] clazz) {
        if (params == null || params.length != pCount) {
            return false;
        }
        if (clazz == null) {
            return true;
        }
        if (clazz.length > params.length) {
            return false;
        }
        boolean valid = true;
        int length = clazz.length;
        for (int i = 0; i < length; ++i) {
            valid = valid && params[i].getClass() == clazz[i];
        }
        return valid;
    }

    public static Cell getFirstCellForMerge(Sheet sheet, int row, int col) {
        SortedCellBlockArray sortedCellBlockArray;
        MergeBlocks mergeBlocks = sheet.getMerger(false);
        if (mergeBlocks != null && (sortedCellBlockArray = mergeBlocks.getTouchedBlocks(row, col, row, col)) != null) {
            CellBlock mergeCellBlocks = sortedCellBlockArray.getBounds();
            int firstRow = mergeCellBlocks.getRow();
            int firstCol = mergeCellBlocks.getCol();
            Cell firstCell = sheet.getCell(firstRow, firstCol, false);
            return firstCell;
        }
        return null;
    }
}

