/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.propsheet;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.BooleanAsCheckBoxPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.ColorPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.DatePropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.DoublePropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.FloatPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.IntegerPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.LongPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.PrimitiveBooleanPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.PrimitiveIntegerPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.PrimitiveStringPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.ShortPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.StringPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.DateVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.DoubleVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.FloatVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.LongVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ShortVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.StringVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.Property;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.PropertyDescriptorAdapter;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.PropertyEditorFactory;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private static final Logger logger = LogUtil.getPackageLogger(PropertyEditorRegistry.class);
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    @Override
    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        Class<?> clz;
        PropertyDescriptor descriptor;
        PropertyEditor editor = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) != null && (clz = descriptor.getPropertyEditorClass()) != null) {
            editor = this.loadPropertyEditor(clz);
        }
        if (editor == null) {
            Object value = this.propertyToEditor.get(property);
            editor = value instanceof PropertyEditor ? (PropertyEditor)value : (value instanceof Class ? this.loadPropertyEditor((Class)value) : this.getEditor(property.getType()));
        }
        if (editor == null && property instanceof PropertyDescriptorAdapter) {
            descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            clz = descriptor.getPropertyType();
            editor = PropertyEditorManager.findEditor(clz);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(StringVFPair.class, StringPropertyEditor.class);
        this.registerEditor(DoubleVFPair.class, DoublePropertyEditor.class);
        this.registerEditor(FloatVFPair.class, FloatPropertyEditor.class);
        this.registerEditor(IntegerVFPair.class, IntegerPropertyEditor.class);
        this.registerEditor(LongVFPair.class, LongPropertyEditor.class);
        this.registerEditor(ShortVFPair.class, ShortPropertyEditor.class);
        this.registerEditor(BooleanVFPair.class, BooleanAsCheckBoxPropertyEditor.class);
        this.registerEditor(DateVFPair.class, DatePropertyEditor.class);
        this.registerEditor(ColorVFPair.class, ColorPropertyEditor.class);
        this.registerEditor(Integer.TYPE, PrimitiveIntegerPropertyEditor.class);
        this.registerEditor(Boolean.TYPE, PrimitiveBooleanPropertyEditor.class);
        this.registerEditor(String.class, PrimitiveStringPropertyEditor.class);
    }
}

