/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.reporting.model.CommitType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.UpdateType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateProperty;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.log4j.Logger;

public class ReportingModelLoader {
    private static Logger logger = Logger.getLogger(ReportingModelLoader.class);

    public IReportingModel load(IReportingModel emptyModel, Book book, String modelString) throws IOException, XmlParsingException {
        if (StringUtil.isEmptyString((String)modelString)) {
            emptyModel.setSheet(book.getActiveSheet());
            return emptyModel;
        }
        IReportingModel model = emptyModel;
        IXmlElement modelElement = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(modelString.getBytes("UTF-8")));
        try {
            model.setSheet(book.getSheetByName(modelElement.getAttribute("sheetName")));
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"can not find correct sheet! loading stopped!", (Throwable)e);
            return model;
        }
        model.setCommitType(CommitType.getInstance(modelElement.getAttribute("commitType")));
        model.setEnabled(Boolean.parseBoolean(modelElement.getAttribute("enabled")));
        model.setFastInvalid(Boolean.parseBoolean(modelElement.getAttribute("isFastInvalid")));
        List updates = modelElement.searchChildren("UpdateConstrant");
        if (updates != null) {
            for (int i = 0; i < updates.size(); ++i) {
                IXmlElement consElement = (IXmlElement)updates.get(i);
                IUpdateConstraint constraint = model.createEmptyUpdateConstraint();
                constraint.setProperty(consElement.getAttribute("property"));
                constraint.setDBID(consElement.getAttribute("dbID"));
                constraint.setUpdateType(UpdateType.getInstance(consElement.getAttribute("updateType")));
                constraint.setUserDefineName(consElement.getAttribute("userDefineName"));
                List properties = consElement.searchChildren("UpdateProperty");
                if (properties == null) continue;
                for (int j = 0; j < properties.size(); ++j) {
                    IXmlElement propElement = (IXmlElement)properties.get(j);
                    IUpdateProperty property = constraint.createEmptytUpdateProperties();
                    property.setFormula(propElement.getAttribute("formula"));
                    property.setPropertyName(propElement.getAttribute("propertyName"));
                    property.setJdbcDataType(Integer.parseInt(propElement.getAttribute("jdbcDataType")));
                    property.setPrimaryKey(Boolean.parseBoolean(propElement.getAttribute("isPrimaryKey")));
                }
            }
        }
        return model;
    }
}

