/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.dirty;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.cosmic.ctrl.ext.reporting.exception.ExtReportingBizException;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.CommitResult;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.cosmic.ctrl.ext.util.VariantUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExtReportingDirtyManagerLoader {
    public void load(ExtReportingDirtyManager manager) throws ExtReportingBizException {
        String lastValue = (String)manager._book.getUserObjectValue("EXT_REPORTING_DIRTY_MANAGER_CONTENT_USER_OBJECT_KEY");
        Book book = manager._book;
        IReportingModel model = book.getReportingModel();
        if (StringUtil.isEmptyString((String)lastValue) || model == null) {
            return;
        }
        IUpdateConstraint[] contraints = model.getUpdateConstraintList();
        if (contraints == null || contraints.length == 0) {
            return;
        }
        HashMap<String, IUpdateConstraint> constraintMap = new HashMap<String, IUpdateConstraint>();
        for (int i = 0; i < contraints.length; ++i) {
            constraintMap.put(contraints[i].getUserDefineName(), contraints[i]);
        }
        try {
            IXmlElement root = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(lastValue.getBytes("UTF-8")));
            List recodes = root.getChild("Recodes").searchChildren("Recode");
            manager._records = new ArrayList();
            for (IXmlElement recode : recodes) {
                String className = recode.getAttribute("className");
                String constraintName = recode.getAttribute("constraintName");
                String identityKey = recode.getAttribute("identityKey");
                ArrayList<Cell> cellList = new ArrayList<Cell>();
                List cells = recode.searchChildren("Cell");
                int index = 0;
                for (IXmlElement cell : cells) {
                    cellList.add(book.getSheetByName(cell.getAttribute("sheetName")).getCell(Integer.parseInt(cell.getAttribute("rowIndex")), Integer.parseInt(cell.getAttribute("colIndex")), true));
                }
                List valueElementList = recode.searchChildren("CommitValue");
                Variant[] values = new Variant[valueElementList.size()];
                int[] jdbcTypes = new int[valueElementList.size()];
                for (IXmlElement commitValue : valueElementList) {
                    String type = commitValue.getAttribute("valueType");
                    jdbcTypes[index] = Integer.parseInt(commitValue.getAttribute("jdbcType"));
                    values[index++] = VariantUtil.parsePlainString2Variant(commitValue.getAttribute("value"), Byte.parseByte(type));
                }
                IUpdateConstraint constraint = (IUpdateConstraint)constraintMap.get(constraintName);
                Class<?> clazz = Class.forName(className);
                ExecutionPlan plan = (ExecutionPlan)clazz.getConstructor(String.class, Cell[].class, IUpdateConstraint.class).newInstance(identityKey, cellList.toArray(new Cell[0]), constraint);
                plan.setLoaded(true);
                plan.setValues(values);
                plan.setJdbcTypes(jdbcTypes);
                plan.setSQL(recode.getAttribute("sqlContent"));
                manager._records.add(plan);
            }
            manager._commitResults = new ArrayList();
            List results = root.getChild("Results").searchChildren("Result");
            for (IXmlElement result : results) {
                String className = result.getAttribute("className");
                Class<?> clazz = Class.forName(className);
                CommitResult cr = (CommitResult)clazz.getConstructor(String.class, String.class, String.class).newInstance(result.getAttribute("identityKey"), result.getText(), result.getAttribute("level"));
                manager._commitResults.add(cr);
            }
        }
        catch (Throwable cause) {
            throw new ExtReportingBizException("error ocurred during loading dirty manager", cause);
        }
    }
}

