/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.dirty;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.DeleteDataPlan;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.InsertDataPlan;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.UpdateDataPlan;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import java.util.UUID;

public class UpdateDataPlanCreator {
    private ExtReportingDirtyManager _manager;

    public UpdateDataPlanCreator(ExtReportingDirtyManager manager) {
        this._manager = manager;
    }

    public void addUpdateDataPlan(Cell cll) {
        ExtProps props = cll.getExtProps(true);
        Cell srcCll = props.getSource().getCell();
        IUpdateConstraint[] constraints = this._manager._cell2ConstraintMap.get(srcCll);
        if (constraints == null) {
            return;
        }
        for (int i = 0; i < constraints.length; ++i) {
            Cell[] all = this._manager.findAllBrotherCells(cll.getRow() - srcCll.getRow(), cll.getCol() - srcCll.getCol(), constraints[i].getUsedCellList(false));
            ExecutionPlan plan = this._manager.searchSameRecord(all);
            if (plan == null) {
                plan = constraints[i].getPKCells().contains(srcCll) && StringUtil.isEmptyString((String)cll.getFormula()) ? new InsertDataPlan(UUID.randomUUID().toString(), all, constraints[i]) : new UpdateDataPlan(UUID.randomUUID().toString(), all, constraints[i]);
                this._manager._records.add(plan);
                continue;
            }
            if (plan instanceof UpdateDataPlan) {
                if (!constraints[i].getPKCells().contains(srcCll) || !StringUtil.isEmptyString((String)cll.getFormula())) continue;
                this._manager._records.remove(plan);
                plan = new InsertDataPlan(plan.getIdentityKey(), all, constraints[i]);
                this._manager._records.add(plan);
                continue;
            }
            if (!(plan instanceof DeleteDataPlan)) continue;
            this.saveDeletedData((DeleteDataPlan)plan, constraints[i]);
        }
    }

    private void saveDeletedData(DeleteDataPlan plan, IUpdateConstraint cons) {
        this._manager._records.remove(plan);
        Cell[] cells = plan.getUsedCells();
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxRow = -1;
        int maxCol = -1;
        for (int i = 0; i < cells.length; ++i) {
            minRow = Math.min(minRow, cells[i].getRow());
            minCol = Math.min(minCol, cells[i].getCol());
            maxRow = Math.max(maxRow, cells[i].getRow());
            maxCol = Math.max(maxCol, cells[i].getCol());
        }
        CellBlock cb = CellBlock.getCellBlock(minRow, minCol, maxRow, maxCol);
        Sheet activeSheet = this._manager._book.getActiveSheet();
        Sheet.ICellsIterator iter = activeSheet.getCellsIterator(cb, true, false);
        while (iter.hasNext()) {
            Cell cll = iter.next();
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            if (!sa.isStrikeThrough()) continue;
            sa.setStrikeThrough(false);
            cll.setSSA((ShareStyleAttributes)sa);
        }
        UpdateDataPlan updatePlan = new UpdateDataPlan(plan.getIdentityKey(), cells, cons);
        this._manager._records.add(updatePlan);
        this._manager._book.fireBookPropertyChange(null, null, "Global_Repaint");
    }
}

