/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.BaseBeanInfo;
import com.kingdee.cosmic.ctrl.ext.pe.beans.DefaultBeanInfoResolver;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.Property;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.PropertySheetPanel;
import com.kingdee.cosmic.ctrl.ext.pe.propsheet.PropertySheetTable;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartLocationChooserPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultCombinationSeriesBeanBeanInfo;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.propsheet.FusionBeanPropertyEditorRegistry;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.propsheet.FusionBeanPropertyRendererRegistry;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;

public class FusionChartPropertiesChooserPanel
extends AbstractChartPanel {
    private static final long serialVersionUID = 1L;
    private KDTabbedPane pane;
    private KDPanel[] container;
    private String[] titles;
    private PropertySheetPanel propertySheetPanel;

    FusionChartPropertiesChooserPanel(IWizardStep last, SpreadContext context, Container parent, FusionGraphicsModel model) {
        super(last, context, parent, model);
        this.title = CtrlEXTMessages.getMLS("fourthStepChartPropertiesSettings", "\u7b2c\u56db\u6b65\uff1a\u56fe\u8868\u5c5e\u6027\u8bbe\u7f6e");
        this.last = last;
        this.pane = new KDTabbedPane();
    }

    @Override
    public KDPanel getImpl() {
        return this.container[0];
    }

    @Override
    public String getTitle() {
        return CtrlEXTMessages.getMLS("chartProperties", "\u56fe\u8868\u5c5e\u6027");
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(400, 360));
        this.setLayout(new BorderLayout());
        this.container = new KDPanel[1];
        this.container[0] = new KDPanel();
        this.titles = new String[]{CtrlEXTMessages.getMLS("KEY_SetChart", "\u56fe\u8868\u8bbe\u7f6e")};
        this.initPanel(this.container[0]);
        this.pane.add(this.titles[0], (Component)this.container[0]);
        this.add((Component)this.pane);
        this.pane.revalidate();
    }

    private void initPanel(KDPanel panel) {
        PropertySheetTable table = new PropertySheetTable();
        table.getActionMap().put("selectNextRowCell", new SelectAndEditAction(table.getActionMap().get("selectNextRowCell")));
        table.getActionMap().put("selectPreviousRowCell", new SelectAndEditAction(table.getActionMap().get("selectPreviousRowCell")));
        table.setEditorFactory(new FusionBeanPropertyEditorRegistry(this.context));
        table.setRendererFactory(new FusionBeanPropertyRendererRegistry(this.context));
        this.propertySheetPanel = new PropertySheetPanel(table);
        BeanInfo info = new DefaultBeanInfoResolver().getBeanInfo(this.model.getBean());
        this.specifyBeanInfo(this.model.getBean().getChartType(), info);
        this.propertySheetPanel.setMode(1);
        this.propertySheetPanel.setDescriptionVisible(true);
        this.propertySheetPanel.setBeanInfo(info);
        this.propertySheetPanel.addPropertySheetChangeListener(new PropertySheetPanelListener());
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)this.propertySheetPanel);
    }

    @Override
    public boolean syncGraphics2Model(int type) {
        if (this.checkValid()) {
            return false;
        }
        if (this.propertySheetPanel != null) {
            this.propertySheetPanel.getTable().commitEditing();
        }
        DataLabelUtil.changeFlashChartType2DataSortLabel(this.context, this.model.getChartType(), this.model.getFramworkType()).composeProperties(this.model.getBean(), this.model.getDataNode());
        return true;
    }

    @Override
    public void syncModel2Graphics(int type) {
        AbstractFusionBean bean = this.model.getBean();
        DataLabelUtil.changeFlashChartType2DataSortLabel(this.context, this.model.getChartType(), this.model.getFramworkType()).prepareProperties(bean, this.model.getDataNode());
        if (this.propertySheetPanel != null) {
            BeanInfo info = new DefaultBeanInfoResolver().getBeanInfo(this.model.getBean());
            if (!this.context.getBook().is4Mobile()) {
                ((BaseBeanInfo)info).removeProperty("frozenFixed");
            }
            if (DataLabelUtil.isDoubleYChart(this.model.getChartType())) {
                ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("chartYScaleUnit");
            }
            this.propertySheetPanel.setBeanInfo(info);
            this.propertySheetPanel.readFromObject(bean);
        }
    }

    @Override
    public boolean prepare() {
        super.prepare();
        if (this.next != null) {
            ((FusionChartLocationChooserPanel)this.next).setModel(this.model);
        }
        int count = this.pane.getTabCount();
        for (int i = 0; i < count; ++i) {
            this.pane.removeTabAt(0);
        }
        this.initComponents();
        this.revalidate();
        return true;
    }

    @Override
    public IWizardStep getNextStep() {
        this.initNextStep();
        if (this.model.getChartType() == null) {
            return null;
        }
        return this.next;
    }

    @Override
    public void initNextStep() {
        if (this.next == null) {
            this.next = new FusionChartLocationChooserPanel(this, this.context, this.parent, this.model);
        }
    }

    @Override
    public boolean checkValid() {
        String chartName = this.model.getBean().getChartName();
        Set<String> names = this.loadAllChartNamesExcludeSelf();
        if (names.contains(chartName)) {
            MessageUtil.msgboxWarning((Component)((Object)this), CtrlEXTMessages.getMLS("duplicateChartName2", "\u5b58\u5728\u76f8\u540c\u7684\u56fe\u8868\u540d\u79f0\u3010#1\u3011").replace("#1", chartName));
            return true;
        }
        return false;
    }

    private Set<String> loadAllChartNamesExcludeSelf() {
        Sheet activeSheet = this.context.getBook().getActiveSheet();
        EmbedhLayer embedments = activeSheet.getEmbedments(false);
        EmbedObject me = null;
        if (embedments != null) {
            me = activeSheet.getEmbedments(false).getActiveSelectedEmbed();
        }
        String myId = null;
        if (me instanceof ChartRectEmbedment) {
            myId = ((ChartRectEmbedment)me).getEmbedId();
        }
        HashSet<String> names = new HashSet<String>(8);
        if (embedments != null) {
            int embeds = embedments.size();
            for (int j = 0; j < embeds; ++j) {
                EmbedObject embed = embedments.getEmbed(j);
                if (!(embed instanceof ChartRectEmbedment) || !StringUtil.isEmptyString((String)myId) && myId.equals(((ChartRectEmbedment)embed).getEmbedId())) continue;
                names.add(embed.getName());
            }
        }
        return names;
    }

    @Override
    public EmbedObject compose() {
        return super.compose();
    }

    private BeanInfo specifyBeanInfo(FlashChartType chartType, BeanInfo info) {
        if (chartType == FlashChartType.FLASH_CT_COMBI3D) {
            ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("trendlineTrendzone");
            ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("trendlineDashed");
            ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("trendlineOnTop");
        } else if (DataLabelUtil.isDoubleYChart(chartType)) {
            ((DefaultCombinationSeriesBeanBeanInfo)info).addRightYAxisSettings();
            ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("showTrendLineValue");
            ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("trendlineDisplayRight");
            ((DefaultCombinationSeriesBeanBeanInfo)info).removeProperty("chartYScaleUnit");
        }
        return info;
    }

    private static class SelectAndEditAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        Action delegate;

        SelectAndEditAction(Action delegate) {
            this.delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table;
            if (this.delegate != null) {
                this.delegate.actionPerformed(e);
            }
            if (!(table = (JTable)e.getSource()).hasFocus()) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                table.requestFocus();
                return;
            }
            ListSelectionModel rsm = table.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            table.editCellAt(anchorRow, 1);
            Component editorComp = table.getEditorComponent();
            if (editorComp != null) {
                editorComp.requestFocus();
            }
        }
    }

    private class PropertySheetPanelListener
    implements PropertyChangeListener {
        private PropertySheetPanelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Property prop = (Property)evt.getSource();
            try {
                prop.writeToObject(FusionChartPropertiesChooserPanel.this.model.getBean());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof PropertyVetoException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(FusionChartPropertiesChooserPanel.this.propertySheetPanel);
                    prop.setValue(evt.getOldValue());
                }
                throw e;
            }
        }
    }
}

