/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartDataAreaChooserPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.ChartTypeButton;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.ChartTypeSortLabel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.SelectionButtonChangedListener;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.SortLabelUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.layout.ChartTypeChooserPanelLayout;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.layout.SmartLayout;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDEditorPane;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class FusionChartTypeChooserPanel
extends AbstractChartPanel
implements SelectionButtonChangedListener {
    private static final Logger logger = LogUtil.getLogger(FusionChartTypeChooserPanel.class);
    private static final long serialVersionUID = 1L;
    private KDTabbedPane tabbedPane = new KDTabbedPane();
    private KDPanel flashChartPanel = new KDPanel();
    private JTextComponent detail = new KDEditorPane("text/html", "");
    private KDPanel detailPanel = new KDPanel();
    private KDList flashList;
    private KDScrollPane flashScroll;
    private KDButtonGroup bg;
    private KDRadioButton nullValue;
    private KDRadioButton zeroValue;
    private KDCheckBox showHideData;
    private KDPanel cellPane;
    private KDDialog dialog;
    private KDButton showHideEdit;
    private KDButton confirm;
    private KDButton cancle;
    private TimingTargetImpl impl = new TimingTargetImpl(this.detailPanel);
    private Animator animator = new Animator(300, (TimingTarget)this.impl);
    private SmartLayout smartLayout = new SmartLayout();

    public FusionChartTypeChooserPanel(IWizardStep last, SpreadContext context, Container parent, FusionGraphicsModel model) {
        super(last, context, parent, model);
        this.title = CtrlEXTMessages.getMLS("secondStepChartTypeSelection", "\u7b2c\u4e8c\u6b65\uff1a\u9009\u62e9\u56fe\u8868\u7c7b\u578b");
        this.initComponents();
        this.initListeners();
    }

    @Override
    public KDPanel getImpl() {
        return this.flashChartPanel;
    }

    @Override
    public String getTitle() {
        return CtrlEXTMessages.getMLS("chartType", "\u56fe\u8868\u7c7b\u578b");
    }

    private void initComponents() {
        this.flashList = new KDList((Object[])SortLabelUtil.getSuitableLabels(this.model == null ? null : this.model.getFramworkType()));
        this.flashScroll = new KDScrollPane((Component)this.flashList);
        this.setPreferredSize(new Dimension(400, 360));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        flow.setVgap(flow.getVgap() + 3);
        this.detailPanel.setLayout((LayoutManager)flow);
        this.detail.setEnabled(false);
        this.detail.setBackground(this.detailPanel.getBackground());
        this.detail.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.detail.setForeground(Color.black);
        this.flashChartPanel.setLayout((LayoutManager)new ChartTypeChooserPanelLayout());
        this.tabbedPane.add(CtrlEXTMessages.getMLS("chartType", "\u56fe\u8868\u7c7b\u578b"), (Component)this.flashChartPanel);
        this.flashChartPanel.add((Component)this.flashScroll);
        this.flashChartPanel.add((Component)new KDScrollPane((Component)this.detail));
        KDScrollPane sp = new KDScrollPane((Component)this.detailPanel);
        sp.setBorder(BorderFactory.createRaisedBevelBorder());
        sp.getVerticalScrollBar().setUnitIncrement(133);
        this.flashChartPanel.add((Component)sp);
        this.showHideEdit = new KDButton(CtrlEXTMessages.getMLS("hiddenAndEmptyCells", "\u9690\u85cf\u7684\u548c\u7a7a\u7684\u5355\u5143\u683c"));
        this.confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this.cancle = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this.showHideEdit.setEnabled(false);
    }

    @Override
    public boolean prepare() {
        if (null == this.model.getChartType()) {
            this.reAssembleComponent(SortLabelUtil.getSuitableLabels(this.model.getFramworkType()));
            if (ChartFrameWorkType.QINGCHART == this.model.getFramworkType()) {
                this.model.setChartType(QingChartType.QING_CT_PIE);
                this.setSelectedItem(QingChartType.QING_CT_PIE);
            } else {
                this.model.setChartType(FlashChartType.FLASH_CT_PIE2D);
                this.setSelectedItem(FlashChartType.FLASH_CT_PIE2D);
            }
        } else {
            this.setSelectedItem(this.model.getChartType());
        }
        return super.prepare();
    }

    private void listSelectionChanged() {
        this.showHideEdit.setEnabled(false);
        this.detailPanel.removeAll();
        ChartTypeSortLabel selection = (ChartTypeSortLabel)this.flashList.getSelectedValue();
        if (selection != null) {
            this.detail.setText(selection.getDescription());
            KDPanel[] p = selection.getPanels(this.detail);
            boolean hasRemain = p.length % 3 != 0;
            this.detailPanel.setPreferredSize(new Dimension(500, (p.length / 3 + (hasRemain ? 1 : 0)) * 162));
            int length = p.length;
            for (int i = 0; i < length; ++i) {
                if (p[i] == null) continue;
                this.detailPanel.add((Component)p[i]);
            }
            this.detailPanel.repaint();
            this.detailPanel.revalidate();
            if (this.model != null) {
                this.model.setChartType(((ChartTypeButton)p[0].getComponent(0)).getChartType());
            }
            if (ChartTypeButton.currentSelection() != null) {
                ChartTypeButton.currentSelection().setSelected(false);
                ChartTypeButton.clearSelection();
            }
            this.setSelectedItem(((ChartTypeButton)p[0].getComponent(0)).getChartType());
        } else {
            this.flashList.setSelectedIndex(0);
        }
    }

    private void initListeners() {
        this.flashList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FusionChartTypeChooserPanel.this.listSelectionChanged();
            }
        });
        this.flashList.setSelectedIndex(0);
        this.showHideEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FusionChartTypeChooserPanel.this.dialog == null) {
                    FusionChartTypeChooserPanel.this.dialog = new KDDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)FusionChartTypeChooserPanel.this)), CtrlEXTMessages.getMLS("hiddenAndEmptyCellRepresentation", "\u8bbe\u7f6e\u9690\u85cf\u7684\u5355\u5143\u683c\u548c\u7a7a\u5355\u5143\u683c\u7684\u8868\u793a"));
                    FusionChartTypeChooserPanel.this.dialog.setSize(240, 150);
                    FusionChartTypeChooserPanel.this.dialog.setResizable(false);
                    FusionChartTypeChooserPanel.this.dialog.setModal(true);
                    FusionChartTypeChooserPanel.this.cellPane = new KDPanel();
                    FusionChartTypeChooserPanel.this.bg = new KDButtonGroup();
                    FusionChartTypeChooserPanel.this.nullValue = new KDRadioButton(CtrlEXTMessages.getMLS("ignoreEmptyCells", "\u7a7a\u5355\u5143\u683c\u5c06\u88ab\u5ffd\u7565"));
                    FusionChartTypeChooserPanel.this.zeroValue = new KDRadioButton(CtrlEXTMessages.getMLS("showEmptyCellsAsZero", "\u7a7a\u5355\u5143\u683c\u663e\u793a\u4e3a\u96f6"));
                    FusionChartTypeChooserPanel.this.showHideData = new KDCheckBox(CtrlEXTMessages.getMLS("showHiddenRowsAndColumns", "\u663e\u793a\u9690\u85cf\u884c\u5217\u4e2d\u7684\u6570\u636e"));
                    FusionChartTypeChooserPanel.this.bg.add((AbstractButton)FusionChartTypeChooserPanel.this.nullValue);
                    FusionChartTypeChooserPanel.this.bg.add((AbstractButton)FusionChartTypeChooserPanel.this.zeroValue);
                    FusionChartTypeChooserPanel.this.cellPane.setLayout(null);
                    FusionChartTypeChooserPanel.this.nullValue.setBounds(12, 10, 120, 21);
                    FusionChartTypeChooserPanel.this.cellPane.add((Component)FusionChartTypeChooserPanel.this.nullValue);
                    FusionChartTypeChooserPanel.this.zeroValue.setBounds(12, 40, 120, 21);
                    FusionChartTypeChooserPanel.this.cellPane.add((Component)FusionChartTypeChooserPanel.this.zeroValue);
                    FusionChartTypeChooserPanel.this.showHideData.setBounds(10, 70, 200, 21);
                    FusionChartTypeChooserPanel.this.cellPane.add((Component)FusionChartTypeChooserPanel.this.showHideData);
                    FusionChartTypeChooserPanel.this.confirm.setBounds(10, 100, 100, 21);
                    FusionChartTypeChooserPanel.this.cellPane.add((Component)FusionChartTypeChooserPanel.this.confirm);
                    FusionChartTypeChooserPanel.this.cancle.setBounds(120, 100, 100, 21);
                    FusionChartTypeChooserPanel.this.cellPane.add((Component)FusionChartTypeChooserPanel.this.cancle);
                    FusionChartTypeChooserPanel.this.dialog.getContentPane().add((Component)FusionChartTypeChooserPanel.this.cellPane);
                    FusionChartTypeChooserPanel.this.bg.setValue(0);
                    FusionChartTypeChooserPanel.this.showHideData.setSelected(true);
                }
                FusionChartTypeChooserPanel.this.dialog.setLocationRelativeTo((Component)SwingUtilities.getWindowAncestor((Component)((Object)FusionChartTypeChooserPanel.this)));
                FusionChartTypeChooserPanel.this.dialog.show();
            }
        });
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FusionChartDataNode node = FusionChartTypeChooserPanel.this.model.getDataNode();
                if (FusionChartTypeChooserPanel.this.bg.getValue() == 0) {
                    node.setFormula("false", FusionChartDataNode.NullCellType);
                } else {
                    node.setFormula("true", FusionChartDataNode.NullCellType);
                }
                if (FusionChartTypeChooserPanel.this.showHideData.isSelected()) {
                    node.setFormula("false", FusionChartDataNode.HideCellType);
                } else {
                    node.setFormula("true", FusionChartDataNode.HideCellType);
                }
                FusionChartTypeChooserPanel.this.dialog.dispose();
            }
        });
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FusionChartTypeChooserPanel.this.dialog.dispose();
            }
        });
    }

    public void setSelectedItem(FlashChartType fct) {
        if (this.flashList == null) {
            logger.warn((Object)CtrlEXTMessages.getMLS("emptyChartContent", "\u56fe\u8868\u5185\u5bb9\u4e3a\u7a7a"));
            return;
        }
        int len = this.flashList.getElementCount();
        for (int i = 0; i < len; ++i) {
            ChartTypeSortLabel element = (ChartTypeSortLabel)this.flashList.getElement(i);
            ChartTypeSortLabel current = SortLabelUtil.getChartSortDes(fct);
            if (current != element) continue;
            this.flashList.setSelectedValue((Object)element, true);
            KDPanel[] ps = element.getPanels(this.detail);
            if (ps == null) continue;
            if (ChartTypeButton.currentSelection() != null) {
                ChartTypeButton.clearSelection();
            }
            this.detailPanel.removeAll();
            int length = ps.length;
            for (int k = 0; k < length; ++k) {
                if (ps[k] != null) {
                    this.detailPanel.add((Component)ps[k]);
                }
                if (((ChartTypeButton)ps[k].getComponent(0)).getChartType() != fct) continue;
                ((ChartTypeButton)ps[k].getComponent(0)).doClick();
            }
            this.detailPanel.validate();
            this.detailPanel.repaint();
            break;
        }
    }

    private void refreshModel(FlashChartType fct) {
        String chartName = null;
        if (this.model.getBean() != null) {
            chartName = this.model.getBean().getChartName();
            this.model.getBean().setChartType(fct);
            this.model.getBean().setChartName(chartName);
        }
        this.model.setChartType(fct);
        this.impl.setButtons(((ChartTypeSortLabel)this.flashList.getSelectedValue()).getButtons(this.detail));
        this.animator.stop();
        this.animator.start();
        this.detailPanel.doLayout();
        this.detailPanel.repaint();
    }

    public void clearSelection() {
        ChartTypeButton.clearSelection();
        this.flashList.setSelectedIndex(0);
        this.listSelectionChanged();
        this.detailPanel.validate();
        this.detailPanel.repaint();
    }

    @Override
    protected void initNextStep() {
        FlashChartType chartType = this.model.getChartType();
        if (this.next == null && chartType != null) {
            this.next = new FusionChartDataAreaChooserPanel(this, this.context, this.parent, this.model);
        } else if (chartType != null) {
            ((FusionChartDataAreaChooserPanel)this.next).reInit(this.model);
        }
    }

    @Override
    public void reAssembleComponent(Object[] elems) {
        this.flashList.removeAllElements();
        if (elems != null && elems.length > 0) {
            for (Object elem : elems) {
                this.flashList.addElement(elem);
            }
        }
    }

    @Override
    public IWizardStep getNextStep() {
        this.initNextStep();
        if (this.model.getChartType() == null) {
            return null;
        }
        return this.next;
    }

    @Override
    public boolean syncGraphics2Model(int type) {
        this.setSelectedItem(this.model.getChartType());
        return true;
    }

    @Override
    public void syncModel2Graphics(int type) {
    }

    @Override
    public void selectionChanged(FlashChartType newFct) {
        this.refreshModel(newFct);
    }

    public class TimingTargetImpl
    extends TimingTargetAdapter {
        ChartTypeButton[] buttons;

        TimingTargetImpl(KDPanel layoutPanel) {
        }

        public void setButtons(ChartTypeButton[] buttons) {
            this.buttons = buttons;
        }

        public void timingEvent(float fraction) {
            if (this.buttons == null) {
                return;
            }
            FusionChartTypeChooserPanel.this.smartLayout.setCurrentLocation(fraction);
        }
    }
}

