/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.dataset;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.PropertyEditorTrimView;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.TextValuePair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.dataset.util.ChartConstant;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.SummaryType;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class AbstractChartKindOf {
    private static Logger logger = Logger.getLogger(AbstractChartKindOf.class);
    protected static final int COL_DISP = 0;
    protected static final int COL_FNAME = 1;
    protected static final int COL_SERIES = 2;
    protected static final int COL_SUM = 3;
    protected static final int COL_AXIS = 4;
    protected static final int COL_WIDTH = 75;
    protected KDTable table;
    protected KDPanel dataPanel;
    protected ExtDataSet dataset;
    protected KDComboBox boxSeries;
    protected KDComboBox boxCategory;
    protected KDComboBox boxDataset;
    protected KDLabelContainer conSeries;
    protected KDLabelContainer conCategory;
    protected KDLabelContainer conDataset;
    protected KDWorkButton btnInsert;
    protected KDWorkButton btnDelete;
    protected KDExt ext;
    protected DatasetImporter importerPanel;
    protected boolean isEmpty;

    public void addToDataPanel(List datasets) {
        this.importerPanel = null;
        this.addConDataset(datasets);
        this.addConSeries();
        this.buildTable();
        this.reLayout();
    }

    public void addConDataset(List datasets) {
        if (this.conDataset == null) {
            this.boxDataset = new KDComboBox();
            this.conDataset = new KDLabelContainer(CtrlEXTMessages.getMLS("dataset", "\u6570\u636e\u96c6"), (JComponent)this.boxDataset);
            this.conDataset.setBoundLabelLength(150);
            this.conDataset.setBoundLabelUnderline(true);
            this.boxDataset.addItemListener((ItemListener)new BoxDatasetItemListener());
            this.conDataset.setBounds(0, 0, 310, 19);
            this.conDataset.putClientProperty((Object)"INDEX-X", (Object)0);
            this.conDataset.putClientProperty((Object)"INDEX-Y", (Object)0);
        }
        this.fillBoxDataset(datasets);
        Object selectedItem = this.boxDataset.getSelectedItem();
        if (!(selectedItem instanceof ExtDataSet)) {
            selectedItem = null;
        }
        this.setDataset((ExtDataSet)selectedItem);
        this.dataPanel.add((Component)this.conDataset);
    }

    protected void fillBoxDataset(List datasets) {
        this.isEmpty = true;
        if (this.boxDataset.getModel().getSize() > 0) {
            this.boxDataset.removeAllItems();
        }
        for (int i = 0; i < datasets.size(); ++i) {
            this.isEmpty = false;
            this.boxDataset.addItem(datasets.get(i));
        }
        if (this.importerPanel != null) {
            this.boxDataset.addItem((Object)CtrlEXTMessages.getMLS("importMoreDatasets", "\u5f15\u5165\u66f4\u591a\u6570\u636e\u96c6..."));
        }
    }

    protected void addConSeries() {
        if (this.conSeries == null) {
            this.boxSeries = this.getBoxSeriesUse();
            this.boxSeries.addItemListener((ItemListener)new BoxItemChangeListener());
            this.conSeries = new KDLabelContainer(CtrlEXTMessages.getMLS("LegendItemSeriesUsage", "\u56fe\u4f8b\u9879(\u7cfb\u5217)\u4f7f\u7528"), (JComponent)this.boxSeries);
            this.conSeries.setBoundLabelLength(150);
            this.conSeries.setBoundLabelUnderline(true);
            int y = this.conDataset.getY() + this.conDataset.getHeight() + 8;
            this.conSeries.setBounds(this.conDataset.getX(), y, this.conDataset.getWidth(), this.conDataset.getHeight());
            this.conSeries.putClientProperty((Object)"INDEX-X", (Object)1);
            this.conSeries.putClientProperty((Object)"INDEX-Y", (Object)0);
        }
        this.dataPanel.add((Component)this.conSeries);
    }

    protected void addConCategory() {
        if (this.conCategory == null) {
            this.boxCategory = this.getBoxFilledFieldName();
            this.conCategory = new KDLabelContainer(CtrlEXTMessages.getMLS("useCategoryName", "\u5206\u7c7b(\u7ec4\u522b)\u540d\u4f7f\u7528"), (JComponent)this.boxCategory);
            this.conCategory.setBoundLabelLength(150);
            this.conCategory.setBoundLabelUnderline(true);
            if (this.conSeries != null) {
                this.conCategory.setBounds(this.conSeries.getX(), this.conSeries.getY(), this.conDataset.getWidth(), this.conDataset.getHeight());
                int x = this.conSeries.getX() + this.conSeries.getWidth() + 10;
                int y = this.conSeries.getY();
                this.conSeries.setBounds(x, y, this.conDataset.getWidth(), this.conDataset.getHeight());
            } else {
                int x = this.conDataset.getX();
                int y = this.conDataset.getY() + this.conDataset.getHeight() + 8;
                this.conCategory.setBounds(x, y, this.conDataset.getWidth(), this.conDataset.getHeight());
            }
            this.conCategory.putClientProperty((Object)"INDEX-X", (Object)1);
            this.conCategory.putClientProperty((Object)"INDEX-Y", (Object)0);
        }
        this.dataPanel.add((Component)this.conCategory);
    }

    protected void buildTable() {
        if (this.table == null) {
            this.table = new KDTable();
            this.table.addKDTEditListener((KDTEditListener)new TableEditListener());
            int y = 30;
            if (this.conSeries != null) {
                y = this.conSeries.getY() + this.conSeries.getHeight() + 8;
            } else if (this.conCategory != null) {
                y = this.conCategory.getY() + this.conCategory.getHeight() + 8;
            }
            this.table.addColumns(5);
            this.table.getColumn(0).getStyleAttributes().setHided(true);
            this.table.getColumn(3).setWidth(75);
            this.table.getColumn(4).setWidth(75);
            this.table.getColumn(4).getStyleAttributes().setHided(true);
            IRow headRow = this.table.addHeadRow();
            headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("displayMode", "\u663e\u793a\u65b9\u5f0f"));
            headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("fieldName", "\u5b57\u6bb5\u540d"));
            headRow.getCell(2).setValue((Object)CtrlEXTMessages.getMLS("seriesName", "\u7cfb\u5217\u540d"));
            headRow.getCell(3).setValue((Object)CtrlEXTMessages.getMLS("KEY_ClassifiedStatistics_LABEL2", "\u6c47\u603b\u65b9\u5f0f"));
            headRow.getCell(4).setValue((Object)CtrlEXTMessages.getMLS("yAxisPosition", "Y\u8f74\u4f4d\u7f6e"));
            int width = this.getTableWidth(this.table);
            this.table.setBounds(0, y, width, 130);
            this.btnInsert = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
            this.btnInsert.setToolTipText(CtrlEXTMessages.getMLS("addRow", "\u589e\u52a0\u884c"));
            int x = this.table.getX() + this.table.getWidth() + 5;
            this.btnInsert.setBounds(x, y, 22, 22);
            this.btnInsert.setActionCommand("insert");
            this.btnDelete = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
            this.btnDelete.setToolTipText(CtrlEXTMessages.getMLS("KEY_DELETE_ROW", "\u5220\u9664\u884c"));
            y = this.btnInsert.getY() + this.btnInsert.getHeight() + 4;
            this.btnDelete.setBounds(x, y, 22, 22);
            this.btnDelete.setActionCommand("delete");
            InsDelTableRowActionListener actionListener = new InsDelTableRowActionListener();
            this.btnInsert.addActionListener((ActionListener)actionListener);
            this.btnDelete.addActionListener((ActionListener)actionListener);
        }
        this.dataPanel.add((Component)this.btnInsert);
        this.dataPanel.add((Component)this.btnDelete);
        this.dataPanel.add((Component)this.table);
    }

    protected void reLayout() {
        int x = this.table.getX() + this.table.getWidth() + 5;
        this.btnInsert.setLocation(x, this.btnInsert.getY());
        this.btnDelete.setLocation(x, this.btnDelete.getY());
    }

    protected int getTableWidth(KDTable table) {
        int width = 45;
        if (table == null) {
            return width;
        }
        int colCount = table.getColumnCount();
        if (colCount <= 0) {
            return width;
        }
        for (int i = 0; i < colCount; ++i) {
            width += table.getColumn(i).getWidth();
        }
        return width;
    }

    public void refreshData() {
        if (this.boxSeries != null) {
            this.boxSeries.setSelectedIndex(-1);
            this.boxSeries.setSelectedIndex(0);
        }
        if (this.table != null) {
            this.table.removeRows();
            if (this.boxSeries != null && 0 == this.boxSeries.getSelectedIndex()) {
                this.addTableRow(this.table, false);
            } else {
                this.addTableRow(this.table, true);
            }
        }
    }

    protected KDComboBox getBoxSeriesUse() {
        KDComboBox boxSeriesUse = new KDComboBox();
        TextValuePair pair = new TextValuePair(CtrlEXTMessages.getMLS("fieldValue", "\u5b57\u6bb5\u540d"), "fieldValue");
        boxSeriesUse.addItem((Object)pair);
        pair = new TextValuePair(CtrlEXTMessages.getMLS("fieldName", "\u5b57\u6bb5\u540d"), "fieldName");
        boxSeriesUse.addItem((Object)pair);
        return boxSeriesUse;
    }

    protected KDComboBox getBoxFilledChartType(boolean hasCol, boolean hasLine, boolean hasArea) {
        KDComboBox box = new KDComboBox();
        TextValuePair pair = null;
        if (hasCol) {
            pair = new TextValuePair(ChartConstant.getColumnText(), "column");
            box.addItem((Object)pair);
        }
        if (hasLine) {
            pair = new TextValuePair(ChartConstant.getLineText(), "line");
            box.addItem((Object)pair);
        }
        if (hasArea) {
            pair = new TextValuePair(ChartConstant.getAreaText(), "area");
            box.addItem((Object)pair);
        }
        return box;
    }

    protected KDComboBox getBoxFilledAxis() {
        KDComboBox box = new KDComboBox();
        TextValuePair pair = new TextValuePair(ChartConstant.getNormalText(), "normal");
        box.addItem((Object)pair);
        pair = new TextValuePair(ChartConstant.getRightText(), "right");
        box.addItem((Object)pair);
        return box;
    }

    protected KDComboBox getBoxFilledFieldName() {
        KDComboBox box = new KDComboBox();
        if (this.dataset == null) {
            return box;
        }
        this.filledFieldName(box);
        return box;
    }

    protected void filledFieldName(KDComboBox box) {
        if (box == null || this.dataset == null) {
            return;
        }
        box.removeAllItems();
        box.addItems(this.getDatasetColumns());
    }

    protected Object[] getDatasetColumns() {
        if (this.dataset == null) {
            return null;
        }
        Object[] objArr = MiscUtil.sortColumnsByIndex(this.dataset.getColumns());
        if (objArr == null || objArr.length == 0) {
            return null;
        }
        ArrayList<TextValuePair> listValue = new ArrayList<TextValuePair>();
        int size = objArr.length;
        for (int i = 0; i < size; ++i) {
            ExtColumn col = (ExtColumn)objArr[i];
            TextValuePair pair = new TextValuePair(col.getAlias(), col.getName());
            listValue.add(pair);
        }
        return listValue.toArray();
    }

    protected IRow addTableRow(KDTable table, boolean isFieldName) {
        IRow row = table.addRow();
        KDComboBox boxFieldName = this.getBoxFilledFieldName();
        ICell cell = row.getCell(1);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxFieldName));
        cell.setValue(boxFieldName.getItemAt(0));
        cell = row.getCell(2);
        if (!isFieldName) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxFieldName));
            cell.setValue(boxFieldName.getItemAt(0));
        } else {
            cell.setValue(row.getCell(1).getValue());
        }
        KDComboBox boxSumType = new KDComboBox();
        boxSumType.addItems((Object[])SummaryType.values());
        cell = row.getCell(3);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)boxSumType));
        cell.setValue(boxSumType.getItemAt(0));
        KDTableUtil.setSelectedRow((KDTable)table, (int)row.getRowIndex());
        table.scrollToVisible(row.getRowIndex(), 0);
        return row;
    }

    protected void removeSelectedRows(KDTable table) {
        int[] selectedIndex = KDTableUtil.getSelectedRows((KDTable)table);
        if (selectedIndex == null || selectedIndex.length <= 0) {
            return;
        }
        for (int i = selectedIndex.length - 1; i >= 0; --i) {
            table.removeRow(selectedIndex[i]);
        }
    }

    public void setDataset(ExtDataSet dataset) {
        this.dataset = dataset;
    }

    public void setDataPanel(KDPanel panel) {
        this.dataPanel = panel;
    }

    public void syncUI2Model(DataFromDataset fromDataset) {
        this.syncUI2Model_Dataset(fromDataset);
        String selectedValue = "fieldName";
        Series series = new Series();
        if (this.boxSeries != null) {
            selectedValue = (String)((TextValuePair)this.boxSeries.getSelectedItem()).getValue();
            series.setSeriesNameType(selectedValue);
        }
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        boolean isDispHide = this.table.getColumn(0).getStyleAttributes().isHided();
        boolean isAxisHide = this.table.getColumn(4).getStyleAttributes().isHided();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Object cellValue;
            Category category = new Category();
            if (!isDispHide) {
                this.syncUI2Model_COL(i, 0, category);
            }
            if (!isAxisHide) {
                this.syncUI2Model_COL(i, 4, category);
            }
            if ((cellValue = this.table.getCell(i, 1).getValue()) != null) {
                category.setSeriesName((String)((TextValuePair)cellValue).getValue());
            }
            Object seriesValue = this.table.getCell(i, 2).getValue();
            if ("fieldName".equals(selectedValue)) {
                category.setSeriesValue(seriesValue == null ? null : seriesValue.toString());
            } else if (seriesValue != null) {
                category.setSeriesValue((String)((TextValuePair)seriesValue).getValue());
            }
            category.setSummaryType(((SummaryType)((Object)this.table.getCell(i, 3).getValue())).name());
            categories.add(category);
        }
        series.setCategories(categories);
        ArrayList<Series> seriesList = new ArrayList<Series>();
        seriesList.add(series);
        fromDataset.setSeries(seriesList);
    }

    protected void syncUI2Model_Dataset(DataFromDataset fromDataset) {
        Object selectedItem = this.boxDataset.getSelectedItem();
        if (!(selectedItem instanceof ExtDataSet)) {
            return;
        }
        String datasetName = ((ExtDataSet)selectedItem).getName();
        String define = ((ExtDataSet)selectedItem).getDefine();
        String datasetId = ExtDataSetManager.getDataSetIdByDefine(define);
        fromDataset.setDatasetId(datasetId);
        fromDataset.setDatasetName(datasetName);
    }

    protected void syncUI2Model_COL(int rowIndex, int colIndex, ICategory category) {
    }

    public void syncModel2UI(DataFromDataset fromDataset) {
        this.syncModel2UI_Dataset(fromDataset);
        int boxCount = 0;
        if (this.boxSeries != null && (boxCount = this.boxSeries.getModel().getSize()) <= 0) {
            return;
        }
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return;
        }
        Series series = seriesList.get(0);
        if (series == null) {
            return;
        }
        boolean isFieldName = this.syncModel2UI_BoxSeries(series);
        this.table.removeRows();
        List<ICategory> categories = series.getCategories();
        boolean isDispHide = this.table.getColumn(0).getStyleAttributes().isHided();
        boolean isAxisHide = this.table.getColumn(4).getStyleAttributes().isHided();
        for (int i = 0; i < categories.size(); ++i) {
            ICategory iCategory = categories.get(i);
            if (iCategory instanceof Category) {
                Category category = (Category)iCategory;
                this.addTableRow(this.table, isFieldName);
                if (!isDispHide) {
                    this.syncModel2UI_COL(i, 0, category);
                }
                ICell cell = this.table.getCell(i, 1);
                this.setCellValue(cell, category.getSeriesName());
                cell = this.table.getCell(i, 2);
                this.setCellValue(cell, category.getSeriesValue());
                cell = this.table.getCell(i, 3);
                this.setCellValue(cell, category.getSummaryType());
                if (isAxisHide) continue;
                this.syncModel2UI_COL(i, 4, category);
                continue;
            }
            this.addTableRow(this.table, isFieldName);
        }
    }

    protected boolean syncModel2UI_BoxSeries(Series series) {
        boolean isFieldName = false;
        if (this.boxSeries != null) {
            int boxCount = this.boxSeries.getModel().getSize();
            String seriesNameType = series.getSeriesNameType();
            for (int i = 0; i < boxCount; ++i) {
                String itemName = (String)((TextValuePair)this.boxSeries.getItemAt(i)).getValue();
                if (!itemName.equals(seriesNameType)) continue;
                if ("fieldName".equals(itemName)) {
                    isFieldName = true;
                }
                this.boxSeries.setSelectedIndex(i);
                break;
            }
        }
        return isFieldName;
    }

    protected void syncModel2UI_Dataset(DataFromDataset fromDataset) {
        int boxCount = this.boxDataset.getModel().getSize();
        if (boxCount <= 0 || this.boxDataset.getSelectedItem() == null) {
            return;
        }
        int sameNameIndex = -1;
        boolean isFind = false;
        String datasetId = fromDataset.getDatasetId();
        String datasetName = fromDataset.getDatasetName();
        for (int i = 0; i < boxCount; ++i) {
            Object selectedItem = this.boxDataset.getItemAt(i);
            if (!(selectedItem instanceof ExtDataSet)) continue;
            ExtDataSet dataset = (ExtDataSet)selectedItem;
            String define = dataset.getDefine();
            String itemId = ExtDataSetManager.getDataSetIdByDefine(define);
            if (itemId.equals(datasetId)) {
                isFind = true;
                this.boxDataset.setSelectedIndex(i);
                break;
            }
            String itemName = dataset.getName();
            if (!itemName.equals(datasetName)) continue;
            sameNameIndex = i;
        }
        if (!isFind && sameNameIndex != -1) {
            this.boxDataset.setSelectedIndex(sameNameIndex);
        }
    }

    protected void syncModel2UI_COL(int rowIndex, int colIndex, ICategory category) {
    }

    protected void setCellValue(ICell cell, String value) {
        ICellEditor cellEditor = cell.getEditor();
        if (cellEditor == null) {
            cell.setValue((Object)value);
            return;
        }
        KDComboBox box = (KDComboBox)cellEditor.getComponent();
        int boxCount = box.getModel().getSize();
        String itemName = "";
        for (int j = 0; j < boxCount; ++j) {
            Object itemObject = box.getItemAt(j);
            if (itemObject instanceof ExtColumn) {
                itemName = ((ExtColumn)itemObject).getName();
            } else if (itemObject instanceof SummaryType) {
                itemName = ((SummaryType)((Object)itemObject)).name();
            } else if (itemObject instanceof TextValuePair) {
                itemName = (String)((TextValuePair)itemObject).getValue();
            }
            if (!itemName.equals(value)) continue;
            box.setSelectedIndex(j);
            cell.setValue(box.getItemAt(j));
            break;
        }
    }

    protected void itemSeriesSelectedChanged(ItemEvent e) {
        String selectedValue = (String)((TextValuePair)e.getItem()).getValue();
        this.changeHeadNameBySeriesUse(selectedValue, ((TextValuePair)e.getItem()).getText());
    }

    protected void changeHeadNameBySeriesUse(String selectedValue, String selectedText) {
        boolean isFieldName = false;
        if ("fieldName".equals(selectedValue)) {
            this.table.getHeadRow(0).getCell(1).setValue((Object)CtrlEXTMessages.getMLS("seriesValue", "\u7cfb\u5217\u503c"));
            this.table.getHeadRow(0).getCell(2).setValue((Object)CtrlEXTMessages.getMLS("seriesName", "\u7cfb\u5217\u540d"));
            isFieldName = true;
        } else if ("fieldValue".equals(selectedValue)) {
            this.table.getHeadRow(0).getCell(1).setValue((Object)CtrlEXTMessages.getMLS("seriesName", "\u7cfb\u5217\u540d"));
            this.table.getHeadRow(0).getCell(2).setValue((Object)CtrlEXTMessages.getMLS("seriesValue", "\u7cfb\u5217\u503c"));
            isFieldName = false;
        } else {
            throw new UnsupportedOperationException("unknow selected Item: '" + selectedText + "'");
        }
        this.table.removeRows();
        this.addTableRow(this.table, isFieldName);
        this.btnInsert.setVisible(isFieldName);
        this.btnDelete.setVisible(isFieldName);
    }

    protected void actionPerformedInsDel(ActionEvent e) {
        if ("insert".equals(e.getActionCommand())) {
            String selectedValue = null;
            if (this.boxSeries != null) {
                selectedValue = (String)((TextValuePair)this.boxSeries.getSelectedItem()).getValue();
            }
            this.addTableRow(this.table, "fieldName".equals(selectedValue));
        } else if ("delete".equals(e.getActionCommand())) {
            this.removeSelectedRows(this.table);
        } else {
            throw new UnsupportedOperationException("unknow action command: '" + e.getActionCommand() + "'");
        }
    }

    protected void tableEditValueChanged(KDTEditEvent e) {
    }

    public KDComboBox getBoxDataset() {
        return this.boxDataset;
    }

    public void addToDataPanel(KDExt ext, List datasets) {
        this.ext = ext;
        this.importerPanel = new DatasetImporter(ext);
        this.importerPanel.prepare();
        this.addConDataset(datasets);
        this.addConSeries();
        this.buildTable();
        this.reLayout();
    }

    protected class TableEditListener
    extends KDTEditAdapter {
        protected TableEditListener() {
        }

        public void editStopped(KDTEditEvent e) {
            ICell cellSeries;
            Object value = e.getValue();
            if (value != null && value.equals(e.getOldValue())) {
                return;
            }
            if (e.getColIndex() == 1 && (cellSeries = AbstractChartKindOf.this.table.getRow(e.getRowIndex()).getCell(2)).getEditor() == null) {
                cellSeries.setValue((Object)(value == null ? null : value.toString()));
            }
            AbstractChartKindOf.this.tableEditValueChanged(e);
        }
    }

    protected class InsDelTableRowActionListener
    implements ActionListener {
        protected InsDelTableRowActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractChartKindOf.this.actionPerformedInsDel(e);
        }
    }

    protected class BoxItemChangeListener
    implements ItemListener {
        protected BoxItemChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            if (e.getItem() instanceof TextValuePair) {
                AbstractChartKindOf.this.itemSeriesSelectedChanged(e);
            }
        }
    }

    private class BoxDatasetItemListener
    implements ItemListener {
        private BoxDatasetItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            if (AbstractChartKindOf.this.isEmpty) {
                AbstractChartKindOf.this.boxDataset.setSelectedItem(null, true);
                AbstractChartKindOf.this.isEmpty = false;
                return;
            }
            Object selectedItem = AbstractChartKindOf.this.boxDataset.getSelectedItem();
            if (CtrlEXTMessages.getMLS("importMoreDatasets", "\u5f15\u5165\u66f4\u591a\u6570\u636e\u96c6...").equals(selectedItem) && !(selectedItem instanceof ExtDataSet)) {
                if (AbstractChartKindOf.this.importerPanel != null) {
                    AbstractChartKindOf.this.boxDataset.hidePopup();
                    AbstractChartKindOf.this.importerPanel.prepare();
                    AbstractChartKindOf.this.importerPanel.getAdd().doClick();
                    List all = AbstractChartKindOf.this.importerPanel.getAllExtDataSets();
                    if (all.size() == 0) {
                        AbstractChartKindOf.this.boxDataset.setSelectedItem(null, false);
                        return;
                    }
                    ExtDataSet currentDs = (ExtDataSet)AbstractChartKindOf.this.importerPanel.getSelectedExtDataSets().get(0);
                    AbstractChartKindOf.this.boxDataset.removeAllItems();
                    for (int i = 0; i < all.size(); ++i) {
                        if (all.get(i).equals(AbstractChartKindOf.this.boxDataset.getItemAt(i))) continue;
                        AbstractChartKindOf.this.boxDataset.addItem(all.get(i));
                    }
                    AbstractChartKindOf.this.boxDataset.addItem((Object)CtrlEXTMessages.getMLS("importMoreDatasets", "\u5f15\u5165\u66f4\u591a\u6570\u636e\u96c6..."));
                    AbstractChartKindOf.this.boxDataset.setSelectedItem((Object)currentDs, true);
                }
                return;
            }
            if (AbstractChartKindOf.this.importerPanel != null) {
                AbstractChartKindOf.this.importerPanel.prepare();
                AbstractChartKindOf.this.importerPanel.commitEdit();
                ((PropertyEditorTrimView)((TrimWidgetViewport)AbstractChartKindOf.this.ext.getPerspective("Report Designer").getTrimWidget("PropertyEditor_Widget_ID")).getView()).refreshDatasetTree();
            }
            if (!(selectedItem instanceof ExtDataSet)) {
                return;
            }
            AbstractChartKindOf.this.setDataset((ExtDataSet)selectedItem);
            AbstractChartKindOf.this.refreshData();
        }
    }
}

