/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.CommonStyleEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.FormatEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.PatternNode;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.apache.log4j.Logger;

public class NumberFormatTemplateEditor
extends CommonStyleEditor {
    private static final Logger logger = LogUtil.getPackageLogger(NumberFormatTemplateEditor.class);
    private NumberFormatVFPair _value;

    @Override
    protected void showEditor() {
        new FormatEditor(this.getCustomEditor(), this._value);
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    public static String getNumberFormatXML() {
        StringBuilder sb = new StringBuilder("<template>");
        sb.append("<percent value='false' />");
        sb.append("<forceDecimals type='Boolean' value='true' />");
        sb.append("<numberPrefix type='String' />");
        sb.append("<numberSuffix type='String' />");
        sb.append("<sNumberSuffix type='String' />");
        sb.append("<decimals type='Integer' value='0' />");
        sb.append("<decimalSeparator type='String' value='.' />");
        sb.append("<formatNumber type='Boolean' value='true' />");
        sb.append("<thousandSeparator type='String' value=',' />");
        sb.append("</template>");
        return sb.toString();
    }

    public static String getCommonFormatXML() {
        StringBuilder sb = new StringBuilder("<template>");
        sb.append("<percent value='false' />");
        sb.append("<forceDecimals type='Boolean' value='true' />");
        sb.append("<numberPrefix type='String' />");
        sb.append("<numberSuffix type='String' />");
        sb.append("<sNumberSuffix type='String' />");
        sb.append("<decimals type='Integer' value='2' />");
        sb.append("<decimalSeparator type='String' value='.' />");
        sb.append("<formatNumber type='Boolean' value='true' />");
        sb.append("<thousandSeparator type='String' value=',' />");
        sb.append("</template>");
        return sb.toString();
    }

    public static String getPercentCommonFormatXML() {
        StringBuilder sb = new StringBuilder("<template>");
        sb.append("<percent value='true' />");
        sb.append("<forceDecimals type='Boolean' value='true' />");
        sb.append("<numberPrefix type='String' />");
        sb.append("<numberSuffix type='String' value='%' />");
        sb.append("<sNumberSuffix type='String' />");
        sb.append("<decimals type='Integer' value='2' />");
        sb.append("<decimalSeparator type='String' value='.' />");
        sb.append("<formatNumber type='Boolean' value='true' />");
        sb.append("<thousandSeparator type='String' value=',' />");
        sb.append("</template>");
        return sb.toString();
    }

    @Override
    public void setValue(Object value) {
        this._value = (NumberFormatVFPair)value;
        if (NumberFormatTemplateEditor.getCommonFormatXML().equals(this._value.getXmlValue()) || NumberFormatTemplateEditor.getNumberFormatXML().equals(this._value.getXmlValue())) {
            this.setText(CtrlEXTMessages.getMLS("systemDefaultValue", "\u7cfb\u7edf\u9ed8\u8ba4(\u6570\u503c)"));
        } else if (NumberFormatTemplateEditor.getPercentCommonFormatXML().equals(this._value.getXmlValue())) {
            this.setText(CtrlEXTMessages.getMLS("systemDefaultRate", "\u7cfb\u7edf\u9ed8\u8ba4(\u6bd4\u7387)"));
        } else {
            this.setText(CtrlEXTMessages.getMLS("userDefined", "\u7528\u6237\u81ea\u5b9a\u4e49"));
        }
    }

    public static PatternNode parsePattern(String formatXml, String numberPrefix, String numberSuffix) {
        IXmlElement root = null;
        PatternNode node = new PatternNode();
        try {
            root = XmlUtil.loadXmlBytes((byte[])formatXml.getBytes("UTF-8"));
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        if (root == null) {
            return node;
        }
        List contents = root.getChildren();
        int decimals = 2;
        boolean forceDecimals = true;
        boolean formatNumber = true;
        boolean percentNumber = false;
        String prefix = "";
        String suffix = "";
        String rSuffix = "";
        Character decimalSeparator = Character.valueOf('.');
        Character thousandSeparator = Character.valueOf(',');
        for (int i = 0; i < contents.size(); ++i) {
            String v;
            Object next = contents.get(i);
            if (!(next instanceof IXmlElement)) continue;
            IXmlElement ele = (IXmlElement)next;
            if (ele.getName().equals("forceDecimals")) {
                forceDecimals = Boolean.parseBoolean(ele.getAttribute("value"));
                continue;
            }
            if (ele.getName().equals("numberPrefix")) {
                prefix = ele.getAttribute("value");
                if (!StringUtil.isEmptyString((String)prefix)) continue;
                if (!StringUtil.isEmptyString((String)numberPrefix)) {
                    prefix = numberPrefix;
                    continue;
                }
                prefix = "";
                continue;
            }
            if (ele.getName().equals("numberSuffix")) {
                suffix = ele.getAttribute("value");
                if (!StringUtil.isEmptyString((String)suffix)) continue;
                if (!StringUtil.isEmptyString((String)numberSuffix)) {
                    suffix = numberSuffix;
                    continue;
                }
                suffix = "";
                continue;
            }
            if (ele.getName().equals("sNumberSuffix")) {
                rSuffix = ele.getAttribute("value");
                if (!StringUtil.isEmptyString((String)rSuffix)) continue;
                if (!StringUtil.isEmptyString((String)numberSuffix)) {
                    rSuffix = numberSuffix;
                    continue;
                }
                rSuffix = "";
                continue;
            }
            if (ele.getName().equals("decimals")) {
                decimals = Integer.parseInt(ele.getAttribute("value"));
                continue;
            }
            if (ele.getName().equals("decimalSeparator")) {
                v = ele.getAttribute("value");
                if (StringUtil.isEmptyString((String)v)) continue;
                decimalSeparator = Character.valueOf(v.charAt(0));
                continue;
            }
            if (ele.getName().equals("formatNumber")) {
                formatNumber = Boolean.parseBoolean(ele.getAttribute("value"));
                continue;
            }
            if (ele.getName().equals("thousandSeparator")) {
                v = ele.getAttribute("value");
                if (!StringUtil.isEmptyString((String)v)) {
                    thousandSeparator = Character.valueOf(v.charAt(0));
                    continue;
                }
                thousandSeparator = null;
                continue;
            }
            if (!ele.getName().equals("percent") || !"true".equals(v = ele.getAttribute("value"))) continue;
            percentNumber = true;
        }
        node.setDecimals(decimals);
        node.setDecimalSeparator(decimalSeparator.charValue());
        node.setPercentNumber(percentNumber);
        if (percentNumber) {
            suffix = suffix.replace("%", "");
        }
        node.setPrefix(prefix);
        node.setSuffix(suffix);
        node.setrSuffix(rSuffix);
        node.setForceDecimals(forceDecimals);
        node.setFormatNumber(formatNumber);
        node.setThousandSeparator(thousandSeparator);
        return node;
    }

    public static NumberFormatVFPair parseNumberFormatVFPair(AbstractFusionBean bean, PatternNode patternNode) {
        NumberFormatVFPair nfvp = new NumberFormatVFPair(bean, null);
        StringBuilder sb = new StringBuilder("<template>");
        sb.append(patternNode.isPercentNumber() ? "<percent value='true' />" : "<percent value='false' />");
        sb.append(patternNode.isForceDecimals() ? "<forceDecimals type='Boolean' value='true' />" : "<forceDecimals type='Boolean' value='false' />");
        sb.append(StringUtil.isEmptyString((String)patternNode.getPrefix()) ? "<numberPrefix type='String' />" : "<numberPrefix type='String' value='" + patternNode.getPrefix() + "' />");
        sb.append(StringUtil.isEmptyString((String)patternNode.getSuffix()) ? "<numberSuffix type='String' />" : "<numberSuffix type='String' value='" + patternNode.getSuffix() + "' />");
        sb.append(StringUtil.isEmptyString((String)patternNode.getrSuffix()) ? "<sNumberSuffix type='String' />" : "<sNumberSuffix type='String' value='" + patternNode.getrSuffix() + "' />");
        sb.append("<decimals type='Integer' value='");
        sb.append(patternNode.getDecimals());
        sb.append("' />");
        sb.append("<decimalSeparator type='String' value='");
        sb.append(patternNode.getDecimalSeparator());
        sb.append("' />");
        sb.append(patternNode.isFormatNumber() ? "<formatNumber type='Boolean' value='true' />" : "<formatNumber type='Boolean' value='false' />");
        sb.append("<thousandSeparator type='String' value='");
        sb.append(patternNode.getThousandSeparator());
        sb.append("' />");
        sb.append("</template>");
        nfvp.setXmlValue(sb.toString());
        return nfvp;
    }

    public static String applayPattern(String valueString, String formatXml) {
        return NumberFormatTemplateEditor.applayPattern(valueString, formatXml, null, null);
    }

    public static String applayPattern(String valueString, String formatXml, String numberPrefix, String numberSuffix) {
        Number value = new BigDecimal(valueString);
        PatternNode node = NumberFormatTemplateEditor.parsePattern(formatXml, numberPrefix, numberSuffix);
        DecimalFormat format = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(node.getDecimalSeparator());
        if (node.isPercentNumber()) {
            value = ((Number)value).doubleValue() * 100.0;
        } else {
            symbols.setGroupingSeparator(node.getThousandSeparator());
        }
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(node.isFormatNumber());
        format.setMaximumFractionDigits(node.getDecimals());
        if (node.isForceDecimals()) {
            format.setMinimumFractionDigits(node.getDecimals());
        }
        return node.getPrefix() + format.format(value) + node.getSuffix();
    }
}

