/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.layout;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.typechooser.ChartTypeButton;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.layout.DefaultLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class SmartLayout
extends DefaultLayoutManager {
    public static boolean shouldRelayout = true;
    int cellX = 80;
    int cellY = 60;

    public void setCurrentLocation(float location) {
    }

    private void switchBounds(JComponent c1, JComponent c2) {
        Rectangle temp = c1.getBounds();
        c1.setBounds(c2.getBounds());
        c2.setBounds(temp);
    }

    @Override
    public void layoutContainer(Container parent) {
        JComponent comp = (JComponent)parent;
        Rectangle rect = comp.getBounds();
        Component[] children = comp.getComponents();
        int childrenCount = children.length;
        if (childrenCount == 0) {
            return;
        }
        int width = rect.width / 4;
        int height = rect.height / 4;
        Rectangle center = new Rectangle(rect.width / 2 - width / 2, rect.height / 2 - height / 2, width, height);
        if (childrenCount == 1) {
            children[0].setBounds(center);
            return;
        }
        boolean hasSelection = false;
        Component button1 = null;
        ChartTypeButton button2 = null;
        if (shouldRelayout) {
            int size = children.length;
            for (int i = 0; i < size; ++i) {
                ChartTypeButton button = (ChartTypeButton)children[i];
                if (button.isSelected()) {
                    --childrenCount;
                    hasSelection = true;
                    button1 = button;
                }
                if (!button.getBounds().equals(center)) continue;
                button2 = button;
            }
            if (button1 != null && button2 != null) {
                this.switchBounds((JComponent)button1, button2);
                return;
            }
            if (button1 != null) {
                button1.setBounds(center);
            }
        }
        double angle = -1.5707963267948966;
        if (childrenCount % 2 == 0) {
            angle = 0.0;
        }
        int size = hasSelection ? childrenCount + 1 : childrenCount;
        double plus = Math.PI * 2 / (double)childrenCount;
        for (int i = 0; i < size; ++i) {
            this.circleStartPointCalc(width + 45, height + 30, angle, rect);
            ChartTypeButton button = (ChartTypeButton)children[i];
            if (shouldRelayout) {
                if (button.isSelected()) continue;
                children[i].setBounds(rect);
                angle += plus;
                continue;
            }
            children[i].setBounds(rect);
            angle += plus;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(parent.getWidth(), parent.getHeight() - 80);
    }

    private void circleStartPointCalc(int radiusX, int radiusY, double angle, Rectangle rect) {
        rect.x = (int)((double)radiusX * Math.cos(angle));
        rect.y = (int)((double)radiusY * Math.sin(angle));
        rect.x += radiusX;
        rect.y += radiusY;
        rect.x = rect.x - this.cellX / 2 + 80;
        rect.y = rect.y - this.cellY / 2 + 50;
        rect.width = this.cellX;
        rect.height = this.cellY;
    }
}

