/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.angulargauge;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartTitlePositionComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Color;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.ColorRange;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dial;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dials;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Point;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Trendpoints;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class AngularGaugeFusionBean
extends AbstractFusionBean {
    private static final Logger logger = LogUtil.getPackageLogger(AngularGaugeFusionBean.class);
    private IntegerVFPair gaugeStartAngle = new IntegerVFPair(180, null);
    private IntegerVFPair gaugeEndAngle = new IntegerVFPair(0, null);
    private IntegerVFPair gaugeInnerRadius = new IntegerVFPair(80, null);
    private IntegerVFPair gaugeOuterRadius = new IntegerVFPair(100, null);
    private IntegerVFPair pivotRadius = new IntegerVFPair(5, null);
    private IntegerVFPair majorTMNumber = new IntegerVFPair(10, null);
    private IntegerVFPair minorTMNumber = new IntegerVFPair(1, null);
    private IntegerVFPair borderAlpha = new IntegerVFPair(100, null);
    private IntegerVFPair trendValueDistance = new IntegerVFPair(20, null);
    private BooleanVFPair placeTicksInside = new BooleanVFPair(false, null);
    private BooleanVFPair adjustTM = new BooleanVFPair(false, null);
    private BooleanVFPair useMarker = new BooleanVFPair(false, null);
    private BooleanVFPair valueInside = new BooleanVFPair(true, null);
    private BooleanVFPair dashed = new BooleanVFPair(false, null);
    private BooleanVFPair showSeparatorTick = new BooleanVFPair(true, null);
    private Double max = null;
    private Double min = null;
    private BooleanVFPair showGroupLabel = new BooleanVFPair(false, null);
    private BooleanVFPair showGroupValue = new BooleanVFPair(true, null);
    private BooleanVFPair showMajorTick = new BooleanVFPair(true, null);
    private BooleanVFPair showMinorTick = new BooleanVFPair(true, null);
    private DecimalFormat format = new DecimalFormat();
    private static final int MAJOR_INNERRADIUS = 15;
    private static final int MINOR_INNERRADIUS = 10;
    private Random random = new SecureRandom();

    public AngularGaugeFusionBean() {
        this.chart_chartLeftMargin = "16";
        this.chart_chartRightMargin = "16";
        this.chart_chartTopMargin = "16";
        this.chart_chartBottomMargin = "0";
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    @Override
    protected HashMap applyNumberFormats() {
        HashMap ret = super.applyNumberFormats();
        if (ret.containsKey("forceDecimals")) {
            this.chart.forceTickValueDecimals = String.valueOf(ret.get("forceDecimals"));
        }
        this.chart.tickValueDecimals = ret.containsKey("decimals") ? String.valueOf(ret.get("decimals")) : "2";
        return ret;
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        return null;
    }

    protected String[] buildChartCaptionsImpl(FusionChartDataNode dataNode) {
        String[] chartCaptions = null;
        Object obj = dataNode.getData(FusionChartDataNode.CHART_CAPTION);
        if (obj != null) {
            int len = Array.getLength(obj);
            chartCaptions = new String[len];
            for (int i = 0; i < len; ++i) {
                Variant[][] val = (Variant[][])Array.get(obj, i);
                if (val == null) continue;
                chartCaptions[i] = val[0][0].toString();
            }
        }
        if (chartCaptions != null) {
            this.chart.gaugeStartAngle = chartCaptions[0];
            this.chart.gaugeEndAngle = chartCaptions[1];
            this.chart.gaugeInnerRadius = chartCaptions[2] + "%";
            this.chart.gaugeOuterRadius = chartCaptions[3] + "%";
            this.chart.pivotRadius = chartCaptions[4];
            if (chartCaptions.length > 13) {
                this.chart.caption = chartCaptions[13];
            }
            if (chartCaptions.length > 14) {
                this.chart.subCaption = chartCaptions[14];
            }
            if (chartCaptions.length > 15) {
                this.chart.setAttribute("chartBottomMargin", chartCaptions[16]);
                this.chart.setAttribute("chartTopMargin", chartCaptions[15]);
                this.chart.setAttribute("chartLeftMargin", chartCaptions[17]);
                this.chart.setAttribute("chartRightMargin", chartCaptions[18]);
            }
            if (chartCaptions.length > 19) {
                this.chart.setAttribute("numberPrefix", chartCaptions[19]);
                this.chart.setAttribute("numberSuffix", chartCaptions[20]);
            }
            if (chartCaptions.length > 21) {
                this.showSeparatorTick = new BooleanVFPair(chartCaptions[21].equals("1"), null);
            }
            if (chartCaptions.length > 22) {
                this.showGroupLabel = new BooleanVFPair(chartCaptions[22].equals("1"), null);
                this.showGroupValue = new BooleanVFPair(chartCaptions[23].equals("1"), null);
                this.showMajorTick = new BooleanVFPair(chartCaptions[24].equals("1"), null);
                this.showMinorTick = new BooleanVFPair(chartCaptions[25].equals("1"), null);
            }
            if (chartCaptions.length >= 27) {
                this.borderAlpha = new IntegerVFPair(Integer.parseInt(chartCaptions[26]), null);
                this.chart.setAttribute("borderAlpha", chartCaptions[26]);
            }
            this.chart.bgColor = chartCaptions.length >= 28 ? new String[]{chartCaptions[27]} : new String[]{"#ffffff"};
            this.chart.captionFontSize = chartCaptions.length >= 29 ? chartCaptions[28] : "24";
            this.chart.subCaptionFontSize = chartCaptions.length >= 30 ? chartCaptions[29] : "16";
            this.chart.baseFont = chartCaptions.length >= 31 ? chartCaptions[30] : CtrlEXTMessages.getMLS("simSun", "\u5b8b\u4f53");
            this.chart.baseFontSize = chartCaptions.length >= 32 ? chartCaptions[31] : "12";
            this.chart.captionFontName = chartCaptions.length >= 34 ? chartCaptions[33] : CtrlEXTMessages.getMLS("simSun", "\u5b8b\u4f53");
            this.chart.captionColor = chartCaptions.length >= 35 ? chartCaptions[34] : "0;0;0;255";
            this.chart.subCaptionFontName = chartCaptions.length >= 36 ? chartCaptions[35] : CtrlEXTMessages.getMLS("simSun", "\u5b8b\u4f53");
            this.chart.subCaptionColor = chartCaptions.length >= 37 ? chartCaptions[36] : "0;0;0;255";
            this.chart.captionAlign = chartCaptions.length >= 38 ? chartCaptions[37] : ChartTitlePositionComboBoxEditor.getCenter();
            if (chartCaptions.length >= 39) {
                this.chart.dataLabelFormat = chartCaptions[38];
            }
        } else {
            this.chart.gaugeStartAngle = "180";
            this.chart.gaugeEndAngle = "0";
        }
        this.chart.adjustTM = "0";
        this.chart.showTickMarks = "0";
        return chartCaptions;
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        dataNode.setDirty(true);
        this.buildChartCaptionsImpl(dataNode);
        super.fillChartNodes(dataNode);
        boolean isSerialByCol = false;
        double[][] datas = (double[][])dataNode.getData();
        String[] keys = dataNode.getGroupKeys();
        int len = datas[0].length;
        this.init(len, isSerialByCol, datas, keys);
        this.buildDials(dataNode, isSerialByCol);
        this.buildTicks(dataNode);
    }

    private void init(int len, boolean isSerialByCol, double[][] datas, String[] keys) {
        block2: {
            this.nodes = new NodeFunc[3];
            this.nodes[0] = new ColorRange();
            this.nodes[1] = new Dials();
            this.nodes[2] = new Trendpoints();
            ((Trendpoints)this.nodes[2]).points = new Point[len];
            Point[] points = ((Trendpoints)this.nodes[2]).points;
            ((ColorRange)this.nodes[0]).colors = new Color[len - 1];
            Color[] colors = ((ColorRange)this.nodes[0]).colors;
            this.buildColorRanges(len, isSerialByCol, colors, points, datas, keys);
            super.applyNumberFormats();
            try {
                this.format.setMinimumFractionDigits(Integer.parseInt(this.chart.decimals));
                this.format.setMaximumFractionDigits(Integer.parseInt(this.chart.decimals));
                this.format.setGroupingUsed(true);
                DecimalFormatSymbols newSymbols = new DecimalFormatSymbols();
                newSymbols.setGroupingSeparator(this.chart.thousandSeparator.charAt(0));
                newSymbols.setDecimalSeparator(this.chart.decimalSeparator.charAt(0));
                this.format.setDecimalFormatSymbols(newSymbols);
            }
            catch (Exception ex) {
                logger.error((Object)"err", (Throwable)ex);
                if (!MiscUtil.shouldLog()) break block2;
                MiscUtil.log(ex);
            }
        }
    }

    private void buildDials(FusionChartDataNode dataNode, boolean isSerialByCol) throws SyntaxErrorException {
        Variant[][] needleValues = (Variant[][])Array.get(dataNode.getData(FusionChartDataNode.DASHBOARD_CHART_NEEDLE_FORMULA), 0);
        Variant[][] needleNames = (Variant[][])Array.get(dataNode.getData(FusionChartDataNode.DASHBOARD_CHART_NEEDLE_GROUP_FORMULA), 0);
        int len = isSerialByCol ? needleValues[0].length : needleValues.length;
        Dial[] dials = new Dial[len];
        ((Dials)this.nodes[1]).dials = dials;
        for (int i = 0; i < len; ++i) {
            double value;
            dials[i] = new Dial();
            double d = value = isSerialByCol ? needleValues[0][i].doubleValue() : needleValues[i][0].doubleValue();
            if (value > this.max) {
                value = this.max;
            } else if (value < this.min) {
                value = this.min;
            }
            if (ArrayUtil.isEqual((Double)value, (Double)0.0)) {
                value = 1.0E-127;
            }
            if (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1) {
                dials[i].value = String.valueOf(value);
                dials[i].toolText = String.valueOf(isSerialByCol ? needleNames[0][i] : needleNames[i][0]) + ':' + NumberFormatTemplateEditor.applayPattern(String.valueOf(value), this.getChartNumberFormat().getXmlValue());
                continue;
            }
            dials[i].value = String.valueOf(value);
            dials[i].toolText = String.valueOf(isSerialByCol ? needleNames[0][i] : needleNames[i][0]) + ':' + this.chart.numberPrefix + this.format.format(new BigDecimal(dials[i].value)) + this.chart.numberSuffix;
        }
    }

    private void buildColorRanges(int len, boolean isSerialByCol, Color[] colors, Point[] points, double[][] datas, String[] keys) {
        this.chart.lowerLimit = String.valueOf(datas[0][0]);
        for (int i = 1; i < len; ++i) {
            colors[i - 1] = new Color();
            double currentMin = isSerialByCol ? datas[i - 1][0] : datas[0][i - 1];
            colors[i - 1].minValue = String.valueOf(currentMin);
            double currentMax = isSerialByCol ? datas[i][0] : datas[0][i];
            colors[i - 1].maxValue = String.valueOf(currentMax);
            if (this.min == null) {
                this.min = currentMin;
            }
            this.max = currentMax;
        }
        this.chart.upperLimit = String.valueOf(isSerialByCol ? datas[len - 1][0] : datas[0][len - 1]);
    }

    private void buildTicks(FusionChartDataNode dataNode) {
        int endAngle;
        if (Double.parseDouble(this.chart.upperLimit) - Double.parseDouble(this.chart.lowerLimit) == 0.0) {
            this.chart.adjustTM = "1";
            this.chart.showTickMarks = "1";
            return;
        }
        Trendpoints tp = (Trendpoints)this.nodes[2];
        int startAngle = Integer.parseInt(this.chart.gaugeStartAngle);
        int majorTickCount = (startAngle - (endAngle = Integer.parseInt(this.chart.gaugeEndAngle))) / 45;
        if (majorTickCount == 0) {
            majorTickCount = 1;
        }
        int minorTickCount = 3;
        double majorStep = this.parseStep(Double.parseDouble(this.chart.upperLimit), Double.parseDouble(this.chart.lowerLimit), majorTickCount);
        double minorStep = majorStep / (double)(minorTickCount + 1);
        ArrayList bucket = new ArrayList();
        while (majorStep * (double)majorTickCount < Double.parseDouble(this.chart.upperLimit)) {
            ++majorTickCount;
        }
        int count = 0;
        while (majorStep * (double)count > Double.parseDouble(this.chart.lowerLimit)) {
            --count;
            ++majorTickCount;
        }
        count = Math.abs(count);
        Point[] majorTickPoints = new Point[majorTickCount];
        Point[] minorTickPoints = new Point[(majorTickCount + 1) * minorTickCount];
        int embedWidth = 0;
        EmbedhLayer layer = dataNode.getSheet().getEmbedments(false);
        for (int l = 0; l < layer.size(); ++l) {
            EmbedObject eObject = layer.getEmbed(l);
            if (!eObject.getName().equals(this.getChartName())) continue;
            embedWidth = eObject.getWidth();
            break;
        }
        int leftMargin = Integer.parseInt(this.chart.chartLeftMargin);
        int rightMargin = Integer.parseInt(this.chart.chartRightMargin);
        int radius = (embedWidth - leftMargin - rightMargin) / 2;
        for (int i = majorTickCount; i >= 0; --i) {
            double currentValue = majorStep * (double)((majorTickCount - count++) * 100) / 100.0;
            if (i != majorTickCount) {
                majorTickPoints[i] = new Point();
                majorTickPoints[i].startValue = majorTickPoints[i].displayValue = String.valueOf(currentValue);
                majorTickPoints[i].displayValue = !this.showSeparatorTick.getPrimitiveValue() ? " " : (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? NumberFormatTemplateEditor.applayPattern(String.valueOf(majorTickPoints[i].startValue), this.getChartNumberFormat().getXmlValue()) : this.chart.numberPrefix + this.format.format(new BigDecimal(majorTickPoints[i].startValue)) + this.chart.numberSuffix);
                majorTickPoints[i].thickness = "1";
                majorTickPoints[i].alpha = this.showMajorTick.getPrimitiveValue() ? null : "0";
                majorTickPoints[i].isMajorTick = "1";
                majorTickPoints[i].innerRadius = String.valueOf(radius - 15);
            }
            for (int j = 0; j < minorTickCount; ++j) {
                int index = i * minorTickCount + j;
                minorTickPoints[index] = new Point();
                minorTickPoints[index].startValue = String.valueOf(currentValue + minorStep * (double)(j + 1));
                minorTickPoints[index].displayValue = " ";
                minorTickPoints[index].thickness = "1";
                minorTickPoints[index].alpha = this.showMinorTick.getPrimitiveValue() ? null : "0";
                minorTickPoints[index].innerRadius = String.valueOf(radius - 10);
            }
        }
        this.addPoint(bucket, majorTickPoints);
        this.addPoint(bucket, minorTickPoints);
        Point[] groupTickPoints = new Point[tp.points.length];
        for (int i = 0; i < tp.points.length; ++i) {
            groupTickPoints[i] = new Point();
            groupTickPoints[i].startValue = groupTickPoints[i].displayValue = tp.points[i].startValue;
            groupTickPoints[i].displayValue = !this.showGroupValue.getPrimitiveValue() && !this.chart.upperLimit.equals(tp.points[i].startValue) && !this.chart.lowerLimit.equals(tp.points[i].startValue) ? " " : (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? NumberFormatTemplateEditor.applayPattern(String.valueOf(groupTickPoints[i].startValue), this.getChartNumberFormat().getXmlValue()) : this.chart.numberPrefix + this.format.format(new BigDecimal(groupTickPoints[i].startValue)) + this.chart.numberSuffix);
            groupTickPoints[i].alpha = "0";
        }
        this.addPoint(bucket, tp.points);
        this.addPoint(bucket, groupTickPoints);
        Point[] all = new Point[bucket.size()];
        bucket.toArray(all);
        tp.points = all;
    }

    private double parseStep(double upper, double lower, int majorTickCount) {
        double distance;
        double step = 10.0;
        int variCount = 0;
        int variSeed = 100;
        for (distance = Math.abs(upper - lower); !ArrayUtil.isEqual((Double)distance, (Double)0.0) && distance < (double)variSeed; distance *= (double)variSeed) {
            ++variCount;
        }
        if (variCount == 0) {
            while (distance > (double)variSeed) {
                --variCount;
                distance /= (double)variSeed;
            }
            if (distance < (double)variSeed) {
                distance *= (double)variSeed;
                ++variCount;
            }
        }
        while (step * (double)Math.abs(majorTickCount) < distance) {
            step += (double)(variSeed / 10);
        }
        return step /= Math.pow(variSeed, variCount);
    }

    private void addPoint(ArrayList bucket, Point[] points) {
        if (points != null) {
            for (int i = 0; i < points.length; ++i) {
                bucket.add(points[i]);
            }
        }
    }

    @Override
    public String[] buildChartCaptions1(FusionChartDataNode dataNode) {
        String[] chartCaptions = this.getChartCaptions(dataNode);
        if (chartCaptions != null && chartCaptions.length != 0) {
            this.buildChartHide(chartCaptions);
        }
        return chartCaptions;
    }

    private void buildChartHide(String[] chartCaptions) {
        if (chartCaptions.length >= 33) {
            if (chartCaptions[32] != null && chartCaptions[32].equals("1")) {
                this.setChart_hideChart(new BooleanVFPair(true, null));
            } else if (chartCaptions[32] == null || chartCaptions[32].equals("0")) {
                this.setChart_hideChart(new BooleanVFPair(false, null));
            } else {
                this.setChart_hideChart(new BooleanVFPair(null, chartCaptions[32]));
            }
        }
    }

    public IntegerVFPair getGaugeStartAngle() {
        return this.gaugeStartAngle;
    }

    public void setGaugeStartAngle(IntegerVFPair gaugeStartAngle) {
        this.gaugeStartAngle = gaugeStartAngle;
    }

    public IntegerVFPair getGaugeEndAngle() {
        return this.gaugeEndAngle;
    }

    public void setGaugeEndAngle(IntegerVFPair gaugeEndAngle) {
        this.gaugeEndAngle = gaugeEndAngle;
    }

    public IntegerVFPair getGaugeInnerRadius() {
        return this.gaugeInnerRadius;
    }

    public void setGaugeInnerRadius(IntegerVFPair gaugeInnerRadius) {
        this.gaugeInnerRadius = gaugeInnerRadius;
    }

    public IntegerVFPair getGaugeOuterRadius() {
        return this.gaugeOuterRadius;
    }

    public void setGaugeOuterRadius(IntegerVFPair gaugeOuterRadius) {
        this.gaugeOuterRadius = gaugeOuterRadius;
    }

    public IntegerVFPair getPivotRadius() {
        return this.pivotRadius;
    }

    public void setPivotRadius(IntegerVFPair pivotRadius) {
        this.pivotRadius = pivotRadius;
    }

    public IntegerVFPair getMajorTMNumber() {
        return this.majorTMNumber;
    }

    public void setMajorTMNumber(IntegerVFPair majorTMNumber) {
        this.majorTMNumber = majorTMNumber;
    }

    public IntegerVFPair getMinorTMNumber() {
        return this.minorTMNumber;
    }

    public void setMinorTMNumber(IntegerVFPair minorTMNumber) {
        this.minorTMNumber = minorTMNumber;
    }

    public IntegerVFPair getTrendValueDistance() {
        return this.trendValueDistance;
    }

    public void setTrendValueDistance(IntegerVFPair trendValueDistance) {
        this.trendValueDistance = trendValueDistance;
    }

    public BooleanVFPair getPlaceTicksInside() {
        return this.placeTicksInside;
    }

    public void setPlaceTicksInside(BooleanVFPair placeTicksInside) {
        this.placeTicksInside = placeTicksInside;
    }

    public BooleanVFPair getAdjustTM() {
        return this.adjustTM;
    }

    public void setAdjustTM(BooleanVFPair adjustTM) {
        this.adjustTM = adjustTM;
    }

    public BooleanVFPair getUseMarker() {
        return this.useMarker;
    }

    public void setUseMarker(BooleanVFPair useMarker) {
        this.useMarker = useMarker;
    }

    public BooleanVFPair getValueInside() {
        return this.valueInside;
    }

    public void setValueInside(BooleanVFPair valueInside) {
        this.valueInside = valueInside;
    }

    public BooleanVFPair getDashed() {
        return this.dashed;
    }

    public void setDashed(BooleanVFPair dashed) {
        this.dashed = dashed;
    }

    public String getDemoXML(List colors, HashMap numberFormats) {
        StringBuilder sb = new StringBuilder("<chart showAboutMenuItem='1' aboutMenuItemLabel='\u91cf\u8868\u5c5e\u6027\u8bbe\u7f6e' aboutMenuItemLink='n-/class/1/com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.FusionChartPropertiesResovler/chartSettings/' gaugeStartAngle='240' gaugeEndAngle='-60' executed='0' showAboutMenuItem='0' showPrintMenuItem='0' showTransionMenu='0' showChartIDMenu='0' showRefreshMenu='0' bgColor='AEC0CA,FFFFFF' ");
        double start = this.random.nextDouble() * 1000.0;
        sb.append("lowerLimit='");
        sb.append(start);
        sb.append("' upperLimit='");
        sb.append(start + (double)(1000 * colors.size()));
        sb.append('\'');
        sb.append(" majorTMNumber='10' majorTMHeight='8' showGaugeBorder='0' gaugeOuterRadius='100%' gaugeInnerRadius='70%'  displayValueDistance='30' tickMarkDecimalPrecision='1' pivotRadius='6' showPivotBorder='0' pivotBorderColor='000000' pivotBorderThickness='5' pivotFillMix='FFFFFF,000000' ");
        for (Map.Entry entry : numberFormats.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            sb.append((String)entry.getKey());
            sb.append("='");
            if (Boolean.toString(true).equals(value)) {
                value = "1";
            } else if (Boolean.toString(false).equals(value)) {
                value = "0";
            }
            sb.append(value);
            sb.append("' ");
        }
        sb.append("><colorRange>");
        for (String nextColor : colors) {
            String color = nextColor.substring(0, 6);
            String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
            sb.append("<color minValue='");
            sb.append(start);
            sb.append("' maxValue='");
            sb.append(start += 1000.0);
            sb.append("' code='");
            sb.append(color);
            sb.append("' alpha='");
            sb.append(alpha);
            sb.append("' />");
        }
        sb.append("</colorRange><dials><dial value='");
        sb.append(start / 2.3);
        sb.append("' borderAlpha='0' bgColor='000000' baseWidth='6' topWidth='1' radius='90%'/></dials><annotations></annotations></chart>");
        return sb.toString();
    }

    @Override
    protected String[] getChartCaptions(FusionChartDataNode dataNode) {
        Object obj = dataNode.getData(FusionChartDataNode.CHART_CAPTION);
        return this.parseValue2StringArray(obj);
    }

    public BooleanVFPair getShowSeparatorTick() {
        return this.showSeparatorTick;
    }

    public void setShowSeparatorTick(BooleanVFPair showSeparatorTick) {
        this.showSeparatorTick = showSeparatorTick;
    }

    public BooleanVFPair getShowGroupLabel() {
        return this.showGroupLabel;
    }

    public void setShowGroupLabel(BooleanVFPair showGroupLabel) {
        this.showGroupLabel = showGroupLabel;
    }

    public BooleanVFPair getShowGroupValue() {
        return this.showGroupValue;
    }

    public void setShowGroupValue(BooleanVFPair showGroupValue) {
        this.showGroupValue = showGroupValue;
    }

    public BooleanVFPair getShowMajorTick() {
        return this.showMajorTick;
    }

    public void setShowMajorTick(BooleanVFPair showMajorTick) {
        this.showMajorTick = showMajorTick;
    }

    public BooleanVFPair getShowMinorTick() {
        return this.showMinorTick;
    }

    public void setShowMinorTick(BooleanVFPair showMinorTick) {
        this.showMinorTick = showMinorTick;
    }

    @Override
    public IntegerVFPair getBorderAlpha() {
        return this.borderAlpha;
    }

    @Override
    public void setBorderAlpha(IntegerVFPair borderAlpha) {
        this.borderAlpha = borderAlpha;
    }

    @Override
    public void setChartBaseFontName(String chartBaseFontName) {
        this.chartBaseFontName = chartBaseFontName;
    }

    @Override
    public void setDataLabelFormat(NumberFormatVFPair dataLabelFormat) {
        this.dataLabelFormat = dataLabelFormat;
    }

    @Override
    public void setChart_showLabels(BooleanVFPair chartShowLabels) {
        this.chart_showLabels = chartShowLabels;
    }
}

