/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.pie;

import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.NumberStyleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultSingleSeriesBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;

public class Pie3DBean
extends DefaultSingleSeriesBean {
    private String showType = NumberStyleComboBoxEditor.getShowTypePercent();

    public Pie3DBean() {
        this.chartType = FlashChartType.FLASH_CT_PIE3D;
        this.chart_showValues = new BooleanVFPair(false, null);
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        String[] ret;
        block14: {
            int i;
            double sum;
            double[] values;
            block16: {
                int i2;
                block15: {
                    block13: {
                        ret = super.buildChartCaptions(dataNode);
                        if (ret != null && ret.length > 35) {
                            this.showType = ret[35];
                        }
                        double[][] data = (double[][])dataNode.getData();
                        int row = CtrlUtil.Array.getLength((Object[])data);
                        int col = 0;
                        for (int i3 = 0; i3 < row; ++i3) {
                            col = col < data[i3].length ? data[i3].length : col;
                        }
                        values = new double[row * col];
                        int index = 0;
                        sum = 0.0;
                        for (i = 0; i < row; ++i) {
                            int len = data[i].length;
                            for (int j = 0; j < len; ++j) {
                                values[index] = data[i][j];
                                sum += values[index];
                                ++index;
                            }
                        }
                        if (this.nodes == null) {
                            return ret;
                        }
                        if (!NumberStyleComboBoxEditor.getShowTypePercent().equals(this.showType)) break block13;
                        for (i = 0; i < this.nodes.length; ++i) {
                            int value;
                            Set s = (Set)this.nodes[i];
                            BigDecimal bd = BigDecimal.valueOf(values[i] * 100.0 / sum);
                            if (bd.subtract(BigDecimal.valueOf(value = bd.intValue())).abs().compareTo(BigDecimal.valueOf(0.5)) > 0) {
                                ++value;
                            }
                            s.displayValue = "1".equals(ret[16]) ? value + "%" : s.label;
                        }
                        break block14;
                    }
                    if (!NumberStyleComboBoxEditor.getShowTypeNumber().equals(this.showType)) break block15;
                    String formatXml = this.getChartNumberFormat().getXmlValue();
                    for (i2 = 0; i2 < this.nodes.length; ++i2) {
                        Set s = (Set)this.nodes[i2];
                        if (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1) {
                            Number shrinkValue = new BigDecimal(s.value);
                            shrinkValue = shrinkValue.doubleValue() / 100.0;
                            s.displayValue = "1".equals(ret[16]) ? s.label + "\uff0c" + NumberFormatTemplateEditor.applayPattern(shrinkValue.toString(), formatXml, ret[4], ret[5]) : s.label;
                            continue;
                        }
                        s.displayValue = "1".equals(ret[16]) ? s.label + "\uff0c" + NumberFormatTemplateEditor.applayPattern(s.value, formatXml, ret[4], ret[5]) : s.label;
                    }
                    break block14;
                }
                if (!NumberStyleComboBoxEditor.getShowTypeBoth().equals(this.showType)) break block16;
                String formatXml = this.getChartNumberFormat().getXmlValue();
                for (i2 = 0; i2 < this.nodes.length; ++i2) {
                    Set s = (Set)this.nodes[i2];
                    BigDecimal bg = BigDecimal.valueOf(values[i2] * 100.0 / sum);
                    bg = bg.setScale(0, RoundingMode.HALF_UP);
                    if (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1) {
                        Number shrinkValue = new BigDecimal(s.value);
                        shrinkValue = shrinkValue.doubleValue() / 100.0;
                        s.displayValue = NumberFormatTemplateEditor.applayPattern(shrinkValue.toString(), formatXml, ret[4], ret[5]) + "\uff0c" + bg + "%";
                        continue;
                    }
                    s.displayValue = NumberFormatTemplateEditor.applayPattern(s.value, formatXml, ret[4], ret[5]) + "\uff0c" + bg + "%";
                }
                break block14;
            }
            if (!NumberStyleComboBoxEditor.getShowTypeLablePercent().equals(this.showType)) break block14;
            for (i = 0; i < this.nodes.length; ++i) {
                int value;
                Set s = (Set)this.nodes[i];
                BigDecimal bd = BigDecimal.valueOf(values[i] * 100.0 / sum);
                if (bd.subtract(BigDecimal.valueOf(value = bd.intValue())).abs().compareTo(BigDecimal.valueOf(0.5)) > 0) {
                    ++value;
                }
                s.displayValue = s.label;
                if (!"1".equals(ret[16])) continue;
                s.displayValue = s.displayValue + "\uff0c" + value + "%";
            }
        }
        return ret;
    }

    public String getDemoXML(List colors, HashMap numberFormats) {
        return super.getDemoXML("Pie3D", colors, numberFormats);
    }

    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    @Override
    protected boolean isPieType() {
        return true;
    }

    @Override
    public void setChart_showValues(BooleanVFPair chartShowValues) {
        this.chart_showValues = chartShowValues;
    }

    @Override
    public void setSortType(SortEnum sortType) {
        this.sortType = sortType;
    }

    @Override
    public void setChart_showLegend(BooleanVFPair chartShowLegend) {
        this.chart_showLegend = chartShowLegend;
    }

    @Override
    public void setChart_legendPosition(String chartLegendPosition) {
        this.chart_legendPosition = chartLegendPosition;
    }

    @Override
    public void setChart_showLabels(BooleanVFPair chartShowLabels) {
        this.chart_showLabels = chartShowLabels;
    }

    @Override
    public void setChartBaseFontName(String chartBaseFontName) {
        this.chartBaseFontName = chartBaseFontName;
    }

    @Override
    public void setChart_showPlotBorder(BooleanVFPair chartShowPlotBorder) {
        this.chart_showPlotBorder = new BooleanVFPair(false, null);
    }
}

