/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.TextScaleComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;

public class FusionChartXmlBuilder {
    public static String[] RESULT = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String CHART = "chart";
    public static final String CATEGORIES = "categories";
    public static final String CONNECTORS = "connectors";
    public static final String CONNECTOR = "connector";
    public static final String DATASET = "dataset";
    public static final String DATATABLE = "datatable";
    public static final String DATACOLUMN = "datacolumn";
    public static final String TEXT = "text";
    public static final String LEGEND = "legend";
    public static final String ITEM = "item";
    public static final String LINE = "line";
    public static final String LINESET = "lineset";
    public static final String MILESTONES = "milestones";
    public static final String MILESTONE = "milestone";
    public static final String PROCESSES = "processes";
    public static final String PROCESSE = "process";
    public static final String SET = "set";
    public static final String STYLES = "styles";
    public static final String APPLICATION = "application";
    public static final String APPLY = "apply";
    public static final String DEFINITION = "definition";
    public static final String STYLE = "style";
    public static final String TASKS = "tasks";
    public static final String TASK = "task";
    public static final String TRENDLINES = "trendlines";
    public static final String VLINE = "vline";
    public static final String VTRENDLINES = "vtrendlines";
    public static final String CATEGORY = "category";
    public static final String AREA_RENDER = "Area";
    public static final String LINE_RENDER = "Line";
    public static final String COLUMN_RENDER = "Column";
    public static final String XTITLE_STAGGER = "stagger";
    public static final String XTITLE_ROTATE = "rotate";

    public static final String getAreaRenderDisplay() {
        return CtrlEXTMessages.getMLS("area", "\u9762\u79ef");
    }

    public static final String getLineRenderDisplay() {
        return CtrlEXTMessages.getMLS(LINE, "\u6298\u7ebf");
    }

    public static final String getColumnRenderDisplay() {
        return CtrlEXTMessages.getMLS("column", "\u67f1\u5f62");
    }

    public static final String getXTitleStaggerDisplay() {
        return TextScaleComboBoxEditor.getXAxsisTextStyleStagger();
    }

    public static final String getXTitleRotateDisplay() {
        return TextScaleComboBoxEditor.getXAxsisTextStyleSlant();
    }

    public static final String getYAxisNormalDisplay() {
        return CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38");
    }

    public static final String getYAxisRightDisplay() {
        return CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74");
    }

    public static String parseColorToSixteenHex(Color value) {
        StringBuilder builder = new StringBuilder();
        builder.append(FusionChartXmlBuilder.toHex(value.getRed()));
        builder.append(FusionChartXmlBuilder.toHex(value.getGreen()));
        builder.append(FusionChartXmlBuilder.toHex(value.getBlue()));
        builder.insert(0, "#");
        return builder.toString();
    }

    private static String toHex(int value) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        if (value < 17) {
            list.add(RESULT[0]);
        }
        int temp = value / 16;
        do {
            switch (value % 16) {
                case 0: {
                    list.add(RESULT[0]);
                    break;
                }
                case 1: {
                    list.add(RESULT[1]);
                    break;
                }
                case 2: {
                    list.add(RESULT[2]);
                    break;
                }
                case 3: {
                    list.add(RESULT[3]);
                    break;
                }
                case 4: {
                    list.add(RESULT[4]);
                    break;
                }
                case 5: {
                    list.add(RESULT[5]);
                    break;
                }
                case 6: {
                    list.add(RESULT[6]);
                    break;
                }
                case 7: {
                    list.add(RESULT[7]);
                    break;
                }
                case 8: {
                    list.add(RESULT[8]);
                    break;
                }
                case 9: {
                    list.add(RESULT[9]);
                    break;
                }
                case 10: {
                    list.add(RESULT[10]);
                    break;
                }
                case 11: {
                    list.add(RESULT[11]);
                    break;
                }
                case 12: {
                    list.add(RESULT[12]);
                    break;
                }
                case 13: {
                    list.add(RESULT[13]);
                    break;
                }
                case 14: {
                    list.add(RESULT[14]);
                    break;
                }
                case 15: {
                    list.add(RESULT[15]);
                }
            }
        } while ((temp = (value /= 16)) != 0);
        for (int i = list.size() - 1; i >= 0; --i) {
            builder.append(list.get(i));
        }
        return builder.toString();
    }

    public static String getChartRenderName(String chartRenderName) {
        if (FusionChartXmlBuilder.getAreaRenderDisplay().equals(chartRenderName) || AREA_RENDER.equalsIgnoreCase(chartRenderName)) {
            return AREA_RENDER;
        }
        if (FusionChartXmlBuilder.getLineRenderDisplay().equals(chartRenderName) || LINE_RENDER.equalsIgnoreCase(chartRenderName)) {
            return LINE_RENDER;
        }
        return COLUMN_RENDER;
    }

    public static String getChartXTitleScale(String scaleName) {
        if (FusionChartXmlBuilder.getXTitleStaggerDisplay().equals(scaleName)) {
            return XTITLE_STAGGER;
        }
        if (FusionChartXmlBuilder.getXTitleRotateDisplay().equals(scaleName)) {
            return XTITLE_ROTATE;
        }
        return null;
    }

    public static String getChartYAxis(String yAxisType) {
        if (FusionChartXmlBuilder.getYAxisRightDisplay().equals(yAxisType) || "right".equalsIgnoreCase(yAxisType)) {
            return "S";
        }
        return null;
    }

    public static void handleFusionChartBussinessException(Throwable bussiness, Component parent) {
        MessageUtil.msgboxWarning(null, bussiness.getMessage());
    }
}

