/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.convenientkeys;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.convenientkeys.ConvenientKeysUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConvenientKeysWizzard
extends KDDialog
implements ISpreadWizzard {
    private static final int CTRL = 0;
    private static final int ALT = 1;
    private static final int SHIFT = 2;
    private KDExt _ext;
    private SpreadContext _context;
    private InputMap inputMap;
    private ActionMap actionMap;
    private InputMap inputMap2;
    private KDPanel panel;
    private KDTable relationTable;
    private KDTable wizzardTable;
    private KDTable focusTravelTable;
    private KDLabelContainer ctrl;
    private KDLabelContainer alt;
    private KDLabelContainer shift;
    KDCheckBox ctrlCheckBox;
    KDCheckBox altCheckBox;
    KDCheckBox shiftCheckBox;
    private KDLabelContainer letterLabel;
    private KDLabelContainer controlLabel;
    private KDLabelContainer arrowLabel;
    private KDLabelContainer numberLabel;
    KDComboBox keyComboLetter;
    KDComboBox keyComboControl;
    KDComboBox keyComboArrow;
    KDComboBox keyComboNumber;
    private KDButton confirm;
    private KeyboardFocusManager keyM;
    HashMap keyMap;
    private KDTabbedPane tabbedPane;

    public ConvenientKeysWizzard(KDExt ext) {
        super((Frame)((Object)ext));
        this._ext = ext;
        this.setModal(true);
        this.setSize(340, 360);
        this.setLocationRelativeTo((Component)((Object)ext));
        this.setTitle(CtrlEXTMessages.getMLS("customShortcutKeys", "\u81ea\u5b9a\u4e49\u5feb\u6377\u952e"));
        this._context = MiscUtil.getActiveSpreadContext(this._ext);
        this.initTable();
        this.initComponents();
        this.initTabbedPane();
        this.initPanel();
        this.initAllDefinedControlKeys();
        this.initListeners();
        ConvenientKeysUtil.wizzard = this;
    }

    private void initTable() {
        this.relationTable = new KDTable(2, 1, 0);
        IRow row = this.relationTable.getHeadRow(0);
        ICell cell = row.getCell(0);
        cell.setValue((Object)CtrlEXTMessages.getMLS("functionName", "\u529f\u80fd\u540d\u79f0"));
        cell = row.getCell(1);
        cell.setValue((Object)CtrlEXTMessages.getMLS("shortcutKeyCombination", "\u5feb\u6377\u952e\u7ec4\u5408"));
        this.relationTable.getSelectManager().setSelectMode(2);
        this.relationTable.getStyleAttributes().setLocked(true);
        ConvenientKeysUtil.initTable(this._context, this.relationTable, 0);
        this.wizzardTable = new KDTable(2, 1, 0);
        row = this.wizzardTable.getHeadRow(0);
        cell = row.getCell(0);
        cell.setValue((Object)CtrlEXTMessages.getMLS("functionName", "\u529f\u80fd\u540d\u79f0"));
        cell = row.getCell(1);
        cell.setValue((Object)CtrlEXTMessages.getMLS("shortcutKeyCombination", "\u5feb\u6377\u952e\u7ec4\u5408"));
        this.wizzardTable.getSelectManager().setSelectMode(2);
        this.wizzardTable.getStyleAttributes().setLocked(true);
        ConvenientKeysUtil.initTable(this._context, this.wizzardTable, 1);
        this.focusTravelTable = new KDTable(2, 1, 0);
        row = this.focusTravelTable.getHeadRow(0);
        cell = row.getCell(0);
        cell.setValue((Object)CtrlEXTMessages.getMLS("functionName", "\u529f\u80fd\u540d\u79f0"));
        cell = row.getCell(1);
        cell.setValue((Object)CtrlEXTMessages.getMLS("shortcutKeyCombination", "\u5feb\u6377\u952e\u7ec4\u5408"));
        this.focusTravelTable.getSelectManager().setSelectMode(2);
        this.focusTravelTable.getStyleAttributes().setLocked(true);
        ConvenientKeysUtil.initTable(this._context, this.focusTravelTable, 2);
    }

    private void initTabbedPane() {
        this.tabbedPane = new KDTabbedPane(1);
        this.tabbedPane.setForcedHide(false);
        this.relationTable.setAutoResize(true);
        this.wizzardTable.setAutoResize(true);
        this.focusTravelTable.setAutoResize(true);
        this.tabbedPane.addTab(CtrlEXTMessages.getMLS("styleClass", "\u98ce\u683c\u7c7b"), null, (Component)this.relationTable, true);
        this.tabbedPane.addTab(CtrlEXTMessages.getMLS("wizardClass", "\u5411\u5bfc\u7c7b"), null, (Component)this.wizzardTable, true);
        this.tabbedPane.addTab(CtrlEXTMessages.getMLS("browseClass", "\u6d4f\u89c8\u7c7b"), null, (Component)this.focusTravelTable, true);
    }

    private void initPanel() {
        this.panel = new KDPanel();
        this.panel.setLayout(null);
        this.panel.add((Component)this.tabbedPane);
        this.tabbedPane.setBounds(20, 10, 300, 140);
        this.ctrl.setBounds(20, 160, 80, 20);
        this.alt.setBounds(100, 160, 80, 20);
        this.shift.setBounds(200, 160, 100, 20);
        this.letterLabel.setBounds(20, 200, 120, 20);
        this.controlLabel.setBounds(160, 200, 120, 20);
        this.arrowLabel.setBounds(20, 240, 120, 20);
        this.numberLabel.setBounds(160, 240, 120, 20);
        this.confirm.setBounds(100, 300, 100, 20);
        this.panel.add((Component)this.ctrl);
        this.panel.add((Component)this.alt);
        this.panel.add((Component)this.shift);
        this.panel.add((Component)this.letterLabel);
        this.panel.add((Component)this.controlLabel);
        this.panel.add((Component)this.arrowLabel);
        this.panel.add((Component)this.numberLabel);
        this.panel.add((Component)this.confirm);
        this.getContentPane().add((Component)this.panel);
    }

    private void initComponents() {
        String temp;
        int i;
        this.ctrl = new KDLabelContainer("Ctrl");
        this.alt = new KDLabelContainer("Alt");
        this.shift = new KDLabelContainer("Shift");
        this.letterLabel = new KDLabelContainer(CtrlEXTMessages.getMLS("letterKey", "\u5b57\u6bcd\u952e"));
        this.controlLabel = new KDLabelContainer(CtrlEXTMessages.getMLS("controlKey", "\u63a7\u5236\u952e"));
        this.arrowLabel = new KDLabelContainer(CtrlEXTMessages.getMLS("directionKey", "\u65b9\u5411\u952e"));
        this.numberLabel = new KDLabelContainer(CtrlEXTMessages.getMLS("numberKey", "\u6570\u5b57\u952e"));
        this.ctrlCheckBox = new KDCheckBox();
        this.altCheckBox = new KDCheckBox();
        this.shiftCheckBox = new KDCheckBox();
        this.keyComboLetter = new KDComboBox();
        this.keyComboControl = new KDComboBox();
        this.keyComboArrow = new KDComboBox();
        this.keyComboNumber = new KDComboBox();
        this.confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this.keyMap = new HashMap();
        this.keyComboLetter.addItem((Object)String.valueOf(""));
        this.keyComboControl.addItem((Object)String.valueOf(""));
        this.keyComboArrow.addItem((Object)String.valueOf(""));
        this.keyComboNumber.addItem((Object)String.valueOf(""));
        for (i = 0; i < 26; ++i) {
            temp = KeyEvent.getKeyText(65 + i);
            this.keyComboLetter.addItem((Object)temp);
            this.keyMap.put(temp, 65 + i);
        }
        for (i = 1; i <= 12; ++i) {
            temp = KeyEvent.getKeyText(112 + i - 1);
            this.keyComboControl.addItem((Object)temp);
            this.keyMap.put(temp, 112 + i - 1);
        }
        temp = KeyEvent.getKeyText(36);
        this.keyComboControl.addItem((Object)temp);
        this.keyMap.put(temp, 36);
        temp = KeyEvent.getKeyText(35);
        this.keyComboControl.addItem((Object)temp);
        this.keyMap.put(temp, 35);
        temp = KeyEvent.getKeyText(33);
        this.keyComboControl.addItem((Object)temp);
        this.keyMap.put(temp, 33);
        temp = KeyEvent.getKeyText(34);
        this.keyComboControl.addItem((Object)temp);
        this.keyMap.put(temp, 34);
        for (i = 0; i < 10; ++i) {
            temp = KeyEvent.getKeyText(48 + i);
            this.keyComboNumber.addItem((Object)temp);
            this.keyMap.put(temp, 48 + i);
        }
        temp = CtrlEXTMessages.getMLS("up", "\u4e0a");
        this.keyComboArrow.addItem((Object)temp);
        this.keyMap.put(temp, 38);
        temp = CtrlEXTMessages.getMLS("down", "\u4e0b");
        this.keyComboArrow.addItem((Object)temp);
        this.keyMap.put(temp, 40);
        temp = CtrlEXTMessages.getMLS("left", "\u5de6");
        this.keyComboArrow.addItem((Object)temp);
        this.keyMap.put(temp, 37);
        temp = CtrlEXTMessages.getMLS("right", "\u53f3");
        this.keyComboArrow.addItem((Object)temp);
        this.keyMap.put(temp, 39);
        this.ctrl.setBoundEditor((JComponent)this.ctrlCheckBox);
        this.alt.setBoundEditor((JComponent)this.altCheckBox);
        this.shift.setBoundEditor((JComponent)this.shiftCheckBox);
        this.letterLabel.setBoundEditor((JComponent)this.keyComboLetter);
        this.controlLabel.setBoundEditor((JComponent)this.keyComboControl);
        this.arrowLabel.setBoundEditor((JComponent)this.keyComboArrow);
        this.numberLabel.setBoundEditor((JComponent)this.keyComboNumber);
    }

    private void initListeners() {
        this.ctrlCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvenientKeysWizzard.this.updateTable(ConvenientKeysWizzard.this.ctrlCheckBox.isSelected(), 0, ConvenientKeysWizzard.this.tabbedPane.getSelectedIndex());
            }
        });
        this.altCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvenientKeysWizzard.this.updateTable(ConvenientKeysWizzard.this.altCheckBox.isSelected(), 1, ConvenientKeysWizzard.this.tabbedPane.getSelectedIndex());
            }
        });
        this.shiftCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvenientKeysWizzard.this.updateTable(ConvenientKeysWizzard.this.shiftCheckBox.isSelected(), 2, ConvenientKeysWizzard.this.tabbedPane.getSelectedIndex());
            }
        });
        this.addComboListener(this.keyComboLetter, 0);
        this.addComboListener(this.keyComboControl, 1);
        this.addComboListener(this.keyComboArrow, 2);
        this.addComboListener(this.keyComboNumber, 3);
        this.addTableListener(this.relationTable);
        this.addTableListener(this.wizzardTable);
        this.addTableListener(this.focusTravelTable);
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvenientKeysWizzard.this.updateItems(ConvenientKeysWizzard.this.relationTable);
                ConvenientKeysWizzard.this.updateItems(ConvenientKeysWizzard.this.wizzardTable);
                ConvenientKeysWizzard.this.updateItems(ConvenientKeysWizzard.this.focusTravelTable);
                ConvenientKeysWizzard.this.dispose();
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDTable table = null;
                table = ConvenientKeysWizzard.this.tabbedPane.getSelectedIndex() == 0 ? ConvenientKeysWizzard.this.relationTable : (ConvenientKeysWizzard.this.tabbedPane.getSelectedIndex() == 1 ? ConvenientKeysWizzard.this.wizzardTable : ConvenientKeysWizzard.this.focusTravelTable);
                if (KDTableUtil.getSelectedRow((KDTable)table) == null) {
                    ConvenientKeysWizzard.this.setAllControlButtonState(false);
                } else {
                    ConvenientKeysWizzard.this.setAllControlButtonState(true);
                }
                ConvenientKeysWizzard.this.resetAllByTableSelect(table);
            }
        });
    }

    private void addTableListener(final KDTable otable) {
        otable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){
            KDTable refer;
            {
                this.refer = otable;
            }

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock prev = e.getPrevSelectBlock();
                if (prev == null) {
                    return;
                }
                int top = prev.getTop();
                ICell prevCell = this.refer.getCell(top, 1);
                CellContent content = (CellContent)prevCell.getUserObject();
                if (StringUtil.isEmptyString((String)content.key)) {
                    content.isAlt = false;
                    content.isCtrl = false;
                    content.isShift = false;
                    prevCell.setValue((Object)"");
                }
                top = e.getSelectBlock().getTop();
                ICell cell = ConvenientKeysWizzard.this.relationTable.getCell(top, 1);
                content = (CellContent)cell.getUserObject();
                ConvenientKeysWizzard.this.ctrlCheckBox.setSelected(content.isCtrl);
                ConvenientKeysWizzard.this.altCheckBox.setSelected(content.isAlt);
                ConvenientKeysWizzard.this.shiftCheckBox.setSelected(content.isShift);
                if (content.index == 0) {
                    ConvenientKeysWizzard.this.keyComboLetter.setSelectedItem((Object)content.key);
                } else if (content.index == 1) {
                    ConvenientKeysWizzard.this.keyComboControl.setSelectedItem((Object)content.key);
                } else if (content.index == 2) {
                    ConvenientKeysWizzard.this.keyComboArrow.setSelectedItem((Object)content.key);
                } else {
                    ConvenientKeysWizzard.this.keyComboNumber.setSelectedItem((Object)content.key);
                }
            }
        });
        otable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (KDTableUtil.getSelectedRow((KDTable)otable) != null) {
                    ConvenientKeysWizzard.this.setAllControlButtonState(true);
                }
            }
        });
    }

    private void addComboListener(final KDComboBox combo, final int oindex) {
        combo.addActionListener(new ActionListener(){
            Object last;
            int index;
            KDComboBox refer;
            {
                this.last = combo.getSelectedItem();
                this.index = oindex;
                this.refer = combo;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.last == this.refer.getSelectedItem()) {
                    return;
                }
                this.last = this.refer.getSelectedItem();
                ConvenientKeysWizzard.this.keyComboLetter.setSelectedIndex(0);
                ConvenientKeysWizzard.this.keyComboControl.setSelectedIndex(0);
                ConvenientKeysWizzard.this.keyComboArrow.setSelectedIndex(0);
                ConvenientKeysWizzard.this.keyComboNumber.setSelectedIndex(0);
                this.refer.setSelectedItem(this.last);
                ConvenientKeysWizzard.this.updateTable((String)this.refer.getSelectedItem(), this.index, ConvenientKeysWizzard.this.tabbedPane.getSelectedIndex());
            }
        });
    }

    private void setAllControlButtonState(boolean flag) {
        this.ctrl.setEnabled(flag);
        this.alt.setEnabled(flag);
        this.shift.setEnabled(flag);
        this.keyComboLetter.setEnabled(flag);
        this.keyComboControl.setEnabled(flag);
        this.keyComboArrow.setEnabled(flag);
        this.keyComboNumber.setEnabled(flag);
    }

    private void updateTable(boolean isSelected, int index, int tableIndex) {
        KDTable table = null;
        table = tableIndex == 0 ? this.relationTable : (tableIndex == 1 ? this.wizzardTable : this.focusTravelTable);
        IRow row = KDTableUtil.getSelectedRow((KDTable)table);
        if (row == null) {
            return;
        }
        ICell cell = row.getCell(1);
        CellContent content = (CellContent)cell.getUserObject();
        if (index == 0) {
            content.isCtrl = isSelected;
        } else if (index == 1) {
            content.isAlt = isSelected;
        } else {
            content.isShift = isSelected;
        }
        cell.setValue((Object)ConvenientKeysUtil.getFormatString(content));
    }

    private void updateTable(String appendString, int index, int tableIndex) {
        KDTable table = null;
        table = tableIndex == 0 ? this.relationTable : (tableIndex == 1 ? this.wizzardTable : this.focusTravelTable);
        IRow row = KDTableUtil.getSelectedRow((KDTable)table);
        if (row == null) {
            return;
        }
        ICell cell = row.getCell(1);
        CellContent content = (CellContent)cell.getUserObject();
        content.key = appendString;
        content.index = index;
        cell.setValue((Object)ConvenientKeysUtil.getFormatString(content));
    }

    public void updateItems(KDTable table) {
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            ICell cell = table.getCell(i, 1);
            if (StringUtil.isEmptyString((String)((String)cell.getValue()))) continue;
            CellContent content = (CellContent)cell.getUserObject();
            cell = table.getCell(i, 0);
            String actionName = (String)cell.getUserObject();
            Object keyIndex = this.keyMap.get(content.key);
            if (keyIndex == null) continue;
            KeyStroke stroke = KeyStroke.getKeyStroke((Integer)keyIndex, (content.isCtrl ? 128 : 0) | (content.isAlt ? 512 : 0) | (content.isShift ? 64 : 0), true);
            this.registerAction(stroke, actionName, this.inputMap, this.inputMap2, this.actionMap);
        }
    }

    public void updateItems(SpreadContext context) {
        KDSpread spread = context.getSpread();
        InputMap in = spread.getInputMap(2);
        InputMap inputMap2 = spread.getInputMap();
        ActionMap ac = spread.getActionMap();
        this.registerByTable(this.relationTable, in, inputMap2, ac);
        this.registerByTable(this.wizzardTable, in, inputMap2, ac);
        this.registerByTable(this.focusTravelTable, in, inputMap2, ac);
    }

    private void registerByTable(KDTable table, InputMap in, InputMap inputMap2, ActionMap ac) {
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            ICell cell = table.getCell(i, 1);
            if (StringUtil.isEmptyString((String)((String)cell.getValue()))) continue;
            CellContent content = (CellContent)cell.getUserObject();
            cell = table.getCell(i, 0);
            String actionName = (String)cell.getUserObject();
            Object keyIndex = this.keyMap.get(content.key);
            if (keyIndex == null) continue;
            KeyStroke stroke = KeyStroke.getKeyStroke((Integer)keyIndex, (content.isCtrl ? 128 : 0) | (content.isAlt ? 512 : 0) | (content.isShift ? 64 : 0), true);
            this.registerAction(stroke, actionName, in, inputMap2, ac);
        }
    }

    private void resetAllByTableSelect(KDTable table) {
        IRow row = KDTableUtil.getSelectedRow((KDTable)table);
        if (row == null) {
            this.ctrlCheckBox.setSelected(false);
            this.altCheckBox.setSelected(false);
            this.shiftCheckBox.setSelected(false);
            this.keyComboLetter.setSelectedIndex(0);
            this.keyComboControl.setSelectedIndex(0);
            this.keyComboArrow.setSelectedIndex(0);
            this.keyComboNumber.setSelectedIndex(0);
            return;
        }
        ICell cell = row.getCell(1);
        CellContent content = (CellContent)cell.getUserObject();
        this.ctrlCheckBox.setSelected(content.isCtrl);
        this.altCheckBox.setSelected(content.isAlt);
        this.shiftCheckBox.setSelected(content.isShift);
        if (content.index == 0) {
            this.keyComboLetter.setSelectedItem((Object)content.key);
        } else if (content.index == 1) {
            this.keyComboControl.setSelectedItem((Object)content.key);
        } else if (content.index == 2) {
            this.keyComboArrow.setSelectedItem((Object)content.key);
        } else {
            this.keyComboNumber.setSelectedItem((Object)content.key);
        }
    }

    private void initAllDefinedControlKeys() {
        this.keyM = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        KDSpread spread = this._context.getSpread();
        this.actionMap = spread.getActionMap();
        this.inputMap = spread.getInputMap(1);
        this.inputMap2 = spread.getInputMap();
    }

    private void registerAction(KeyStroke stroke, String keyWord, InputMap in, InputMap inputMap2, ActionMap ac) {
        in.put(stroke, keyWord);
        ac.put(keyWord, this._context.getActionManager().getAction(keyWord, true));
        if (inputMap2.get(stroke) != null) {
            inputMap2.remove(stroke);
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public void show() {
        this.setAllControlButtonState(false);
        super.show();
    }

    static class CellContent {
        boolean isCtrl;
        boolean isShift;
        boolean isAlt;
        String key;
        int index;

        CellContent() {
        }
    }
}

