/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Group;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.IExtCtrl;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.assembled.ComboColorExtCtrl;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.assembled.RangeSelectorExtCtrl;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.AbstractFunctionWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.FunctionWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.MiniFunctionWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.ExprStringMapping;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaWizardMisc {
    private static Logger logger = LogUtil.getLogger(FormulaWizardMisc.class);
    private KDExt _ext;
    private FunctionWizard wizard;

    public FormulaWizardMisc(KDExt ext) {
        this._ext = ext;
    }

    public FunctionWizard createSharedFormulaWizard() {
        if (this.wizard == null) {
            InputStream is = null;
            try {
                is = FormulaWizardMisc.createConfigStream();
                this.wizard = new FunctionWizard(is);
                SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
                this.wizard.getEditor().setExprCreator(new ExprCreator(context));
                this.wizard.addCustomCtrl((IExtCtrl)new ComboColorExtCtrl());
                this.wizard.addCustomCtrl((IExtCtrl)new RangeSelectorExtCtrl(context));
                this.getDsGroup().setTitle(CtrlEXTMessages.getMLS("dataset", "\u6570\u636e\u96c6"));
            }
            catch (Throwable throwable) {
                CloseUtil.close(is);
                throw throwable;
            }
            CloseUtil.close(is);
        }
        return this.wizard;
    }

    private static InputStream createConfigStream() {
        String defaultPostfix = "en";
        String localePostfix = Locale.getDefault().toString();
        InputStream configStream = null;
        while (configStream == null) {
            StringBuilder sb = new StringBuilder("config/FormulaWizard_");
            sb.append(localePostfix);
            sb.append(".xml");
            configStream = FormulaWizardMisc.class.getResourceAsStream(sb.toString());
            if (configStream != null) continue;
            if (defaultPostfix.equals(localePostfix)) {
                throw new RuntimeException("FormulaWizard config file not found. " + Locale.getDefault());
            }
            int sepeartorIndex = localePostfix.lastIndexOf(95);
            if (sepeartorIndex < 0) {
                localePostfix = defaultPostfix;
                continue;
            }
            localePostfix = localePostfix.substring(0, sepeartorIndex);
        }
        return configStream;
    }

    public void updateDs(KDExt ext) {
        SpreadContext context = MiscUtil.getActiveSpreadContext(ext);
        DefaultKingdeeTreeNode root = this.getDsGroup().getRoot();
        this.getDsGroup().removeAllChildren(root);
        ExtDataSetManager dsm = context.getBook().getDataSetManager();
        int size = dsm.size();
        for (int i = 0; i < size; ++i) {
            ExtDataSet ds = dsm.getAt(i);
            if (ds instanceof ExtDynamicDataSet) continue;
            DefaultKingdeeTreeNode dsNode = this.getDsGroup().addNode(root, ds.getAlias());
            Object[] cols = MiscUtil.sortColumnsByIndex(ds.getColumns());
            for (int j = 0; j < cols.length; ++j) {
                ExtColumn col = (ExtColumn)cols[j];
                String colName = col.getAlias();
                this.getDsGroup().addNode(dsNode, colName, new Formula(colName));
            }
        }
        FormulaWizardMisc.initParamTree(this, ext);
        this.getDsGroup().expandRoot();
    }

    public static boolean keepDialogSize(FunctionWizard wizard, KDDialog newDlg) {
        KDDialog lastDlg = (KDDialog)wizard.getCustomProperty("lastDialog");
        wizard.putCustomProperty("lastDialog", newDlg);
        if (lastDlg == null) {
            newDlg.setSize(800, 600);
            newDlg.setLocationRelativeTo(null);
            return false;
        }
        newDlg.setLocation(lastDlg.getX(), lastDlg.getY());
        newDlg.setSize(lastDlg.getWidth(), lastDlg.getHeight());
        return true;
    }

    private Group getDsGroup() {
        return this.wizard.getDsSupplyGroup();
    }

    private static void initParamTree(FormulaWizardMisc misc, KDExt ext) {
        Group group = misc.getDsGroup();
        FormulaWizardMisc.initParamTree(group, ext.getExtCallback().fetchSystemParameters());
        List<IParameter>[] macros = ext.getExtCallback().fetchSystemMacros();
        if (macros == null) {
            return;
        }
        DefaultKingdeeTreeNode macroRootNode = group.addNode(group.getRoot(), CtrlEXTMessages.getMLS("macroVariable", "\u5b8f\u53d8\u91cf"), null);
        String[] vTypes = new String[]{CtrlEXTMessages.getMLS("singleValueMacro", "\u5355\u503c\u5b8f"), CtrlEXTMessages.getMLS("multipleValueMacro", "\u591a\u503c\u5b8f")};
        for (int i = 0; i < 2; ++i) {
            List<IParameter> list = macros[i];
            if (list.isEmpty()) continue;
            DefaultKingdeeTreeNode root = group.addNode(macroRootNode, vTypes[i % 2], null);
            for (IParameter p : list) {
                String temp = p.getAlias();
                if (temp == null) {
                    temp = p.toString();
                }
                group.addNode(root, temp, new Formula("$" + p.getName()));
            }
        }
    }

    private static void initParamTree(Group group, Map params) {
        DefaultKingdeeTreeNode root = group.getRoot();
        if (params != null) {
            DefaultKingdeeTreeNode dsNode = group.addNode(root, CtrlEXTMessages.getMLS("sysVariable", "\u7cfb\u7edf\u53d8\u91cf"), null);
            for (Map.Entry entry : params.entrySet()) {
                ParameterImpl impl = (ParameterImpl)entry.getValue();
                String temp = null;
                temp = impl.getAlias();
                if (temp == null) {
                    temp = entry.getKey().toString();
                }
                temp = temp + "(" + impl.getName() + ")";
                group.addNode(dsNode, temp, new Formula("@" + impl.getName()));
            }
        }
    }

    public void markEditing(boolean isEditing) {
        this.wizard.putCustomProperty("editing", isEditing);
    }

    public boolean isEditing() {
        if (this.wizard == null) {
            return false;
        }
        Boolean v = (Boolean)this.wizard.getCustomProperty("editing");
        return v == null ? false : v;
    }

    public static MiniFunctionWizard createSharedMiniFormulaWizard(String[] supportedFuncNames) {
        AbstractFunctionWizard.AbstractExprCreator ec = new AbstractFunctionWizard.AbstractExprCreator(){
            private Sheet sheet = new Sheet(Book.Manager.getNewBook(), "MiniFunctionWizard");

            @Override
            protected Sheet getSheet() {
                return this.sheet;
            }
        };
        return FormulaWizardMisc.configMiniFunctionWizard(ec, supportedFuncNames, false, null);
    }

    public static MiniFunctionWizard createSharedCellUnSupportedMiniFormulaWizard(String[] supportedFuncNames, Map sysParams) {
        AbstractFunctionWizard.AbstractExprCreator ec = new AbstractFunctionWizard.AbstractExprCreator(){
            private SyntaxErrorException unSupportedNodeType = new SyntaxErrorException(-1L, CtrlEXTMessages.getMLS("unsupportedOperationType", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b"));
            private Sheet sheet = new Sheet(Book.Manager.getNewBook(), "CellUnSupportedMiniFormulaWizard");
            private boolean isExprOk = true;
            private int pos;

            @Override
            protected Sheet getSheet() {
                return this.sheet;
            }

            @Override
            public Expr toExpr(String strFormula) {
                this.isExprOk = true;
                Expr expr = super.toExpr(strFormula);
                if (expr != null && expr.hasCellBlock()) {
                    this.isExprOk = false;
                    IExprNode[] nodes = expr.getAllNodes();
                    for (int i = 0; i < nodes.length; ++i) {
                        int exprType = nodes[i].getExprType();
                        if (exprType != 4) continue;
                        this.pos = i;
                        break;
                    }
                    return null;
                }
                return expr;
            }

            @Override
            public SyntaxErrorException getSyntaxError() {
                if (!this.isExprOk) {
                    return this.unSupportedNodeType;
                }
                return super.getSyntaxError();
            }

            @Override
            public int getSyntaxErrorPos() {
                if (!this.isExprOk) {
                    return this.pos;
                }
                return super.getSyntaxErrorPos();
            }
        };
        MiniFunctionWizard w = FormulaWizardMisc.configMiniFunctionWizard(ec, supportedFuncNames, true, CtrlEXTMessages.getMLS("builtInParameters", "\u5185\u7f6e\u53c2\u6570"));
        FormulaWizardMisc.initParamTree(w.getDsSupplyGroup(), sysParams);
        w.getDsSupplyGroup().expandRoot();
        return w;
    }

    private static MiniFunctionWizard configMiniFunctionWizard(ExprStringMapping.IExprCreator ec, String[] supportedFuncNames, boolean withDSSupply, String dsSupplyTitle) {
        MiniFunctionWizard mini = new MiniFunctionWizard();
        mini.getEditor().setExprCreator(ec);
        mini.setSupportedFunction(supportedFuncNames);
        if (withDSSupply && dsSupplyTitle != null) {
            mini.setDsSupplyTitle(dsSupplyTitle);
        }
        try (InputStream is = FormulaWizardMisc.createConfigStream();){
            mini.setConfig(is, withDSSupply);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return mini;
    }

    private static class ExprCreator
    extends AbstractFunctionWizard.AbstractExprCreator {
        private SpreadContext _context;

        public ExprCreator(SpreadContext ctx) {
            this._context = ctx;
        }

        @Override
        protected Sheet getSheet() {
            return this._context.getBook().getActiveSheet();
        }
    }
}

