/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel;

import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.FuncParamsBizModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.IParamBizModel;
import java.util.Map;

public abstract class AbstractParamBizModel
implements IParamBizModel {
    public static final Object KEY_ISARRAY = "isArray";
    public static final int MatchArray_Ignore = 0;
    public static final int MatchArray_True = 1;
    public static final int MatchArray_False = -1;
    public static final int DT_NUMBER = 1;
    public static final int DT_STRING = 2;
    public static final int DT_BOOLEAN = 4;
    public static final int DT_DATE = 8;
    public static final int DT_ARRAY = 16;
    public static final int DT_DSNAME = 32;
    public static final int DT_DS = 64;
    public static final int DT_FIELDNAME = 128;
    public static final int DT_CELLBLOCK = 256;
    public static final int DT_OBJECT = 512;
    private int _dataType;
    private String _name;
    private String _desc;
    private boolean _isOption;
    protected int _matchArray = 0;
    private FuncParamsBizModel _subModelSet;

    void setMatchArray(int state) {
        this._matchArray = state;
    }

    protected int getBizIdx(int paramIdx) {
        return -1;
    }

    public void setDescription(String desc) {
        this._desc = desc;
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    public void setDataType(int dataType) {
        this._dataType = dataType;
    }

    @Override
    public int getDataType() {
        return this._dataType;
    }

    public void setNameWithoutPostfix(String name) {
        this._name = name;
    }

    @Override
    public String getName(int paramIdx) {
        int bizIdx = this.getBizIdx(paramIdx);
        if (bizIdx > 0) {
            return this._name + bizIdx;
        }
        return this._name;
    }

    FuncParamsBizModel createSubModelSet() {
        if (this._subModelSet == null) {
            this._subModelSet = new FuncParamsBizModel();
        }
        return this._subModelSet;
    }

    @Override
    public FuncParamsBizModel getSubModelSet() {
        return this._subModelSet;
    }

    public void setOption(boolean isOption) {
        this._isOption = isOption;
    }

    @Override
    public boolean isOption() {
        return this._isOption;
    }

    public static String encodeDataType(int dataType) {
        int len;
        StringBuilder sb = new StringBuilder();
        if ((1 & dataType) == 1) {
            sb.append("|num");
        }
        if ((2 & dataType) == 2) {
            sb.append("|str");
        }
        if ((4 & dataType) == 4) {
            sb.append("|bol");
        }
        if ((8 & dataType) == 8) {
            sb.append("|dte");
        }
        if ((0x10 & dataType) == 16) {
            sb.append("|ary");
        }
        if ((0x20 & dataType) == 32) {
            sb.append("|dsname");
        }
        if ((0x40 & dataType) == 64) {
            sb.append("|ds");
        }
        if ((0x80 & dataType) == 128) {
            sb.append("|field");
        }
        if ((0x100 & dataType) == 256) {
            sb.append("|cell");
        }
        if ((0x200 & dataType) == 512) {
            sb.append("|obj");
        }
        if ((len = sb.length()) > 0) {
            return sb.substring(1, len);
        }
        return null;
    }

    public static int decodeDataType(String str) {
        int dataType = 0;
        if (str == null) {
            return dataType;
        }
        String[] vs = str.indexOf(124) == -1 ? new String[]{str} : str.split("\\|");
        int c = vs.length;
        for (int i = 0; i < c; ++i) {
            if ("num".equals(vs[i])) {
                dataType |= 1;
                continue;
            }
            if ("str".equals(vs[i])) {
                dataType |= 2;
                continue;
            }
            if ("bol".equals(vs[i])) {
                dataType |= 4;
                continue;
            }
            if ("dte".equals(vs[i])) {
                dataType |= 8;
                continue;
            }
            if ("ary".equals(vs[i])) {
                dataType |= 0x10;
                continue;
            }
            if ("dsname".equals(vs[i])) {
                dataType |= 0x20;
                continue;
            }
            if ("ds".equals(vs[i])) {
                dataType |= 0x40;
                continue;
            }
            if ("field".equals(vs[i])) {
                dataType |= 0x80;
                continue;
            }
            if ("cell".equals(vs[i])) {
                dataType |= 0x100;
                continue;
            }
            if (!"obj".equals(vs[i])) continue;
            dataType |= 0x200;
        }
        return dataType;
    }

    public static class AtGroup
    extends AbstractParamBizModel {
        private int _moreThanIdx;
        private int _countAtGroup;
        private int _idxAtGroup;

        public AtGroup(int moreThanIdx, int countAtGroup, int idxAtGroup) {
            this._moreThanIdx = moreThanIdx;
            this._countAtGroup = countAtGroup;
            this._idxAtGroup = idxAtGroup;
        }

        @Override
        public boolean isMatching(int paramsCount, int paramIdx, Map more) {
            int v = paramIdx - this._moreThanIdx - 1;
            boolean isGroupFull = (v / this._countAtGroup + 1) * this._countAtGroup < paramsCount - this._moreThanIdx;
            return isGroupFull && v >= 0 && v % this._countAtGroup == this._idxAtGroup;
        }

        @Override
        protected int getBizIdx(int paramIdx) {
            int v = paramIdx - this._moreThanIdx - 1;
            return v / this._countAtGroup + 1;
        }
    }

    public static class OddLast
    extends AbstractParamBizModel {
        @Override
        public boolean isMatching(int paramsCount, int paramIdx, Map more) {
            return paramIdx == paramsCount - 1 && paramsCount % 2 == 1;
        }
    }

    public static class Any
    extends AbstractParamBizModel {
        @Override
        public boolean isMatching(int paramsCount, int paramIdx, Map more) {
            return true;
        }

        @Override
        protected int getBizIdx(int paramIdx) {
            return paramIdx + 1;
        }
    }

    public static class Appoint
    extends AbstractParamBizModel {
        private int _idx;
        private int _count = -1;

        public Appoint(int idx) {
            this._idx = idx;
        }

        public Appoint(int idx, int count) {
            this(idx);
            this._count = count;
        }

        @Override
        public boolean isMatching(int paramsCount, int paramIdx, Map more) {
            boolean checkCount = true;
            if (this._count >= 0) {
                checkCount = this._count == paramsCount;
            }
            boolean checkArray = true;
            if (this._matchArray != 0) {
                Boolean v = (Boolean)more.get(KEY_ISARRAY);
                boolean isArray = v != null && v != false;
                boolean requireArray = this._matchArray == 1;
                checkArray = requireArray == isArray;
            }
            return this._idx == paramIdx && checkCount && checkArray;
        }
    }
}

