/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.ContentLayout;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableDocument;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.FuncCollapsableEditorKit;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.ICtrlDependency;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.editor.InsideCollapsedException;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.ExprStringMapping;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.navigator.INavigatorListener;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.swing.KDTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;

public class FuncCollapsableEditor
extends KDTextPane {
    private static final Logger logger = LogUtil.getPackageLogger(FuncCollapsableEditor.class);
    private INavigatorListener _navigatorListener;

    public FuncCollapsableEditor() {
        this.init();
    }

    private void init() {
        this.setEditorKit(new FuncCollapsableEditorKit());
        this.getMyDoc().setCtrlDependency(new ICtrlDependency(){

            @Override
            public void insertSubCtrl(int pos, JComponent ctrl) {
                FuncCollapsableEditor.this.setCaretPosition(pos);
                FuncCollapsableEditor.this.insertComponent(ctrl);
            }

            @Override
            public void setCaretPosition(int pos) {
                FuncCollapsableEditor.this.setCaretPosition(pos);
            }
        });
        this.manager = new UndoManager();
        this.getMyDoc().setUndoableEditListener(this.manager);
        this.setSelectedTextColor(Color.WHITE);
        this.setSelectionColor(new Color(37, 94, 162));
        try {
            this.getDropTarget().addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    int caretPosition = FuncCollapsableEditor.this.getCaretPosition();
                    FuncCollapsableEditor.this.setCaretPosition(caretPosition);
                }
            });
        }
        catch (TooManyListenersException ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    public void setExprCreator(ExprStringMapping.IExprCreator creator) {
        this.getMyDoc().setExprCreator(creator);
    }

    public void setParamWrapAsker(ContentLayout.IParamWrapAsker paramWrapAsker) {
        this.getMyDoc().setParamWrapAsker(paramWrapAsker);
    }

    public void setDocument(Document doc) {
        super.setDocument(doc);
    }

    FuncCollapsableDocument getMyDoc() {
        return (FuncCollapsableDocument)this.getDocument();
    }

    public String getText() {
        throw new RuntimeException("Please use getRealText() instead.");
    }

    public void setText(String text) {
        throw new RuntimeException("Please use setRealText(text) instead.");
    }

    public void setRealText(String text) {
        this.getMyDoc().closeUndoable();
        super.setText(text);
        this.layoutWithTab();
        this.getMyDoc().openUndoable();
    }

    public String getRealText() {
        return ((FuncCollapsableDocument)this.getDocument()).getRealText();
    }

    public String getSelectedText() {
        if (this.getMyDoc().isCopying()) {
            return this.getSelectedRealText();
        }
        return super.getSelectedText();
    }

    public String getSelectedRealText() {
        int p1;
        int p0 = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
        if (p0 != (p1 = Math.max(this.getCaret().getDot(), this.getCaret().getMark()))) {
            try {
                return this.getMyDoc().getSelectionRealText(p0, p1);
            }
            catch (BadLocationException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public void copy() {
        try {
            this.getMyDoc().openCopying();
            super.copy();
        }
        finally {
            this.getMyDoc().closeCopying();
        }
    }

    public void cut() {
        try {
            this.getMyDoc().openCopying();
            super.cut();
        }
        finally {
            this.getMyDoc().closeCopying();
        }
    }

    public void paste() {
        try {
            this.getMyDoc().openCopying();
            super.paste();
        }
        finally {
            this.getMyDoc().closeCopying();
        }
    }

    public void replaceSelection(String text) {
        Caret caret = this.getCaret();
        int p0 = Math.min(caret.getDot(), caret.getMark());
        int p1 = Math.max(caret.getDot(), caret.getMark());
        try {
            this.getMyDoc().remove(p0, p1 - p0);
        }
        catch (BadLocationException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (text != null && text.indexOf(9) != -1) {
            text = text.replaceAll("\t", ContentLayout.TabInstead);
        }
        super.replaceSelection(text);
    }

    public void layoutWithTab() {
        this.setCaretPosition(0);
        this.getMyDoc().layoutWithTab();
    }

    public void setSyntaxStatusListener(ISyntaxStatusListener l) {
        this.getMyDoc().setSyntaxStatusListener(l);
    }

    public void setNavigatorListener(INavigatorListener l) {
        this._navigatorListener = l;
    }

    void fireNavigatorUpdate(IFuncUnit func, int paramIdx) {
        if (this._navigatorListener != null) {
            this._navigatorListener.update(func, paramIdx);
        }
    }

    void fireNavigatorReset() {
        if (this._navigatorListener != null) {
            this._navigatorListener.reset();
        }
    }

    public boolean isTextPosInsideCollapsed(int textPos) {
        try {
            this.getMyDoc().changeTextPos2EditorPos(textPos);
        }
        catch (InsideCollapsedException ex) {
            return true;
        }
        return false;
    }

    public int changeTextPos2EditorPos(int textPos) {
        int pos = 0;
        boolean continueExpand = true;
        while (continueExpand) {
            continueExpand = false;
            try {
                pos = this.getMyDoc().changeTextPos2EditorPos(textPos);
            }
            catch (InsideCollapsedException ex) {
                continueExpand = true;
                this.getMyDoc().expandFuncUnit(ex.getFunc());
            }
        }
        return pos;
    }

    public int getEmptyCharCountForward(int pos) throws BadLocationException {
        return FuncCollapsableEditor.getEmptyCharCountForward(this.getMyDoc(), pos);
    }

    static int getEmptyCharCountForward(FuncCollapsableDocument doc, int pos) throws BadLocationException {
        char chr;
        int len = doc.getLength();
        int count = 0;
        while (pos < len && FuncCollapsableEditor.isEmptyChar(chr = doc.getText(pos++, 1).charAt(0))) {
            ++count;
        }
        return count;
    }

    public int getEmptyCharCountBackward(int pos) throws BadLocationException {
        return FuncCollapsableEditor.getEmptyCharCountBackward(this.getMyDoc(), pos);
    }

    static int getEmptyCharCountBackward(FuncCollapsableDocument doc, int pos) throws BadLocationException {
        char chr;
        int count = 0;
        while (pos > 0 && FuncCollapsableEditor.isEmptyChar(chr = doc.getText(--pos, 1).charAt(0))) {
            ++count;
        }
        return count;
    }

    private static boolean isEmptyChar(char chr) {
        return chr <= ' ';
    }

    public void insertComponent(Component c) {
        MutableAttributeSet inputAttributes = this.getInputAttributes();
        inputAttributes.removeAttributes(inputAttributes);
        StyleConstants.setComponent(inputAttributes, c);
        super.replaceSelection("@");
        inputAttributes.removeAttributes(inputAttributes);
    }

    public static interface ISyntaxStatusListener {
        public void syntaxChecked(boolean var1, int var2, SyntaxErrorException var3);
    }
}

